<?php

namespace Microsoft\Graph\Generated\Users\Item\ManagedDevices\Item\WindowsProtectionState\DetectedMalwareState;

use Exception;
use Http\Promise\Promise;
use Microsoft\Graph\Generated\Models\ODataErrors\ODataError;
use Microsoft\Graph\Generated\Models\WindowsDeviceMalwareState;
use Microsoft\Graph\Generated\Models\WindowsDeviceMalwareStateCollectionResponse;
use Microsoft\Graph\Generated\Users\Item\ManagedDevices\Item\WindowsProtectionState\DetectedMalwareState\Count\CountRequestBuilder;
use Microsoft\Graph\Generated\Users\Item\ManagedDevices\Item\WindowsProtectionState\DetectedMalwareState\Item\WindowsDeviceMalwareStateItemRequestBuilder;
use Microsoft\Kiota\Abstractions\BaseRequestBuilder;
use Microsoft\Kiota\Abstractions\HttpMethod;
use Microsoft\Kiota\Abstractions\RequestAdapter;
use Microsoft\Kiota\Abstractions\RequestInformation;

/**
 * Provides operations to manage the detectedMalwareState property of the microsoft.graph.windowsProtectionState entity.
*/
class DetectedMalwareStateRequestBuilder extends BaseRequestBuilder 
{
    /**
     * Provides operations to count the resources in the collection.
    */
    public function count(): CountRequestBuilder {
        return new CountRequestBuilder($this->pathParameters, $this->requestAdapter);
    }
    
    /**
     * Provides operations to manage the detectedMalwareState property of the microsoft.graph.windowsProtectionState entity.
     * @param string $windowsDeviceMalwareStateId The unique identifier of windowsDeviceMalwareState
     * @return WindowsDeviceMalwareStateItemRequestBuilder
    */
    public function byWindowsDeviceMalwareStateId(string $windowsDeviceMalwareStateId): WindowsDeviceMalwareStateItemRequestBuilder {
        $urlTplParams = $this->pathParameters;
        $urlTplParams['windowsDeviceMalwareState%2Did'] = $windowsDeviceMalwareStateId;
        return new WindowsDeviceMalwareStateItemRequestBuilder($urlTplParams, $this->requestAdapter);
    }

    /**
     * Instantiates a new DetectedMalwareStateRequestBuilder and sets the default values.
     * @param array<string, mixed>|string $pathParametersOrRawUrl Path parameters for the request or a String representing the raw URL.
     * @param RequestAdapter $requestAdapter The request adapter to use to execute the requests.
    */
    public function __construct($pathParametersOrRawUrl, RequestAdapter $requestAdapter) {
        parent::__construct($requestAdapter, [], '{+baseurl}/users/{user%2Did}/managedDevices/{managedDevice%2Did}/windowsProtectionState/detectedMalwareState{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}');
        if (is_array($pathParametersOrRawUrl)) {
            $this->pathParameters = $pathParametersOrRawUrl;
        } else {
            $this->pathParameters = ['request-raw-url' => $pathParametersOrRawUrl];
        }
    }

    /**
     * Device malware list
     * @param DetectedMalwareStateRequestBuilderGetRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return Promise<WindowsDeviceMalwareStateCollectionResponse|null>
     * @throws Exception
    */
    public function get(?DetectedMalwareStateRequestBuilderGetRequestConfiguration $requestConfiguration = null): Promise {
        $requestInfo = $this->toGetRequestInformation($requestConfiguration);
        $errorMappings = [
                'XXX' => [ODataError::class, 'createFromDiscriminatorValue'],
        ];
        return $this->requestAdapter->sendAsync($requestInfo, [WindowsDeviceMalwareStateCollectionResponse::class, 'createFromDiscriminatorValue'], $errorMappings);
    }

    /**
     * Create new navigation property to detectedMalwareState for users
     * @param WindowsDeviceMalwareState $body The request body
     * @param DetectedMalwareStateRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return Promise<WindowsDeviceMalwareState|null>
     * @throws Exception
    */
    public function post(WindowsDeviceMalwareState $body, ?DetectedMalwareStateRequestBuilderPostRequestConfiguration $requestConfiguration = null): Promise {
        $requestInfo = $this->toPostRequestInformation($body, $requestConfiguration);
        $errorMappings = [
                'XXX' => [ODataError::class, 'createFromDiscriminatorValue'],
        ];
        return $this->requestAdapter->sendAsync($requestInfo, [WindowsDeviceMalwareState::class, 'createFromDiscriminatorValue'], $errorMappings);
    }

    /**
     * Device malware list
     * @param DetectedMalwareStateRequestBuilderGetRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return RequestInformation
    */
    public function toGetRequestInformation(?DetectedMalwareStateRequestBuilderGetRequestConfiguration $requestConfiguration = null): RequestInformation {
        $requestInfo = new RequestInformation();
        $requestInfo->urlTemplate = $this->urlTemplate;
        $requestInfo->pathParameters = $this->pathParameters;
        $requestInfo->httpMethod = HttpMethod::GET;
        if ($requestConfiguration !== null) {
            $requestInfo->addHeaders($requestConfiguration->headers);
            if ($requestConfiguration->queryParameters !== null) {
                $requestInfo->setQueryParameters($requestConfiguration->queryParameters);
            }
            $requestInfo->addRequestOptions(...$requestConfiguration->options);
        }
        $requestInfo->tryAddHeader('Accept', "application/json");
        return $requestInfo;
    }

    /**
     * Create new navigation property to detectedMalwareState for users
     * @param WindowsDeviceMalwareState $body The request body
     * @param DetectedMalwareStateRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return RequestInformation
    */
    public function toPostRequestInformation(WindowsDeviceMalwareState $body, ?DetectedMalwareStateRequestBuilderPostRequestConfiguration $requestConfiguration = null): RequestInformation {
        $requestInfo = new RequestInformation();
        $requestInfo->urlTemplate = $this->urlTemplate;
        $requestInfo->pathParameters = $this->pathParameters;
        $requestInfo->httpMethod = HttpMethod::POST;
        if ($requestConfiguration !== null) {
            $requestInfo->addHeaders($requestConfiguration->headers);
            $requestInfo->addRequestOptions(...$requestConfiguration->options);
        }
        $requestInfo->tryAddHeader('Accept', "application/json");
        $requestInfo->setContentFromParsable($this->requestAdapter, "application/json", $body);
        return $requestInfo;
    }

    /**
     * Returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
     * @param string $rawUrl The raw URL to use for the request builder.
     * @return DetectedMalwareStateRequestBuilder
    */
    public function withUrl(string $rawUrl): DetectedMalwareStateRequestBuilder {
        return new DetectedMalwareStateRequestBuilder($rawUrl, $this->requestAdapter);
    }

}
