<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;

/**
 * Malware detection entity.
*/
class WindowsDeviceMalwareState extends Entity implements Parsable 
{
    /**
     * Instantiates a new WindowsDeviceMalwareState and sets the default values.
    */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return WindowsDeviceMalwareState
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): WindowsDeviceMalwareState {
        return new WindowsDeviceMalwareState();
    }

    /**
     * Gets the additionalInformationUrl property value. Information URL to learn more about the malware
     * @return string|null
    */
    public function getAdditionalInformationUrl(): ?string {
        $val = $this->getBackingStore()->get('additionalInformationUrl');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalInformationUrl'");
    }

    /**
     * Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @return WindowsMalwareCategory|null
    */
    public function getCategory(): ?WindowsMalwareCategory {
        $val = $this->getBackingStore()->get('category');
        if (is_null($val) || $val instanceof WindowsMalwareCategory) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'category'");
    }

    /**
     * Gets the detectionCount property value. Number of times the malware is detected
     * @return int|null
    */
    public function getDetectionCount(): ?int {
        $val = $this->getBackingStore()->get('detectionCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'detectionCount'");
    }

    /**
     * Gets the displayName property value. Malware name
     * @return string|null
    */
    public function getDisplayName(): ?string {
        $val = $this->getBackingStore()->get('displayName');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'displayName'");
    }

    /**
     * Gets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @return WindowsMalwareExecutionState|null
    */
    public function getExecutionState(): ?WindowsMalwareExecutionState {
        $val = $this->getBackingStore()->get('executionState');
        if (is_null($val) || $val instanceof WindowsMalwareExecutionState) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'executionState'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'additionalInformationUrl' => fn(ParseNode $n) => $o->setAdditionalInformationUrl($n->getStringValue()),
            'category' => fn(ParseNode $n) => $o->setCategory($n->getEnumValue(WindowsMalwareCategory::class)),
            'detectionCount' => fn(ParseNode $n) => $o->setDetectionCount($n->getIntegerValue()),
            'displayName' => fn(ParseNode $n) => $o->setDisplayName($n->getStringValue()),
            'executionState' => fn(ParseNode $n) => $o->setExecutionState($n->getEnumValue(WindowsMalwareExecutionState::class)),
            'initialDetectionDateTime' => fn(ParseNode $n) => $o->setInitialDetectionDateTime($n->getDateTimeValue()),
            'lastStateChangeDateTime' => fn(ParseNode $n) => $o->setLastStateChangeDateTime($n->getDateTimeValue()),
            'severity' => fn(ParseNode $n) => $o->setSeverity($n->getEnumValue(WindowsMalwareSeverity::class)),
            'state' => fn(ParseNode $n) => $o->setState($n->getEnumValue(WindowsMalwareState::class)),
            'threatState' => fn(ParseNode $n) => $o->setThreatState($n->getEnumValue(WindowsMalwareThreatState::class)),
        ]);
    }

    /**
     * Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @return DateTime|null
    */
    public function getInitialDetectionDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('initialDetectionDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'initialDetectionDateTime'");
    }

    /**
     * Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @return DateTime|null
    */
    public function getLastStateChangeDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastStateChangeDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastStateChangeDateTime'");
    }

    /**
     * Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
     * @return WindowsMalwareSeverity|null
    */
    public function getSeverity(): ?WindowsMalwareSeverity {
        $val = $this->getBackingStore()->get('severity');
        if (is_null($val) || $val instanceof WindowsMalwareSeverity) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'severity'");
    }

    /**
     * Gets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
     * @return WindowsMalwareState|null
    */
    public function getState(): ?WindowsMalwareState {
        $val = $this->getBackingStore()->get('state');
        if (is_null($val) || $val instanceof WindowsMalwareState) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'state'");
    }

    /**
     * Gets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @return WindowsMalwareThreatState|null
    */
    public function getThreatState(): ?WindowsMalwareThreatState {
        $val = $this->getBackingStore()->get('threatState');
        if (is_null($val) || $val instanceof WindowsMalwareThreatState) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'threatState'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeStringValue('additionalInformationUrl', $this->getAdditionalInformationUrl());
        $writer->writeEnumValue('category', $this->getCategory());
        $writer->writeIntegerValue('detectionCount', $this->getDetectionCount());
        $writer->writeStringValue('displayName', $this->getDisplayName());
        $writer->writeEnumValue('executionState', $this->getExecutionState());
        $writer->writeDateTimeValue('initialDetectionDateTime', $this->getInitialDetectionDateTime());
        $writer->writeDateTimeValue('lastStateChangeDateTime', $this->getLastStateChangeDateTime());
        $writer->writeEnumValue('severity', $this->getSeverity());
        $writer->writeEnumValue('state', $this->getState());
        $writer->writeEnumValue('threatState', $this->getThreatState());
    }

    /**
     * Sets the additionalInformationUrl property value. Information URL to learn more about the malware
     * @param string|null $value Value to set for the additionalInformationUrl property.
    */
    public function setAdditionalInformationUrl(?string $value): void {
        $this->getBackingStore()->set('additionalInformationUrl', $value);
    }

    /**
     * Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @param WindowsMalwareCategory|null $value Value to set for the category property.
    */
    public function setCategory(?WindowsMalwareCategory $value): void {
        $this->getBackingStore()->set('category', $value);
    }

    /**
     * Sets the detectionCount property value. Number of times the malware is detected
     * @param int|null $value Value to set for the detectionCount property.
    */
    public function setDetectionCount(?int $value): void {
        $this->getBackingStore()->set('detectionCount', $value);
    }

    /**
     * Sets the displayName property value. Malware name
     * @param string|null $value Value to set for the displayName property.
    */
    public function setDisplayName(?string $value): void {
        $this->getBackingStore()->set('displayName', $value);
    }

    /**
     * Sets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @param WindowsMalwareExecutionState|null $value Value to set for the executionState property.
    */
    public function setExecutionState(?WindowsMalwareExecutionState $value): void {
        $this->getBackingStore()->set('executionState', $value);
    }

    /**
     * Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @param DateTime|null $value Value to set for the initialDetectionDateTime property.
    */
    public function setInitialDetectionDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('initialDetectionDateTime', $value);
    }

    /**
     * Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @param DateTime|null $value Value to set for the lastStateChangeDateTime property.
    */
    public function setLastStateChangeDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastStateChangeDateTime', $value);
    }

    /**
     * Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
     * @param WindowsMalwareSeverity|null $value Value to set for the severity property.
    */
    public function setSeverity(?WindowsMalwareSeverity $value): void {
        $this->getBackingStore()->set('severity', $value);
    }

    /**
     * Sets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
     * @param WindowsMalwareState|null $value Value to set for the state property.
    */
    public function setState(?WindowsMalwareState $value): void {
        $this->getBackingStore()->set('state', $value);
    }

    /**
     * Sets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @param WindowsMalwareThreatState|null $value Value to set for the threatState property.
    */
    public function setThreatState(?WindowsMalwareThreatState $value): void {
        $this->getBackingStore()->set('threatState', $value);
    }

}
