<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Types\TypeUtils;

class Alert extends Entity implements Parsable 
{
    /**
     * Instantiates a new Alert and sets the default values.
    */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return Alert
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): Alert {
        return new Alert();
    }

    /**
     * Gets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
     * @return string|null
    */
    public function getActivityGroupName(): ?string {
        $val = $this->getBackingStore()->get('activityGroupName');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'activityGroupName'");
    }

    /**
     * Gets the alertDetections property value. The alertDetections property
     * @return array<AlertDetection>|null
    */
    public function getAlertDetections(): ?array {
        $val = $this->getBackingStore()->get('alertDetections');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, AlertDetection::class);
            /** @var array<AlertDetection>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'alertDetections'");
    }

    /**
     * Gets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
     * @return string|null
    */
    public function getAssignedTo(): ?string {
        $val = $this->getBackingStore()->get('assignedTo');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'assignedTo'");
    }

    /**
     * Gets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
     * @return string|null
    */
    public function getAzureSubscriptionId(): ?string {
        $val = $this->getBackingStore()->get('azureSubscriptionId');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'azureSubscriptionId'");
    }

    /**
     * Gets the azureTenantId property value. Microsoft Entra tenant ID. Required.
     * @return string|null
    */
    public function getAzureTenantId(): ?string {
        $val = $this->getBackingStore()->get('azureTenantId');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'azureTenantId'");
    }

    /**
     * Gets the category property value. Category of the alert (for example, credentialTheft, ransomware).
     * @return string|null
    */
    public function getCategory(): ?string {
        $val = $this->getBackingStore()->get('category');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'category'");
    }

    /**
     * Gets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
     * @return DateTime|null
    */
    public function getClosedDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('closedDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'closedDateTime'");
    }

    /**
     * Gets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
     * @return array<CloudAppSecurityState>|null
    */
    public function getCloudAppStates(): ?array {
        $val = $this->getBackingStore()->get('cloudAppStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, CloudAppSecurityState::class);
            /** @var array<CloudAppSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'cloudAppStates'");
    }

    /**
     * Gets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
     * @return array<string>|null
    */
    public function getComments(): ?array {
        $val = $this->getBackingStore()->get('comments');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'comments'");
    }

    /**
     * Gets the confidence property value. Confidence of the detection logic (percentage between 1-100).
     * @return int|null
    */
    public function getConfidence(): ?int {
        $val = $this->getBackingStore()->get('confidence');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'confidence'");
    }

    /**
     * Gets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @return DateTime|null
    */
    public function getCreatedDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('createdDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'createdDateTime'");
    }

    /**
     * Gets the description property value. Alert description.
     * @return string|null
    */
    public function getDescription(): ?string {
        $val = $this->getBackingStore()->get('description');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'description'");
    }

    /**
     * Gets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
     * @return array<string>|null
    */
    public function getDetectionIds(): ?array {
        $val = $this->getBackingStore()->get('detectionIds');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'detectionIds'");
    }

    /**
     * Gets the eventDateTime property value. Time at which the event or events that served as the trigger to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @return DateTime|null
    */
    public function getEventDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('eventDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'eventDateTime'");
    }

    /**
     * Gets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. Supports update.
     * @return AlertFeedback|null
    */
    public function getFeedback(): ?AlertFeedback {
        $val = $this->getBackingStore()->get('feedback');
        if (is_null($val) || $val instanceof AlertFeedback) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'feedback'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'activityGroupName' => fn(ParseNode $n) => $o->setActivityGroupName($n->getStringValue()),
            'alertDetections' => fn(ParseNode $n) => $o->setAlertDetections($n->getCollectionOfObjectValues([AlertDetection::class, 'createFromDiscriminatorValue'])),
            'assignedTo' => fn(ParseNode $n) => $o->setAssignedTo($n->getStringValue()),
            'azureSubscriptionId' => fn(ParseNode $n) => $o->setAzureSubscriptionId($n->getStringValue()),
            'azureTenantId' => fn(ParseNode $n) => $o->setAzureTenantId($n->getStringValue()),
            'category' => fn(ParseNode $n) => $o->setCategory($n->getStringValue()),
            'closedDateTime' => fn(ParseNode $n) => $o->setClosedDateTime($n->getDateTimeValue()),
            'cloudAppStates' => fn(ParseNode $n) => $o->setCloudAppStates($n->getCollectionOfObjectValues([CloudAppSecurityState::class, 'createFromDiscriminatorValue'])),
            'comments' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setComments($val);
            },
            'confidence' => fn(ParseNode $n) => $o->setConfidence($n->getIntegerValue()),
            'createdDateTime' => fn(ParseNode $n) => $o->setCreatedDateTime($n->getDateTimeValue()),
            'description' => fn(ParseNode $n) => $o->setDescription($n->getStringValue()),
            'detectionIds' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setDetectionIds($val);
            },
            'eventDateTime' => fn(ParseNode $n) => $o->setEventDateTime($n->getDateTimeValue()),
            'feedback' => fn(ParseNode $n) => $o->setFeedback($n->getEnumValue(AlertFeedback::class)),
            'fileStates' => fn(ParseNode $n) => $o->setFileStates($n->getCollectionOfObjectValues([FileSecurityState::class, 'createFromDiscriminatorValue'])),
            'historyStates' => fn(ParseNode $n) => $o->setHistoryStates($n->getCollectionOfObjectValues([AlertHistoryState::class, 'createFromDiscriminatorValue'])),
            'hostStates' => fn(ParseNode $n) => $o->setHostStates($n->getCollectionOfObjectValues([HostSecurityState::class, 'createFromDiscriminatorValue'])),
            'incidentIds' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setIncidentIds($val);
            },
            'investigationSecurityStates' => fn(ParseNode $n) => $o->setInvestigationSecurityStates($n->getCollectionOfObjectValues([InvestigationSecurityState::class, 'createFromDiscriminatorValue'])),
            'lastEventDateTime' => fn(ParseNode $n) => $o->setLastEventDateTime($n->getDateTimeValue()),
            'lastModifiedDateTime' => fn(ParseNode $n) => $o->setLastModifiedDateTime($n->getDateTimeValue()),
            'malwareStates' => fn(ParseNode $n) => $o->setMalwareStates($n->getCollectionOfObjectValues([MalwareState::class, 'createFromDiscriminatorValue'])),
            'messageSecurityStates' => fn(ParseNode $n) => $o->setMessageSecurityStates($n->getCollectionOfObjectValues([MessageSecurityState::class, 'createFromDiscriminatorValue'])),
            'networkConnections' => fn(ParseNode $n) => $o->setNetworkConnections($n->getCollectionOfObjectValues([NetworkConnection::class, 'createFromDiscriminatorValue'])),
            'processes' => fn(ParseNode $n) => $o->setProcesses($n->getCollectionOfObjectValues([Process::class, 'createFromDiscriminatorValue'])),
            'recommendedActions' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setRecommendedActions($val);
            },
            'registryKeyStates' => fn(ParseNode $n) => $o->setRegistryKeyStates($n->getCollectionOfObjectValues([RegistryKeyState::class, 'createFromDiscriminatorValue'])),
            'securityResources' => fn(ParseNode $n) => $o->setSecurityResources($n->getCollectionOfObjectValues([SecurityResource::class, 'createFromDiscriminatorValue'])),
            'severity' => fn(ParseNode $n) => $o->setSeverity($n->getEnumValue(AlertSeverity::class)),
            'sourceMaterials' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setSourceMaterials($val);
            },
            'status' => fn(ParseNode $n) => $o->setStatus($n->getEnumValue(AlertStatus::class)),
            'tags' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setTags($val);
            },
            'title' => fn(ParseNode $n) => $o->setTitle($n->getStringValue()),
            'triggers' => fn(ParseNode $n) => $o->setTriggers($n->getCollectionOfObjectValues([AlertTrigger::class, 'createFromDiscriminatorValue'])),
            'uriClickSecurityStates' => fn(ParseNode $n) => $o->setUriClickSecurityStates($n->getCollectionOfObjectValues([UriClickSecurityState::class, 'createFromDiscriminatorValue'])),
            'userStates' => fn(ParseNode $n) => $o->setUserStates($n->getCollectionOfObjectValues([UserSecurityState::class, 'createFromDiscriminatorValue'])),
            'vendorInformation' => fn(ParseNode $n) => $o->setVendorInformation($n->getObjectValue([SecurityVendorInformation::class, 'createFromDiscriminatorValue'])),
            'vulnerabilityStates' => fn(ParseNode $n) => $o->setVulnerabilityStates($n->getCollectionOfObjectValues([VulnerabilityState::class, 'createFromDiscriminatorValue'])),
        ]);
    }

    /**
     * Gets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
     * @return array<FileSecurityState>|null
    */
    public function getFileStates(): ?array {
        $val = $this->getBackingStore()->get('fileStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, FileSecurityState::class);
            /** @var array<FileSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'fileStates'");
    }

    /**
     * Gets the historyStates property value. The historyStates property
     * @return array<AlertHistoryState>|null
    */
    public function getHistoryStates(): ?array {
        $val = $this->getBackingStore()->get('historyStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, AlertHistoryState::class);
            /** @var array<AlertHistoryState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'historyStates'");
    }

    /**
     * Gets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
     * @return array<HostSecurityState>|null
    */
    public function getHostStates(): ?array {
        $val = $this->getBackingStore()->get('hostStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, HostSecurityState::class);
            /** @var array<HostSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'hostStates'");
    }

    /**
     * Gets the incidentIds property value. IDs of incidents related to current alert.
     * @return array<string>|null
    */
    public function getIncidentIds(): ?array {
        $val = $this->getBackingStore()->get('incidentIds');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'incidentIds'");
    }

    /**
     * Gets the investigationSecurityStates property value. The investigationSecurityStates property
     * @return array<InvestigationSecurityState>|null
    */
    public function getInvestigationSecurityStates(): ?array {
        $val = $this->getBackingStore()->get('investigationSecurityStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, InvestigationSecurityState::class);
            /** @var array<InvestigationSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'investigationSecurityStates'");
    }

    /**
     * Gets the lastEventDateTime property value. The lastEventDateTime property
     * @return DateTime|null
    */
    public function getLastEventDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastEventDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastEventDateTime'");
    }

    /**
     * Gets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     * @return DateTime|null
    */
    public function getLastModifiedDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastModifiedDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastModifiedDateTime'");
    }

    /**
     * Gets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
     * @return array<MalwareState>|null
    */
    public function getMalwareStates(): ?array {
        $val = $this->getBackingStore()->get('malwareStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, MalwareState::class);
            /** @var array<MalwareState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareStates'");
    }

    /**
     * Gets the messageSecurityStates property value. The messageSecurityStates property
     * @return array<MessageSecurityState>|null
    */
    public function getMessageSecurityStates(): ?array {
        $val = $this->getBackingStore()->get('messageSecurityStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, MessageSecurityState::class);
            /** @var array<MessageSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'messageSecurityStates'");
    }

    /**
     * Gets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
     * @return array<NetworkConnection>|null
    */
    public function getNetworkConnections(): ?array {
        $val = $this->getBackingStore()->get('networkConnections');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, NetworkConnection::class);
            /** @var array<NetworkConnection>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'networkConnections'");
    }

    /**
     * Gets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
     * @return array<Process>|null
    */
    public function getProcesses(): ?array {
        $val = $this->getBackingStore()->get('processes');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, Process::class);
            /** @var array<Process>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'processes'");
    }

    /**
     * Gets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
     * @return array<string>|null
    */
    public function getRecommendedActions(): ?array {
        $val = $this->getBackingStore()->get('recommendedActions');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'recommendedActions'");
    }

    /**
     * Gets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
     * @return array<RegistryKeyState>|null
    */
    public function getRegistryKeyStates(): ?array {
        $val = $this->getBackingStore()->get('registryKeyStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, RegistryKeyState::class);
            /** @var array<RegistryKeyState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'registryKeyStates'");
    }

    /**
     * Gets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
     * @return array<SecurityResource>|null
    */
    public function getSecurityResources(): ?array {
        $val = $this->getBackingStore()->get('securityResources');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, SecurityResource::class);
            /** @var array<SecurityResource>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'securityResources'");
    }

    /**
     * Gets the severity property value. The severity property
     * @return AlertSeverity|null
    */
    public function getSeverity(): ?AlertSeverity {
        $val = $this->getBackingStore()->get('severity');
        if (is_null($val) || $val instanceof AlertSeverity) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'severity'");
    }

    /**
     * Gets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search.
     * @return array<string>|null
    */
    public function getSourceMaterials(): ?array {
        $val = $this->getBackingStore()->get('sourceMaterials');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'sourceMaterials'");
    }

    /**
     * Gets the status property value. The status property
     * @return AlertStatus|null
    */
    public function getStatus(): ?AlertStatus {
        $val = $this->getBackingStore()->get('status');
        if (is_null($val) || $val instanceof AlertStatus) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'status'");
    }

    /**
     * Gets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW') (supports update).
     * @return array<string>|null
    */
    public function getTags(): ?array {
        $val = $this->getBackingStore()->get('tags');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'tags'");
    }

    /**
     * Gets the title property value. Alert title. Required.
     * @return string|null
    */
    public function getTitle(): ?string {
        $val = $this->getBackingStore()->get('title');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'title'");
    }

    /**
     * Gets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
     * @return array<AlertTrigger>|null
    */
    public function getTriggers(): ?array {
        $val = $this->getBackingStore()->get('triggers');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, AlertTrigger::class);
            /** @var array<AlertTrigger>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'triggers'");
    }

    /**
     * Gets the uriClickSecurityStates property value. The uriClickSecurityStates property
     * @return array<UriClickSecurityState>|null
    */
    public function getUriClickSecurityStates(): ?array {
        $val = $this->getBackingStore()->get('uriClickSecurityStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, UriClickSecurityState::class);
            /** @var array<UriClickSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'uriClickSecurityStates'");
    }

    /**
     * Gets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
     * @return array<UserSecurityState>|null
    */
    public function getUserStates(): ?array {
        $val = $this->getBackingStore()->get('userStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, UserSecurityState::class);
            /** @var array<UserSecurityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'userStates'");
    }

    /**
     * Gets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
     * @return SecurityVendorInformation|null
    */
    public function getVendorInformation(): ?SecurityVendorInformation {
        $val = $this->getBackingStore()->get('vendorInformation');
        if (is_null($val) || $val instanceof SecurityVendorInformation) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'vendorInformation'");
    }

    /**
     * Gets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
     * @return array<VulnerabilityState>|null
    */
    public function getVulnerabilityStates(): ?array {
        $val = $this->getBackingStore()->get('vulnerabilityStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, VulnerabilityState::class);
            /** @var array<VulnerabilityState>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'vulnerabilityStates'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeStringValue('activityGroupName', $this->getActivityGroupName());
        $writer->writeCollectionOfObjectValues('alertDetections', $this->getAlertDetections());
        $writer->writeStringValue('assignedTo', $this->getAssignedTo());
        $writer->writeStringValue('azureSubscriptionId', $this->getAzureSubscriptionId());
        $writer->writeStringValue('azureTenantId', $this->getAzureTenantId());
        $writer->writeStringValue('category', $this->getCategory());
        $writer->writeDateTimeValue('closedDateTime', $this->getClosedDateTime());
        $writer->writeCollectionOfObjectValues('cloudAppStates', $this->getCloudAppStates());
        $writer->writeCollectionOfPrimitiveValues('comments', $this->getComments());
        $writer->writeIntegerValue('confidence', $this->getConfidence());
        $writer->writeDateTimeValue('createdDateTime', $this->getCreatedDateTime());
        $writer->writeStringValue('description', $this->getDescription());
        $writer->writeCollectionOfPrimitiveValues('detectionIds', $this->getDetectionIds());
        $writer->writeDateTimeValue('eventDateTime', $this->getEventDateTime());
        $writer->writeEnumValue('feedback', $this->getFeedback());
        $writer->writeCollectionOfObjectValues('fileStates', $this->getFileStates());
        $writer->writeCollectionOfObjectValues('historyStates', $this->getHistoryStates());
        $writer->writeCollectionOfObjectValues('hostStates', $this->getHostStates());
        $writer->writeCollectionOfPrimitiveValues('incidentIds', $this->getIncidentIds());
        $writer->writeCollectionOfObjectValues('investigationSecurityStates', $this->getInvestigationSecurityStates());
        $writer->writeDateTimeValue('lastEventDateTime', $this->getLastEventDateTime());
        $writer->writeDateTimeValue('lastModifiedDateTime', $this->getLastModifiedDateTime());
        $writer->writeCollectionOfObjectValues('malwareStates', $this->getMalwareStates());
        $writer->writeCollectionOfObjectValues('messageSecurityStates', $this->getMessageSecurityStates());
        $writer->writeCollectionOfObjectValues('networkConnections', $this->getNetworkConnections());
        $writer->writeCollectionOfObjectValues('processes', $this->getProcesses());
        $writer->writeCollectionOfPrimitiveValues('recommendedActions', $this->getRecommendedActions());
        $writer->writeCollectionOfObjectValues('registryKeyStates', $this->getRegistryKeyStates());
        $writer->writeCollectionOfObjectValues('securityResources', $this->getSecurityResources());
        $writer->writeEnumValue('severity', $this->getSeverity());
        $writer->writeCollectionOfPrimitiveValues('sourceMaterials', $this->getSourceMaterials());
        $writer->writeEnumValue('status', $this->getStatus());
        $writer->writeCollectionOfPrimitiveValues('tags', $this->getTags());
        $writer->writeStringValue('title', $this->getTitle());
        $writer->writeCollectionOfObjectValues('triggers', $this->getTriggers());
        $writer->writeCollectionOfObjectValues('uriClickSecurityStates', $this->getUriClickSecurityStates());
        $writer->writeCollectionOfObjectValues('userStates', $this->getUserStates());
        $writer->writeObjectValue('vendorInformation', $this->getVendorInformation());
        $writer->writeCollectionOfObjectValues('vulnerabilityStates', $this->getVulnerabilityStates());
    }

    /**
     * Sets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
     * @param string|null $value Value to set for the activityGroupName property.
    */
    public function setActivityGroupName(?string $value): void {
        $this->getBackingStore()->set('activityGroupName', $value);
    }

    /**
     * Sets the alertDetections property value. The alertDetections property
     * @param array<AlertDetection>|null $value Value to set for the alertDetections property.
    */
    public function setAlertDetections(?array $value): void {
        $this->getBackingStore()->set('alertDetections', $value);
    }

    /**
     * Sets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
     * @param string|null $value Value to set for the assignedTo property.
    */
    public function setAssignedTo(?string $value): void {
        $this->getBackingStore()->set('assignedTo', $value);
    }

    /**
     * Sets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
     * @param string|null $value Value to set for the azureSubscriptionId property.
    */
    public function setAzureSubscriptionId(?string $value): void {
        $this->getBackingStore()->set('azureSubscriptionId', $value);
    }

    /**
     * Sets the azureTenantId property value. Microsoft Entra tenant ID. Required.
     * @param string|null $value Value to set for the azureTenantId property.
    */
    public function setAzureTenantId(?string $value): void {
        $this->getBackingStore()->set('azureTenantId', $value);
    }

    /**
     * Sets the category property value. Category of the alert (for example, credentialTheft, ransomware).
     * @param string|null $value Value to set for the category property.
    */
    public function setCategory(?string $value): void {
        $this->getBackingStore()->set('category', $value);
    }

    /**
     * Sets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
     * @param DateTime|null $value Value to set for the closedDateTime property.
    */
    public function setClosedDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('closedDateTime', $value);
    }

    /**
     * Sets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
     * @param array<CloudAppSecurityState>|null $value Value to set for the cloudAppStates property.
    */
    public function setCloudAppStates(?array $value): void {
        $this->getBackingStore()->set('cloudAppStates', $value);
    }

    /**
     * Sets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
     * @param array<string>|null $value Value to set for the comments property.
    */
    public function setComments(?array $value): void {
        $this->getBackingStore()->set('comments', $value);
    }

    /**
     * Sets the confidence property value. Confidence of the detection logic (percentage between 1-100).
     * @param int|null $value Value to set for the confidence property.
    */
    public function setConfidence(?int $value): void {
        $this->getBackingStore()->set('confidence', $value);
    }

    /**
     * Sets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @param DateTime|null $value Value to set for the createdDateTime property.
    */
    public function setCreatedDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('createdDateTime', $value);
    }

    /**
     * Sets the description property value. Alert description.
     * @param string|null $value Value to set for the description property.
    */
    public function setDescription(?string $value): void {
        $this->getBackingStore()->set('description', $value);
    }

    /**
     * Sets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
     * @param array<string>|null $value Value to set for the detectionIds property.
    */
    public function setDetectionIds(?array $value): void {
        $this->getBackingStore()->set('detectionIds', $value);
    }

    /**
     * Sets the eventDateTime property value. Time at which the event or events that served as the trigger to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @param DateTime|null $value Value to set for the eventDateTime property.
    */
    public function setEventDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('eventDateTime', $value);
    }

    /**
     * Sets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. Supports update.
     * @param AlertFeedback|null $value Value to set for the feedback property.
    */
    public function setFeedback(?AlertFeedback $value): void {
        $this->getBackingStore()->set('feedback', $value);
    }

    /**
     * Sets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
     * @param array<FileSecurityState>|null $value Value to set for the fileStates property.
    */
    public function setFileStates(?array $value): void {
        $this->getBackingStore()->set('fileStates', $value);
    }

    /**
     * Sets the historyStates property value. The historyStates property
     * @param array<AlertHistoryState>|null $value Value to set for the historyStates property.
    */
    public function setHistoryStates(?array $value): void {
        $this->getBackingStore()->set('historyStates', $value);
    }

    /**
     * Sets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
     * @param array<HostSecurityState>|null $value Value to set for the hostStates property.
    */
    public function setHostStates(?array $value): void {
        $this->getBackingStore()->set('hostStates', $value);
    }

    /**
     * Sets the incidentIds property value. IDs of incidents related to current alert.
     * @param array<string>|null $value Value to set for the incidentIds property.
    */
    public function setIncidentIds(?array $value): void {
        $this->getBackingStore()->set('incidentIds', $value);
    }

    /**
     * Sets the investigationSecurityStates property value. The investigationSecurityStates property
     * @param array<InvestigationSecurityState>|null $value Value to set for the investigationSecurityStates property.
    */
    public function setInvestigationSecurityStates(?array $value): void {
        $this->getBackingStore()->set('investigationSecurityStates', $value);
    }

    /**
     * Sets the lastEventDateTime property value. The lastEventDateTime property
     * @param DateTime|null $value Value to set for the lastEventDateTime property.
    */
    public function setLastEventDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastEventDateTime', $value);
    }

    /**
     * Sets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     * @param DateTime|null $value Value to set for the lastModifiedDateTime property.
    */
    public function setLastModifiedDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastModifiedDateTime', $value);
    }

    /**
     * Sets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
     * @param array<MalwareState>|null $value Value to set for the malwareStates property.
    */
    public function setMalwareStates(?array $value): void {
        $this->getBackingStore()->set('malwareStates', $value);
    }

    /**
     * Sets the messageSecurityStates property value. The messageSecurityStates property
     * @param array<MessageSecurityState>|null $value Value to set for the messageSecurityStates property.
    */
    public function setMessageSecurityStates(?array $value): void {
        $this->getBackingStore()->set('messageSecurityStates', $value);
    }

    /**
     * Sets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
     * @param array<NetworkConnection>|null $value Value to set for the networkConnections property.
    */
    public function setNetworkConnections(?array $value): void {
        $this->getBackingStore()->set('networkConnections', $value);
    }

    /**
     * Sets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
     * @param array<Process>|null $value Value to set for the processes property.
    */
    public function setProcesses(?array $value): void {
        $this->getBackingStore()->set('processes', $value);
    }

    /**
     * Sets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
     * @param array<string>|null $value Value to set for the recommendedActions property.
    */
    public function setRecommendedActions(?array $value): void {
        $this->getBackingStore()->set('recommendedActions', $value);
    }

    /**
     * Sets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
     * @param array<RegistryKeyState>|null $value Value to set for the registryKeyStates property.
    */
    public function setRegistryKeyStates(?array $value): void {
        $this->getBackingStore()->set('registryKeyStates', $value);
    }

    /**
     * Sets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
     * @param array<SecurityResource>|null $value Value to set for the securityResources property.
    */
    public function setSecurityResources(?array $value): void {
        $this->getBackingStore()->set('securityResources', $value);
    }

    /**
     * Sets the severity property value. The severity property
     * @param AlertSeverity|null $value Value to set for the severity property.
    */
    public function setSeverity(?AlertSeverity $value): void {
        $this->getBackingStore()->set('severity', $value);
    }

    /**
     * Sets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search.
     * @param array<string>|null $value Value to set for the sourceMaterials property.
    */
    public function setSourceMaterials(?array $value): void {
        $this->getBackingStore()->set('sourceMaterials', $value);
    }

    /**
     * Sets the status property value. The status property
     * @param AlertStatus|null $value Value to set for the status property.
    */
    public function setStatus(?AlertStatus $value): void {
        $this->getBackingStore()->set('status', $value);
    }

    /**
     * Sets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW') (supports update).
     * @param array<string>|null $value Value to set for the tags property.
    */
    public function setTags(?array $value): void {
        $this->getBackingStore()->set('tags', $value);
    }

    /**
     * Sets the title property value. Alert title. Required.
     * @param string|null $value Value to set for the title property.
    */
    public function setTitle(?string $value): void {
        $this->getBackingStore()->set('title', $value);
    }

    /**
     * Sets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
     * @param array<AlertTrigger>|null $value Value to set for the triggers property.
    */
    public function setTriggers(?array $value): void {
        $this->getBackingStore()->set('triggers', $value);
    }

    /**
     * Sets the uriClickSecurityStates property value. The uriClickSecurityStates property
     * @param array<UriClickSecurityState>|null $value Value to set for the uriClickSecurityStates property.
    */
    public function setUriClickSecurityStates(?array $value): void {
        $this->getBackingStore()->set('uriClickSecurityStates', $value);
    }

    /**
     * Sets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
     * @param array<UserSecurityState>|null $value Value to set for the userStates property.
    */
    public function setUserStates(?array $value): void {
        $this->getBackingStore()->set('userStates', $value);
    }

    /**
     * Sets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
     * @param SecurityVendorInformation|null $value Value to set for the vendorInformation property.
    */
    public function setVendorInformation(?SecurityVendorInformation $value): void {
        $this->getBackingStore()->set('vendorInformation', $value);
    }

    /**
     * Sets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
     * @param array<VulnerabilityState>|null $value Value to set for the vulnerabilityStates property.
    */
    public function setVulnerabilityStates(?array $value): void {
        $this->getBackingStore()->set('vulnerabilityStates', $value);
    }

}
