<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Hesap Ayarlari',
    'active'                                          => 'Aktif',
    'activity'                                        => 'Aktiviteler',
    'activity_invoice_paid'                           => 'Fatura <a href=":link">#:number</a> Ödendi.',
    'activity_invoice_viewed'                         => 'Fatura <a href=":link">#:number</a> görüntülendi.',
    'activity_quote_approved'                         => 'Teklif <a href=":link">#:number</a> Onaylandi.',
    'activity_quote_rejected'                         => 'Teklif <a href=":link">#:number</a> Onaylanmadi.',
    'activity_quote_viewed'                           => 'Teklif <a href=":link">#:number</a> Görüntülendi.',
    'add_item'                                        => 'Ürün Ekle',
    'add_line_item_to_invoice'                        => 'Faturaya satir ögesi ekleyin',
    'add_note'                                        => 'Not Ekle',
    'additional'                                      => 'Ek Bilgi',
    'addon'                                           => 'Eklenti',
    'addons'                                          => 'Eklentiler',
    'address'                                         => 'Adres',
    'address_format'                                  => 'Adres Biçimi',
    'after_amount'                                    => 'Fiyattan sonra',
    'all'                                             => 'Hepsi',
    'all_categories'                                  => 'Tüm Kategoriler',
    'all_statuses'                                    => 'Tüm Durumlar',
    'all_time'                                        => 'Tüm Zamanlar',
    'all_vendors'                                     => 'Tüm Saticilar',
    'allow_login'                                     => 'Giris yapmaya izin ver',
    'always_attach_pdf'                               => 'Her zaman PDF ekle',
    'always_bcc'                                      => 'Herzaman BCC Adres,',
    'always_cc'                                       => 'Herzaman CC Adresi',
    'amount'                                          => 'Fiyat',
    'api_public_key'                                  => 'API Public Key',
    'api_secret_key'                                  => 'API Secret Key',
    'approve'                                         => 'Onay',
    'approved'                                        => 'Onaylandi',
    'approved_quotes'                                 => 'Onaylanmis Teklifler',
    'attach_files'                                    => 'Dosya ekle',
    'attach_pdf'                                      => 'PDF Ekle',
    'attachment'                                      => 'Ek',
    'attachments'                                     => 'Ekler',
    'author'                                          => 'Yazar',
    'automatic'                                       => 'Otomatik',
    'automatic_email_on_recur'                        => 'Tekrarlanan faturalari otomatik yolla',
    'automatic_email_payment_receipts'                => 'Ödeme makbuzlarini otomatik olarak email gönder',
    'available_fields'                                => 'Kullanilabilir alanlar',
    'back'                                            => 'Geri',
    'back_to_invoice'                                 => 'Faturaya geri dön',
    'back_to_quote'                                   => 'Teklife geri dön',
    'balance'                                         => 'Bakiye',
    'base_currency'                                   => 'Para birimi',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Tutardan önce',
    'bill_this_expense'                               => 'Bu gideri faturalandir',
    'bill_to'                                         => 'Bill To',
    'billable'                                        => 'Faturalandirilabilir',
    'billed'                                          => 'Faturalandirilan',
    'billing_address'                                 => 'Fatura Adresi',
    'billing_city'                                    => 'Fatura Sehir',
    'billing_name'                                    => 'Fatura Adi',
    'billing_state'                                   => 'Fatura Ilçe',
    'billing_zip'                                     => 'Fatura Posta Kodu',
    'binary_path'                                     => 'Binary Path',
    'body'                                            => 'Body',
    'cancel'                                          => 'Iptal',
    'canceled'                                        => 'Iptal edildi',
    'card_number'                                     => 'Kart Numarasi',
    'cash'                                            => 'Nakit',
    'category'                                        => 'Kategori',
    'cc'                                              => 'CC',
    'change'                                          => 'Degistir',
    'change_client'                                   => 'Müsteriyi Degistir',
    'check_for_update'                                => 'Updateleri kontrol et',
    'city'                                            => 'Sehir',
    'clear_keys'                                      => 'Anahtarlari Temizle',
    'client'                                          => 'Müsteri',
    'client_form'                                     => 'Müsteri Formu',
    'client_name'                                     => 'Müsteri Adi',
    'client_not_found'                                => 'Müsteri bulunamadi',
    'client_statement'                                => 'Müsteri Bilanço',
    'client_unique_name_option_1'                     => 'Sadece müsteri adi benzersiz olmadiginda',
    'client_unique_name_option_2'                     => 'Herzaman Göster',
    'client_visibility'                               => 'Müsteri Görünürlügü',
    'clients'                                         => 'Müsteriler',
    'code'                                            => 'Kod',
    'column_name'                                     => 'Kolon Adi',
    'column_width'                                    => 'Sütun genisligi',
    'company'                                         => 'Sirket',
    'complete'                                        => 'Tamamlandi',
    'complete_upgrade'                                => 'Yükseltmeyi tamamla',
    'compound'                                        => 'Bilesik',
    'compound_tax_note'                               => 'Compound tax rates must be applied to an item as tax 2 to have the desired effect.',
    'confirm_approve_quote'                           => 'Teklifi onaylamak istediginizden eminmisiniz?',
    'confirm_reject_quote'                            => 'Teklifi onaylamiyorusunuz ! onaylamamak istediginizden eminmisiniz??',
    'continue'                                        => 'Devam et',
    'convert_quote_option1'                           => 'Fatura teklifin sartlarini içermeli',
    'convert_quote_option2'                           => 'Fatura varsayilan fatura sartlarini içermeli',
    'convert_quote_setting'                           => 'Teklif faturaya çevrildiginde',
    'convert_quote_when_approved'                     => 'Müsteri onayindan sonra Teklifi otomatik Faturalandir.',
    'converted_from_quote'                            => 'Tekliften dönüstürüldü',
    'converted_to_invoice'                            => 'Faturadan dönüstürüldü',
    'country'                                         => 'Ülke',
    'create_invoice'                                  => 'Fatura düzenle',
    'create_quote'                                    => 'Teklif düzenle',
    'created'                                         => 'Düzenlendi',
    'credit_card'                                     => 'Kredi Karti',
    'currencies'                                      => 'Para Birimleri',
    'currency'                                        => 'Parabirimi',
    'currency_form'                                   => 'Parabirimi Formu',
    'currency_symbol'                                 => 'Para birimi simgesi',
    'currency_symbol_placement'                       => 'Para birimi simgesi',
    'custom_date_range'                               => 'Özel tarih araligi',
    'custom_field_form'                               => 'Gelismis ekstra alan formu',
    'custom_fields'                                   => 'Ekstra alanlar',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Yönetici Paneli',
    'dashboard_totals_option'                         => 'Totals on the Dashboard Should Include',
    'database_not_configured'                         => 'Lütfen Veritabani ayarlarinizi kontrol ediniz. app/config/database.php',
    'database_setup'                                  => 'Database ayarlari',
    'date'                                            => 'Tarih',
    'date_format'                                     => 'Tarih formati',
    'days'                                            => 'Gün',
    'decimal_point'                                   => 'Ondalik belirteci',
    'default_currency'                                => 'Standart Para birimi',
    'default_footer'                                  => 'Standart alt notu',
    'default_group'                                   => 'Standart Grup',
    'default_invoice_email_body'                      => 'Standart Fatura Email Body',
    'default_invoice_template'                        => 'Standart Fatura Sablonu',
    'default_item_tax_2_rate'                         => 'Default Item Tax 2 Rate',
    'default_item_tax_rate'                           => 'Standart ürün Kdv orani',
    'default_overdue_invoice_email_body'              => 'Standart Gecikmis Fatura Email Body',
    'default_payment_receipt_body'                    => 'Varsayilan Ödeme Makbuzu Içerigi',
    'default_quote_email_body'                        => 'Standaard Teklif Email Body',
    'default_quote_template'                          => 'Standart Telif Sablonu',
    'default_terms'                                   => 'Standart kullanici sözlesmesi',
    'delete'                                          => 'Sil',
    'delete_client_warning'                           => 'Bu kullaniciya ait tüm Fatura ve Teklifler silinecek, Devam etmek istediginizden eminmisiniz?',
    'delete_record_warning'                           => 'Veriler sinilecek, devam etmek istediginizden eminmisiniz',
    'description'                                     => 'Detay',
    'details'                                         => 'Detaylar',
    'disabled'                                        => 'Devredisi',
    'discount'                                        => 'Iskonto',
    'display_client_unique_name'                      => 'Müsteri Benzersiz Adini Göster',
    'display_do_not_require'                          => 'Görüntüle ama zorunlu kilma',
    'display_order'                                   => 'Görüntüleme Sirasi',
    'display_profile_image'                           => 'Profil fotografi göster',
    'do_not_add_line_item_to_invoice'                 => 'Faturaya satir ögesi ekleme',
    'do_not_display'                                  => 'Görüntüleme',
    'documentation'                                   => 'Dökümanlar',
    'download'                                        => 'Indir',
    'draft'                                           => 'Taslak',
    'draft_invoices'                                  => 'Taslak Faturalar',
    'draft_quotes'                                    => 'Taslak Teklifler',
    'dropdown'                                        => 'Açilir kapanir menu',
    'due'                                             => 'Borçlanildi',
    'due_date'                                        => 'Son ödeme tarihi',
    'edit'                                            => 'Düzenle',
    'edit_client'                                     => 'Müsteriyi Düzenle',
    'email'                                           => 'E-mail',
    'email_address'                                   => 'E-mail Adresi',
    'email_invoice'                                   => 'E-mail Fatura',
    'email_payment_receipt'                           => 'Ödeme Makbuzunu Email ile gönder',
    'email_quote'                                     => 'E-mail Teklif',
    'email_send_method'                               => 'E-mail Gönderi metodu',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Etkin',
    'enter_payment'                                   => 'Ödeme ekle',
    'error'                                           => 'Hata',
    'every'                                           => 'Tümü',
    'exchange_rate'                                   => 'Kur',
    'exchange_rate_mode'                              => 'Kur Modu',
    'expense_form'                                    => 'Gider Formu',
    'expenses'                                        => 'Giderler',
    'expiration'                                      => 'Son kullanma Tarihi',
    'expires'                                         => 'Gecikmis',
    'export_clients'                                  => 'Müsterileri disaaktar',
    'export_data'                                     => 'Veriyi disaaktar',
    'export_expenses'                                 => 'Ihracat Giderleri',
    'export_invoice_items'                            => 'Fatura ögelerini disaaktar',
    'export_invoices'                                 => 'Faturalari disaaktar',
    'export_payments'                                 => 'Ödemeleri disaaktar',
    'export_quote_items'                              => 'Teklif ögelerini disaaktar',
    'export_quotes'                                   => 'Teklifleri disaaktar',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Fax Numarasi',
    'field_label'                                     => 'Alan Etiketi',
    'field_meta'                                      => 'Alan Meta',
    'field_meta_description'                          => 'Meta etiketini sadece Dropdown olarak kullanin.',
    'field_type'                                      => 'Alan Tipi',
    'footer'                                          => 'Not',
    'format'                                          => 'Biçim',
    'frequency'                                       => 'Frekans',
    'from'                                            => 'Kimden',
    'from_date'                                       => 'Tarihten',
    'general'                                         => 'Genel',
    'generate_keys'                                   => 'Anahtar olustur.',
    'group'                                           => 'Grup',
    'group_form'                                      => 'Grup Formu',
    'groups'                                          => 'Gruplar',
    'header_title_text'                               => 'Baslik',
    'help'                                            => 'Yardim',
    'help_currency_code'                              => 'Para birimi, örn. "TL".',
    'help_currency_name'                              => 'Para birimi yazi ile, örn. "Türk Lirasi".',
    'help_currency_symbol'                            => 'Parabirimi sembolu, örn. "$".',
    'help_currency_symbol_placement'                  => 'Parabirimi nereye yerlestirilecek.',
    'help_text_client_name'                           => 'Bu deger faturada gözükecek bir sirket ya da kisi adi olabilir. Bu degerin benzersiz olmasi gerekmez',
    'help_text_client_password'                       => 'Sifre olusturmadiginiz/degistirmediginiz takdirde bu alani bos birakin.',
    'help_text_client_unique_name'                    => 'Bir ya da birden fazla ayni isimle müsteri oldugunda, karisiklik olmamasi için benzersiz isim tanimlanir. Bu bilgi fatura üzerinde gösterilmez.',
    'i_accept'                                        => 'Kabul Ediyorum',
    'import_data'                                     => 'Veri yükle',
    'inactive'                                        => 'Pasif',
    'income'                                          => 'Gelir',
    'install'                                         => 'Kurulum',
    'installation_complete'                           => 'Kurulum Tamamlandi',
    'installing_please_wait'                          => 'Kurulum devam ediyor, Lütfen biraz bekleyiniz....',
    'invalid_credentials'                             => 'Hatali kimlik bilgileri',
    'invoice'                                         => 'Fatura',
    'invoice_default'                                 => 'Standart Fatura',
    'invoice_email_subject'                           => 'Fatura Email Konusu',
    'invoice_items'                                   => 'Faturalandirma',
    'invoice_number'                                  => 'Fatura Numarasi',
    'invoice_summary'                                 => 'Faturalar',
    'invoiced'                                        => 'Faturalandi',
    'invoices'                                        => 'Faturalar',
    'invoices_due_after'                              => 'Faturalar .... Gün sonra gecikmis kabul edilir.',
    'issued'                                          => 'Verildi',
    'item'                                            => 'Ürün',
    'item_lookup_form'                                => 'Ürün arama formu',
    'item_lookups'                                    => 'Ürünler',
    'item_sales'                                      => 'Satilan ürünler',
    'items'                                           => 'Ögeler',
    'label_invoice'                                   => 'Bu giderin eklenecegi faturayi seçin',
    'label_item_description'                          => 'Bu gider için bir açiklama ekleyin (istege bagli)',
    'label_item_name'                                 => 'Faturaya eklenecek öge olarak isim girin',
    'landscape'                                       => 'Çevre',
    'language'                                        => 'Dil',
    'left_pad'                                        => 'Sol Bölüm',
    'left_pad_description'                            => 'The number of zeroes to optionally left pad the next number with.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Mektup',
    'license_agreement'                               => 'Lisans Sözlesmesi',
    'license_agreement_accept'                        => 'Lisans Sözlesmesini kabul ediyorum',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'It appears your secret key has been changed since the last time you saved your email password. To fix this error, go to System Settings -> Email tab, re-enter your email password and press Save. Note that no mail will be delivered until this has been done.',
    'manual'                                          => 'Manuel',
    'map_fields_to_import'                            => 'Aktarim için Alanlari birlestir',
    'merchant_api_key'                                => 'API Anahtari',
    'merchant_api_password'                           => 'API Sifre',
    'merchant_api_username'                           => 'API Kullanici Adi',
    'merchant_publishable_key'                        => 'Yayinlanabilir anahtar',
    'merchant_secret_key'                             => 'Gizli Anahtar',
    'merchant_signature'                              => 'Imza',
    'mobile'                                          => 'Mobil',
    'mobile_number'                                   => 'Mobil Numarasi',
    'monthly'                                         => 'Aylik',
    'months'                                          => 'Aylar',
    'multiple_email_validation'                       => 'Çoklu mail adresi virgülle ayrilip girilmeli',
    'name'                                            => 'Ürün Adi',
    'net_income'                                      => 'Net Gelir',
    'never'                                           => 'Hiçbirzaman',
    'new'                                             => 'Yeni',
    'next_date'                                       => 'Sonraki tarih',
    'next_number'                                     => 'Sonraki Numara',
    'no'                                              => 'Hayir',
    'no_open_invoices'                                => 'Bu müsterinin açik faturasi yok. Bir gideri faturalandirmak için müsterinin en az bir açik faturasi olmali.',
    'no_records_found'                                => 'Hiç kayit bulunamadi.',
    'none'                                            => 'Hiçbiri',
    'not_billable'                                    => 'Faturalandirilamaz',
    'not_billed'                                      => 'Faturalandirilmamis',
    'not_viewed'                                      => 'Görüntülenmedi',
    'not_visible'                                     => 'Görünmez',
    'note'                                            => 'Not',
    'note_notification'                               => 'Bildirim: Yeni Not',
    'notes'                                           => 'Notlar',
    'online_payment'                                  => 'Online Ödeme',
    'online_payment_method'                           => 'Online ödeme seçenekleri',
    'online_payments'                                 => 'Online Ödemeleri',
    'options'                                         => 'Seçenekler',
    'other'                                           => 'Diger',
    'output_type'                                     => 'Çikis Türü',
    'overdue'                                         => 'Gecikmis',
    'overdue_email_subject'                           => 'Gecikmis Ödeme Email Konusu',
    'overdue_invoice_reminder'                        => 'Gecikmis Fatura Hatirlatici',
    'overdue_invoice_reminder_frequency'              => 'Gecikmis Fatura Hatirlatma Sikligi',
    'overdue_invoice_reminder_frequency_help'         => 'Hatirlaticin gönderilecegi günler virgül ile ayrilmali. Fatura hatirlatmayi devredisi birakmak için bu alani bos birakin. Örnegin, son ödeme tarihi geçtikten 1,5,10 gün sonra hatirlatma göndermek için 1,5,10 girin.',
    'overdue_invoices'                                => 'Gecikmis Faturalar',
    'paid'                                            => 'Ödendi',
    'paper_orientation'                               => 'Kagit sekli/Yönü',
    'paper_size'                                      => 'Kagit boyutu',
    'password'                                        => 'Sifre',
    'password_confirmation'                           => 'Sifreyi onayla',
    'password_successfully_reset'                     => 'Sifre Resetlendi',
    'pay'                                             => 'Ödeme',
    'pay_now'                                         => 'Hemen öde',
    'payment_applied'                                 => 'Ödemeniz eklendi',
    'payment_button_text'                             => 'Ödeme butonu yazisi',
    'payment_date'                                    => 'Ödeme Tarihi',
    'payment_form'                                    => 'Ödeme Formu',
    'payment_method'                                  => 'Ödeme seçenekleri',
    'payment_method_form'                             => 'Ödeme seçenekleri formu',
    'payment_methods'                                 => 'Ödeme seçenekleri',
    'payment_receipt'                                 => 'Ödeme Makbuzu',
    'payment_receipt_email_subject'                   => 'Ödeme Makbuzu Email Konusu',
    'payments'                                        => 'Ödemeler',
    'payments_collected'                              => 'Alinan Ödemeler',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF Driver',
    'pdf_driver_wkhtmltopdf'                          => 'Ikili Yol alani, wkhtmltopdf PDF sürücüsünü kullanirken geçerli bir dosya yolu içermelidir.',
    'percent'                                         => 'Yüzde',
    'phone'                                           => 'Telefon',
    'phone_number'                                    => 'Telefon numarasi',
    'php_version_error'                               => 'PHP versiyonu bu sistem ile uyumlu degil (%s)',
    'placeholder_type_message'                        => 'Mesaji Girin...',
    'portrait'                                        => 'Portre',
    'postal_code'                                     => 'Posta Kodu',
    'prefix'                                          => 'Döngü',
    'prerequisites'                                   => 'Kosullar',
    'preview'                                         => 'Önizleme',
    'price'                                           => 'Fiyat',
    'private'                                         => 'Özel',
    'problem_with_email_template'                     => 'There appears to be a problem with the email template. Please check the templates in System Settings on the Email tab.',
    'product'                                         => 'Ürün',
    'profit_and_loss'                                 => 'Kar ve zarar',
    'public'                                          => 'Online Görüntüle',
    'qty'                                             => 'Adet',
    'quantity'                                        => 'Adet',
    'quantity_price_decimals'                         => 'Miktar ve Tutar için Ondalik Sayi',
    'quote'                                           => 'Teklif',
    'quote_approved'                                  => 'Teklif Onaylandi',
    'quote_approved_email_body'                       => 'Teklif Onayi Maili',
    'quote_default'                                   => 'Standart Teklif',
    'quote_email_subject'                             => 'Teklif Email Konusu',
    'quote_items'                                     => 'Teklif sartlari',
    'quote_number'                                    => 'Teklif no',
    'quote_rejected'                                  => 'Kabul edilmeyen Teklif',
    'quote_rejected_email_body'                       => 'Teklif Reddi Maili',
    'quote_status_change_notification'                => 'Bildirim: Teklif Durum Degisikligi',
    'quote_summary'                                   => 'Teklifler',
    'quote_to_invoice'                                => 'Teklifi Faturalandir',
    'quotes'                                          => 'Teklif',
    'quotes_expire_after'                             => 'Teklif geçerlilik süresi',
    'recalculate'                                     => 'Yeniden Hesapla',
    'recalculate_help_text'                           => 'Yeniden hesaplamak biraz zaman alacak. Islem bittiginde onay mesaji görüntülenecek.',
    'recalculate_invoices'                            => 'Faturalari yeniden hesapla',
    'recalculate_quotes'                              => 'Teklifleri yeniden hesapla',
    'recalculating_wait'                              => 'Yeniden hesaplaniyor, lütfen bekleyin...',
    'recalculation_complete'                          => 'Yeniden hesaplama tamamlandi.',
    'recent_invoices'                                 => 'Son Faturalar',
    'recent_payments'                                 => 'Son Ödemeler',
    'recent_quotes'                                   => 'Son Teklifler',
    'record_not_found'                                => 'Kayit bulunamadi',
    'record_successfully_created'                     => 'Kayit basarili sekilde olusturuldu',
    'record_successfully_deleted'                     => 'Kayit basarili sekilde silindi',
    'record_successfully_updated'                     => 'Kayit basarili sekilde düzenlendi',
    'records_imported_successfully'                   => 'Kayitlar basarili sekilde içe aktarildi',
    'recurring'                                       => 'Yenilenen',
    'reject'                                          => 'Kabul etme',
    'rejected'                                        => 'Kabul edilmedi',
    'rejected_quotes'                                 => 'Kabul edilmeyen Teklifler',
    'remember_me'                                     => 'Beni Hatirla',
    'remove_logo'                                     => 'Logo yi sil',
    'report_rev_client_notice'                        => 'This report will be available once you have some payments entered in the system.',
    'reports'                                         => 'Raporlar',
    'require'                                         => 'Zorunlu',
    'reset_number'                                    => 'Sayiyi sifirla',
    'reset_password'                                  => 'Sifreyi sifirla',
    'results_per_page'                                => 'Sayfa basina sonuç',
    'revenue_by_client'                               => 'Müsteriye Göre Gelir',
    'round_tax_decimals'                              => 'Vergi YuvarlaGmasi için Ondalik Sayi',
    'run_report'                                      => 'Raporu Olustur',
    'save'                                            => 'Kaydet',
    'save_and_apply_exchange_rate'                    => 'Döviz kurunu kaydet ve uygula',
    'save_item_as_lookup'                             => 'Ürün olarak kaydet',
    'search'                                          => 'Ara',
    'select_file_to_import'                           => 'Içeri aktarim için dosya seçin',
    'send'                                            => 'Gönder',
    'sending'                                         => 'Gönderiliyor',
    'sendmail_path'                                   => 'Sendmail yolu',
    'sent'                                            => 'Gönderildi',
    'sent_invoices'                                   => 'Gönderilen Faturalar',
    'sent_quotes'                                     => 'Gönderilen Teklifler',
    'settings'                                        => 'Ayarlar',
    'settings_successfully_saved'                     => 'Ayarlar basariyla güncellendi',
    'setup'                                           => 'Ayarlar',
    'sign_in'                                         => 'Giris Yap',
    'sign_out'                                        => 'Çikis Yap',
    'skin'                                            => 'Skin',
    'smtp_encryption'                                 => 'SMTP Encryptie Type',
    'smtp_host_address'                               => 'SMTP Host Adres',
    'smtp_host_port'                                  => 'SMTP Host Port',
    'smtp_password'                                   => 'SMTP Sifre',
    'smtp_username'                                   => 'SMTP Kullanici Adi',
    'start_date'                                      => 'Baslangiç tarihi',
    'state'                                           => 'Durum',
    'status'                                          => 'Durum',
    'step_database_setup'                             => 'Veritabani olusturuluyor. Bu islem birkac dakika sürebilir.',
    'step_prerequisites'                              => 'Devam etmek için uyaridaki hata düzeltilmelidir:',
    'subject'                                         => 'Konu',
    'submit'                                          => 'Gönder',
    'subtotal'                                        => 'Ara Toplam',
    'summary'                                         => 'Özet',
    'symbol'                                          => 'Sembol',
    'symbol_placement'                                => 'Sembol konumu',
    'system'                                          => 'Sistem',
    'system_settings'                                 => 'Sistem ayarlari',
    'table_name'                                      => 'Tablo adi',
    'tax'                                             => 'KDV',
    'tax_1'                                           => 'Tax 1',
    'tax_2'                                           => 'Tax 2',
    'tax_rate'                                        => 'KDV Yüzdesi',
    'tax_rate_form'                                   => 'KDV Yüzdesi formu',
    'tax_rate_name'                                   => 'KDV Adi',
    'tax_rate_percent'                                => 'KDV Yüzdesi',
    'tax_rates'                                       => 'KDV Yüzdeleri',
    'tax_summary'                                     => 'KDV Dökümü',
    'taxable_amount'                                  => 'KDV lenmis miktar',
    'taxes'                                           => 'KDV',
    'template'                                        => 'Sablon',
    'terms_and_conditions'                            => 'Kullanim Kosullari',
    'test_mode'                                       => 'Test Modu',
    'text'                                            => 'Teks',
    'textarea'                                        => 'Teks Alani',
    'this_quarter'                                    => 'Bu Çeyrek',
    'thousands_separator'                             => 'Binlik ayiraci',
    'timezone'                                        => 'Zaman dilimi',
    'to'                                              => 'Kime',
    'to_date'                                         => 'Tarihe Kadar',
    'total'                                           => 'Toplam',
    'total_balance'                                   => 'Toplam Tutar',
    'total_invoiced'                                  => 'Toplam Faturalanan',
    'total_expenses'                                  => 'Toplam Gider',
    'total_paid_invoices'                             => 'Toplam Ödenen Faturalar',
    'try_again'                                       => 'Tekrar dene',
    'uninstall'                                       => 'Kaldir',
    'uninstall_addon_warning'                         => 'Eklentiyi kaldirmak, bu eklentideki tüm verileri silecektir. Devam etmek istediginize emin misiniz ?',
    'unique_name'                                     => 'Benzersiz Ad',
    'unknown_error'                                   => 'Bilinmeyen hata',
    'upcoming_payment_notice_email_body'              => 'Yaklasan Ödeme Bilgi Email Içerigi',
    'upcoming_payment_notice_email_subject'           => 'Yaklasan Ödeme Bilgi Email Konusu',
    'upcoming_payment_notice_frequency'               => 'Yaklasan Ödeme Hatirlatma Sikligi',
    'upcoming_payment_notice_frequency_help'          => 'Yaklasan tarihi hatirlatmak için kaç gün ÖNCEDEN göndermek istediginiz günleri virgül ile ayirin. Örnegin 1 ve 5 gün kala hatirlatma maili gönderecekseniz 1,5 olarak girin',
    'update_available'                                => 'Versiyon :version yeni versiyonu indirebilirsiniz :url',
    'update_exchange_rate'                            => 'Döviz kurunu güncelle',
    'update_not_available'                            => 'herhangi bir update bulunmamaktadir.',
    'upload_progress'                                 => 'Yükleme durumu',
    'user'                                            => 'Kullanici',
    'user_accounts'                                   => 'Kullanici Hesaplari',
    'user_form'                                       => 'Kullanici Formu',
    'users'                                           => 'Kullanicilar',
    'validation_invoice_summary_from_date'            => 'Tarih araligi Özel Tarih Araligina ayarlandiginda, Fatura Özet Gösterge Panosu Widget\'taki tarihten itibaren gereklidir.',
    'validation_invoice_summary_to_date'              => 'Özel bir tarih araligi kullanirken Fatura Özeti Kontrol Paneli Widget\'tan bugüne kadar gerekli.',
    'validation_quote_summary_from_date'              => 'Özel bir tarih araligi kullanirken, Alinti Özet Dashboard Widget\'tan itibaren gerekir.',
    'validation_quote_summary_to_date'                => 'Özel bir tarih araligi kullanirken Alinti Özeti Kontrol Paneli Pencere Ögesi\'ne bugüne kadar gerekli.',
    'vendor'                                          => 'Satici',
    'version'                                         => 'Versiyon',
    'view'                                            => 'Listele',
    'view_all'                                        => 'Tümünü Gör',
    'view_all_invoices_for_client'                    => 'Bu müsterinin tüm faturalarini göster',
    'view_all_payments_for_client'                    => 'Bu müsterinin tüm ödemelerini göster',
    'view_all_quotes_for_client'                      => 'Bu müsterinin tüm tekliflerini göster',
    'view_approved_quotes'                            => 'Onaylanmis Teklifleri Görütüle',
    'view_client'                                     => 'Müsteriyi Listele',
    'view_draft_invoices'                             => 'Taslak Haldeki Faturalari Listele',
    'view_draft_quotes'                               => 'Taslak Haldeki Teklifleri Görütüle',
    'view_overdue_invoices'                           => 'Gecikmis Faturalari Listele',
    'view_payments'                                   => 'Ödemeleri Listele',
    'view_rejected_quotes'                            => 'Onaylanmamis Teklifleri Görütüle',
    'view_sent_invoices'                              => 'Gönderilen Faturalari Listele',
    'view_sent_quotes'                                => 'Gönderilmis Teklifleri Görütüle',
    'view_unique_name'                                => 'Benzersiz Adi Göster',
    'viewed'                                          => 'Görüntülendi',
    'visible'                                         => 'Görünür',
    'visible_after_payment'                           => 'Ödemeden sonra görünür',
    'web'                                             => 'Web',
    'web_address'                                     => 'Web Adresi',
    'weekly'                                          => 'Haftalik',
    'weeks'                                           => 'Hafta',
    'welcome'                                         => 'Hosgeldin',
    'what_to_import'                                  => 'Neys import etmek istiyorsunuz ?',
    'year'                                            => 'Yil',
    'yearly'                                          => 'Yillik',
    'years'                                           => 'Yil',
    'yes'                                             => 'Evet',
    'you_may_now_sign_in'                             => 'Simdi giris yapabilirsiniz!',

    // 2017-1
    'all_company_profiles'                            => 'Tüm Sirket Profilleri',
    'cannot_delete_record_in_use'                     => 'Bu kayit kullanimda ve silinemez.',
    'cannot_edit_record_in_use'                       => 'Bu kayit kullanimda ve düzenlenemez.',
    'change_company_profile'                          => 'Sirket Profilini Degistir',
    'company_profile'                                 => 'sirket Profili',
    'company_profiles'                                => 'Sirket profilleri',
    'company_profile_form'                            => 'Sirket Profil Formu',
    'copy'                                            => 'Kopyala',
    'create_recurring_invoice'                        => 'Yinelenen Fatura Olusturun',
    'custom'                                          => 'Özel',
    'date_range'                                      => 'Tarih araligi',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Pzt',
    'day_short_tuesday'                               => 'Sa',
    'day_short_wednesday'                             => 'Biz',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Varsayilan Sirket Profili',
    'first_quarter'                                   => 'Ilk çeyrek',
    'fourth_quarter'                                  => 'Dördüncü çeyrek',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Son 7 gün',
    'last_30_days'                                    => 'Son 30 gün',
    'last_month'                                      => 'Geçen ay',
    'last_quarter'                                    => 'Son çeyrek',
    'last_year'                                       => 'Geçen yil',
    'month_january'                                   => 'Ocak',
    'month_february'                                  => 'Subat',
    'month_march'                                     => 'Mart',
    'month_april'                                     => 'Nisan',
    'month_may'                                       => 'Mayis',
    'month_june'                                      => 'Haziran',
    'month_july'                                      => 'Temmuz',
    'month_august'                                    => 'Agustos',
    'month_september'                                 => 'Eylül',
    'month_october'                                   => 'Ekim',
    'month_november'                                  => 'Kasim',
    'month_december'                                  => 'Aralik',
    'recurring_invoice'                               => 'Yinelenen Fatura',
    'second_quarter'                                  => 'Ikinci çeyrek',
    'stop_date'                                       => 'Bitis Tarihi',
    'third_quarter'                                   => 'Üçüncü çeyrek',
    'this_month'                                      => 'Bu ay',
    'this_year'                                       => 'Bu yil',
    'today'                                           => 'Bugün',
    'user_account'                                    => 'Kullanici hesabi',
    'yesterday'                                       => 'Dün',

    // 2017-3
    'mail_log'                                        => 'Posta Günlügü',
    'recent_client_activity'                          => 'Son Müsteri Etkinligi',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Ödenmemis Faturalari Hariç Tut',

    // 2017-7
    'please_wait'                                     => 'Lütfen bekle...',
    'reply_to_address'                                => 'Adrese Yanitla',

    // 2017-8
    'admin'                                           => 'Yönetici',
    'admin_account'                                   => 'Yönetici Hesabi',
    'admin_accounts'                                  => 'Yönetici Hesaplari',
    'all_accounts'                                    => 'Bütün hesaplar',
    'api_key'                                         => 'API Anahtari',
    'client_account'                                  => 'Müsteri Hesabi',
    'client_accounts'                                 => 'Müsteri Hesaplari',
    'client_id'                                       => 'Müsteri Kimligi',
    'client_secret'                                   => 'Müsteri Sirri',
    'enable_bitcoin_payments'                         => 'Bitcoin Ödemelerini Etkinlestir',
    'live'                                            => 'Canli',
    'mode'                                            => 'Mod',
    'publishable_key'                                 => 'Yayinlanabilir Anahtar',
    'sandbox'                                         => 'Kum havuzu',
    'secret_key'                                      => 'Gizli anahtar',
    'type'                                            => 'Tür',

    // 2017-10
    'deselect_all'                                    => 'Hiçbirini seçme',
    'select_all'                                      => 'Hepsini seç',
    'use_24_hour_time_format'                         => '24 Saatlik Saat Biçimini Kullan',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Bu kayitlari silmek istediginizden emin misiniz?',
    'bulk_invoice_change_status_warning'              => 'Seçilen faturanin / faturalarin durumunu degistirmek istediginizden emin misiniz?',
    'bulk_quote_change_status_warning'                => 'Seçilen tekliflerin durumunu degistirmek istediginizden emin misiniz?',
    'calculate_as_vat_gst'                            => 'KDV / GST olarak hesapla',
    'change_status'                                   => 'Durum degistirmek',
    'default_status_filter'                           => 'Varsayilan Durum Filtresi',
    'error_applying_payment'                          => 'Bu ödeme uygulanirken bir hata olustu. Lütfen farkli bir kart veya ödeme yöntemi deneyin.',
    'remaining'                                       => 'Kalan',

    // 2017-12
    'invoice_date'                                    => 'Fatura tarihi',
    'include_profit_based_on'                         => 'Suna Göre Kar Dahil Et',

    // 2018-1
    'add_contact'                                     => 'Kisi ekle',
    'allow_self_signed_cert'                          => 'Kendinden Imzali Sertifikaya Izin Ver',
    'backup'                                          => 'Destek olmak',
    'close'                                           => 'Kapat',
    'change_invoice_date_to_todays_date'              => 'Fatura Tarihini Bugünün Tarihiyle Degistirin',
    'change_quote_date_to_todays_date'                => 'Teklif Tarihini Bugünün Tarihine Degistirin',
    'contacts'                                        => 'Kisiler',
    'default_bcc'                                     => 'Varsayilan BCC',
    'default_cc'                                      => 'Varsayilan CC',
    'default_to'                                      => 'Varsayilan Olarak',
    'disable'                                         => 'Devre disi birak',
    'download_database_backup'                        => 'Veritabani Yedeklemesini Indirin',
    'edit_contact'                                    => 'Kisiyi Düzenle',
    'expense_list'                                    => 'Gider Listesi',
    'keep_invoice_date_as_is'                         => 'Fatura Tarihini Oldugu Gibi Tut',
    'keep_quote_date_as_is'                           => 'Teklif Tarihini Oldugu Gibi Tut',
    'if_quote_is_emailed_while_draft'                 => 'Taslak Durumunda Teklif E-postayla Gönderilirse',

    // 2018-4
    'force_https'                                     => 'HTTPS\'yi zorla',
    'force_https_help'                                => 'Bu seçenegi etkinlestirmeden önce, FusionInvoice kurulumunuzun https araciligiyla çalistigindan emin olun. Bunun yapilmamasi, islevsel olmayan (ancak düzeltilebilir) bir kuruluma neden olabilir.',

    // 2019-1
    'attached_to'                                     => 'Ekli',
    'customer'                                        => 'Müsteri',
    'expense'                                         => 'Gider',
    'expense_categories'                              => 'Gider Kategorileri',
    'expense_category_form'                           => 'Gider Kategori Formu',
    'expense_vendors'                                 => 'Gider Saticilari',
    'expense_vendor_form'                             => 'Gider Satici Formu',
    'lead'                                            => 'Öncülük etmek',
    'local_time'                                      => 'Yerel zaman',
    'prospect'                                        => 'Beklenti',
    'search_clients'                                  => 'Müsteri Ara',
    'search_expenses'                                 => 'Arama Giderleri',
    'search_invoices'                                 => 'Faturalari Ara',
    'search_items'                                    => 'Ürün Ara',
    'search_log'                                      => 'Arama Günlügü',
    'search_quotes'                                   => 'Alintilarda Ara',
    'search_payments'                                 => 'Ödemeleri Ara',
    'search_recurring_invoices'                       => 'Yinelenen Faturalari Ara',
    'show_all_statuses'                               => 'Tüm Durumlari Göster',
    'show_all_types'                                  => 'Tüm Türleri Göster',
    'unknown'                                         => 'Bilinmeyen',
    'value'                                           => 'Deger',

    // 2019-2
    'default'                                         => 'Varsayilan',
    'no_data_available'                               => 'Uygun veri yok',
    'recurring_invoice_list'                          => 'Yinelenen Fatura Listesi',
    'report_total'                                    => 'Toplamlari Bildir',

    //2019-3
    'checkbox'                                        => 'Onay kutusu',
    'custom_dropdown_validate'                        => 'Lütfen @kolonstr1 alanindan geçerli bir seçenek seçin',
    'custom_image_validate'                           => 'Lütfen geçerli bir resim seçin.',
    'custom_tag_validate'                             => 'Lütfen @kolonstr1\'den geçerli bir etiket seçin',
    'custom_text_validate'                            => 'Lütfen @kolonstr1 alanina geçerli bir @kolonstr1 girin.',
    'datetime'                                        => 'DateTime',
    'decimal'                                         => 'Ondalik',
    'delete-confirm'                                  => 'Emin misiniz?',
    'grand_total'                                     => 'Genel Toplam',
    'image'                                           => 'Resim',
    'integer'                                         => 'Tamsayi',
    'mailed'                                          => 'Postalanmis',
    'mailed_invoices'                                 => 'Postalanan Faturalar',
    'radio'                                           => 'Radyo',
    'recurring_id'                                    => 'Yinelenen kimlik',
    'remove_image'                                    => 'Resmi Kaldir',
    'tags'                                            => 'Etiketler',
    'tagselection'                                    => 'Etiket Seçimi',
    'unpaid'                                          => 'Ödenmemis',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Postalanan Faturalari Görüntüle',
    'important'                                       => 'Önemli!',
    'created_recurring_invoice_id'                    => 'Yinelenen Fatura Kimliginden Olusturuldu',
    'mr'                                              => 'Bay.',
    'miss'                                            => 'Özlemek',
    'ms'                                              => 'Hanim.',
    'mrs'                                             => 'Bayan.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Iletisim Ünvani',
    'title'                                           => 'Baslik',
    'test_email_subject'                              => 'FusionInvoice\'tan merhaba',
    'test_email_body'                                 => 'Bu, FusionInvoice\'tan bir test e-postasidir.',
    'test_email_address'                              => 'E-posta Testini Gönder',
    'send_test_email'                                 => 'Test E-postasi Gönderin',
    'invalid_json'                                    => 'Lütfen geçerli bir JSON dizesi girin',
    'textarea_rows_limit'                             => 'Satirlar @kolonstr1 degerini asamaz',
    'custom_integer_validate'                         => '@kolonstr1 geçerli bir tamsayi degeri olmalidir',

    //2020-1
    'user_role'                                       => 'Kullanici rolü',
    'standard_user'                                   => 'Standart kullanici',
    'permissions'                                     => 'Izinler',
    'modules'                                         => 'Modüller',
    'is_view'                                         => 'Görünüm',
    'is_create'                                       => 'Olusturmak',
    'is_update'                                       => 'Güncelleme',
    'is_delete'                                       => 'Sil',
    'dashboards'                                      => 'Gösterge tablolari',
    'allow_time_period_change'                        => 'Zaman Araligi Degisikligine Izin Ver',
    'page_not_found'                                  => 'Oops! Sayfa bulunamadi.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => 'Müsteri yaratma yetkiniz yok!',
    'check-all'                                       => 'Tümünü Kontrol Et',
    'invoice_prefix'                                  => 'Fatura Öneki',
    'recently_viewed'                                 => 'Son Görüntülenen',
    'copy_from'                                       => 'Suradan kopyala:',
    'select_user'                                     => 'Kullanici seç',
    'please_select_user'                              => 'Lütfen listeden bir kullanici seçin',
    'allow_client_center_login'                       => 'Müsteri Merkezi Girisine Izin Ver',
    'online_payment_processing_fee'                   => 'Online Ödeme Islem Ücreti',
    'client_password_required'                        => 'Lütfen müsteri sifresini girin',
    'last_login_at'                                   => 'Son Giris',
    'show_notes_panel_below_client'                   => 'Istemci Ayrintilarinin altinda Notlar Panelini Göster',
    'notepad'                                         => 'Not defteri',
    'added'                                           => 'Katma',
    'last_edited'                                     => 'Son Düzenlenen',
    'loading'                                         => 'Isleme ....',
    'n_records_match'                                 => '@kolonstr1 Record @kolonstr2 maç',
    'initials'                                        => 'Bas harfler',
    'initials_bg_color'                               => 'Bas Harfleri Arka Plan Rengi',
    'more'                                            => 'Daha',
    'must_match_all'                                  => 'Tümüyle eslesmelidir',
    'clear'                                           => 'Açik',
    'no_client_tags'                                  => 'Tanimlanmis etiketlere sahip müsteri kaydi yok.',
    'qr_code_on_invoice_quote'                        => 'Fatura ve Fiyat Teklifinde QR Kodu',
    'delete_tags'                                     => 'Etiket Temizleme',
    'orphan_tags_deleted'                             => 'Sahipsiz tüm etiketler sistemden basariyla silindi.',
    'orphan_tags_delete_confirm'                      => 'Etiket Temizlemeyi çalistirmak, kullanilmayan tüm etiketleri kaldiracaktir. Devam et?',
    'deleting_tags_wait'                              => 'Etiketler siliniyor, lütfen bekleyin ...',
    'new-version-available'                           => 'Yeni sürüm mevcut!',
    'ignore-this-version'                             => 'Bu sürümü yok say',
    'view-release-notes'                              => 'Sürüm notlarini göster',
    'task_list'                                       => 'Görev listesi',
    'create_task'                                     => 'Görev Olustur',
    'open'                                            => 'Açik',
    'closed'                                          => 'Kapali',
    'assignee'                                        => 'Vekil',
    'task'                                            => 'Görev',
    'task_successfully_created'                       => 'Görev basariyla olusturuldu',
    'task_successfully_updated'                       => 'Görev basariyla güncellendi',
    'task_completed'                                  => 'Görev basariyla tamamlandi',
    'task_marked_incomplete'                          => 'Görev yeniden açildi',
    'due_date_validation_date'                        => 'Lütfen geçerli bir son tarih seçin',
    'assignee_validation_required'                    => 'Lütfen listeden geçerli bir vekil seçin',
    'assignee_validation_exists'                      => 'Lütfen listeden geçerli bir vekil seçin',
    'tomorrow'                                        => 'Yarin',
    'task_not_authorized'                             => 'Bu görevi düzenleme yetkiniz yok!',
    'me'                                              => 'Ben mi',
    'task_from_note'                                  => 'Kaydederken Görev Olusturun',
    'done'                                            => 'Bitti',
    'refresh'                                         => 'Yenile',
    'task_list_page_size'                             => 'Sayfa basina görev sayisi',
    'select_client'                                   => 'Istemci Seçin',
    'note-search-config'                              => 'Notlar Dahil Edilecek Arama',
    'username'                                        => 'Kullanici adi',
    'task-search-config'                              => 'Dahil Edilecek Görev Aramasi',
    'task_section_invalid'                            => 'Geçersiz görev bölümü',
    'task_section'                                    => 'Görev bölümü',
    'select_section'                                  => 'Bölüm seçin',
    'email-test-failed'                               => 'E-posta Testi Basarisiz',
    'smtp-setting-suggestion'                         => 'Öneriler:<br>1. Kullanici / sifre degerlerinizi dogrulayin ve yeniden girin<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Öneriler:<br>1. PHP Mail sunucusunun dogru yapilandirildigini dogrulayin<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Öneriler:<br>1. Sendmail yolunuzun dogru sekilde yapilandirildigini dogrulayin.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Öneriler:<br>1. Sendgrid anahtarinizin dogru sekilde yapilandirildigini dogrulayin.<br>2. Contact server admin',
    'later'                                           => 'Sonra',
    'test-email-required'                             => 'Geçerli bir Alici e-postasi girmelisiniz',
    'test_mail_sent_successfully'                     => 'Test postasi basariyla gönderildi',
    'test-mail-btn-title'                             => 'Testten önce degisiklikleri kaydetmelisiniz.',
    'agreement_expire'                                => 'Ürün Güncellemeleriniz ve Desteginiz @kolonstr1 tarihinde sona erecek',
    'agreement_expired'                               => 'Ürün Güncellemeleriniz ve Desteginiz @kolonstr1 tarihinde sona erdi',
    'piracy_message'                                  => 'FusionInvoice Lisans Anahtariniz geçerli degil. Yazilim korsanligi bir suçtur. Lütfen adil oynayin. Geçerli bir lisansla destek, güncellemeler ve iyi bir karma alacaksiniz.',
    'buy-now'                                         => 'Simdi satin al',
    'piracy_alert'                                    => 'Lütfen adil olun!',
    'agreement-expire-alert'                          => 'Ürün Güncellemeleri ve Destek Yakinda Sona Eriyor.',
    'agreement-expired-alert'                         => 'Ürün Güncellemeleri ve Destek Süresi Doldu.',
    'dismiss-forever'                                 => 'Sonsuza Kadar Reddet',
    'renew-now'                                       => 'Simdi Yenile',
    'select_all_permissions'                          => 'Tüm Izinleri Seçin',
    'app-key-missing'                                 => 'Lütfen config / app.php\'ye lisans anahtarinizi girin.',
    'custom_fields_column_width'                      => 'Özel Alanlar Sütunlari Görüntüle',
    'select-user-type'                                => 'Kullanici Türünü Seçin',
    'lead-or-prospect-with-invoices-error'            => 'Maalesef, bir müsterinin Türü, faturalar veya yinelenen faturalar varken Müsteri Adayi veya Olasilik olamaz.',
    'sendgrid_key'                                    => 'Sendgrid anahtari',

    //2020-2.0
    'space'                                           => 'Uzay',
    'apostrophe'                                      => 'Kesme isareti',
    'comma'                                           => 'Virgül',
    'fullstop'                                        => 'Nokta (Tam Durdurma)',
    'middledot'                                       => 'Orta Nokta',
    'thinspace'                                       => 'Ince Bosluk',
    'narrow-no-break-space'                           => 'Dar Bölünmez Bosluk',
    'dotabove'                                        => 'Yukarida Nokta',
    'arabic-decimal'                                  => 'Arapça Ondalik Ayirici',
    'arabic-thousand'                                 => 'Arapça Bin Ayirici',
    'decimal-separator-key-symbol'                    => 'Ondalik Ayirici Anahtar Sembolü',
    'select-item'                                     => 'Ögeyi seçin',
    'item-lookup-overload'                            => 'Öge aramasi için maksimum 100 ögeye izin verilir',
    'select-expense-category'                         => 'Gider Kategorisi Seçin',
    'select-expense-vendor'                           => 'Gider Saticisini Seçin',
    'can-not-delete-all-users'                        => 'Üzgünüz, tüm kullanicilari sistemden silemezsiniz',
    'can-not-change-default-user-role'                => 'Maalesef varsayilan kullanici rolünü degistiremezsiniz',
    'can-not-change-default-user-status'              => 'Üzgünüz, varsayilan kullanici durumunu degistiremezsiniz',
    'user_not_active'                                 => 'Kullanici aktif degil',
    'can-not-inactive-your-own-status'                => 'Üzgünüm, kendinizi pasif hale getiremezsiniz.',
    'delete_user_warning'                             => '<p>DUR! Bu kullanicinin silinmesi, sistem içinde olusturduklari kayitlari silebilecek zararli bir eylemdir. Lütfen bunun yerine kullaniciyi devre disi birakmayi düsünün.</p><p>Bu kullaniciyi silmek istediginizden emin misiniz?</p>',
    'include_time_in_due_date'                        => 'Son Tarihte Zamani Dahil Et',
    'cannot_delete_default_company'                   => 'Varsayilan sirket profilini silemezsiniz',
    'make-user-inactive'                              => 'Kullaniciyi Pasif Yap',
    'mail_from_address'                               => 'Gelen Posta Adresi',
    'mail_from_name'                                  => 'Addan Posta',
    'item_categories'                                 => 'Öge Kategorileri',
    'select-item-category'                            => 'Öge Kategorisi Seçin',
    'item_category_form'                              => 'Öge Kategori Formu',
    'sort_by_due'                                     => 'Son Tarihe Göre Sirala',
    'affiliate'                                       => 'Ortaklik',
    'parent_account'                                  => 'ebeveyn hesabi',
    'child_account'                                   => 'Çocuk Hesaplari',
    'select_parent_client'                            => 'Ana Hesabi Seçin',
    'record_successfully_retrieved'                   => 'Kayit basariyla alindi',
    'custom-image-not-support'                        => 'Özel görüntü alani desteklenmiyor',
    'custom-tag-not-support'                          => 'Özel etiket alani desteklenmiyor',
    'custom-checkbox-not-support'                     => 'Özel onay kutusu alani desteklenmiyor',
    'custom-date-not-support'                         => 'Özel tarih alani desteklenmiyor',
    'custom-datetime-not-support'                     => 'Özel tarih saat alani desteklenmiyor',
    'timeline'                                        => 'Zaman çizelgesi',
    'client_invoice'                                  => 'Müsteriye Göre Faturalar',
    'select_client_blank_for_all'                     => 'Istemci Seçin (tümü için bos)',
    'invoice_email_success'                           => 'Fatura e-postasi basariyla gönderildi',
    'quote_email_success'                             => 'Teklif e-postasi basariyla gönderildi',
    'document_number_schemes'                         => 'Belge Numaralandirma',
    'document_number_scheme'                          => 'Belge Numarasi Semasi',
    'document_number_scheme_form'                     => 'Belge Numarasi Sema Formu',
    'default_document_number_scheme'                  => 'Varsayilan Belge Numarasi Semasi',
    'supporting_data'                                 => 'Destekleyici veri',
    'customizations'                                  => 'Özellestirmeler',
    'utilities_and_logs'                              => 'Yardimci Programlar ve Günlükler',
    'system_log'                                      => 'Sistem Günlügü',
    'paid_amount'                                     => 'Ödenen miktar',
    'payment_amount'                                  => 'Ödeme miktari',
    'payment_intent'                                  => 'Ödeme Amaci',
    'apply_payment_to_one_or_more_invoice'            => 'Ödemeyi bir veya daha fazla faturaya uygulayin',
    'pre_payment_for_future_invoices'                 => 'Gelecekteki faturalar için ön ödeme',
    'apply_to_invoices'                               => 'Faturalara Uygula',
    'payment_application'                             => 'Ödeme Basvurusu',
    'remaining_payment_balance'                       => 'Kalan Ödeme Bakiyesi',
    'remaining_balance'                               => 'Kalan Bakiye',
    'payment_warning'                                 => 'Lütfen tutari girin',
    'apply_pre_payment_warning'                       => 'Ödemeyi hiçbir faturaya uygulamadiniz. Ön ödeme olarak kaydetmek ister misiniz?',
    'confirm_remaining_balance'                       => ':value\'in kalan bakiyesi, bu müsteri için gelecekteki faturalara uygulanabilecek.',
    'open_balance'                                    => 'Açik Bakiye',
    'more_figure_then_total_payment'                  => 'Lütfen ödemeyi tekrar girin, toplam fatura ödemeniz kalan bakiyeden fazla.',
    'remaining_payment_balance_apply_later_info'      => 'Kalan ödeme bakiyeleri daha sonra diger faturalara uygulanabilir.',
    'invoice_balance'                                 => 'Fatura Bakiyesi',
    'enter_payment_for_invoice'                       => 'Fatura için ödeme girin',
    'invoice_pdf'                                     => 'Fatura PDF\'si',
    'payment_applications'                            => 'Ödeme Uygulamalari',
    'multiple'                                        => 'çoklu',
    'ok'                                              => 'Tamam mi',
    'credit_memo_default'                             => 'Kredi Notu Varsayilani',
    'edit_payment'                                    => 'Ödemeyi Düzenle',
    'credit_memo'                                     => 'Kredi Notu',
    'credit_memos'                                    => 'Kredi notlari',
    'create_credit_memo'                              => 'Kredi Notu Olustur',
    'credit_applications'                             => 'Kredi Notu Uygulamalari',
    'credit_applications_for_invoice'                 => 'Fatura Için Alacak Dekontu Basvurulari',
    'prepayment_applications_for_invoice'             => 'Fatura Ön Ödeme Basvurulari',
    'apply_credit_memo'                               => 'Kredi Notu Uygula',
    'apply_pre_payment'                               => 'Ön ödeme uygula',
    'applied_amount'                                  => 'Uygulanan Tutar',
    'remaining_credit_balance'                        => 'Kalan Kredi Bakiyesi',
    'remaining_credit_balance_apply_later_info'       => 'Kalan alacak bakiyeleri daha sonra diger faturalara uygulanabilir.',
    'applied'                                         => 'Uygulamali',
    'more_figure_then_invoice_amount'                 => 'Lütfen tutari tekrar girin, tutar fatura tutarindan büyük olamaz.',
    'more_figure_then_invoice_total'                  => 'Lütfen tutari tekrar girin, uygulanan toplam tutar fatura tutarindan fazla olamaz.',
    'invoice_not_selected_warning'                    => 'Bekleyin, Alacak Dekontunu hiçbir faturaya uygulamadiniz.',
    'select_type'                                     => 'Tür Seç',
    'email_credit_memo'                               => 'E-posta Kredi Notu',
    'back_to_credit_memo'                             => 'Kredi Notuna Geri Dön',
    'invoice_amount'                                  => 'Fatura tutari',
    'remaining_invoice_amount'                        => 'Kalan Fatura Tutari',
    'settlement_for_credit_memo'                      => 'Alacak Dekontu için Hesap Görme',
    'credit_memo_amount'                              => 'Kredi Notu Tutari',
    'confirm_remaining_balance_invoice'               => 'Bu faturanin kalan bakiyesi, ödemeden sonra :value olacaktir.',
    'payment_receipt_for_invoices'                    => 'Faturalar için Ödeme Dekontu',
    'primary_phone'                                   => 'Birincil telefon numarasi',
    'alternate_phone'                                 => 'Alternatif telefon numarasi',
    'currency_not_match'                              => 'Para birimi eslesmiyor',
    'tasks'                                           => 'Görevler',
    'full_and_final_payment'                          => 'tam',
    'partial'                                         => 'kismi',
    'transition'                                      => [
        'created'          => 'Olusturuldu',
        'updated'          => 'Güncellenmis',
        'deleted'          => 'silindi',
        'received'         => 'Alinan',
        'opened'           => 'Açildi',
        'sent'             => 'Gönderildi',
        'mail'             => 'Postalandi',
        'changed'          => 'Degistirildi',
        'recurring'        => 'Olusturuldu',
        'completed'        => 'Tamamlandi',
        'reversed'         => 'Ters',
        'quote_to_invoice' => 'Faturaya Alinti',
        'download'         => 'Indirmek',
        'added'            => 'Katma',
        'email'            => 'E-posta',
        'merge'            => 'Birlestirmek',
        'billed'           => 'Faturalandirilan',
        'failed'           => 'Arizali',
        'invoice'          => [
            'created'                => 'Fatura @kolonstr1 olusturuldu',
            'credit_memo_created'    => 'Alacak Dekontu :credit_memo_number olusturuldu',
            'credit_memo_updated'    => 'Alacak Dekontu @kolonstr1 degistirildi',
            'created_from_recurring' => 'Invoice @kolonstr1 olusturuldu (Yinelenen sablon @kolonstr2\'den',
            'updated'                => 'Fatura @kolonstr1 degistirildi',
            'deleted'                => 'Fatura @kolonstr1 silindi',
            'credit_memo_deleted'    => 'Alacak Dekontu @kolonstr1 silindi',
            'status_changed'         => 'Invoice @kolonstr1 Durumu @kolonstr2\'den @kolonstr3 olarak degistirildi',
            'email_sent'             => 'Invoice @kolonstr1 e-postasi gönderildi',
            'resend_email'           => 'Fatura :invoice_number e-postanin yeniden gönderilmesi',
            'email_opened'           => 'Invoice @kolonstr1 e-postasi açildi',
            'payment_updated'        => 'Fatura :invoice_number güncellendi :full_payment_text ödeme',
            'payment_received'       => 'Fatura @kolonstr1 alindi @kolonstr2 ödemesi',
            'payment_reversed'       => 'Fatura @kolonstr1 @kolonstr2 vardi',
            'invoice_tag_updated'    => ':invoice_number faturasina Fatura Etiketi :tags eklendi',
            'invoice_tag_deleted'    => 'Fatura Etiketi :invoice_number silindi :tags',
            'mark_mail'              => 'Fatura :invoice_number postalandi olarak isaretle',
            'unmark_mail'            => 'Fatura :invoice_number postalanmamis olarak maskeleniyor',
            'paid_invoice_opened'    => 'Ödenen fatura düzenlemeye açildi',
            'sent_invoice_opened'    => 'Gönderilen Fatura düzenlenmek üzere açildi',
            'sms_sent'               => 'Fatura :invoice_number SMS gönderildi',
        ],
        'quote'            => [
            'created'           => 'Alinti @kolonstr1 olusturuldu',
            'updated'           => 'Alinti @kolonstr1 degistirildi',
            'deleted'           => 'Alinti @kolonstr1 silindi',
            'status_changed'    => 'Alinti @kolonstr1 Durumu @kolonstr2\'den @kolonstr3\'e degistirildi',
            'email_sent'        => 'Alinti @kolonstr1 e-posta gönderildi',
            'resend_email'      => 'Alinti :quote_number e-postayi yeniden gönder',
            'email_opened'      => 'Alinti @kolonstr1 e-postasi açildi',
            'quote_to_invoice'  => '@kolonstr1 faturaya dönüstürüldü - @kolonstr2',
            'quote_tag_updated' => 'Alinti Etiketi :tags, :quote_number alintisina eklendi',
            'quote_tag_deleted' => 'Alinti Etiketi :quote_number silindi :tags',
            'sms_sent'          => 'Alinti :quote_number SMS gönderildi',
        ],
        'payment'          => [
            'prepayment_created'           => 'Ön ödeme olusturuldu',
            'payment_receipt_email_sent'   => 'Ödeme makbuzu e-postasi gönderildi',
            'payment_receipt_resend_email' => 'Ödeme makbuzu e-postasinin yeniden gönderilmesi',
            'payment_updated'              => 'Ödeme degistirildi',
            'deleted'                      => 'Ödeme silindi',
            'payment_receipt_pdf_download' => 'Ödeme makbuzu PDF indir',
            'payment_note_deleted'         => 'Ödeme notu silindi:',
            'payment_note_added'           => 'Ödeme notu eklendi:',
            'payment_note_updated'         => 'Ödeme notu su tarihten güncellendi:',
            'payment_failed'               => 'Ödeme basarisiz',
        ],
        'client'           => [
            'client_created'     => '@kolonstr1 olusturuldu',
            'type_changed'       => '@kolonstr1, @kolonstr2 oldu',
            'updated'            => 'Müsteri güncellendi',
            'deleted'            => 'Müsteri silindi',
            'status_changed'     => 'Istemci @kolonstr1 olarak ayarlandi',
            'client_tag_updated' => ':tags etiketi eklendi',
            'client_tag_deleted' => ':tags etiketi silindi',
            'merge'              => 'Müsteri Kimligi: :idTo - :nameTo Müsteri Kimligi ile birlestirildi: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Gider olusturuldu',
            'updated' => 'Gider degistirildi',
            'deleted' => 'Gider silindi',
            'billed'  => 'Gider faturalandi',
            'vendor'  => [
                'created' => 'Gider Saticisi olusturuldu',
                'updated' => 'Gider Saticisi degistirildi',
                'deleted' => 'Gider Saticisi silindi',
            ],
        ],
        'note'             => [
            'created'          => 'Not olusturuldu',
            'updated'          => 'Not degistirildi',
            'deleted'          => 'Not silindi',
            'note_tag_updated' => ':tags etiketi nota eklendi',
            'note_tag_deleted' => ':tags etiketi nottan silindi',
        ],
        'task'             => [
            'created'   => 'Görev olusturuldu',
            'updated'   => 'Görev degistirildi',
            'deleted'   => 'Görev silindi',
            'completed' => 'Görev tamamlandi',
        ],
        'subscription'     => [
            'created'                       => 'Abonelik :invoice_number olusturuldu',
            'updated'                       => 'Abonelik :invoice_number degistirildi',
            'deleted'                       => 'Abonelik :invoice_number silindi',
            'recurring_invoice_tag_updated' => 'Abonelik Etiketi :tags , Abonelik :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Abonelik etiketi :recurringInvoice_number silindi :tags',
        ],
        'attachment'       => [
            'created' => ':filename ek olarak yüklendi',
            'deleted' => ':filename bir ek olarak kaldirildi',
        ],
        'tag'              => [
            'created' => ':tag etiketi eklendi',
            'deleted' => ':tag etiketi suradan kaldirildi:',
        ],
    ],
    'reset'                                           => 'Sifirla',
    'select_event'                                    => 'Etkinlik Türünü Seçin',
    'select_country'                                  => 'Bir ülke seçin',
    'type_captcha'                                    => 'Lütfen yukaridaki soruyu cevaplayin',
    'refresh_captcha'                                 => 'Soruyu yenile',
    'answer'                                          => 'Cevap',
    'use_captcha_in_login'                            => 'Giriste captcha kullanin',
    'allow_client_timeline'                           => 'Zaman çizelgesi',
    'client_timeline'                                 => 'Zaman çizelgesi',
    'no_invoice_tags'                                 => 'Fatura etiketi yok.',
    'total_notifications'                             => '@Colonstr1 bildiriminiz var',
    'no_notifications'                                => 'yeni bildirim yok',
    'notifications'                                   => 'Bildirimler',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Size atanmis yeni bir görev',
            'due_date_breached' => 'Görev',
            'completed'         => ':user görevi tamamladi:',
        ],
        'quote' => [
            'approved'             => ':quote_number onaylandi',
            'quote_to_invoice'     => ':quote_number bir faturaya dönüstürüldü -',
            'rejected'             => ':quote_number reddedildi',
            'payment_successfully' => 'Müsteri :quote_number client_name~ için alinti :client_name ödendi. Fatura :invoice_number olusturuldu ve ödeme uygulandi',
        ],
    ],
    'search_tasks'                                    => 'Görevleri Ara',
    'reopen_task'                                     => 'Görevi Yeniden Aç',
    'task_form'                                       => 'Görev ekle',
    'view_task'                                       => 'Görev Ayrintilari',
    'client_deleted'                                  => 'Müsteri silindi',
    'payment_canceled'                                => 'Ödemeniz iptal edildi',
    'default_company_profile_set'                     => 'Varsayilan sirket profilinizi belirledik. Sirket Profili ayarlarindan istediginiz zaman güncelleyebilirsiniz.',
    'file_uploaded_successfully'                      => 'dosya basariyla yüklendi',
    'attachment_notice'                               => 'Maksimum Ek dosya boyutu :size\'den küçük veya ona esit',
    'attachment_error'                                => 'Ek boyutu :size degerini asamaz',
    'attachment_warning'                              => 'Ek boyutu :size.\'dir Birçok büyük ekin yüklenmesi, zaman içinde veritabaninizin performansini düsürebilir.',
    'generate_timeline_history'                       => 'Zaman Çizelgesi Geçmisi Olustur',
    'generating_timeline_wait'                        => 'Zaman çizelgesi olusturuluyor, lütfen bekleyin ...',
    'generating_timeline_confirm'                     => 'Zaman çizelgesi özelligi, FusionInvoice 2020\'ye eklendi. Bu, o özellik eklemeden önce gelen tüm etkinlikler için zaman çizelgesi girisleri olusturacaktir. Devam et?',
    'generated_timeline_request_accepted'             => 'Zaman çizelgesi geçmisinin olusturulmasi tamamlandi.',
    'transitions'                                     => 'Zaman Çizelgesi Geçmisi',
    'pending'                                         => 'Bekliyor',
    'client_transition'                               => 'Müsteri Zaman Çizelgeleri',
    'expense_transition'                              => 'Gider Zaman Çizelgeleri',
    'invoice_transition'                              => 'Fatura Zaman Çizelgeleri',
    'payment_invoice_transition'                      => 'Ödeme Fatura Zaman Çizelgeleri',
    'payment_transition'                              => 'Ödeme Zaman Çizelgeleri',
    'quote_transition'                                => 'Teklif Zaman Çizelgeleri',
    'note_transition'                                 => 'Not Zaman Çizelgeleri',
    'task_transition'                                 => 'Görev Zaman Çizelgeleri',
    'email_sent'                                      => 'E-posta gönderildi',
    'credit_applied'                                  => 'Kredi Uygulandi',
    'configuration'                                   => 'Yapilandirma',
    'include_prepayments'                             => 'Ön Ödemeleri Dahil Et',
    'pre_payment'                                     => 'Ön Ödemeler',
    'pre_payments'                                    => 'Ön Ödemeler',
    'times'                                           => 'Zamanlar',
    'include_prepayments_applied'                     => 'Uygulanan Ön Ödemeleri Dahil Et',
    'confirm_full_payment_applied'                    => 'Ödeme tamamen uygulandi',
    'confirm_full_credit_memo_applied'                => 'Alacak dekontu tamamen uygulandi',
    'all_tasks'                                       => 'Tüm görevler',
    'my_tasks'                                        => 'Görevlerim',
    'assigned_from_others'                            => 'Digerleri için atanmis',
    'full_payment_reversed'                           => 'tam ödeme iptal edildi.',
    'partial_payment_reversed'                        => 'kismi ödeme iptal edildi.',
    'invoice_delete_error'                            => 'Üzgünüz, ödemeleri veya alacak notu uygulamalari olan bir faturayi silemezsiniz. Önce ödemeleri veya alacak notu uygulamalarini silmelisiniz.',
    'mail-from-required'                              => 'Geçerli bir E-postadan Posta girmelisiniz',
    'contact_updated'                                 => 'Kisi basariyla güncellendi',
    'contact_added'                                   => 'Kisi basariyla eklendi',
    'generate_passport_key_wait'                      => 'Pasaport anahtariniz olusturuluyor, lütfen bekleyin ...',
    'generate_passport_key'                           => 'Pasaport Anahtari Olusturun',
    'default_greeting'                                => 'Merhaba!<br>',
    'hi'                                              => 'Selam,',
    'deduct_tax_from_expenses'                        => 'Giderlerden Vergi Kesilmesi',
    'invalid_invoice_id'                              => 'Geçersiz Fatura Kimligi',
    'client_related_record_exist'                     => 'Maalesef, istemcinin asagidakilerle ilgili kayitlari var:: modüller. Islem geçmisine sahip müsteriler silinemez.',
    'email_payment_receipt_notice'                    => 'Müsterinin dosyasinda e-posta adresi yok',
    'show_more'                                       => 'Daha fazla göster ...',
    'show_less'                                       => 'Daha az göster ...',
    'invoice_already_paid'                            => 'Fatura zaten ödendi!',
    'system_default'                                  => 'Sistem varsayilani',
    'created_by'                                      => 'Tarafindan yaratildi',
    'created_at'                                      => 'Olusturulma Tarihi',
    'task_created_by_and_created_at'                  => '@Zzcolonstr1 tarafindan :created_at üzerinde olusturulan görev',
    'dashboard_widgets_date_options'                  => 'Fatura ve Teklif Özeti için Sistem Varsayilan Zaman Dönemi',
    'dashboard-widget-from-date-required'             => 'Fatura ve Teklif Özeti için Sistem Varsayilan Zaman Dönemi\'nde özel tarih araligi seçildiginde baslangiç tarihi gereklidir',
    'dashboard-widget-to-date-required'               => 'Fatura ve Teklif Özeti için Sistem Varsayilan Zaman Dönemi\'nde özel tarih araligi seçildiginde tarih gereklidir',
    'invoice_currency'                                => 'Fatura Para Birimi',
    'currency_format'                                 => 'Para Birimi Biçimi',
    'create_missing_folder_success'                   => 'Eksik gerekli klasör olusturuldu',
    'create_missing_folder_failed'                    => 'Klasör(ler) olusturma denemesi basarisiz oldu :path',
    'folder_is_not_writable'                          => 'Klasör yazilabilir degil :path',
    'update_item_as_lookup'                           => 'Öge aramasini güncelle',
    'number_of_tax_fields'                            => 'Vergi alanlarinin sayisi',
    'tax_1_entry'                                     => '1 Giris',
    'tax_2_entries'                                   => '2 Giris',
    'require_tags_on_client_notes'                    => 'Müsteri Notlarinda Etiket(ler) Gerektir',
    'entered_amount_less_than_invoice_amount'         => 'Girilen Tutar, Fatura tutarindan küçük veya ona esit olmalidir',
    'send-to'                                         => 'Gönderildi',
    'print'                                           => 'Yazdir',
    'pdf_cleanup'                                     => 'PDF Temizleme',
    'pdf_cleanup_confirm'                             => 'Eski PDF dosyalarini temizlemek istediginizden emin misiniz?',
    'pdf_cleanup_success'                             => 'PDF Temizleme tamamlandi',
    'deleting_pdf_wait'                               => 'Eski PDF dosyalari siliniyor, lütfen bekleyin...',
    'open_invoices'                                   => 'Açik Faturalar',
    'open_credits'                                    => 'Açik Krediler',
    'unapplied_payments'                              => 'Uygulanmayan Ödemeler',
    'attach_invoice_pdf'                              => 'Fatura PDF\'i Ekle',
    'upcoming_payment_notice'                         => 'Yaklasan Ödeme Bildirimi',
    'select_mapping'                                  => 'Esleme Seç',
    'select_named_export'                             => 'Adlandirilmis Disa Aktarmayi Seçin',
    'save_mapping'                                    => 'Eslemeyi Kaydet',
    'add_mapping'                                     => 'Yeni esleme olustur',
    'edit_mapping'                                    => 'Eslemeyi güncelle',
    'save_as_default_mapping'                         => 'Varsayilan esleme',
    'save_as_default_export'                          => 'Varsayilan disa aktarma',
    'export_item_lookups'                             => 'Öge Aramalarini Disa Aktar',
    'import_file_selection'                           => 'Dosya Seçimini Içe Aktar',
    'next'                                            => 'Sonraki',
    'delete_import_mapping_warning'                   => 'Bu eslemeyi silmek istediginizden emin misiniz?',
    'export'                                          => 'Ihracat',
    'named_exports'                                   => 'Adlandirilmis Ihracat',
    'save_named_export'                               => 'Adlandirilmis Disa Aktarmayi Kaydet',
    'delete_named_export'                             => 'Adlandirilmis Disa Aktarmayi Sil',
    'updated_at'                                      => 'Güncellenme Tarihi',
    'zip'                                             => 'Posta kodu',
    'fields_to_export'                                => 'Disa Aktarilacak Alanlar',
    'import-file-type-error'                          => 'Içe aktarma dosyasi türü CSV olmalidir',
    'recurring_invoice_items'                         => 'Yinelenen Fatura Kalemleri',
    'important_details'                               => 'Önemli Ayrintilar',
    'important_information'                           => 'Önemli bilgi',
    'item_lookups_important_information'              => '<p>CSV içe aktarma islemi sirasinda mevcut verilerde eslesen bir öge arama adi bulunursa, içe aktarma toplu islemi basarisiz olur ve hataya neden olan ögeyi gösterir.</p>',
    'invoices_important_information'                  => '<p>Istemci adi (CSV\'den) Istemciler tablosunda aranir ve eslesen bir ad varsa client_id olarak çözümlenir. Ad eslesmesi bulunamazsa, bir müsteri girisi olusturur ve yeni müsteri girisinin kimligini kullanir.</p><p>Fatura numarasi,</p><p>Invoice_items, fatura tablosundaki fatura numarasina (CSV\'den) bir arama yapar ve bunu kimlige dönüstürür. Baska hiçbir anahtar alan aramasi/dogrulamasi yapilmaz</p>',
    'invoice_items_important_information'             => '<p>fatura_ögelerini içe aktarma, faturalar tablosundaki fatura numarasina (CSV\'den) bir arama yapar ve bunu uygun fatura kimligine çözer. Müsteri kimligi de eslesen fatura bilgilerinden elde edilir.</p>',
    'payments_important_information'                  => '<p>Ödemelerin içe aktarilmasi, ödemelerin uygulanacagi geçerli bir eslesen fatura numarasi gerektirir. Eslesen bir fatura bulunamazsa, toplu içe aktarma isleminin tamami basarisiz olur.</p><p>Uygun müsteriler-</p><p>Ödeme yöntemi adina (CSV\'den ödeme_yöntemleri tablosuna) bir arama yapilir ve bulunursa uygun ödeme_yöntem_kimligi\'ne çözümlenir. eslesen isim bulunmazsa, yeni bir ödeme yöntemi kaydi olusturulacak ve yeni ödeme_metod_kimligi kullanilacaktir.</p>',
    'run_daily_tasks'                                 => 'Günlük Görevleri Çalistir',
    'daily_task_ran'                                  => 'Günlük Görevler basariyla çalistirildi',
    'csv_row_number'                                  => 'CSV Satir numarasi :row',
    'max_item_lookup_records'                         => 'Maks. Öge Arama Kayitlari',
    'invoice_with_commission_delete_error'            => 'Üzgünüz, ödenmis durumda komisyon girisleri olan bir faturayi silemezsiniz. Önce bu faturada ödenen komisyonu silmeniz gerekir.',
    'if_invoice_is_emailed_while_draft'               => 'Fatura Taslak Durumundayken E-postayla Gönderilirse',
    'custom_payment_receipt_body_not_exists'          => 'Ödeme Makbuzlari için özel sablon bulunamadi.',
    'invoice_email_body_type'                         => 'Fatura E-posta Gövde Türü',
    'send_overdue_reminder'                           => 'Gecikmis hatirlatici gönder',
    'reminder_sent_successfully'                      => 'Hatirlatici basariyla gönderildi',
    'error_sending_reminder'                          => 'Hatirlatici gönderilirken bir hata olustu, lütfen daha sonra tekrar deneyin.',
    'expense_date'                                    => 'Harcama Tarihi',
    'group_by'                                        => 'Gruplandir',
    'timeline_scope_all_user'                         => 'Zaman Çizelgesi Kapsami - Tüm Kullanicilar',
    'copy_to_clipboard'                               => 'Panoya kopyala',
    'text_copied_clipboard'                           => 'Metin panoya kopyalandi!',
    'import_example_csv'                              => 'Örnek bir CSV dosyasi burada bulunabilir',
    'import'                                          => 'Içe aktarmak',
    'address2'                                        => 'Adres 2',
    'use_parent_email'                                => 'Ebeveyn E-postasini Kullan',
    'max_import_records'                              => 'Kayitlari içe aktarmak için maksimum sinir :total_records\'dir.',
    'demo_file_attachment_disabled'                   => 'Demoda dosya ekleri devre disi birakildi',
    'drag_drop_file'                                  => 'Sürüklemek',
    'or'                                              => 'VEYA',
    'browse_file'                                     => 'Dosyaya Gözat',
    'system_setting_and_ui'                           => 'Sistem ayarlari',
    'localization_and_timezone'                       => 'yerellestirme',
    'security'                                        => 'Güvenlik',
    'cleanup_and_backup'                              => 'Temizlemek',
    'attach_quote_pdf'                                => 'Teklif PDF\'i Ekle',
    'attach_payment_receipt'                          => 'Ödeme Fisini Ekle',
    'choose-file'                                     => 'Dosya seçin',
    'important-note'                                  => 'Önemli Not',
    'collapse'                                        => 'Yikilmak',
    'add_task'                                        => 'Görev ekle',
    'recurring_invoice_commissions'                   => 'Yinelenen Fatura Komisyonlari',
    'invoice_commissions'                             => 'Fatura Komisyonlari',
    'percentage'                                      => 'Yüzde',
    'flat_amount'                                     => 'Sabit Tutar',
    'discount-amount'                                 => 'Indirim',
    'discount-type'                                   => 'Indirim Türü',
    'saving'                                          => 'Kaydediliyor...',
    'preparing'                                       => 'hazirlaniyor',
    'allow_line_item_discounts'                       => 'Satir Ögesi Indirimlerine Izin Ver',
    'invalid_price_amount'                            => 'Geçersiz Fiyat Tutari! 0\'dan büyük olmalidir.',
    'light-mode'                                      => 'Isik Modu',
    'dark-mode'                                       => 'Karanlik Mod',
    'system_base_currency'                            => 'Sistem Temel Para Birimi',
    'is_recurring_task'                               => 'Yinelenen Görev',
    'contact_names'                                   => 'Kisi Isimleri',
    'all_client'                                      => 'Tüm Müsteriler',
    'invoice_grand_total'                             => 'Fatura Genel Toplami',
    'recurring_invoice_grand_total'                   => 'Tekrarlayan Fatura Genel Toplami',
    'is_required'                                     => 'Gereklidir?',
    'add-new-client'                                  => 'Yeni Istemci Ekle',
    'client_name_required'                            => 'Istemci adi gerekli',
    'custom_item_text_validate'                       => 'Lütfen :label alanina geçerli bir öge :label girin.',
    'assigned_to_others'                              => 'Digerlerine Atandi',
    'all_tasks_and_all_users'                         => 'Tüm görevler/Tüm kullanicilar',
    'statement'                                       => 'Ifade',
    'profile_code'                                    => 'Profil Kodu',
    'login-url'                                       => 'Giris URL\'si',
    'url_copied_clipboard'                            => 'URL panoya kopyalandi!',
    'payment_receipt_email_sent'                      => 'Ödeme makbuzu e-postasi basariyla gönderildi',
    'edit_payment_note_form'                          => 'Ödeme Notunu Düzenle',
    'payment_invoices_text'                           => 'Tesekkürler! :amount ödemeniz sonraki faturalara yansitildi.',
    'payment_text'                                    => ':amount ödemeniz için tesekkür ederiz.',
    'date_filter_by'                                  => 'Tarihe Göre Filtrele',
    'filter_by_invoice_date'                          => 'Fatura tarihi',
    'filter_by_payment_date'                          => 'Ödeme tarihi',
    'date-range-required'                             => 'Lütfen Tarih Araligi seçiniz',
    'save-and-complete'                               => 'Kaydet ve Tamamla',
    'completion-note'                                 => 'Tamamlama Notu',
    'complete-with-note'                              => 'Not ile tamamlayin',
    'placeholder_type_note'                           => 'Notlarinizi yazin...',
    'credit_memo_email_subject'                       => 'Alacak Dekontu E-posta Konusu',
    'default_credit_memo_email_body'                  => 'Varsayilan Alacak Dekontu E-posta Gövdesi',
    'show_invoices_from'                              => 'Faturalari Göster',
    'system_mail_from_address'                        => 'Adresten Sistem Postasi',
    'user_who_created_invoice'                        => 'Faturayi Olusturan Kullanici',
    'completed'                                       => 'Tamamlanmis',
    'no_auth_to_view_task'                            => 'Bu görev artik listenizde yok.',
    'credit-memo-and-prepayments'                     => 'Krediler ve Ön Ödemeler',
    'all_selected'                                    => 'Tümü Seçildi',
    'select_columns'                                  => 'Sütunlari Seçin',
    'column_settings'                                 => 'Sütun Ayarlari',
    'minimum_one_column_check_is_required'            => 'Lütfen en az bir sütun seçin',
    'date_of_entry'                                   => 'Giris tarihi',
    'amount_applied'                                  => 'Uygulanan Tutar',
    'date_applied'                                    => 'Uygulanan tarih',
    'copy_to_recurring_invoice'                       => 'Düzenli Faturaya Kopyala',
    'top_bar_color'                                   => 'Üst Çubuk Rengi',
    'light_grey'                                      => 'Açik gri',
    'bg-primary'                                      => 'Mavi',
    'bg-warning'                                      => 'Sari',
    'bg-info'                                         => 'yusufçuk mavi',
    'bg-danger'                                       => 'Kirmizi',
    'bg-success'                                      => 'Çim Yesili',
    'bg-indigo'                                       => 'indigo',
    'bg-lightblue'                                    => 'Victoria Mavisi',
    'bg-navy'                                         => 'Lacivert',
    'bg-purple'                                       => 'Mor',
    'bg-fuchsia'                                      => 'Fusya',
    'bg-pink'                                         => 'Pembe',
    'bg-maroon'                                       => 'bordo',
    'bg-orange'                                       => 'Turuncu',
    'bg-lime'                                         => 'Limon yesili',
    'bg-teal'                                         => 'deniz mavisi',
    'bg-olive'                                        => 'zeytin',
    'fee_name'                                        => 'Ücret Adi',
    'fee_percentage'                                  => 'Ücret Yüzdesi',
    'fee_explanation'                                 => 'Ücret Açiklamasi',
    'enable_online_payment_processing_fees'           => 'Çevrimiçi Ödeme Isleme Ücretlerini Etkinlestirin',
    'allow_online_payment_processing_fees'            => 'Çevrimiçi Ödeme Isleme ücretlerine izin ver',
    'allow_online_pay_fees'                           => 'Çevrimiçi Ödeme Ücretlerine Izin Ver',
    'convenience_charges'                             => 'Kolaylik Ücretleri',
    'opp-fee-percentage-required'                     => 'Çevrimiçi Ödeme Isleme Ücretleri Yüzdesi Gerekli',
    'opp-fee-percentage-gt-zero'                      => 'Çevrimiçi Ödeme Isleme Ücretleri Yüzdesi Sifirdan Büyük Olmalidir',
    'cron_error'                                      => ':datetime\'de basarisiz oldu',
    'cron_start'                                      => 'Günlük görev çalistirici :datetime\'de basladi',
    'notification_clear_all'                          => 'Tüm bildirimleri temizle',
    'show'                                            => 'Göstermek',
    'report'                                          => 'Bildiri',
    'profit_loss'                                     => 'Kar ve zarar',
    'credit_and_pre_payments'                         => 'Krediler ve Ön Ödemeler',
    'expenses_vendors'                                => 'Gider Saticilari',
    'expenses_categories'                             => 'Gider Kategorileri',
    'create'                                          => 'Yaratmak',
    'import_map_clients'                              => 'Harita Istemcilerini Içe Aktar',
    'payctr_users'                                    => 'Ödeme Merkezi Kullanicilari',
    'ctrl_plus_click'                                 => 'Tamamlama Notlari Eklemek için Ctrl-Tiklayin',
    'edit_note'                                       => 'Notu Düzenle',
    'save-and-unComplete'                             => 'Kaydet ve Tamamlamayi Geri Al',
    'sales_chart'                                     => 'Satis Grafigi',
    'accumulate_totals'                               => 'Toplamlari Biriktir',
    'do_not_accumulate_totals'                        => 'Toplamlari Biriktirme',
    'kpi_cards'                                       => 'KPI Kartlari',
    'no_data_to_display'                              => 'Gösterilecek bilgi yok',
    'choose_period'                                   => 'Dönem Seçin',
    'date_mailed'                                     => 'Gönderim Tarihi',
    'date_emailed'                                    => 'E-postayla Gönderilme Tarihi',
    'action'                                          => 'Eylem',
    'mail'                                            => 'Posta',
    'mark_as_mailed'                                  => 'Posta Olarak Isaretle',
    'invoice_mailed'                                  => 'Fatura Postalandi olarak isaretlendi',
    'emailed'                                         => 'e-postayla gönderildi',
    'paid_invoice_canceled_error'                     => 'Bu faturayi Iptal etmek için lütfen ödemeleri faturadan silin.',
    'allow_invoice_delete'                            => 'Fatura Silme Izin Ver',
    'allow_child_accounts'                            => 'Alt Hesaplara Izin Ver',
    'third_party_bill_payer'                          => '3. Taraf Fatura Ödeyicisi',
    'invoices_paid_by'                                => 'Ödenen Faturalar',
    'use_third_party_bill_payer_email'                => 'Üçüncü Taraf Fatura Ödeyen E-postasini Kullanin',
    'email_default'                                   => 'E-posta Varsayilani',
    'client_default'                                  => 'Istemci Varsayilani',
    'clear-all'                                       => 'Hepsini temizle',
    'system_log_is_missing_or_empty'                  => 'Sistem Günlügü eksik veya bos',
    'change_to_draft'                                 => 'Taslaga Degistir',
    'invoice_status_change_to_draft'                  => 'Fatura Durumu Taslak Olarak Degistirildi',
    'there_is_some_error'                             => 'Bazi Hatalar Var',
    'filter_by_date'                                  => 'Tarihe Göre Filtrele',
    'quote_grand_total'                               => 'Alinti Genel Toplam',
    'email_upcoming_payment_due_notice'               => 'Yaklasan Ödeme Bildirimini E-postayla Gönder',
    'email_overdue_invoice_reminder'                  => 'E-posta Gecikmis Fatura Hatirlatma',
    'page_totals'                                     => 'Sayfa Toplamlari',
    'categories'                                      => 'Kategoriler',
    'conven_charges'                                  => 'Döns. Masraflar',
    'invoice_status_change_to_cancel'                 => 'Iptal Edilecek Fatura Durumu Degisikligi',
    'filter_by_invoice_number'                        => 'Fatura numarasi',
    'filter_by_client_name'                           => 'Müsteri Adi',
    'custom_mail_template'                            => 'Özel Posta Sablonu',
    'invoice_use_custom_mail_template'                => 'Fatura Kullanim Özel Posta Sablonu',
    'client_or_company_name'                          => 'Müsteri/Sirket Adi',
    'view_invoice'                                    => 'Faturayi Görüntüle',
    'tt_active'                                       => 'Bir müsteri kaydi aktif olmadiginda, varsayilan müsteri listesinde görünmezler ve normal islemlere izin verilmez.',
    'tt_invoice_prefix'                               => 'Bir müsteri kaydi olusturuldugunda, benzersiz bir fatura ön ek kodu otomatik olarak atanir. Daha sonra manuel olarak degistirilebilir. Fatura numaralandirma için belge numaralandirma planinizin bir parçasi olarak kullanilabilir ve müsteri basina benzersiz bir fatura numarasina izin verir.',
    'tt_automatic_email_payment_receipts'             => 'Ödeme aldiktan sonra müsteriye e-postayla gönderilen bir ödeme makbuzu gönderir. Sistem Ayarlari\'nda genel bir ayar mevcuttur, ancak bireysel müsteri bazinda geçersiz kilinabilir.',
    'tt_automatic_email_on_recur'                     => 'Yinelenen bir fatura çalistirildiginda müsteriye e-postayla gönderilen bir fatura gönderir ve canli bir fatura olusturur. Sistem Ayarlari\'nda genel bir ayar mevcuttur, ancak bireysel müsteri bazinda geçersiz kilinabilir.',
    'tt_default_currency'                             => 'Fatura, teklif ve ödeme islemlerinde kullanilacak olan bu müsteri hesabina atanan para birimi. Bu deger, Temel Para Birimi için Sistem Ayarindan varsayilandir.',
    'tt_language'                                     => 'Müsteri merkezinde oturum açtiklarinda müsteri için görüntülenecek dil.',
    'tt_allow_client_center_login'                    => 'Istemcinin FusionInvoice müsteri merkezinizde oturum açmasina izin verilmeli mi? E-postalari, kullanici adi olarak kullanilmali ve bir sifre atamaniz gerekir. Müsteri merkezi URL\'si:',
    'tt_timezone'                                     => 'Istemci için saat dilimi. Girilirse, müsterinin yerel saati Müsteri sayfasi görünümünün üst kisminda görüntülenecektir.',
    'tt_allow_online_payment_processing_fees'         => 'Çevrimiçi ödeme isleme ücretleri, genel fatura baglantisini (fatura e-postasinda bulunur) kullanarak kredi kartiyla ödeme yapan müsteriler için degerlendirilebilir. Bu seçenegin genel bir sistem ayari vardir, ancak bireysel müsteri bazinda da geçersiz kilinabilir.',
    'tt_allow_child_accounts'                         => 'Alt Hesaplara Izin Ver ögesini Evet olarak ayarlamak, bu istemcinin bir Ana Hesap olarak hareket etmesini saglar ve Ana Hesaplar listesinden seçmenize izin verir.',
    'tt_third_party_bill_payer'                       => 'Üçüncü taraf fatura ödeyen, müsterileri için fatura ödeyen bir kurulustur, örnegin harici bir muhasebe firmasi.',
    'tt_parent_account'                               => 'Bu müsterinin iliskili oldugu veya bir yan kurulusu olan ana isletme. Bu liste, Alt Hesaplara Izin Ver ayarinin Evet olarak ayarlandigi müsteri kayitlarini içerir. Müsterinin ana hesabi yoksa bos birakin.',
    'tt_invoices_paid_by'                             => 'Bu müsterinin faturalarini ödemek için kullandigi üçüncü taraf isi. Bu liste, 3. Sahis Fatura Ödeyen ayarinin Evet olarak ayarlandigi müsteri kayitlarini içerir. Müsteri kendi faturalarini ödüyorsa bos birakin.',
    'tt_email_default'                                => 'Bu müsteriye e-posta gönderirken, kullanilmasi gereken e-postayi seçin. Bu müsterinin iliskilendirilmis bir Ana Hesabi veya Faturalari Ödenen hesabi varsa, bu seçeneklerden biri seçilebilir. Varsayilan, standart müsteri e-postasidir.',
    'tt_default_to'                                   => 'E-posta gönderirken, bu kisi otomatik olarak \'To:\' alicilar listesine eklenmeli mi?',
    'tt_default_cc'                                   => 'E-posta gönderirken, bu kisi otomatik olarak \'CC:\' alicilar listesine eklenmeli mi?',
    'tt_default_bcc'                                  => 'E-posta gönderirken, bu kisi otomatik olarak \'BCC:\' alicilar listesine eklenmeli mi?',
    'tt_client_type'                                  => 'Lead, vasifsiz bir satis adayidir. Potansiyel Müsteri, yakinda müsteri olabilecek nitelikli bir adaydir. Müsteri, mal veya hizmet sattiginiz (veya yakinda satacaginiz) bir isletme veya kisidir. Bir Bagli Kurulus, mallarinizi veya hizmetlerinizi yeniden satan bir isletme veya kisidir. Diger, dogrudan is yapmadiginiz Üçüncü Sahis Fatura Ödeyenler veya Ana Hesaplar gibi diger türlere uymayan isler için kullanilir.',
    'tt_client_tags'                                  => 'Müsteriler listenizi görüntüleme veya raporlama için kategorilere ayirmaniza veya filtrelemenize yardimci olmasi için bir müsteriye etiketler atanabilir.',
    'tt_important_note'                               => 'Buraya girilen bir not otomatik olarak ÖNEMLI! Istemci kaydi görüntülendiginde pencere.',
    'tt_gen_header_title_text'                        => 'Logonuzun yaninda sol üst kösede görüntülenen metin, genellikle sirketinizin adidir.',
    'tt_gen_default_company_profile'                  => 'Yeni faturalar, fiyat teklifleri vb. olustururken varsayilan olarak kullanilacak sirket profili. Sirket profilleri, farkli sirket adlari, logolar, fatura biçimleri vb. saglayarak isletmenizi her profilde farkli sekilde sunmaniza olanak tanir.',
    'tt_gen_address_format'                           => 'Tek adres alanini veya sehir, eyalet, ülke vb. gibi ayri adres alanlarinin bir kombinasyonunu kullanarak faturalarda ve tekliflerde gösterilen adres biçimini olusturmaniza olanak tanir.',
    'tt_gen_custom_fields_columns'                    => 'Özel alanlar, satir basina 1 ila 3 alan arasinda görüntülenebilir.',
    'tt_gen_require_tags_on_client_notes'             => 'Evet olarak ayarlanirsa, \'Destek\' veya \'Satis\' gibi bir müsteri notu eklerken bir etiketin seçilmesini veya girilmesini gerektirir. Bu, notlari kategorize etmek ve aramak için yararlidir.',
    'tt_gen_skin'                                     => 'FI UI\'nizin nasil gösterilmesini istersiniz, Açik veya Koyu mod',
    'tt_gen_top_bar_color'                            => 'Üst baslik çubugunun rengi. Birkaç farkli FusionInvoice kurulumuyla çalisiyorsaniz, bu görsel bir tanimlamaya yardimci olabilir.',
    'tt_gen_results_per_page'                         => 'Müsteriler, faturalar, fiyat teklifleri, giderler vb. gibi tüm liste görünümleri için sayfa basina gösterilen kayit sayisi.',
    'tt_gen_allow_line_item_discounts'                => 'Faturalarda ve tekliflerde satir ögesi iskonto özelligini etkinlestirir veya devre disi birakir.',
    'tt_gen_language'                                 => 'FusionInvoice kurulumunuz için kullanilacak dil. Müsterileriniz için farkli bir dil atayabileceginizi ve onlarin ana dillerini kullanarak FusionInvoice Müsteri Merkezi ile etkilesimde bulunmalarini saglayabileceginizi unutmayin.',
    'tt_gen_date_format'                              => 'Tercih ettiginiz tarih formati',
    'tt_gen_use_24_hour_time_format'                  => '24 veya 12 saatlik saat biçimlerini desteklemeye izin verir.',
    'tt_gen_timezone'                                 => 'Isletmenizin birincil zaman çizelgesi.',
    'tt_gen_base_currency'                            => 'Isletmenizin en sik kullandigi para birimi.',
    'tt_gen_exchange_rate_mode'                       => 'Manuel, fatura olustururken döviz kuru degerini girmenizi saglar. Otomatik, para birimi döviz kurunu getirmek için genel bir API kullanmayi deneyecek. Bu, yalnizca temel para biriminizden farkli bir para birimi kullanarak bir islem girerken kullanilir.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice, satir ögesi basina en fazla 2 vergi alanini destekler. ile seçilen deger, ikinci vergi alanini gösterir veya gizler.',
    'tt_gen_quantity_price_decimals'                  => 'Miktar ve miktar degerleri için gösterilecek ondalik basamak sayisi. Gerekli dogruluk seviyenize göre 0 ila 4 arasinda seçim yapin.',
    'tt_gen_round_tax_decimals'                       => 'Vergi yuvarlama hesaplamalari için gereken ondalik basamak sayisini seçin.',
    'tt_gen_use_captcha_in_login'                     => 'Evet olarak ayarlanirsa, kullanicilarinizin oturum açma sirasinda bir CAPTCHA sorgulama sorusunu yanitlamasini gerektirir.',
    'tt_gen_force_https'                              => 'Bu seçenegi etkinlestirmenizi nadiren öneririz. Kurulumunuzun web sunucunuzda düzgün çalisan bir SSL sertifikasi yoksa FusionInvoice kurulumunuz için sorun yasayabilirsiniz. Bir sunucu yeniden yönlendirme kurali ayarlayarak ayni sonucu elde edebilirsiniz.',
    'dashboard_settings'                              => 'Pano Ayarlari',
    'tt_dashboard_settings'                           => 'Kontrol paneliniz, sirketinizin performansi hakkinda size degerli bilgiler veren önemli is ölçümlerini ve olaylari görüntülemek için kullanilir. Sistem panosu, tüm kullanicilar için varsayilandir, ancak her kullanicinin yapilandirmasinda, her kullanici için belirli ayarlari tanimlayarak sistem varsayilan panosunu geçersiz kilabilirsiniz. Asagidaki ayarlar kontrol panelinizi özellestirmenize olanak tanir.',
    'tt_db_default_time_period'                       => 'KPI Kartlari ve Satis Grafigi gibi bunlari kullanan pano widget\'lari için varsayilan baslangiç ve bitis tarihlerini ayarlar.',
    'tt_db_recent_client_activity'                    => 'Genel fatura veya fiyat teklifi baglantilarinizdan yapilan ödemeler ve görüntülenen faturalar veya fiyat teklifleri gibi müsteri etkilesimlerini gösteren bir pencere ögesi.',
    'tt_db_display_order'                             => 'Bu, pano widget\'larinin görüntülenme sirasini degistirir. 1 en üstte görüntülenecek, 2 1\'den sonra görüntülenecektir, vb.',
    'tt_db_column_width'                              => 'Pano widget\'lari Bootstrap izgara sistemini kullanir ve maksimum sütun genisligi 12\'dir. Sütun genisligini 12 olarak ayarlamak, widget\'in mevcut tüm genisligi kullanmasina neden olur. 6\'ya ayarlamak, iki widget\'in ayni satiri paylasmasina izin verir, 4, 3 widget\'in ayni satiri paylasmasina vb. izin verir.',
    'tt_db_accumulate_totals'                         => 'Bu degerin açik olarak ayarlanmasi, grafiginizin her gün için önceki günlerin toplamlarini içermesine neden olur. Örnegin, 1. gün için satislar 100$, 2. gün için 50$, 3. gün için satislar 125$ idi. Grafik, bu seçenek Evet olarak ayarlandiginda yükselen bir çizgi gösterir. Hayir olarak ayarlandiginda, 2. günde satis satirinda bir düsüs gösterir ve 3. güne yükselir.',
    'tt_db_kpi_cards'                                 => 'Bu renk kodlu kartlar, gösterge tablonuzun üst kisminda temel performans göstergelerini görüntüler.',
    'tt_db_sales_chart'                               => 'Fatura ve ödeme toplamlarini gösteren bir çizgi grafik grafigi.',
    'tt_db_task_list'                                 => 'Bu pencere ögesi, Görev Listesi modülüyle dogrudan kontrol panelinizden çalismaniza olanak tanir.',
    'tt_db_task_list_include_time'                    => 'Bu seçenegin açik olarak ayarlanmasi, görevlerle çalisirken son tarihler için tarih ve saat belirlemenizi saglar. Hayir olarak ayarlandiginda yalnizca tarih degeri kullanilir.',
    'tt_db_timeline'                                  => 'Zaman çizelgesi pencere ögesi, müsteri durumu degisiklikleri, e-postayla gönderilen faturalar, alinan ödemeler, alinan notlar vb. gibi önemli sistem olaylarinin kronolojik ve aranabilir bir listesini görüntüler.',
    'tt_ss_invoices_default_invoice_template'         => 'Yeni faturalar olusturulurken varsayilan olarak kullanilacak sablonu seçin. Özel sablonlar .\\custom\\templates\\invoice_templates\\ içine yerlestirilmeli ve .blade.php uzantisiyla adlandirilmalidir.',
    'tt_ss_invoices_default_doc_scheme'               => 'Yeni faturalar olusturulurken varsayilan olarak kullanilacak belge numarasi düzenini seçin. Belge numarasi semalari, Yapilandirma Ayarlari içinde olusturulabilir ve belge numaralarinizi (faturalar, fiyat teklifleri, kredi notlari) kisisellestirmenize olanak tanir.',
    'tt_ss_invoices_invoice_due_days'                 => 'Fatura (olusturma) tarihinden sonra, faturanin vadesinin gelecegi ve ödenmesinin beklendigi varsayilan gün sayisi.',
    'tt_ss_invoices_automatic_email_ri'               => 'Yinelenen bir fatura çalistirildiginda ve canli bir fatura olusturdugunda, bu canli fatura müsteriye otomatik olarak e-postayla mi gönderilmeli?',
    'tt_ss_invoices_qr_code'                          => 'Varsayilan faturalara ve tekliflere otomatik olarak bir QR kodu yerlestirilmelidir. Özel fatura veya fiyat teklifi sablonlari kullaniyorsaniz QR kodunu özel sablonlariniza eklemek için varsayilan sablonlara bakin.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Bir fatura Taslak durumundaysa ve manuel veya otomatik olarak e-postayla gönderilmisse, fatura tarihine ne olur? Önemli not: Bir fatura e-posta ile gönderildiginde, durum otomatik olarak Taslak\'tan Gönderildi\'ye degistirilecektir.',
    'tt_ss_invoices_recalculate'                      => 'Her fatura için, olusturuldugu tarihten itibaren yapilan her islemi çalistirir ve toplamlari, kalem toplamlarini, vergileri, indirimleri ve fatura toplamlarini yeniden hesaplar. Büyük bir veri kümeniz varsa, bunun çalismasi uzun zaman alabilir.',
    'tt_ss_invoices_due_after'                        => 'Faturanin vade tarihi, fatura tarihi arti buraya girilen gün sayisi olacaktir.',
    'tt_ss_invoices_default_status_filter'            => 'Fatura listesi görüntülenirken varsayilan olarak uygulanacak durum filtresi.',
    'tt_ss_invoices_default_terms'                    => 'Varsayilan fatura sablonunda, faturanin alt kisminda, Hükümler ve Kosullar alaninda görüntülenen terimler metin degeri.',
    'tt_ss_invoices_default_footer'                   => 'Varsayilan fatura sablonunda faturanin altinda görüntülenen alt bilgi metni degeri. Örnegin:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Günlük görev çalistirici (CRON isi) yinelenen bir fatura sablonundan bir canli fatura yürüttügünde ve olusturdugunda, bu yeni olusturulan fatura müsteriye otomatik olarak e-posta ile gönderilmeli mi? Bu, müsteri bazinda müsteri bazinda geçersiz kilinabilir.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Bir ödeme alindiginda, bu ödeme bilgisi müsteriye otomatik olarak e-posta ile mi gönderilmeli?',
    'tt_ss_invoices_online_payment_method'            => 'Bir müsteri genel bir fatura baglantisini kullanarak ödeme yaptiginda atanan ödeme yöntemi. Ödeme yöntemleri Sistem Ayarlari araciligiyla saglanabilir.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Belgede Faturanin veya Fiyat Teklifinin genel URL\'sine yönlendiren bir QR Kodu görüntülenmeli mi?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Kullanicilarin, hatta yönetici kullanicilarin bile faturalari silmesine izin verilmeli mi? Faturalari silmenin daha güvenli ve izlenebilir bir alternatifi, fatura durumunu \'Iptal edildi\' olarak degistirmektir; bu, fatura toplamini sifira degistirir ve çogu liste ve rapordan hariç tutar.',
    'tt_ss_invoices_show_invoices_from'               => 'Faturalar e-posta ile gönderildiginde, bu, Posta Gönderen adresi olarak görüntülenecektir. Önemli not: Yanitla degeri her zaman Sistem Ayarlarinda atanan deger olacaktir -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Fatura görünümünden, fatura Taslak durumundaysa ve e-postayla gönderildiyse, fatura tarihi degismeden mi kalmali yoksa geçerli tarihe mi geçmelidir? Fatura tarihi degisirse vade tarihi de güncellenir.',
    'tt_ss_quotes_default_quote_template'             => 'Yeni teklif olustururken varsayilan olarak kullanilacak sablonu seçin. Özel sablonlar .\\custom\\templates\\quote_templates\\ içine yerlestirilmeli ve .blade.php uzantisiyla adlandirilmalidir.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Yeni teklifler olusturulurken varsayilan olarak kullanilacak belge numarasi düzenini seçin. Belge numarasi semalari, Yapilandirma Ayarlari içinde olusturulabilir ve belge numaralarinizi (faturalar, fiyat teklifleri, kredi notlari) kisisellestirmenize olanak tanir.',
    'tt_ss_quotes_expire_days'                        => 'Teklif (olusturma) tarihinden sonra, teklifin süresinin dolacagi varsayilan gün sayisi. Bir teklifin son kullanma tarihi geçtiginde, piyasa dalgalanmalari vb. Nedenlerle fiyatlandirmanin degisebilecegi anlasilir.',
    'tt_ss_quotes_default_status_filter'              => 'Fatura listesi görüntülenirken varsayilan olarak uygulanacak durum filtresi.',
    'tt_ss_quotes_auto_convert'                       => 'Bir fiyat teklifi onaylandiginda, bu, tekliften otomatik olarak bir fatura olusturulmasina neden olur.',
    'tt_ss_quotes_when_converted_action'              => 'Bir teklif bir faturaya dönüstürüldügünde, ödeme kosullari tekliften mi yoksa varsayilan fatura sartlari ayarindan mi kullanilmalidir?',
    'tt_ss_quotes_default_terms'                      => 'Varsayilan fiyat teklifi sablonunda, Sartlar ve Kosullar alaninda, teklifin alt kisminda görüntülenen sartlar metin degeri.',
    'tt_ss_quotes_default_footer'                     => 'Varsayilan teklif sablonunda, teklifin altinda görüntülenen alt bilgi metni degeri. Örnegin:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Bir teklif Taslak durumundaysa ve manuel veya otomatik olarak e-postayla gönderilirse, teklif tarihine ne olur? Önemli not: Bir fiyat teklifi e-postayla gönderildiginde, durum otomatik olarak Taslak\'tan Gönderildi\'ye degistirilecektir.',
    'tt_ss_quotes_recalculate'                        => 'Olusturuldugu tarihten geçerli tarihe kadar her bir teklif için yapilan her islemi çalistirir ve toplamlari, kalem toplamlarini, vergileri, indirimleri ve teklif toplamlarini yeniden hesaplar. Büyük bir veri kümeniz varsa, bunun çalismasi uzun zaman alabilir.',
    'tt_ss_taxes_default_rate1'                       => 'Faturalara veya fiyat tekliflerine eklenen yeni kalemlere otomatik olarak uygulanmasi gereken birincil vergi orani. Vergi oranlari Yapilandirma yoluyla korunur -',
    'tt_ss_taxes_default_rate2'                       => 'Faturalara veya fiyat tekliflerine eklenen yeni kalemlere otomatik olarak uygulanmasi gereken ikincil vergi orani. Vergi oranlari Yapilandirma yoluyla korunur -',
    'tt_ss_email_send_method'                         => 'FusionInvoice\'un kullanmasi gereken e-posta gönderme yöntemi. Gönderme yönteminin degistirilmesi, gönderme yöntemi için destekleyici alanlarin görüntüsünü de degistirir.',
    'tt_ss_email_allow_self_cert'                     => 'Bu seçenegin açilmasi, PHP correct_peer gereksinimini devre disi birakir. Daha fazla bilgi için internette sunu arayin: PHP e-posta kendinden imzali sertifika openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Bu, e-posta gönderirken, alicilarinizin görecegi varsayilan Yanitlama adresidir.',
    'tt_ss_email_always_cc'                           => 'Varsayilan olarak gönderilen her e-postayla birlikte otomatik olarak CC\'ye eklemek istediginiz bir e-posta adresi.',
    'tt_ss_email_always_bcc'                          => 'Varsayilan olarak, gönderilen her e-posta ile otomatik olarak BCC yapmak istediginiz bir e-posta adresi.',
    'tt_ss_email_send_test_to'                        => 'Test E-postasi Gönder dügmesine tiklandiginda kullanilacak e-posta adresi.',
    'tt_ss_email_mail_from_addr'                      => 'FusionInvoice\'dan e-postalar gönderildiginde kullanilacak varsayilan Posta Gönderen adresi. Not: Sistem Ayarlari içinde -',
    'tt_ss_email_mail_from_name'                      => 'Gönderen kolay ad, gönderilen e-postalarda gösterilecek.',
    'tt_ss_email_email_templates'                     => 'Birçok belge ve etkinlik için e-posta sablonlari mevcuttur, bunlar sunlari içerir: teklifler, teklif onaylari, teklif reddleri, faturalar, vadesi geçen faturalar, kredi notlari, ödeme makbuzlari, yaklasan ödeme bildirimleri. Varsayilan bir sablon dahildir, ancak basit (saglanan varsayilan sablonlar gibi) veya tamamen biçimlendirilmis HTML olabilen özel sablonlar da olusturabilirsiniz.',
    'tt_ss_pdf_driver'                                => 'PDF belgeleri olustururken kullanilacak sürücü. \'wkhtmltopdf\' sürücüsünün seçilmesi, bu programin yerel sunucuda kurulmasini ve bunun için uygun ikili yolun ayarlanmasini gerektirir.',
    'tt_ss_pdf_binary_path'                           => 'wkhtmltopdf için ikili dosyaya giden yerel sunucu yolu. Örnegin C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice, birkaç çevrimiçi ödeme saglayicisini destekler. Hesap olusturdugunuz saglayicilari etkinlestirin. Burada etkinlestirilen saglayicilar, müsterileriniz faturalarini genel fatura baglantisini (varsayilan fatura e-postasinda bulunur) kullanarak görüntülediklerinde ödeme seçenekleri olarak görüntülenecektir.',
    'tt_ss_olp_api_key'                               => 'API anahtari size ödeme saglayiciniz tarafindan saglanir.',
    'tt_ss_olp_payment_button_text'                   => 'Müsterileriniz tarafindan görüntülendigi sekliyle, genel faturanizin üst kisminda, bu ödeme saglayicisi için ödeme yöntemi dügmesinde görüntülenen metin.',
    'tt_ss_olp_mode'                                  => 'Bazi ödeme saglayicilari tarafindan desteklenir, Sandbox\'a daha fazla (test) ve canli izin verir.',
    'tt_ss_olp_client_id'                             => 'Müsteri Kimligi size bu ödeme saglayicisi tarafindan saglanir.',
    'tt_ss_olp_client_secret'                         => 'Müsteri Sirri size bu ödeme saglayici tarafindan saglanir.',
    'tt_ss_olp_publishable_key'                       => 'Yayinlanabilir Anahtar size bu ödeme saglayici tarafindan saglanir.',
    'tt_ss_olp_secret_key'                            => 'Gizli Anahtar size bu ödeme saglayici tarafindan saglanmaktadir.',
    'tt_ss_olp_opp_fees_about'                        => 'Çevrimiçi ödeme isleme ücretleri, genel fatura baglantisini (fatura e-postasinda bulunur) kullanarak kredi kartiyla ödeme yapan müsteriler için degerlendirilebilir.',
    'tt_ss_olp_enable_opp_fees'                       => 'Çevrimiçi ödeme isleme ücretleri, genel fatura baglantisini (fatura e-postasinda bulunur) kullanarak kredi kartiyla ödeme yapan müsteriler için degerlendirilebilir. Bu seçenegin genel bir sistem ayari vardir, ancak bireysel müsteri bazinda da geçersiz kilinabilir.',
    'tt_ss_olp_opp_fee_pct'                           => 'Çevrimiçi ödeme isleme (kolaylik) ücreti olarak tahsil edilecek fatura toplaminin yüzdesi.',
    'tt_ss_olp_opp_fee_name'                          => 'Faturada gösterilecek ücret adi. yani. \'Kredi Karti Kolaylik Ücreti\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Faturada görüntülenecek ücretin açiklamasi. yani. \'Tüm kredi karti islemlerinden %3 komisyon alinmaktadir\'',
    'tt_company_profiles_about'                       => 'Sirket profilleri, farkli sirket adlarina, logolara, fatura biçimlerine vb. olanak taniyarak isletmenizi her profilde farkli sekilde sunmaniza olanak tanir. Ayni FusionInvoice kurulumunda birden çok sanal sirkete sahip olmanin bir yolunu sunar. Sistem Ayarlari\'nda varsayilan bir sirket profili seçilmelidir.',
    'tt_users_about'                                  => 'Yönetici (tam erisim) veya Standart (bireysel sistem izinleri verilmelidir) türünde kullanicilar olusturabilirsiniz. Bir müsteri kaydi için \'Müsteri Merkezinde Oturum Açmaya Izin Ver\' seçeneginin Evet olarak ayarlanmasi, müsteri için otomatik olarak bir Kullanici kaydi ekleyecektir, ancak Müsteri kullanicilari yalnizca Istemci ayarlari arabirimi kullanilarak eklenebilir.',
    'tt_users_client_about'                           => 'Müsteri kullanicilari, yalnizca faturalarini, fiyat tekliflerini ve ödemelerini sinirli bir sekilde görmelerine olanak taniyan Müsteri Merkezi\'nde oturum açabilir. Bir müsteri kaydi için \'Müsteri Merkezinde Oturum Açmaya Izin Ver\' seçeneginin Evet olarak ayarlanmasi, bu kisinin Müsteri Merkezine erismesine izin verir.',
    'tt_user_types_about'                             => 'Yönetici kullanicilar tam sistem erisimine sahiptir. Standart kullanicilara, ihtiyaç duyduklari bireysel izinler verilebilir. Istemci kullanicilari, yalnizca Müsteri Merkezi içindeki belirli bilgilerine erisebilir ve oturum açma yetenekleri Müsteri Ayarlari\'nda ayarlanir -',
    'tt_custom_fields_about'                          => 'Özel alanlar, çogu modüle kendi veri alanlarinizi eklemenizi saglar. Müsteriler için sektörü yakalamaniz gerekiyorsa, Müsteriler sayfasinda \'Endüstri\' etiketli özel bir alan ekleyerek onu bir Açilir liste türü haline getirmeniz yeterlidir. Özel alanlar otomatik olarak normal alanlarin altinda görüntülenir.',
    'tt_recurring_invoices_about'                     => 'Yinelenen Faturalar aslinda fatura degil, gelecekteki faturalari olusturmak için sablonlardir. Canli bir faturayi ne zaman olusturacaklarini belirleyen bir yinelenme sikligi ve Sonraki Tarih vardir. Yinelenen faturalarin düzgün çalismasi için günlük bir CRON isi veya planlanmis görev gereklidir.',
    'tt_addons_about'                                 => 'Eklentiler, zaman takibi, fiyatlandirma fürmulalari veya stilize edilmis fatura sablonlari gibi benzersiz is ihtiyaçlari için FusionInvoice\'a yönelik özellestirmelerdir. FusionInvoice eklenti pazari araciligiyla sunulurlar.',
    'client_center_user'                              => 'Müsteri Merkezi Kullanicisi',
    'user_type'                                       => 'Kullanici tipi',
    'custom_field'                                    => 'Özel alan',
    'placeholder_type_email_template'                 => 'E-posta sablonunuzu yazin veya yapistirin. . .',
    'email_templates'                                 => 'E-posta Sablonlari',
    'payment_receipts'                                => 'Ödeme Makbuzlari',
    'upcoming_payment_notices'                        => 'Yaklasan Ödeme Bildirimleri',
    'convenience_fee_for_credit_card_transactions'    => 'Kredi Karti Islemlerinde Kolaylik Ücreti',
    'credit_card_processing_fee'                      => 'Kredi Karti Islem Ücreti',
    'delete_client_user_warning'                      => '<p>Bir müsteri kullanicisini silmek, müsteri merkezinde oturum açma yeteneklerini devre disi birakacaktir.</p>',
    'use_default_mail_template'                       => 'Varsayilan Posta Sablonu',
    'use_custom_mail_template'                        => 'Özel Posta Sablonu',
    'quote_email_body'                                => 'Alinti E-posta Gövdesi',
    'overdue_invoice_email_body'                      => 'Vadesi Geçmis Fatura E-posta Gövdesi',
    'credit_memo_email_body'                          => 'Alacak Dekontu E-posta Gövdesi',
    'payment_receipt_body'                            => 'Ödeme Makbuzu Gövdesi',
    'invoice_email_body'                              => 'Fatura E-posta Gövdesi',
    'quote_custom_email_body_require'                 => 'Lütfen teklif e-posta gövdesi için özel e-posta sablonunuzu girin',
    'quote_custom_approve_email_body_require'         => 'Lütfen fiyat teklifi onaylama e-posta gövdesi için özel e-posta sablonunuzu girin',
    'quote_reject_email_body_require'                 => 'Lütfen teklif reddi e-posta gövdesi için özel e-posta sablonunuzu girin',
    'overdue_invoice_email_body_require'              => 'Lütfen vadesi geçmis fatura e-posta gövdesi için özel e-posta sablonunuzu girin',
    'invoice_email_body_require'                      => 'Lütfen fatura e-posta gövdesi için özel e-posta sablonunuzu girin',
    'credit_memo_email_body_require'                  => 'Lütfen kredi notu e-posta gövdesi için özel e-posta sablonunuzu girin',
    'payment_receipt_email_body_require'              => 'Lütfen ödeme makbuzu e-posta gövdesi için özel e-posta sablonunuzu girin',
    'upcoming_payment_notice_email_body_require'      => 'Lütfen yaklasan ödeme bildirimi e-posta gövdesi için özel e-posta sablonunuzu girin',
    'copy_text'                                       => 'Metni kopyala',
    'tt_preview_template'                             => 'Önizleme Sablonu',
    'tt_view_template_code'                           => 'Sablon Kodunu Görüntüle',
    'dashboard_date_range'                            => 'Pano Tarih Araligi',
    'tt_dashboard_date_range'                         => 'Pano Tarih Araligi, su pencere ögeleri için görünümü filtreler: KPI Kartlari, Satis Grafigi, Son Müsteri Etkinligi.',
    'product_copy'                                    => 'Ürün Kopyasi',
    'open_selected_client'                            => 'Seçilen Istemciyi Aç',
    'save_this_client'                                => 'Bu Istemciyi Kaydet (kopya degil)',
    'looks_like_duplicate'                            => 'Hmm... Bu kopya gibi görünüyor',
    'duplicate_instructions'                          => 'Istediginiz istemciyi listede görürseniz, onu seçin ve açin. Degilse, yeni istemciyi kaydedin.',
    'select_checkbox'                                 => 'bir müsteri seçin',
    'select_lead_source_tag'                          => 'Potansiyel Müsteri Kaynagini Seçin',
    'lead_source'                                     => 'Öncü kaynak',
    'tt_client_lead_source_tags'                      => 'Müsteri adayi kaynagini seçin veya girin (müsteri nasil edinildi)',
    'your_link_is_expired'                            => 'Hata! Baglantinizin süresi doldu.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Kontrol paneline dön</a>.',
    'secure_link_and_expire_link_days'                => 'Güvenli ve Süresi Dolmus Genel Fatura Baglantilari',
    'secure_link_expire_days'                         => 'Gün sayisi',
    'tt_secure_link_and_expire_link_days'             => 'Güvenli baglantilari etkinlestirirken, fatura baglantisinin sona erecegi gün sayisini da belirlemeniz gerekir. Müsteri bunu yaparak, süresi dolana kadar genel fatura baglantisini görüntüleyebilir.',
    'expire_time_period'                              => 'Baglanti Sona Erme Gün Sayisi alani zorunludur',
    'enter_days'                                      => 'Günleri Girin',
    'invalid_field_name'                              => 'Lütfen geçerli bir alan adi girin',
    'lead_source_notes'                               => 'Kursun Kaynak Notlari',
    'important_note'                                  => 'Önemli Not',
    'social_media_url'                                => 'Sosyal Medya URL\'si',
    'general_notes'                                   => 'Genel Notlar',
    'payment_amount_mismatch'                         => 'Ödeme Tutari Uyusmazligi',
    'open_invoice_aging'                              => 'Açik Fatura Yaslandirma',
    'tt_db_open_invoice_aging'                        => 'Açik Fatura Yaslandirma',
    'current'                                         => 'Akim',
    'oneToThirty'                                     => '1-30 Gün',
    'thirtyOneToSixty'                                => '31-60 Gün',
    'sixtyOneToNinety'                                => '61-90 Gün',
    'ninetyOnePlus'                                   => '91 Gün',
    'sent_and_draft'                                  => 'Hem Gönderilmis Hem Taslak Faturalari Dahil Et',
    'sent_only'                                       => 'Yalnizca Gönderilmis Faturalari dahil et',
    'tt_open_ar_aging_settings'                       => 'Açik Fatura Yaslandirma Toplamlari Ayarlari',
    'tt_client_field_settings'                        => 'Istemci görünümünüzde görüntülenmesini istediginiz alanlari seçin',
    'position_change'                                 => 'pozisyon degisti',
    'dynamic_width'                                   => 'dinamik genislik',
    'full_width'                                      => 'Tam genislik',
    'save_configuration_default'                      => 'Yapilandirmayi sistem varsayilani olarak kaydet',
    'assign_configuration_other'                      => 'Yapilandirmayi diger kullanicilara atama',
    'tt_user_tags'                                    => 'Kullanici Etiketleri',
    'select_users'                                    => 'Kullanicilari Seçin',
    'configuration_assigned'                          => 'Yapilandirma basariyla atandi',
    'default_configuration_set'                       => 'Varsayilan yapilandirma basariyla ayarlandi',
    'current_user_id'                                 => 'mevcut kullanici kimligi',
    'tt_users_settings'                               => 'Kullanici ayarlari',
    'invoice_link_expire'                             => 'Fatura genel baglantinizin süresi su tarihte dolacak:',
    'quote_link_expire'                               => 'Alinti genel baglantinizin süresi su tarihte dolacak:',
    'dashboard_width'                                 => 'Dashboard :widthName sütun genisligi ayari degistirildi',
    'unmark_mailed'                                   => 'Posta olarak isaretini kaldir',
    'invoice_unmark_mailed'                           => 'Faturanin postalandi olarak isaretini kaldir',
    'print_mark_mailed'                               => 'Yazdir',
    'public_link'                                     => 'Genel Baglanti',
    'tt_sales_chart_settings'                         => 'Satis tablosu faturasi/toplam ayari',
    'verify_key'                                      => 'Ürün Anahtari Dogrulamasi',
    'enter_key'                                       => 'anahtarinizi girin',
    'verify'                                          => 'Dogrula!',
    'key_required'                                    => 'Ürün anahtari gerekli',
    'key_length_invalid'                              => 'Lütfen satin alma sirasinda saglanan 32 karakterlik ürün anahtarini girin.',
    'invalid_key'                                     => 'Üzgünüz, anahtariniz geçersiz. Kurulum devam edemiyor.',
    'key_verified'                                    => 'Tebrikler, anahtariniz dogrulandi.',
    'clear_cache'                                     => 'Önbellegi Temizle',
    'clear_cache_confirm'                             => 'Uygulama önbelleginizi temizlemek istediginizden emin misiniz?',
    'cache_clear_success'                             => 'Önbellek basariyla temizlendi.',
    'cache_clear_error'                               => 'Lütfen PHP exec() komutu için sunucu yapilandirmanizi kontrol edin.',
    'add_new_client'                                  => 'yeni müsteri ekle',
    'add'                                             => 'Eklemek',
    'invalid_quantity_amount'                         => 'Geçersiz Miktar Tutari! 0\'dan büyük olmalidir.',
    'api_version'                                     => 'API Sürümü',
    '2021_prior'                                      => '2021 ve Öncesi',
    '2022_later'                                      => '2022 ve Sonrasi',
    'vendors'                                         => 'Saticilar',
    'file_not_found'                                  => ':file_name bulunamadi',
    'leave_empty_no_parent_account'                   => 'müsterinin ebeveyn hesabi yoksa bos birakin',
    'leave_empty_client_pays_invoices'                => 'müsteri kendi faturalarini ödüyorsa bos birakin',
    'modal_not_found'                                 => 'Kip bulunamadi',
    'payment_delete_success'                          => 'Ödeme basariyla silindi',
    'payment_delete_error'                            => 'Ödeme silinirken bir sorun olustu, lütfen daha sonra tekrar deneyin.',
    'status_change_error'                             => 'Bir seyler yanlis gitti! Durum degistirilmedi.',
    'total_payments'                                  => 'Toplam tutar',
    'licence_verification_error'                      => 'Lisans anahtariniz dogrulanamiyor.',
    'line_item_discount_limit'                        => 'Satir ögelerinin indirimi %99,99\'dan fazla olamaz.',
    'date_range_report'                               => 'Tarih Araligi (çalistirilacak bir sonraki tarih)',
    'no_client_found'                                 => 'Hmmm... o müsteriyi bulamadik.',
    'tt_line_item_discount'                           => 'Satir ögesi indirimi, fiyatin yüzdesi veya tek tek öge fiyati için sabit bir tutar olarak hesaplanabilir.',
    'functionality_not_available_on_demo'             => 'Üzgünüz, demoda bu isleve izin verilmiyor.',
    'vat_tax_id'                                      => 'KDV Kimligi',
    'tt_vat_tax_id'                                   => 'katma deger vergisi (KDV) numarasi',
    'enable_vat_tax_id'                               => 'KDV numarasi etkinlestirilsin mi',
    'no-attachment'                                   => 'ek yok',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Temizlemek',
    'allow_edit_status_invoice'                       => ':status Faturasini Düzenle',
    'tt_ss_allow_edit_invoices_status'                => 'Güvenlik önlemi olarak sadece Taslak durumundaki faturalar düzenlenebilir. Gönderilen ve/veya Ödenen faturalarin düzenlenmesine izin vererek bunu geçersiz kilabilirsiniz.',
    'allow_edit_invoices_status'                      => 'Durumdaki faturalarin düzenlenmesine izin ver',
    'draft_and_sent'                                  => 'Taslak ve Gönderildi',
    'draft_or_sent_and_paid'                          => 'Taslak, Gönderilen ve Ödenen',
    'invoice_editable'                                => 'Fatura Düzenlenebilir',
    'can_not_edit_paid_invoice'                       => 'Ödenmis bir faturayi düzenleyemezsiniz',
    'item_category'                                   => 'Öge Kategorisi',
    'itemLookups'                                     => 'Öge Aramalari',
    'quoteItems'                                      => 'Teklif Ögeleri',
    'invoiceItems'                                    => 'Fatura Ögeleri',
    'imports_disabled_in_demo.'                       => 'Demoda içe aktarma devre disi birakildi.',
    'no_file_selected'                                => 'Dosya seçilmedi',
    'no_import_records'                               => 'Içe aktarilacak kayit bulunamadi',
    'vendor_name'                                     => 'Satici adi',
    'license_key'                                     => 'Lisans anahtari',
    'change_license_key'                              => 'Lisans Anahtarini Degistir',
    'verify_and_save'                                 => 'Dogrulamak',
    'same_key_error'                                  => 'Degisiklik algilanmadi. Lütfen farkli bir anahtar deneyin',
    'trying_invalid_key'                              => 'Maalesef bu anahtar dogrulanamadi. Lisans anahtari degistirilmedi.',
    'key_updated'                                     => 'Tebrikler! Lisans anahtariniz basariyla güncellendi.',
    'invalid_date_format'                             => 'Geçersiz tarih biçimi. Gerekli format: YYYY-AA-GG',
    'invalid_datetime_format'                         => 'Geçersiz TarihSaat Biçimi. Gerekli format: YYYY-AA-GG SS:DD :SS',
    'profile_setting'                                 => 'Profil ayarlari',
    'include_draft_invoices_unpaid_and_overdue'       => 'Taslak Faturalari Ödenmemis ve Vadesi Geçmis Listelere Dahil Et',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Evet olarak ayarlanirsa, durumu Taslak olan faturalar Vadesi Geçmis ve Ödenmemis faturalar için listelere ve hesaplamalara dahil edilir.',
    'tt_utilities_import'                             => 'CSV dosyalarindaki verileri FusionInvoice veritabaniniza aktarin.',
    'tt_utilities_export'                             => 'FusionInvoice veritabaninizdaki verileri bir dizi farkli formata aktarin: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'FusionInvoice içindeki tüm e-posta olaylarini tutan günlük dosyasini görüntüleyin.',
    'tt_utilities_system_log'                         => 'Hata ve uyari sistemi olaylarini içeren sistem günlük dosyasini görüntüleyin.',
    'tt_utilities_tag_cleanup'                        => 'Tanimlanmis ancak kullanilmayan etiketleri kaldirir. Ayrica yinelenen etiketleri de kaldirir.',
    'tt_utilities_pdf_cleanup'                        => 'Geçici PDF dosyalarini kaldirir.',
    'tt_utilities_recalc_invoices'                    => 'Indirimleri ve vergiyi hesaba katarak toplamlarin tüm satir ögelerinin toplamiyla eslestiginden emin olmak için her faturayi tarar. *Bu uzun zaman alabilir.',
    'tt_utilities_recalc_quotes'                      => 'Indirimleri ve vergiyi hesaba katarak toplamlarin tüm satir ögelerinin toplamiyla eslestiginden emin olmak için her bir teklifi tarayin. *Bu uzun zaman alabilir.',
    'tt_utilities_clear_cache'                        => 'Geçici önbellek dosyalarini kaldirir.',
    'tt_utilities_download_database'                  => 'Canli FusionInvoice verilerinizden disa aktarilan bir veritabani dosyasini indirin. Veritabaniniz ne kadar büyükse bu islem o kadar uzun sürecektir.',
    'tt_utilities_run_daily_tasks'                    => 'Bir CRON isi veya zamanlanmis görev normalde günlük görevlerinizi yürütür. Bu, bunu manuel olarak yapmanizi saglar. Yinelenen fatura sablonlarindan canli faturalar olusturur, ödeme hatirlaticilari gönderir vb.',
    'include_line_item_detail'                        => 'Satir Ögesi Ayrintilarini Dahil Et',
    'invoice_tags'                                    => 'Fatura Etiketleri',
    'related_accounts'                                => 'Ilgili Hesaplar',
    'not_found_related_clients'                       => 'Iliskili müsteri hesabi atanmadi',
    'invoices_paid_for_list'                          => 'Bu müsteri hesabi su faturalari öder:',
    'child_accounts_exist'                            => 'Çocuk Hesaplarina Izin Ver ayari, Evet\'e döndürüldü. Alt hesaplar varken Hayir olarak degistirilemiyor.',
    'third_bp_accounts_exist'                         => '3. Sahis Fatura Ödeyen ayari, Evet\'e döndürüldü. Ilgili hesaplar varken Hayir olarak degistirilemiyor.',
    'tag_name'                                        => 'Etiket adi',
    'tag_new_name'                                    => 'Yeni Etiket Adi',
    'tag_category'                                    => 'Etiket Kategorisi',
    'rename_tags'                                     => 'Etiketleri Yeniden Adlandir',
    'apply'                                           => 'Uygula',
    'select_tag_category'                             => 'Etiket Kategorisini Seçin',
    'tt_utilities_rename_tags'                        => 'Müsterilere, notlara, satis etkinliklerine vb. atanan etiketleri yeniden adlandirin.',
    'system_default_dashboard'                        => 'Sistem Varsayilan Panosu',
    'user_specific_dashboards'                        => 'Kullaniciya Özel Panolar',
    'tt_default_client_type'                          => 'Varsayilan Istemci Türü',
    'default_client_type'                             => 'Varsayilan Istemci Türü',
    'invalid_user'                                    => 'Lütfen geçerli bir kullanici seçin.',
    'create_live_invoice'                             => 'Canli Fatura Olustur',
    'create_live_invoice_successfully'                => 'canli fatura',
    'create_live_invoice_unsuccessfully'              => 'Canli fatura olusturulmadi',
    'live_invoice_not_generate'                       => 'Durdurma Tarihi bugün veya öncesi olan ya da Sonraki Tarihi 30 günden daha ileri olan bir Yinelenen Faturadan canli fatura olusturulamaz.',
    'data_seeder'                                     => 'Veri Ekme Makinesi',
    'select_module'                                   => 'Modül Seçin',
    'number_of_seed'                                  => 'Tohum Sayisi',
    'seed_it'                                         => 'Tohumlayin!',
    'seeds_success'                                   => 'Tohumlar basariyla eklendi',
    'tt_ri_generate_the_next_live_invoice'            => 'Bu yinelenen fatura için hemen simdi bir sonraki canli faturayi olusturun.',
    'system_log_clear_message'                        => 'Sistem günlügünü temizlemek istediginizden emin misiniz? Bu islem geri alinamaz ve önceki tüm günlükler kalici olarak silinir.',
    'system_log_clear_successfully'                   => 'Sistem Günlügü Basariyla Temizlendi',
    'payment_problem'                                 => 'Ödeme sirasinda bir sorun olustu. Lütfen daha sonra tekrar deneyiniz.',
    'log_detail'                                      => 'Detay günlügünü görüntülemek için buraya tiklayin.',
    'log_limit_message'                               => 'Log dosyasi',
    'log_download_file'                               => 'Dosyayi indir',
    'log_delete_all'                                  => 'Tüm dosyalari sil',
    'log_level'                                       => 'Seviye',
    'log_context'                                     => 'Baglam',
    'log_date'                                        => 'Tarih',
    'log_line_number'                                 => 'Satir numarasi',
    'log_content'                                     => 'Içerik',
    'addon_install_error'                             => 'Eklenti kurulumunda bir sorun olustu, lütfen daha sonra tekrar deneyiniz.',
    'addon_installed_success'                         => 'Eklenti basariyla yüklendi.',
    'allow_edit_status_credit_memo'                   => 'Uygulanan Kredi Notunu Düzenle',
    'database_seeder'                                 => 'Ekme makinesi',
    'tt_utilities_database_seeder'                    => 'Tohum siniflarini kullanarak veritabaninizi test verileriyle tohumlayin',
    'vat_information'                                 => 'KDV Bilgileri',
    'tt_vat_information'                              => 'IBAN Banka Hesap Numarasi, BIC, E-posta vb...',
    'explore_addons'                                  => 'Eklentileri Kesfedin',
    'available_addons'                                => 'Mevcut FusionInvoice Eklentileri',
    'addon_success'                                   => 'Eklenti basariyla eklendi.',
    'payment_cannot_enabled_in_demo'                  => 'Demoda ödeme ag geçitleri etkinlestirilemez',
    'confirm_approve_leave_page'                      => 'Bu sayfada kaydedilmemis degisiklikler var! Kaydetmeden ayrilmak istediginizden emin misiniz?',
    'leave'                                           => 'Ayrilmak',
    'demo_date_refresh'                               => 'Demo verileri su tarihte yenilenecek:',
    'minutes'                                         => 'dakika',
    'minute'                                          => 'dakika',
    'seconds'                                         => 'saniye',
    'mautic-authentication-fail'                      => 'Bu kaynaga erisim yetkiniz yok. Lütfen geçerli bir gizli anahtar kullanin.',
    'something_went_wrong'                            => 'Bir seyler yanlis gitti!',
    'month_to_date'                                   => 'Bu Aydan Bugüne',
    'quarter_to_date'                                 => 'Bu Çeyrek Bugüne Kadar',
    'year_to_date'                                    => 'Bugünden bir yil öncesi',
    'last_active'                                     => 'Son Aktif',
    'database_seeder_stop'                            => ':name IS EKIM DURAGI',
    'database_seeder_start'                           => ':name IS EKIM MAKINESI BASLANGICI',
    'seeder_records_created'                          => ':total :modal Için Kayitlar Basariyla Olusturuldu',
    'seeder_credit_apply_invoice'                     => 'Kredi Dekontu Faturaya Uygula',
    'seeder_quote_approve_reject'                     => 'Alinti Onayla ve Reddet',
    'seeder_executed'                                 => 'Ekme makinesi basariyla yürütüldü!',
    'seeder_not_executed'                             => 'Ekme makinesi idam edilmedi!',
    'db_to_file_system_attachments_migration'         => 'Eklerin Geçisi - Veritabanindan Dosya Sistemine',
    'attachment_content_count'                        => 'Toplamda tasimak üzeresiniz',
    'attachment_repeat_content_count'                 => 'Toplamda tasimak üzeresiniz',
    'attachment_key_invalid'                          => 'Ek anahtari geçersiz',
    'stop'                                            => 'Durmak!',
    'attachment_migration_warning'                    => 'Bu adim, ekleri veritabaninizdan dosya sisteminize tasiyacaktir; lütfen devam etmeden önce tam bir veritabani yedeklemesi gerçeklestirin ve bu islemi gerçeklestirmek için yeterli disk alaniniz oldugundan emin olun.',
    'attachment_agreement_accept'                     => 'Veritabanimi yedekledim.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Microsoft 365 Parolasi',
    'office365_username'                              => 'Microsoft 365 Kullanici Adi',
    'custom_date_formula_note1'                       => '<b><u>Varsayilan Deger Yer Tutuculari :</span></u></b> ~<br> <b>Bugün, yarin ve dün</b> herhangi bir degeri varsayilan olarak kullanabilirsiniz.<br>',
    'custom_date_formula_note2'                       => '<b>Bugün + N gün için, </b> \'varsayilan\' kullanin: \'+7\' Bu, bugünün tarihine 7 gün ekler <br><b>Bugün - N gün için, </b> \'varsayilan\' kullanin: \'-7\' Bu, bugünün tarihinden 7 gün çikaracak <br>',
    'mail_config_error'                               => 'E-posta Gönderme Yöntemi tanimlanmadan test e-postasi gönderilemiyor.',
    'db_prefix_alert'                                 => ':prefix veritabani önekini kullandiginizi fark ettik. FusionInvoice gelecek sürümlerde veritabani öneklerini desteklemeyecektir. Lütfen veritabaninizi düzenleyin ve öneki kaldirarak tüm tablolarinizi yeniden adlandirin, ardindan veritabani.php dosyanizi düzenleyin ve \'önek\' degerinizi bos olarak ayarlayin',
    'db_prefix_alert_title'                           => 'DB Önekleri Destegi Yakinda Sona Eriyor',
    'add_title_bar_shortcut'                          => 'Baslik Çubugu Kisayolu Ekle',
    'title_bar_shortcuts'                             => 'Baslik Çubugu Kisayollari',
    'select_icon'                                     => 'Simge Seç',
    'all_payment_method'                              => 'Tüm ödeme yöntemi',
    'about'                                           => 'Hakkinda',
    'own_license'                                     => 'Kendi Lisansi',
    'tt_own_license'                                  => 'Kendi Lisansi',
    'git_branch'                                      => 'Git Güncel Subesi',
    'quote_email'                                     => 'Alinti E-postasi',
    'custom1'                                         => 'Özel 1',
    'custom2'                                         => 'Özel 2',
    'custom3'                                         => 'Özel 3',
    'default_document_template'                       => 'Varsayilan Belge Sablonu',
    'default_email_template'                          => 'Varsayilan E-posta Sablonu',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Fiyatlandirma Formülü',
    'is_mobile'                                       => 'Mobil mi?',
    'default_sms_template'                            => 'Varsayilan SMS Sablonu',
    'sms_log'                                         => 'SMS Günlügü',
    'two_factor_auth'                                 => 'Iki Faktörlü Kimlik Dogrulama',
    'enabled_mail_driver'                             => 'Lütfen e-posta hizmetini etkinlestirin',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Geçersiz Dogrulama Kodu',
    'otp-subject'                                     => 'OTP\'ye giris yap',
    'resend_otp_success'                              => 'Dogrulama Kodunun Yeniden Gönderilmesi',
    'resend_otp_btn'                                  => 'Yeniden gönderme kodu',
    'expired_otp'                                     => 'Dogrulama Kodu Süresi Doldu',
    'token_expired'                                   => 'CSRF belirtecinizin süresi doldu',
    'verification_code'                               => 'Dogrulama kodu',
    'migration'                                       => 'Göç',
    'invoice_status_change_draft_to_sent'             => 'Taslak olan fatura durumu gönderildi olarak degistirildi',
    'default_sales_quantity'                          => 'Varsayilan Satis Miktari',
    'lead_time'                                       => 'Ortalama Teslim Süresi (gün)',
    'primary_vendor_id'                               => 'Tercih Edilen Satici',
    'all_items'                                       => 'Tüm esyalar',
    'non_inventory_items'                             => 'Envanter Disi Ögeler',
    'back_ordered'                                    => 'Geri Siparis Verildi',
    'low_inventory'                                   => 'Düsük envanter',
    'high_inventory'                                  => 'Yüksek Envanter',
    'merge_client_records'                            => 'Müsteri Kayitlarini Birlestir',
    'primary_merge_to_client'                         => 'Birlestir (tut)',
    'surrogate_merge_from_client'                     => 'Suradan Birlestir (at)',
    'merge'                                           => 'Birlestirmek',
    'merge_action'                                    => 'Eylemi Birlestir',
    'ignore'                                          => 'Görmezden gelmek',
    'overwrite'                                       => 'Üzerine yaz',
    'add_to'                                          => 'A ekle',
    'select_merge_client'                             => 'Birlestirme Için Seçin',
    'client_to_and_from_not_same'                     => 'Gelen istemci ve gelen istemci farkli olmalidir.',
    'client_id_required'                              => 'Müsteri seçme alani hem gerekli hem de benzersiz olmalidir.',
    'is_merge'                                        => 'Birlestirmek',
    'record_successfully_merged'                      => 'Kayit basariyla birlestirildi',
    'service_ends'                                    => 'Hizmet Bitisleri',
    'service_starts'                                  => 'Hizmet Basliyor',
    'explanation'                                     => 'Açiklama',
    'subscription_details'                            => 'Abonelik Ayrintilari',
    'generate_next_invoice'                           => 'Sonraki Faturayi Olustur',
    'subscription'                                    => 'Abonelik',
    'of_the'                                          => '...',
    'on'                                              => 'Açik',
    'invoice_month'                                   => 'Fatura Ayi',
    'invoice_year'                                    => 'Fatura Yili',
    'next_month'                                      => 'Gelecek ay',
    'next_year'                                       => 'Gelecek Yil',
    'day'                                             => 'Gün',
    'last_date'                                       => 'Son tarih',
    'merge_record_warning'                            => 'Durmak! Müsteri hesaplarinin birlestirilmesi geri alinamaz. Üzerine yazmak veya eklemek için seçtiginiz alanlara ek olarak, birlestirme istemcisine iliskin tüm islem geçmisi, birlestirme istemcisine aktarilacaktir. Bu müsteri hesaplarini birlestirmek istediginizden emin misiniz?',
    'merge_child_account_warning'                     => 'Merge(From) istemcisinin, Merge(To) istemcisine yeniden atanacak ilgili alt hesaplara sahip bir ana hesabi var. Lütfen Merge(To) istemcisine ana hesap olarak izin verildiginden emin olun.',
    'merge_parent_account_warning'                    => 'Birlestirme, ebeveyn hesabiyla olan iliskinizi kaldiracaktir.',
    'merge_invoices_paid_by_warning'                  => 'Birlestirme islemi, tarafinizca ödenen ana faturayla olan iliskinizi kaldiracaktir.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Istemci modelindeki iliskilerin sayisi degisti.',
    'payment_terms'                                   => 'Ödeme sartlari',
    'net_amount_due_in'                               => 'Ödenecek net tutar',
    'net_amount_due_by'                               => 'Ödenecek net tutar',
    'if_paid_within'                                  => 'içinde ödeme yapilirsa',
    'if_paid_by'                                      => 'eger tarafindan ödenirse',
    'th_of_next_month'                                => 'gelecek ayin th\'i',
    'of_next_month'                                   => 'gelecek ayin',
    'down_payment'                                    => 'Pesinat',
    'balance_amount_due_of'                           => 'ödenmesi gereken bakiye tutari',
    'payment_split_over'                              => 'Ödeme bölünmüs durumda',
    'installments'                                    => 'taksitler',
    'days_from_invoice_date'                          => 'fatura tarihinden itibaren gün sayisi',
    'payment'                                         => 'Ödeme',
    'one'                                             => 'Bir',
    'two'                                             => 'Iki',
    'three'                                           => 'Üç',
    'four'                                            => 'Dört',
    'five'                                            => 'Bes',
    'six'                                             => 'Alti',
    'discount_percent'                                => 'Indirim Yüzdesi',
    'discount_days_simple'                            => 'Indirim Günleri Basit',
    'discount_days_nth'                               => 'Indirim Günleri Kuzey',
    'net_due_days'                                    => 'Net Vade Günleri',
    'balance_due_days'                                => 'Bakiye Vade Günleri',
    'number_of_installments'                          => 'Taksit Sayisi',
    'payment_term'                                    => 'Ödeme kosulu',
    'select_payment_term'                             => 'Ödeme Süresini Seçin',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Taksit yüzdesi :index alani zorunludur ve sifirdan büyüktür.',
        'installment_due_days_error'                  => 'Taksit son günlerinin :index dosyalanmasi zorunludur',
        'discount_percent_gt_error'                   => 'Belirtilen Indirim yüzdesi gereklidir ve sifirdan büyüktür.',
        'discount_percent_lt_error'                   => 'Belirtilen Indirim yüzdesi gereklidir ve %100\'den azdir.',
        'down_payment_percent_lt_error'               => 'Basvurulan Pesinat yüzdesi gereklidir ve %100\'den azdir.',
        'discount_percent_numeric_error'              => 'Indirim yüzdesi alani sayisal bir deger olmali ve %100\'den küçük olmalidir.',
        'down_payment_gt_error'                       => 'Dosyalanan Pesinat gereklidir ve sifirdan büyüktür.',
        'discount_days_gt_net_days_error'             => 'Net vade günlerinin tutari Indirim günlerinden büyük olmalidir.',
        'discount_days_nth_gt_net_days_error'         => 'Net ödeme günlerinin tutari, Indirim N\'inci günlerinden daha büyük olmalidir.',
        'installment_due_days_gt_error'               => 'Taksit vade günleri :index taksit vade günlerinden :preIndex daha büyük olmalidir.',
        'installment_percent_total_error'             => 'Toplam taksit yüzdesi dogru degil. %100\'e esit olmalidir.',
        'installment_percent_numeric_error'           => 'Toplam taksit yüzdesi dogru degil. Sayisal bir deger olmalidir.',
        'term_discount'                               => 'Dönem Indirimi',
        'installment_due_days_gt_zero_error'          => 'Taksit vade günleri :index sifirdan büyük veya sifira esit olmalidir.',
        'net_due_days_error'                          => 'Net ödeme günlerinin tutari Sifir\'dan büyük olmali ve gerekli dosyalanmalidir.',
        'discount_days_simple_error'                  => 'Indirim günleri basit Sifirdan büyük olmali ve gerekli dosyalanmalidir.',
        'discount_days_nth_error'                     => 'Indirim N\'inci günleri Sifir\'dan büyük olmali ve gerekli dosyalanmalidir.',
        'balance_due_days_error'                      => 'Bakiye vade günlerinin Sifirdan büyük olmasi ve gerekli dosyalanmasi gerekir.',
        'status_error'                                => 'Üzgünüz, faturada kullanilan terim nedeniyle durum degismedi.',
        'down_payment_type_invoice_description_error' => 'Girdiginiz Fatura Açiklamasi jetonu pesinat türünüzle eslesmiyor.',
        'down_payment_type_quote_description_error'   => 'Girdiginiz Teklif Açiklamasi jetonunuz pesinat türünüzle eslesmiyor.',
    ],
    'quotes_delete_error'                             => 'Tirnak silme hatasi',
    'for'                                             => 'Için',
    'production'                                      => 'Üretme',
    'access_token'                                    => 'Erisim Jetonu',
    'application_id'                                  => 'Uygulama Kimligi',
    'location_id'                                     => 'Konum Kimligi',
    'fi_config_check'                                 => 'Önkosul Kontrolü',
    'requirement'                                     => 'Gereklilik',
    'required'                                        => 'Gerekli',
    'actual'                                          => 'Gerçek',
    'result'                                          => 'Sonuç',
    'db_prefix_setup_alert'                           => 'FusionInvoice veritabaniniz DB öneklerini kullaniyor. DB öneklerine yönelik destek, 2023-3.0 sürümüyle sona erdi. Bu ve gelecek sürümlere yükseltmeye devam etmek için DB Öneklerini kaldirmaniz gerekmektedir. Bunu, veritabaninizdaki tüm tablolari yeniden adlandirarak, öneki kaldirarak ve ayrica veritabani.php dosyanizda \'prefix\' => \'\' degerini ayarlayarak yapabilirsiniz.',
    'open_tasks'                                      => 'Görevleri Aç',
    'closed_tasks'                                    => 'Kapali Görevler',
    'select_status'                                   => 'Durum Seç',
    'net_amount_due_invoice'                          => ':days gün içinde ödenmesi gereken net tutar.',
    'days_add_in_current_date'                        => '<span class="text-blue">:date</span> , ve son tarih itibariyle geçerli tarih, <span class="text-blue">:date</span>  <span class="text-danger">arti</span> <span class="text-blue">gün sayisi</span> olarak kabul edilecektir.',
    'terms'                                           => 'Sartlar',
    'quote_rejecting_error'                           => 'Fatura # :invoice_number bu teklifin onaylanmasiyla :invoice_date tarihinde olusturuldu. Bu teklifi reddetmeden önce bu faturayi silmeli veya iptal etmelisiniz.',
    'resend_record_warning'                           => 'Bu e-posta simdi yeniden gönderilsin mi?',
    'resend_email'                                    => 'Elektronik postayi tekrar gönder',
    'requirement_check_fail'                          => 'Kurulumun devam edebilmesi için yukarida gösterilen hatalari düzeltmeniz gerekir.',
    'failed'                                          => 'Arizali',
    'subscriptions'                                   => 'Abonelikler',
    'tt_explanation'                                  => 'Istege bagli tarih yer tutuculariyla hizmet için bir açiklama girin. Hizmet baslangiç ve bitis tarihlerini dinamik olarak eklemek için su belirteçleri kullanabilirsiniz:{{service_starts_on}} ve {{service_ends_on}}. Içerik görüntülendiginde bunlar gerçek baslangiç ve bitis tarihleriyle degistirilecektir.',
    'tt_ss_invoices_default_payment_terms'            => 'Fatura Varsayilan Ödeme Kosullari',
    'invoices_default_terms'                          => 'Faturalarin Varsayilan Sartlari',
    'net_amount_due_in_n_days'                        => 'N gün içinde ödenmesi gereken net tutar',
    'last_day'                                        => 'Son gun',
    'down_payment_payment_term1'                      => 'Pesinat',
    'down_payment_payment_term2'                      => 'gereklidir.  Bakiyenin ödenmesi gerekiyor',
    '1_type'                                          => 'Bugün olusturulan bir faturanin son ödeme tarihi <span class="text-primary">#N</span> gün olacak',
    '2_type'                                          => 'Bugün olusturulan bir fatura <span class="text-primary">#date</span>  tarihine kadar ödenirse indirime olanak tanir, aksi takdirde tutarin tamami <span class="text-primary">#N</span>  gün içinde ödenir',
    '3_type'                                          => 'Bugün olusturulan bir fatura <span class="text-primary">#date</span>  tarihine kadar ödenirse indirime olanak tanir. Net tutar <span class="text-primary">#N</span>  gün içinde ödenecek',
    '4_type'                                          => 'Bugün olusturulan bir fatura <span class="text-primary">#amount</span>  tutarinda bir pesinat gerektirecektir. Kalan bakiye <span class="text-primary">#N</span>  gün içinde ödenecek',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Bugün olusturulan ve <span class="text-primary">#months</span> #installment</span> bölünmüs bir fatura</strong></p> ~',
    '5_1_type'                                        => '<p>Ödeme <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Vade <span class="text-primary">#date</span></p>',
    'installment'                                     => 'taksit',
    'apply_payment_terms'                             => 'Ödeme kosullari indirim tutarini uygula',
    'payable_amount'                                  => 'Ödenecek Nihai Tutar',
    'payable_amount_lt_error'                         => 'Ödenecek nihai tutar Fatura Bakiyesinden az olmalidir.',
    'payment_term_type_4_amount'                      => ':amount kismi ödeme kabul edildi',
    'net_terms'                                       => 'Net sartlar',
    'proforma_invoice_default'                        => 'Proforma Fatura Varsayilani',
    'expense_vendor'                                  => 'Gider Saticisi',
    'expense_vendor_deleted'                          => 'Gider saticisi silindi',
    'expense_vendor_already_used'                     => 'Ilgili gider girisleri olan bir saticiyi silemezsiniz.',
    'total_must_be_gt_zero'                           => ':modal_name toplami sifirdan büyük olmalidir.',
    'payment_failed'                                  => 'Ödeme :error nedeniyle basarisiz oldu',
    'xss_validation'                                  => ':attribute alani bir XSS güvenlik açigini ortaya çikarabilecek etiketler içerir',
    'support_desk'                                    => 'Destek Masasi',
    'choose_file'                                     => 'Dosya seçin',
    'supportTicket'                                   => 'Destek Masasi',
    'create_support_ticket'                           => 'Destek Bileti Olustur',
    'supportTicket_inbox_view'                        => 'Destek Masasi',
    'support_ticket'                                  => 'Destek bileti',
    'ticket_number'                                   => 'Bilet numarasi',
    'revision'                                        => 'Revizyon',
    'revisions'                                       => 'Revizyonlar',
    'recurring_invoices'                              => 'Yenilenen Faturalar',
    'message'                                         => 'Ileti',
    'custom_img'                                      => 'Özel Resim',
    'please_fill_some_data'                           => 'Lütfen yeni ögeyle ilgili gerekli verileri doldurun.',
    'assigned'                                        => 'Atandi',
    'add_ons_will_be_disabled'                        => 'ASAGIDAKI EKLENTILER DEVRE DISI BIRAKILACAK:',
    'add_ons_will_be_disabled_msg'                    => 'Temel FusionInvoice yükseltmesi sirasinda tüm eklentiler otomatik olarak devre disi birakilir. Bu yükseltme tamamlandiktan sonra uygun eklenti zip dosyalarini indirip yüklediginizden emin olun. Bunu yaptiktan sonra bunlari Sistem Ayarlari menüsü, Özellestirmeler, Eklentiler ve [Yükle] seçenegini seçerek yeniden etkinlestirebilirsiniz.',
    'price_not_valid'                                 => 'Fiyat sifirdan büyük olmalidir',
    'free_space'                                      => 'Bos alan',
    'expense_type'                                    => 'Gider Türü',
    'standard_expense'                                => 'Standart Gider',
    'expense_with_deductible_tax'                     => 'Indirilebilir Vergili Giderler',
    'remittance_to_tax_authority'                     => 'Vergi Dairesine Havale',
    'tax_paid'                                        => 'Ödenen Vergi',
    'tax_detail'                                      => 'Vergi Detayi',
    'select_expense_type'                             => 'Gider Türünü Seçin',
    'taxes_paid_on_expenses_or_remitted'              => 'Giderler Üzerine Ödenen veya Gönderilen Vergiler',
    'tax_name'                                        => 'Vergi Adi',
    'last_activity'                                   => 'son Aktivite',
    'select_default_company_profile'                  => 'Lütfen varsayilan sirket profilinizi seçin',
    'mn_sales_tax'                                    => 'MN Satis Vergisi',
    'taxes_collected_on_sales'                        => 'Satislardan Alinan Vergiler',
    'vatgst_tax_note'                                 => 'Evet, vergiyi öge toplamina dahil olarak hesaplar. Hayir, vergiyi ürün toplamina ekleyecektir.',
    'tt_vatgst_tax'                                   => 'Bu örnekte vergi oraninin %5 oldugunu ve ürün fiyatinin 100$ oldugunu varsayacagiz. KDV/GST\'yi Etkinlestir\'in Evet olarak ayarlanmasi, ürün tutari 95,24 ABD Dolari ve vergi tutari 4,76 ABD Dolari olarak ayarlanacak sekilde toplam 100 ABD Dolari tutarinda bir fatura verecektir. KDV/GST\'nin Hayir olarak ayarlanmasi, ürün fiyati 100 Dolar ve vergi 5 Dolar olmak üzere toplam 105 Dolar tutarinda bir fatura verecektir.',
    'level_of_detail'                                 => 'Ayrinti Düzeyi',
    'tax_report'                                      => 'Vergi Raporu',
    'detail'                                          => 'Detay',
    'totals'                                          => 'Toplamlar',
    'totals_with_dots'                                => 'Toplamlar . . .',
    'yes_all'                                         => 'Evet (tümü)',
    'invoices_only'                                   => 'Yalnizca faturalar',
    'payment_receipts_only'                           => 'Yalnizca Ödeme Makbuzlari',
    'role'                                            => 'Rol',
    'previous_email'                                  => 'Önceki e-posta',
    'web_store_user_id'                               => 'Web Magazasi Kullanici Kimligi: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => '<span class="text-info">#LASTDATE</span> tarihine kadar ödenmesi gereken net tutar',
        '2_type'       => '#DISCOUNTPERCENT tarihine kadar ödeme yapilirsa % <span class="text-info">#DISCOUNTDATE</span> ~ tutarinda bir indirim alinabilir,</span> aksi takdirde net tutar <span class="text-info">#LASTDATE</span>  tarihine kadar ödenir.',
        '3_type'       => '#DISCOUNTPERCENT tarihine kadar ödeme yapilirsa % <span class="text-info">#DISCOUNTDATE</span> ~ tutarinda bir indirim alinabilir,</span> aksi takdirde net tutar <span class="text-info">#LASTDATE</span>  tarihine kadar ödenir.',
        '4_type'       => '<span class="text-info">#DOWNPAYMENT</span>  tutarindaki pesinat #INVOICEDATE tarihindedir. Bakiyenin vadesi <span class="text-info">#LASTDATE</span>  tarihine kadar ödenecektir.',
        '5_type'       => '<p class="mt-2 mb-1">Ödemeler <span class="text-info">#NUMBEROFINSTALLMENTS</span> taksite bölünebilir</p>',
        '5_1_type'     => '<li>Ödeme <span class="text-info">#PERCENT Ödenmesi gereken yüzde</span> <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Gelecek ayin toplam #N günü var, dolayisiyla gelecek ayin indirim günleri için lütfen 1 ile #N arasinda bir deger girin.</span>',
    ],
    'payment_term_not_selected'                       => 'Ödeme Süresi Seçilmedi',
    'confirm'                                         => 'Onaylamak',
    'create_live_invoice_now'                         => 'Simdi Canli Fatura Olusturulsun mu?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Abonelik, belirli bir siklikta canli faturalar olusturmak için kullanilan bir fatura sablonu gibidir.</p><p class="m-0"> Normalde bir CRON isi veya zamanlanmis görev günde bir kez çalisacak sekilde ayarlanmistir ve aboneligin Sonraki Fatura Olustur tarih alanina göre olusturulmasi gereken canli faturalarin kontrol edilmesinden sorumludur.  Bu tarih degeri bugün veya bugünden önceyse otomatik olarak canli fatura olusturulur.</p><p class="m-0"> Bu seçenek, otomatik yöntemi atlayarak abonelikten canli faturayi manuel olarak olusturmaniza olanak tanir. . Canli faturayi simdi olusturmak ister misiniz?</p>',
    'contact'                                         => 'Temas etmek',
    'invoice_month_plus_one'                          => 'Fatura Ayi +1',
    'invoice_month_plus_two'                          => 'Fatura Ayi +2',
    'invoice_month_plus_three'                        => 'Fatura Ayi +3',
    'inbound_email'                                   => 'Gelen e-posta',
    'outbound_email'                                  => 'Giden e-posta',
    'email_signature'                                 => 'E-posta imzasi',
    'mail_credential_error'                           => 'Geçersiz e-posta yapilandirmasi. Lütfen ayarlarinizi kontrol edip tekrar deneyin. <strong>( Yapilandirma <i class="fa fa-arrow-alt-circle-right"> </i> Sistem Ayarlari <i class="fa fa-arrow-alt-circle-right"> </i> E-posta )</strong>',
    'tt_generate_next_invoice'                        => 'Bu abonelikten bir sonraki canli faturanin otomatik olarak olusturulacagi tarih.',
    'tt_stop_date'                                    => 'Bu abonelik için artik geçerli faturalarin otomatik olarak olusturulmayacagi tarih esigi. Sonsuza kadar devam etmesi gereken bir abonelik için bu alani bos birakin.',
    'description_template'                            => 'Açiklama Sablonu',
    't_1_description'                                 => 'Ödemenin tamaminin #LASTDATE tarihine kadar yapilmasi gerekmektedir.',
    't_2_description'                                 => '#DISCOUNTPERCENT tarihine kadar ödeme yapilirsa % ~ #DISCOUNTDATE, aksi takdirde fatura tutarinin tamamini #LASTDATE tarihine kadar ödeyin.',
    't_3_description'                                 => '#DISCOUNTPERCENT tarihine kadar ödeme yapilirsa % ~ #DISCOUNTDATE, aksi takdirde fatura tutarinin tamamini #LASTDATE tarihine kadar ödeyin.',
    't_4_description'                                 => '#DOWNPAYMENT tutarinda bir pesinatin #INVOICEDATE, #LASTDATE tarihine kadar ödenmesi gerekmektedir.',
    't_4_1_description'                               => '#DOWNPAYMENTPERCENT tutarinda bir pesinatin #INVOICEDATE, #LASTDATE tarihine kadar ödenmesi gerekmektedir.',
    't_5_description'                                 => 'Ödemeler #NUMBEROFINSTALLMENTS esit taksitlerle yapilacaktir.',
    't_5_type_description'                            => 'Ödeme #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT #LASTDATE tarihinde yapilacak',
    'tokens_allowed'                                  => 'Jetonlara izin verildi',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Sablondan degerlendirilen metin, fatura, fiyat teklifi vb. belgelerde gösterilen terimlerin açiklamasidir.',
    'cc_mail'                                         => 'CC Posta',
    'assigned_inv_sent_or_paid'                       => '*Ödenmis veya gönderilmis, bu ödeme vadesinin belirlendigi faturalar var. \'Tip\' ayrintilarinin degistirilmesine izin verilmez.',
    'exclude_paid_invoices'                           => 'Ödenen Faturalari Hariç Tut',
    'phone_number_numeric_error'                      => 'Telefon Numarasi bir sayi olmalidir.',
    'phone_num_same_country_code_error'               => 'Lütfen telefon numaranizin dogru biçimlendirildiginden emin olun. Izin verilmeyen ülke kodundan baslayarak girilmis gibi görünüyor.',
    'tt_expense_amount'                               => 'Vergi dahil toplam gider tutarini girin. Bir vergi ödemesini vergi dairesine havale ederken bu alan kullanilamaz.',
    'tt_expense_tax_paid_deductible'                  => 'Bu giderle birlikte ödenen vergi tutarini girin. Bu deger, Vergi Özeti ve Vergi Ayrintisi raporlarindaki genel vergi yükümlülügünüzden düsülecektir.',
    'tt_expense_tax_paid_remittance'                  => 'Vergi dairesine havale edilen vergi tutarini girin. Bu, ödenen faturalarinizda tahsil edilen vergiler için yapilan ödemeleri kaydetmek için kullanilir.',
    'tt_expense_client'                               => 'Bu masraf yalnizca bir müsteri adina yapilmissa ve bu masrafi kendisine fatura etmek istiyorsaniz, ilgili müsteriyi buradan seçin.',
    'base_currency_not_deleted'                       => 'Temel para birimi silinemez',
    'used_currency_modal_error'                       => ':modal_names modülünde zaten kullanilan para birimi.',
    'addon_uninstall_success'                         => 'Eklenti basariyla kaldirildi',
    'original'                                        => 'Orijinal',
    'revision_current'                                => 'Revizyon(güncel)',
    'number'                                          => 'Sayi',
    'copy_process_error'                              => 'Hata! Kopyalama islemi sirasinda bir aksaklik oldugu anlasiliyor. Lütfen daha sonra tekrar deneyiniz.',
    'tt_captcha_image'                                => 'CAPTCHA görseli',
    'reload_page'                                     => 'Lütfen sayfayi yenileyin',
    'discount_limit'                                  => 'Indirim %99,99\'dan az olmalidir.',
    'tooltip'                                         => 'Ipucu',
    'authorization_error'                             => 'Bu islemi gerçeklestirme yetkiniz yok.',
    'reset_to_default'                                => 'Varsayilana sifirla',
    'reset_to_default_warning'                        => '<p>Bu, Konu ve Gövde\'yi :model için varsayilan degere sifirlayacaktir. Devam etmek?</p>',
    'reset_default_mail_template'                     => ':model için varsayilan posta sablonu basariyla sifirlandi.',
    'overdue_invoice'                                 => 'Gecikmis Fatura',
    'total_cannot_be_lt_zero'                         => ':modal_name toplami sifirdan küçük olamaz.',
    'addons_disabled_during_setup'                    => 'Yükseltme islemi sirasinda asagidaki eklentiler devre disi birakildi: :addons . Yükseltme tamamlandiktan sonra bunlari etkinlestirmeyi unutmayin.',
    'allow_payments_on_quotes'                        => 'Tekliflerde Ödemelere Izin Ver E/H',
    'allow_payments_on_quote'                         => 'Ödemeye Izin Ver E/H',
    'tt_ss_quotes_is_payable'                         => 'Etkinlestirilirse, fiyat teklifi onaylandiktan sonra, teklifin genel baglanti görünümünde Simdi Öde dügmesi görünecektir. Otomatik olarak bir fatura olusturulacak ve ödeme faturaya uygulanacaktir.',
    'pay_with_square'                                 => 'Kare ile Ödeme',
    'validation_mess_for_is_payable_quote'            => 'Tekliflerde Ödemelere Izin Ver \'Evet\' olarak ayarlandiginda, Müsteri Onayladiginda Teklifi Otomatik Olarak Faturaya Dönüstürme ayari gereklidir.',
    'client_requirement_msg'                          => 'Lütfen :seed_name eklemeden önce bir istemci olusturun',
    'quote_add_items'                                 => 'Teklif ögeleri gerekli ve durum iptal edilmedi',
    'invalid_quote_id'                                => 'Geçersiz Fiyat Teklifi Kimligi',
    'information_header'                              => 'Tebrikler, biraz tasarruf etmek üzeresiniz!',
    'convenience_charge'                              => 'Kolaylik Ücreti',
    'credit_card_fee_message'                         => 'Bu islemde :charge tutarinda Kredi Karti Kolaylik Ücreti alinacaktir.',
    'info_payment_term_type_2'                        => 'Fatura bakiyeniz :ORIGINAL_AMOUNT, olmasina ragmen, ödeme tutarinizi :DISCOUNT_PERCENT kadar azaltacak olan % :DISCOUNT_AMOUNT tutarindaki ödeme kosullari indiriminden yararlanmaya hak kazanirsiniz.',
    'info_payment_term_type_3'                        => 'Fatura bakiyeniz :ORIGINAL_AMOUNT, olmasina ragmen, ödeme tutarinizi :DISCOUNT_PERCENT kadar azaltacak olan % :DISCOUNT_AMOUNT tutarindaki ödeme kosullari indiriminden yararlanmaya hak kazanirsiniz.',
    'info_payment_term_type_4'                        => 'Fatura bakiyeniz :ORIGINAL_AMOUNT, :DISCOUNT_AMOUNT ön ödeme yapmak için ödeme kosullarina uygunsunuz.',
    'info_payment_term_type_5'                        => 'Fatura bakiyeniz :ORIGINAL_AMOUNT, :DISCOUNT_AMOUNT taksitli ödeme yapmak için ödeme kosullarina uygunsunuz.',
    'payment_terms_applied'                           => 'Ödeme Sartlari silinmeden önce :modal dan kaldirilmalidir.',
    'default_payment_term_warn'                       => '*<strong>Sistem Varsayilan Ödeme Kosullari</strong> için yalnizca Ad ve Net Vade Günlerini degistirebilirsiniz.',
    'quote_rejected_not_payable'                      => 'Alinti # :number reddedildi ve durumu nedeniyle ödenmiyor.',
    'could_not_delete'                                => 'Silinemedi',
    'convenience_charges_calculation_fail'            => 'Hata: Kolaylik ücretleri hesaplamasi tasima sirasinda basarisiz oldu. Lütfen daha sonra tekrar deneyiniz.',
    'sign_in_welcome_message'                         => 'ðŸš€ Tebrikler! FusionFaturaniz Basariyla Kuruldu! gŸš€',
    'sign_in_welcome_message_1'                       => '<p>FusionInvoice\'niz basariyla :old_version sürümünden :new_version sürümüne yükseltildi.</p><p> Tüm yeni özelliklere ve iyilestirmelere iliskin ayrintili bir genel bakis için lütfen <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Sürüm Notlarimiza</a> bakin.</p>',
    'sign_in_welcome_message_2'                       => '<p>FusionInvoice\'u seçtiginiz için tesekkür ederiz. Güveniniz, desteginiz ve geri bildirimleriniz inovasyonumuza yön veriyor.</p><p class="m-0 text-bold">Mutlu Faturalama!</p><p class="text-bold">FusionInvoice Ekibi</p >',
    'tt_gen_skin_user_profile'                        => 'Bu degerin degistirilmesi YALNIZCA yeni kullanicilar için sistem varsayilanini ayarlar. Kullanicilar bu ayari kullanici profili ayarlari araciligiyla geçersiz kilabilir.',
    'description_template_invoice'                    => 'Açiklama Sablonu - Fatura',
    'description_template_quote'                      => 'Açiklama Sablonu - Alinti',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Ödemenin tamaminin fatura tarihinden itibaren #NETDAYS içinde yapilmasi gerekmektedir.',
    't_2_description_for_quote'                       => '#DISCOUNTPERCENT #DISCOUNTDAYS, aksi takdirde teklif tutarinin tamamini #NETDAYS tarihine kadar ödeyin.',
    't_3_description_for_quote'                       => 'Bir sonraki ayin #NTHDAY tarihine kadar ödenirse % #DISCOUNTPERCENT indirimden yararlanin, aksi takdirde fatura tutarinin tamamini #NETDAYS gün içinde ödeyin.',
    't_4_description_for_quote'                       => 'Fatura tarihinde #DOWNPAYMENT tutarinda bir pesinat ödenmesi gerekiyor, kalan bakiye #NETDAYS gün içinde ödenecek',
    't_4_1_description_for_quote'                     => 'Fatura tarihinde #DOWNPAYMENTPERCENT tutarinda bir pesinat ödenmesi gerekiyor, kalan bakiye #NETDAYS gün içinde ödenecek',
    't_5_description_for_quote'                       => 'Ödemeler #NUMBEROFINSTALLMENTS esit taksitlerle yapilacaktir.',
    't_5_type_description_for_quote'                  => 'Ödeme #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT fatura tarihinden #INSTALLMENTDUEDAYS gün sonra yapilacaktir',
    'default_term'                                    => 'Varsayilan Dönem',
    'proceed_to_payment'                              => 'Ödemeye Devam Et',
    'version_upgraded'                                => 'Basvurunuz güncel.',
    'term_amount_gt_payment_amount'                   => 'Tutar, ödeme kosullari indirim tutarindan büyük olmalidir',
    'payment_term_not_eligible_warning'               => 'Ödeme süresi indirimi yalnizca tam ödemeler için geçerlidir. Maalesef buna uygun degilsiniz.',
    'processed_by_user'                               => '<strong>Isleyen:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Ödeme Yöntemi:</strong> :method',
    'all_methods'                                     => 'Tüm Yöntemler',
    'this_payment'                                    => 'Bu Ödeme',
    'previous_balance'                                => 'Önceki denge',
    'payment_applied_with_remaining_balance'          => '<p><strong>:amount Ödemeniz kismen uygulandi. :remaining_balance olaganüstü olmaya devam ediyor.</strong></p>',
    'pre_payment_received'                            => '<p><strong>~ :date tarihinde gelecek Faturalar için :amount tutarinda bir Ön Ödeme alindi.</strong></p>',
    'payment_full_applied'                            => '<p><strong>Ödemeniz :amount tamamen uygulandi.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Ödeme <span style="background: #d2d6de;kenarlik yariçapi: 2px;padding: 0 8px;"> :formatted_number</span> ~ Ayrintilar:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>:paid ödemesi, ~ :date</span> ~ tarihinde :invoice_number Faturasina uygulandi',
    'payment_full_applied_on_inv_with_ptd'            => '<p>:paid, eksi :payment_terms_discount ödeme süresi indirimi ödemesi, :date</span> ~ tarihinde Fatura :invoice_number a uygulandi',
    'payment_full_applied_on_inv_with_cc'             => '<p>:paid, arti :convenience_charges kolaylik ücretlerinin ödenmesi, :date</span> ~ tarihinde Fatura :invoice_number a uygulanmistir.',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>:paid, arti :convenience_charges kolaylik ücretleri ve eksi :payment_terms_discount ödeme süresi indiriminin ödenmesi, ~ :date</span> ~ tarihinde Fatura :invoice_number a uygulanmistir.',
    'payment_remaining_balance_mail_message'          => '<p>Fatura :invoice_number in kalan bakiyesi :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Ödenmemis Faturalar',
    'include'                                         => 'Katmak',
    'exclude'                                         => 'Hariç tutmak',
    'invoice_with_no_tax'                             => 'Vergisiz Faturalar',
    'tax_total'                                       => 'Vergi Toplami',
];

return TranslationOverride::override(__FILE__, $translations);
