<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => 'Het :attribute moet worden geaccepteerd.',
    'active_url'                      => 'Het :attribute is geen geldige URL.',
    'after'                           => 'Het :attribute moet een datum na :date zijn.',
    'after_or_equal'                  => 'Het :attribute moet een datum zijn na of gelijk zijn aan :date.',
    'alpha'                           => 'Het :attribute mag alleen letters bevatten.',
    'alpha_dash'                      => 'Het :attribute mag alleen letters, cijfers en streepjes bevatten.',
    'alpha_num'                       => 'Het :attribute mag alleen letters en cijfers bevatten.',
    'array'                           => 'Het :attribute moet een array zijn.',
    'before'                          => 'Het :attribute moet een datum vóór :date zijn.',
    'before_or_equal'                 => 'Het :attribute moet een datum vóór of gelijk aan :date zijn.',
    'between'                         => [
        'numeric' => 'Het :attribute moet tussen :min en :max liggen.',
        'file'    => 'Het :attribute moet tussen :min en :max kilobytes liggen.',
        'string'  => 'Het :attribute moet tussen de tekens :min en :max liggen.',
        'array'   => 'Het :attribute moet tussen :min en :max items bevatten.',
    ],
    'boolean'                         => 'Het veld :attribute moet waar of onwaar zijn.',
    'confirmed'                       => 'De :attribute bevestiging komt niet overeen.',
    'date'                            => 'Het :attribute is geen geldige datum.',
    'date_format'                     => 'Het :attribute komt niet overeen met het formaat :format.',
    'different'                       => 'De :attribute en :other moeten verschillend zijn.',
    'digits'                          => 'Het :attribute moet uit :digits cijfers bestaan.',
    'digits_between'                  => 'Het :attribute moet tussen :min en :max cijfers liggen.',
    'dimensions'                      => 'Het :attribute heeft ongeldige afbeeldingsafmetingen.',
    'distinct'                        => 'Het veld :attribute heeft een dubbele waarde.',
    'email'                           => 'Het :attribute moet een geldig e-mailadres zijn.',
    'exists'                          => 'Het geselecteerde :attribute is ongeldig.',
    'file'                            => 'Het :attribute moet een bestand zijn.',
    'filled'                          => 'Het veld :attribute moet een waarde hebben.',
    'image'                           => 'Het :attribute moet een afbeelding zijn.',
    'in'                              => 'Het geselecteerde :attribute is ongeldig.',
    'in_array'                        => 'Het veld :attribute bestaat niet in :other.',
    'integer'                         => 'Het :attribute moet een geheel getal zijn.',
    'ip'                              => 'Het :attribute moet een geldig IP-adres zijn.',
    'ipv4'                            => 'Het :attribute moet een geldig IPv4-adres zijn.',
    'ipv6'                            => 'Het :attribute moet een geldig IPv6-adres zijn.',
    'json'                            => 'Het :attribute moet een geldige JSON-tekenreeks zijn.',
    'max'                             => [
        'numeric' => 'Het :attribute mag niet groter zijn dan :max.',
        'file'    => 'Het :attribute mag niet groter zijn dan :max kilobytes.',
        'string'  => 'Het :attribute mag niet groter zijn dan :max tekens.',
        'array'   => 'Het :attribute mag niet meer dan :max items bevatten.',
    ],
    'mimes'                           => 'Het :attribute moet een bestand zijn van het type: :values.',
    'mimetypes'                       => 'Het :attribute moet een bestand zijn van het type: :values.',
    'min'                             => [
        'numeric' => 'Het :attribute moet minstens :min zijn.',
        'file'    => 'Het :attribute moet minimaal :min kilobytes zijn.',
        'string'  => 'Het :attribute moet minimaal :min tekens bevatten.',
        'array'   => 'Het :attribute moet minstens :min items bevatten.',
    ],
    'not_in'                          => 'Het geselecteerde :attribute is ongeldig.',
    'numeric'                         => 'Het :attribute moet een getal zijn.',
    'present'                         => 'Het veld :attribute moet aanwezig zijn.',
    'regex'                           => 'Het :attribute formaat is ongeldig.',
    'required'                        => 'Het veld :attribute is verplicht.',
    'required_if'                     => 'Het veld :attribute is vereist als :other :value is.',
    'required_unless'                 => 'Het veld :attribute is verplicht tenzij :other in :values staat.',
    'required_with'                   => 'Het veld :attribute is vereist als :values aanwezig is.',
    'required_with_all'               => 'Het veld :attribute is vereist als :values aanwezig is.',
    'required_without'                => 'Het veld :attribute is vereist als :values niet aanwezig is.',
    'required_without_all'            => 'Het veld :attribute is vereist als geen van :values aanwezig is.',
    'same'                            => 'De :attribute en :other moeten overeenkomen.',
    'size'                            => [
        'numeric' => 'Het :attribute moet :size zijn.',
        'file'    => 'Het :attribute moet :size kilobytes zijn.',
        'string'  => 'Het :attribute moet uit :size tekens bestaan.',
        'array'   => 'Het :attribute moet :size items bevatten.',
    ],
    'string'                          => 'Het :attribute moet een string zijn.',
    'timezone'                        => 'Het :attribute moet een geldige zone zijn.',
    'unique'                          => 'Het :attribute is al in gebruik.',
    'uploaded'                        => 'Het :attribute kon niet worden geüpload.',
    'url'                             => 'Het :attribute formaat is ongeldig.',
    'captcha'                         => 'Het :attribute is niet correct',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'aangepast bericht',
        ],
        'field_label'    => [
            'regex' => 'Veldlabel bevat een ongeldig teken. Toegestane tekens: A-Z, a-z, 0-9, spatie, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
