<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => 'Le :attribute doit être accepté.',
    'active_url'                      => 'Le :attribute n\'est pas une URL valide.',
    'after'                           => 'Le :attribute doit être une date après :date.',
    'after_or_equal'                  => 'Le :attribute doit être une date postérieure ou égale à :date.',
    'alpha'                           => 'L :attribute ne peut contenir que des lettres.',
    'alpha_dash'                      => 'L\' :attribute ne peut contenir que des lettres, des chiffres et des tirets.',
    'alpha_num'                       => 'L :attribute ne peut contenir que des lettres et des chiffres.',
    'array'                           => 'Le :attribute doit être un tableau.',
    'before'                          => 'Le :attribute doit être une date antérieure :date.',
    'before_or_equal'                 => 'Le :attribute doit être une date antérieure ou égale à :date.',
    'between'                         => [
        'numeric' => 'Le :attribute doit être compris entre :min et :max.',
        'file'    => 'Le :attribute doit être compris entre :min et :max kilo-octets.',
        'string'  => 'Le :attribute doit être compris entre les caractères :min et :max.',
        'array'   => 'L\' :attribute doit avoir entre :min et :max éléments.',
    ],
    'boolean'                         => 'Le champ :attribute doit être vrai ou faux.',
    'confirmed'                       => 'La confirmation :attribute ne correspond pas.',
    'date'                            => 'Le :attribute n\'est pas une date valide.',
    'date_format'                     => 'Le :attribute ne correspond pas au format :format.',
    'different'                       => 'Le :attribute et :other doivent être différents.',
    'digits'                          => 'Le :attribute doit être composé :digits chiffres.',
    'digits_between'                  => 'Le :attribute doit être compris entre :min et :max chiffres.',
    'dimensions'                      => 'Le :attribute a des dimensions d\'image non valides.',
    'distinct'                        => 'Le champ :attribute a une valeur en double.',
    'email'                           => 'Le :attribute doit être une adresse e-mail valide.',
    'exists'                          => 'Le :attribute sélectionné n\'est pas valide.',
    'file'                            => 'Le :attribute doit être un fichier.',
    'filled'                          => 'Le champ :attribute doit avoir une valeur.',
    'image'                           => 'Le :attribute doit être une image.',
    'in'                              => 'Le :attribute sélectionné n\'est pas valide.',
    'in_array'                        => 'Le champ :attribute n\'existe pas dans :other.',
    'integer'                         => 'Le :attribute doit être un entier.',
    'ip'                              => 'Le :attribute doit être une adresse IP valide.',
    'ipv4'                            => 'Le :attribute doit être une adresse IPv4 valide.',
    'ipv6'                            => 'Le :attribute doit être une adresse IPv6 valide.',
    'json'                            => 'Le :attribute doit être une chaîne JSON valide.',
    'max'                             => [
        'numeric' => 'Le :attribute ne peut pas être supérieur à :max.',
        'file'    => 'Le :attribute ne peut pas dépasser :max kilo-octets.',
        'string'  => 'Le :attribute ne peut pas dépasser :max caractères.',
        'array'   => 'L\' :attribute ne peut pas contenir plus de :max éléments.',
    ],
    'mimes'                           => 'Le :attribute doit être un fichier de type : :values.',
    'mimetypes'                       => 'Le :attribute doit être un fichier de type : :values.',
    'min'                             => [
        'numeric' => 'Le :attribute doit être au moins :min.',
        'file'    => 'Le :attribute doit faire au moins :min kilo-octets.',
        'string'  => 'Le :attribute doit contenir au moins :min caractères.',
        'array'   => 'L\' :attribute doit avoir au moins :min éléments.',
    ],
    'not_in'                          => 'Le :attribute sélectionné n\'est pas valide.',
    'numeric'                         => 'Le :attribute doit être un nombre.',
    'present'                         => 'Le champ :attribute doit être présent.',
    'regex'                           => 'Le format :attribute n\'est pas valide.',
    'required'                        => 'Le champ :attribute est obligatoire.',
    'required_if'                     => 'Le champ :attribute est obligatoire lorsque :other est :value.',
    'required_unless'                 => 'Le champ :attribute est obligatoire sauf si :other est dans :values.',
    'required_with'                   => 'Le champ :attribute est obligatoire lorsque :values est présent.',
    'required_with_all'               => 'Le champ :attribute est obligatoire lorsque :values est présent.',
    'required_without'                => 'Le champ :attribute est obligatoire lorsque :values n\'est pas présent.',
    'required_without_all'            => 'Le champ :attribute est requis lorsqu\'aucune des :values n\'est présente.',
    'same'                            => 'Les :attribute et :other doivent correspondre.',
    'size'                            => [
        'numeric' => 'Le :attribute doit être :size.',
        'file'    => 'Le :attribute doit être :size kilo-octets.',
        'string'  => 'Le :attribute doit être constitué de caractères :size.',
        'array'   => 'Le :attribute doit contenir des éléments :size.',
    ],
    'string'                          => 'Le :attribute doit être une chaîne.',
    'timezone'                        => 'Le :attribute doit être une zone valide.',
    'unique'                          => 'Le :attribute a déjà été pris.',
    'uploaded'                        => 'L :attribute n\'a pas pu être téléchargé.',
    'url'                             => 'Le format :attribute n\'est pas valide.',
    'captcha'                         => 'Le :attribute n\'est pas correct',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'message personnalisé',
        ],
        'field_label'    => [
            'regex' => 'L\'étiquette du champ contient un caractère non valide. Caractères autorisés: A-Z, a-z, 0-9, espace, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
