<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Benutzereinstellungen',
    'active'                                          => 'Aktiv',
    'activity'                                        => 'Aktivitäten',
    'activity_invoice_paid'                           => 'Rechnung <a href=":link">#:number</a> wurde bezahlt.',
    'activity_invoice_viewed'                         => 'Rechnung <a href=":link">#:number</a> wurde angesehen.',
    'activity_quote_approved'                         => 'Angebot <a href=":link">#:number</a> wurde bestätigt.',
    'activity_quote_rejected'                         => 'Angebot <a href=":link">#:number</a> wurde abgelehnt.',
    'activity_quote_viewed'                           => 'Angebot <a href=":link">#:number</a> wurde angesehen.',
    'add_item'                                        => 'Artikel hinzufügen',
    'add_line_item_to_invoice'                        => 'Fügen Sie der Rechnung eine Werbebuchung hinzu',
    'add_note'                                        => 'Notiz hinzufügen',
    'additional'                                      => 'Zusätzliches',
    'addon'                                           => 'Add-on',
    'addons'                                          => 'Add-ons',
    'address'                                         => 'Adresse',
    'address_format'                                  => 'Adressformat',
    'after_amount'                                    => 'Nach der Menge',
    'all'                                             => 'Alle',
    'all_categories'                                  => 'Alle Kategorien',
    'all_statuses'                                    => 'Alle Statusanzeigen',
    'all_time'                                        => 'Alle',
    'all_vendors'                                     => 'Alle Verkäufer',
    'allow_login'                                     => 'Login erlauben',
    'always_attach_pdf'                               => 'PDF immer anfügen',
    'always_bcc'                                      => 'Feste BCC Adresse',
    'always_cc'                                       => 'Feste CC Adresse',
    'amount'                                          => 'Summe',
    'api_public_key'                                  => 'API Public Key',
    'api_secret_key'                                  => 'API Secret Key',
    'approve'                                         => 'Bestätigen',
    'approved'                                        => 'Bestätigt',
    'approved_quotes'                                 => 'Akzeptierte Angebote',
    'attach_files'                                    => 'Datei(en) anhängen',
    'attach_pdf'                                      => 'PDF anhängen',
    'attachment'                                      => 'Anhang',
    'attachments'                                     => 'Anhänge',
    'author'                                          => 'Autor',
    'automatic'                                       => 'Automatisch',
    'automatic_email_on_recur'                        => 'Wiederkehrende Rechnung automatisch versenden',
    'automatic_email_payment_receipts'                => 'Automatische Zahlungsbestätigung per E-Mail',
    'available_fields'                                => 'Verfügbare Felder',
    'back'                                            => 'Zurück',
    'back_to_invoice'                                 => 'Zurück zur Rechnung',
    'back_to_quote'                                   => 'Zurück zum Angebot',
    'balance'                                         => 'Differenz',
    'base_currency'                                   => 'Basiswährung',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Vor Summierung',
    'bill_this_expense'                               => 'Diese Ausgaben abrechnen',
    'bill_to'                                         => 'An',
    'billable'                                        => 'Abrechnung',
    'billed'                                          => 'Abgerechnet',
    'billing_address'                                 => 'Rechnungs-Adresse',
    'billing_city'                                    => 'Rechnungs-Ort',
    'billing_name'                                    => 'Rechnungs-Name',
    'billing_state'                                   => 'Rechnungs-Bundesland',
    'billing_zip'                                     => 'Rechnungs-Postleitzahl',
    'binary_path'                                     => 'Binärpfad',
    'body'                                            => 'Text',
    'cancel'                                          => 'Abbrechen',
    'canceled'                                        => 'Abgebrochen',
    'card_number'                                     => 'Kreditkartennummer',
    'cash'                                            => 'Bar',
    'category'                                        => 'Kategorie',
    'cc'                                              => 'CC',
    'change'                                          => 'Ändern',
    'change_client'                                   => 'Kunde ändern',
    'check_for_update'                                => 'Auf Updates prüfen',
    'city'                                            => 'Ort',
    'clear_keys'                                      => 'Schlüssel leeren',
    'client'                                          => 'Kunde',
    'client_form'                                     => 'Kunden bearbeiten',
    'client_name'                                     => 'Kundenname',
    'client_not_found'                                => 'Kunde nicht gefunden',
    'client_statement'                                => 'Kunden',
    'client_unique_name_option_1'                     => 'Nur wenn der Kundenname nicht einzigartig ist',
    'client_unique_name_option_2'                     => 'Immer anzeigen',
    'client_visibility'                               => 'Kunden Sichtbarkeit',
    'clients'                                         => 'Kunden',
    'code'                                            => 'Code',
    'column_name'                                     => 'Spaltenname',
    'column_width'                                    => 'Spaltenbreite',
    'company'                                         => 'Firma',
    'complete'                                        => 'Abgeschlossen',
    'complete_upgrade'                                => 'Upgrade abschließen',
    'compound'                                        => 'Compound',
    'compound_tax_note'                               => 'Compound tax rates must be applied to an item as tax 2 to have the desired effect.',
    'confirm_approve_quote'                           => 'Sind Sie sicher, dass Sie das Angebot akzeptieren möchten?',
    'confirm_reject_quote'                            => 'Sind Sie sicher, dass Sie das Angebot ablehnen möchten?',
    'continue'                                        => 'Weiter',
    'convert_quote_option1'                           => 'Die Rechnung sollte die Angebotsbedingungen beinhalten',
    'convert_quote_option2'                           => 'Die Rechnung sollte die Standard-Angebotsbedingungen beinhalten',
    'convert_quote_setting'                           => 'Wenn ein Angebot in eine Rechnung umgewandelt wurde',
    'convert_quote_when_approved'                     => 'Angebot automatisch in eine Rechnung umwandeln, sobald der Kunde dieses bestätigt?',
    'converted_from_quote'                            => 'Umgewandelt von Angebot',
    'converted_to_invoice'                            => 'Umgewandelt in Rechnung',
    'country'                                         => 'Land',
    'create_invoice'                                  => 'Rechnung erstellen',
    'create_quote'                                    => 'Angebot erstellen',
    'created'                                         => 'Erstellt',
    'credit_card'                                     => 'Kreditkarte',
    'currencies'                                      => 'Währungen',
    'currency'                                        => 'Währung',
    'currency_form'                                   => 'Währung bearbeiten',
    'currency_symbol'                                 => 'Währungssymbol',
    'currency_symbol_placement'                       => 'Platzierung des Währungssymbol',
    'custom_date_range'                               => 'Eigener Zeitraum',
    'custom_field_form'                               => 'Eigenes Feld bearbeiten',
    'custom_fields'                                   => 'Eigene Felder',
    'cvc'                                             => 'Sicherheitsnummer',
    'dashboard'                                       => 'Übersicht',
    'dashboard_totals_option'                         => 'Beträge in der Übersicht sollten beinhalten',
    'database_not_configured'                         => 'Die Datenbank muss noch in der Datei config/database.php konfiguriert werden.',
    'database_setup'                                  => 'Datenbank-Installation',
    'date'                                            => 'Datum',
    'date_format'                                     => 'Datumsformat',
    'days'                                            => 'Tage',
    'decimal_point'                                   => 'Dezimalpunkt',
    'default_currency'                                => 'Standardwährung',
    'default_footer'                                  => 'Standard-Fußzeile',
    'default_group'                                   => 'Standard-Gruppe',
    'default_invoice_email_body'                      => 'Standard E-Mail Text für eine Rechnung',
    'default_invoice_template'                        => 'Standard-Rechnungsvorlage',
    'default_item_tax_2_rate'                         => 'Standard Artikel Steuerrate',
    'default_item_tax_rate'                           => 'Standard-Artikelsteuer',
    'default_overdue_invoice_email_body'              => 'Standard E-Mail Text bei überfälliger Rechnung',
    'default_payment_receipt_body'                    => 'Standard E-Mail Text für eine Zahlungsbestätigung',
    'default_quote_email_body'                        => 'Standard E-Mail Text für ein Angebot',
    'default_quote_template'                          => 'Standard-Angebotsvorlage',
    'default_terms'                                   => 'Standard-Rechnungsbedingungen',
    'delete'                                          => 'Löschen',
    'delete_client_warning'                           => 'Sind Sie sicher, dass Sie diesen Kunden inkl. all seiner Rechnungen löschen möchten?',
    'delete_record_warning'                           => 'Sind Sie sicher, dass Sie den Eintrag löschen möchten?',
    'description'                                     => 'Beschreibung',
    'details'                                         => 'Details',
    'disabled'                                        => 'Deaktiviert',
    'discount'                                        => 'Ermäßigung',
    'display_client_unique_name'                      => 'Einzigartigen Kundennamen anzeigen',
    'display_do_not_require'                          => 'Anzeigen, aber nicht benötigen',
    'display_order'                                   => 'Ansichtsreihenfolge',
    'display_profile_image'                           => 'Profil Bild anzeigen',
    'do_not_add_line_item_to_invoice'                 => 'Fügen Sie der Rechnung keine Werbebuchung hinzu',
    'do_not_display'                                  => 'Nicht anzeigen',
    'documentation'                                   => 'Dokumentation',
    'download'                                        => 'Download',
    'draft'                                           => 'Entwürfe',
    'draft_invoices'                                  => 'Entworfene Rechnungen',
    'draft_quotes'                                    => 'Entworfene Angebote',
    'dropdown'                                        => 'Dropdown',
    'due'                                             => 'Bis',
    'due_date'                                        => 'Zahlungsdatum',
    'edit'                                            => 'Bearbeiten',
    'edit_client'                                     => 'Kunde editieren',
    'email'                                           => 'E-Mail',
    'email_address'                                   => 'E-Mail Adresse',
    'email_invoice'                                   => 'Rechnungs-E-Mail',
    'email_payment_receipt'                           => 'Zahlungsbestätigung per E-Mail',
    'email_quote'                                     => 'Angebots-E-Mail',
    'email_send_method'                               => 'E-Mail-Sendemethode',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'SendGrid-API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Aktiviert',
    'enter_payment'                                   => 'Zahlung eingeben',
    'error'                                           => 'Fehler',
    'every'                                           => 'Alle',
    'exchange_rate'                                   => 'Wechselkurs',
    'exchange_rate_mode'                              => 'Wechselkurs-Methode',
    'expense_form'                                    => 'Ausgaben Formular',
    'expenses'                                        => 'Ausgaben',
    'expiration'                                      => 'Ablaufdatum',
    'expires'                                         => 'Gültig bis',
    'export_clients'                                  => 'Kunden exportieren',
    'export_data'                                     => 'Daten exportieren',
    'export_expenses'                                 => 'Exportausgaben',
    'export_invoice_items'                            => 'Rechnungsartikel exportieren',
    'export_invoices'                                 => 'Rechnungen exportieren',
    'export_payments'                                 => 'Zahlungen exportieren',
    'export_quote_items'                              => 'Angebotsartikel exportieren',
    'export_quotes'                                   => 'Angebote exportieren',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Faxnummer',
    'field_label'                                     => 'Feldbezeichnung',
    'field_meta'                                      => 'Felddaten',
    'field_meta_description'                          => 'Felddaten werden nur benötigt, wenn das Feld ein Dropdown-Feld ist. Die einzelnen Werte müssen durch Kommas getrennt werden.',
    'field_type'                                      => 'Feldtyp',
    'footer'                                          => 'Fußzeile',
    'format'                                          => 'Format',
    'frequency'                                       => 'Häufigkeit',
    'from'                                            => 'Von',
    'from_date'                                       => 'Von-Datum',
    'general'                                         => 'Allgemein',
    'generate_keys'                                   => 'Schlüssel generieren',
    'group'                                           => 'Nummerngruppe',
    'group_form'                                      => 'Nummerngruppe bearbeiten',
    'groups'                                          => 'Nummerngruppen',
    'header_title_text'                               => 'Überschrift',
    'help'                                            => 'Hilfe',
    'help_currency_code'                              => 'Der Währungscode, z.B. "EUR".',
    'help_currency_name'                              => 'Der Währungsname, z.B. "Euro".',
    'help_currency_symbol'                            => 'Das Währungssymbol, z.B. "€".',
    'help_currency_symbol_placement'                  => 'Die Position des Währungssymbols.',
    'help_text_client_name'                           => 'Dieser Wert kann der Name der Firma oder der Person sein und wird auf Angeboten oder Rechnungen angezeigt. Dieser Wert muss nicht einzigartig sein.',
    'help_text_client_password'                       => 'Dieses Feld leer lassen wenn kein Passwort erstellt oder geändert werden soll.',
    'help_text_client_unique_name'                    => 'Wenn einer oder mehr Kunden im System den selben Namen teilen, muss ein einzigartiger Name angegeben werden um diese zu unterscheiden. Dieser Wert wird nicht auf Angeboten oder Rechnungen angezeigt.',
    'i_accept'                                        => 'Akzeptieren',
    'import_data'                                     => 'Daten importieren',
    'inactive'                                        => 'Inaktiv',
    'income'                                          => 'Einnahmen',
    'install'                                         => 'Installieren',
    'installation_complete'                           => 'Installation abgeschlossen',
    'installing_please_wait'                          => 'Installation läuft, bitte warten...',
    'invalid_credentials'                             => 'Ungültige Anmeldedaten',
    'invoice'                                         => 'Rechnung',
    'invoice_default'                                 => 'Standard-Rechnung',
    'invoice_email_subject'                           => 'E-Mail Betreff für eine Rechnung',
    'invoice_items'                                   => 'Rechnungsposten',
    'invoice_number'                                  => 'Rechnungsnummer',
    'invoice_summary'                                 => 'Rechnungszusammenfassung',
    'invoiced'                                        => 'In Rechnung gestellt',
    'invoices'                                        => 'Rechnungen',
    'invoices_due_after'                              => 'Zahlungsfrist',
    'issued'                                          => 'Ausgestellt',
    'item'                                            => 'Artikel',
    'item_lookup_form'                                => 'Artikel bearbeiten',
    'item_lookups'                                    => 'Artikel',
    'item_sales'                                      => 'Verkaufte Artikel',
    'items'                                           => 'Artikel',
    'label_invoice'                                   => 'Die Rechnung auswählen zu der die Ausgaben hinzugefügt werden soll',
    'label_item_description'                          => 'Eine Beschreibung dieser Ausgaben eingeben (optional)',
    'label_item_name'                                 => 'Name des Postens eingeben, der zu der Rechnung hinzugefügt werden soll',
    'landscape'                                       => 'Querformat',
    'language'                                        => 'Sprache',
    'left_pad'                                        => 'Anzahl Ziffern',
    'left_pad_description'                            => 'Die Anzahl der Nullstellen um die die nächste Nummer optional aufgefüllt wird.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Letter',
    'license_agreement'                               => 'Lizenzbestimmungen',
    'license_agreement_accept'                        => 'Ich akzeptiere die Lizenzbestimmungen',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Es scheint so, dass sich der Geheime Schlüssel geändert hat seit dem Sie das letzte Mal Ihr E-Mail Passwort geändert haben. Um diesen Fehler zu beheben gehen Sie auf die Sytemeinstellungen -> E-Mail Ansicht, geben Ihr E-Mail Passwort erneut ein und speichern. Beachten Sie, dass keine E-Mail verschickt wird solange dieser Fehler nicht behoben wurde.',
    'manual'                                          => 'Manuell',
    'map_fields_to_import'                            => 'Felder zuweisen',
    'merchant_api_key'                                => 'API Key',
    'merchant_api_password'                           => 'API Passwort',
    'merchant_api_username'                           => 'API Username',
    'merchant_publishable_key'                        => 'Öffentlicher Schlüssel',
    'merchant_secret_key'                             => 'Geheimer Schlüssel',
    'merchant_signature'                              => 'Signatur',
    'mobile'                                          => 'Handy',
    'mobile_number'                                   => 'Handynummer',
    'monthly'                                         => 'Monatlich',
    'months'                                          => 'Monate',
    'multiple_email_validation'                       => 'Mehrfache E-Mail Adressen müssen gültig sein und mit Komma getrennt werden.',
    'name'                                            => 'Name',
    'net_income'                                      => 'Nettoeinnahmen',
    'never'                                           => 'Niemals',
    'new'                                             => 'Neu',
    'next_date'                                       => 'Nächstes Datum',
    'next_number'                                     => 'Nächste Nummer',
    'no'                                              => 'Nein',
    'no_open_invoices'                                => 'Dieser Kunde hat keine offenen Rechnungen. Um Ausgaben in Rechnung zu stellen muss der Kunde mindestens eine Rechnung haben die noch nicht voll bezahlt wurde.',
    'no_records_found'                                => 'Keine Einträge gefunden.',
    'none'                                            => 'Keine',
    'not_billable'                                    => 'Nicht abrechnungsfähig',
    'not_billed'                                      => 'Nicht abgerechnet',
    'not_viewed'                                      => 'Nicht angesehen',
    'not_visible'                                     => 'Nicht sichtbar',
    'note'                                            => 'Notiz',
    'note_notification'                               => 'Hinweis: Neue Notiz',
    'notes'                                           => 'Notizen',
    'online_payment'                                  => 'Online-Zahlung',
    'online_payment_method'                           => 'Online-Zahlungsmethode',
    'online_payments'                                 => 'Online Zahlungen',
    'options'                                         => 'Optionen',
    'other'                                           => 'Andere',
    'output_type'                                     => 'Ausgabe',
    'overdue'                                         => 'Überfällig',
    'overdue_email_subject'                           => 'E-Mail Betreff für eine überfällige Rechnung',
    'overdue_invoice_reminder'                        => 'Erinnerung an überfällige Rechnungen',
    'overdue_invoice_reminder_frequency'              => 'Häufigkeit der Erinnerung an überfällige Rechnungen',
    'overdue_invoice_reminder_frequency_help'         => 'Eine Komma separierte Liste von Tagen an denen eine Erinnerung für die Fälligkeit einer Rechnung geschickt wird. Leer lassen um die Erinnerung an überfällige Rechnungen zu deaktivieren. Als Beispiel: ein Wert von 1,5,10 würde Erinnerungen 1, 5 und 10 Tage nach der Fälligkeit der Rechnung verschicken.',
    'overdue_invoices'                                => 'Überfällige Rechnungen',
    'paid'                                            => 'Bezahlt',
    'paper_orientation'                               => 'Seitenausrichtung',
    'paper_size'                                      => 'Papiergröße',
    'password'                                        => 'Passwort',
    'password_confirmation'                           => 'Passwort-Bestätigung',
    'password_successfully_reset'                     => 'Passwort erfolgreich zurückgesetzt',
    'pay'                                             => 'Bezahlen',
    'pay_now'                                         => 'Jetzt zahlen',
    'payment_applied'                                 => 'Die Zahlung wurde eingegeben',
    'payment_button_text'                             => 'Bezahlknopftext',
    'payment_date'                                    => 'Zahlungsdatum',
    'payment_form'                                    => 'Zahlung bearbeiten',
    'payment_method'                                  => 'Zahlungsmethode',
    'payment_method_form'                             => 'Zahlungsmethode bearbeiten',
    'payment_methods'                                 => 'Zahlungsmethoden',
    'payment_receipt'                                 => 'Zahlungsbestätigung',
    'payment_receipt_email_subject'                   => 'E-Mail Betreff für einer Zahlungsbestätigung',
    'payments'                                        => 'Zahlungen',
    'payments_collected'                              => 'Erhaltene Zahlungen',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF-Konvertierer',
    'pdf_driver_wkhtmltopdf'                          => 'Das Feld Binärpfad muss einen gültigen Dateipfad enthalten, wenn Sie den wkhtmltopdf PDF-Treiber verwenden.',
    'percent'                                         => 'Prozent',
    'phone'                                           => 'Telefon',
    'phone_number'                                    => 'Telefonnummer',
    'php_version_error'                               => 'Es ist mindestens PHP-Version %s erforderlich.',
    'placeholder_type_message'                        => 'Nachricht eingeben...',
    'portrait'                                        => 'Hochformat',
    'postal_code'                                     => 'Postleitzahl',
    'prefix'                                          => 'Präfix',
    'prerequisites'                                   => 'Systemvoraussetzungen',
    'preview'                                         => 'Vorschau',
    'price'                                           => 'Preis',
    'private'                                         => 'Privat',
    'problem_with_email_template'                     => 'Es besteht anscheinend ein Problem mit dem E-Mail Template. Überprüfen Sie die Templates in dem Systemeinstellungen im E-Mail Tab.',
    'product'                                         => 'Produkt',
    'profit_and_loss'                                 => 'Gewinn und Verlust',
    'public'                                          => 'Öffentlich',
    'qty'                                             => 'Anz',
    'quantity'                                        => 'Anzahl',
    'quantity_price_decimals'                         => 'Anzahl der Dezimalstellen für Mengen und Beträge',
    'quote'                                           => 'Angebot',
    'quote_approved'                                  => 'Angebot akzeptiert',
    'quote_approved_email_body'                       => 'Standard E-Mail Text für bestätigte Angebote',
    'quote_default'                                   => 'Standardangebot',
    'quote_email_subject'                             => 'E-Mail Betreff für ein Angebot',
    'quote_items'                                     => 'Angebotsposten',
    'quote_number'                                    => 'Angebotsnummer',
    'quote_rejected'                                  => 'Angebot abgelehnt',
    'quote_rejected_email_body'                       => 'Standard E-Mail Text für abgelehnte Angebote',
    'quote_status_change_notification'                => 'Hinweis: Angebotsstatus geändert',
    'quote_summary'                                   => 'Angebotszusammenfassung',
    'quote_to_invoice'                                => 'Angebot in Rechnung umwandeln',
    'quotes'                                          => 'Angebote',
    'quotes_expire_after'                             => 'Angebote, die bald auslaufen (Tage)',
    'recalculate'                                     => 'Neuberechnung',
    'recalculate_help_text'                           => 'Die Neuberechnung dauert einige Momente. Es wird eine Nachricht angezeigt sobald die Neuberechnung abgeschlossen ist.',
    'recalculate_invoices'                            => 'Rechnungen neuberechnen',
    'recalculate_quotes'                              => 'Angebote neuberechnen',
    'recalculating_wait'                              => 'Neuberechnung, bitte warten...',
    'recalculation_complete'                          => 'Neuberechnung abgeschlossen',
    'recent_invoices'                                 => 'Aktuelle Rechnungen',
    'recent_payments'                                 => 'Aktuelle Zahlungen',
    'recent_quotes'                                   => 'Aktuelle Angeboten',
    'record_not_found'                                => 'Eintrag nicht gefunden',
    'record_successfully_created'                     => 'Eintrag erstellt',
    'record_successfully_deleted'                     => 'Eintrag gelöscht',
    'record_successfully_updated'                     => 'Eintrag aktualisiert',
    'records_imported_successfully'                   => 'Einträge importiert',
    'recurring'                                       => 'Wiederkehrende',
    'reject'                                          => 'Ablehnen',
    'rejected'                                        => 'Abgelehnt',
    'rejected_quotes'                                 => 'Abgelehnte Angebote',
    'remember_me'                                     => 'Erinnere dich an mich',
    'remove_logo'                                     => 'Logo entfernen',
    'report_rev_client_notice'                        => 'Dieser Bericht ist verfügbar, sobald Zahlungen für diesen Kunden hinterlegt sind.',
    'reports'                                         => 'Berichte',
    'require'                                         => 'Benötigt',
    'reset_number'                                    => 'Nummer zurücksetzen',
    'reset_password'                                  => 'Passwort zurücksetzen',
    'results_per_page'                                => 'Ergebnisse pro Seite',
    'revenue_by_client'                               => 'Einnahmen pro Kunde',
    'round_tax_decimals'                              => 'Anzahl Dezimalstellen für Steuerrundung',
    'run_report'                                      => 'Bericht erstellen',
    'save'                                            => 'Speichern',
    'save_and_apply_exchange_rate'                    => 'Wechselkurs speichern und anwenden',
    'save_item_as_lookup'                             => 'Artikel speichern',
    'search'                                          => 'Suche',
    'select_file_to_import'                           => 'Datei zum Importieren auswählen',
    'send'                                            => 'Senden',
    'sending'                                         => 'Senden',
    'sendmail_path'                                   => 'Sendmail-Pfad',
    'sent'                                            => 'Versandt',
    'sent_invoices'                                   => 'Versandte Rechnungen',
    'sent_quotes'                                     => 'Versandte Angebote',
    'settings'                                        => 'Einstellungen',
    'settings_successfully_saved'                     => 'Einstellungen gespeichert',
    'setup'                                           => 'Installation',
    'sign_in'                                         => 'Anmelden',
    'sign_out'                                        => 'Abmelden',
    'skin'                                            => 'Skin',
    'smtp_encryption'                                 => 'SMTP-Verschlüsselung',
    'smtp_host_address'                               => 'SMTP-Server',
    'smtp_host_port'                                  => 'SMTP-Port',
    'smtp_password'                                   => 'SMTP-Passwort',
    'smtp_username'                                   => 'SMTP-Benutzername',
    'start_date'                                      => 'Startdatum',
    'state'                                           => 'Bundesland',
    'status'                                          => 'Status',
    'step_database_setup'                             => 'Die Datenbank wird jetzt angelegt bzw. aktualisiert.',
    'step_prerequisites'                              => 'Die Installation kann nicht durchgeführt werden, solange folgende Systemvoraussetzungen nicht erfüllt sind:',
    'subject'                                         => 'Betreff',
    'submit'                                          => 'Absenden',
    'subtotal'                                        => 'Zwischensumme',
    'summary'                                         => 'Zusammenfassung',
    'symbol'                                          => 'Symbol',
    'symbol_placement'                                => 'Symbolposition',
    'system'                                          => 'System',
    'system_settings'                                 => 'Systemeinstellungen',
    'table_name'                                      => 'Tabellenname',
    'tax'                                             => 'Steuer',
    'tax_1'                                           => 'Steuer 1',
    'tax_2'                                           => 'Steuer 2',
    'tax_rate'                                        => 'Steuersatz',
    'tax_rate_form'                                   => 'Steuer bearbeiten',
    'tax_rate_name'                                   => 'Steuername',
    'tax_rate_percent'                                => 'Steuersatz (Prozent)',
    'tax_rates'                                       => 'Steuersatz',
    'tax_summary'                                     => 'Steuern',
    'taxable_amount'                                  => 'Versteuerbare Summe',
    'taxes'                                           => 'Steuern',
    'template'                                        => 'Vorlage',
    'terms_and_conditions'                            => 'Rechnungsbedingungen',
    'test_mode'                                       => 'Testmodus',
    'text'                                            => 'Text',
    'textarea'                                        => 'Textfeld',
    'this_quarter'                                    => 'Dieses Quartal',
    'thousands_separator'                             => 'Tausender-Trennzeichen',
    'timezone'                                        => 'Zeitzone',
    'to'                                              => 'An',
    'to_date'                                         => 'Bis-Datum',
    'total'                                           => 'Summe',
    'total_balance'                                   => 'Gesamtsumme',
    'total_invoiced'                                  => 'Gesamt in Rechnung gestellt',
    'total_expenses'                                  => 'Gesamtausgaben',
    'total_paid_invoices'                             => 'Gesamtzahl der bezahlten Rechnungen',
    'try_again'                                       => 'Erneut versuchen',
    'uninstall'                                       => 'Deinstallieren',
    'uninstall_addon_warning'                         => 'Deinstallieren dieses Add-ons löscht alle Daten die innerhalb des Add-ons eingegeben wurden. Sind Sie sicher, dass Sie fortfahren wollen?',
    'unique_name'                                     => 'Einzigartiger Name',
    'unknown_error'                                   => 'Unbekannter Fehler',
    'upcoming_payment_notice_email_body'              => 'Standard E-Mail Text bei Zahlungserinnerung',
    'upcoming_payment_notice_email_subject'           => 'E-Mail Betreff für eine Zahlungserinnerung',
    'upcoming_payment_notice_frequency'               => 'Häufigkeit der Zahlungserinnerung',
    'upcoming_payment_notice_frequency_help'          => 'Eine Komma separierte List von Tagen BEVOR eine Rechnung überfällig ist. Leer lassen um Zahlungserinnerungen zu deaktivieren. Als Beispiel, ein Wert von 1,5 verschickt Erinnerungen 1 und 5 Tage bevor eine Rechnung überfällig ist.',
    'update_available'                                => 'FusionInvoice :version ist zum Download verfügbar!',
    'update_exchange_rate'                            => 'Wechselkurs aktualisieren',
    'update_not_available'                            => 'Im Moment sind keine Updates verfügbar.',
    'upload_progress'                                 => 'Upload Fortschritt',
    'user'                                            => 'Nutzer',
    'user_accounts'                                   => 'Benutzer',
    'user_form'                                       => 'Benutzer bearbeiten',
    'users'                                           => 'Benutzer',
    'validation_invoice_summary_from_date'            => 'Das Datum aus dem Invoice Summary Dashboard Widget ist erforderlich, wenn der Datumsbereich auf Custom Date Range gesetzt ist.',
    'validation_invoice_summary_to_date'              => 'Das bisherige Datum auf dem Invoice Summary Dashboard Widget ist erforderlich, wenn Sie einen benutzerdefinierten Zeitraum verwenden.',
    'validation_quote_summary_from_date'              => 'Das Datum aus dem Zitat Zusammenfassung Dashboard Widget ist erforderlich, wenn Sie einen benutzerdefinierten Zeitraum verwenden.',
    'validation_quote_summary_to_date'                => 'Das bis jetzt auf dem Zitat Zusammenfassung Dashboard Widget ist erforderlich, wenn Sie einen benutzerdefinierten Zeitraum verwenden.',
    'vendor'                                          => 'Anbieter',
    'version'                                         => 'Version',
    'view'                                            => 'Ansicht',
    'view_all'                                        => 'Alles anzeigen',
    'view_all_invoices_for_client'                    => 'Alle Rechnungen dieses Kunden anzeigen',
    'view_all_payments_for_client'                    => 'Alle Zahlungen dieses Kunden anzeigen',
    'view_all_quotes_for_client'                      => 'Alle Angebote dieses Kunden anzeigen',
    'view_approved_quotes'                            => 'Akzeptierte Angebote anzeigen',
    'view_client'                                     => 'Kunde anzeigen',
    'view_draft_invoices'                             => 'Rechnungsentwürfe anzeigen',
    'view_draft_quotes'                               => 'Entworfene Angebote anzeigen',
    'view_overdue_invoices'                           => 'Überfällige Rechnungen anzeigen',
    'view_payments'                                   => 'Zahlungen anzeigen',
    'view_rejected_quotes'                            => 'Abgelehnte Angebote anzeigen',
    'view_sent_invoices'                              => 'Versandte Rechnungen anzeigen',
    'view_sent_quotes'                                => 'Versandte Angebote anzeigen',
    'view_unique_name'                                => 'Zeige einzigartigen Namen',
    'viewed'                                          => 'Angesehen',
    'visible'                                         => 'Sichtbar',
    'visible_after_payment'                           => 'Sichtbar nach Bezahlung',
    'web'                                             => 'Webseite',
    'web_address'                                     => 'Webseiten-URL',
    'weekly'                                          => 'Wöchentlich',
    'weeks'                                           => 'Wochen',
    'welcome'                                         => 'Willkommen',
    'what_to_import'                                  => 'Was möchten Sie importieren?',
    'year'                                            => 'Jahr',
    'yearly'                                          => 'Jährlich',
    'years'                                           => 'Jahre',
    'yes'                                             => 'Ja',
    'you_may_now_sign_in'                             => 'Sie können sich nun anmelden!',

    // 2017-1
    'all_company_profiles'                            => 'Alle Firmenprofile',
    'cannot_delete_record_in_use'                     => 'Dieser Datensatz wird verwendet und kann nicht gelöscht werden.',
    'cannot_edit_record_in_use'                       => 'Dieser Datensatz wird verwendet und kann nicht bearbeitet werden.',
    'change_company_profile'                          => 'Firmenprofil ändern',
    'company_profile'                                 => 'Firmenprofil',
    'company_profiles'                                => 'Firmenprofile',
    'company_profile_form'                            => 'Firmenprofilformular',
    'copy'                                            => 'Kopieren',
    'create_recurring_invoice'                        => 'Wiederkehrende Rechnung erstellen',
    'custom'                                          => 'Benutzerdefiniert',
    'date_range'                                      => 'Datumsbereich',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mo.',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'Wir',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr.',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Standard-Firmenprofil',
    'first_quarter'                                   => 'Erstes Viertel',
    'fourth_quarter'                                  => 'Viertes Viertel',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Letzten 7 Tage',
    'last_30_days'                                    => 'Letzte 30 Tage',
    'last_month'                                      => 'Letzten Monat',
    'last_quarter'                                    => 'Letztes Vierteljahr',
    'last_year'                                       => 'Vergangenes Jahr',
    'month_january'                                   => 'Januar',
    'month_february'                                  => 'Februar',
    'month_march'                                     => 'März',
    'month_april'                                     => 'April',
    'month_may'                                       => 'Mai',
    'month_june'                                      => 'Juni',
    'month_july'                                      => 'Juli',
    'month_august'                                    => 'August',
    'month_september'                                 => 'September',
    'month_october'                                   => 'Oktober',
    'month_november'                                  => 'November',
    'month_december'                                  => 'Dezember',
    'recurring_invoice'                               => 'Wiederkehrende Rechnung',
    'second_quarter'                                  => 'Zweites Viertel',
    'stop_date'                                       => 'Stoppdatum',
    'third_quarter'                                   => 'Drittes Quartal',
    'this_month'                                      => 'Diesen Monat',
    'this_year'                                       => 'Dieses Jahr',
    'today'                                           => 'Heute',
    'user_account'                                    => 'Benutzerkonto',
    'yesterday'                                       => 'Gestern',

    // 2017-3
    'mail_log'                                        => 'E-Mail-Protokoll',
    'recent_client_activity'                          => 'Letzte Kundenaktivität',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Unbezahlte Rechnungen ausschließen',

    // 2017-7
    'please_wait'                                     => 'Warten Sie mal...',
    'reply_to_address'                                => 'Antwortadresse',

    // 2017-8
    'admin'                                           => 'Administrator',
    'admin_account'                                   => 'Administratorkonto',
    'admin_accounts'                                  => 'Administratorkonten',
    'all_accounts'                                    => 'Alle Konten',
    'api_key'                                         => 'API-Schlüssel',
    'client_account'                                  => 'Kundenkonto',
    'client_accounts'                                 => 'Kundenkonten',
    'client_id'                                       => 'Kunden ID',
    'client_secret'                                   => 'Kundengeheimnis',
    'enable_bitcoin_payments'                         => 'Aktivieren Sie Bitcoin-Zahlungen',
    'live'                                            => 'Leben',
    'mode'                                            => 'Modus',
    'publishable_key'                                 => 'Veröffentlichbarer Schlüssel',
    'sandbox'                                         => 'Sandkasten',
    'secret_key'                                      => 'Geheimer Schlüssel',
    'type'                                            => 'Art',

    // 2017-10
    'deselect_all'                                    => 'Alle abwählen',
    'select_all'                                      => 'Wählen Sie Alle',
    'use_24_hour_time_format'                         => 'Verwenden Sie das 24-Stunden-Zeitformat',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Möchten Sie diese Datensätze wirklich löschen?',
    'bulk_invoice_change_status_warning'              => 'Möchten Sie den Status der ausgewählten Rechnung (en) wirklich ändern?',
    'bulk_quote_change_status_warning'                => 'Möchten Sie den Status der ausgewählten Angebote wirklich ändern?',
    'calculate_as_vat_gst'                            => 'Berechnen Sie als MwSt. / GST',
    'change_status'                                   => 'Status ändern',
    'default_status_filter'                           => 'Standardstatusfilter',
    'error_applying_payment'                          => 'Bei der Anwendung dieser Zahlung ist ein Fehler aufgetreten. Bitte versuchen Sie es mit einer anderen Karte oder Zahlungsmethode.',
    'remaining'                                       => 'Verbleibend',

    // 2017-12
    'invoice_date'                                    => 'Rechnungsdatum',
    'include_profit_based_on'                         => 'Gewinn basierend auf einbeziehen',

    // 2018-1
    'add_contact'                                     => 'Kontakt hinzufügen',
    'allow_self_signed_cert'                          => 'Selbstsigniertes Zertifikat zulassen',
    'backup'                                          => 'Backup',
    'close'                                           => 'Schließen',
    'change_invoice_date_to_todays_date'              => 'Ändern Sie das Rechnungsdatum in das heutige Datum',
    'change_quote_date_to_todays_date'                => 'Ändern Sie das Angebotsdatum in das heutige Datum',
    'contacts'                                        => 'Kontakte',
    'default_bcc'                                     => 'Standard-BCC',
    'default_cc'                                      => 'Standard-CC',
    'default_to'                                      => 'Standard zu',
    'disable'                                         => 'Deaktivieren',
    'download_database_backup'                        => 'Laden Sie die Datenbanksicherung herunter',
    'edit_contact'                                    => 'Kontakt bearbeiten',
    'expense_list'                                    => 'Spesenliste',
    'keep_invoice_date_as_is'                         => 'Rechnungsdatum unverändert lassen',
    'keep_quote_date_as_is'                           => 'Angebotsdatum unverändert lassen',
    'if_quote_is_emailed_while_draft'                 => 'Wenn das Angebot im Entwurfsstatus per E-Mail gesendet wird',

    // 2018-4
    'force_https'                                     => 'HTTPS erzwingen',
    'force_https_help'                                => 'Stellen Sie vor dem Aktivieren dieser Option sicher, dass Ihre FusionInvoice-Installation über https funktioniert. Andernfalls kann es zu einer nicht funktionsfähigen (aber reparierbaren) Installation kommen.',

    // 2019-1
    'attached_to'                                     => 'Angebracht an',
    'customer'                                        => 'Kunde',
    'expense'                                         => 'Kosten',
    'expense_categories'                              => 'Ausgabenkategorien',
    'expense_category_form'                           => 'Formular für Ausgabenkategorien',
    'expense_vendors'                                 => 'Kostenanbieter',
    'expense_vendor_form'                             => 'Spesenabrechnungsformular',
    'lead'                                            => 'Führen',
    'local_time'                                      => 'Ortszeit',
    'prospect'                                        => 'Aussicht',
    'search_clients'                                  => 'Kunden suchen',
    'search_expenses'                                 => 'Suchkosten',
    'search_invoices'                                 => 'Rechnungen durchsuchen',
    'search_items'                                    => 'Artikel suchen',
    'search_log'                                      => 'Suchprotokoll',
    'search_quotes'                                   => 'Zitate suchen',
    'search_payments'                                 => 'Zahlungen suchen',
    'search_recurring_invoices'                       => 'Suche nach wiederkehrenden Rechnungen',
    'show_all_statuses'                               => 'Alle Status anzeigen',
    'show_all_types'                                  => 'Alle Typen anzeigen',
    'unknown'                                         => 'Unbekannt',
    'value'                                           => 'Wert',

    // 2019-2
    'default'                                         => 'Standard',
    'no_data_available'                               => 'Keine Daten verfügbar',
    'recurring_invoice_list'                          => 'Wiederkehrende Rechnungsliste',
    'report_total'                                    => 'Gesamtsummen melden',

    //2019-3
    'checkbox'                                        => 'Kontrollkästchen',
    'custom_dropdown_validate'                        => 'Bitte wählen Sie eine gültige Option aus dem Feld :label',
    'custom_image_validate'                           => 'Bitte wählen Sie ein gültiges Bild.',
    'custom_tag_validate'                             => 'Bitte wählen Sie ein gültiges Tag aus :label',
    'custom_text_validate'                            => 'Bitte geben Sie ein gültiges :label in das Feld :label ein.',
    'datetime'                                        => 'Terminzeit',
    'decimal'                                         => 'Dezimal',
    'delete-confirm'                                  => 'Bist du sicher?',
    'grand_total'                                     => 'Gesamtsumme',
    'image'                                           => 'Bild',
    'integer'                                         => 'Ganze Zahl',
    'mailed'                                          => 'Mailed',
    'mailed_invoices'                                 => 'Gesendete Rechnungen',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'Wiederkehrende ID',
    'remove_image'                                    => 'Entferne Bild',
    'tags'                                            => 'Stichworte',
    'tagselection'                                    => 'Tag-Auswahl',
    'unpaid'                                          => 'Unbezahlt',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Gesendete Rechnungen anzeigen',
    'important'                                       => 'Wichtig!',
    'created_recurring_invoice_id'                    => 'Erstellt aus der ID für wiederkehrende Rechnungen',
    'mr'                                              => 'Herr.',
    'miss'                                            => 'Fräulein',
    'ms'                                              => 'Frau.',
    'mrs'                                             => 'Frau.',
    'dr'                                              => 'DR.',
    'prof'                                            => 'Prof. Prof.',
    'select_title'                                    => 'Kontakttitel',
    'title'                                           => 'Titel',
    'test_email_subject'                              => 'Hallo von FusionInvoice',
    'test_email_body'                                 => 'Dies ist eine Test-E-Mail von FusionInvoice.',
    'test_email_address'                              => 'E-Mail-Test senden an',
    'send_test_email'                                 => 'Test-E-Mail senden',
    'invalid_json'                                    => 'Bitte geben Sie eine gültige JSON-Zeichenfolge ein',
    'textarea_rows_limit'                             => 'Zeilen dürfen :limit nicht überschreiten',
    'custom_integer_validate'                         => ':label muss ein gültiger ganzzahliger Wert sein',

    //2020-1
    'user_role'                                       => 'Benutzer-Rolle',
    'standard_user'                                   => 'Standardbenutzer',
    'permissions'                                     => 'Berechtigungen',
    'modules'                                         => 'Module',
    'is_view'                                         => 'Aussicht',
    'is_create'                                       => 'Erstellen',
    'is_update'                                       => 'Aktualisieren',
    'is_delete'                                       => 'Löschen',
    'dashboards'                                      => 'Dashboards',
    'allow_time_period_change'                        => 'Änderung des Zeitraums zulassen',
    'page_not_found'                                  => 'Hoppla! Seite nicht gefunden.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => 'Sie sind nicht berechtigt, Kunden zu erstellen!',
    'check-all'                                       => 'Alle überprüfen',
    'invoice_prefix'                                  => 'Rechnungspräfix',
    'recently_viewed'                                 => 'zuletzt angesehen',
    'copy_from'                                       => 'Kopie von',
    'select_user'                                     => 'Nutzer wählen',
    'please_select_user'                              => 'Bitte wählen Sie einen Benutzer aus der Liste aus',
    'allow_client_center_login'                       => 'Client Center-Anmeldung zulassen',
    'online_payment_processing_fee'                   => 'Gebühr für die Online-Zahlungsabwicklung',
    'client_password_required'                        => 'Bitte geben Sie das Passwort des Kunden ein',
    'last_login_at'                                   => 'Letzter Login um',
    'show_notes_panel_below_client'                   => 'Notizenfenster unter Client-Details anzeigen',
    'notepad'                                         => 'Notizblock',
    'added'                                           => 'Hinzugefügt',
    'last_edited'                                     => 'Zuletzt bearbeitet',
    'loading'                                         => 'Wird bearbeitet ....',
    'n_records_match'                                 => ':label Record :plural match',
    'initials'                                        => 'Initialen',
    'initials_bg_color'                               => 'Initialen Hintergrundfarbe',
    'more'                                            => 'Mehr',
    'must_match_all'                                  => 'Muss allen entsprechen',
    'clear'                                           => 'klar',
    'no_client_tags'                                  => 'Es sind keine Client-Datensätze mit definierten Tags vorhanden.',
    'qr_code_on_invoice_quote'                        => 'QR-Code auf Rechnung und Angebot',
    'delete_tags'                                     => 'Tag-Bereinigung',
    'orphan_tags_deleted'                             => 'Alle verwaisten Tags wurden erfolgreich aus dem System gelöscht.',
    'orphan_tags_delete_confirm'                      => 'Durch Ausführen der Tag-Bereinigung werden alle nicht verwendeten Tags entfernt. Fortsetzen?',
    'deleting_tags_wait'                              => 'Tags löschen, bitte warten ...',
    'new-version-available'                           => 'Neue Version verfügbar!',
    'ignore-this-version'                             => 'Ignoriere diese Version',
    'view-release-notes'                              => 'Versionshinweise anzeigen',
    'task_list'                                       => 'Aufgabenliste',
    'create_task'                                     => 'Aufgabe erstellen',
    'open'                                            => 'Öffnen',
    'closed'                                          => 'Geschlossen',
    'assignee'                                        => 'Beauftragter',
    'task'                                            => 'Aufgabe',
    'task_successfully_created'                       => 'Aufgabe erfolgreich erstellt',
    'task_successfully_updated'                       => 'Aufgabe erfolgreich aktualisiert',
    'task_completed'                                  => 'Aufgabe erfolgreich abgeschlossen',
    'task_marked_incomplete'                          => 'Aufgabe erneut geöffnet',
    'due_date_validation_date'                        => 'Bitte wählen Sie ein gültiges Fälligkeitsdatum',
    'assignee_validation_required'                    => 'Bitte wählen Sie einen gültigen Empfänger aus der Liste aus',
    'assignee_validation_exists'                      => 'Bitte wählen Sie einen gültigen Empfänger aus der Liste aus',
    'tomorrow'                                        => 'Morgen',
    'task_not_authorized'                             => 'Sie sind nicht berechtigt, diese Aufgabe zu bearbeiten!',
    'me'                                              => 'Mich',
    'task_from_note'                                  => 'Aufgabe beim Speichern erstellen',
    'done'                                            => 'Getan',
    'refresh'                                         => 'Aktualisierung',
    'task_list_page_size'                             => 'Anzahl der Aufgaben pro Seite',
    'select_client'                                   => 'Wählen Sie Client',
    'note-search-config'                              => 'Notizen Suche zum Einschließen',
    'username'                                        => 'Nutzername',
    'task-search-config'                              => 'Zu suchende Aufgabensuche',
    'task_section_invalid'                            => 'Ungültiger Aufgabenbereich',
    'task_section'                                    => 'Aufgabenbereich',
    'select_section'                                  => 'Abschnitt auswählen',
    'email-test-failed'                               => 'E-Mail-Test fehlgeschlagen',
    'smtp-setting-suggestion'                         => 'Vorschläge:<br>1. Überprüfen Sie Ihre Benutzer- / Kennwortwerte und geben Sie sie erneut ein<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Vorschläge:<br>1. Stellen Sie sicher, dass der PHP Mail-Server ordnungsgemäß konfiguriert ist<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Vorschläge:<br>1. Stellen Sie sicher, dass Ihr Sendmail-Pfad korrekt konfiguriert ist.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Vorschläge:<br>1. Stellen Sie sicher, dass Ihr Sendgrid-Schlüssel korrekt konfiguriert ist.<br>2. Contact server admin',
    'later'                                           => 'Später',
    'test-email-required'                             => 'Sie müssen eine gültige An-E-Mail-Adresse eingeben',
    'test_mail_sent_successfully'                     => 'Testmail erfolgreich gesendet',
    'test-mail-btn-title'                             => 'Änderungen müssen vor dem Testen gespeichert werden.',
    'agreement_expire'                                => 'Ihre Produktaktualisierungen und Ihr Support laufen auf :date ab',
    'agreement_expired'                               => 'Ihre Produktaktualisierungen und Ihr Support sind auf :date abgelaufen',
    'piracy_message'                                  => 'Ihr FusionInvoice-Lizenzschlüssel ist ungültig. Softwarepiraterie ist ein Verbrechen. Bitte spielen Sie fair. Mit einer gültigen Lizenz erhalten Sie Support, Updates und ein gutes Karma.',
    'buy-now'                                         => 'Kaufe jetzt',
    'piracy_alert'                                    => 'Bitte sei fair!',
    'agreement-expire-alert'                          => 'Produktaktualisierungen und Support laufen bald ab.',
    'agreement-expired-alert'                         => 'Produktaktualisierungen und Support sind abgelaufen.',
    'dismiss-forever'                                 => 'Für immer ablehnen',
    'renew-now'                                       => 'Jetzt erneuern',
    'select_all_permissions'                          => 'Wählen Sie Alle Berechtigungen',
    'app-key-missing'                                 => 'Bitte geben Sie Ihren Lizenzschlüssel in config / app.php ein.',
    'custom_fields_column_width'                      => 'Benutzerdefinierte Felder zeigen Spalten an',
    'select-user-type'                                => 'Wählen Sie Benutzertyp',
    'lead-or-prospect-with-invoices-error'            => 'Leider kann der Typ eines Kunden nicht Lead oder Prospect sein, wenn Rechnungen oder wiederkehrende Rechnungen vorhanden sind.',
    'sendgrid_key'                                    => 'Sendgrid-Schlüssel',

    //2020-2.0
    'space'                                           => 'Raum',
    'apostrophe'                                      => 'Apostroph',
    'comma'                                           => 'Komma',
    'fullstop'                                        => 'Punkt (Punkt)',
    'middledot'                                       => 'Mittlerer Punkt',
    'thinspace'                                       => 'Dünner Raum',
    'narrow-no-break-space'                           => 'Enger No-Break-Raum',
    'dotabove'                                        => 'Punkt oben',
    'arabic-decimal'                                  => 'Arabisches Dezimaltrennzeichen',
    'arabic-thousand'                                 => 'Arabisch Tausend Separator',
    'decimal-separator-key-symbol'                    => 'Dezimaltrennzeichen-Schlüsselsymbol',
    'select-item'                                     => 'Menüpunkt wählen',
    'item-lookup-overload'                            => 'Maximal 100 Artikel für die Artikelsuche zulässig',
    'select-expense-category'                         => 'Wählen Sie Ausgabenkategorie',
    'select-expense-vendor'                           => 'Wählen Sie Expense Vendor',
    'can-not-delete-all-users'                        => 'Sie können nicht alle Benutzer aus dem System löschen',
    'can-not-change-default-user-role'                => 'Sie können die Standardbenutzerrolle leider nicht ändern',
    'can-not-change-default-user-status'              => 'Sie können den Standardbenutzerstatus leider nicht ändern',
    'user_not_active'                                 => 'Benutzer ist nicht aktiv',
    'can-not-inactive-your-own-status'                => 'Sie können sich leider nicht selbst inaktiv machen.',
    'delete_user_warning'                             => '<p>HALT! Das Löschen dieses Benutzers ist eine zerstörerische Aktion, mit der möglicherweise im System erstellte Datensätze entfernt werden. Bitte erwägen Sie stattdessen, den Benutzer inaktiv zu machen.</p><p>Möchten Sie diesen Benutzer wirklich löschen?</p>',
    'include_time_in_due_date'                        => 'Zeit in Fälligkeitsdatum einschließen',
    'cannot_delete_default_company'                   => 'Sie können das Standard-Unternehmensprofil nicht löschen',
    'make-user-inactive'                              => 'Benutzer inaktiv machen',
    'mail_from_address'                               => 'Mail von Adresse',
    'mail_from_name'                                  => 'Mail vom Namen',
    'item_categories'                                 => 'Artikelkategorien',
    'select-item-category'                            => 'Wählen Sie Artikelkategorie',
    'item_category_form'                              => 'Artikelkategorie-Formular',
    'sort_by_due'                                     => 'Nach Fälligkeitsdatum sortieren',
    'affiliate'                                       => 'Affiliate',
    'parent_account'                                  => 'Eltern Account',
    'child_account'                                   => 'Kinderkonten',
    'select_parent_client'                            => 'Wählen Sie Übergeordnetes Konto',
    'record_successfully_retrieved'                   => 'Datensatz erfolgreich abgerufen',
    'custom-image-not-support'                        => 'Benutzerdefiniertes Bildfeld wird nicht unterstützt',
    'custom-tag-not-support'                          => 'Benutzerdefiniertes Tag-Feld wird nicht unterstützt',
    'custom-checkbox-not-support'                     => 'Benutzerdefiniertes Kontrollkästchenfeld wird nicht unterstützt',
    'custom-date-not-support'                         => 'Benutzerdefiniertes Datumsfeld wird nicht unterstützt',
    'custom-datetime-not-support'                     => 'Benutzerdefiniertes Datum / Uhrzeit-Feld wird nicht unterstützt',
    'timeline'                                        => 'Zeitleiste',
    'client_invoice'                                  => 'Rechnungen des Kunden',
    'select_client_blank_for_all'                     => 'Client auswählen (leer für alle)',
    'invoice_email_success'                           => 'Rechnungs-E-Mail erfolgreich gesendet',
    'quote_email_success'                             => 'Angebots-E-Mail erfolgreich gesendet',
    'document_number_schemes'                         => 'Dokumentennummerierung',
    'document_number_scheme'                          => 'Dokumentennummernschema',
    'document_number_scheme_form'                     => 'Formular für das Dokumentennummernschema',
    'default_document_number_scheme'                  => 'Standarddokumentennummernschema',
    'supporting_data'                                 => 'Unterstützende Daten',
    'customizations'                                  => 'Anpassungen',
    'utilities_and_logs'                              => 'Dienstprogramme und Protokolle',
    'system_log'                                      => 'Systemprotokoll',
    'paid_amount'                                     => 'Bezahlte Menge',
    'payment_amount'                                  => 'Zahlungsbetrag',
    'payment_intent'                                  => 'Zahlungsabsicht',
    'apply_payment_to_one_or_more_invoice'            => 'Zahlung auf eine oder mehrere Rechnungen anwenden',
    'pre_payment_for_future_invoices'                 => 'Vorauszahlung für zukünftige Rechnungen',
    'apply_to_invoices'                               => 'Auf Rechnung (en) anwenden',
    'payment_application'                             => 'Zahlungsantrag',
    'remaining_payment_balance'                       => 'Verbleibende Zahlungsbilanz',
    'remaining_balance'                               => 'Restbetrag',
    'payment_warning'                                 => 'Bitte Betrag eingeben',
    'apply_pre_payment_warning'                       => 'Sie haben die Zahlung auf keine Rechnungen angewendet. Möchten Sie es als Vorauszahlung verbuchen?',
    'confirm_remaining_balance'                       => 'Der Restbetrag von :value steht für zukünftige Rechnungen für diesen Kunden zur Verfügung.',
    'open_balance'                                    => 'Offene Saldo',
    'more_figure_then_total_payment'                  => 'Bitte geben Sie die Zahlung erneut ein. Ihre Gesamtrechnungszahlung ist höher als der Restbetrag.',
    'remaining_payment_balance_apply_later_info'      => 'Restzahlungssalden können später auf andere Rechnungen angerechnet werden.',
    'invoice_balance'                                 => 'Rechnungssaldo',
    'enter_payment_for_invoice'                       => 'Zahlung für Rechnung eingeben',
    'invoice_pdf'                                     => 'Rechnungs-PDF',
    'payment_applications'                            => 'Zahlungsanträge',
    'multiple'                                        => 'Mehrere',
    'ok'                                              => 'OK',
    'credit_memo_default'                             => 'Gutschrift Standard',
    'edit_payment'                                    => 'Zahlung bearbeiten',
    'credit_memo'                                     => 'Gutschrift',
    'credit_memos'                                    => 'Gutschriften',
    'create_credit_memo'                              => 'Gutschrift erstellen',
    'credit_applications'                             => 'Gutschriftsanträge',
    'credit_applications_for_invoice'                 => 'Gutschriftsanträge für Rechnung',
    'prepayment_applications_for_invoice'             => 'Vorauszahlungsanträge für Rechnung In',
    'apply_credit_memo'                               => 'Gutschrift anwenden',
    'apply_pre_payment'                               => 'Vorauszahlung beantragen',
    'applied_amount'                                  => 'Angewandter Betrag',
    'remaining_credit_balance'                        => 'Restguthaben',
    'remaining_credit_balance_apply_later_info'       => 'Restguthaben können später auf andere Rechnungen angerechnet werden.',
    'applied'                                         => 'Angewendet',
    'more_figure_then_invoice_amount'                 => 'Bitte geben Sie den Betrag erneut ein, der Betrag darf den Rechnungsbetrag nicht überschreiten.',
    'more_figure_then_invoice_total'                  => 'Bitte geben Sie den Betrag erneut ein, der Gesamtbetrag darf den Rechnungsbetrag nicht überschreiten.',
    'invoice_not_selected_warning'                    => 'Warten Sie, Sie haben die Gutschrift auf keine Rechnungen angewendet.',
    'select_type'                                     => 'Art auswählen',
    'email_credit_memo'                               => 'E-Mail-Gutschrift',
    'back_to_credit_memo'                             => 'Zurück zur Gutschrift',
    'invoice_amount'                                  => 'Rechnungsbetrag',
    'remaining_invoice_amount'                        => 'Verbleibender Rechnungsbetrag',
    'settlement_for_credit_memo'                      => 'Abrechnung für Gutschrift',
    'credit_memo_amount'                              => 'Gutschriftsbetrag',
    'confirm_remaining_balance_invoice'               => 'Der Restbetrag für diese Rechnung beträgt nach der Begleichung :value.',
    'payment_receipt_for_invoices'                    => 'Zahlungseingang für Rechnungen',
    'primary_phone'                                   => 'Erste Telefonnummer',
    'alternate_phone'                                 => 'Alternative Telefonnummer',
    'currency_not_match'                              => 'Währung stimmt nicht überein',
    'tasks'                                           => 'Aufgaben',
    'full_and_final_payment'                          => 'voll',
    'partial'                                         => 'teilweise',
    'transition'                                      => [
        'created'          => 'Erstellt',
        'updated'          => 'Aktualisiert',
        'deleted'          => 'Gelöscht',
        'received'         => 'Empfangen',
        'opened'           => 'Geöffnet',
        'sent'             => 'Geschickt',
        'mail'             => 'Gemailt',
        'changed'          => 'Geändert',
        'recurring'        => 'Erstellt',
        'completed'        => 'Abgeschlossen',
        'reversed'         => 'Rückgängig gemacht',
        'quote_to_invoice' => 'Angebot zur Rechnung',
        'download'         => 'Download',
        'added'            => 'Hinzugefügt',
        'email'            => 'Email',
        'merge'            => 'Verschmelzen',
        'billed'           => 'In Rechnung gestellt',
        'failed'           => 'Fehlgeschlagen',
        'invoice'          => [
            'created'                => 'Invoice :invoice_number wurde erstellt',
            'credit_memo_created'    => 'Credit Memo :credit_memo_number wurde erstellt',
            'credit_memo_updated'    => 'Credit Memo :credit_memo_number wurde geändert',
            'created_from_recurring' => 'Invoice :invoice_number wurde erstellt (aus Recurring template :recurring_invoice_id)',
            'updated'                => 'Invoice :invoice_number wurde geändert',
            'deleted'                => 'Invoice :invoice_number wurde gelöscht',
            'credit_memo_deleted'    => 'Credit Memo :credit_memo_number wurde gelöscht',
            'status_changed'         => 'Rechnung :invoice_number Der Status wurde von :previous_value in :current_value geändert',
            'email_sent'             => 'Rechnung :invoice_number E-Mail gesendet',
            'resend_email'           => 'Rechnung :invoice_number E-Mail erneut senden',
            'email_opened'           => 'Invoice :invoice_number E-Mail geöffnet',
            'payment_updated'        => 'Rechnung :invoice_number aktualisiert :full_payment_text Zahlung',
            'payment_received'       => 'Rechnung :invoice_number erhielt :full_payment_text Zahlung',
            'payment_reversed'       => 'Rechnung :invoice_number hatte ein :full_payment_text',
            'invoice_tag_updated'    => 'Rechnungs-Tag :tags wurde auf Rechnung :invoice_number hinzugefügt',
            'invoice_tag_deleted'    => 'Rechnungs-Tag :invoice_number wurde gelöscht :tags',
            'mark_mail'              => 'Rechnung :invoice_number als gesendet markieren',
            'unmark_mail'            => 'Rechnung :invoice_number Maske als unversendet',
            'paid_invoice_opened'    => 'Bezahlte Rechnung wurde zur Bearbeitung geöffnet',
            'sent_invoice_opened'    => 'Gesendete Rechnung wurde zur Bearbeitung geöffnet',
            'sms_sent'               => 'Rechnung :invoice_number SMS gesendet',
        ],
        'quote'            => [
            'created'           => 'Quote :quote_number wurde erstellt',
            'updated'           => 'Quote :quote_number wurde geändert',
            'deleted'           => 'Quote :quote_number wurde gelöscht',
            'status_changed'    => 'Quote :quote_number Der Status wurde von :previous_value in :current_value geändert',
            'email_sent'        => 'Quote :quote_number E-Mail gesendet',
            'resend_email'      => 'Zitat :quote_number E-Mail erneut senden',
            'email_opened'      => 'Quote :quote_number E-Mail geöffnet',
            'quote_to_invoice'  => ':quote_number wurde in eine Rechnung konvertiert - :invoice_number',
            'quote_tag_updated' => 'Zitat-Tag :tags wurde zu Zitat :quote_number hinzugefügt',
            'quote_tag_deleted' => 'Zitat-Tag :quote_number wurde :tags gelöscht',
            'sms_sent'          => 'Zitat :quote_number SMS gesendet',
        ],
        'payment'          => [
            'prepayment_created'           => 'Vorauszahlung wurde erstellt',
            'payment_receipt_email_sent'   => 'Zahlungsbeleg E-Mail gesendet',
            'payment_receipt_resend_email' => 'E-Mail mit Zahlungsbeleg erneut senden',
            'payment_updated'              => 'Zahlung wurde geändert',
            'deleted'                      => 'Zahlung wurde gelöscht',
            'payment_receipt_pdf_download' => 'Zahlungsbeleg PDF-Download',
            'payment_note_deleted'         => 'Zahlungsbeleg gelöscht:',
            'payment_note_added'           => 'Zahlungshinweis hinzugefügt:',
            'payment_note_updated'         => 'Zahlungshinweis aktualisiert von',
            'payment_failed'               => 'Bezahlung fehlgeschlagen',
        ],
        'client'           => [
            'client_created'     => ':client_type wurde erstellt',
            'type_changed'       => ':previous_value wurde ein :current_value',
            'updated'            => 'Client wurde aktualisiert',
            'deleted'            => 'Client wurde gelöscht',
            'status_changed'     => 'Client auf :current_value gesetzt',
            'client_tag_updated' => 'Tag :tags hinzugefügt',
            'client_tag_deleted' => 'Tag :tags gelöscht',
            'merge'              => 'Client-ID: :idTo - :nameTo wurde mit Client-ID: :idFrom - :nameFrom zusammengeführt.',
        ],
        'expense'          => [
            'created' => 'Kosten wurden erstellt',
            'updated' => 'Die Ausgaben wurden geändert',
            'deleted' => 'Aufwand wurde gelöscht',
            'billed'  => 'Die Kosten wurden in Rechnung gestellt',
            'vendor'  => [
                'created' => 'Spesenlieferant wurde erstellt',
                'updated' => 'Der Spesenanbieter wurde geändert',
                'deleted' => 'Spesenlieferant wurde gelöscht',
            ],
        ],
        'note'             => [
            'created'          => 'Hinweis wurde erstellt',
            'updated'          => 'Hinweis wurde geändert',
            'deleted'          => 'Hinweis wurde gelöscht',
            'note_tag_updated' => 'Tag :tags in Notiz hinzugefügt',
            'note_tag_deleted' => 'Tag :tags aus Notiz gelöscht',
        ],
        'task'             => [
            'created'   => 'Aufgabe wurde erstellt',
            'updated'   => 'Aufgabe wurde geändert',
            'deleted'   => 'Aufgabe wurde gelöscht',
            'completed' => 'Aufgabe wurde abgeschlossen',
        ],
        'subscription'     => [
            'created'                       => 'Abonnement :invoice_number wurde erstellt',
            'updated'                       => 'Abonnement :invoice_number wurde geändert',
            'deleted'                       => 'Abonnement :invoice_number wurde gelöscht',
            'recurring_invoice_tag_updated' => 'Abonnement-Tag :tags wurde zum Abonnement :recurringInvoice_number hinzugefügt',
            'recurring_invoice_tag_deleted' => 'Abonnement-Tag :recurringInvoice_number wurde gelöscht :tags',
        ],
        'attachment'       => [
            'created' => ':filename wurde als Anhang hochgeladen',
            'deleted' => ':filename wurde als Anhang entfernt',
        ],
        'tag'              => [
            'created' => 'Das Tag :tag wurde hinzugefügt',
            'deleted' => 'Das Tag :tag wurde entfernt',
        ],
    ],
    'reset'                                           => 'Zurücksetzen',
    'select_event'                                    => 'Wählen Sie den Ereignistyp',
    'select_country'                                  => 'Wähle ein Land',
    'type_captcha'                                    => 'Bitte beantworten Sie die obige Frage',
    'refresh_captcha'                                 => 'Frage aktualisieren',
    'answer'                                          => 'Antworten',
    'use_captcha_in_login'                            => 'Verwenden Sie Captcha im Login',
    'allow_client_timeline'                           => 'Zeitleiste',
    'client_timeline'                                 => 'Zeitleiste',
    'no_invoice_tags'                                 => 'Es gibt keine Rechnungs-Tags.',
    'total_notifications'                             => 'Sie haben :total-Benachrichtigungen',
    'no_notifications'                                => 'Keine neuen Benachrichtigungen',
    'notifications'                                   => 'Benachrichtigungen',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Eine neue Aufgabe, die Ihnen zugewiesen wurde',
            'due_date_breached' => 'Die Aufgabe',
            'completed'         => ':user abgeschlossene Aufgabe:',
        ],
        'quote' => [
            'approved'             => ':quote_number wurde genehmigt',
            'quote_to_invoice'     => ':quote_number wurde in eine Rechnung umgewandelt -',
            'rejected'             => ':quote_number wurde abgelehnt',
            'payment_successfully' => 'Angebot :quote_number für Kunde :client_name wurde bezahlt. Rechnung :invoice_number wurde erstellt und die Zahlung wurde angewendet',
        ],
    ],
    'search_tasks'                                    => 'Suchaufgaben',
    'reopen_task'                                     => 'Aufgabe erneut öffnen',
    'task_form'                                       => 'Aufgabe hinzufügen',
    'view_task'                                       => 'Aufgabendetails',
    'client_deleted'                                  => 'Client wird gelöscht',
    'payment_canceled'                                => 'Ihre Zahlung wurde storniert',
    'default_company_profile_set'                     => 'Wir haben Ihr Standard-Firmenprofil festgelegt. Sie können es jederzeit über die Einstellungen des Firmenprofils aktualisieren.',
    'file_uploaded_successfully'                      => 'Datei erfolgreich hochgeladen',
    'attachment_notice'                               => 'Maximale Dateigröße für Anhänge kleiner oder gleich :size',
    'attachment_error'                                => 'Die Größe des Anhangs darf :size nicht überschreiten',
    'attachment_warning'                              => 'Die Größe der Anhänge ist :size.. Das Hochladen vieler großer Anhänge kann die Leistung Ihrer Datenbank im Laufe der Zeit beeinträchtigen.',
    'generate_timeline_history'                       => 'Zeitleistenverlauf generieren',
    'generating_timeline_wait'                        => 'Timeline generieren, bitte warten ...',
    'generating_timeline_confirm'                     => 'Die Zeitleistenfunktion wurde in FusionInvoice 2020 hinzugefügt. Dadurch werden Zeitleisteneinträge für alle Aktivitäten generiert, die dieser Funktionserweiterung vorausgingen. Fortsetzen?',
    'generated_timeline_request_accepted'             => 'Die Generierung des Timeline-Verlaufs ist abgeschlossen.',
    'transitions'                                     => 'Zeitleistenverlauf',
    'pending'                                         => 'steht aus',
    'client_transition'                               => 'Client-Zeitleisten',
    'expense_transition'                              => 'Zeitpläne für Ausgaben',
    'invoice_transition'                              => 'Rechnungsfristen',
    'payment_invoice_transition'                      => 'Zahlungsrechnungsfristen',
    'payment_transition'                              => 'Zahlungsfristen',
    'quote_transition'                                => 'Zeitleisten zitieren',
    'note_transition'                                 => 'Zeitleisten beachten',
    'task_transition'                                 => 'Aufgabenzeitleisten',
    'email_sent'                                      => 'E-Mail gesendet',
    'credit_applied'                                  => 'Kredit beantragt',
    'configuration'                                   => 'Aufbau',
    'include_prepayments'                             => 'Vorauszahlungen einschließen',
    'pre_payment'                                     => 'Vorauszahlungen',
    'pre_payments'                                    => 'Vorauszahlungen',
    'times'                                           => 'Mal',
    'include_prepayments_applied'                     => 'Angewendete Vorauszahlungen einschließen',
    'confirm_full_payment_applied'                    => 'Die Zahlung wurde vollständig angewendet',
    'confirm_full_credit_memo_applied'                => 'Die Gutschrift wurde vollständig angewendet',
    'all_tasks'                                       => 'Alle Aufgaben',
    'my_tasks'                                        => 'Meine Aufgaben',
    'assigned_from_others'                            => 'Von anderen zugewiesen',
    'full_payment_reversed'                           => 'volle Zahlung rückgängig gemacht.',
    'partial_payment_reversed'                        => 'Teilzahlung storniert.',
    'invoice_delete_error'                            => 'Leider können Sie keine Rechnung mit Zahlungen oder Gutschriftsanträgen löschen. Sie müssen zuerst die Zahlungs- oder Gutschriftsanträge löschen.',
    'mail-from-required'                              => 'Sie müssen eine gültige Mail From Email eingeben',
    'contact_updated'                                 => 'Kontakt erfolgreich aktualisiert',
    'contact_added'                                   => 'Kontakt erfolgreich hinzugefügt',
    'generate_passport_key_wait'                      => 'Bitte warten Sie Ihren Passschlüssel ...',
    'generate_passport_key'                           => 'Passschlüssel generieren',
    'default_greeting'                                => 'Hallo!<br>',
    'hi'                                              => 'Hallo,',
    'deduct_tax_from_expenses'                        => 'Steuern von den Ausgaben abziehen',
    'invalid_invoice_id'                              => 'Ungültige Rechnungs-ID',
    'client_related_record_exist'                     => 'Entschuldigung, der Client hat verwandte Datensätze für :: Module. Clients mit Transaktionsverlauf können nicht gelöscht werden.',
    'email_payment_receipt_notice'                    => 'Der Kunde hat keine E-Mail-Adresse in der Datei',
    'show_more'                                       => 'Zeig mehr ...',
    'show_less'                                       => 'Zeige weniger ...',
    'invoice_already_paid'                            => 'Rechnung ist bereits bezahlt!',
    'system_default'                                  => 'Systemfehler',
    'created_by'                                      => 'Erstellt von',
    'created_at'                                      => 'Hergestellt in',
    'task_created_by_and_created_at'                  => 'Aufgabe erstellt von :created_by auf :created_at',
    'dashboard_widgets_date_options'                  => 'Systemstandardzeitraum für Rechnungs- und Angebotszusammenfassung',
    'dashboard-widget-from-date-required'             => 'Ab Datum ist erforderlich, wenn der benutzerdefinierte Datumsbereich im Systemstandardzeitraum für Rechnung und Angebotszusammenfassung ausgewählt ist',
    'dashboard-widget-to-date-required'               => 'Das Datum ist erforderlich, wenn im Systemstandardzeitraum für Rechnung und Angebotszusammenfassung der benutzerdefinierte Datumsbereich ausgewählt ist',
    'invoice_currency'                                => 'Rechnungswährung',
    'currency_format'                                 => 'Währungsformat',
    'create_missing_folder_success'                   => 'Fehlender erforderlicher Ordner erstellt',
    'create_missing_folder_failed'                    => 'Versuch, Ordner zu erstellen fehlgeschlagen :path',
    'folder_is_not_writable'                          => 'Ordner ist nicht beschreibbar :path',
    'update_item_as_lookup'                           => 'Artikelsuche aktualisieren',
    'number_of_tax_fields'                            => 'Anzahl Steuerfelder',
    'tax_1_entry'                                     => '1 Eintrag',
    'tax_2_entries'                                   => '2 Einträge',
    'require_tags_on_client_notes'                    => 'Tag(s) in Kundennotizen erfordern',
    'entered_amount_less_than_invoice_amount'         => 'Der eingegebene Betrag muss kleiner oder gleich dem Rechnungsbetrag sein',
    'send-to'                                         => 'Senden an',
    'print'                                           => 'Drucken',
    'pdf_cleanup'                                     => 'PDF-Bereinigung',
    'pdf_cleanup_confirm'                             => 'Möchten Sie wirklich alte PDF-Dateien bereinigen?',
    'pdf_cleanup_success'                             => 'PDF-Bereinigung abgeschlossen',
    'deleting_pdf_wait'                               => 'Alte PDF-Dateien werden gelöscht, bitte warten...',
    'open_invoices'                                   => 'Offene Rechnungen',
    'open_credits'                                    => 'Offene Credits',
    'unapplied_payments'                              => 'Nicht zugewiesene Zahlungen',
    'attach_invoice_pdf'                              => 'Rechnungs-PDF anhängen',
    'upcoming_payment_notice'                         => 'Bevorstehende Zahlungsmitteilung',
    'select_mapping'                                  => 'Wählen Sie Zuordnung',
    'select_named_export'                             => 'Wählen Sie Benannter Export',
    'save_mapping'                                    => 'Zuordnung speichern',
    'add_mapping'                                     => 'Neue Zuordnung erstellen',
    'edit_mapping'                                    => 'Zuordnung aktualisieren',
    'save_as_default_mapping'                         => 'Standardzuordnung',
    'save_as_default_export'                          => 'Standardexport',
    'export_item_lookups'                             => 'Artikelsuche exportieren',
    'import_file_selection'                           => 'Dateiauswahl importieren',
    'next'                                            => 'Nächste',
    'delete_import_mapping_warning'                   => 'Möchten Sie diese Zuordnung wirklich löschen?',
    'export'                                          => 'Export',
    'named_exports'                                   => 'Benannte Exporte',
    'save_named_export'                               => 'Benannten Export speichern',
    'delete_named_export'                             => 'Benannten Export löschen',
    'updated_at'                                      => 'Aktualisiert am',
    'zip'                                             => 'Reißverschluss',
    'fields_to_export'                                => 'Zu exportierende Felder',
    'import-file-type-error'                          => 'Importdateityp muss CSV sein',
    'recurring_invoice_items'                         => 'Wiederkehrende Rechnungspositionen',
    'important_details'                               => 'Wichtige Details',
    'important_information'                           => 'Wichtige Informationen',
    'item_lookups_important_information'              => '<p>Wenn während des CSV-Imports ein übereinstimmender Artikelsuchname in den vorhandenen Daten gefunden wird, schlägt der Import-Batch fehl und zeigt den Artikel an, der den Fehler verursacht hat.</p>',
    'invoices_important_information'                  => '<p>Der Clientname (aus der CSV) wird in der Clients-Tabelle nachgeschlagen und in client_id aufgelöst, wenn ein übereinstimmender Name vorhanden ist. Wenn keine Namensübereinstimmung gefunden wird, erstellt es einen Client-Eintrag und verwendet die ID des neuen Client-Eintrags</p><p>Rechnungsnummer,</p><p>Invoice_items sucht die Rechnungsnummer (aus der CSV) in der Rechnungstabelle und löst sie in die ID auf. Es werden keine weiteren Schlüsselfeld-Suchen/-Validierungen durchgeführt</p>',
    'invoice_items_important_information'             => '<p>Beim Import von \</p>',
    'payments_important_information'                  => '<p>Das Importieren von Zahlungen erfordert eine gültige übereinstimmende Rechnungsnummer, auf die die Zahlungen angewendet werden können. Wenn keine übereinstimmende Rechnung gefunden wird, schlägt der gesamte Stapelimport fehl.</p><p>Die passenden Kunden-</p><p>Es wird eine Suche nach dem Namen der Zahlungsmethode durchgeführt (aus der CSV-Datei in die Tabelle \</p>',
    'run_daily_tasks'                                 => 'Tägliche Aufgaben ausführen',
    'daily_task_ran'                                  => 'Tägliche Aufgaben wurden erfolgreich ausgeführt',
    'csv_row_number'                                  => 'CSV-Zeilennummer :row',
    'max_item_lookup_records'                         => 'max. Artikelsuchdatensätze',
    'invoice_with_commission_delete_error'            => 'Sie können eine Rechnung mit Provisionseinträgen mit dem Status',
    'if_invoice_is_emailed_while_draft'               => 'Wenn die Rechnung im Entwurfsstatus per E-Mail gesendet wird',
    'custom_payment_receipt_body_not_exists'          => 'Die benutzerdefinierte Vorlage für Zahlungseingänge wurde nicht gefunden.',
    'invoice_email_body_type'                         => 'Rechnungs-E-Mail-Texttyp',
    'send_overdue_reminder'                           => 'Überfällige Mahnung senden',
    'reminder_sent_successfully'                      => 'Erinnerung erfolgreich versendet',
    'error_sending_reminder'                          => 'Beim Senden der Erinnerung ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.',
    'expense_date'                                    => 'Ausgabendatum',
    'group_by'                                        => 'Gruppiere nach',
    'timeline_scope_all_user'                         => 'Zeitachsenbereich – Alle Benutzer',
    'copy_to_clipboard'                               => 'In die Zwischenablage kopieren',
    'text_copied_clipboard'                           => 'Text in die Zwischenablage kopiert!',
    'import_example_csv'                              => 'Eine Beispiel-CSV-Datei finden Sie hier',
    'import'                                          => 'Importieren',
    'address2'                                        => 'Adresse 2',
    'use_parent_email'                                => 'Eltern-E-Mail verwenden',
    'max_import_records'                              => 'Die maximale Grenze zum Importieren von Datensätzen ist :total_records',
    'demo_file_attachment_disabled'                   => 'Dateianhänge sind in der Demo deaktiviert',
    'drag_drop_file'                                  => 'Ziehen',
    'or'                                              => 'ODER',
    'browse_file'                                     => 'Datei durchsuchen',
    'system_setting_and_ui'                           => 'Systemeinstellungen',
    'localization_and_timezone'                       => 'Lokalisierung',
    'security'                                        => 'Sicherheit',
    'cleanup_and_backup'                              => 'Aufräumen',
    'attach_quote_pdf'                                => 'Angebots-PDF anhängen',
    'attach_payment_receipt'                          => 'Zahlungsbeleg anhängen',
    'choose-file'                                     => 'Datei wählen',
    'important-note'                                  => 'Wichtiger Hinweis',
    'collapse'                                        => 'Zusammenbruch',
    'add_task'                                        => 'Aufgabe hinzufügen',
    'recurring_invoice_commissions'                   => 'Wiederkehrende Rechnungsprovisionen',
    'invoice_commissions'                             => 'Rechnungsprovisionen',
    'percentage'                                      => 'Prozentsatz',
    'flat_amount'                                     => 'Pauschalbetrag',
    'discount-amount'                                 => 'Rabatt',
    'discount-type'                                   => 'Rabatttyp',
    'saving'                                          => 'Sparen...',
    'preparing'                                       => 'Vorbereiten',
    'allow_line_item_discounts'                       => 'Werbebuchungsrabatte zulassen',
    'invalid_price_amount'                            => 'Ungültiger Preisbetrag! Muss größer als 0 sein.',
    'light-mode'                                      => 'Lichtmodus',
    'dark-mode'                                       => 'Dunkler Modus',
    'system_base_currency'                            => 'Basiswährung des Systems',
    'is_recurring_task'                               => 'Ist eine wiederkehrende Aufgabe',
    'contact_names'                                   => 'Kontaktnamen',
    'all_client'                                      => 'Alle Kunden',
    'invoice_grand_total'                             => 'Gesamtsumme der Rechnung',
    'recurring_invoice_grand_total'                   => 'Gesamtsumme der wiederkehrenden Rechnung',
    'is_required'                                     => 'Ist nötig?',
    'add-new-client'                                  => 'Neuen Kunden hinzufügen',
    'client_name_required'                            => 'Kundenname ist erforderlich',
    'custom_item_text_validate'                       => 'Bitte geben Sie einen gültigen Artikel :label in das Feld :label ein.',
    'assigned_to_others'                              => 'Anderen zugewiesen',
    'all_tasks_and_all_users'                         => 'Alle Aufgaben/Alle Benutzer',
    'statement'                                       => 'Aussage',
    'profile_code'                                    => 'Profilcode',
    'login-url'                                       => 'Anmelde-URL',
    'url_copied_clipboard'                            => 'URL in Zwischenablage kopiert!',
    'payment_receipt_email_sent'                      => 'Zahlungsbestätigungs-E-Mail erfolgreich gesendet',
    'edit_payment_note_form'                          => 'Zahlungshinweis bearbeiten',
    'payment_invoices_text'                           => 'Danke schön! Ihre Zahlung von :amount wurde auf folgende Rechnungen angewendet.',
    'payment_text'                                    => 'Vielen Dank für Ihre Zahlung von :amount .',
    'date_filter_by'                                  => 'Datum Filtern nach',
    'filter_by_invoice_date'                          => 'Rechnungsdatum',
    'filter_by_payment_date'                          => 'Zahlungsdatum',
    'date-range-required'                             => 'Bitte wählen Sie einen Zeitraum aus',
    'save-and-complete'                               => 'Speichern und abschließen',
    'completion-note'                                 => 'Fertigstellungshinweis',
    'complete-with-note'                              => 'Komplett mit Notiz',
    'placeholder_type_note'                           => 'Geben Sie Ihre Notizen ein...',
    'credit_memo_email_subject'                       => 'Betreff der Gutschrift-E-Mail',
    'default_credit_memo_email_body'                  => 'Standard-E-Mail-Text für Gutschriften',
    'show_invoices_from'                              => 'Rechnungen anzeigen von',
    'system_mail_from_address'                        => 'System-E-Mail-Absenderadresse',
    'user_who_created_invoice'                        => 'Benutzer, der die Rechnung erstellt hat',
    'completed'                                       => 'Vollendet',
    'no_auth_to_view_task'                            => 'Diese Aufgabe befindet sich nicht mehr in Ihrer Liste.',
    'credit-memo-and-prepayments'                     => 'Kredite und Vorauszahlungen',
    'all_selected'                                    => 'Alle ausgewählt',
    'select_columns'                                  => 'Spalten auswählen',
    'column_settings'                                 => 'Spalteneinstellungen',
    'minimum_one_column_check_is_required'            => 'Bitte wählen Sie mindestens eine Spalte aus',
    'date_of_entry'                                   => 'Zeitpunkt des Inkrafttretens',
    'amount_applied'                                  => 'Angewendeter Betrag',
    'date_applied'                                    => 'Antragsdatum',
    'copy_to_recurring_invoice'                       => 'In Dauerrechnung kopieren',
    'top_bar_color'                                   => 'Farbe der oberen Leiste',
    'light_grey'                                      => 'Hellgrau',
    'bg-primary'                                      => 'Blau',
    'bg-warning'                                      => 'Gelb',
    'bg-info'                                         => 'Libelle blau',
    'bg-danger'                                       => 'Rot',
    'bg-success'                                      => 'Rasen grün',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Viktoriablau',
    'bg-navy'                                         => 'Navy blau',
    'bg-purple'                                       => 'Violett',
    'bg-fuchsia'                                      => 'Fuchsie',
    'bg-pink'                                         => 'Rosa',
    'bg-maroon'                                       => 'Kastanienbraun',
    'bg-orange'                                       => 'Orange',
    'bg-lime'                                         => 'Lindgrün',
    'bg-teal'                                         => 'Blaugrün',
    'bg-olive'                                        => 'Olive',
    'fee_name'                                        => 'Gebührenname',
    'fee_percentage'                                  => 'Gebührenprozentsatz',
    'fee_explanation'                                 => 'Gebührenerklärung',
    'enable_online_payment_processing_fees'           => 'Bearbeitungsgebühren für Online-Zahlungen aktivieren',
    'allow_online_payment_processing_fees'            => 'Bearbeitungsgebühren für Online-Zahlungen zulassen',
    'allow_online_pay_fees'                           => 'Gebühren für Online-Bezahlung zulassen',
    'convenience_charges'                             => 'Gefälligkeitsentgelte',
    'opp-fee-percentage-required'                     => 'Der Prozentsatz der Bearbeitungsgebühren für Online-Zahlungen ist erforderlich',
    'opp-fee-percentage-gt-zero'                      => 'Der Prozentsatz der Bearbeitungsgebühren für Online-Zahlungen muss größer als Null sein',
    'cron_error'                                      => 'bei :datetime fehlgeschlagen',
    'cron_start'                                      => 'Täglicher Task-Runner gestartet bei :datetime',
    'notification_clear_all'                          => 'Alle Benachrichtigungen löschen',
    'show'                                            => 'Show',
    'report'                                          => 'Bericht',
    'profit_loss'                                     => 'Gewinn-und Verlust',
    'credit_and_pre_payments'                         => 'Kredite und Vorauszahlungen',
    'expenses_vendors'                                => 'Spesen Anbieter',
    'expenses_categories'                             => 'Ausgabenkategorien',
    'create'                                          => 'Schaffen',
    'import_map_clients'                              => 'Karten-Clients importieren',
    'payctr_users'                                    => 'PaymentCenter-Benutzer',
    'ctrl_plus_click'                                 => 'Klicken Sie bei gedrückter Strg-Taste, um Fertigstellungshinweise hinzuzufügen',
    'edit_note'                                       => 'Notiz bearbeiten',
    'save-and-unComplete'                             => 'Speichern und unvollständig',
    'sales_chart'                                     => 'Verkaufsdiagramm',
    'accumulate_totals'                               => 'Summen akkumulieren',
    'do_not_accumulate_totals'                        => 'Summen nicht kumulieren',
    'kpi_cards'                                       => 'KPI-Karten',
    'no_data_to_display'                              => 'Keine Daten zum Anzeigen',
    'choose_period'                                   => 'Wählen Sie Zeitraum',
    'date_mailed'                                     => 'Versanddatum',
    'date_emailed'                                    => 'Datum per E-Mail',
    'action'                                          => 'Handlung',
    'mail'                                            => 'Post',
    'mark_as_mailed'                                  => 'Als verschickt markieren',
    'invoice_mailed'                                  => 'Rechnung wurde als verschickt markiert',
    'emailed'                                         => 'E-Mail gesendet',
    'paid_invoice_canceled_error'                     => 'Um diese Rechnung zu stornieren, löschen Sie bitte Zahlungen aus der Rechnung.',
    'allow_invoice_delete'                            => 'Rechnungslöschung zulassen',
    'allow_child_accounts'                            => 'Kinderkonten zulassen',
    'third_party_bill_payer'                          => 'Externer Rechnungszahler',
    'invoices_paid_by'                                => 'Rechnungen bezahlt von',
    'use_third_party_bill_payer_email'                => 'Verwenden Sie die E-Mail-Adresse des Rechnungszahlers eines Drittanbieters',
    'email_default'                                   => 'E-Mail-Standard',
    'client_default'                                  => 'Client-Standard',
    'clear-all'                                       => 'Alles löschen',
    'system_log_is_missing_or_empty'                  => 'Das Systemprotokoll fehlt oder ist leer',
    'change_to_draft'                                 => 'Wechseln Sie zu Entwurf',
    'invoice_status_change_to_draft'                  => 'Rechnungsstatus auf Entwurf geändert',
    'there_is_some_error'                             => 'Es gibt einige Fehler',
    'filter_by_date'                                  => 'Nach Datum filtern',
    'quote_grand_total'                               => 'Gesamtsumme angeben',
    'email_upcoming_payment_due_notice'               => 'Zahlungsbenachrichtigung per E-Mail senden',
    'email_overdue_invoice_reminder'                  => 'Erinnerung an überfällige Rechnung per E-Mail',
    'page_totals'                                     => 'Seitensummen',
    'categories'                                      => 'Kategorien',
    'conven_charges'                                  => 'Konv. Gebühren',
    'invoice_status_change_to_cancel'                 => 'Rechnungsstatusänderung auf Stornieren',
    'filter_by_invoice_number'                        => 'Rechnungsnummer',
    'filter_by_client_name'                           => 'Kundenname',
    'custom_mail_template'                            => 'Benutzerdefinierte Mail-Vorlage',
    'invoice_use_custom_mail_template'                => 'Rechnung Verwenden Sie eine benutzerdefinierte E-Mail-Vorlage',
    'client_or_company_name'                          => 'Name des Kunden/Unternehmens',
    'view_invoice'                                    => 'Rechnung ansehen',
    'tt_active'                                       => 'Wenn ein Kundendatensatz nicht aktiv ist, erscheint er nicht in der Standardkundenliste und normale Transaktionen sind nicht zulässig.',
    'tt_invoice_prefix'                               => 'Einem Kundendatensatz wird automatisch ein eindeutiger Rechnungspräfixcode zugewiesen, wenn er erstellt wird. Sie kann später manuell geändert werden. Es kann als Teil Ihres Dokumentennummerierungsschemas für die Rechnungsnummerierung verwendet werden und ermöglicht eine eindeutige Rechnungsnummer pro Kunde.',
    'tt_automatic_email_payment_receipts'             => 'Sendet nach Annahme einer Zahlung eine E-Mail-Zahlungsquittung an den Kunden. Eine globale Einstellung ist in den Systemeinstellungen verfügbar, kann jedoch auf individueller Clientbasis überschrieben werden.',
    'tt_automatic_email_on_recur'                     => 'Sendet eine E-Mail-Rechnung an den Kunden, wenn eine wiederkehrende Rechnung ausgeführt wird, und erstellt eine Live-Rechnung. Eine globale Einstellung ist in den Systemeinstellungen verfügbar, kann jedoch auf individueller Clientbasis überschrieben werden.',
    'tt_default_currency'                             => 'Die diesem Kundenkonto zugewiesene Währung, die für ihre Rechnungs-, Angebots- und Zahlungstransaktionen verwendet wird. Dieser Wert wird von der Systemeinstellung für die Basiswährung voreingestellt.',
    'tt_language'                                     => 'Die Sprache, die dem Kunden angezeigt wird, wenn er sich im Kundencenter anmeldet.',
    'tt_allow_client_center_login'                    => 'Soll der Kunde sich bei Ihrem FusionInvoice-Kundencenter anmelden dürfen? Ihre E-Mail muss für ihren Benutzernamen verwendet werden und Sie müssen ein Passwort vergeben. Die Clientcenter-URL lautet',
    'tt_timezone'                                     => 'Zeitzone für den Client. Falls eingegeben, wird die Ortszeit des Clients oben in der Client-Seitenansicht angezeigt.',
    'tt_allow_online_payment_processing_fees'         => 'Für Kunden, die per Kreditkarte zahlen, können Bearbeitungsgebühren für Online-Zahlungen erhoben werden, die ihren öffentlichen Rechnungslink (in der Rechnungs-E-Mail enthalten) verwenden. Diese Option hat eine globale Systemeinstellung, kann aber auch auf individueller Client-Basis überschrieben werden.',
    'tt_allow_child_accounts'                         => 'Wenn Sie „Untergeordnete Konten zulassen“ auf „Ja“ setzen, kann dieser Client als übergeordnetes Konto fungieren und Sie können es aus der Liste der übergeordneten Konten auswählen.',
    'tt_third_party_bill_payer'                       => 'Ein externer Rechnungszahler ist eine Organisation, die Rechnungen für ihre Kunden bezahlt, beispielsweise eine externe Wirtschaftsprüfungsgesellschaft.',
    'tt_parent_account'                               => 'Das Mutterunternehmen, mit dem dieser Kunde verbunden ist oder dessen Tochtergesellschaft. Diese Liste enthält die Kundendatensätze, bei denen die Einstellung Untergeordnete Konten zulassen auf Ja gesetzt ist. Lassen Sie das Feld leer, wenn der Kunde kein übergeordnetes Konto hat.',
    'tt_invoices_paid_by'                             => 'Das Drittunternehmen, das dieser Kunde zur Zahlung seiner Rechnungen verwendet. Diese Liste enthält die Kundendatensätze, bei denen die Einstellung 3rd Party Bill Payer auf Yes gesetzt ist. Leer lassen, wenn der Kunde seine eigenen Rechnungen bezahlt.',
    'tt_email_default'                                => 'Wählen Sie beim Senden von E-Mails an diesen Client die E-Mail aus, die verwendet werden soll. Wenn dieser Kunde ein übergeordnetes Konto oder ein bezahltes Rechnung-Konto hat, kann eine dieser Optionen ausgewählt werden. Standard ist die Standard-Client-E-Mail.',
    'tt_default_to'                                   => 'Soll dieser Kontakt beim Versenden von E-Mails automatisch zur Empfängerliste \'To:\' hinzugefügt werden?',
    'tt_default_cc'                                   => 'Soll dieser Kontakt beim Versenden von E-Mails automatisch zur Empfängerliste \CC:\' hinzugefügt werden?',
    'tt_default_bcc'                                  => 'Soll dieser Kontakt beim Versenden von E-Mails automatisch zur Empfängerliste \BCC:\' hinzugefügt werden?',
    'tt_client_type'                                  => 'Ein Lead ist ein unqualifizierter Verkaufskandidat. Ein Interessent ist ein qualifizierter Kandidat, der bald ein Kunde werden kann. Ein Kunde ist ein Unternehmen oder eine Einzelperson, an die Sie Waren oder Dienstleistungen verkauft haben (oder bald verkaufen werden). Ein Partner ist ein Unternehmen oder eine Einzelperson, die Ihre Waren oder Dienstleistungen weiterverkauft. Sonstiges wird für Geschäfte verwendet, die nicht zu den anderen Typen passen, z. B. Rechnungszahler von Drittanbietern oder Mutterkonten, mit denen Sie keine direkten Geschäfte tätigen.',
    'tt_client_tags'                                  => 'Tags können einem Kunden zugewiesen werden, um Ihre Kundenliste für die Anzeige oder Berichterstellung zu kategorisieren oder zu filtern.',
    'tt_important_note'                               => 'Eine hier eingegebene Notiz wird automatisch in einem WICHTIG! Fenster, wenn der Kundendatensatz angezeigt wird.',
    'tt_gen_header_title_text'                        => 'Der Text, der in der oberen linken Ecke neben Ihrem Logo angezeigt wird, normalerweise Ihr Firmenname.',
    'tt_gen_default_company_profile'                  => 'Das Unternehmensprofil, das standardmäßig beim Erstellen neuer Rechnungen, Angebote usw. verwendet wird. Unternehmensprofile ermöglichen es Ihnen, Ihr Unternehmen mit jedem Profil anders zu präsentieren, indem Sie unterschiedliche Firmennamen, Logos, Rechnungsformate usw. zulassen.',
    'tt_gen_address_format'                           => 'Ermöglicht es Ihnen, das auf Rechnungen und Angeboten angezeigte Adressformat zu erstellen, indem Sie das einzelne Adressfeld oder eine Kombination der einzelnen Adressfelder wie Stadt, Bundesland, Land usw. verwenden.',
    'tt_gen_custom_fields_columns'                    => 'Benutzerdefinierte Felder können mit 1 bis 3 Feldern pro Zeile angezeigt werden.',
    'tt_gen_require_tags_on_client_notes'             => 'Bei Einstellung auf Ja muss ein Tag ausgewählt oder eingegeben werden, wenn eine Kundennotiz hinzugefügt wird, z. B. „Support“ oder „Vertrieb“. Dies ist hilfreich, um Notizen zu kategorisieren und zu suchen.',
    'tt_gen_skin'                                     => 'Wie soll Ihre FI-UI angezeigt werden, heller oder dunkler Modus',
    'tt_gen_top_bar_color'                            => 'Die Farbe der oberen Titelleiste. Wenn Sie mit mehreren verschiedenen FusionInvoice-Installationen arbeiten, kann dies eine hilfreiche visuelle Identifizierung sein.',
    'tt_gen_results_per_page'                         => 'Die Anzahl der pro Seite angezeigten Datensätze für alle Listenansichten, wie z. B. Kunden, Rechnungen, Angebote, Ausgaben usw.',
    'tt_gen_allow_line_item_discounts'                => 'Aktiviert oder deaktiviert die Rabattfunktion für Einzelposten in Rechnungen und Angeboten.',
    'tt_gen_language'                                 => 'Die Sprache, die für Ihre FusionInvoice-Installation verwendet werden soll. Beachten Sie, dass Sie Ihren Kunden eine andere Sprache zuweisen können, sodass sie mit dem FusionInvoice Client Center in ihrer Muttersprache interagieren können.',
    'tt_gen_date_format'                              => 'Ihr bevorzugtes Datumsformat',
    'tt_gen_use_24_hour_time_format'                  => 'Ermöglicht die Unterstützung von 24- oder 12-Stunden-Zeitformaten.',
    'tt_gen_timezone'                                 => 'Das primäre Timezine Ihres Unternehmens.',
    'tt_gen_base_currency'                            => 'Die Währung, die Ihr Unternehmen am häufigsten verwendet.',
    'tt_gen_exchange_rate_mode'                       => 'Manuell ermöglicht es Ihnen, den Wechselkurswert einzugeben, während Sie Rechnungen erstellen. Automatisch wird versuchen, eine öffentliche API zu verwenden, um den aktuellen Wechselkurs abzurufen. Dies wird nur verwendet, wenn Sie eine Transaktion mit einer anderen Währung als Ihrer Basiswährung eingeben.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice unterstützt bis zu 2 Steuerfelder pro Einzelposten. Der mit Zweites Steuerfeld ein- oder ausblenden ausgewählte Wert.',
    'tt_gen_quantity_price_decimals'                  => 'Die Anzahl der Dezimalstellen, die für Mengen- und Betragswerte angezeigt werden sollen. Wählen Sie je nach erforderlicher Genauigkeitsstufe 0 bis 4 aus.',
    'tt_gen_round_tax_decimals'                       => 'Wählen Sie die erforderliche Anzahl von Dezimalstellen für Steuerrundungsberechnungen aus.',
    'tt_gen_use_captcha_in_login'                     => 'Bei Einstellung auf Ja müssen Ihre Benutzer während der Anmeldung eine CAPTCHA-Sicherheitsfrage beantworten.',
    'tt_gen_force_https'                              => 'Wir empfehlen selten, diese Option zu aktivieren. Wenn Ihre Installation kein ordnungsgemäß funktionierendes SSL-Zertifikat auf Ihrem Webserver installiert hat, können bei Ihrer FusionInvoice-Installation Probleme auftreten. Sie können dasselbe Ergebnis erzielen, indem Sie eine Serverumleitungsregel einrichten.',
    'dashboard_settings'                              => 'Dashboard-Einstellungen',
    'tt_dashboard_settings'                           => 'Ihr Dashboard wird verwendet, um wichtige Geschäftsmetriken und Ereignisse anzuzeigen, die Ihnen wertvolle Einblicke in die Leistung Ihres Unternehmens geben. Das System-Dashboard ist die Standardeinstellung für alle Benutzer, jedoch können Sie innerhalb der Konfiguration jedes Benutzers das Standard-System-Dashboard überschreiben, indem Sie spezifische Einstellungen für jeden Benutzer definieren. Mit den folgenden Einstellungen können Sie Ihr Dashboard anpassen.',
    'tt_db_default_time_period'                       => 'Legt das standardmäßige Anfangs- und Enddatum für Dashboard-Widgets fest, die sie verwenden, wie z. B. KPI-Karten und das Verkaufsdiagramm.',
    'tt_db_recent_client_activity'                    => 'Ein Widget, das Kundeninteraktionen wie geleistete Zahlungen und angesehene Rechnungen oder Angebote über Ihre öffentlichen Rechnungs- oder Angebotslinks anzeigt.',
    'tt_db_display_order'                             => 'Dadurch wird die Anzeigereihenfolge für Dashboard-Widgets geändert. 1 wird oben angezeigt, 2 wird nach 1 angezeigt usw.',
    'tt_db_column_width'                              => 'Dashboard-Widgets verwenden das Bootstrap-Rastersystem und haben eine maximale Spaltenbreite von 12. Wenn Sie die Spaltenbreite auf 12 setzen, verwendet das Widget die gesamte verfügbare Breite. Wenn Sie es auf 6 setzen, können zwei Widgets dieselbe Zeile teilen, bei 4 können 3 Widgets dieselbe Zeile teilen usw.',
    'tt_db_accumulate_totals'                         => 'Wenn Sie diesen Wert aktivieren, enthält Ihr Diagramm die Summen der Vortage für jeden Tag. Beispiel: Der Umsatz für Tag 1 betrug 100 $, für Tag 2 50 $ und für Tag 3 125 $. Das Diagramm würde eine ansteigende Linie zeigen, wenn diese Option auf Ja gesetzt ist. Auf Nein eingestellt, würde die Verkaufslinie an Tag 2 sinken und bis Tag 3 steigen.',
    'tt_db_kpi_cards'                                 => 'Diese farbcodierten Karten zeigen die wichtigsten Leistungsindikatoren oben auf Ihrem Dashboard an.',
    'tt_db_sales_chart'                               => 'Ein Liniendiagramm, das Rechnungs- und Zahlungssummen anzeigt.',
    'tt_db_task_list'                                 => 'Mit diesem Widget können Sie direkt von Ihrem Dashboard aus mit dem Aufgabenlistenmodul arbeiten.',
    'tt_db_task_list_include_time'                    => 'Wenn Sie diese Option aktivieren, können Sie Datum und Uhrzeit für Fälligkeitsdaten angeben, wenn Sie mit Aufgaben arbeiten. Bei Einstellung auf Nein wird nur der Datumswert verwendet.',
    'tt_db_timeline'                                  => 'Das Zeitleisten-Widget zeigt eine chronologische und durchsuchbare Liste wichtiger Systemereignisse an, z. B. Änderungen des Kundenstatus, per E-Mail gesendete Rechnungen, geleistete Zahlungen, gemachte Notizen usw.',
    'tt_ss_invoices_default_invoice_template'         => 'Wählen Sie die Vorlage aus, die standardmäßig beim Erstellen neuer Rechnungen verwendet wird. Benutzerdefinierte Vorlagen sollten in .\\custom\\templates\\invoice_templates\\ abgelegt werden und müssen mit der Erweiterung .blade.php benannt werden.',
    'tt_ss_invoices_default_doc_scheme'               => 'Wählen Sie das Belegnummernschema aus, das standardmäßig beim Erstellen neuer Rechnungen verwendet werden soll. Belegnummernschemata können in den Konfigurationseinstellungen erstellt werden und ermöglichen Ihnen die Personalisierung Ihrer Belegnummern (Rechnungen, Angebote, Gutschriften).',
    'tt_ss_invoices_invoice_due_days'                 => 'Die standardmäßige Anzahl von Tagen nach dem Rechnungsdatum (Erstellungsdatum), an denen die Rechnung fällig wird und voraussichtlich bezahlt wird.',
    'tt_ss_invoices_automatic_email_ri'               => 'Wenn eine wiederkehrende Rechnung ausgeführt und eine Live-Rechnung erstellt wird, sollte diese Live-Rechnung automatisch per E-Mail an den Kunden gesendet werden?',
    'tt_ss_invoices_qr_code'                          => 'Soll automatisch ein QR-Code auf den Standardrechnungen und Angeboten platziert werden. Wenn Sie benutzerdefinierte Rechnungs- oder Angebotsvorlagen verwenden, beziehen Sie sich auf die Standardvorlagen, um den QR-Code zu Ihren benutzerdefinierten Vorlagen hinzuzufügen.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Was soll mit dem Rechnungsdatum geschehen, wenn sich eine Rechnung im Entwurfsstatus befindet und entweder manuell oder automatisch per E-Mail versendet wird? Wichtiger Hinweis: Wenn eine Rechnung per E-Mail versendet wird, ändert sich der Status automatisch von „Entwurf“ zu „Gesendet“.',
    'tt_ss_invoices_recalculate'                      => 'Führt jede Transaktion für jede Rechnung vom Erstellungsdatum bis zum aktuellen Datum aus und berechnet die Summen, Einzelpostensummen, Steuern, Rabatte und Rechnungssummen neu. Bei einem großen Dataset kann die Ausführung lange dauern.',
    'tt_ss_invoices_due_after'                        => 'Das Fälligkeitsdatum der Rechnung ist das Rechnungsdatum plus die hier eingegebene Anzahl von Tagen.',
    'tt_ss_invoices_default_status_filter'            => 'Der standardmäßig anzuwendende Statusfilter beim Anzeigen der Rechnungsliste.',
    'tt_ss_invoices_default_terms'                    => 'Der Textwert der Bedingungen, der auf der Standard-Rechnungsvorlage im unteren Bereich der Rechnung innerhalb des Bereichs „Allgemeine Geschäftsbedingungen“ angezeigt wird.',
    'tt_ss_invoices_default_footer'                   => 'Fußzeilentextwert, der in der Standardrechnungsvorlage am Ende der Rechnung angezeigt wird. Zum Beispiel:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Wenn der Daily Task Runner (CRON-Job) eine Live-Rechnung aus einer wiederkehrenden Rechnungsvorlage ausführt und generiert, sollte diese neu erstellte Rechnung automatisch per E-Mail an den Kunden gesendet werden? Dies kann Client für Client überschrieben werden.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Wenn eine Zahlung entgegengenommen wird, sollten diese Zahlungsinformationen automatisch per E-Mail an den Kunden gesendet werden?',
    'tt_ss_invoices_online_payment_method'            => 'Die Zahlungsmethode, die zugewiesen wird, wenn ein Kunde über einen öffentlichen Rechnungslink bezahlt. Zahlungsmethoden können über die Systemeinstellungen verwaltet werden.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Soll auf dem Dokument ein QR-Code angezeigt werden, der zur öffentlichen URL der Rechnung oder des Angebots führt?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Sollen Benutzer, auch Admin-Benutzer, Rechnungen löschen dürfen? Eine sicherere und nachvollziehbarere Alternative zum Löschen von Rechnungen besteht darin, den Rechnungsstatus auf „Storniert“ zu ändern, wodurch die Rechnungssumme auf Null gesetzt und von den meisten Listen und Berichten ausgeschlossen wird.',
    'tt_ss_invoices_show_invoices_from'               => 'Wenn Rechnungen per E-Mail versendet werden, wird dies als Absenderadresse angezeigt. Wichtiger Hinweis: Der Wert „Antwort an“ ist immer der Wert, der in den Systemeinstellungen zugewiesen wurde –',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Soll das Rechnungsdatum in der Rechnungsansicht unverändert bleiben oder auf das aktuelle Datum geändert werden, wenn sich die Rechnung im Entwurfsstatus befindet und per E-Mail gesendet wird? Wenn sich das Rechnungsdatum ändert, wird auch das Fälligkeitsdatum aktualisiert.',
    'tt_ss_quotes_default_quote_template'             => 'Wählen Sie die Vorlage aus, die standardmäßig beim Erstellen eines neuen Angebots verwendet wird. Benutzerdefinierte Vorlagen sollten in .\\custom\\templates\\quote_templates\\ abgelegt werden und müssen mit der Erweiterung .blade.php benannt werden.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Wählen Sie das Belegnummernschema aus, das standardmäßig beim Erstellen neuer Angebote verwendet werden soll. Belegnummernschemata können in den Konfigurationseinstellungen erstellt werden und ermöglichen Ihnen die Personalisierung Ihrer Belegnummern (Rechnungen, Angebote, Gutschriften).',
    'tt_ss_quotes_expire_days'                        => 'Die standardmäßige Anzahl von Tagen nach dem Angebots-(Erstellungs-)datum, die das Angebot abläuft. Wenn ein Angebot sein Ablaufdatum überschritten hat, wird davon ausgegangen, dass sich die Preise aufgrund von Marktschwankungen usw. ändern können.',
    'tt_ss_quotes_default_status_filter'              => 'Der standardmäßig anzuwendende Statusfilter beim Anzeigen der Rechnungsliste.',
    'tt_ss_quotes_auto_convert'                       => 'Wenn ein Angebot genehmigt wird, sollte dies dazu führen, dass automatisch eine Rechnung aus dem Angebot erstellt wird.',
    'tt_ss_quotes_when_converted_action'              => 'Wenn ein Angebot in eine Rechnung umgewandelt wird, sollten die Zahlungsbedingungen aus dem Angebot oder aus der Standardeinstellung für Rechnungsbedingungen verwendet werden?',
    'tt_ss_quotes_default_terms'                      => 'Der Textwert der Bedingungen, der in der Standard-Angebotsvorlage im unteren Bereich des Angebots innerhalb des Bereichs „Allgemeine Geschäftsbedingungen“ angezeigt wird.',
    'tt_ss_quotes_default_footer'                     => 'Fußzeilentextwert, der in der Standardangebotsvorlage am Ende des Angebots angezeigt wird. Zum Beispiel:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Was soll mit dem Angebotsdatum geschehen, wenn sich ein Angebot im Entwurfsstatus befindet und per E-Mail gesendet wird, entweder manuell oder automatisch? Wichtiger Hinweis: Wenn ein Angebot per E-Mail gesendet wird, ändert sich der Status automatisch von „Entwurf“ zu „Gesendet“.',
    'tt_ss_quotes_recalculate'                        => 'Führt jede Transaktion aus, die für jedes Angebot durchgeführt wird, vom Erstellungsdatum bis zum aktuellen Datum, und berechnet die Summen, Einzelpostensummen, Steuern, Rabatte und Angebotssummen neu. Bei einem großen Dataset kann die Ausführung lange dauern.',
    'tt_ss_taxes_default_rate1'                       => 'Der primäre Steuersatz, der automatisch auf neue Positionen angewendet werden soll, die zu Rechnungen oder Angeboten hinzugefügt werden. Steuersätze werden über die Konfiguration gepflegt -',
    'tt_ss_taxes_default_rate2'                       => 'Der sekundäre Steuersatz, der automatisch auf neue Positionen angewendet werden soll, die zu Rechnungen oder Angeboten hinzugefügt werden. Steuersätze werden über die Konfiguration gepflegt -',
    'tt_ss_email_send_method'                         => 'Die E-Mail-Sendemethode, die FusionInvoice verwenden soll. Das Ändern der Versandmethode ändert auch die Anzeige der unterstützenden Felder für die Versandmethode.',
    'tt_ss_email_allow_self_cert'                     => 'Wenn Sie diese Option aktivieren, wird die PHP-Verify_Peer-Anforderung deaktiviert. Für weitere Informationen suchen Sie im Internet nach: PHP email self-signed certificate openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Beim Senden von E-Mails ist dies die standardmäßige Antwortadresse, die Ihre Empfänger sehen.',
    'tt_ss_email_always_cc'                           => 'Eine E-Mail-Adresse, die Sie standardmäßig bei jeder gesendeten E-Mail automatisch auf CC setzen möchten.',
    'tt_ss_email_always_bcc'                          => 'Eine E-Mail-Adresse, die Sie standardmäßig bei jeder gesendeten E-Mail automatisch mit BCC versehen möchten.',
    'tt_ss_email_send_test_to'                        => 'Die E-Mail-Adresse, die beim Klicken auf die Schaltfläche „Test-E-Mail senden“ verwendet werden soll.',
    'tt_ss_email_mail_from_addr'                      => 'Die standardmäßige Mail-From-Adresse, die verwendet wird, wenn E-Mails von FusionInvoice gesendet werden. Hinweis: innerhalb der Systemeinstellungen -',
    'tt_ss_email_mail_from_name'                      => 'Der Mail-From-Anzeigename, der in gesendeten E-Mails angezeigt werden soll.',
    'tt_ss_email_email_templates'                     => 'E-Mail-Vorlagen sind für viele Dokumente und Ereignisse verfügbar, darunter: Angebote, Angebotsgenehmigungen, Angebotsablehnungen, Rechnungen, überfällige Rechnungen, Gutschriften, Zahlungseingänge, anstehende Zahlungsmitteilungen. Eine Standardvorlage ist enthalten, aber Sie können auch benutzerdefinierte Vorlagen erstellen, die einfach (wie die bereitgestellten Standardvorlagen) oder vollständig formatiertes HTML sein können.',
    'tt_ss_pdf_driver'                                => 'Der beim Erstellen von PDF-Dokumenten zu verwendende Treiber. Die Auswahl des Treibers „wkhtmltopdf“ erfordert eine lokale Serverinstallation dieses Programms und die Einstellung des entsprechenden Binärpfads dafür.',
    'tt_ss_pdf_binary_path'                           => 'Der lokale Serverpfad zur Binärdatei für wkhtmltopdf. Zum Beispiel C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice unterstützt mehrere Online-Zahlungsanbieter. Aktivieren Sie die Anbieter, bei denen Sie Konten eingerichtet haben. Die hier aktivierten Anbieter werden als Zahlungsoptionen angezeigt, wenn Ihre Kunden ihre Rechnungen über den öffentlichen Rechnungslink (in der Standard-Rechnungs-E-Mail enthalten) anzeigen.',
    'tt_ss_olp_api_key'                               => 'Der API-Schlüssel wird Ihnen von Ihrem Zahlungsanbieter zur Verfügung gestellt.',
    'tt_ss_olp_payment_button_text'                   => 'Der Text, der auf der Zahlungsmethode-Schaltfläche für diesen Zahlungsanbieter oben auf Ihrer öffentlichen Rechnung angezeigt wird, wie von Ihren Kunden gesehen.',
    'tt_ss_olp_mode'                                  => 'Unterstützt von einigen Zahlungsanbietern, was Sandbox mehr (Testen) und Live ermöglicht.',
    'tt_ss_olp_client_id'                             => 'Die Kunden-ID wird Ihnen von diesem Zahlungsanbieter bereitgestellt.',
    'tt_ss_olp_client_secret'                         => 'Das Kundengeheimnis wird Ihnen von diesem Zahlungsanbieter zur Verfügung gestellt.',
    'tt_ss_olp_publishable_key'                       => 'Der Publishable Key wird Ihnen von diesem Zahlungsanbieter zur Verfügung gestellt.',
    'tt_ss_olp_secret_key'                            => 'Der Secret Key wird Ihnen von diesem Zahlungsanbieter zur Verfügung gestellt.',
    'tt_ss_olp_opp_fees_about'                        => 'Für Kunden, die per Kreditkarte zahlen, können Bearbeitungsgebühren für Online-Zahlungen erhoben werden, die ihren öffentlichen Rechnungslink (in der Rechnungs-E-Mail enthalten) verwenden.',
    'tt_ss_olp_enable_opp_fees'                       => 'Für Kunden, die per Kreditkarte zahlen, können Bearbeitungsgebühren für Online-Zahlungen erhoben werden, die ihren öffentlichen Rechnungslink (in der Rechnungs-E-Mail enthalten) verwenden. Diese Option hat eine globale Systemeinstellung, kann aber auch auf individueller Client-Basis überschrieben werden.',
    'tt_ss_olp_opp_fee_pct'                           => 'Der Prozentsatz des Rechnungsbetrags, der als Bearbeitungsgebühr für Online-Zahlungen (Convenience-Gebühr) berechnet werden soll.',
    'tt_ss_olp_opp_fee_name'                          => 'Der Gebührenname, der auf der Rechnung erscheinen soll. Dh. \'Vorzugsgebühr für Kreditkarten\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Eine Erläuterung der Gebühr, die auf der Rechnung anzugeben ist. Dh. „Für alle Kreditkartentransaktionen wird eine Gebühr von 3 % erhoben“',
    'tt_company_profiles_about'                       => 'Unternehmensprofile ermöglichen es Ihnen, Ihr Unternehmen mit jedem Profil anders zu präsentieren, indem Sie unterschiedliche Firmennamen, Logos, Rechnungsformate usw. zulassen. Es bietet eine Möglichkeit, mehrere virtuelle Unternehmen innerhalb derselben FusionInvoice-Installation zu haben. In den Systemeinstellungen muss ein Standard-Firmenprofil ausgewählt werden.',
    'tt_users_about'                                  => 'Sie können Benutzer vom Typ Admin (Vollzugriff) oder Standard (individuelle Systemberechtigungen müssen erteilt werden) erstellen. Wenn Sie „Anmeldung beim Kundencenter zulassen“ für einen Kundendatensatz auf „Ja“ setzen, wird automatisch ein Benutzerdatensatz für den Kunden hinzugefügt. Kundenbenutzer können jedoch nur über die Benutzeroberfläche für die Kundeneinstellungen hinzugefügt werden.',
    'tt_users_client_about'                           => 'Kundenbenutzer können sich nur beim Kundencenter anmelden, das ihnen eine eingeschränkte Ansicht ihrer Rechnungen, Angebote und Zahlungen ermöglicht. Wenn Sie „Anmeldung beim Kundencenter zulassen“ für einen Kundendatensatz auf „Ja“ setzen, wird ihm Zugriff auf das Kundencenter gewährt.',
    'tt_user_types_about'                             => 'Admin-Benutzer haben vollen Systemzugriff. Standardbenutzern können die individuellen Berechtigungen erteilt werden, die sie benötigen. Client-Benutzer haben nur im Client Center Zugriff auf ihre spezifischen Informationen, und ihre Anmeldemöglichkeit wird in den Client-Einstellungen festgelegt -',
    'tt_custom_fields_about'                          => 'Mit benutzerdefinierten Feldern können Sie den meisten Modulen Ihre eigenen Datenfelder hinzufügen. Wenn Sie die Branche für Kunden erfassen müssen, fügen Sie einfach ein benutzerdefiniertes Feld mit der Bezeichnung „Branche“ auf der Seite „Kunden“ hinzu und machen es zu einem Dropdown-Typ. Benutzerdefinierte Felder werden automatisch unter den normalen Feldern angezeigt.',
    'tt_recurring_invoices_about'                     => 'Wiederkehrende Rechnungen sind eigentlich keine Rechnungen, sondern Vorlagen zum Erstellen zukünftiger Rechnungen. Sie haben eine Wiederholungshäufigkeit und ein nächstes Datum, die bestimmen, wann sie eine Live-Rechnung erstellen. Ein täglicher CRON-Job oder eine geplante Aufgabe ist erforderlich, damit wiederkehrende Rechnungen ordnungsgemäß funktionieren.',
    'tt_addons_about'                                 => 'Add-ons sind Anpassungen an FusionInvoice für einzigartige Geschäftsanforderungen, wie z. B. Zeiterfassung, Preisangaben oder sylisierte Rechnungsvorlagen. Sie werden über den Add-On-Marktplatz FusionInvoice angeboten.',
    'client_center_user'                              => 'Kundencenter-Benutzer',
    'user_type'                                       => 'Benutzertyp',
    'custom_field'                                    => 'Benutzerdefinierte Feld',
    'placeholder_type_email_template'                 => 'Geben oder fügen Sie Ihre E-Mail-Vorlage ein. . .',
    'email_templates'                                 => 'E-Mail-Vorlagen',
    'payment_receipts'                                => 'Zahlungseingänge',
    'upcoming_payment_notices'                        => 'Bevorstehende Zahlungsmitteilungen',
    'convenience_fee_for_credit_card_transactions'    => 'Gefälligkeitsgebühr für Kreditkartentransaktionen',
    'credit_card_processing_fee'                      => 'Bearbeitungsgebühr für Kreditkarten',
    'delete_client_user_warning'                      => '<p>Durch das Löschen eines Kundenbenutzers wird dessen Möglichkeit, sich beim Kundencenter anzumelden, deaktiviert.</p>',
    'use_default_mail_template'                       => 'Standard-E-Mail-Vorlage',
    'use_custom_mail_template'                        => 'Benutzerdefinierte Mail-Vorlage',
    'quote_email_body'                                => 'E-Mail-Text zitieren',
    'overdue_invoice_email_body'                      => 'E-Mail-Text für überfällige Rechnungen',
    'credit_memo_email_body'                          => 'E-Mail-Text der Gutschrift',
    'payment_receipt_body'                            => 'Zahlungseingangstext',
    'invoice_email_body'                              => 'Rechnungs-E-Mail-Text',
    'quote_custom_email_body_require'                 => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text des Angebots ein',
    'quote_custom_approve_email_body_require'         => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text zur Angebotsgenehmigung ein',
    'quote_reject_email_body_require'                 => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text der Angebotsablehnung ein',
    'overdue_invoice_email_body_require'              => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text für überfällige Rechnungen ein',
    'invoice_email_body_require'                      => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text der Rechnung ein',
    'credit_memo_email_body_require'                  => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text der Gutschrift ein',
    'payment_receipt_email_body_require'              => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text des Zahlungsbelegs ein',
    'upcoming_payment_notice_email_body_require'      => 'Bitte geben Sie Ihre benutzerdefinierte E-Mail-Vorlage für den E-Mail-Text der bevorstehenden Zahlungsbenachrichtigung ein',
    'copy_text'                                       => 'Text kopieren',
    'tt_preview_template'                             => 'Vorschauvorlage',
    'tt_view_template_code'                           => 'Vorlagencode anzeigen',
    'dashboard_date_range'                            => 'Datumsbereich des Dashboards',
    'tt_dashboard_date_range'                         => 'Das Dashboard Date Range filtert die Ansicht nach den folgenden Widgets: KPI-Karten, Verkaufsdiagramm, Letzte Kundenaktivität.',
    'product_copy'                                    => 'Produktkopie',
    'open_selected_client'                            => 'Ausgewählten Client öffnen',
    'save_this_client'                                => 'Diesen Client speichern (kein Duplikat)',
    'looks_like_duplicate'                            => 'Hmm ... Das sieht aus wie ein Duplikat',
    'duplicate_instructions'                          => 'Wenn Sie den gewünschten Client in der Liste sehen, wählen Sie ihn aus und öffnen Sie ihn. Wenn nicht, speichern Sie den neuen Client.',
    'select_checkbox'                                 => 'Wählen Sie einen Kunden aus',
    'select_lead_source_tag'                          => 'Wählen Sie Client-Lead-Quelle',
    'lead_source'                                     => 'Hauptquelle',
    'tt_client_lead_source_tags'                      => 'Kunden-Lead-Quelle auswählen oder eingeben (wie der Kunde akquiriert wurde)',
    'your_link_is_expired'                            => 'Hoppla! Ihr Link ist abgelaufen.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Zurück zum Dashboard</a>.',
    'secure_link_and_expire_link_days'                => 'Öffentliche Rechnungslinks sichern und ablaufen lassen',
    'secure_link_expire_days'                         => 'Anzahl der Tage',
    'tt_secure_link_and_expire_link_days'             => 'Wenn Sie sichere Links aktivieren, müssen Sie auch die Anzahl der Tage festlegen, nach denen der Rechnungslink abläuft. Auf diese Weise kann ein Kunde seinen öffentlichen Rechnungslink anzeigen, bis er abläuft.',
    'expire_time_period'                              => 'Das Feld Link Expire Number of Days ist erforderlich',
    'enter_days'                                      => 'Geben Sie Tage ein',
    'invalid_field_name'                              => 'Bitte geben Sie einen gültigen Feldnamen ein',
    'lead_source_notes'                               => 'Hinweise zur Lead-Quelle',
    'important_note'                                  => 'Wichtiger Hinweis',
    'social_media_url'                                => 'Social-Media-URL',
    'general_notes'                                   => 'Allgemeine Hinweise',
    'payment_amount_mismatch'                         => 'Nichtübereinstimmung des Zahlungsbetrags',
    'open_invoice_aging'                              => 'Rechnungsalterung öffnen',
    'tt_db_open_invoice_aging'                        => 'Rechnungsalterung öffnen',
    'current'                                         => 'Strom',
    'oneToThirty'                                     => '1-30 Tage',
    'thirtyOneToSixty'                                => '31-60 Tage',
    'sixtyOneToNinety'                                => '61-90 Tage',
    'ninetyOnePlus'                                   => '91 Tage',
    'sent_and_draft'                                  => 'Fügen Sie sowohl gesendete als auch Entwurfsrechnungen hinzu',
    'sent_only'                                       => 'Nur gesendete Rechnungen einbeziehen',
    'tt_open_ar_aging_settings'                       => 'Einstellungen für Fälligkeitssummen offener Rechnungen',
    'tt_client_field_settings'                        => 'Wählen Sie die Felder aus, die in Ihrer Kundenansicht angezeigt werden sollen',
    'position_change'                                 => 'Stelle geändert',
    'dynamic_width'                                   => 'Dynamische Breite',
    'full_width'                                      => 'Gesamtbreite',
    'save_configuration_default'                      => 'Konfiguration als Systemstandard speichern',
    'assign_configuration_other'                      => 'Konfiguration anderen Benutzern zuweisen',
    'tt_user_tags'                                    => 'Benutzer-Tags',
    'select_users'                                    => 'Wählen Sie Benutzer aus',
    'configuration_assigned'                          => 'Konfiguration erfolgreich zugewiesen',
    'default_configuration_set'                       => 'Standardkonfiguration erfolgreich festgelegt',
    'current_user_id'                                 => 'Aktuelle Benutzer-ID',
    'tt_users_settings'                               => 'Benutzereinstellungen',
    'invoice_link_expire'                             => 'Der öffentliche Link Ihrer Rechnung läuft ab in',
    'quote_link_expire'                               => 'Der öffentliche Link Ihres Angebots läuft ab in',
    'dashboard_width'                                 => 'Dashboard :widthName Spaltenbreiteneinstellung geändert',
    'unmark_mailed'                                   => 'Markierung als verschickt aufheben',
    'invoice_unmark_mailed'                           => 'Rechnung als verschickt entmarkieren',
    'print_mark_mailed'                               => 'Drucken',
    'public_link'                                     => 'Öffentlicher Link',
    'tt_sales_chart_settings'                         => 'Einstellung für Verkaufstabelle Rechnung/Summe',
    'verify_key'                                      => 'Überprüfung des Produktschlüssels',
    'enter_key'                                       => 'Geben Sie Ihren Schlüssel ein',
    'verify'                                          => 'Überprüfen Sie es!',
    'key_required'                                    => 'Produktschlüssel ist erforderlich',
    'key_length_invalid'                              => 'Bitte geben Sie den 32-stelligen Produktschlüssel ein, den Sie beim Kauf erhalten haben.',
    'invalid_key'                                     => 'Ihr Schlüssel ist leider ungültig. Die Installation kann nicht fortgesetzt werden.',
    'key_verified'                                    => 'Herzlichen Glückwunsch, Ihr Schlüssel wurde verifiziert.',
    'clear_cache'                                     => 'Cache leeren',
    'clear_cache_confirm'                             => 'Möchten Sie Ihren Anwendungscache wirklich löschen?',
    'cache_clear_success'                             => 'Cache erfolgreich gelöscht.',
    'cache_clear_error'                               => 'Bitte überprüfen Sie Ihre Serverkonfiguration auf den PHP-Befehl exec().',
    'add_new_client'                                  => 'Neuen Kunden hinzufügen',
    'add'                                             => 'Addieren',
    'invalid_quantity_amount'                         => 'Ungültiger Mengenbetrag! Muss größer als 0 sein.',
    'api_version'                                     => 'API-Version',
    '2021_prior'                                      => '2021 und früher',
    '2022_later'                                      => '2022 und später',
    'vendors'                                         => 'Anbieter',
    'file_not_found'                                  => ':file_name wurde nicht gefunden',
    'leave_empty_no_parent_account'                   => 'leer lassen, wenn der Kunde kein übergeordnetes Konto hat',
    'leave_empty_client_pays_invoices'                => 'leer lassen, wenn der Kunde seine eigenen Rechnungen bezahlt',
    'modal_not_found'                                 => 'Modal nicht gefunden',
    'payment_delete_success'                          => 'Zahlung erfolgreich gelöscht',
    'payment_delete_error'                            => 'Beim Löschen der Zahlung ist ein Problem aufgetreten. Bitte versuchen Sie es später erneut.',
    'status_change_error'                             => 'Etwas ist schief gelaufen! Status wurde nicht geändert.',
    'total_payments'                                  => 'Gesamtzahlungen',
    'licence_verification_error'                      => 'Ihr Lizenzschlüssel kann nicht verifiziert werden.',
    'line_item_discount_limit'                        => 'Werbebuchungen dürfen keinen Rabatt von mehr als 99,99% haben.',
    'date_range_report'                               => 'Datumsbereich (nächster Ausführungstermin)',
    'no_client_found'                                 => 'Hmmm… wir konnten diesen Kunden nicht finden.',
    'tt_line_item_discount'                           => 'Ein Einzelartikelrabatt kann als Prozentsatz des Preises oder als Pauschalbetrag für den Einzelartikelpreis berechnet werden.',
    'functionality_not_available_on_demo'             => 'Leider ist diese Funktion in der Demo nicht erlaubt.',
    'vat_tax_id'                                      => 'Umsatzsteuer-ID',
    'tt_vat_tax_id'                                   => 'Umsatzsteuer-Identifikationsnummer',
    'enable_vat_tax_id'                               => 'Umsatzsteuer-ID aktivieren',
    'no-attachment'                                   => 'es gibt keinen Anhang',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Aufräumen',
    'allow_edit_status_invoice'                       => ':status Rechnung bearbeiten',
    'tt_ss_allow_edit_invoices_status'                => 'Aus Sicherheitsgründen können nur Rechnungen im Entwurfsstatus bearbeitet werden. Sie können dies außer Kraft setzen, indem Sie die Bearbeitung von gesendeten und/oder bezahlten Rechnungen zulassen.',
    'allow_edit_invoices_status'                      => 'Bearbeiten von Rechnungen im Status zulassen',
    'draft_and_sent'                                  => 'Entwurf und gesendet',
    'draft_or_sent_and_paid'                          => 'Entwurf, gesendet und bezahlt',
    'invoice_editable'                                => 'Rechnung bearbeitbar',
    'can_not_edit_paid_invoice'                       => 'Sie können eine bezahlte Rechnung nicht bearbeiten',
    'item_category'                                   => 'Artikelkategorie',
    'itemLookups'                                     => 'Artikelsuche',
    'quoteItems'                                      => 'Artikel zitieren',
    'invoiceItems'                                    => 'Rechnungspositionen',
    'imports_disabled_in_demo.'                       => 'Importe sind in der Demo deaktiviert.',
    'no_file_selected'                                => 'Keine Datei ausgewählt',
    'no_import_records'                               => 'Es wurden keine Datensätze zum Importieren gefunden',
    'vendor_name'                                     => 'Herstellername',
    'license_key'                                     => 'Lizenzschlüssel',
    'change_license_key'                              => 'Lizenzschlüssel ändern',
    'verify_and_save'                                 => 'Verifizieren',
    'same_key_error'                                  => 'Keine Änderung erkannt. Bitte versuchen Sie es mit einem anderen Schlüssel',
    'trying_invalid_key'                              => 'Leider konnte dieser Schlüssel nicht verifiziert werden. Der Lizenzschlüssel wurde nicht geändert.',
    'key_updated'                                     => 'Glückwunsch! Ihr Lizenzschlüssel wurde erfolgreich aktualisiert.',
    'invalid_date_format'                             => 'Ungültiges Datumsformat. Erforderliches Format: JJJJ-MM-TT',
    'invalid_datetime_format'                         => 'Ungültiges DateTime-Format. Erforderliches Format: JJJJ-MM-TT HH:MM :SS',
    'profile_setting'                                 => 'Profileinstellungen',
    'include_draft_invoices_unpaid_and_overdue'       => 'Nehmen Sie Rechnungsentwürfe in Listen für unbezahlte und überfällige Rechnungen auf',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Bei Einstellung auf Ja werden Rechnungen mit dem Status Entwurf in Listen und Berechnungen für überfällige und unbezahlte Rechnungen aufgenommen.',
    'tt_utilities_import'                             => 'Importieren Sie Daten aus CSV-Dateien in Ihre FusionInvoice-Datenbank.',
    'tt_utilities_export'                             => 'Exportieren Sie Daten aus Ihrer FusionInvoice-Datenbank in verschiedene Formate: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Sehen Sie sich die Protokolldatei an, die alle E-Mail-Ereignisse in FusionInvoice enthält.',
    'tt_utilities_system_log'                         => 'Sehen Sie sich die Systemprotokolldatei mit Fehler- und Warnsystemereignissen an.',
    'tt_utilities_tag_cleanup'                        => 'Entfernt Tags, die definiert, aber nicht verwendet wurden. Entfernt außerdem alle doppelten Tags.',
    'tt_utilities_pdf_cleanup'                        => 'Entfernt temporäre PDF-Dateien.',
    'tt_utilities_recalc_invoices'                    => 'Durchsucht jede Rechnung und stellt sicher, dass die Gesamtsummen mit der Summe aller Einzelposten übereinstimmen, wobei Rabatte und Steuern berücksichtigt werden. *Dies kann lange dauern.',
    'tt_utilities_recalc_quotes'                      => 'Durchsucht jedes Angebot und stellt sicher, dass die Gesamtsummen mit der Summe aller Einzelposten übereinstimmen, wobei Rabatte und Steuern berücksichtigt werden. *Dies kann lange dauern.',
    'tt_utilities_clear_cache'                        => 'Entfernt temporäre Cache-Dateien.',
    'tt_utilities_download_database'                  => 'Laden Sie eine exportierte Datenbankdatei aus Ihren Live-FusionInvoice-Daten herunter. Je größer Ihre Datenbank ist, desto länger dauert dies.',
    'tt_utilities_run_daily_tasks'                    => 'Ein CRON-Job oder eine geplante Aufgabe führt normalerweise Ihre täglichen Aufgaben aus. Dadurch können Sie dies manuell tun. Es generiert Live-Rechnungen aus wiederkehrenden Rechnungsvorlagen, sendet Zahlungserinnerungen usw.',
    'include_line_item_detail'                        => 'Einzelpostendetails einschließen',
    'invoice_tags'                                    => 'Rechnungs-Tags',
    'related_accounts'                                => 'Verwandte Konten',
    'not_found_related_clients'                       => 'Es wurden keine zugehörigen Kundenkonten zugewiesen',
    'invoices_paid_for_list'                          => 'Dieses Kundenkonto bezahlt Rechnungen für',
    'child_accounts_exist'                            => 'Die Einstellung „Untergeordnete Konten zulassen“ wurde auf „Ja“ zurückgesetzt. Kann nicht zu Nein geändert werden, wenn untergeordnete Konten vorhanden sind.',
    'third_bp_accounts_exist'                         => 'Die Einstellung für den Drittanbieter-Rechnungszahler wurde auf „Ja“ zurückgesetzt. Kann nicht zu',
    'tag_name'                                        => 'Verlinke den Namen',
    'tag_new_name'                                    => 'Neuer Tag-Name',
    'tag_category'                                    => 'Tag-Kategorie',
    'rename_tags'                                     => 'Tags umbenennen',
    'apply'                                           => 'Anwenden',
    'select_tag_category'                             => 'Wählen Sie Tag-Kategorie aus',
    'tt_utilities_rename_tags'                        => 'Benennen Sie Tags um, die Kunden, Notizen, Verkaufsaktivitäten usw. zugewiesen wurden.',
    'system_default_dashboard'                        => 'System-Standard-Dashboard',
    'user_specific_dashboards'                        => 'Benutzerspezifische Dashboards',
    'tt_default_client_type'                          => 'Standard-Client-Typ',
    'default_client_type'                             => 'Standard-Client-Typ',
    'invalid_user'                                    => 'Bitte wählen Sie einen gültigen Benutzer aus.',
    'create_live_invoice'                             => 'Live-Rechnung erstellen',
    'create_live_invoice_successfully'                => 'Live-Rechnung',
    'create_live_invoice_unsuccessfully'              => 'Live-Rechnung wurde nicht erstellt',
    'live_invoice_not_generate'                       => 'Es kann keine Live-Rechnung aus einer wiederkehrenden Rechnung generiert werden, die ein Enddatum von heute oder früher oder ein nächstes Datum mehr als 30 Tage in der Zukunft hat.',
    'data_seeder'                                     => 'Daten-Seeder',
    'select_module'                                   => 'Modul auswählen',
    'number_of_seed'                                  => 'Anzahl der Samen',
    'seed_it'                                         => 'Samen es!',
    'seeds_success'                                   => 'Seeds erfolgreich hinzugefügt',
    'tt_ri_generate_the_next_live_invoice'            => 'Generieren Sie jetzt die nächste Live-Rechnung für diese wiederkehrende Rechnung.',
    'system_log_clear_message'                        => 'Möchten Sie das Systemprotokoll wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden und alle vorherigen Protokolle werden dauerhaft gelöscht.',
    'system_log_clear_successfully'                   => 'Systemprotokoll erfolgreich gelöscht',
    'payment_problem'                                 => 'Während der Zahlung ist ein Problem aufgetreten. Bitte versuchen Sie es später erneut.',
    'log_detail'                                      => 'Klicken Sie hier, um das Detailprotokoll anzuzeigen.',
    'log_limit_message'                               => 'Logdatei',
    'log_download_file'                               => 'Download-Datei',
    'log_delete_all'                                  => 'Alle Dateien löschen',
    'log_level'                                       => 'Eben',
    'log_context'                                     => 'Kontext',
    'log_date'                                        => 'Datum',
    'log_line_number'                                 => 'Zeilennummer',
    'log_content'                                     => 'Inhalt',
    'addon_install_error'                             => 'Es gibt ein Problem mit der Addon-Installation. Bitte versuchen Sie es später erneut.',
    'addon_installed_success'                         => 'Addon erfolgreich installiert.',
    'allow_edit_status_credit_memo'                   => 'Angewendete Gutschrift bearbeiten',
    'database_seeder'                                 => 'Sämaschine',
    'tt_utilities_database_seeder'                    => 'Seeden Sie Ihre Datenbank mithilfe von Seed-Klassen mit Testdaten',
    'vat_information'                                 => 'Informationen zur Mehrwertsteuer',
    'tt_vat_information'                              => 'IBAN Bankkontonummer, BIC, E-Mail usw.',
    'explore_addons'                                  => 'Entdecken Sie Add-ons',
    'available_addons'                                => 'Verfügbare FusionInvoice-Add-ons',
    'addon_success'                                   => 'Addon wurde erfolgreich hinzugefügt.',
    'payment_cannot_enabled_in_demo'                  => 'Zahlungsgateways können in der Demo nicht aktiviert werden',
    'confirm_approve_leave_page'                      => 'Auf dieser Seite sind noch nicht gespeicherte Änderungen vorhanden! Sind Sie sicher, dass Sie die Seite verlassen möchten, ohne zu speichern?',
    'leave'                                           => 'Verlassen',
    'demo_date_refresh'                               => 'Demodaten werden aktualisiert',
    'minutes'                                         => 'Protokoll',
    'minute'                                          => 'Minute',
    'seconds'                                         => 'Sekunden',
    'mautic-authentication-fail'                      => 'Sie sind nicht berechtigt, auf diese Ressource zuzugreifen. Bitte verwenden Sie einen gültigen geheimen Schlüssel.',
    'something_went_wrong'                            => 'Etwas ist schief gelaufen!',
    'month_to_date'                                   => 'Dieser Monat bis heute',
    'quarter_to_date'                                 => 'Dieses Quartal bis heute',
    'year_to_date'                                    => 'Jahr zu Datum',
    'last_active'                                     => 'letzte Aktivität',
    'database_seeder_stop'                            => ':name BUSINESS SEEDER STOP',
    'database_seeder_start'                           => ':name BUSINESS SEEDER START',
    'seeder_records_created'                          => ':total Datensätze für :modal erfolgreich erstellt',
    'seeder_credit_apply_invoice'                     => 'Gutschrift auf Rechnung anwenden',
    'seeder_quote_approve_reject'                     => 'Angebot genehmigen und ablehnen',
    'seeder_executed'                                 => 'Sämaschine erfolgreich ausgeführt!',
    'seeder_not_executed'                             => 'Seeder wurde nicht ausgeführt!',
    'db_to_file_system_attachments_migration'         => 'Migration von Anhängen – Datenbank in Dateisystem',
    'attachment_content_count'                        => 'Sie sind dabei, insgesamt zu migrieren',
    'attachment_repeat_content_count'                 => 'Sie sind dabei, insgesamt zu migrieren',
    'attachment_key_invalid'                          => 'Der Anhangsschlüssel ist ungültig',
    'stop'                                            => 'Stoppen!',
    'attachment_migration_warning'                    => 'Durch diesen Schritt werden die Anhänge von Ihrer Datenbank in Ihr Dateisystem migriert. Bitte führen Sie eine vollständige Datenbanksicherung durch, bevor Sie fortfahren, und stellen Sie sicher, dass Sie über ausreichend Speicherplatz für diesen Vorgang verfügen.',
    'attachment_agreement_accept'                     => 'Ich habe meine Datenbank gesichert.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Microsoft 365-Passwort',
    'office365_username'                              => 'Microsoft 365-Benutzername',
    'custom_date_formula_note1'                       => '<b><u>Standardwert-Platzhalter :</span></u></b> ~<br> Sie können <b>heute, morgen und gestern</b> einen beliebigen Wert als Standard verwenden.<br>',
    'custom_date_formula_note2'                       => '<b>Für heute + N Tage verwenden Sie </b> „default“: „+7“. Dadurch werden 7 Tage zum heutigen Datum hinzugefügt. <br><b>Für heute – N Tage verwenden Sie </b> „default“: \'-7\' Dadurch werden 7 Tage vom heutigen Datum abgezogen <br>',
    'mail_config_error'                               => 'Ohne definierte E-Mail-Versandmethode kann keine Test-E-Mail gesendet werden.',
    'db_prefix_alert'                                 => 'Wir haben festgestellt, dass Sie das Datenbankpräfix :prefix verwenden. FusionInvoice wird in zukünftigen Versionen keine Datenbankpräfixe mehr unterstützen. Bitte bearbeiten Sie Ihre Datenbank und benennen Sie alle Ihre Tabellen um, indem Sie das Präfix entfernen. Bearbeiten Sie dann Ihre Datei „database.php“ und setzen Sie Ihren „Präfix“-Wert auf leer',
    'db_prefix_alert_title'                           => 'Die Unterstützung für DB-Präfixe endet bald',
    'add_title_bar_shortcut'                          => 'Verknüpfung zur Titelleiste hinzufügen',
    'title_bar_shortcuts'                             => 'Tastenkombinationen für die Titelleiste',
    'select_icon'                                     => 'Symbol auswählen',
    'all_payment_method'                              => 'Alle Zahlungsmethoden',
    'about'                                           => 'Um',
    'own_license'                                     => 'Eigene Lizenz',
    'tt_own_license'                                  => 'Eigene Lizenz',
    'git_branch'                                      => 'Aktueller Git-Zweig',
    'quote_email'                                     => 'Angebot E-Mail',
    'custom1'                                         => 'Benutzerdefiniert 1',
    'custom2'                                         => 'Benutzerdefiniert 2',
    'custom3'                                         => 'Benutzerdefiniert 3',
    'default_document_template'                       => 'Standarddokumentvorlage',
    'default_email_template'                          => 'Standard-E-Mail-Vorlage',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Preisformel',
    'is_mobile'                                       => 'Ist mobil?',
    'default_sms_template'                            => 'Standard-SMS-Vorlage',
    'sms_log'                                         => 'SMS-Protokoll',
    'two_factor_auth'                                 => 'Zwei-Faktor-Authentifizierung',
    'enabled_mail_driver'                             => 'Bitte aktivieren Sie den E-Mail-Dienst',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Ungültiger Bestätigungscode',
    'otp-subject'                                     => 'OTP-Anmeldung',
    'resend_otp_success'                              => 'Bestätigungscode erneut gesendet',
    'resend_otp_btn'                                  => 'Code erneut senden',
    'expired_otp'                                     => 'Bestätigungscode abgelaufen',
    'token_expired'                                   => 'Ihr CSRF-Token ist abgelaufen',
    'verification_code'                               => 'Bestätigungscode',
    'migration'                                       => 'Migration',
    'invoice_status_change_draft_to_sent'             => 'Der Rechnungsstatus wurde von Entwurf auf Gesendet geändert',
    'default_sales_quantity'                          => 'Standardverkaufsmenge',
    'lead_time'                                       => 'Durchschnittliche Vorlaufzeit (Tage)',
    'primary_vendor_id'                               => 'Bevorzugter Anbieter',
    'all_items'                                       => 'Alle Elemente',
    'non_inventory_items'                             => 'Nicht im Lager befindliche Artikel',
    'back_ordered'                                    => 'Nachbestellt',
    'low_inventory'                                   => 'Geringer Lagerbestand',
    'high_inventory'                                  => 'Hoher Lagerbestand',
    'merge_client_records'                            => 'Kundendatensätze zusammenführen',
    'primary_merge_to_client'                         => 'Zusammenführen mit (behalten)',
    'surrogate_merge_from_client'                     => 'Zusammenführen von (verwerfen)',
    'merge'                                           => 'Verschmelzen',
    'merge_action'                                    => 'Zusammenführungsaktion',
    'ignore'                                          => 'Ignorieren',
    'overwrite'                                       => 'Überschreiben',
    'add_to'                                          => 'Hinzufügen zu',
    'select_merge_client'                             => 'Zum Zusammenführen auswählen',
    'client_to_and_from_not_same'                     => 'Der „An-Client“ und der „Von-Client“ müssen unterschiedlich sein.',
    'client_id_required'                              => 'Das Client-Auswahlfeld muss sowohl erforderlich als auch eindeutig sein.',
    'is_merge'                                        => 'Verschmelzen',
    'record_successfully_merged'                      => 'Datensatz erfolgreich zusammengeführt',
    'service_ends'                                    => 'Dienstende',
    'service_starts'                                  => 'Dienst beginnt',
    'explanation'                                     => 'Erläuterung',
    'subscription_details'                            => 'Abonnementdetails',
    'generate_next_invoice'                           => 'Nächste Rechnung generieren',
    'subscription'                                    => 'Abonnement',
    'of_the'                                          => 'Des',
    'on'                                              => 'An',
    'invoice_month'                                   => 'Rechnungsmonat',
    'invoice_year'                                    => 'Rechnungsjahr',
    'next_month'                                      => 'Nächsten Monat',
    'next_year'                                       => 'Nächstes Jahr',
    'day'                                             => 'Tag',
    'last_date'                                       => 'Letztes Datum',
    'merge_record_warning'                            => 'Stopp! Das Zusammenführen von Kundenkonten kann nicht rückgängig gemacht werden. Zusätzlich zu den Feldern, die Sie zum Überschreiben oder Hinzufügen ausgewählt haben, wird der gesamte Transaktionsverlauf des zusammenzuführenden Kunden auf den zusammenzuführenden Kunden übertragen. Möchten Sie diese Kundenkonten wirklich zusammenführen?',
    'merge_child_account_warning'                     => 'Der Merge(From)-Client verfügt über ein übergeordnetes Konto mit zugehörigen untergeordneten Konten, die dem Merge(To)-Client neu zugewiesen werden. Stellen Sie sicher, dass der Merge(To)-Client als übergeordnetes Konto zugelassen ist.',
    'merge_parent_account_warning'                    => 'Durch die Zusammenführung wird Ihre Verbindung zum übergeordneten Konto entfernt.',
    'merge_invoices_paid_by_warning'                  => 'Durch das Zusammenführen wird Ihre Verbindung zur übergeordneten Rechnung, von der bezahlt wurde, entfernt.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Die Anzahl der Beziehungen im Clientmodell hat sich geändert.',
    'payment_terms'                                   => 'Zahlungsbedingungen',
    'net_amount_due_in'                               => 'Nettobetrag fällig in',
    'net_amount_due_by'                               => 'Nettobetrag zahlbar bis',
    'if_paid_within'                                  => 'bei Zahlung innerhalb',
    'if_paid_by'                                      => 'bei Zahlung durch',
    'th_of_next_month'                                => 'des nächsten Monats',
    'of_next_month'                                   => 'des nächsten Monats',
    'down_payment'                                    => 'Anzahlung',
    'balance_amount_due_of'                           => 'Restbetrag in',
    'payment_split_over'                              => 'Zahlung aufgeteilt über',
    'installments'                                    => 'Ratenzahlung',
    'days_from_invoice_date'                          => 'Tage ab Rechnungsdatum',
    'payment'                                         => 'Zahlung',
    'one'                                             => 'Eins',
    'two'                                             => 'Zwei',
    'three'                                           => 'Drei',
    'four'                                            => 'Vier',
    'five'                                            => 'Fünf',
    'six'                                             => 'Sechs',
    'discount_percent'                                => 'Rabattprozentsatz',
    'discount_days_simple'                            => 'Rabatttage Einfach',
    'discount_days_nth'                               => 'Rabatttage Nth',
    'net_due_days'                                    => 'Nettofälligkeitstage',
    'balance_due_days'                                => 'Restbetrag in Tagen',
    'number_of_installments'                          => 'Anzahl der Raten',
    'payment_term'                                    => 'Zahlungsfrist',
    'select_payment_term'                             => 'Zahlungsbedingung auswählen',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Das Feld „Ratenzahlungsprozentsatz :index ist erforderlich und größer als Null.',
        'installment_due_days_error'                  => 'Das Feld „Ratenfälligkeitstage :index ist erforderlich',
        'discount_percent_gt_error'                   => 'Der angegebene Rabattprozentsatz ist erforderlich und größer als Null.',
        'discount_percent_lt_error'                   => 'Der angegebene Rabattprozentsatz ist erforderlich und liegt unter 100 %.',
        'down_payment_percent_lt_error'               => 'Der angegebene Prozentsatz für die Anzahlung ist erforderlich und darf nicht mehr als 100 % betragen.',
        'discount_percent_numeric_error'              => 'Das Feld „Rabattprozentsatz“ muss einen numerischen Wert enthalten und darf nicht unter 100 % liegen.',
        'down_payment_gt_error'                       => 'Die angegebene Anzahlung ist erforderlich und muss größer als Null sein.',
        'discount_days_gt_net_days_error'             => 'Die Anzahl der Fälligkeitstage des Nettobetrags sollte größer sein als die Anzahl der Skontotage.',
        'discount_days_nth_gt_net_days_error'         => 'Der Nettobetrag muss in Tagen fällig sein, die N-te Rabatttage dürfen nicht überschritten werden.',
        'installment_due_days_gt_error'               => 'Die Anzahl der Fälligkeitstage :index sollte größer sein als die Anzahl der Fälligkeitstage :preIndex Raten.',
        'installment_percent_total_error'             => 'Der Gesamtprozentsatz der Ratenzahlung ist nicht korrekt. Er sollte 100 % betragen.',
        'installment_percent_numeric_error'           => 'Der Gesamtbetrag der Ratenzahlung ist nicht korrekt. Es sollte ein numerischer Wert sein.',
        'term_discount'                               => 'Laufzeitrabatt',
        'installment_due_days_gt_zero_error'          => 'Die Anzahl der Fälligkeitstage :index der Raten sollte größer oder gleich Null sein.',
        'net_due_days_error'                          => 'Der Nettobetrag in Tagen sollte größer als Null sein und muss angegeben werden.',
        'discount_days_simple_error'                  => 'Die Rabatttage sollten einfach größer als Null sein und müssen angegeben werden.',
        'discount_days_nth_error'                     => 'Der Rabatt N-te Tag sollte größer als Null sein und muss angegeben werden.',
        'balance_due_days_error'                      => 'Der Restbetrag sollte in Tagen größer als Null sein und muss angegeben werden.',
        'status_error'                                => 'Aufgrund der in der Rechnung verwendeten Bezeichnung hat sich der Status leider nicht geändert.',
        'down_payment_type_invoice_description_error' => 'Ihr eingegebenes Rechnungsbeschreibungs-Token stimmt nicht mit Ihrer Anzahlung überein.',
        'down_payment_type_quote_description_error'   => 'Ihr eingegebenes Angebotsbeschreibungs-Token stimmt nicht mit Ihrer Anzahlung überein.',
    ],
    'quotes_delete_error'                             => 'Fehler beim Löschen von Zitaten',
    'for'                                             => 'Für',
    'production'                                      => 'Produktion',
    'access_token'                                    => 'Zugangstoken',
    'application_id'                                  => 'Anwendungs-ID',
    'location_id'                                     => 'Standort-ID',
    'fi_config_check'                                 => 'Voraussetzungen prüfen',
    'requirement'                                     => 'Erfordernis',
    'required'                                        => 'Erforderlich',
    'actual'                                          => 'Tatsächlich',
    'result'                                          => 'Ergebnis',
    'db_prefix_setup_alert'                           => 'Ihre FusionInvoice-Datenbank verwendet DB-Präfixe. Die Unterstützung für DB-Präfixe endete mit Version 2023-3.0. Um mit dem Upgrade auf diese und zukünftige Versionen fortzufahren, müssen Sie DB-Präfixe entfernen. Sie können dies tun, indem Sie alle Tabellen in Ihrer DB umbenennen und das Präfix entfernen und außerdem den Wert „prefix“ => „“ in Ihrer Datei database.php festlegen.',
    'open_tasks'                                      => 'Offene Aufgaben',
    'closed_tasks'                                    => 'Abgeschlossene Aufgaben',
    'select_status'                                   => 'Status auswählen',
    'net_amount_due_invoice'                          => 'Nettobetrag fällig in :days Tagen.',
    'days_add_in_current_date'                        => 'Das aktuelle Datum vom <span class="text-blue">:date</span>  und das Fälligkeitsdatum sind als <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">Anzahl der Tage</span> zu betrachten.',
    'terms'                                           => 'Bedingungen',
    'quote_rejecting_error'                           => 'Rechnung Nr. :invoice_number wurde am :invoice_date nach Genehmigung dieses Angebots erstellt. Sie müssen diese Rechnung löschen oder stornieren, bevor Sie dieses Angebot ablehnen.',
    'resend_record_warning'                           => 'Diese E-Mail jetzt erneut senden?',
    'resend_email'                                    => 'E-Mail zurücksenden',
    'requirement_check_fail'                          => 'Bevor die Installation fortgesetzt werden kann, müssen Sie die oben angezeigten Fehler beheben.',
    'failed'                                          => 'Fehlgeschlagen',
    'subscriptions'                                   => 'Abonnements',
    'tt_explanation'                                  => 'Geben Sie eine Beschreibung für den Service mit optionalen Datumsplatzhaltern ein. Sie können die folgenden Token verwenden, um Start- und Enddaten des Services dynamisch einzufügen:{{service_starts_on}} und {{service_ends_on}}. Diese werden beim Anzeigen des Inhalts durch die tatsächlichen Start- und Enddaten ersetzt.',
    'tt_ss_invoices_default_payment_terms'            => 'Standardzahlungsbedingungen für Rechnungen',
    'invoices_default_terms'                          => 'Standardbedingungen für Rechnungen',
    'net_amount_due_in_n_days'                        => 'Nettobetrag fällig in N Tagen',
    'last_day'                                        => 'Letzter Tag',
    'down_payment_payment_term1'                      => 'Anzahlung von',
    'down_payment_payment_term2'                      => 'erforderlich. Der Restbetrag ist fällig in',
    '1_type'                                          => 'Eine heute erstellte Rechnung ist in <span class="text-primary">#N</span> Tagen fällig',
    '2_type'                                          => 'Eine heute erstellte Rechnung gewährt einen Rabatt, wenn sie bis <span class="text-primary">#date</span> bezahlt wird,</span> andernfalls ist der volle Betrag innerhalb von <span class="text-primary">#N</span>  Tagen fällig',
    '3_type'                                          => 'Eine heute erstellte Rechnung gewährt einen Rabatt, wenn sie bis <span class="text-primary">#date</span>  bezahlt wird. Der Nettobetrag ist innerhalb von <span class="text-primary">#N</span>  Tagen fällig',
    '4_type'                                          => 'Eine heute erstellte Rechnung erfordert eine Anzahlung in Höhe von <span class="text-primary">#amount</span>  . Der Restbetrag ist innerhalb von <span class="text-primary">#N</span>  Tagen fällig',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Eine heute erstellte Rechnung, aufgeteilt auf <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Zahlung <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Fällig <span class="text-primary">#date</span></p>',
    'installment'                                     => 'Rate',
    'apply_payment_terms'                             => 'Zahlungsbedingungen Rabattbetrag anwenden',
    'payable_amount'                                  => 'Endgültiger zu zahlender Betrag',
    'payable_amount_lt_error'                         => 'Der endgültige Zahlbetrag sollte geringer sein als der Rechnungssaldo.',
    'payment_term_type_4_amount'                      => 'Teilzahlung von :amount akzeptiert',
    'net_terms'                                       => 'Nettokonditionen',
    'proforma_invoice_default'                        => 'Proforma-Rechnungsstandard',
    'expense_vendor'                                  => 'Spesenverkäufer',
    'expense_vendor_deleted'                          => 'Spesenlieferant wurde gelöscht',
    'expense_vendor_already_used'                     => 'Sie können einen Kreditor, der zugehörige Ausgabeneinträge hat, nicht löschen.',
    'total_must_be_gt_zero'                           => 'Die Summe von :modal_name muss größer als Null sein.',
    'payment_failed'                                  => 'Die Zahlung ist mit :error fehlgeschlagen',
    'xss_validation'                                  => 'Das Feld :attribute enthält Tags, die eine XSS-Schwachstelle aufdecken könnten',
    'support_desk'                                    => 'Kundendienst',
    'choose_file'                                     => 'Datei wählen',
    'supportTicket'                                   => 'Kundendienst',
    'create_support_ticket'                           => 'Support-Ticket erstellen',
    'supportTicket_inbox_view'                        => 'Kundendienst',
    'support_ticket'                                  => 'Unterstüzungsticket',
    'ticket_number'                                   => 'Ticketnummer',
    'revision'                                        => 'Revision',
    'revisions'                                       => 'Revisionen',
    'recurring_invoices'                              => 'Wiederkehrende Rechnungen',
    'message'                                         => 'Nachricht',
    'custom_img'                                      => 'Benutzerdefiniertes Bild',
    'please_fill_some_data'                           => 'Tragen Sie bitte die erforderlichen Daten zum neuen Artikel ein.',
    'assigned'                                        => 'Zugewiesen',
    'add_ons_will_be_disabled'                        => 'DIE FOLGENDEN ADD-ONS WERDEN DEAKTIVIERT:',
    'add_ons_will_be_disabled_msg'                    => 'Alle Add-ons werden während eines FusionInvoice-Core-Upgrades automatisch deaktiviert. Laden Sie nach Abschluss dieses Upgrades die entsprechenden Add-on-ZIP-Dateien herunter und installieren Sie sie. Anschließend können Sie sie über das Menü „Systemeinstellungen“, „Anpassungen“, „Add-ons“ und „[Installieren]“ wieder aktivieren.',
    'price_not_valid'                                 => 'Der Preis muss größer als Null sein',
    'free_space'                                      => 'Freiraum',
    'expense_type'                                    => 'Kostenart',
    'standard_expense'                                => 'Standardkosten',
    'expense_with_deductible_tax'                     => 'Ausgaben mit abzugsfähiger Steuer',
    'remittance_to_tax_authority'                     => 'Überweisung an die Steuerbehörde',
    'tax_paid'                                        => 'Steuer gezahlt',
    'tax_detail'                                      => 'Steuerdetails',
    'select_expense_type'                             => 'Kostenart auswählen',
    'taxes_paid_on_expenses_or_remitted'              => 'Auf Ausgaben gezahlte oder abgeführte Steuern',
    'tax_name'                                        => 'Steuerbezeichnung',
    'last_activity'                                   => 'Letzte Aktivität',
    'select_default_company_profile'                  => 'Bitte wählen Sie Ihr Standard-Firmenprofil',
    'mn_sales_tax'                                    => 'MN Umsatzsteuer',
    'taxes_collected_on_sales'                        => 'Auf Verkäufe erhobene Steuern',
    'vatgst_tax_note'                                 => 'Bei „Ja“ wird die Steuer als im Artikelgesamtbetrag enthalten berechnet. Bei „Nein“ wird die Steuer zum Artikelgesamtbetrag addiert.',
    'tt_vatgst_tax'                                   => 'Für dieses Beispiel gehen wir von einem Steuersatz von 5 % und einem Artikelpreis von 100 $ aus. Wenn Sie „Mehrwertsteuer/GST aktivieren“ auf „Ja“ setzen, ergibt sich ein Rechnungsbetrag von 100 $, wobei der Artikelbetrag auf 95,24 $ und der Steuerbetrag auf 4,76 $ angepasst wird. Wenn Sie „Mehrwertsteuer/GST“ auf „Nein“ setzen, ergibt sich ein Rechnungsbetrag von 105 $, mit einem Artikelpreis von 100 $ und einer Steuer von 5 $.',
    'level_of_detail'                                 => 'Detaillierungsgrad',
    'tax_report'                                      => 'Steuerbericht',
    'detail'                                          => 'Detail',
    'totals'                                          => 'Gesamt',
    'totals_with_dots'                                => 'Gesamtsummen . . .',
    'yes_all'                                         => 'Ja alle)',
    'invoices_only'                                   => 'Nur Rechnungen',
    'payment_receipts_only'                           => 'Nur Zahlungsbelege',
    'role'                                            => 'Rolle',
    'previous_email'                                  => 'Vorherige Email',
    'web_store_user_id'                               => 'Web Store-Benutzer-ID: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Nettobetrag fällig bis <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Bei Zahlung bis #DISCOUNTPERCENT kann ein Rabatt von <span class="text-info">#DISCOUNTDATE</span> ~ gewährt werden,</span> andernfalls ist der Nettobetrag bis <span class="text-info">#LASTDATE</span>  fällig.',
        '3_type'       => 'Bei Zahlung bis #DISCOUNTPERCENT kann ein Rabatt von <span class="text-info">#DISCOUNTDATE</span> ~ gewährt werden,</span> andernfalls ist der Nettobetrag bis <span class="text-info">#LASTDATE</span>  fällig.',
        '4_type'       => 'Eine Anzahlung in Höhe von <span class="text-info">#DOWNPAYMENT</span>  ist am #INVOICEDATE . Der Restbetrag ist bis <span class="text-info">#LASTDATE</span>  fällig.',
        '5_type'       => '<p class="mt-2 mb-1">Zahlungen können auf <span class="text-info">#NUMBEROFINSTALLMENTS</span> Raten aufgeteilt werden</p>',
        '5_1_type'     => '<li>Zahlung <span class="text-info">#PERCENT %</span> Fällig <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Der nächste Monat hat insgesamt #N Tage. Geben Sie daher bitte einen Wert zwischen 1 und #N für die Rabatttage des nächsten Monats ein.</span>',
    ],
    'payment_term_not_selected'                       => 'Zahlungsbedingung nicht ausgewählt',
    'confirm'                                         => 'Bestätigen',
    'create_live_invoice_now'                         => 'Jetzt Live-Rechnung erstellen?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Ein Abonnement ist wie eine Rechnungsvorlage, die zum Erstellen von Live-Rechnungen in einer bestimmten Häufigkeit verwendet wird.</p><p class="m-0"> Normalerweise wird ein CRON-Job oder eine geplante Aufgabe so eingerichtet, dass sie einmal pro Tag ausgeführt wird und dafür verantwortlich ist, anhand des Datumsfelds „Nächste Rechnung generieren“ des Abonnements nach Live-Rechnungen zu suchen, die erstellt werden sollen. Wenn dieser Datumswert heute oder früher als heute ist, wird automatisch eine Live-Rechnung erstellt.</p><p class="m-0"> Mit dieser Option können Sie die Live-Rechnung manuell aus dem Abonnement erstellen und die automatisierte Methode umgehen. Möchten Sie die Live-Rechnung jetzt erstellen?</p>',
    'contact'                                         => 'Kontakt',
    'invoice_month_plus_one'                          => 'Rechnungsmonat +1',
    'invoice_month_plus_two'                          => 'Rechnungsmonat +2',
    'invoice_month_plus_three'                        => 'Rechnungsmonat +3',
    'inbound_email'                                   => 'Eingehende E-Mail',
    'outbound_email'                                  => 'Ausgehende E-Mail',
    'email_signature'                                 => 'E-Mail Signatur',
    'mail_credential_error'                           => 'Ungültige E-Mail-Konfiguration. Bitte überprüfen Sie Ihre Einstellungen und versuchen Sie es erneut. <strong>( Konfiguration <i class="fa fa-arrow-alt-circle-right"> </i> Systemeinstellungen <i class="fa fa-arrow-alt-circle-right"> </i> E-Mail )</strong>',
    'tt_generate_next_invoice'                        => 'Das Datum, an dem die nächste Live-Rechnung automatisch aus diesem Abonnement erstellt wird.',
    'tt_stop_date'                                    => 'Der Datumsschwellenwert, nach dem für dieses Abonnement keine Live-Rechnungen mehr automatisch generiert werden. Lassen Sie dieses Feld leer, wenn das Abonnement unbegrenzt gültig sein soll.',
    'description_template'                            => 'Beschreibungsvorlage',
    't_1_description'                                 => 'Die vollständige Zahlung muss bis #LASTDATE erfolgen.',
    't_2_description'                                 => 'Erhalten Sie #DISCOUNTPERCENT % Rabatt, wenn Sie bis #DISCOUNTDATE, andernfalls zahlen Sie den vollen Rechnungsbetrag bis #LASTDATE.',
    't_3_description'                                 => 'Erhalten Sie #DISCOUNTPERCENT % Rabatt, wenn Sie bis #DISCOUNTDATE, andernfalls zahlen Sie den vollen Rechnungsbetrag bis #LASTDATE.',
    't_4_description'                                 => 'Eine Anzahlung in Höhe von #DOWNPAYMENT ist am #INVOICEDATE, der Restbetrag der Rechnung ist bis #LASTDATE fällig',
    't_4_1_description'                               => 'Eine Anzahlung in Höhe von #DOWNPAYMENTPERCENT ist am #INVOICEDATE, der Restbetrag der Rechnung ist bis #LASTDATE fällig',
    't_5_description'                                 => 'Die Zahlungen sind in #NUMBEROFINSTALLMENTS gleichen Raten zu leisten',
    't_5_type_description'                            => 'Die Zahlung #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT ist am #LASTDATE fällig',
    'tokens_allowed'                                  => 'Token erlaubt',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Der ausgewertete Text aus der Vorlage ist die Begriffsbeschreibung, die auf Dokumenten wie Rechnungen, Angeboten usw. angezeigt wird.',
    'cc_mail'                                         => 'CC-Mail',
    'assigned_inv_sent_or_paid'                       => '*Es gibt Rechnungen, die bezahlt oder gesendet wurden und denen diese Zahlungsfrist zugewiesen ist. Eine Änderung der Angaben zum „Typ“ ist nicht zulässig.',
    'exclude_paid_invoices'                           => 'Bezahlte Rechnungen ausschließen',
    'phone_number_numeric_error'                      => 'Die Telefonnummer muss eine Zahl sein.',
    'phone_num_same_country_code_error'               => 'Bitte stellen Sie sicher, dass Ihre Telefonnummer das richtige Format hat. Sie scheint mit der Landesvorwahl zu beginnen, was nicht zulässig ist.',
    'tt_expense_amount'                               => 'Geben Sie den Gesamtbetrag der Ausgabe einschließlich Steuern ein. Dieses Feld ist bei der Überweisung einer Steuerzahlung an eine Steuerbehörde nicht verfügbar.',
    'tt_expense_tax_paid_deductible'                  => 'Geben Sie den Steuerbetrag ein, der mit dieser Ausgabe gezahlt wurde. Dieser Betrag wird in den Berichten „Steuerübersicht“ und „Steuerdetails“ von Ihrer Gesamtsteuerschuld abgezogen.',
    'tt_expense_tax_paid_remittance'                  => 'Geben Sie den Steuerbetrag ein, der an die Steuerbehörde abgeführt wurde. Dies wird verwendet, um Zahlungen für Steuern aufzuzeichnen, die auf Ihre bezahlten Rechnungen erhoben wurden.',
    'tt_expense_client'                               => 'Wenn diese Ausgabe ausschließlich im Auftrag eines Kunden entstanden ist und Sie sie diesem in Rechnung stellen möchten, wählen Sie hier den entsprechenden Kunden aus.',
    'base_currency_not_deleted'                       => 'Basiswährung kann nicht gelöscht werden',
    'used_currency_modal_error'                       => 'Währung wird bereits im Modul :modal_names verwendet.',
    'addon_uninstall_success'                         => 'Addon erfolgreich deinstalliert',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revision (aktuell)',
    'number'                                          => 'Nummer',
    'copy_process_error'                              => 'Hoppla! Beim Kopiervorgang ist offenbar ein Problem aufgetreten. Bitte versuchen Sie es später noch einmal.',
    'tt_captcha_image'                                => 'CAPTCHA Bild',
    'reload_page'                                     => 'Bitte laden Sie die Seite neu',
    'discount_limit'                                  => 'Der Rabatt muss weniger als 99,99 % betragen.',
    'tooltip'                                         => 'Tooltip',
    'authorization_error'                             => 'Sie sind nicht berechtigt, diesen Vorgang durchzuführen.',
    'reset_to_default'                                => 'Zurücksetzen',
    'reset_to_default_warning'                        => '<p>Dadurch werden Betreff und Text auf den Standardwert für :model zurückgesetzt. Fortfahren?</p>',
    'reset_default_mail_template'                     => 'Die Standard-E-Mail-Vorlage für :model wurde erfolgreich zurückgesetzt.',
    'overdue_invoice'                                 => 'Überfällige Rechnung',
    'total_cannot_be_lt_zero'                         => 'Die Summe von :modal_name kann nicht kleiner als Null sein.',
    'addons_disabled_during_setup'                    => 'Während des Upgrade-Vorgangs wurden die folgenden Add-Ons deaktiviert: :addons . Vergessen Sie nicht, sie jetzt, da das Upgrade abgeschlossen ist, wieder zu aktivieren.',
    'allow_payments_on_quotes'                        => 'Zahlungen für Angebote zulassen J/N',
    'allow_payments_on_quote'                         => 'Zahlung zulassen J/N',
    'tt_ss_quotes_is_payable'                         => 'Wenn diese Option aktiviert ist, wird nach der Angebotsgenehmigung in der öffentlichen Linkansicht des Angebots die Schaltfläche „Jetzt bezahlen“ angezeigt. Es wird automatisch eine Rechnung erstellt und die Zahlung wird auf die Rechnung angerechnet.',
    'pay_with_square'                                 => 'Bezahlen mit Square',
    'validation_mess_for_is_payable_quote'            => 'Die Einstellung „Angebot nach Genehmigung durch den Kunden automatisch in Rechnung umwandeln“ ist erforderlich, wenn „Zahlungen für Angebote zulassen“ auf „Ja“ gesetzt ist.',
    'client_requirement_msg'                          => 'Bitte erstellen Sie einen Client, bevor Sie :seed_name hinzufügen.',
    'quote_add_items'                                 => 'Angebotspositionen erforderlich und Status nicht storniert',
    'invalid_quote_id'                                => 'Ungültige Angebots-ID',
    'information_header'                              => 'Herzlichen Glückwunsch, Sie sind dabei, Geld zu sparen!',
    'convenience_charge'                              => 'Servicegebühr',
    'credit_card_fee_message'                         => 'Für diese Transaktion fällt eine Kreditkarten-Bearbeitungsgebühr in Höhe von :charge an.',
    'info_payment_term_type_2'                        => 'Obwohl Ihr Rechnungssaldo :ORIGINAL_AMOUNT, haben Sie Anspruch auf einen Zahlungsrabatt von :DISCOUNT_PERCENT %, wodurch sich Ihr Zahlungsbetrag auf :DISCOUNT_AMOUNT reduziert.',
    'info_payment_term_type_3'                        => 'Obwohl Ihr Rechnungssaldo :ORIGINAL_AMOUNT, haben Sie Anspruch auf einen Zahlungsrabatt von :DISCOUNT_PERCENT %, wodurch sich Ihr Zahlungsbetrag auf :DISCOUNT_AMOUNT reduziert.',
    'info_payment_term_type_4'                        => 'Obwohl Ihr Rechnungssaldo :ORIGINAL_AMOUNT, haben Sie Anspruch auf Zahlungsbedingungen für die Zahlung einer Anzahlung in Höhe :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Obwohl Ihr Rechnungssaldo :ORIGINAL_AMOUNT, haben Sie Anspruch auf Zahlungsbedingungen für die Zahlung einer Ratenzahlung :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Zahlungsbedingungen müssen vor dem Löschen aus dem :modal entfernt werden.',
    'default_payment_term_warn'                       => '*Sie können für die <strong>Systemstandard-Zahlungsbedingungen</strong> nur den Namen und die Nettofälligkeitstage ändern.',
    'quote_rejected_not_payable'                      => 'Angebot Nr. :number wurde abgelehnt und ist aufgrund seines Status nicht zahlbar.',
    'could_not_delete'                                => 'Löschen nicht möglich',
    'convenience_charges_calculation_fail'            => 'Fehler: Die Berechnung der Bearbeitungsgebühren ist während der Migration fehlgeschlagen. Bitte versuchen Sie es später erneut.',
    'sign_in_welcome_message'                         => 'ðŸš€ Herzlichen Glückwunsch! Ihr FusionInvoice wurde erfolgreich installiert! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Ihr FusionInvoice wurde erfolgreich von Version :old_version auf Version :new_version aktualisiert.</p><p> Eine detaillierte Übersicht über alle neuen Funktionen und Verbesserungen finden Sie in unseren <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Versionshinweisen</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Vielen Dank, dass Sie sich für FusionInvoice entschieden haben. Ihr Vertrauen, Ihre Unterstützung und Ihr Feedback treiben unsere Innovation voran.</p><p class="m-0 text-bold">Viel Spaß beim Rechnungsstellen!</p><p class="text-bold">Das FusionInvoice-Team</p>',
    'tt_gen_skin_user_profile'                        => 'Durch das Ändern dieses Wertes wird der Systemstandard NUR für neue Benutzer festgelegt. Benutzer können diese Einstellung in ihren Benutzerprofileinstellungen überschreiben.',
    'description_template_invoice'                    => 'Beschreibung Vorlage - Rechnung',
    'description_template_quote'                      => 'Beschreibungsvorlage - Angebot',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Die vollständige Zahlung ist innerhalb von #NETDAYS nach dem Rechnungsdatum fällig.',
    't_2_description_for_quote'                       => 'Erhalten Sie #DISCOUNTPERCENT % Rabatt, wenn Sie innerhalb von #DISCOUNTDAYS, andernfalls zahlen Sie den vollen Angebotsbetrag bis #NETDAYS.',
    't_3_description_for_quote'                       => 'Erhalten Sie #DISCOUNTPERCENT % Rabatt, wenn Sie bis zum #NTHDAY des Folgemonats zahlen, andernfalls zahlen Sie den vollen Rechnungsbetrag innerhalb von #NETDAYS Tagen.',
    't_4_description_for_quote'                       => 'Eine Anzahlung von #DOWNPAYMENT ist am Rechnungsdatum fällig, der Restbetrag ist innerhalb von #NETDAYS Tagen fällig',
    't_4_1_description_for_quote'                     => 'Eine Anzahlung von #DOWNPAYMENTPERCENT ist am Rechnungsdatum fällig, der Restbetrag ist innerhalb von #NETDAYS Tagen fällig',
    't_5_description_for_quote'                       => 'Die Zahlungen sind in #NUMBEROFINSTALLMENTS gleichen Raten zu leisten',
    't_5_type_description_for_quote'                  => 'Die Zahlung #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT ist #INSTALLMENTDUEDAYS Tage nach dem Rechnungsdatum fällig',
    'default_term'                                    => 'Standardbegriff',
    'proceed_to_payment'                              => 'Weiter zur Zahlung',
    'version_upgraded'                                => 'Ihre Bewerbung ist aktuell.',
    'term_amount_gt_payment_amount'                   => 'Der Betrag muss größer sein als der Skontobetrag der Zahlungsbedingungen',
    'payment_term_not_eligible_warning'               => 'Der Skontoabzug ist nur bei vollständiger Zahlung möglich. Leider haben Sie hierfür keinen Anspruch.',
    'processed_by_user'                               => '<strong>Verarbeitet von:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Zahlungsmethode:</strong> :method',
    'all_methods'                                     => 'Alle Methoden',
    'this_payment'                                    => 'Diese Zahlung',
    'previous_balance'                                => 'Vorherige Balance',
    'payment_applied_with_remaining_balance'          => '<p><strong>Ihre Zahlung von :amount wurde teilweise angewendet. :remaining_balance bleibt offen.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Eine Vorauszahlung in Höhe von :amount wurde am :date für zukünftige Rechnungen erhalten.</strong></p>',
    'payment_full_applied'                            => '<p><strong>Ihre Zahlung :amount wurde vollständig angewendet.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Zahlung <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Details:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Die Zahlung von :paid wurde der Rechnung :invoice_number am :date</span> ~ zugewiesen.',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Die Zahlung von :paid, abzüglich :payment_terms_discount Zahlungszielrabatt wurde auf die Rechnung :invoice_number am :date</span> ~ angewendet.',
    'payment_full_applied_on_inv_with_cc'             => '<p>Die Zahlung von :paid, zuzüglich :convenience_charges Bearbeitungsgebühren wurde der Rechnung :invoice_number am :date</span> ~ zugewiesen.',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Die Zahlung von :paid, zuzüglich :convenience_charges Bearbeitungsgebühren und abzüglich :payment_terms_discount Zahlungszielrabatt wurde am :date</span> ~ auf die Rechnung :invoice_number angewendet.',
    'payment_remaining_balance_mail_message'          => '<p>Der Restbetrag der Rechnung :invoice_number beträgt :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Unbezahlte Rechnungen',
    'include'                                         => 'Enthalten',
    'exclude'                                         => 'Ausschließen',
    'invoice_with_no_tax'                             => 'Rechnungen ohne Steuern',
    'tax_total'                                       => 'Gesamtsteuer',
];

return TranslationOverride::override(__FILE__, $translations);
