<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Kontoopsætning',
    'active'                                          => 'Aktiv',
    'activity'                                        => 'Aktivitet',
    'activity_invoice_paid'                           => 'Invoice <a href=":link">#:number</a> was paid.',
    'activity_invoice_viewed'                         => 'Invoice <a href=":link">#:number</a> was viewed.',
    'activity_quote_approved'                         => 'Quote <a href=":link">#:number</a> was approved.',
    'activity_quote_rejected'                         => 'Quote <a href=":link">#:number</a> was rejected.',
    'activity_quote_viewed'                           => 'Quote <a href=":link">#:number</a> was viewed.',
    'add_item'                                        => 'Tilføj vare',
    'add_line_item_to_invoice'                        => 'Føj linjepost til fakturaen',
    'add_note'                                        => 'Tilføj note',
    'additional'                                      => 'Ekstra',
    'addon'                                           => 'Tilføjelse',
    'addons'                                          => 'Tilføjelser',
    'address'                                         => 'Adresse',
    'address_format'                                  => 'Adresseformat',
    'after_amount'                                    => 'Efter beløb',
    'all'                                             => 'Alle',
    'all_categories'                                  => 'alle kategorier',
    'all_statuses'                                    => 'Alle statusser',
    'all_time'                                        => 'Hele tiden',
    'all_vendors'                                     => 'Alle leverandører',
    'allow_login'                                     => 'Tillad login',
    'always_attach_pdf'                               => 'Vedhæft altid PDF',
    'always_bcc'                                      => 'Altid BCC-adresse',
    'always_cc'                                       => 'Altid CC-adresse',
    'amount'                                          => 'Beløb',
    'api_public_key'                                  => 'API offentlig nøgle',
    'api_secret_key'                                  => 'API-hemmelig nøgle',
    'approve'                                         => 'Godkende',
    'approved'                                        => 'godkendt',
    'approved_quotes'                                 => 'Godkendte tilbud',
    'attach_files'                                    => 'Vedhæft filer',
    'attach_pdf'                                      => 'Vedhæft PDF',
    'attachment'                                      => 'Vedhæftet fil',
    'attachments'                                     => 'Vedhæftede filer',
    'author'                                          => 'Forfatter',
    'automatic'                                       => 'Automatisk',
    'automatic_email_on_recur'                        => 'Automatisk e-mail tilbagevendende fakturaer',
    'automatic_email_payment_receipts'                => 'Automatisk e-mail-betalingskvitteringer',
    'available_fields'                                => 'Tilgængelige felter',
    'back'                                            => 'Tilbage',
    'back_to_invoice'                                 => 'Tilbage til faktura',
    'back_to_quote'                                   => 'Tilbage til tilbud',
    'balance'                                         => 'Balance',
    'base_currency'                                   => 'Basisvaluta',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Før beløb',
    'bill_this_expense'                               => 'Fakturer denne udgift',
    'bill_to'                                         => 'Regning til',
    'billable'                                        => 'Fakturerbar',
    'billed'                                          => 'Faktureret',
    'billing_address'                                 => 'Betalingsadresse',
    'billing_city'                                    => 'Billing City',
    'billing_name'                                    => 'Faktureringsnavn',
    'billing_state'                                   => 'Faktureringsstat',
    'billing_zip'                                     => 'Fakturerings zip',
    'binary_path'                                     => 'Binær sti',
    'body'                                            => 'Legeme',
    'cancel'                                          => 'Afbestille',
    'canceled'                                        => 'Annulleret',
    'card_number'                                     => 'Kortnummer',
    'cash'                                            => 'Kontanter',
    'category'                                        => 'Kategori',
    'cc'                                              => 'CC',
    'change'                                          => 'Lave om',
    'change_client'                                   => 'Skift klient',
    'check_for_update'                                => 'Søg efter opdatering',
    'city'                                            => 'By',
    'clear_keys'                                      => 'Ryd nøgler',
    'client'                                          => 'Klient',
    'client_form'                                     => 'Klientformular',
    'client_name'                                     => 'Kundenavn',
    'client_not_found'                                => 'Kunden blev ikke fundet',
    'client_statement'                                => 'Klienterklæring',
    'client_unique_name_option_1'                     => 'Kun når klientnavnet ikke er entydigt',
    'client_unique_name_option_2'                     => 'Vis altid',
    'client_visibility'                               => 'Kundesynlighed',
    'clients'                                         => 'Kunder',
    'code'                                            => 'Kode',
    'column_name'                                     => 'Kolonnenavn',
    'column_width'                                    => 'Kolonne bredde',
    'company'                                         => 'Selskab',
    'complete'                                        => 'Komplet',
    'complete_upgrade'                                => 'Komplet opgradering',
    'compound'                                        => 'Forbindelse',
    'compound_tax_note'                               => 'Sammensatte afgiftssatser skal anvendes på en vare som afgift 2 for at have den ønskede effekt.',
    'confirm_approve_quote'                           => 'Er du sikker på, at du vil godkende dette tilbud?',
    'confirm_reject_quote'                            => 'Er du sikker på, at du vil afvise dette tilbud?',
    'continue'                                        => 'Blive ved',
    'convert_quote_option1'                           => 'Fakturaen skal bevare vilkårene fra tilbudet',
    'convert_quote_option2'                           => 'Fakturaen skal bruge standardfakturaudtrykkene',
    'convert_quote_setting'                           => 'Når et tilbud konverteres til en faktura',
    'convert_quote_when_approved'                     => 'Konverter automatisk tilbud til faktura, når klienten godkender',
    'converted_from_quote'                            => 'Konverteret fra tilbud',
    'converted_to_invoice'                            => 'Konverteret til faktura',
    'country'                                         => 'Land',
    'create_invoice'                                  => 'Opret faktura',
    'create_quote'                                    => 'Opret tilbud',
    'created'                                         => 'Oprettet',
    'credit_card'                                     => 'Kreditkort',
    'currencies'                                      => 'Valutaer',
    'currency'                                        => 'betalingsmiddel',
    'currency_form'                                   => 'Valutaform',
    'currency_symbol'                                 => 'Valutasymbol',
    'currency_symbol_placement'                       => 'Placering af valutasymbol',
    'custom_date_range'                               => 'Brugerdefineret datointerval',
    'custom_field_form'                               => 'Brugerdefineret feltformular',
    'custom_fields'                                   => 'Brugerdefinerede felter',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Dashboard',
    'dashboard_totals_option'                         => 'Totaler på instrumentbrættet bør omfatte',
    'database_not_configured'                         => 'Det ser ud til, at app / config / database.php endnu ikke er konfigureret.',
    'database_setup'                                  => 'Databaseopsætning',
    'date'                                            => 'Dato',
    'date_format'                                     => 'Datoformat',
    'days'                                            => 'Dage',
    'decimal_point'                                   => 'Decimaltegnet',
    'default_currency'                                => 'Standardvaluta',
    'default_footer'                                  => 'Standard sidefod',
    'default_group'                                   => 'Standardgruppe',
    'default_invoice_email_body'                      => 'Standardfaktura-e-mail-brødtekst',
    'default_invoice_template'                        => 'Standardfakturaskabelon',
    'default_item_tax_2_rate'                         => 'Standard vareafgift 2-sats',
    'default_item_tax_rate'                           => 'Standardafgiftssats',
    'default_overdue_invoice_email_body'              => 'Standard forfalden e-mail-krop',
    'default_payment_receipt_body'                    => 'Standard betalingsmodtagelsesorgan',
    'default_quote_email_body'                        => 'Standard tilbud på e-mail-krop',
    'default_quote_template'                          => 'Standard tilbudskabelon',
    'default_terms'                                   => 'Standardbetingelser',
    'delete'                                          => 'Slet',
    'delete_client_warning'                           => '<p>HOLD OP! Hvis du sletter denne klient, sletter du også ALLE deres transaktionshistorik, inklusive fakturaer, tilbud og betalinger.</p><p>Er du sikker på, at du vil slette denne klient permanent?</p>',
    'delete_record_warning'                           => 'Er du sikker på, at du vil slette denne post?',
    'description'                                     => 'Beskrivelse',
    'details'                                         => 'detaljer',
    'disabled'                                        => 'handicappet',
    'discount'                                        => 'Rabat',
    'display_client_unique_name'                      => 'Vis unikt navn for klienten',
    'display_do_not_require'                          => 'Vis men kræv ikke',
    'display_order'                                   => 'Vis rækkefølge',
    'display_profile_image'                           => 'Vis profilbillede',
    'do_not_add_line_item_to_invoice'                 => 'Føj ikke linjepost til fakturaen',
    'do_not_display'                                  => 'Må ikke vises',
    'documentation'                                   => 'Dokumentation',
    'download'                                        => 'Hent',
    'draft'                                           => 'Udkast',
    'draft_invoices'                                  => 'Udkast til fakturaer',
    'draft_quotes'                                    => 'Udkast til tilbud',
    'dropdown'                                        => 'Dropdown',
    'due'                                             => 'På grund',
    'due_date'                                        => 'Afleveringsdato',
    'edit'                                            => 'Redigere',
    'edit_client'                                     => 'Rediger klient',
    'email'                                           => 'E-mail',
    'email_address'                                   => 'Email adresse',
    'email_invoice'                                   => 'E-mail-faktura',
    'email_payment_receipt'                           => 'Modtagelse af e-mail-betaling',
    'email_quote'                                     => 'E-mail-tilbud',
    'email_send_method'                               => 'Metode til afsendelse af e-mail',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Send mail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Aktiveret',
    'enter_payment'                                   => 'Indtast betaling',
    'error'                                           => 'Fejl',
    'every'                                           => 'Hver',
    'exchange_rate'                                   => 'Valutakurs',
    'exchange_rate_mode'                              => 'Valutakurstilstand',
    'expense_form'                                    => 'Udgiftsformular',
    'expenses'                                        => 'Udgifter',
    'expiration'                                      => 'Udløb',
    'expires'                                         => 'Udløber',
    'export_clients'                                  => 'Eksporter klienter',
    'export_data'                                     => 'Eksportér data',
    'export_expenses'                                 => 'Eksportudgifter',
    'export_invoice_items'                            => 'Eksport af fakturaposter',
    'export_invoices'                                 => 'Eksport fakturaer',
    'export_payments'                                 => 'Eksport betalinger',
    'export_quote_items'                              => 'Eksportér tilbud',
    'export_quotes'                                   => 'Eksport tilbud',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Fax nummer',
    'field_label'                                     => 'Feltetiket',
    'field_meta'                                      => 'Feltmeta',
    'field_meta_description'                          => 'Brug kun feltmetafeltet, hvis felttypen er en rullemenu. For at specificere dropdown-værdier skal du indtaste en liste over dropdown-værdier adskilt med kommaer.',
    'field_type'                                      => 'Felttype',
    'footer'                                          => 'Sidefod',
    'format'                                          => 'Format',
    'frequency'                                       => 'Frekvens',
    'from'                                            => 'Fra',
    'from_date'                                       => 'Fra dato',
    'general'                                         => 'Generel',
    'generate_keys'                                   => 'Generer nøgler',
    'group'                                           => 'Gruppe',
    'group_form'                                      => 'Gruppeformular',
    'groups'                                          => 'Grupper',
    'header_title_text'                               => 'Overskrift Titel Tekst',
    'help'                                            => 'Hjælp',
    'help_currency_code'                              => 'Valutakoden, f.eks.',
    'help_currency_name'                              => 'Valutanavnet, f.eks.',
    'help_currency_symbol'                            => 'Valutasymbolet, f.eks.',
    'help_currency_symbol_placement'                  => 'Hvor placeres valutasymbolet.',
    'help_text_client_name'                           => 'Denne værdi kan være navnet på en virksomhed eller en person og vises på tilbud og fakturaer. Denne værdi behøver ikke at være unik.',
    'help_text_client_password'                       => 'Lad dette felt være tomt, medmindre du opretter eller nulstiller en adgangskode.',
    'help_text_client_unique_name'                    => 'Når en eller flere klienter i systemet deler det samme navn, skal der gives et unikt navn for at skelne mellem dem. Denne værdi vises ikke på tilbud eller fakturaer.',
    'i_accept'                                        => 'Jeg accepterer',
    'import_data'                                     => 'Importer data',
    'inactive'                                        => 'Inaktiv',
    'income'                                          => 'Indkomst',
    'install'                                         => 'Installere',
    'installation_complete'                           => 'Installation afsluttet',
    'installing_please_wait'                          => 'Installerer, vent venligst ...',
    'invalid_credentials'                             => 'Ugyldige legitimationsoplysninger',
    'invoice'                                         => 'Faktura',
    'invoice_default'                                 => 'Faktura standard',
    'invoice_email_subject'                           => 'Faktura-e-mail-emne',
    'invoice_items'                                   => 'Fakturaposter',
    'invoice_number'                                  => 'Faktura nummer',
    'invoice_summary'                                 => 'Fakturaoversigt',
    'invoiced'                                        => 'Faktureret',
    'invoices'                                        => 'Fakturaer',
    'invoices_due_after'                              => 'Fakturaer forfaldne efter (dage)',
    'issued'                                          => 'Udstedt',
    'item'                                            => 'Vare',
    'item_lookup_form'                                => 'Objektopslagsformular',
    'item_lookups'                                    => 'Item Lookups',
    'item_sales'                                      => 'Varesalg',
    'items'                                           => 'Varer',
    'label_invoice'                                   => 'Vælg den faktura, du vil føje denne udgift til',
    'label_item_description'                          => 'Angiv en beskrivelse af denne udgift (valgfrit)',
    'label_item_name'                                 => 'Indtast navnet på linjeposten, der skal føjes til fakturaen',
    'landscape'                                       => 'Landskab',
    'language'                                        => 'Sprog',
    'left_pad'                                        => 'Venstre pad',
    'left_pad_description'                            => 'Antallet af nuller til valgfrit venstre pad det næste nummer med.',
    'legal'                                           => 'gyldige',
    'letter'                                          => 'Brev',
    'license_agreement'                               => 'Licensaftale',
    'license_agreement_accept'                        => 'Jeg accepterer betingelserne i licensaftalen',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Det ser ud til, at din hemmelige nøgle er blevet ændret siden sidste gang du gemte din e-mail-adgangskode. For at rette denne fejl skal du gå til Systemindstillinger -',
    'manual'                                          => 'brugervejledning',
    'map_fields_to_import'                            => 'Kortlæg felter, der skal importeres',
    'merchant_api_key'                                => 'API-nøgle',
    'merchant_api_password'                           => 'API-adgangskode',
    'merchant_api_username'                           => 'API-brugernavn',
    'merchant_publishable_key'                        => 'Publicerbar nøgle',
    'merchant_secret_key'                             => 'Hemmelig nøgle',
    'merchant_signature'                              => 'Underskrift',
    'mobile'                                          => 'Mobil',
    'mobile_number'                                   => 'Mobilnummer',
    'monthly'                                         => 'Månedlige',
    'months'                                          => 'Måneder',
    'multiple_email_validation'                       => 'Flere e-mail-adresser skal være gyldige og adskilt med kommaer.',
    'name'                                            => 'Navn',
    'net_income'                                      => 'Nettoindkomst',
    'never'                                           => 'Aldrig',
    'new'                                             => 'Ny',
    'next_date'                                       => 'Næste dato',
    'next_number'                                     => 'Næste nummer',
    'no'                                              => 'Ingen',
    'no_open_invoices'                                => 'Denne klient har ingen åbne fakturaer. For at fakturere en udgift skal klienten have mindst en faktura, der ikke er betalt fuldt ud.',
    'no_records_found'                                => 'Ingen optegnelser fundet.',
    'none'                                            => 'Ingen',
    'not_billable'                                    => 'Ikke fakturerbar',
    'not_billed'                                      => 'Ikke faktureret',
    'not_viewed'                                      => 'Ikke set',
    'not_visible'                                     => 'Ikke synlig',
    'note'                                            => 'Bemærk',
    'note_notification'                               => 'Meddelelse: Ny note',
    'notes'                                           => 'Bemærkninger',
    'online_payment'                                  => 'Online betaling',
    'online_payment_method'                           => 'Online betalingsmetode',
    'online_payments'                                 => 'Online betalinger',
    'options'                                         => 'Muligheder',
    'other'                                           => 'Andet',
    'output_type'                                     => 'Udgangstype',
    'overdue'                                         => 'Forsinket',
    'overdue_email_subject'                           => 'Forsinket e-mail-emne',
    'overdue_invoice_reminder'                        => 'Påmindelse om forfalden faktura',
    'overdue_invoice_reminder_frequency'              => 'Forsinket påmindelsesfrekvens for faktura',
    'overdue_invoice_reminder_frequency_help'         => 'En kommasepareret liste over dage EFTER en faktura skal sende påmindelsen. Lad det være tomt for at deaktivere forfaldne fakturapåmindelser. For eksempel vil en værdi på 1,5,10 sende påmindelser 1, 5 og 10 dage efter fakturaen forfalder.',
    'overdue_invoices'                                => 'Forfaldne fakturaer',
    'paid'                                            => 'Betalt',
    'paper_orientation'                               => 'Papirretning',
    'paper_size'                                      => 'Papirstørrelse',
    'password'                                        => 'Adgangskode',
    'password_confirmation'                           => 'Kodeords bekræftelse',
    'password_successfully_reset'                     => 'Adgangskoden er nulstillet',
    'pay'                                             => 'Betale',
    'pay_now'                                         => 'Betal nu',
    'payment_applied'                                 => 'Din betaling er blevet anvendt',
    'payment_button_text'                             => 'Tekst til betalingsknap',
    'payment_date'                                    => 'Betalingsdato',
    'payment_form'                                    => 'Betalingsformular',
    'payment_method'                                  => 'Betalingsmetode',
    'payment_method_form'                             => 'Betalingsformular',
    'payment_methods'                                 => 'betalingsmetoder',
    'payment_receipt'                                 => 'Betalingskvittering',
    'payment_receipt_email_subject'                   => 'Betalingskvittering E-mail-emne',
    'payments'                                        => 'Betalinger',
    'payments_collected'                              => 'Betalinger indsamlet',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF-driver',
    'pdf_driver_wkhtmltopdf'                          => 'Feltet Binær sti skal indeholde en gyldig filsti, når du bruger wkhtmltopdf PDF-driveren.',
    'percent'                                         => 'Procent',
    'phone'                                           => 'telefon',
    'phone_number'                                    => 'Telefonnummer',
    'php_version_error'                               => 'PHP opfylder ikke versionskravet (% s)',
    'placeholder_type_message'                        => 'Skriv besked ...',
    'portrait'                                        => 'Portræt',
    'postal_code'                                     => 'postnummer',
    'prefix'                                          => 'Præfiks',
    'prerequisites'                                   => 'Forudsætninger',
    'preview'                                         => 'Eksempel',
    'price'                                           => 'Pris',
    'private'                                         => 'Privat',
    'problem_with_email_template'                     => 'Der ser ud til at være et problem med e-mail-skabelonen. Kontroller skabelonerne i Systemindstillinger på fanen E-mail.',
    'product'                                         => 'Produkt',
    'profit_and_loss'                                 => 'Fortjeneste og tab',
    'public'                                          => 'Offentlig',
    'qty'                                             => 'Antal',
    'quantity'                                        => 'Antal',
    'quantity_price_decimals'                         => 'Antal decimaler for mængder og beløb',
    'quote'                                           => 'Citere',
    'quote_approved'                                  => 'Citat godkendt',
    'quote_approved_email_body'                       => 'Citat godkendt e-mail-organ',
    'quote_default'                                   => 'Citat Standard',
    'quote_email_subject'                             => 'Citat E-mail-emne',
    'quote_items'                                     => 'Citat Varer',
    'quote_number'                                    => 'Tilbudsnummer',
    'quote_rejected'                                  => 'Citat afvist',
    'quote_rejected_email_body'                       => 'Citat Afvist e-mail-organ',
    'quote_status_change_notification'                => 'Meddelelse: Tilbudsstatusændring',
    'quote_summary'                                   => 'Citatoversigt',
    'quote_to_invoice'                                => 'Citat til faktura',
    'quotes'                                          => 'Citater',
    'quotes_expire_after'                             => 'Citater udløber efter (dage)',
    'recalculate'                                     => 'Genberegn',
    'recalculate_help_text'                           => 'Det kan tage et øjeblik at gennemføre genberegningen. En meddelelse vises, når processen er afsluttet.',
    'recalculate_invoices'                            => 'Genberegn fakturaer',
    'recalculate_quotes'                              => 'Genberegn tilbud',
    'recalculating_wait'                              => 'Genberegner, vent venligst ...',
    'recalculation_complete'                          => 'Genberegning afsluttet',
    'recent_invoices'                                 => 'Seneste fakturaer',
    'recent_payments'                                 => 'Seneste betalinger',
    'recent_quotes'                                   => 'Seneste tilbud',
    'record_not_found'                                => 'Posten blev ikke fundet',
    'record_successfully_created'                     => 'Optagelsen blev oprettet',
    'record_successfully_deleted'                     => 'Optagelsen blev slettet',
    'record_successfully_updated'                     => 'Optagelsen er opdateret',
    'records_imported_successfully'                   => 'Records importeret med succes',
    'recurring'                                       => 'Tilbagevendende',
    'reject'                                          => 'Afvise',
    'rejected'                                        => 'Afvist',
    'rejected_quotes'                                 => 'Afviste citater',
    'remember_me'                                     => 'Husk mig',
    'remove_logo'                                     => 'Fjern logo',
    'report_rev_client_notice'                        => 'Denne rapport vil være tilgængelig, når du har foretaget nogle betalinger i systemet.',
    'reports'                                         => 'Rapporter',
    'require'                                         => 'Kræve',
    'reset_number'                                    => 'Nulstil nummer',
    'reset_password'                                  => 'Nulstille kodeord',
    'results_per_page'                                => 'Resultater pr. Side',
    'revenue_by_client'                               => 'Indtægter fra klient',
    'round_tax_decimals'                              => 'Antal decimaler for skatterunding',
    'run_report'                                      => 'Kør rapport',
    'save'                                            => 'Gemme',
    'save_and_apply_exchange_rate'                    => 'Gem og anvend valutakurs',
    'save_item_as_lookup'                             => 'Gem elementet som opslag',
    'search'                                          => 'Søg',
    'select_file_to_import'                           => 'Vælg den fil, der skal importeres',
    'send'                                            => 'Sende',
    'sending'                                         => 'Afsendelse',
    'sendmail_path'                                   => 'Sendmail-sti',
    'sent'                                            => 'Sendt',
    'sent_invoices'                                   => 'Sendte fakturaer',
    'sent_quotes'                                     => 'Sendte / afventende tilbud',
    'settings'                                        => 'Indstillinger',
    'settings_successfully_saved'                     => 'Indstillingerne blev gemt',
    'setup'                                           => 'Opsætning',
    'sign_in'                                         => 'Log ind',
    'sign_out'                                        => 'Log ud',
    'skin'                                            => 'Hud',
    'smtp_encryption'                                 => 'SMTP-kryptering',
    'smtp_host_address'                               => 'SMTP-værtsadresse',
    'smtp_host_port'                                  => 'SMTP-værtsport',
    'smtp_password'                                   => 'SMTP-adgangskode',
    'smtp_username'                                   => 'SMTP-brugernavn',
    'start_date'                                      => 'Start dato',
    'state'                                           => 'Stat',
    'status'                                          => 'Status',
    'step_database_setup'                             => 'Dette trin installerer og opgraderer dine databasetabeller. Dette trin kan tage et øjeblik at gennemføre.',
    'step_prerequisites'                              => 'Følgende forudsætninger skal løses, før installationen kan fortsætte:',
    'subject'                                         => 'Emne',
    'submit'                                          => 'Indsend',
    'subtotal'                                        => 'Subtotal',
    'summary'                                         => 'Resumé',
    'symbol'                                          => 'Symbol',
    'symbol_placement'                                => 'Symbolplacering',
    'system'                                          => 'System',
    'system_settings'                                 => 'Systemindstillinger',
    'table_name'                                      => 'Tabelnavn',
    'tax'                                             => 'Skat',
    'tax_1'                                           => 'Skat 1',
    'tax_2'                                           => 'Skat 2',
    'tax_rate'                                        => 'Skatteprocent',
    'tax_rate_form'                                   => 'Skattesatsformular',
    'tax_rate_name'                                   => 'Skattesats navn',
    'tax_rate_percent'                                => 'Skattesats Procent',
    'tax_rates'                                       => 'Skattesatser',
    'tax_summary'                                     => 'Skatteoversigt',
    'taxable_amount'                                  => 'Skattepligtigt beløb',
    'taxes'                                           => 'Skatter',
    'template'                                        => 'Skabelon',
    'terms_and_conditions'                            => 'Vilkår og betingelser',
    'test_mode'                                       => 'Test mode',
    'text'                                            => 'Tekst',
    'textarea'                                        => 'Textarea',
    'this_quarter'                                    => 'Dette kvartal',
    'thousands_separator'                             => 'Tusinder separator',
    'timezone'                                        => 'Tidszone',
    'to'                                              => 'Til',
    'to_date'                                         => 'Til dato',
    'total'                                           => 'Total',
    'total_balance'                                   => 'Samlet saldo',
    'total_invoiced'                                  => 'I alt faktureret',
    'total_expenses'                                  => 'Samlede udgifter',
    'total_paid_invoices'                             => 'Samlede betalte fakturaer',
    'try_again'                                       => 'Prøv igen',
    'uninstall'                                       => 'Afinstaller',
    'uninstall_addon_warning'                         => 'Er du sikker på, at du vil deaktivere denne tilføjelse?',
    'unique_name'                                     => 'Unikt navn',
    'unknown_error'                                   => 'Ukendt fejl',
    'upcoming_payment_notice_email_body'              => 'Kommende betalingsmeddelelse E-mail-organ',
    'upcoming_payment_notice_email_subject'           => 'Kommende betalingsmeddelelse E-mail-emne',
    'upcoming_payment_notice_frequency'               => 'Kommende betalingsmeddelelsesfrekvens',
    'upcoming_payment_notice_frequency_help'          => 'En komma-adskilt liste over dage FØR en faktura skal sende påmindelsen. Lad det være tomt for at deaktivere kommende betalingsmeddelelser. For eksempel vil en værdi på 1,5 sende meddelelser 1 og 5 dage før fakturaen forfalder.',
    'update_available'                                => 'FusionInvoice :version kan downloades!',
    'update_exchange_rate'                            => 'Opdater valutakurs',
    'update_not_available'                            => 'Der er i øjeblikket ingen opdateringer tilgængelige.',
    'upload_progress'                                 => 'Upload fremskridt',
    'user'                                            => 'Bruger',
    'user_accounts'                                   => 'Brugerkonti',
    'user_form'                                       => 'Brugerformular',
    'users'                                           => 'Brugere',
    'validation_invoice_summary_from_date'            => 'Fra-datoen på fakturaoversigten Dashboard-widget kræves, når datointervallet er indstillet til brugerdefineret datointerval.',
    'validation_invoice_summary_to_date'              => 'Datoen til fakturaoversigten Dashboard-widget kræves, når du bruger et brugerdefineret datointerval.',
    'validation_quote_summary_from_date'              => 'Fra-datoen i Tilbudsoversigt Dashboard-widget kræves, når du bruger et brugerdefineret datointerval.',
    'validation_quote_summary_to_date'                => 'Til dato på Tilbudsoversigt Dashboard-widget kræves, når du bruger et brugerdefineret datointerval.',
    'vendor'                                          => 'Sælger',
    'version'                                         => 'Version',
    'view'                                            => 'Udsigt',
    'view_all'                                        => 'Se alt',
    'view_all_invoices_for_client'                    => 'Se alle fakturaer for denne klient',
    'view_all_payments_for_client'                    => 'Se alle betalinger for denne klient',
    'view_all_quotes_for_client'                      => 'Se alle tilbud for denne klient',
    'view_approved_quotes'                            => 'Se godkendte tilbud',
    'view_client'                                     => 'Se klient',
    'view_draft_invoices'                             => 'Se kladdefakturaer',
    'view_draft_quotes'                               => 'Se tilbud på tilbud',
    'view_overdue_invoices'                           => 'Se forfaldne fakturaer',
    'view_payments'                                   => 'Se betalinger',
    'view_rejected_quotes'                            => 'Se afviste tilbud',
    'view_sent_invoices'                              => 'Se sendte fakturaer',
    'view_sent_quotes'                                => 'Se sendte tilbud',
    'view_unique_name'                                => 'Se unikt navn',
    'viewed'                                          => 'har set',
    'visible'                                         => 'Synlig',
    'visible_after_payment'                           => 'Synlig efter betaling',
    'web'                                             => 'Web',
    'web_address'                                     => 'Web adresse',
    'weekly'                                          => 'Ugentlig',
    'weeks'                                           => 'Uger',
    'welcome'                                         => 'Velkommen',
    'what_to_import'                                  => 'Hvad vil du importere?',
    'year'                                            => 'År',
    'yearly'                                          => 'Årligt',
    'years'                                           => 'Flere år',
    'yes'                                             => 'Ja',
    'you_may_now_sign_in'                             => 'Du kan nu logge ind!',

    // 2017-1
    'all_company_profiles'                            => 'Alle virksomhedsprofiler',
    'cannot_delete_record_in_use'                     => 'Denne post er i brug og kan ikke slettes.',
    'cannot_edit_record_in_use'                       => 'Denne post er i brug og kan ikke redigeres.',
    'change_company_profile'                          => 'Skift virksomhedsprofil',
    'company_profile'                                 => 'Firmaprofil',
    'company_profiles'                                => 'Virksomhedsprofiler',
    'company_profile_form'                            => 'Virksomhedsprofilformular',
    'copy'                                            => 'Kopi',
    'create_recurring_invoice'                        => 'Opret tilbagevendende faktura',
    'custom'                                          => 'Brugerdefinerede',
    'date_range'                                      => 'Datointerval',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mo',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'Vi',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Standardvirksomhedsprofil',
    'first_quarter'                                   => 'Første kvartal',
    'fourth_quarter'                                  => 'Fjerde kvartal',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Sidste 7 dage',
    'last_30_days'                                    => 'Sidste 30 dage',
    'last_month'                                      => 'Sidste måned',
    'last_quarter'                                    => 'Sidste kvarter',
    'last_year'                                       => 'Sidste år',
    'month_january'                                   => 'januar',
    'month_february'                                  => 'februar',
    'month_march'                                     => 'marts',
    'month_april'                                     => 'April',
    'month_may'                                       => 'Kan',
    'month_june'                                      => 'juni',
    'month_july'                                      => 'juli',
    'month_august'                                    => 'august',
    'month_september'                                 => 'september',
    'month_october'                                   => 'oktober',
    'month_november'                                  => 'november',
    'month_december'                                  => 'december',
    'recurring_invoice'                               => 'Tilbagevendende faktura',
    'second_quarter'                                  => 'Andet kvartal',
    'stop_date'                                       => 'Stop dato',
    'third_quarter'                                   => 'Tredje kvartal',
    'this_month'                                      => 'Denne måned',
    'this_year'                                       => 'Dette år',
    'today'                                           => 'I dag',
    'user_account'                                    => 'Brugerkonto',
    'yesterday'                                       => 'I går',

    // 2017-3
    'mail_log'                                        => 'Maillog',
    'recent_client_activity'                          => 'Seneste klientaktivitet',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Ekskluder ubetalte fakturaer',

    // 2017-7
    'please_wait'                                     => 'Vent venligst...',
    'reply_to_address'                                => 'Svar på adresse',

    // 2017-8
    'admin'                                           => 'Administrator',
    'admin_account'                                   => 'Administratorkonto',
    'admin_accounts'                                  => 'Administratorkonti',
    'all_accounts'                                    => 'Alle konti',
    'api_key'                                         => 'API-nøgle',
    'client_account'                                  => 'Kundekonto',
    'client_accounts'                                 => 'Klientkonti',
    'client_id'                                       => 'Klient-id',
    'client_secret'                                   => 'Klienthemmelighed',
    'enable_bitcoin_payments'                         => 'Aktivér Bitcoin-betalinger',
    'live'                                            => 'Direkte',
    'mode'                                            => 'Mode',
    'publishable_key'                                 => 'Publicerbar nøgle',
    'sandbox'                                         => 'Sandkasse',
    'secret_key'                                      => 'Hemmelig nøgle',
    'type'                                            => 'Type',

    // 2017-10
    'deselect_all'                                    => 'Fravælg alle',
    'select_all'                                      => 'Vælg alle',
    'use_24_hour_time_format'                         => 'Brug 24-timers format',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Er du sikker på, at du vil slette disse poster?',
    'bulk_invoice_change_status_warning'              => 'Er du sikker på, at du vil ændre status for de valgte fakturaer?',
    'bulk_quote_change_status_warning'                => 'Er du sikker på, at du vil ændre status for de valgte tilbud?',
    'calculate_as_vat_gst'                            => 'Beregn som moms / GST',
    'change_status'                                   => 'Skift status',
    'default_status_filter'                           => 'Standardstatusfilter',
    'error_applying_payment'                          => 'Der opstod en fejl under anvendelsen af denne betaling. Prøv et andet kort eller en anden betalingsmetode.',
    'remaining'                                       => 'Resterende',

    // 2017-12
    'invoice_date'                                    => 'Fakturadato',
    'include_profit_based_on'                         => 'Inkluder overskud baseret på',

    // 2018-1
    'add_contact'                                     => 'Tilføj kontakt',
    'allow_self_signed_cert'                          => 'Tillad selvunderskrevet certifikat',
    'backup'                                          => 'Backup',
    'close'                                           => 'Tæt',
    'change_invoice_date_to_todays_date'              => 'Skift fakturadato til dagens dato',
    'change_quote_date_to_todays_date'                => 'Skift citatdato til dagens dato',
    'contacts'                                        => 'Kontakter',
    'default_bcc'                                     => 'Standard BCC',
    'default_cc'                                      => 'Standard CC',
    'default_to'                                      => 'Standard til',
    'disable'                                         => 'Deaktiver',
    'download_database_backup'                        => 'Download sikkerhedskopi af database',
    'edit_contact'                                    => 'Rediger kontakt',
    'expense_list'                                    => 'Udgiftsliste',
    'keep_invoice_date_as_is'                         => 'Opbevar fakturadato, som den er',
    'keep_quote_date_as_is'                           => 'Opbevar tilbudsdato, som den er',
    'if_quote_is_emailed_while_draft'                 => 'Hvis citatet sendes via e-mail, mens det er i kladdestatus',

    // 2018-4
    'force_https'                                     => 'Tving HTTPS',
    'force_https_help'                                => 'Inden du aktiverer denne mulighed, skal du sikre dig, at din FusionInvoice-installation fungerer via https. Hvis dette ikke gøres, kan det resultere i en ikke-funktionel (men fixerbar) installation.',

    // 2019-1
    'attached_to'                                     => 'Fastgjort til',
    'customer'                                        => 'Kunde',
    'expense'                                         => 'Bekostning',
    'expense_categories'                              => 'Udgiftskategorier',
    'expense_category_form'                           => 'Formular for udgiftskategori',
    'expense_vendors'                                 => 'Omkostningsleverandører',
    'expense_vendor_form'                             => 'Udgiftsleverandørformular',
    'lead'                                            => 'At føre',
    'local_time'                                      => 'Lokal tid',
    'prospect'                                        => 'Udsigt',
    'search_clients'                                  => 'Søg efter klienter',
    'search_expenses'                                 => 'Søgeudgifter',
    'search_invoices'                                 => 'Søg i fakturaer',
    'search_items'                                    => 'Søg efter emner',
    'search_log'                                      => 'Søgningslog',
    'search_quotes'                                   => 'Søg citater',
    'search_payments'                                 => 'Søg betalinger',
    'search_recurring_invoices'                       => 'Søg efter tilbagevendende fakturaer',
    'show_all_statuses'                               => 'Vis alle statusser',
    'show_all_types'                                  => 'Vis alle typer',
    'unknown'                                         => 'Ukendt',
    'value'                                           => 'Værdi',

    // 2019-2
    'default'                                         => 'Standard',
    'no_data_available'                               => 'Ingen tilgængelig data',
    'recurring_invoice_list'                          => 'Tilbagevendende fakturaliste',
    'report_total'                                    => 'Rapporter totaler',

    //2019-3
    'checkbox'                                        => 'Afkrydsningsfelt',
    'custom_dropdown_validate'                        => 'Vælg en gyldig mulighed fra feltet :label',
    'custom_image_validate'                           => 'Vælg et gyldigt billede.',
    'custom_tag_validate'                             => 'Vælg et gyldigt tag fra :label',
    'custom_text_validate'                            => 'Indtast en gyldig :label i feltet :label.',
    'datetime'                                        => 'Dato tid',
    'decimal'                                         => 'Decimal',
    'delete-confirm'                                  => 'Er du sikker?',
    'grand_total'                                     => 'Grand Total',
    'image'                                           => 'Billede',
    'integer'                                         => 'Heltal',
    'mailed'                                          => 'Mailet',
    'mailed_invoices'                                 => 'Mails fakturaer',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'Tilbagevendende ID',
    'remove_image'                                    => 'Fjern billede',
    'tags'                                            => 'Mærker',
    'tagselection'                                    => 'Valg af tag',
    'unpaid'                                          => 'Ubetalt',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Se mailede fakturaer',
    'important'                                       => 'Vigtig!',
    'created_recurring_invoice_id'                    => 'Oprettet fra tilbagevendende faktura-id',
    'mr'                                              => 'Hr.',
    'miss'                                            => 'Gå glip af',
    'ms'                                              => 'Frk.',
    'mrs'                                             => 'Fru.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Kontakt titel',
    'title'                                           => 'Titel',
    'test_email_subject'                              => 'Hej fra FusionInvoice',
    'test_email_body'                                 => 'Dette er en test-e-mail fra FusionInvoice.',
    'test_email_address'                              => 'Send e-mail-test til',
    'send_test_email'                                 => 'Send test-e-mail',
    'invalid_json'                                    => 'Indtast en gyldig JSON-streng',
    'textarea_rows_limit'                             => 'Rækker må ikke overstige :limit',
    'custom_integer_validate'                         => ':label skal være en gyldig heltal',

    //2020-1
    'user_role'                                       => 'Brugerrolle',
    'standard_user'                                   => 'Standardbruger',
    'permissions'                                     => 'Tilladelser',
    'modules'                                         => 'Moduler',
    'is_view'                                         => 'Udsigt',
    'is_create'                                       => 'skab',
    'is_update'                                       => 'Opdatering',
    'is_delete'                                       => 'Slet',
    'dashboards'                                      => 'Dashboards',
    'allow_time_period_change'                        => 'Tillad ændring af tidsperiode',
    'page_not_found'                                  => 'Ups! Siden blev ikke fundet.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href=":dashboard_link">Tilbage til instrumentbræt</a>.',
    'no_auth_to_create_client'                        => 'Du er ikke autoriseret til at oprette kunder!',
    'check-all'                                       => 'Tjek alle',
    'invoice_prefix'                                  => 'Faktura-præfiks',
    'recently_viewed'                                 => 'Senest set',
    'copy_from'                                       => 'Kopier fra',
    'select_user'                                     => 'Vælg bruger',
    'please_select_user'                              => 'Vælg en bruger fra listen',
    'allow_client_center_login'                       => 'Tillad login til klientcenter',
    'online_payment_processing_fee'                   => 'Gebyr for behandling af online betaling',
    'client_password_required'                        => 'Indtast klientadgangskode',
    'last_login_at'                                   => 'Sidste login kl',
    'show_notes_panel_below_client'                   => 'Vis Notes-panelet under klientoplysninger',
    'notepad'                                         => 'Notesblok',
    'added'                                           => 'Tilføjet',
    'last_edited'                                     => 'Sidst redigeret',
    'loading'                                         => 'Behandler ....',
    'n_records_match'                                 => ':label Optag :plural-kamp',
    'initials'                                        => 'Initialer',
    'initials_bg_color'                               => 'Initialer Baggrundsfarve',
    'more'                                            => 'Mere',
    'must_match_all'                                  => 'Skal matche alle',
    'clear'                                           => 'Klar',
    'no_client_tags'                                  => 'Der er ingen klientoptegnelser med tags defineret.',
    'qr_code_on_invoice_quote'                        => 'QR-kode på faktura og tilbud',
    'delete_tags'                                     => 'Oprydning af tag',
    'orphan_tags_deleted'                             => 'Slettede alle de forældreløse tags fra systemet.',
    'orphan_tags_delete_confirm'                      => 'Kørsel af Tagoprydning fjerner alle ubrugte tags. Blive ved?',
    'deleting_tags_wait'                              => 'Slet tags, vent venligst ...',
    'new-version-available'                           => 'Ny version tilgængelig!',
    'ignore-this-version'                             => 'Ignorer denne version',
    'view-release-notes'                              => 'Se udgivelsesnoter',
    'task_list'                                       => 'Opgaveliste',
    'create_task'                                     => 'Opret opgave',
    'open'                                            => 'Åben',
    'closed'                                          => 'Lukket',
    'assignee'                                        => 'Modtager',
    'task'                                            => 'Opgave',
    'task_successfully_created'                       => 'Opgaven blev oprettet',
    'task_successfully_updated'                       => 'Opgaven blev opdateret',
    'task_completed'                                  => 'Opgaven blev gennemført',
    'task_marked_incomplete'                          => 'Opgaven genåbnet',
    'due_date_validation_date'                        => 'Vælg en gyldig forfaldsdato',
    'assignee_validation_required'                    => 'Vælg en gyldig modtager fra listen',
    'assignee_validation_exists'                      => 'Vælg en gyldig modtager fra listen',
    'tomorrow'                                        => 'I morgen',
    'task_not_authorized'                             => 'Du er ikke autoriseret til at redigere denne opgave!',
    'me'                                              => 'Mig',
    'task_from_note'                                  => 'Opret opgave ved Gem',
    'done'                                            => 'Færdig',
    'refresh'                                         => 'Opdater',
    'task_list_page_size'                             => 'Antal opgaver pr. Side',
    'select_client'                                   => 'Vælg klient',
    'note-search-config'                              => 'Noter Søg for at inkludere',
    'username'                                        => 'Brugernavn',
    'task-search-config'                              => 'Opgavesøgning for at medtage',
    'task_section_invalid'                            => 'Ugyldig sektion for opgave',
    'task_section'                                    => 'Opgaveafsnit',
    'select_section'                                  => 'Vælg sektion',
    'email-test-failed'                               => 'E-mail-test mislykkedes',
    'smtp-setting-suggestion'                         => 'Forslag:<br>1. Bekræft og indtast dine bruger- / adgangskodeværdier igen<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Forslag:<br>1. Kontroller, at PHP Mail-server er konfigureret korrekt<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Forslag:<br>1. Kontroller, at din Sendmail-sti er korrekt konfigureret.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Forslag:<br>1. Kontroller, at din Sendgrid-nøgle er korrekt konfigureret.<br>2. Contact server admin',
    'later'                                           => 'Senere',
    'test-email-required'                             => 'Du skal indtaste en gyldig e-mail',
    'test_mail_sent_successfully'                     => 'Testmail blev sendt',
    'test-mail-btn-title'                             => 'Skal gemme ændringer inden test.',
    'agreement_expire'                                => 'Dine produktopdateringer og support udløber den :date',
    'agreement_expired'                               => 'Dine produktopdateringer og support udløb den :date',
    'piracy_message'                                  => 'Din FusionInvoice licensnøgle er ikke gyldig. Software-piratkopiering er en forbrydelse. Spil venligst fair. Med en gyldig licens modtager du support, opdateringer og en god karma.',
    'buy-now'                                         => 'Køb nu',
    'piracy_alert'                                    => 'Vær retfærdig!',
    'agreement-expire-alert'                          => 'Produktopdateringer og support udløber snart.',
    'agreement-expired-alert'                         => 'Produktopdateringer og support er udløbet.',
    'dismiss-forever'                                 => 'Afvis for evigt',
    'renew-now'                                       => 'Forny nu',
    'select_all_permissions'                          => 'Vælg Alle tilladelser',
    'app-key-missing'                                 => 'Indtast din licensnøgle i config / app.php.',
    'custom_fields_column_width'                      => 'Brugerdefinerede felter viser kolonner',
    'select-user-type'                                => 'Vælg brugertype',
    'lead-or-prospect-with-invoices-error'            => 'Beklager, en klients type kan ikke være bly eller udsigter, når der findes fakturaer eller tilbagevendende fakturaer.',
    'sendgrid_key'                                    => 'Sendgrid-nøgle',

    //2020-2.0
    'space'                                           => 'Plads',
    'apostrophe'                                      => 'Apostrof',
    'comma'                                           => 'Komma',
    'fullstop'                                        => 'Punkt (punktum)',
    'middledot'                                       => 'Middle Dot',
    'thinspace'                                       => 'Tyndt rum',
    'narrow-no-break-space'                           => 'Smal plads uden pause',
    'dotabove'                                        => 'Prik over',
    'arabic-decimal'                                  => 'Arabisk decimalseparator',
    'arabic-thousand'                                 => 'Arabisk tusind separator',
    'decimal-separator-key-symbol'                    => 'Nøglesymbol for decimalseparator',
    'select-item'                                     => 'Vælg element',
    'item-lookup-overload'                            => 'Maks. 100 genstande er tilladt til opslag af varer',
    'select-expense-category'                         => 'Vælg Udgiftskategori',
    'select-expense-vendor'                           => 'Vælg Udgiftsleverandør',
    'can-not-delete-all-users'                        => 'Beklager, du kan ikke slette alle brugere fra systemet',
    'can-not-change-default-user-role'                => 'Beklager, du kan ikke ændre standardbrugerrollen',
    'can-not-change-default-user-status'              => 'Beklager, du kan ikke ændre standardbrugerstatus',
    'user_not_active'                                 => 'Brugeren er ikke aktiv',
    'can-not-inactive-your-own-status'                => 'Beklager, du kan ikke gøre dig inaktiv.',
    'delete_user_warning'                             => '<p>HOLD OP! Sletning af denne bruger er en destruktiv handling, der kan fjerne poster, som de oprettede i systemet. Overvej venligst at gøre brugeren inaktiv i stedet.</p><p>Er du sikker på, at du vil slette denne bruger?</p>',
    'include_time_in_due_date'                        => 'Medtag tid på forfaldsdato',
    'cannot_delete_default_company'                   => 'Du kan ikke slette standardprofilen',
    'make-user-inactive'                              => 'Gør brugeren inaktiv',
    'mail_from_address'                               => 'Mail fra adresse',
    'mail_from_name'                                  => 'Mail fra navn',
    'item_categories'                                 => 'Varekategorier',
    'select-item-category'                            => 'Vælg varekategori',
    'item_category_form'                              => 'Varekategoriformular',
    'sort_by_due'                                     => 'Sorter efter forfaldsdato',
    'affiliate'                                       => 'Tilknyttet',
    'parent_account'                                  => 'Forældrekonto',
    'child_account'                                   => 'Børnekonti',
    'select_parent_client'                            => 'Vælg Overordnet konto',
    'record_successfully_retrieved'                   => 'Record hentet med succes',
    'custom-image-not-support'                        => 'Tilpasset billedfelt understøttes ikke',
    'custom-tag-not-support'                          => 'Tilpasset tagfelt understøttes ikke',
    'custom-checkbox-not-support'                     => 'Tilpasset afkrydsningsfelt understøttes ikke',
    'custom-date-not-support'                         => 'Tilpasset datofelt understøttes ikke',
    'custom-datetime-not-support'                     => 'Tilpasset datetime-felt understøttes ikke',
    'timeline'                                        => 'TimeLine',
    'client_invoice'                                  => 'Fakturaer efter klient',
    'select_client_blank_for_all'                     => 'Vælg klient (tom for alle)',
    'invoice_email_success'                           => 'Faktura-e-mail sendt',
    'quote_email_success'                             => 'Tilbudsmail sendt',
    'document_number_schemes'                         => 'Dokument nummerering',
    'document_number_scheme'                          => 'Dokumentnummerordning',
    'document_number_scheme_form'                     => 'Skema for dokumentnummerplan',
    'default_document_number_scheme'                  => 'Standard dokumentnummerordning',
    'supporting_data'                                 => 'Understøttende data',
    'customizations'                                  => 'Tilpasninger',
    'utilities_and_logs'                              => 'Hjælpeprogrammer og logfiler',
    'system_log'                                      => 'Systemlog',
    'paid_amount'                                     => 'Betalt beløb',
    'payment_amount'                                  => 'Betalingsbeløb',
    'payment_intent'                                  => 'Betalingsformål',
    'apply_payment_to_one_or_more_invoice'            => 'Anvend betaling på en eller flere fakturaer',
    'pre_payment_for_future_invoices'                 => 'Forudbetaling for fremtidige fakturaer',
    'apply_to_invoices'                               => 'Anvend på faktura (er)',
    'payment_application'                             => 'Betalingsansøgning',
    'remaining_payment_balance'                       => 'Resterende betalingssaldo',
    'remaining_balance'                               => 'Resterende saldo',
    'payment_warning'                                 => 'Indtast beløb',
    'apply_pre_payment_warning'                       => 'Du har ikke anvendt betalingen på fakturaer. Vil du registrere det som en forudbetaling?',
    'confirm_remaining_balance'                       => 'Den resterende saldo på :value vil være tilgængelig for fremtidige fakturaer for denne klient.',
    'open_balance'                                    => 'Åben balance',
    'more_figure_then_total_payment'                  => 'Indtast venligst betalingen igen, din samlede faktura betaling er større end restbeløbet.',
    'remaining_payment_balance_apply_later_info'      => 'Resterende betalingsbalancer kan anvendes på andre fakturaer senere.',
    'invoice_balance'                                 => 'Fakturasaldo',
    'enter_payment_for_invoice'                       => 'Indtast betaling for faktura',
    'invoice_pdf'                                     => 'Faktura PDF',
    'payment_applications'                            => 'Betalingsansøgninger',
    'multiple'                                        => 'Mange',
    'ok'                                              => 'Okay',
    'credit_memo_default'                             => 'Kreditnota standard',
    'edit_payment'                                    => 'Rediger betaling',
    'credit_memo'                                     => 'Kreditnota',
    'credit_memos'                                    => 'Kreditnotaer',
    'create_credit_memo'                              => 'Opret kreditnota',
    'credit_applications'                             => 'Ansøgninger om kreditnotaer',
    'credit_applications_for_invoice'                 => 'Ansøgninger om kreditnota til faktura',
    'prepayment_applications_for_invoice'             => 'Forudbetaling Ansøgninger om faktura',
    'apply_credit_memo'                               => 'Anvend kreditnota',
    'apply_pre_payment'                               => 'Anvend forudbetaling',
    'applied_amount'                                  => 'Anvendt beløb',
    'remaining_credit_balance'                        => 'Resterende kreditbalance',
    'remaining_credit_balance_apply_later_info'       => 'Resterende kreditsaldoer kan anvendes på andre fakturaer senere.',
    'applied'                                         => 'Anvendt',
    'more_figure_then_invoice_amount'                 => 'Indtast venligst beløbet igen, beløbet kan ikke være større end fakturabeløbet.',
    'more_figure_then_invoice_total'                  => 'Indtast venligst beløbet igen, det samlede anvendte beløb kan ikke være større end fakturabeløbet.',
    'invoice_not_selected_warning'                    => 'Vent, du har ikke anvendt kreditnotaen på nogen fakturaer.',
    'select_type'                                     => 'Vælg Type',
    'email_credit_memo'                               => 'E-mail-kreditnota',
    'back_to_credit_memo'                             => 'Tilbage til kreditnota',
    'invoice_amount'                                  => 'Faktura beløb',
    'remaining_invoice_amount'                        => 'Resterende fakturabeløb',
    'settlement_for_credit_memo'                      => 'Afregning for kreditnota',
    'credit_memo_amount'                              => 'Kreditnota beløb',
    'confirm_remaining_balance_invoice'               => 'Den resterende saldo for denne faktura er :value efter afvikling.',
    'payment_receipt_for_invoices'                    => 'Betalingskvittering for fakturaer',
    'primary_phone'                                   => 'Primære telefonnummer',
    'alternate_phone'                                 => 'Alternativt telefonnummer',
    'currency_not_match'                              => 'Valuta stemmer ikke overens',
    'tasks'                                           => 'Opgaver',
    'full_and_final_payment'                          => 'fuld',
    'partial'                                         => 'delvis',
    'transition'                                      => [
        'created'          => 'Oprettet',
        'updated'          => 'Opdateret',
        'deleted'          => 'Slettet',
        'received'         => 'Modtaget',
        'opened'           => 'Åbnet',
        'sent'             => 'Sendt',
        'mail'             => 'Sendt',
        'changed'          => 'Ændret',
        'recurring'        => 'Oprettet',
        'completed'        => 'Afsluttet',
        'reversed'         => 'Omvendt',
        'quote_to_invoice' => 'Citat til faktura',
        'download'         => 'Hent',
        'added'            => 'Tilføjet',
        'email'            => 'E-mail',
        'merge'            => 'Fusionere',
        'billed'           => 'Faktureret',
        'failed'           => 'mislykkedes',
        'invoice'          => [
            'created'                => 'Faktura :invoice_number blev oprettet',
            'credit_memo_created'    => 'Kreditnota :credit_memo_number blev oprettet',
            'credit_memo_updated'    => 'Kreditnota :credit_memo_number blev ændret',
            'created_from_recurring' => 'Faktura :invoice_number blev oprettet (fra tilbagevendende skabelon :recurring_invoice_id)',
            'updated'                => 'Faktura :invoice_number blev ændret',
            'deleted'                => 'Faktura :invoice_number blev slettet',
            'credit_memo_deleted'    => 'Kreditnota :credit_memo_number blev slettet',
            'status_changed'         => 'Faktura :invoice_number Status ændret fra :previous_value til :current_value',
            'email_sent'             => 'Faktura :invoice_number e-mail sendt',
            'resend_email'           => 'Faktura :invoice_number e-mail gensend',
            'email_opened'           => 'E-mail med faktura :invoice_number åbnet',
            'payment_updated'        => 'Faktura :invoice_number opdateret :full_payment_text betaling',
            'payment_received'       => 'Faktura :invoice_number modtaget betaling :full_payment_text',
            'payment_reversed'       => 'Faktura :invoice_number havde en :full_payment_text',
            'invoice_tag_updated'    => 'Fakturamærke :tags blev tilføjet på faktura :invoice_number',
            'invoice_tag_deleted'    => 'Fakturamærket :invoice_number blev slettet :tags',
            'mark_mail'              => 'Faktura :invoice_number marker som afsendt',
            'unmark_mail'            => 'Faktura :invoice_number maske som ikke sendt',
            'paid_invoice_opened'    => 'Betalt faktura blev åbnet for redigering',
            'sent_invoice_opened'    => 'Sendt faktura blev åbnet for redigering',
            'sms_sent'               => 'Faktura :invoice_number SMS sendt',
        ],
        'quote'            => [
            'created'           => 'Citat :quote_number blev oprettet',
            'updated'           => 'Citat :quote_number blev ændret',
            'deleted'           => 'Citat :quote_number blev slettet',
            'status_changed'    => 'Citat :quote_number Status ændret fra :previous_value til :current_value',
            'email_sent'        => 'Citat :quote_number e-mail sendt',
            'resend_email'      => 'Citat :quote_number e-mail gensend',
            'email_opened'      => 'Citat :quote_number e-mail åbnet',
            'quote_to_invoice'  => ':quote_number er konverteret til en faktura - :invoice_number',
            'quote_tag_updated' => 'Citattag :tags blev tilføjet på citat :quote_number',
            'quote_tag_deleted' => 'Citat Tag :quote_number blev slettet :tags',
            'sms_sent'          => 'Citat :quote_number SMS sendt',
        ],
        'payment'          => [
            'prepayment_created'           => 'Forudbetaling blev oprettet',
            'payment_receipt_email_sent'   => 'E-mail med betalingskvittering sendt',
            'payment_receipt_resend_email' => 'E-mail med betalingskvittering gensend',
            'payment_updated'              => 'Betalingen blev ændret',
            'deleted'                      => 'Betaling blev slettet',
            'payment_receipt_pdf_download' => 'Betalingskvittering pdf download',
            'payment_note_deleted'         => 'Betalingsnota slettet:',
            'payment_note_added'           => 'Betalingsnota tilføjet:',
            'payment_note_updated'         => 'Betalingsnota opdateret fra',
            'payment_failed'               => 'Betaling mislykkedes',
        ],
        'client'           => [
            'client_created'     => ':client_type blev oprettet',
            'type_changed'       => ':previous_value blev en :current_value',
            'updated'            => 'Kunden blev opdateret',
            'deleted'            => 'Klienten blev slettet',
            'status_changed'     => 'Klient indstillet til :current_value',
            'client_tag_updated' => 'Tag :tags tilføjet',
            'client_tag_deleted' => 'Tag :tags slettet',
            'merge'              => 'Client ID: :idTo - :nameTo blev flettet ind i Client ID: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Udgifter blev oprettet',
            'updated' => 'Omkostningerne blev ændret',
            'deleted' => 'Udgifter blev slettet',
            'billed'  => 'Omkostninger blev faktureret',
            'vendor'  => [
                'created' => 'Udgiftsleverandør blev oprettet',
                'updated' => 'Udgiftsleverandør blev ændret',
                'deleted' => 'Udgiftsleverandør blev slettet',
            ],
        ],
        'note'             => [
            'created'          => 'Notatet blev oprettet',
            'updated'          => 'Noten blev ændret',
            'deleted'          => 'Noten blev slettet',
            'note_tag_updated' => 'Tag :tags tilføjet på note',
            'note_tag_deleted' => 'Tag :tags slettet fra note',
        ],
        'task'             => [
            'created'   => 'Opgaven blev oprettet',
            'updated'   => 'Opgaven blev ændret',
            'deleted'   => 'Opgaven blev slettet',
            'completed' => 'Opgaven var afsluttet',
        ],
        'subscription'     => [
            'created'                       => 'Abonnement :invoice_number blev oprettet',
            'updated'                       => 'Abonnement :invoice_number blev ændret',
            'deleted'                       => 'Abonnement :invoice_number blev slettet',
            'recurring_invoice_tag_updated' => 'Subscription Tag :tags blev tilføjet på abonnement :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Abonnementsmærket :recurringInvoice_number blev slettet :tags',
        ],
        'attachment'       => [
            'created' => ':filename blev uploadet som en vedhæftet fil',
            'deleted' => ':filename blev fjernet som en vedhæftet fil',
        ],
        'tag'              => [
            'created' => 'Tagget :tag blev tilføjet',
            'deleted' => 'Tagget :tag blev fjernet fra',
        ],
    ],
    'reset'                                           => 'Nulstil',
    'select_event'                                    => 'Vælg begivenhedstype',
    'select_country'                                  => 'Vælg et land',
    'type_captcha'                                    => 'Besvar spørgsmålet ovenfor',
    'refresh_captcha'                                 => 'Opdater spørgsmål',
    'answer'                                          => 'Svar',
    'use_captcha_in_login'                            => 'Brug captcha i login',
    'allow_client_timeline'                           => 'Tidslinje',
    'client_timeline'                                 => 'Tidslinje',
    'no_invoice_tags'                                 => 'Der er ingen fakturamærker.',
    'total_notifications'                             => 'Du har :total underretninger',
    'no_notifications'                                => 'Ingen nye meddelelser',
    'notifications'                                   => 'Meddelelser',
    'notification'                                    => [
        'task'  => [
            'created'           => 'En ny opgave tildelt dig',
            'due_date_breached' => 'Opgaven',
            'completed'         => ':user fuldførte opgave:',
        ],
        'quote' => [
            'approved'             => ':quote_number er blevet godkendt',
            'quote_to_invoice'     => ':quote_number er blevet konverteret til en faktura -',
            'rejected'             => ':quote_number er blevet afvist',
            'payment_successfully' => 'Citat :quote_number for klient :client_name er blevet betalt. Faktura :invoice_number blev oprettet, og betalingen blev anvendt',
        ],
    ],
    'search_tasks'                                    => 'Søgeopgaver',
    'reopen_task'                                     => 'Åbn opgaven igen',
    'task_form'                                       => 'Tilføj opgave',
    'view_task'                                       => 'Opgavedetaljer',
    'client_deleted'                                  => 'Klienten slettes',
    'payment_canceled'                                => 'Din betaling er annulleret',
    'default_company_profile_set'                     => 'Vi har indstillet din standardvirksomhedsprofil. Du kan opdatere det når som helst fra firmaprofilindstillingerne.',
    'file_uploaded_successfully'                      => 'Filen blev uploadet',
    'attachment_notice'                               => 'Maksimal filstørrelse for vedhæftet fil mindre end eller lig med :size',
    'attachment_error'                                => 'Vedhæftningsstørrelse må ikke overstige :size',
    'attachment_warning'                              => 'Vedhæftningsstørrelse er :size. Hvis du uploader mange store vedhæftede filer, kan det ødelægge din databaseydelse over tid.',
    'generate_timeline_history'                       => 'Generer tidslinjehistorik',
    'generating_timeline_wait'                        => 'Genererer tidslinje, vent venligst ...',
    'generating_timeline_confirm'                     => 'Tidslinjefunktionen blev tilføjet i FusionInvoice 2020. Dette genererer tidslinjeposter for alle aktiviteter, der gik forud for denne funktionstilføjelse. Blive ved?',
    'generated_timeline_request_accepted'             => 'Generering af tidslinjehistorik er komplet.',
    'transitions'                                     => 'Tidslinje historie',
    'pending'                                         => 'Verserende',
    'client_transition'                               => 'Klienttidslinjer',
    'expense_transition'                              => 'Udgifts tidslinjer',
    'invoice_transition'                              => 'Fakturatidslinjer',
    'payment_invoice_transition'                      => 'Tidslinjer for betalingsfaktura',
    'payment_transition'                              => 'Betalings tidslinjer',
    'quote_transition'                                => 'Citat tidslinjer',
    'note_transition'                                 => 'Bemærk tidslinjer',
    'task_transition'                                 => 'Opgavens tidslinjer',
    'email_sent'                                      => 'Email sendt',
    'credit_applied'                                  => 'Kredit anvendt',
    'configuration'                                   => 'Konfiguration',
    'include_prepayments'                             => 'Inkluder forudbetalinger',
    'pre_payment'                                     => 'Forudbetalinger',
    'pre_payments'                                    => 'Forudbetalinger',
    'times'                                           => 'Tider',
    'include_prepayments_applied'                     => 'Inkluder anvendte forudbetalinger',
    'confirm_full_payment_applied'                    => 'Betaling blev fuldt ud anvendt',
    'confirm_full_credit_memo_applied'                => 'Kreditnota blev fuldt ud anvendt',
    'all_tasks'                                       => 'Alle opgaver',
    'my_tasks'                                        => 'Mine opgaver',
    'assigned_from_others'                            => 'Tildelt af andre',
    'full_payment_reversed'                           => 'fuld betaling vendt.',
    'partial_payment_reversed'                        => 'delvis betaling vendt.',
    'invoice_delete_error'                            => 'Beklager, du kan ikke slette en faktura, der har betalinger eller kreditnota-applikationer. Du skal først slette betalingerne eller kreditnotaapplikationerne.',
    'mail-from-required'                              => 'Du skal indtaste en gyldig mail fra e-mail',
    'contact_updated'                                 => 'Kontakt opdateret',
    'contact_added'                                   => 'Kontakt tilføjet',
    'generate_passport_key_wait'                      => 'Genererer din pasnøgle, vent venligst ...',
    'generate_passport_key'                           => 'Generer pasnøgle',
    'default_greeting'                                => 'Hej!<br>',
    'hi'                                              => 'Hej,',
    'deduct_tax_from_expenses'                        => 'Fradragsskat fra udgifter',
    'invalid_invoice_id'                              => 'Ugyldig faktura-id',
    'client_related_record_exist'                     => 'Beklager, klienten har relaterede poster for: moduler. Kunder med transaktionshistorik kan ikke slettes.',
    'email_payment_receipt_notice'                    => 'Kunden har ingen e-mail-adresse',
    'show_more'                                       => 'Vis mere ...',
    'show_less'                                       => 'Vis mindre ...',
    'invoice_already_paid'                            => 'Faktura er allerede betalt!',
    'system_default'                                  => 'Systemstandard',
    'created_by'                                      => 'Lavet af',
    'created_at'                                      => 'Oprettet kl',
    'task_created_by_and_created_at'                  => 'Opgave oprettet af :created_by på :created_at',
    'dashboard_widgets_date_options'                  => 'Systemets standard tidsperiode for faktura og tilbud',
    'dashboard-widget-from-date-required'             => 'Fra dato kræves, når brugerdefineret datointerval er valgt i Systemets standardperiode for faktura- og tilbudssammendrag',
    'dashboard-widget-to-date-required'               => 'Til dato kræves, når brugerdefineret datointerval er valgt på Systemets standardperiode for faktura og tilbudssammendrag',
    'invoice_currency'                                => 'Faktura valuta',
    'currency_format'                                 => 'Valutaformat',
    'create_missing_folder_success'                   => 'Oprettet manglende påkrævet mappe',
    'create_missing_folder_failed'                    => 'Forsøg på at oprette mappe (r) mislykkedes :path',
    'folder_is_not_writable'                          => 'Mappen kan ikke skrives :path',
    'update_item_as_lookup'                           => 'Opdater elementopslag',
    'number_of_tax_fields'                            => 'Antal afgiftsfelter',
    'tax_1_entry'                                     => '1 indgang',
    'tax_2_entries'                                   => '2 indlæg',
    'require_tags_on_client_notes'                    => 'Kræv mærke (r) på klientnotater',
    'entered_amount_less_than_invoice_amount'         => 'Det indtastede beløb skal være mindre end eller lig med fakturabeløbet',
    'send-to'                                         => 'Send til',
    'print'                                           => 'Print',
    'pdf_cleanup'                                     => 'Oprydning af PDF',
    'pdf_cleanup_confirm'                             => 'Er du sikker på, at du vil rydde op i gamle PDF-filer',
    'pdf_cleanup_success'                             => 'PDF-oprydning afsluttet',
    'deleting_pdf_wait'                               => 'Sletning af gamle PDF-filer, vent venligst ...',
    'open_invoices'                                   => 'Åbn fakturaer',
    'open_credits'                                    => 'Åbn kredit',
    'unapplied_payments'                              => 'Ikke anvendte betalinger',
    'attach_invoice_pdf'                              => 'Vedhæft faktura PDF',
    'upcoming_payment_notice'                         => 'Kommende betalingsmeddelelse',
    'select_mapping'                                  => 'Vælg Kortlægning',
    'select_named_export'                             => 'Vælg Navngivet eksport',
    'save_mapping'                                    => 'Gem kortlægning',
    'add_mapping'                                     => 'Opret ny kortlægning',
    'edit_mapping'                                    => 'Opdater kortlægning',
    'save_as_default_mapping'                         => 'Standardkortlægning',
    'save_as_default_export'                          => 'Standardeksport',
    'export_item_lookups'                             => 'Eksporter elementopslag',
    'import_file_selection'                           => 'Importer filvalg',
    'next'                                            => 'Næste',
    'delete_import_mapping_warning'                   => 'Er du sikker på, at du vil slette denne kortlægning?',
    'export'                                          => 'Eksport',
    'named_exports'                                   => 'Navngivet eksport',
    'save_named_export'                               => 'Gem navngivet eksport',
    'delete_named_export'                             => 'Slet navngivet eksport',
    'updated_at'                                      => 'Opdateret kl',
    'zip'                                             => 'Lynlås',
    'fields_to_export'                                => 'Felter, der skal eksporteres',
    'import-file-type-error'                          => 'Importfiltypen skal være CSV',
    'recurring_invoice_items'                         => 'Tilbagevendende fakturaposter',
    'important_details'                               => 'Vigtige detaljer',
    'important_information'                           => 'Vigtig information',
    'item_lookups_important_information'              => '<p>Hvis der findes et matchende element i opslag i de eksisterende data under CSV -importen, mislykkes importbatchen og viser det element, der forårsagede fejlen.</p>',
    'invoices_important_information'                  => '<p>Klientnavn (fra CSV) slås op i tabellen Klienter og løses til client_id, hvis der er et matchende navn. Hvis der ikke findes et navnematch, opretter det en klientpost og bruger id\'et for den nye klientpost</p><p>Faktura nummer,</p><p>Invoice_items søger efter fakturanummeret (fra CSV) i fakturatabellen og løser det til id\'et. Der udføres ikke andre nøglefeltsøgninger/valideringer</p>',
    'invoice_items_important_information'             => '<p>Importen invoice_items udfører et opslag på fakturanummeret (fra CSV -filen) i fakturatabellen og løser det til det relevante faktura -id. Klient -id\'et er også afledt af de matchende fakturaoplysninger.</p>',
    'payments_important_information'                  => '<p>Import af betalinger kræver et gyldigt matchende fakturanummer for at anvende betalingerne på. Hvis der ikke findes en matchende faktura, mislykkes hele batchimporten.</p><p>De rette kunder-</p><p>Et opslag udføres på betalingsmetodens navn (fra CSV -filen til tabellen for betalingsmetoder) og vil blive overført til den relevante betalingsmetode_id, hvis den findes. hvis der ikke findes et matchende navn, vil der blive oprettet en ny betalingsmetodepost, og det nye betalingsmetode_id vil blive brugt.</p>',
    'run_daily_tasks'                                 => 'Kør daglige opgaver',
    'daily_task_ran'                                  => 'Daglige opgaver kørte med succes',
    'csv_row_number'                                  => 'CSV -rækkenummer :row',
    'max_item_lookup_records'                         => 'Maks. Vareopslagsposter',
    'invoice_with_commission_delete_error'            => 'Beklager, du kan ikke slette en faktura, der har provisionsposteringer med en betalt status. Du skal først slette betalt kommission på denne faktura.',
    'if_invoice_is_emailed_while_draft'               => 'Hvis fakturaen sendes via e-mail, mens den er i kladdestatus',
    'custom_payment_receipt_body_not_exists'          => 'Den tilpassede skabelon til betalingskvitteringer blev ikke fundet.',
    'invoice_email_body_type'                         => 'Faktura E-mail Brødtekst',
    'send_overdue_reminder'                           => 'Send forsinket påmindelse',
    'reminder_sent_successfully'                      => 'Påmindelsen blev sendt',
    'error_sending_reminder'                          => 'Der opstod en fejl ved afsendelse af påmindelse. Prøv venligst igen senere.',
    'expense_date'                                    => 'Udgiftsdato',
    'group_by'                                        => 'Grupper efter',
    'timeline_scope_all_user'                         => 'Tidslinjeomfang - Alle brugere',
    'copy_to_clipboard'                               => 'Kopier til udklipsholder',
    'text_copied_clipboard'                           => 'Tekst kopieret til udklipsholder!',
    'import_example_csv'                              => 'Et eksempel på en CSV-fil kan findes her',
    'import'                                          => 'Importere',
    'address2'                                        => 'Adresse 2',
    'use_parent_email'                                => 'Brug forældre-e-mail',
    'max_import_records'                              => 'Maksimal grænse for import af poster er :total_records',
    'demo_file_attachment_disabled'                   => 'Vedhæftede filer er deaktiveret i demoen',
    'drag_drop_file'                                  => 'Træk',
    'or'                                              => 'ELLER',
    'browse_file'                                     => 'Gennemse fil',
    'system_setting_and_ui'                           => 'Systemindstillinger',
    'localization_and_timezone'                       => 'Lokalisering',
    'security'                                        => 'Sikkerhed',
    'cleanup_and_backup'                              => 'Ryd op',
    'attach_quote_pdf'                                => 'Vedhæft citat PDF',
    'attach_payment_receipt'                          => 'Vedhæft betalingskvittering',
    'choose-file'                                     => 'Vælg fil',
    'important-note'                                  => 'Vigtig note',
    'collapse'                                        => 'Bryder sammen',
    'add_task'                                        => 'Tilføj opgave',
    'recurring_invoice_commissions'                   => 'Tilbagevendende fakturaprovision',
    'invoice_commissions'                             => 'Fakturaprovision',
    'percentage'                                      => 'Procent',
    'flat_amount'                                     => 'fladt beløb',
    'discount-amount'                                 => 'Rabat',
    'discount-type'                                   => 'Rabattype',
    'saving'                                          => 'Gemmer...',
    'preparing'                                       => 'Forbereder',
    'allow_line_item_discounts'                       => 'Tillad linjevarerabatter',
    'invalid_price_amount'                            => 'Ugyldigt prisbeløb! Skal være større end 0.',
    'light-mode'                                      => 'Lys tilstand',
    'dark-mode'                                       => 'Mørk tilstand',
    'system_base_currency'                            => 'Systemets basisvaluta',
    'is_recurring_task'                               => 'Er tilbagevendende opgave',
    'contact_names'                                   => 'Kontaktnavne',
    'all_client'                                      => 'Alle kunder',
    'invoice_grand_total'                             => 'Faktura Grand Total',
    'recurring_invoice_grand_total'                   => 'Tilbagevendende faktura Grand Total',
    'is_required'                                     => 'Er påkrævet?',
    'add-new-client'                                  => 'Tilføj ny klient',
    'client_name_required'                            => 'Klientnavn er påkrævet',
    'custom_item_text_validate'                       => 'Indtast venligst et gyldigt element :label i feltet :label.',
    'assigned_to_others'                              => 'Tildelt til andre',
    'all_tasks_and_all_users'                         => 'Alle opgaver/Alle brugere',
    'statement'                                       => 'Udmelding',
    'profile_code'                                    => 'Profil kode',
    'login-url'                                       => 'Login URL',
    'url_copied_clipboard'                            => 'URL kopieret til udklipsholder!',
    'payment_receipt_email_sent'                      => 'E-mail med betalingskvittering er sendt',
    'edit_payment_note_form'                          => 'Rediger betalingsnota',
    'payment_invoices_text'                           => 'Tak skal du have! Din betaling af :amount er blevet anvendt på følgende fakturaer.',
    'payment_text'                                    => 'Tak for din betaling af :amount .',
    'date_filter_by'                                  => 'Dato Filtrer efter',
    'filter_by_invoice_date'                          => 'Fakturadato',
    'filter_by_payment_date'                          => 'Betalingsdato',
    'date-range-required'                             => 'Vælg venligst datointerval',
    'save-and-complete'                               => 'Gem og fuldfør',
    'completion-note'                                 => 'Afslutningsnotat',
    'complete-with-note'                              => 'Komplet med note',
    'placeholder_type_note'                           => 'Skriv dine noter...',
    'credit_memo_email_subject'                       => 'Kreditnota E-mail Emne',
    'default_credit_memo_email_body'                  => 'Standard kreditnota E-mail Brødtekst',
    'show_invoices_from'                              => 'Vis fakturaer fra',
    'system_mail_from_address'                        => 'System Mail Fra adresse',
    'user_who_created_invoice'                        => 'Bruger der har oprettet faktura',
    'completed'                                       => 'Afsluttet',
    'no_auth_to_view_task'                            => 'Denne opgave er ikke længere på din liste.',
    'credit-memo-and-prepayments'                     => 'Kreditter og forudbetalinger',
    'all_selected'                                    => 'Alle udvalgte',
    'select_columns'                                  => 'Vælg kolonner',
    'column_settings'                                 => 'Kolonneindstillinger',
    'minimum_one_column_check_is_required'            => 'Vælg mindst én kolonne',
    'date_of_entry'                                   => 'Dato for indgang',
    'amount_applied'                                  => 'Anvendt beløb',
    'date_applied'                                    => 'Dato anvendt',
    'copy_to_recurring_invoice'                       => 'Kopi til tilbagevendende faktura',
    'top_bar_color'                                   => 'Top Bar farve',
    'light_grey'                                      => 'Lysegrå',
    'bg-primary'                                      => 'Blå',
    'bg-warning'                                      => 'Gul',
    'bg-info'                                         => 'Dragonfly blå',
    'bg-danger'                                       => 'Rød',
    'bg-success'                                      => 'Græsgrøn',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victoria blå',
    'bg-navy'                                         => 'Marine blå',
    'bg-purple'                                       => 'Lilla',
    'bg-fuchsia'                                      => 'Fuchsia',
    'bg-pink'                                         => 'Lyserød',
    'bg-maroon'                                       => 'Rødbrun',
    'bg-orange'                                       => 'orange',
    'bg-lime'                                         => 'Lime grøn',
    'bg-teal'                                         => 'Blågrøn',
    'bg-olive'                                        => 'Oliven',
    'fee_name'                                        => 'Gebyrnavn',
    'fee_percentage'                                  => 'Gebyrprocent',
    'fee_explanation'                                 => 'Gebyr Forklaring',
    'enable_online_payment_processing_fees'           => 'Aktiver gebyrer for behandling af onlinebetalinger',
    'allow_online_payment_processing_fees'            => 'Tillad gebyrer for behandling af onlinebetalinger',
    'allow_online_pay_fees'                           => 'Tillad onlinebetalingsgebyrer',
    'convenience_charges'                             => 'Bekvemmelighedsgebyrer',
    'opp-fee-percentage-required'                     => 'Procentdel for onlinebetalingsgebyrer er påkrævet',
    'opp-fee-percentage-gt-zero'                      => 'Procentdelen af gebyrer for onlinebetalingsbehandling skal være større end nul',
    'cron_error'                                      => 'mislykkedes på :datetime',
    'cron_start'                                      => 'Daglig opgaveløber startede på :datetime',
    'notification_clear_all'                          => 'Ryd alle meddelelser',
    'show'                                            => 'At vise',
    'report'                                          => 'Rapport',
    'profit_loss'                                     => 'Fortjeneste og tab',
    'credit_and_pre_payments'                         => 'Kreditter og forudbetalinger',
    'expenses_vendors'                                => 'Udgifter Sælgere',
    'expenses_categories'                             => 'Udgiftskategorier',
    'create'                                          => 'skab',
    'import_map_clients'                              => 'Importer kortklienter',
    'payctr_users'                                    => 'PaymentCenter-brugere',
    'ctrl_plus_click'                                 => 'Ctrl-klik for at tilføje færdiggørelsesnotater',
    'edit_note'                                       => 'Rediger note',
    'save-and-unComplete'                             => 'Gem og ufuldstændig',
    'sales_chart'                                     => 'Salgsdiagram',
    'accumulate_totals'                               => 'Akkumuler totaler',
    'do_not_accumulate_totals'                        => 'Akkumuler ikke totaler',
    'kpi_cards'                                       => 'KPI kort',
    'no_data_to_display'                              => 'Ingen data at vise',
    'choose_period'                                   => 'Vælg Periode',
    'date_mailed'                                     => 'Dato afsendt',
    'date_emailed'                                    => 'Dato sendt på e-mail',
    'action'                                          => 'Handling',
    'mail'                                            => 'Post',
    'mark_as_mailed'                                  => 'Markér som afsendt',
    'invoice_mailed'                                  => 'Faktura er markeret som afsendt',
    'emailed'                                         => 'E-mailet',
    'paid_invoice_canceled_error'                     => 'For at annullere denne faktura skal du slette betalinger fra fakturaen.',
    'allow_invoice_delete'                            => 'Tillad sletning af faktura',
    'allow_child_accounts'                            => 'Tillad børnekonti',
    'third_party_bill_payer'                          => '3. parts regningsbetaler',
    'invoices_paid_by'                                => 'Fakturaer betalt af',
    'use_third_party_bill_payer_email'                => 'Brug e-mail til tredjepartsregningsbetaler',
    'email_default'                                   => 'Email Standard',
    'client_default'                                  => 'Client Standard',
    'clear-all'                                       => 'Slet alt',
    'system_log_is_missing_or_empty'                  => 'Systemlog mangler eller er tom',
    'change_to_draft'                                 => 'Skift til Kladde',
    'invoice_status_change_to_draft'                  => 'Fakturastatus Ændring til Kladde',
    'there_is_some_error'                             => 'Der er nogle fejl',
    'filter_by_date'                                  => 'Filtrer efter dato',
    'quote_grand_total'                               => 'Citat Grand Total',
    'email_upcoming_payment_due_notice'               => 'E-mail kommende betalingsmeddelelse',
    'email_overdue_invoice_reminder'                  => 'E-mail påmindelse om forfalden faktura',
    'page_totals'                                     => 'Sidetotaler',
    'categories'                                      => 'Kategorier',
    'conven_charges'                                  => 'Konv. Afgifter',
    'invoice_status_change_to_cancel'                 => 'Fakturastatus Ændring til Annuller',
    'filter_by_invoice_number'                        => 'Faktura nummer',
    'filter_by_client_name'                           => 'Kundenavn',
    'custom_mail_template'                            => 'Brugerdefineret mailskabelon',
    'invoice_use_custom_mail_template'                => 'Faktura Brug tilpasset postskabelon',
    'client_or_company_name'                          => 'Kunde/virksomhedsnavn',
    'view_invoice'                                    => 'Se faktura',
    'tt_active'                                       => 'Når en klientpost ikke er aktiv, vises den ikke på standardklientlisten, og normale transaktioner vil ikke være tilladt.',
    'tt_invoice_prefix'                               => 'En unik fakturapræfikskode tildeles automatisk til en kundepost, når den oprettes. Det kan ændres manuelt senere. Det kan bruges som en del af dit dokumentnummereringsskema til fakturanummerering, hvilket giver mulighed for et unikt fakturanummer pr. klient.',
    'tt_automatic_email_payment_receipts'             => 'Sender en e-mailet betalingskvittering til kunden, når han modtager en betaling. En global indstilling er tilgængelig i Systemindstillinger, men kan tilsidesættes på individuel klientbasis.',
    'tt_automatic_email_on_recur'                     => 'Sender en e-mailet faktura til kunden, når en tilbagevendende faktura køres og opretter en levende faktura. En global indstilling er tilgængelig i Systemindstillinger, men kan tilsidesættes på individuel klientbasis.',
    'tt_default_currency'                             => 'Den valuta, der er tildelt denne kundekonto, som vil blive brugt til deres faktura-, tilbuds- og betalingstransaktioner. Denne værdi er standard fra systemindstillingen for basisvaluta.',
    'tt_language'                                     => 'Det sprog, som vil blive vist for klienten, når de logger på klientcentret.',
    'tt_allow_client_center_login'                    => 'Skal kunden have lov til at logge ind på dit FusionInvoice-kundecenter? Deres e-mail skal bruges til deres brugernavn, og du skal tildele en adgangskode. Klientcenterets URL er',
    'tt_timezone'                                     => 'Tidszone for klienten. Hvis den indtastes, vil klientens lokale tid blive vist øverst i klientsidevisningen.',
    'tt_allow_online_payment_processing_fees'         => 'Gebyrer for behandling af onlinebetalinger kan beregnes for kunder, der betaler med kreditkort, ved at bruge deres offentlige fakturalink (inkluderet i faktura-e-mailen). Denne mulighed har en global systemindstilling, men kan også tilsidesættes på individuel klientbasis.',
    'tt_allow_child_accounts'                         => 'Indstilling af Tillad underordnede konti til Ja sætter denne klient i stand til at fungere som en overordnet konto og giver dig mulighed for at vælge den fra listen over forældrekonti.',
    'tt_third_party_bill_payer'                       => 'En tredjeparts regningsbetaler er en organisation, der betaler regninger for deres kunder, såsom et eksternt revisionsfirma.',
    'tt_parent_account'                               => 'Modervirksomheden, som denne klient er relateret til eller et datterselskab af. Denne liste indeholder de klientposter, som har indstillingen Tillad underordnede konti sat til Ja. Lad være tom, hvis klienten ikke har nogen forældrekonto.',
    'tt_invoices_paid_by'                             => 'Den tredjepartsvirksomhed, som denne klient bruger til at betale deres fakturaer. Denne liste indeholder de klientregistreringer, som har indstillingen 3rd Party Bill Payer sat til Ja. Lad stå tomt, hvis kunden betaler deres egne fakturaer.',
    'tt_email_default'                                => 'Når du sender e-mails til denne klient, skal du vælge den e-mail, der skal bruges. Hvis denne klient har en tilknyttet overordnet konto eller fakturaer betalt af konto, kan en af disse muligheder vælges. Standard er klientens standard-e-mail.',
    'tt_default_to'                                   => 'When sending emails, should this contact automatically get added to the \'To:\' recipients list?',
    'tt_default_cc'                                   => 'Skal denne kontakt automatisk føjes til \'CC:\' modtagerlisten, når du sender e-mails?',
    'tt_default_bcc'                                  => 'Når du sender e-mails, skal denne kontakt automatisk tilføjes til \'BCC:\' modtagerlisten?',
    'tt_client_type'                                  => 'En lead er en ukvalificeret salgskandidat. En kundeemne er en kvalificeret kandidat, som snart kan blive kunde. En kunde er en virksomhed eller person, som du har solgt (eller snart vil sælge) varer eller tjenester til. En affiliate er en virksomhed eller person, der videresælger dine varer eller tjenester. Andet bruges til forretninger, der ikke passer til de andre typer, såsom tredjepartsregningsbetalere eller forældrekonti, som du ikke handler direkte med.',
    'tt_client_tags'                                  => 'Tags kan tildeles en klient for at hjælpe med at kategorisere eller filtrere din kundeliste til visning eller rapportering.',
    'tt_important_note'                               => 'En note, der indtastes her, vil automatisk poppe op i en VIGTIGT! vindue, når klientposten vises.',
    'tt_gen_header_title_text'                        => 'Teksten, der vises i øverste venstre hjørne, ved siden af dit logo, normalt dit firmanavn.',
    'tt_gen_default_company_profile'                  => 'Den virksomhedsprofil, der som standard skal bruges ved oprettelse af nye fakturaer, tilbud osv. Virksomhedsprofiler giver dig mulighed for at præsentere din virksomhed forskelligt med hver profil, hvilket giver mulighed for forskellige firmanavne, logoer, fakturaformater mv.',
    'tt_gen_address_format'                           => 'Giver dig mulighed for at opbygge adresseformatet vist på fakturaer og tilbud ved at bruge det enkelte adressefelt eller en kombination af de individuelle adressefelter, såsom by, stat, land osv.',
    'tt_gen_custom_fields_columns'                    => 'Brugerdefinerede felter kan vises fra 1 til 3 felter pr. række.',
    'tt_gen_require_tags_on_client_notes'             => 'Hvis indstillet til Ja, vil det kræve, at et tag vælges eller indtastes, når der tilføjes en klientnote, såsom \'Support\' eller \'Salg\'. Dette er nyttigt til at kategorisere og søge efter noter.',
    'tt_gen_skin'                                     => 'Hvordan vil du have din FI UI vist, lys eller mørk tilstand',
    'tt_gen_top_bar_color'                            => 'Farven på den øverste titellinje. Hvis du arbejder med flere forskellige FusionInvoice installationer, kan dette være en nyttig visuel identifikation.',
    'tt_gen_results_per_page'                         => 'Antallet af poster vist pr. side for alle listevisninger, såsom kunder, fakturaer, tilbud, udgifter osv.',
    'tt_gen_allow_line_item_discounts'                => 'Aktiverer eller deaktiverer rabatfunktionen for linjeposter i fakturaer og tilbud.',
    'tt_gen_language'                                 => 'Det sprog, der skal bruges til din FusionInvoice-installation. Bemærk, at du kan tildele et andet sprog til dine kunder, så de kan interagere med FusionInvoice Client Center ved hjælp af deres modersmål.',
    'tt_gen_date_format'                              => 'Dit foretrukne datoformat',
    'tt_gen_use_24_hour_time_format'                  => 'Giver mulighed for understøttelse af 24 eller 12 timers tidsformater.',
    'tt_gen_timezone'                                 => 'Din virksomheds primære tidszin.',
    'tt_gen_base_currency'                            => 'Den valuta, som din virksomhed oftest bruger.',
    'tt_gen_exchange_rate_mode'                       => 'Manuel giver dig mulighed for at indtaste valutakursværdien, mens du opretter fakturaer. Automatisk vil forsøge at bruge en offentlig API til at hente valutakursen. Dette bruges kun, når du indtaster en transaktion med en anden valuta end din basisvaluta.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice understøtter op til 2 momsfelter pr. linjepost. Værdien valgt med vis eller skjul det andet momsfelt.',
    'tt_gen_quantity_price_decimals'                  => 'Antallet af decimaler, der skal vises for mængde- og mængdeværdier. Vælg 0 til 4 baseret på dit nødvendige nøjagtighedsniveau.',
    'tt_gen_round_tax_decimals'                       => 'Vælg dit nødvendige antal decimaler til beregning af skatsafrunding.',
    'tt_gen_use_captcha_in_login'                     => 'Hvis indstillet til Ja, kræver det, at dine brugere besvarer et CAPTCHA-udfordringsspørgsmål under login.',
    'tt_gen_force_https'                              => 'Vi anbefaler sjældent at slå denne mulighed til. Hvis din installation ikke har et korrekt fungerende SSL-certifikat installeret på din webserver, kan du opleve problemer til din FusionInvoice installation. Du kan opnå det samme resultat ved at opsætte en serveromdirigeringsregel.',
    'dashboard_settings'                              => 'Indstillinger for instrumentbræt',
    'tt_dashboard_settings'                           => 'Dit dashboard bruges til at vise vigtige forretningsmålinger og begivenheder, hvilket giver dig værdifuld indsigt i din virksomheds præstation. Systemdashboardet er standard for alle brugere, men inden for hver brugers konfiguration kan du tilsidesætte systemets standarddashboard og definere specifikke indstillinger for hver bruger. Indstillingerne nedenfor giver dig mulighed for at tilpasse dit dashboard.',
    'tt_db_default_time_period'                       => 'Indstiller standardstart- og slutdatoer for dashboard-widgets, der bruger dem, såsom KPI-kort og salgsgrafen.',
    'tt_db_recent_client_activity'                    => 'En widget, der viser klientinteraktioner, såsom foretagne betalinger og fakturaer eller citater, der er set, fra dine offentlige faktura- eller tilbudslinks.',
    'tt_db_display_order'                             => 'Dette ændrer visningsrækkefølgen for dashboard-widgets. 1 vises øverst, 2 vises efter 1 osv.',
    'tt_db_column_width'                              => 'Dashboard-widgets bruger Bootstrap-gittersystemet og har en maksimal kolonnebredde på 12. Indstilling af kolonnebredden til 12 vil få widgetten til at bruge hele den tilgængelige bredde. Indstilling til 6 giver to widgets mulighed for at dele den samme række, 4 vil tillade 3 widgets at dele den samme række osv.',
    'tt_db_accumulate_totals'                         => 'Hvis du indstiller denne værdi til, vil din graf inkludere de foregående dages totaler for hver dag. For eksempel var salget for dag 1 $100, dag 2 var $50, dag 3 var $125. Grafen ville vise en stigende linje med denne indstilling sat til Ja. Sæt til Nej, ville vise et fald i salgslinjen på dag 2 og stige til dag 3.',
    'tt_db_kpi_cards'                                 => 'Disse farvekodede kort viser vigtige præstationsindikatorer øverst på dit dashboard.',
    'tt_db_sales_chart'                               => 'Et linjediagram, der viser faktura- og betalingstotaler.',
    'tt_db_task_list'                                 => 'Denne widget giver dig mulighed for at arbejde med opgavelistemodulet direkte fra dit dashboard.',
    'tt_db_task_list_include_time'                    => 'Hvis du slår denne indstilling til, kan du angive dato og klokkeslæt for forfaldsdatoer, når du arbejder med opgaver. Når den er indstillet til Nej, bruges kun datoværdien.',
    'tt_db_timeline'                                  => 'Tidslinje-widgetten viser en kronologisk og søgbar liste over vigtige systemhændelser, såsom ændringer i klientstatus, fakturaer sendt via e-mail, gennemførte betalinger, taget noter osv.',
    'tt_ss_invoices_default_invoice_template'         => 'Vælg den skabelon, der som standard skal bruges ved oprettelse af nye fakturaer. Brugerdefinerede skabeloner skal placeres i .\\custom\\templates\\invoice_templates\\ og skal navngives med en .blade.php-udvidelse.',
    'tt_ss_invoices_default_doc_scheme'               => 'Vælg det bilagsnummerskema, der som standard skal bruges ved oprettelse af nye fakturaer. Dokumentnummerskemaer kan oprettes i Konfigurationsindstillinger og giver dig mulighed for at tilpasse dine bilagsnumre (fakturaer, tilbud, kreditnotaer).',
    'tt_ss_invoices_invoice_due_days'                 => 'Standardantallet af dage efter fakturadatoen (oprettelsesdatoen), hvor fakturaen forfalder og forventes at blive betalt.',
    'tt_ss_invoices_automatic_email_ri'               => 'Når en tilbagevendende faktura køres og genererer en aktiv faktura, skal den aktive faktura automatisk sendes til kunden via e-mail?',
    'tt_ss_invoices_qr_code'                          => 'Skal der automatisk placeres en QR-kode på standardfakturaer og tilbud. Hvis du bruger brugerdefinerede faktura- eller tilbudsskabeloner, skal du se standardskabelonerne for at tilføje QR-koden til dine brugerdefinerede skabeloner.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Hvis en faktura har status som Kladde og sendes via e-mail, enten manuelt eller automatisk, hvad skal der ske med fakturadatoen. Vigtig bemærkning: Når en faktura sendes via e-mail, ændres status automatisk fra Kladde til Sendt.',
    'tt_ss_invoices_recalculate'                      => 'Kører hver transaktion foretaget for hver faktura, fra den dato den blev oprettet til den aktuelle dato, og genberegner totalerne, linjeposttotaler, skatter, rabatter og fakturatotaler. Dette kan tage lang tid at køre, hvis du har et stort datasæt.',
    'tt_ss_invoices_due_after'                        => 'Forfaldsdatoen for fakturaen vil være fakturadatoen plus det antal dage, der er indtastet her.',
    'tt_ss_invoices_default_status_filter'            => 'Statusfilteret, der skal anvendes, som standard, når du ser fakturalisten.',
    'tt_ss_invoices_default_terms'                    => 'Vilkårstekstværdien, som vises på standardfaktura-skabelonen, nederst på fakturaen i området Vilkår og betingelser.',
    'tt_ss_invoices_default_footer'                   => 'Sidefodstekstværdi, som vises på standard fakturaskabelonen nederst på fakturaen. For eksempel:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Når den daglige opgaveløber (CRON-job) udfører og genererer en levende faktura fra en tilbagevendende fakturaskabelon, skal den nyoprettede faktura da automatisk sendes til kunden via e-mail? Dette kan tilsidesættes fra klient til klient.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Når en betaling foretages, skal disse betalingsoplysninger automatisk sendes til kunden via e-mail?',
    'tt_ss_invoices_online_payment_method'            => 'Den betalingsmetode, der tildeles, når en klient betaler ved hjælp af et offentligt fakturalink. Betalingsmetoder kan vedligeholdes gennem systemindstillinger.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Skal der vises en QR-kode, som leder til Fakturaens eller Tilbuddets offentlige URL, på dokumentet?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Skal brugere, selv administratorbrugere, have lov til at slette fakturaer? Et sikrere og mere sporbart alternativ til at slette fakturaer er at ændre fakturastatus til \'Annulleret\', hvilket ændrer fakturatotalen til nul og udelukker den fra de fleste lister og rapporter.',
    'tt_ss_invoices_show_invoices_from'               => 'Når fakturaer sendes via e-mail, vil dette blive vist som den afsendte fra-adresse. Vigtig bemærkning: Værdien Svar til vil altid være den værdi, der er tildelt i Systemindstillinger -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Fra fakturavisningen, hvis fakturaen er i kladdestatus og sendt via e-mail, skal fakturadatoen så forblive uændret eller ændres til den aktuelle dato? Hvis fakturadatoen ændres, opdateres også forfaldsdatoen.',
    'tt_ss_quotes_default_quote_template'             => 'Vælg den skabelon, der som standard skal bruges, når du opretter et nyt tilbud. Brugerdefinerede skabeloner skal placeres i .\\custom\\templates\\quote_templates\\ og skal navngives med en .blade.php-udvidelse.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Vælg det dokumentnummerskema, der som standard skal bruges ved oprettelse af nye tilbud. Dokumentnummerskemaer kan oprettes i Konfigurationsindstillinger og giver dig mulighed for at tilpasse dine bilagsnumre (fakturaer, tilbud, kreditnotaer).',
    'tt_ss_quotes_expire_days'                        => 'Standardantallet af dage efter tilbudsdatoen (oprettelsesdatoen), som tilbuddet udløber. Når et tilbud har passeret sin udløbsdato, er det underforstået, at prisfastsættelsen kan ændre sig på grund af markedsudsving mv.',
    'tt_ss_quotes_default_status_filter'              => 'Statusfilteret, der skal anvendes, som standard, når du ser fakturalisten.',
    'tt_ss_quotes_auto_convert'                       => 'Når et tilbud godkendes, skulle det medføre, at der automatisk oprettes en faktura ud fra tilbuddet.',
    'tt_ss_quotes_when_converted_action'              => 'Når et tilbud konverteres til en faktura, skal betalingsbetingelserne så bruges fra tilbuddet eller fra standardindstillingen for fakturabetingelser?',
    'tt_ss_quotes_default_terms'                      => 'Begrebstekstværdien, som vises på standardtilbudsskabelonen i det nederste område af tilbuddet i området Vilkår og betingelser.',
    'tt_ss_quotes_default_footer'                     => 'Sidefodstekstværdi, som vises nederst i citatet på standardtilbudsskabelonen. For eksempel:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Hvad skal der ske med tilbudsdatoen, hvis et tilbud har status som Kladde og sendes via e-mail, enten manuelt eller automatisk. Vigtig bemærkning: Når et tilbud sendes via e-mail, ændres status automatisk fra Kladde til Sendt.',
    'tt_ss_quotes_recalculate'                        => 'Kører hver transaktion, der er foretaget for hvert tilbud, fra den dato, det blev oprettet til den aktuelle dato, og genberegner totalerne, linjeposttotaler, skatter, rabatter og tilbudstotaler. Dette kan tage lang tid at køre, hvis du har et stort datasæt.',
    'tt_ss_taxes_default_rate1'                       => 'Den primære afgiftssats, der automatisk skal anvendes på nye linjeposter, der tilføjes til fakturaer eller tilbud. Skattesatser opretholdes gennem konfiguration -',
    'tt_ss_taxes_default_rate2'                       => 'Den sekundære skattesats, der automatisk skal anvendes på nye linjeposter, der tilføjes til fakturaer eller tilbud. Skattesatser opretholdes gennem konfiguration -',
    'tt_ss_email_send_method'                         => 'E-mail-afsendelsesmetoden, som FusionInvoice skal bruge. Ændring af afsendelsesmetoden ændrer også visningen af de understøttende felter for afsendelsesmetoden.',
    'tt_ss_email_allow_self_cert'                     => 'Når denne indstilling slås til, deaktiveres PHP verify_peer-kravet. For mere information søg på internettet efter: PHP e-mail selvsigneret certifikat openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Når du sender e-mails, er dette standardsvar til-adressen, som dine modtagere vil se.',
    'tt_ss_email_always_cc'                           => 'En e-mail-adresse, som du som standard automatisk vil CC med hver e-mail sendt.',
    'tt_ss_email_always_bcc'                          => 'En e-mailadresse, som du som standard gerne vil automatisk BCC med hver e-mail sendt.',
    'tt_ss_email_send_test_to'                        => 'Den e-mailadresse, der skal bruges, når du klikker på knappen Send test-e-mail.',
    'tt_ss_email_mail_from_addr'                      => 'Standard Mail From-adresse, der skal bruges, når e-mails sendes fra FusionInvoice. Bemærk: i Systemindstillinger -',
    'tt_ss_email_mail_from_name'                      => 'Mail From-venligt navn, der skal vises på e-mails, der sendes.',
    'tt_ss_email_email_templates'                     => 'E-mail-skabeloner er tilgængelige for mange dokumenter og begivenheder, disse inkluderer: tilbud, tilbudsgodkendelser, tilbudsafvisninger, fakturaer, fakturaer, der forfalder, kreditnotaer, betalingskvitteringer, kommende betalingsmeddelelser. En standardskabelon er inkluderet, men du kan også oprette brugerdefinerede skabeloner, som kan være enkle (som de medfølgende standardskabeloner) eller fuldt formateret HTML.',
    'tt_ss_pdf_driver'                                => 'Driveren til brug ved oprettelse af PDF-dokumenter. Valg af \'wkhtmltopdf\'-driveren kræver en lokal serverinstallation af dette program og indstilling af den passende binære sti til det.',
    'tt_ss_pdf_binary_path'                           => 'Den lokale serversti til den binære fil for wkhtmltopdf. For eksempel C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice understøtter flere online betalingsudbydere. Aktiver de udbydere, som du har oprettet konti hos. De udbydere, der er aktiveret her, vil blive vist som betalingsmuligheder, når dine kunder ser deres fakturaer ved hjælp af det offentlige fakturalink (inkluderet i standardfaktura-e-mailen).',
    'tt_ss_olp_api_key'                               => 'API-nøglen leveres til dig af din betalingsudbyder.',
    'tt_ss_olp_payment_button_text'                   => 'Teksten, der vises på betalingsmetodeknappen for denne betalingsudbyder, øverst på din offentlige faktura, som den ses af dine kunder.',
    'tt_ss_olp_mode'                                  => 'Understøttet af nogle betalingsudbydere, hvilket giver mulighed for Sandbox mere (test) og live.',
    'tt_ss_olp_client_id'                             => 'Klient-id\'et gives til dig af denne betalingsudbyder.',
    'tt_ss_olp_client_secret'                         => 'Klienthemmeligheden leveres til dig af denne betalingsudbyder.',
    'tt_ss_olp_publishable_key'                       => 'Den publicerbare nøgle leveres til dig af denne betalingsudbyder.',
    'tt_ss_olp_secret_key'                            => 'Den hemmelige nøgle leveres til dig af denne betalingsudbyder.',
    'tt_ss_olp_opp_fees_about'                        => 'Gebyrer for behandling af onlinebetalinger kan beregnes for kunder, der betaler med kreditkort, ved at bruge deres offentlige fakturalink (inkluderet i faktura-e-mailen).',
    'tt_ss_olp_enable_opp_fees'                       => 'Gebyrer for behandling af onlinebetalinger kan beregnes for kunder, der betaler med kreditkort, ved at bruge deres offentlige fakturalink (inkluderet i faktura-e-mailen). Denne mulighed har en global systemindstilling, men kan også tilsidesættes på individuel klientbasis.',
    'tt_ss_olp_opp_fee_pct'                           => 'Den procentdel af den samlede faktura, der skal opkræves som gebyr for onlinebetalingsbehandling (bekvemmelighed).',
    'tt_ss_olp_opp_fee_name'                          => 'Gebyrnavnet, der skal vises på fakturaen. dvs. \'Kreditkort bekvemmelighedsgebyr\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'En forklaring på gebyret, der skal vises på fakturaen. dvs.',
    'tt_company_profiles_about'                       => 'Virksomhedsprofiler giver dig mulighed for at præsentere din virksomhed forskelligt med hver profil, hvilket giver mulighed for forskellige firmanavne, logoer, fakturaformater osv. Det giver mulighed for at have flere virtuelle virksomheder inden for samme FusionInvoice-installation. En standard virksomhedsprofil skal vælges i Systemindstillinger.',
    'tt_users_about'                                  => 'Du kan oprette brugere af typen Admin (fuld adgang) eller Standard (individuelle systemtilladelser skal gives). Indstilling af \'Tillad klientcenterlogin\' til Ja for en klientpost vil automatisk tilføje en brugerregistrering for klienten, dog kan klientbrugere kun tilføjes ved hjælp af klientindstillingsgrænsefladen.',
    'tt_users_client_about'                           => 'Kundebrugere kan kun logge ind på kundecenteret, hvilket giver dem et begrænset overblik over deres fakturaer, tilbud og betalinger. Hvis du indstiller \'Tillad login til klientcenter\' til Ja for en klientregistrering, vil de give dem adgang til klientcenteret.',
    'tt_user_types_about'                             => 'Admin-brugere har fuld systemadgang. Standardbrugere kan få tildelt de individuelle tilladelser, som de har brug for. Klientbrugere har kun adgang til deres specifikke oplysninger i kundecenteret, og deres mulighed for at logge på er indstillet i klientindstillinger -',
    'tt_custom_fields_about'                          => 'Brugerdefinerede felter giver dig mulighed for at tilføje dine egne datafelter til de fleste moduler. Hvis du havde brug for at fange branchen for kunder, skal du blot tilføje et brugerdefineret felt mærket \'Industri\' på siden Kunder, hvilket gør det til en dropdown-type. Brugerdefinerede felter vises automatisk under de normale felter.',
    'tt_recurring_invoices_about'                     => 'Tilbagevendende fakturaer er faktisk ikke fakturaer, men snarere skabeloner til oprettelse af fremtidige fakturaer. De har en gentagelsesfrekvens og næste dato, som bestemmer, hvornår de vil generere en aktiv faktura. Et dagligt CRON-job eller en planlagt opgave er påkrævet for at tilbagevendende fakturaer fungerer korrekt.',
    'tt_addons_about'                                 => 'Tilføjelser er tilpasninger til FusionInvoice til et unikt forretningsbehov, såsom tidsregistrering, prisformuleringer eller syliserede fakturaskabeloner. De tilbydes gennem FusionInvoice add-on markedsplads.',
    'client_center_user'                              => 'Kundecenterbruger',
    'user_type'                                       => 'Brugertype',
    'custom_field'                                    => 'Brugerdefineret felt',
    'placeholder_type_email_template'                 => 'Indtast eller indsæt din e-mail-skabelon. . .',
    'email_templates'                                 => 'Email skabeloner',
    'payment_receipts'                                => 'Betalingskvitteringer',
    'upcoming_payment_notices'                        => 'Kommende betalingsmeddelelser',
    'convenience_fee_for_credit_card_transactions'    => 'Bekvemmelighedsgebyr for kreditkorttransaktioner',
    'credit_card_processing_fee'                      => 'Kreditkortbehandlingsgebyr',
    'delete_client_user_warning'                      => '<p>Sletning af en klientbruger vil deaktivere deres mulighed for at logge på klientcentret.</p>',
    'use_default_mail_template'                       => 'Standard mailskabelon',
    'use_custom_mail_template'                        => 'Brugerdefineret mailskabelon',
    'quote_email_body'                                => 'Citat Email Body',
    'overdue_invoice_email_body'                      => 'Forfalden faktura e-mail Body',
    'credit_memo_email_body'                          => 'Kreditnota E-mail Brødtekst',
    'payment_receipt_body'                            => 'Betalingskvitteringstekst',
    'invoice_email_body'                              => 'Faktura E-mail Body',
    'quote_custom_email_body_require'                 => 'Indtast venligst din tilpassede e-mail-skabelon for tilbuds-e-mail-tekst',
    'quote_custom_approve_email_body_require'         => 'Indtast venligst din brugerdefinerede e-mail-skabelon for tilbudsgodkendelse af e-mail-tekst',
    'quote_reject_email_body_require'                 => 'Indtast venligst din brugerdefinerede e-mail-skabelon for at afvise e-mail-teksten',
    'overdue_invoice_email_body_require'              => 'Indtast venligst din brugerdefinerede e-mail-skabelon for forfalden faktura e-mail brødtekst',
    'invoice_email_body_require'                      => 'Indtast venligst din tilpassede e-mail-skabelon for e-mail-fakturaens brødtekst',
    'credit_memo_email_body_require'                  => 'Indtast venligst din tilpassede e-mail-skabelon for kreditnota-e-mail-tekst',
    'payment_receipt_email_body_require'              => 'Indtast venligst din tilpassede e-mail-skabelon for betalingskvitterings-e-mail-tekst',
    'upcoming_payment_notice_email_body_require'      => 'Indtast venligst din tilpassede e-mail-skabelon for kommende betalingsmeddelelses-e-mail-tekst',
    'copy_text'                                       => 'Kopier tekst',
    'tt_preview_template'                             => 'Forhåndsvisning skabelon',
    'tt_view_template_code'                           => 'Se skabelonkode',
    'dashboard_date_range'                            => 'Dashboard Datointerval',
    'tt_dashboard_date_range'                         => 'Dashboard Datointerval filtrerer visningen for følgende widgets: KPI-kort, salgsdiagram, seneste klientaktivitet.',
    'product_copy'                                    => 'Produkt kopi',
    'open_selected_client'                            => 'Åbn Valgt klient',
    'save_this_client'                                => 'Gem denne klient (ikke en dublet)',
    'looks_like_duplicate'                            => 'Hmm... Det ligner en dublet',
    'duplicate_instructions'                          => 'Hvis du ser den ønskede klient på listen, skal du vælge og åbne den. Hvis ikke, gem den nye klient.',
    'select_checkbox'                                 => 'Vælg en klient',
    'select_lead_source_tag'                          => 'Vælg kundeemnekilde',
    'lead_source'                                     => 'Blykilde',
    'tt_client_lead_source_tags'                      => 'Vælg eller indtast kundeemnekilde (hvordan kunden blev erhvervet)',
    'your_link_is_expired'                            => 'Ups! Dit link er udløbet.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Tilbage til instrumentbræt</a>.',
    'secure_link_and_expire_link_days'                => 'Sikre og udløb offentlige fakturalinks',
    'secure_link_expire_days'                         => 'Antal dage',
    'tt_secure_link_and_expire_link_days'             => 'Når du aktiverer sikre links, skal du også indstille antallet af dage, hvorefter fakturalinket udløber. Ved at gøre dette kan en klient se deres offentlige fakturalink, indtil det udløber.',
    'expire_time_period'                              => 'Feltet Link Udløb Antal dage er påkrævet',
    'enter_days'                                      => 'Indtast dage',
    'invalid_field_name'                              => 'Indtast venligst et gyldigt feltnavn',
    'lead_source_notes'                               => 'Lead Source Notes',
    'important_note'                                  => 'Vigtig note',
    'social_media_url'                                => 'URL til sociale medier',
    'general_notes'                                   => 'Generelle bemærkninger',
    'payment_amount_mismatch'                         => 'Betalingsbeløb uoverensstemmelse',
    'open_invoice_aging'                              => 'Åbn faktura aldring',
    'tt_db_open_invoice_aging'                        => 'Åbn faktura aldring',
    'current'                                         => 'Nuværende',
    'oneToThirty'                                     => '1-30 dage',
    'thirtyOneToSixty'                                => '31-60 dage',
    'sixtyOneToNinety'                                => '61-90 dage',
    'ninetyOnePlus'                                   => '91 dage',
    'sent_and_draft'                                  => 'Inkluder både sendte og udkast til fakturaer',
    'sent_only'                                       => 'Medtag kun sendte fakturaer',
    'tt_open_ar_aging_settings'                       => 'Indstillinger for åbne fakturaaldringstotaler',
    'tt_client_field_settings'                        => 'Vælg de felter, du gerne vil have vist på din klientvisning',
    'position_change'                                 => 'Stilling ændret',
    'dynamic_width'                                   => 'Dynamisk bredde',
    'full_width'                                      => 'Fuld bredde',
    'save_configuration_default'                      => 'Gem konfigurationen som systemstandard',
    'assign_configuration_other'                      => 'Tildel konfiguration til andre brugere',
    'tt_user_tags'                                    => 'Brugertags',
    'select_users'                                    => 'Vælg Brugere',
    'configuration_assigned'                          => 'Konfigurationen blev tildelt',
    'default_configuration_set'                       => 'Standardkonfigurationen er indstillet',
    'current_user_id'                                 => 'Nuværende bruger-id',
    'tt_users_settings'                               => 'Brugerindstillinger',
    'invoice_link_expire'                             => 'Dit offentlige fakturalink udløber om',
    'quote_link_expire'                               => 'Dit offentlige citatlink udløber om',
    'dashboard_width'                                 => 'Dashboard :widthName kolonnebredde indstilling ændret',
    'unmark_mailed'                                   => 'Fjern markering som afsendt',
    'invoice_unmark_mailed'                           => 'Faktura fjerner markering som afsendt',
    'print_mark_mailed'                               => 'Print',
    'public_link'                                     => 'Offentligt link',
    'tt_sales_chart_settings'                         => 'Indstilling for salgsdiagram faktura/total',
    'verify_key'                                      => 'Produktnøglebekræftelse',
    'enter_key'                                       => 'Indtast din nøgle',
    'verify'                                          => 'Bekræft det!',
    'key_required'                                    => 'Produktnøgle er påkrævet',
    'key_length_invalid'                              => 'Indtast venligst produktnøglen på 32 tegn, der blev leveret på købstidspunktet.',
    'invalid_key'                                     => 'Beklager, din nøgle er ugyldig. Installationen kan ikke fortsætte.',
    'key_verified'                                    => 'Tillykke, din nøgle er blevet bekræftet.',
    'clear_cache'                                     => 'Ryd cache',
    'clear_cache_confirm'                             => 'Er du sikker på, at du vil rydde din applikationscache?',
    'cache_clear_success'                             => 'Cache er ryddet.',
    'cache_clear_error'                               => 'Kontroller venligst din serverkonfiguration for PHP exec()-kommandoen.',
    'add_new_client'                                  => 'Tilføj ny klient',
    'add'                                             => 'Tilføje',
    'invalid_quantity_amount'                         => 'Ugyldigt mængdebeløb! Skal være større end 0.',
    'api_version'                                     => 'API-version',
    '2021_prior'                                      => '2021 og tidligere',
    '2022_later'                                      => '2022 og senere',
    'vendors'                                         => 'Sælgere',
    'file_not_found'                                  => ':file_name blev ikke fundet',
    'leave_empty_no_parent_account'                   => 'efterlad tom, hvis klienten ikke har nogen forældrekonto',
    'leave_empty_client_pays_invoices'                => 'efterlades tom, hvis kunden betaler deres egne fakturaer',
    'modal_not_found'                                 => 'Modal ikke fundet',
    'payment_delete_success'                          => 'Betalingen blev slettet',
    'payment_delete_error'                            => 'Der opstod et problem med at slette betalingen. Prøv venligst igen senere.',
    'status_change_error'                             => 'Noget gik galt! Status blev ikke ændret.',
    'total_payments'                                  => 'Samlede betalinger',
    'licence_verification_error'                      => 'Kan ikke bekræfte din licensnøgle.',
    'line_item_discount_limit'                        => 'Linjeposter må ikke have en rabat på mere end 99,99 %.',
    'date_range_report'                               => 'Datointerval (næste dato at køre)',
    'no_client_found'                                 => 'Hmmm... vi kunne ikke finde den klient.',
    'tt_line_item_discount'                           => 'En linjevarerabat kan beregnes med en procentdel af prisen eller et fast beløb for den enkelte varepris.',
    'functionality_not_available_on_demo'             => 'Beklager, den funktion er ikke tilladt i demoen.',
    'vat_tax_id'                                      => 'moms ID',
    'tt_vat_tax_id'                                   => 'Merværdiafgift (moms) nummer',
    'enable_vat_tax_id'                               => 'Vil du aktivere VAT ID',
    'no-attachment'                                   => 'Der er ingen vedhæftet fil',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Ryd op',
    'allow_edit_status_invoice'                       => 'Rediger :status Faktura',
    'tt_ss_allow_edit_invoices_status'                => 'Som en sikkerhedsforanstaltning må kun fakturaer i Kladdestatus redigeres. Du kan tilsidesætte dette ved at tillade redigering af sendte og/eller betalte fakturaer.',
    'allow_edit_invoices_status'                      => 'Tillad redigering af fakturaer i status',
    'draft_and_sent'                                  => 'Udkast og sendt',
    'draft_or_sent_and_paid'                          => 'Kladde, sendt og betalt',
    'invoice_editable'                                => 'Faktura kan redigeres',
    'can_not_edit_paid_invoice'                       => 'Du kan ikke redigere en betalt faktura',
    'item_category'                                   => 'Varekategori',
    'itemLookups'                                     => 'Vareopslag',
    'quoteItems'                                      => 'Citat varer',
    'invoiceItems'                                    => 'Fakturavarer',
    'imports_disabled_in_demo.'                       => 'Import er deaktiveret i demoen.',
    'no_file_selected'                                => 'Ingen fil valgt',
    'no_import_records'                               => 'Der blev ikke fundet nogen poster at importere',
    'vendor_name'                                     => 'Leverandørnavn',
    'license_key'                                     => 'Licensnøgle',
    'change_license_key'                              => 'Skift licensnøgle',
    'verify_and_save'                                 => 'Verificere',
    'same_key_error'                                  => 'Ingen ændring registreret. Prøv venligst en anden nøgle',
    'trying_invalid_key'                              => 'Beklager, den nøgle kunne ikke bekræftes. Licensnøgle blev ikke ændret.',
    'key_updated'                                     => 'Tillykke! Din licensnøgle blev opdateret.',
    'invalid_date_format'                             => 'Ugyldigt datoformat. Påkrævet format: ÅÅÅÅ-MM-DD',
    'invalid_datetime_format'                         => 'Ugyldigt DateTime-format. Påkrævet format: ÅÅÅÅ-MM-DD TT:MM :SS',
    'profile_setting'                                 => 'Profilindstillinger',
    'include_draft_invoices_unpaid_and_overdue'       => 'Medtag udkast til fakturaer i ubetalte og forfaldne lister',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Hvis indstillet til Ja, vil fakturaer med status som Kladde blive inkluderet i lister og beregninger for forfaldne og ubetalte fakturaer.',
    'tt_utilities_import'                             => 'Importer data fra CSV-filer til din FusionInvoice-database.',
    'tt_utilities_export'                             => 'Eksporter data fra din FusionInvoice-database til en række forskellige formater: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Se logfilen, der indeholder alle e-mail-begivenheder i FusionInvoice.',
    'tt_utilities_system_log'                         => 'Se systemlogfilen, der indeholder fejl- og advarselssystemhændelser.',
    'tt_utilities_tag_cleanup'                        => 'Fjerner tags, der blev defineret, men ikke brugt. Fjerner også eventuelle duplikerede tags.',
    'tt_utilities_pdf_cleanup'                        => 'Fjerner midlertidige PDF-filer.',
    'tt_utilities_recalc_invoices'                    => 'Scanner gennem hver faktura og sikrer, at totalerne matcher summen af alle linjeposter, idet der tages højde for rabatter og skat. *Dette kan tage lang tid.',
    'tt_utilities_recalc_quotes'                      => 'Scanner gennem hvert tilbud og sikrer, at totalerne matcher summen af alle linjeposter, idet der tages højde for rabatter og skat. *Dette kan tage lang tid.',
    'tt_utilities_clear_cache'                        => 'Fjerner midlertidige cache-filer.',
    'tt_utilities_download_database'                  => 'Download en eksporteret databasefil fra dine live FusionInvoice-data. Jo større din database er, jo længere tid vil det tage.',
    'tt_utilities_run_daily_tasks'                    => 'Et CRON-job eller en planlagt opgave kører normalt dine daglige opgaver. Dette giver dig mulighed for at gøre det manuelt. Det genererer levende fakturaer fra tilbagevendende fakturaskabeloner, sender betalingspåmindelser mv.',
    'include_line_item_detail'                        => 'Inkluder linjepostdetaljer',
    'invoice_tags'                                    => 'Fakturamærker',
    'related_accounts'                                => 'Relaterede konti',
    'not_found_related_clients'                       => 'Ingen relaterede kundekonti er blevet tildelt',
    'invoices_paid_for_list'                          => 'Denne kundekonto betaler fakturaer for',
    'child_accounts_exist'                            => 'Tillad indstillingen for børnekonti vendt tilbage til Ja. Kan ikke ændres til Nej, når der findes underordnede konti.',
    'third_bp_accounts_exist'                         => 'Tredjeparts regningsbetaler-indstilling vendt tilbage til Ja. Kan ikke ændres til Nej, når der findes relaterede konti.',
    'tag_name'                                        => 'Tag navn',
    'tag_new_name'                                    => 'Nyt tagnavn',
    'tag_category'                                    => 'Tag kategori',
    'rename_tags'                                     => 'Omdøb tags',
    'apply'                                           => 'ansøge',
    'select_tag_category'                             => 'Vælg Tag Category',
    'tt_utilities_rename_tags'                        => 'Omdøb tags tildelt til kunder, noter, salgsaktiviteter osv.',
    'system_default_dashboard'                        => 'System Standard Dashboard',
    'user_specific_dashboards'                        => 'Brugerspecifikke Dashboards',
    'tt_default_client_type'                          => 'Standard klienttype',
    'default_client_type'                             => 'Standard klienttype',
    'invalid_user'                                    => 'Vælg venligst en gyldig bruger.',
    'create_live_invoice'                             => 'Opret Live Invoice',
    'create_live_invoice_successfully'                => 'Live faktura',
    'create_live_invoice_unsuccessfully'              => 'Live faktura blev ikke oprettet',
    'live_invoice_not_generate'                       => 'Kan ikke generere en aktiv faktura fra en tilbagevendende faktura, der har en stopdato i dag eller tidligere, eller en næste dato mere end 30 dage ude i fremtiden.',
    'data_seeder'                                     => 'Datasåer',
    'select_module'                                   => 'Vælg modul',
    'number_of_seed'                                  => 'Antal frø',
    'seed_it'                                         => 'Frø det!',
    'seeds_success'                                   => 'Frø blev tilføjet',
    'tt_ri_generate_the_next_live_invoice'            => 'Generer den næste aktive faktura for denne tilbagevendende faktura lige nu.',
    'system_log_clear_message'                        => 'Er du sikker på, at du vil rydde systemloggen? Denne handling kan ikke fortrydes, og alle tidligere logfiler vil blive slettet permanent.',
    'system_log_clear_successfully'                   => 'Systemloggen blev ryddet',
    'payment_problem'                                 => 'Der opstod et problem under betalingen. Prøv igen senere.',
    'log_detail'                                      => 'Klik her for at se detaljeret log.',
    'log_limit_message'                               => 'Logfil',
    'log_download_file'                               => 'Download fil',
    'log_delete_all'                                  => 'Slet alle filer',
    'log_level'                                       => 'Niveau',
    'log_context'                                     => 'Sammenhæng',
    'log_date'                                        => 'Dato',
    'log_line_number'                                 => 'Linjenummer',
    'log_content'                                     => 'Indhold',
    'addon_install_error'                             => 'Der er et problem med tilføjelsesinstallationen. Prøv venligst igen senere.',
    'addon_installed_success'                         => 'Addon installeret.',
    'allow_edit_status_credit_memo'                   => 'Rediger anvendt kreditnota',
    'database_seeder'                                 => 'Såmaskine',
    'tt_utilities_database_seeder'                    => 'Seed din database med testdata ved hjælp af frøklasser',
    'vat_information'                                 => 'momsoplysninger',
    'tt_vat_information'                              => 'IBAN bankkontonummer, BIC, e-mail osv ...',
    'explore_addons'                                  => 'Udforsk tilføjelser',
    'available_addons'                                => 'Tilgængelige FusionInvoice-tilføjelser',
    'addon_success'                                   => 'Addon blev tilføjet.',
    'payment_cannot_enabled_in_demo'                  => 'Betalingsgateways kan ikke aktiveres i demoen',
    'confirm_approve_leave_page'                      => 'Der er ikke-gemte ændringer på denne side! Er du sikker på, at du vil forlade uden at gemme?',
    'leave'                                           => 'Forlade',
    'demo_date_refresh'                               => 'Demodata vil blive opdateret om',
    'minutes'                                         => 'minutter',
    'minute'                                          => 'minut',
    'seconds'                                         => 'sekunder',
    'mautic-authentication-fail'                      => 'Du er ikke autoriseret til at få adgang til denne ressource. Brug venligst en gyldig hemmelig nøgle.',
    'something_went_wrong'                            => 'Noget gik galt!',
    'month_to_date'                                   => 'Denne måned til dato',
    'quarter_to_date'                                 => 'Dette kvartal til dato',
    'year_to_date'                                    => 'Dette år',
    'last_active'                                     => 'Sidst aktive',
    'database_seeder_stop'                            => ':name STOP FOR BUSINESS SEEDER',
    'database_seeder_start'                           => ':name BUSINESS SEEDER START',
    'seeder_records_created'                          => ':total Records oprettet med succes for :modal',
    'seeder_credit_apply_invoice'                     => 'Kreditnota gælder på faktura',
    'seeder_quote_approve_reject'                     => 'Citat Godkend og afvis',
    'seeder_executed'                                 => 'Såmaskinen er udført med succes!',
    'seeder_not_executed'                             => 'Seeder blev ikke henrettet!',
    'db_to_file_system_attachments_migration'         => 'Migration af vedhæftede filer - Database til filsystem',
    'attachment_content_count'                        => 'Du er ved at migrere i alt',
    'attachment_repeat_content_count'                 => 'Du er ved at migrere i alt',
    'attachment_key_invalid'                          => 'Den vedhæftede nøgle er ugyldig',
    'stop'                                            => 'Hold op!',
    'attachment_migration_warning'                    => 'Dette trin vil migrere de vedhæftede filer fra din database til dit filsystem. Udfør venligst en komplet databasesikkerhedskopiering, før du fortsætter, og sørg for, at du har tilstrækkelig diskplads til at udføre denne handling.',
    'attachment_agreement_accept'                     => 'Jeg har sikkerhedskopieret min database.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Microsoft 365 adgangskode',
    'office365_username'                              => 'Microsoft 365 brugernavn',
    'custom_date_formula_note1'                       => '<b><u>Standardværdipladsholdere :</span></u></b> ~<br> Du kan bruge <b>i dag, i morgen og i går</b> en hvilken som helst værdi som standard.<br>',
    'custom_date_formula_note2'                       => '<b>For i dag + N dage, brug </b> \'default\': \'+7\' Dette tilføjer 7 dage til dagens dato <br><b>For i dag - N dage, brug </b> \'default\': \'-7\' Dette vil trække 7 dage fra dagens dato <br>',
    'mail_config_error'                               => 'Kan ikke sende en test-e-mail, uden at metoden til afsendelse af e-mail er defineret.',
    'db_prefix_alert'                                 => 'Vi har bemærket, at du bruger et databasepræfiks på :prefix . FusionInvoice vil ikke understøtte databasepræfikser i fremtidige versioner. Rediger venligst din database og omdøb alle dine tabeller ved at fjerne præfikset, rediger derefter din database.php fil og sæt din \'præfiks\' værdi til tom',
    'db_prefix_alert_title'                           => 'Understøttelse af DB-præfikser slutter snart',
    'add_title_bar_shortcut'                          => 'Tilføj genvej til titellinje',
    'title_bar_shortcuts'                             => 'Genveje til titellinjen',
    'select_icon'                                     => 'Vælg ikon',
    'all_payment_method'                              => 'Alle betalingsmetoder',
    'about'                                           => 'Om',
    'own_license'                                     => 'Egen licens',
    'tt_own_license'                                  => 'Egen licens',
    'git_branch'                                      => 'Git nuværende gren',
    'quote_email'                                     => 'Citat Email',
    'custom1'                                         => 'Brugerdefineret 1',
    'custom2'                                         => 'Brugerdefineret 2',
    'custom3'                                         => 'Brugerdefineret 3',
    'default_document_template'                       => 'Standard dokumentskabelon',
    'default_email_template'                          => 'Standard e-mail-skabelon',
    'sms'                                             => 'Sms',
    'pricing_formula'                                 => 'Prisformel',
    'is_mobile'                                       => 'er mobil?',
    'default_sms_template'                            => 'Standard SMS-skabelon',
    'sms_log'                                         => 'SMS log',
    'two_factor_auth'                                 => 'To-faktor-godkendelse',
    'enabled_mail_driver'                             => 'Aktiver venligst e-mail-tjenesten',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Ugyldig bekræftelseskode',
    'otp-subject'                                     => 'Log ind OTP',
    'resend_otp_success'                              => 'Bekræftelseskode sendt igen',
    'resend_otp_btn'                                  => 'Gensend kode',
    'expired_otp'                                     => 'Bekræftelseskode udløbet',
    'token_expired'                                   => 'Dit CSRF-token er udløbet',
    'verification_code'                               => 'Verifikationskode',
    'migration'                                       => 'Migration',
    'invoice_status_change_draft_to_sent'             => 'Fakturastatus ændret fra kladde til sendt',
    'default_sales_quantity'                          => 'Standard salgsmængde',
    'lead_time'                                       => 'Gns. Leveringstid (dage)',
    'primary_vendor_id'                               => 'Foretrukken leverandør',
    'all_items'                                       => 'Alle dele',
    'non_inventory_items'                             => 'Ikke-lagervarer',
    'back_ordered'                                    => 'Rebestilt',
    'low_inventory'                                   => 'Lavt inventar',
    'high_inventory'                                  => 'Højt inventar',
    'merge_client_records'                            => 'Flet klientposter',
    'primary_merge_to_client'                         => 'Flet ind i (behold)',
    'surrogate_merge_from_client'                     => 'Flet fra (kasser)',
    'merge'                                           => 'Fusionere',
    'merge_action'                                    => 'Flet handling',
    'ignore'                                          => 'Ignorere',
    'overwrite'                                       => 'Overskriv',
    'add_to'                                          => 'Tilføj til',
    'select_merge_client'                             => 'Vælg For fletning',
    'client_to_and_from_not_same'                     => 'Kunden til og klienten fra skal være forskellige.',
    'client_id_required'                              => 'Klientvalgsfeltet skal være både obligatorisk og unikt.',
    'is_merge'                                        => 'Fusionere',
    'record_successfully_merged'                      => 'Optagelse blev flettet',
    'service_ends'                                    => 'Tjenesten slutter',
    'service_starts'                                  => 'Service starter',
    'explanation'                                     => 'Forklaring',
    'subscription_details'                            => 'Abonnementsoplysninger',
    'generate_next_invoice'                           => 'Generer næste faktura',
    'subscription'                                    => 'Abonnement',
    'of_the'                                          => 'Af',
    'on'                                              => 'På',
    'invoice_month'                                   => 'Faktura måned',
    'invoice_year'                                    => 'Faktura år',
    'next_month'                                      => 'Næste måned',
    'next_year'                                       => 'Næste år',
    'day'                                             => 'Dag',
    'last_date'                                       => 'Sidste dato',
    'merge_record_warning'                            => 'Hold op! Sammenlægning af kundekonti kan ikke fortrydes. Ud over de felter, som du valgte at overskrive eller tilføje til, vil al transaktionshistorik for flet-fra-klienten blive overført til flet-til-klienten. Er du sikker på, at du vil flette disse kundekonti?',
    'merge_child_account_warning'                     => 'Merge(Fra)-klienten har en overordnet konto med relaterede underordnede konti, som vil blive gentildelt til Merge(To)-klienten. Sørg for, at Merge(To)-klienten er tilladt som en overordnet konto.',
    'merge_parent_account_warning'                    => 'Sammenlægning vil fjerne din tilknytning til den overordnede konto.',
    'merge_invoices_paid_by_warning'                  => 'Sammenlægning vil fjerne din tilknytning til den overordnede faktura betalt af.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Antallet af relationer i klientmodellen er ændret.',
    'payment_terms'                                   => 'Betalingsbetingelser',
    'net_amount_due_in'                               => 'Netto forfaldent beløb',
    'net_amount_due_by'                               => 'Netto forfaldent beløb pr',
    'if_paid_within'                                  => 'hvis der betales inden for',
    'if_paid_by'                                      => 'hvis betalt af',
    'th_of_next_month'                                => 'den næste måned',
    'of_next_month'                                   => 'af næste måned',
    'down_payment'                                    => 'Udbetaling',
    'balance_amount_due_of'                           => 'restbeløb, der forfalder i',
    'payment_split_over'                              => 'Betaling opdelt',
    'installments'                                    => 'rater',
    'days_from_invoice_date'                          => 'dage fra fakturadato',
    'payment'                                         => 'Betaling',
    'one'                                             => 'En',
    'two'                                             => 'To',
    'three'                                           => 'Tre',
    'four'                                            => 'Fire',
    'five'                                            => 'Fem',
    'six'                                             => 'Seks',
    'discount_percent'                                => 'Rabatprocent',
    'discount_days_simple'                            => 'Rabatdage Enkel',
    'discount_days_nth'                               => 'Rabatdage Nth',
    'net_due_days'                                    => 'Netto forfaldsdage',
    'balance_due_days'                                => 'Saldo forfaldsdage',
    'number_of_installments'                          => 'Antal afdrag',
    'payment_term'                                    => 'Betalingsbetingelser',
    'select_payment_term'                             => 'Vælg Betalingsperiode',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Feltet Rabatprocent :index er påkrævet og større end nul.',
        'installment_due_days_error'                  => 'De indgivne afdragsdage :index er påkrævet',
        'discount_percent_gt_error'                   => 'Den indgivne rabatprocent er påkrævet og større end nul.',
        'discount_percent_lt_error'                   => 'Den indgivne rabatprocent er påkrævet og mindre end 100%.',
        'down_payment_percent_lt_error'               => 'Den indgivne udbetalingsprocent er påkrævet og mindre end 100 %.',
        'discount_percent_numeric_error'              => 'Feltet Rabatprocent skal være en numerisk værdi og være mindre end 100 %.',
        'down_payment_gt_error'                       => 'Den indgivne udbetaling er påkrævet og større end nul.',
        'discount_days_gt_net_days_error'             => 'Nettobeløbet for forfaldsdage bør være større end rabatdage.',
        'discount_days_nth_gt_net_days_error'         => 'Nettobeløbet, der skal betales dage, bør være større end Rabat nth dage.',
        'installment_due_days_gt_error'               => 'Forfaldsdage for afdrag :index bør være større end :preIndex afdragsdage.',
        'installment_percent_total_error'             => 'Den samlede afdragsprocent er ikke nøjagtig. den skal være lig med 100 %.',
        'installment_percent_numeric_error'           => 'Den samlede afdragsprocent er ikke nøjagtig. Det skal være en numerisk værdi.',
        'term_discount'                               => 'Terminsrabat',
        'installment_due_days_gt_zero_error'          => 'Forfaldsdagene :index skal være større end eller lig med nul.',
        'net_due_days_error'                          => 'Nettobeløbet til forfaldsdage skal være større end nul og skal indgives.',
        'discount_days_simple_error'                  => 'Rabatdagene simple bør være større end nul og kræves indgivet.',
        'discount_days_nth_error'                     => 'Rabatten N. dage skal være større end nul og kræves indgivet.',
        'balance_due_days_error'                      => 'Forfaldsdagene for saldoen skal være større end nul og skal indgives.',
        'status_error'                                => 'Beklager, status er ikke ændret på grund af den term, der er brugt i fakturaen.',
        'down_payment_type_invoice_description_error' => 'Dit indtastede fakturabeskrivelsestoken stemmer ikke overens med din udbetalingstype.',
        'down_payment_type_quote_description_error'   => 'Dit indtastede tilbudsbeskrivelsestoken stemmer ikke overens med din udbetalingstype.',
    ],
    'quotes_delete_error'                             => 'Citater slette fejl',
    'for'                                             => 'Til',
    'production'                                      => 'Produktion',
    'access_token'                                    => 'Adgangstoken',
    'application_id'                                  => 'Ansøgnings-id',
    'location_id'                                     => 'Lokations-id',
    'fi_config_check'                                 => 'Forudsætningskontrol',
    'requirement'                                     => 'Krav',
    'required'                                        => 'Påkrævet',
    'actual'                                          => 'Faktiske',
    'result'                                          => 'Resultat',
    'db_prefix_setup_alert'                           => 'Din FusionInvoice-database bruger DB-præfikser. Understøttelse af DB-præfikser sluttede med version 2023-3.0. For at fortsætte med at opgradere til denne og fremtidige versioner, kræves det, at du fjerner DB-præfikser. Du kan gøre dette ved at omdøbe alle tabeller i din DB og fjerne præfikset og også indstille værdien \'prefix\' => \'\', i din database.php fil.',
    'open_tasks'                                      => 'Åbn Opgaver',
    'closed_tasks'                                    => 'Lukkede opgaver',
    'select_status'                                   => 'Vælg Status',
    'net_amount_due_invoice'                          => 'Netto forfaldent beløb i :days dage.',
    'days_add_in_current_date'                        => 'Den aktuelle dato pr <span class="text-blue">:date</span> , og forfaldsdato skal betragtes som <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">antal dage</span>.',
    'terms'                                           => 'Betingelser',
    'quote_rejecting_error'                           => 'Faktura # :invoice_number blev oprettet den :invoice_date fra godkendelsen af dette tilbud. Du skal slette eller annullere denne faktura, før du afviser dette tilbud.',
    'resend_record_warning'                           => 'Send denne e-mail igen nu?',
    'resend_email'                                    => 'Send e-mail igen',
    'requirement_check_fail'                          => 'Før installationen kan fortsætte, skal du rette ovenstående fejl.',
    'failed'                                          => 'mislykkedes',
    'subscriptions'                                   => 'Abonnementer',
    'tt_explanation'                                  => 'Indtast en beskrivelse af tjenesten med valgfri datopladsholdere. Du kan bruge følgende tokens til dynamisk at indsætte tjenestens start- og slutdatoer:{{service_starts_on}} og {{service_ends_on}}. Disse vil blive erstattet med de faktiske start- og slutdatoer, når indholdet vises.',
    'tt_ss_invoices_default_payment_terms'            => 'Faktura Standard betalingsbetingelser',
    'invoices_default_terms'                          => 'Fakturaers standardvilkår',
    'net_amount_due_in_n_days'                        => 'Netto forfaldent beløb på N dage',
    'last_day'                                        => 'Sidste dag',
    'down_payment_payment_term1'                      => 'Udbetaling af',
    'down_payment_payment_term2'                      => 'er påkrævet.  Restbeløbet forfalder',
    '1_type'                                          => 'En faktura oprettet i dag forfalder om <span class="text-primary">#N</span> dage',
    '2_type'                                          => 'En faktura oprettet i dag giver mulighed for rabat, hvis den betales inden <span class="text-primary">#date</span> , hvis ikke, forfalder det fulde beløb inden for <span class="text-primary">#N</span>  dage',
    '3_type'                                          => 'En faktura oprettet i dag vil tillade en rabat, hvis den betales inden <span class="text-primary">#date</span>  . Nettobeløbet forfalder inden for <span class="text-primary">#N</span>  dage',
    '4_type'                                          => 'En faktura oprettet i dag vil kræve en udbetaling på <span class="text-primary">#amount</span>  . Den resterende saldo forfalder inden for <span class="text-primary">#N</span>  dage',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>En faktura oprettet i dag og fordelt på <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Betaling <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Forfald <span class="text-primary">#date</span></p>',
    'installment'                                     => 'rate',
    'apply_payment_terms'                             => 'Anvend betalingsbetingelser rabatbeløb',
    'payable_amount'                                  => 'Endeligt udbetalt beløb',
    'payable_amount_lt_error'                         => 'Det endelige beløb skal være mindre end fakturasaldoen.',
    'payment_term_type_4_amount'                      => 'Delbetaling af :amount accepteres',
    'net_terms'                                       => 'Nettovilkår',
    'proforma_invoice_default'                        => 'Proforma faktura standard',
    'expense_vendor'                                  => 'Udgiftsleverandør',
    'expense_vendor_deleted'                          => 'Udgiftsleverandør blev slettet',
    'expense_vendor_already_used'                     => 'Du kan ikke slette en leverandør, der har relaterede udgiftsposter.',
    'total_must_be_gt_zero'                           => 'Summen af :modal_name skal være større end nul.',
    'payment_failed'                                  => 'Betaling mislykkedes med :error',
    'xss_validation'                                  => 'Feltet :attribute indeholder tags, der kan afsløre en XSS-sårbarhed',
    'support_desk'                                    => 'Support Desk',
    'choose_file'                                     => 'Vælg fil',
    'supportTicket'                                   => 'Support Desk',
    'create_support_ticket'                           => 'Opret supportbillet',
    'supportTicket_inbox_view'                        => 'Support Desk',
    'support_ticket'                                  => 'Support billet',
    'ticket_number'                                   => 'Billetnummer',
    'revision'                                        => 'Revision',
    'revisions'                                       => 'Revisioner',
    'recurring_invoices'                              => 'Tilbagevendende fakturaer',
    'message'                                         => 'Besked',
    'custom_img'                                      => 'Brugerdefineret billede',
    'please_fill_some_data'                           => 'Udfyld venligst de nødvendige data på den nye vare.',
    'assigned'                                        => 'Tildelt',
    'add_ons_will_be_disabled'                        => 'FØLGENDE TILFØJELSER BLIVE DEAKTIVERET:',
    'add_ons_will_be_disabled_msg'                    => 'Alle tilføjelser deaktiveres automatisk under en kerneopgradering af FusionInvoice. Når denne opgradering er færdig, skal du sørge for at downloade de relevante tilføjelses-zip-filer og installere dem. Når du har gjort det, kan du genaktivere dem fra menuen Systemindstillinger, Tilpasninger, Tilføjelser og vælge [Installer].',
    'price_not_valid'                                 => 'Prisen skal være større end nul',
    'free_space'                                      => 'Fri plads',
    'expense_type'                                    => 'Udgiftstype',
    'standard_expense'                                => 'Standardudgift',
    'expense_with_deductible_tax'                     => 'Udgift med fradragsberettiget skat',
    'remittance_to_tax_authority'                     => 'Overførsel til Skattestyrelsen',
    'tax_paid'                                        => 'Skat betalt',
    'tax_detail'                                      => 'Skattedetaljer',
    'select_expense_type'                             => 'Vælg Udgiftstype',
    'taxes_paid_on_expenses_or_remitted'              => 'Skatter betalt af udgifter eller eftergivet',
    'tax_name'                                        => 'Skat Navn',
    'last_activity'                                   => 'Sidste aktivitet',
    'select_default_company_profile'                  => 'Vælg venligst din standard virksomhedsprofil',
    'mn_sales_tax'                                    => 'MN omsætningsafgift',
    'taxes_collected_on_sales'                        => 'Skatter opkrævet ved salg',
    'vatgst_tax_note'                                 => 'Ja beregner afgiften som værende inkluderet i varetotalen. Nej vil lægge afgiften til varetotalen.',
    'tt_vatgst_tax'                                   => 'I dette eksempel vil vi antage en afgiftssats på 5 % og en varepris på 100 USD. Indstilling af Aktiver moms/GST til Ja vil give en faktura i alt på 100 USD, hvor varebeløbet justeres til 95,24 USD og et afgiftsbeløb på 4,76 USD. Indstilling af moms/GST til Nej vil give en faktura i alt på $105, med en varepris på $100 og en afgift på $5.',
    'level_of_detail'                                 => 'Detaljeringsniveau',
    'tax_report'                                      => 'Skatterapport',
    'detail'                                          => 'Detalje',
    'totals'                                          => 'Totaler',
    'totals_with_dots'                                => 'Totaler . . .',
    'yes_all'                                         => 'Ja (alle)',
    'invoices_only'                                   => 'Kun fakturaer',
    'payment_receipts_only'                           => 'Kun betalingskvitteringer',
    'role'                                            => 'Rolle',
    'previous_email'                                  => 'Tidligere e-mail',
    'web_store_user_id'                               => 'Webbutik-bruger-id: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Nettobeløb, der skal betales inden <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'En rabat på #DISCOUNTPERCENT % kan tages ved betaling inden <span class="text-info">#DISCOUNTDATE</span> , ellers forfalder nettobeløbet til <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'En rabat på #DISCOUNTPERCENT % kan tages ved betaling inden <span class="text-info">#DISCOUNTDATE</span> , ellers forfalder nettobeløbet til <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'En udbetaling på <span class="text-info">#DOWNPAYMENT</span>  er den #INVOICEDATE . Saldoen forfalder til <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Betalinger kan deles over <span class="text-info">#NUMBEROFINSTALLMENTS</span> rater</p>',
        '5_1_type'     => '<li>Betaling <span class="text-info">#PERCENT %</span> forfalder <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Næste måned har i alt #N dage, så indtast venligst en værdi mellem 1 og #N for rabatten næste månedsdage.</span>',
    ],
    'payment_term_not_selected'                       => 'Betalingsperiode ikke valgt',
    'confirm'                                         => 'Bekræfte',
    'create_live_invoice_now'                         => 'Opret live faktura nu?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Et abonnement er som en fakturaskabelon, der bliver brugt til at oprette aktive fakturaer med en given frekvens.</p><p class="m-0"> Normalt et CRON-job eller en planlagt opgave er sat op til at køre én gang om dagen, og er ansvarlig for at tjekke for aktive fakturaer, der skal oprettes, baseret på abonnementets Generate Next Invoice-dato-felt.  Hvis denne datoværdi er i dag eller tidligere end i dag, oprettes der automatisk en aktiv faktura.</p><p class="m-0"> Denne mulighed giver dig mulighed for manuelt at oprette den aktive faktura fra abonnementet, uden at den automatiserede metode . Vil du oprette den aktive faktura nu?</p>',
    'contact'                                         => 'Kontakt',
    'invoice_month_plus_one'                          => 'Fakturamåned +1',
    'invoice_month_plus_two'                          => 'Fakturamåned +2',
    'invoice_month_plus_three'                        => 'Fakturamåned +3',
    'inbound_email'                                   => 'Indgående e-mail',
    'outbound_email'                                  => 'Udgående e-mail',
    'email_signature'                                 => 'E-mail signatur',
    'mail_credential_error'                           => 'Ugyldig e-mail-konfiguration. Tjek venligst dine indstillinger og prøv igen. <strong>( Konfiguration <i class="fa fa-arrow-alt-circle-right"> </i> Systemindstillinger <i class="fa fa-arrow-alt-circle-right"> </i> E-mail )</strong>',
    'tt_generate_next_invoice'                        => 'Datoen for, hvornår den næste direkte faktura oprettes automatisk fra dette abonnement.',
    'tt_stop_date'                                    => 'Den datogrænse, hvorefter der ikke automatisk genereres flere aktive fakturaer for dette abonnement. Lad dette felt være tomt for et abonnement, der skal fortsætte for evigt.',
    'description_template'                            => 'Beskrivelse skabelon',
    't_1_description'                                 => 'Fuld betaling skal betales senest #LASTDATE.',
    't_2_description'                                 => 'Tag en #DISCOUNTPERCENT % rabat, hvis du betaler inden #DISCOUNTDATE, ellers betales det fulde fakturabeløb inden #LASTDATE.',
    't_3_description'                                 => 'Tag en #DISCOUNTPERCENT % rabat, hvis du betaler inden #DISCOUNTDATE, ellers betales det fulde fakturabeløb inden #LASTDATE.',
    't_4_description'                                 => 'En udbetaling på #DOWNPAYMENT forfalder den #INVOICEDATE, resten af fakturaen forfalder til #LASTDATE',
    't_4_1_description'                               => 'En udbetaling på #DOWNPAYMENTPERCENT forfalder den #INVOICEDATE, resten af fakturaen forfalder til #LASTDATE',
    't_5_description'                                 => 'Betalingerne skal foretages i #NUMBEROFINSTALLMENTS lige store rater',
    't_5_type_description'                            => 'Betaling #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT forfalder #LASTDATE',
    'tokens_allowed'                                  => 'Poletter tilladt',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Den evaluerede tekst fra skabelonen er termbeskrivelsen, der vises på dokumenter som faktura, tilbud osv.',
    'cc_mail'                                         => 'CC Mail',
    'assigned_inv_sent_or_paid'                       => '*Der er fakturaer, der er blevet betalt eller sendt, som har denne betalingsperiode tildelt. Det er ikke tilladt at ændre â€˜Typeâ€™-oplysningerne.',
    'exclude_paid_invoices'                           => 'Ekskluder betalte fakturaer',
    'phone_number_numeric_error'                      => 'Telefonnummeret skal være et nummer.',
    'phone_num_same_country_code_error'               => 'Sørg for, at dit telefonnummer er korrekt formateret. Det ser ud til at være indtastet startende med landekoden, hvilket ikke er tilladt.',
    'tt_expense_amount'                               => 'Indtast det samlede beløb for udgiften, inklusive skat. Dette felt er ikke tilgængeligt, når du overfører en skattebetaling til en skattemyndighed.',
    'tt_expense_tax_paid_deductible'                  => 'Indtast det afgiftsbeløb, der blev betalt med denne udgift. Denne værdi vil blive trukket fra din samlede skattepligt på skatteoversigten og skattedetaljerapporterne.',
    'tt_expense_tax_paid_remittance'                  => 'Indtast det afgiftsbeløb, der blev overført til skattemyndigheden. Dette bruges til at registrere betalinger foretaget for opkrævet skatter på dine betalte fakturaer.',
    'tt_expense_client'                               => 'Hvis denne udgift udelukkende er afholdt på vegne af en kunde, og du ønsker at fakturere dem for den, skal du vælge den relaterede kunde her.',
    'base_currency_not_deleted'                       => 'Basisvaluta kan ikke slettes',
    'used_currency_modal_error'                       => 'Valuta er allerede brugt i modulet :modal_names.',
    'addon_uninstall_success'                         => 'Addon blev afinstalleret',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revision (nuværende)',
    'number'                                          => 'Nummer',
    'copy_process_error'                              => 'Ups! Det ser ud til, at der var et hikke under kopieringsprocessen. Prøv igen senere.',
    'tt_captcha_image'                                => 'CAPTCHA billede',
    'reload_page'                                     => 'Genindlæs venligst siden',
    'discount_limit'                                  => 'Rabat skal være mindre end 99,99 %.',
    'tooltip'                                         => 'Værktøjstip',
    'authorization_error'                             => 'Du er ikke autoriseret til at udføre denne handling.',
    'reset_to_default'                                => 'Nulstil til standard',
    'reset_to_default_warning'                        => '<p>Dette vil nulstille emnet og brødteksten til standardværdien for :model . Blive ved?</p>',
    'reset_default_mail_template'                     => 'Standardmailskabelonen for :model er blevet nulstillet.',
    'overdue_invoice'                                 => 'Forfalden faktura',
    'total_cannot_be_lt_zero'                         => 'Totalen :modal_name må ikke være mindre end nul.',
    'addons_disabled_during_setup'                    => 'Under opgraderingsprocessen blev følgende tilføjelser deaktiveret: :addons . Glem ikke at aktivere dem nu, hvor opgraderingen er fuldført.',
    'allow_payments_on_quotes'                        => 'Tillad betalinger på tilbud J/N',
    'allow_payments_on_quote'                         => 'Tillad betaling J/N',
    'tt_ss_quotes_is_payable'                         => 'Hvis den er aktiveret, vil en Betal nu-knap efter godkendelse af tilbud vises på tilbuddets offentlige linkvisning. Der oprettes automatisk en faktura, og betalingen vil blive påført fakturaen.',
    'pay_with_square'                                 => 'Betal med kvadrat',
    'validation_mess_for_is_payable_quote'            => 'Indstillingen til automatisk at konvertere tilbud til faktura, når kunden godkender, er påkrævet, når Tillad betalinger på tilbud er indstillet til \'Ja\'.',
    'client_requirement_msg'                          => 'Opret en klient, før du tilføjer :seed_name',
    'quote_add_items'                                 => 'Der kræves tilbudsvarer, og status er ikke annulleret',
    'invalid_quote_id'                                => 'Ugyldigt tilbuds-id',
    'information_header'                              => 'Tillykke, du er ved at spare nogle penge!',
    'convenience_charge'                              => 'Convenience Charge',
    'credit_card_fee_message'                         => 'Der vil være et kreditkortgebyr på :charge på denne transaktion.',
    'info_payment_term_type_2'                        => 'Selvom din fakturasaldo er :ORIGINAL_AMOUNT, er du berettiget til en betalingsvilkårsrabat på :DISCOUNT_PERCENT %, hvilket vil reducere dit betalingsbeløb til :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Selvom din fakturasaldo er :ORIGINAL_AMOUNT, er du berettiget til en rabat på betalingsvilkår på :DISCOUNT_PERCENT %, hvilket vil reducere dit betalingsbeløb til :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Selvom din fakturasaldo er :ORIGINAL_AMOUNT, er du berettiget til betalingsbetingelser for at betale en udbetaling :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Selvom din fakturasaldo er :ORIGINAL_AMOUNT, er du berettiget til betalingsbetingelser for at betale en ratebetaling :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Betalingsbetingelser skal fjernes fra :modal før sletning.',
    'default_payment_term_warn'                       => '*Du kan kun ændre navn og nettoforfaldsdage for <strong>Systemets standardbetalingsbetingelser</strong>.',
    'quote_rejected_not_payable'                      => 'Citat # :number er blevet afvist og skal ikke betales på grund af dets status.',
    'could_not_delete'                                => 'Kunne ikke slette',
    'convenience_charges_calculation_fail'            => 'Fejl: Beregning af bekvemmelighedsgebyrer mislykkedes under migreringen. Prøv igen senere.',
    'sign_in_welcome_message'                         => 'ðŸš€ Tillykke! Din FusionInvoice blev installeret med succes! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Din FusionInvoice er blevet opgraderet fra version :old_version til version :new_version .</p><p> For en detaljeret oversigt over alle de nye funktioner og forbedringer, se venligst vores <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">udgivelsesbemærkninger</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Tak, fordi du valgte FusionInvoice. Din tillid, støtte og feedback driver vores innovation.</p><p class="m-0 text-bold">God fakturering!</p><p class="text-bold">FusionInvoice-teamet</p >',
    'tt_gen_skin_user_profile'                        => 'Ændring af denne værdi indstiller KUN systemets standard for nye brugere. Brugere kan tilsidesætte denne indstilling gennem deres brugerprofilindstillinger.',
    'description_template_invoice'                    => 'Beskrivelsesskabelon - Faktura',
    'description_template_quote'                      => 'Beskrivelsesskabelon - Citat',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Fuld betaling forfalder inden for #NETDAYS fra fakturadatoen.',
    't_2_description_for_quote'                       => 'Tag en #DISCOUNTPERCENT % rabat, hvis du betaler inden for #DISCOUNTDAYS, ellers betal det fulde tilbudsbeløb med #NETDAYS.',
    't_3_description_for_quote'                       => 'Tag en #DISCOUNTPERCENT % rabat, hvis du betaler inden #NTHDAY i den næste måned, ellers betales det fulde fakturabeløb inden for #NETDAYS dage.',
    't_4_description_for_quote'                       => 'En udbetaling på #DOWNPAYMENT forfalder på fakturadatoen, den resterende saldo forfalder inden for #NETDAYS dage',
    't_4_1_description_for_quote'                     => 'En udbetaling på #DOWNPAYMENTPERCENT forfalder på fakturadatoen, den resterende saldo forfalder inden for #NETDAYS dage',
    't_5_description_for_quote'                       => 'Betalingerne skal foretages i #NUMBEROFINSTALLMENTS lige store rater',
    't_5_type_description_for_quote'                  => 'Betaling #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT forfalder #INSTALLMENTDUEDAYS dage fra fakturadatoen',
    'default_term'                                    => 'Standardperiode',
    'proceed_to_payment'                              => 'Fortsæt til betaling',
    'version_upgraded'                                => 'Din ansøgning er opdateret.',
    'term_amount_gt_payment_amount'                   => 'Beløbet skal være større end rabatbeløbet for betalingsbetingelserne',
    'payment_term_not_eligible_warning'               => 'Betalingsterminsrabatten er kun tilgængelig for fuld betaling. Desværre er du ikke kvalificeret til det.',
    'processed_by_user'                               => '<strong>Behandlet af:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Betalingsmetode:</strong> :method',
    'all_methods'                                     => 'Alle metoder',
    'this_payment'                                    => 'Denne betaling',
    'previous_balance'                                => 'Forrige balance',
    'payment_applied_with_remaining_balance'          => '<p><strong>Din betaling på :amount er blevet delvist anvendt. :remaining_balance forbliver udestående.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Der er modtaget en forudbetaling på :amount for fremtidige fakturaer den :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Din betaling :amount er blevet anvendt fuldt ud.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Betaling <span style="background: #d2d6de;border-radius: 2px;polstring: 0 8px;"> :formatted_number</span> ~ Detaljer:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Betaling af :paid er påført Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Betaling af :paid, minus :payment_terms_discount betalingsterminsrabat, er anvendt på Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Betaling af :paid, plus :convenience_charges convenience charges, er blevet påført Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Betaling af :paid, plus :convenience_charges convenience charges og minus :payment_terms_discount betalingsterminsrabat, er blevet anvendt på Faktura :invoice_number den :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Den resterende saldo på Faktura :invoice_number er :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Ubetalte fakturaer',
    'include'                                         => 'Omfatte',
    'exclude'                                         => 'Udelukke',
    'invoice_with_no_tax'                             => 'Fakturaer uden moms',
    'tax_total'                                       => 'Skat i alt',
];

return TranslationOverride::override(__FILE__, $translations);
