<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Nastavení úctu',
    'active'                                          => 'Aktivní',
    'activity'                                        => 'Aktivita',
    'activity_invoice_paid'                           => 'Faktura <a href=":link">#:number</a> byla zaplacena.',
    'activity_invoice_viewed'                         => 'Faktura <a href=":link">#:number</a> byla zobrazena.',
    'activity_quote_approved'                         => 'Nabídka <a href=":link">#:number</a> byla prijata.',
    'activity_quote_rejected'                         => 'Nabídka <a href=":link">#:number</a> byla odmítnuta.',
    'activity_quote_viewed'                           => 'Nabídka <a href=":link">#:number</a> byla zobrazena.',
    'add_item'                                        => 'Pridat položku',
    'add_line_item_to_invoice'                        => 'Pridat položku',
    'add_note'                                        => 'Pridat poznámku',
    'additional'                                      => 'Další',
    'addon'                                           => 'Doplnek',
    'addons'                                          => 'Doplnky',
    'address'                                         => 'Adresa',
    'address_format'                                  => 'Formát adresy',
    'after_amount'                                    => 'Po cástce',
    'all'                                             => 'Všechno',
    'all_categories'                                  => 'Všechny kategorie',
    'all_statuses'                                    => 'Všechny stavy',
    'all_time'                                        => 'Vše',
    'all_vendors'                                     => 'Všichni prodejci',
    'allow_login'                                     => 'Povolit prihlášení',
    'always_attach_pdf'                               => 'Vždy pripojit PDF',
    'always_bcc'                                      => 'Vždy BCC adresa',
    'always_cc'                                       => 'Vždy adresa CC',
    'amount'                                          => 'Cástka',
    'api_public_key'                                  => 'Verejný klíc API',
    'api_secret_key'                                  => 'Tajný klíc API',
    'approve'                                         => 'Schválit',
    'approved'                                        => 'Schváleno',
    'approved_quotes'                                 => 'Schválené nabídky',
    'attach_files'                                    => 'Pripojit soubory',
    'attach_pdf'                                      => 'Pripojte PDF',
    'attachment'                                      => 'Príloha',
    'attachments'                                     => 'Prílohy',
    'author'                                          => 'Autor',
    'automatic'                                       => 'Automatický',
    'automatic_email_on_recur'                        => 'Automaticky zasílat opakované faktury e-mailem',
    'automatic_email_payment_receipts'                => 'Automaticky zasílat potvrzení o platbách e-mailem',
    'available_fields'                                => 'Dostupná pole',
    'back'                                            => 'Zpet',
    'back_to_invoice'                                 => 'Zpet na fakturu',
    'back_to_quote'                                   => 'Zpet na nabídku',
    'balance'                                         => 'Zustatek',
    'base_currency'                                   => 'Základní mena',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Pred cástkou',
    'bill_this_expense'                               => 'Vyúctujte tyto náklady',
    'bill_to'                                         => 'Bill To',
    'billable'                                        => 'Fakturovatelné',
    'billed'                                          => 'Úctováno',
    'billing_address'                                 => 'Fakturacní adresa',
    'billing_city'                                    => 'Fakturacní mesto',
    'billing_name'                                    => 'Fakturacní jméno',
    'billing_state'                                   => 'Stát fakturace',
    'billing_zip'                                     => 'Fakturacní PSC',
    'binary_path'                                     => 'Binární cesta',
    'body'                                            => 'Telo',
    'cancel'                                          => 'Zrušit',
    'canceled'                                        => 'Zrušeno',
    'card_number'                                     => 'Císlo karty',
    'cash'                                            => 'Hotovost',
    'category'                                        => 'Kategorie',
    'cc'                                              => 'CC',
    'change'                                          => 'Zmenit',
    'change_client'                                   => 'Zmenit klienta',
    'check_for_update'                                => 'Zkontrolovat aktualizace',
    'city'                                            => 'Mesto',
    'clear_keys'                                      => 'Vymazat klíce',
    'client'                                          => 'Klient',
    'client_form'                                     => 'Klientský formulár',
    'client_name'                                     => 'Jméno klienta',
    'client_not_found'                                => 'Klient nebyl nalezen',
    'client_statement'                                => 'Prohlášení klienta',
    'client_unique_name_option_1'                     => 'Pouze v prípade, že jméno klienta není jedinecné',
    'client_unique_name_option_2'                     => 'Vždy zobrazit',
    'client_visibility'                               => 'Viditelnost klienta',
    'clients'                                         => 'Klienti',
    'code'                                            => 'Kód',
    'column_name'                                     => 'Název sloupce',
    'column_width'                                    => 'Šírka sloupce',
    'company'                                         => 'Spolecnost',
    'complete'                                        => 'Kompletní',
    'complete_upgrade'                                => 'Dokoncete upgrade',
    'compound'                                        => 'Sloucenina',
    'compound_tax_note'                               => 'Složené danové sazby musí být aplikovány na položku jako dan 2, aby mel požadovaný úcinek.',
    'confirm_approve_quote'                           => 'Opravdu chcete tuto nabídku schválit?',
    'confirm_reject_quote'                            => 'Opravdu chcete tuto nabídku odmítnout?',
    'continue'                                        => 'Pokracovat',
    'convert_quote_option1'                           => 'Faktura by mela zachovat podmínky z nabídky',
    'convert_quote_option2'                           => 'Faktura by mela používat výchozí podmínky faktury',
    'convert_quote_setting'                           => 'Když je nabídka prevedena na fakturu',
    'convert_quote_when_approved'                     => 'Po schválení klientem automaticky prevést nabídku na fakturu',
    'converted_from_quote'                            => 'Prevedeno z nabídky',
    'converted_to_invoice'                            => 'Prevedeno na fakturu',
    'country'                                         => 'Zeme',
    'create_invoice'                                  => 'Vytvorit fakturu',
    'create_quote'                                    => 'Vytvorit nabídku',
    'created'                                         => 'Vytvoreno',
    'credit_card'                                     => 'Kreditní karta',
    'currencies'                                      => 'Meny',
    'currency'                                        => 'Mena',
    'currency_form'                                   => 'Menový formulár',
    'currency_symbol'                                 => 'Symbol meny',
    'currency_symbol_placement'                       => 'Umístení symbolu meny',
    'custom_date_range'                               => 'Vlastní casové období',
    'custom_field_form'                               => 'Vlastní formulár pole',
    'custom_fields'                                   => 'Vlastní pole',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Nástenka',
    'dashboard_totals_option'                         => 'Soucty na nástence by mely zahrnovat',
    'database_not_configured'                         => 'Zdá se, že app / config / database.php ješte nebyl nakonfigurován.',
    'database_setup'                                  => 'Nastavení databáze',
    'date'                                            => 'Datum',
    'date_format'                                     => 'Datový formát',
    'days'                                            => 'Dny',
    'decimal_point'                                   => 'Desetinná cárka',
    'default_currency'                                => 'Výchozí mena',
    'default_footer'                                  => 'Výchozí zápatí',
    'default_group'                                   => 'Výchozí skupina',
    'default_invoice_email_body'                      => 'Výchozí telo e-mailu s fakturou',
    'default_invoice_template'                        => 'Výchozí šablona faktury',
    'default_item_tax_2_rate'                         => 'Výchozí sazba dane za zboží 2',
    'default_item_tax_rate'                           => 'Výchozí sazba dane za zboží',
    'default_overdue_invoice_email_body'              => 'Výchozí text e-mailu po splatnosti',
    'default_payment_receipt_body'                    => 'Výchozí telo potvrzení o platbe',
    'default_quote_email_body'                        => 'Výchozí nabídka Text e-mailu',
    'default_quote_template'                          => 'Výchozí šablona nabídky',
    'default_terms'                                   => 'Výchozí podmínky',
    'delete'                                          => 'Vymazat',
    'delete_client_warning'                           => '<p>STOP! Pokud odstraníte tohoto klienta, smažete také VŠECHNY jeho transakce, vcetne faktur, nabídek a plateb.</p><p>Opravdu chcete tohoto klienta trvale smazat?</p>',
    'delete_record_warning'                           => 'Opravdu chcete tento záznam smazat?',
    'description'                                     => 'Popis',
    'details'                                         => 'Detaily',
    'disabled'                                        => 'Zakázáno',
    'discount'                                        => 'Sleva',
    'display_client_unique_name'                      => 'Zobrazit jedinecné jméno klienta',
    'display_do_not_require'                          => 'Zobrazit, ale nevyžadují',
    'display_order'                                   => 'Zobrazit objednávku',
    'display_profile_image'                           => 'Zobrazit profilový obrázek',
    'do_not_add_line_item_to_invoice'                 => 'Nepridávejte do faktury rádkovou položku',
    'do_not_display'                                  => 'Nezobrazovat',
    'documentation'                                   => 'Dokumentace',
    'download'                                        => 'Stažení',
    'draft'                                           => 'Návrh',
    'draft_invoices'                                  => 'Koncepty faktur',
    'draft_quotes'                                    => 'Koncepty nabídek',
    'dropdown'                                        => 'Rozevírací seznam',
    'due'                                             => 'Splatnost',
    'due_date'                                        => 'Datum splatnosti',
    'edit'                                            => 'Upravit',
    'edit_client'                                     => 'Upravit klienta',
    'email'                                           => 'E-mail',
    'email_address'                                   => 'E-mailová adresa',
    'email_invoice'                                   => 'E-mailová faktura',
    'email_payment_receipt'                           => 'E-mail s potvrzením platby',
    'email_quote'                                     => 'Nabídka e-mailu',
    'email_send_method'                               => 'Metoda odesílání e-mailu',
    'email_send_method_phpmail'                       => 'Pošta PHP',
    'email_send_method_sendmail'                      => 'Poslat mail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Povoleno',
    'enter_payment'                                   => 'Zadejte platbu',
    'error'                                           => 'Chyba',
    'every'                                           => 'Každý',
    'exchange_rate'                                   => 'Smenný kurz',
    'exchange_rate_mode'                              => 'Režim smenného kurzu',
    'expense_form'                                    => 'Formulár výdaju',
    'expenses'                                        => 'Výdaje',
    'expiration'                                      => 'Vypršení',
    'expires'                                         => 'Vyprší',
    'export_clients'                                  => 'Exportovat klienty',
    'export_data'                                     => 'Export dat',
    'export_expenses'                                 => 'Výdaje na vývoz',
    'export_invoice_items'                            => 'Exportovat položky faktury',
    'export_invoices'                                 => 'Exportovat faktury',
    'export_payments'                                 => 'Exportovat platby',
    'export_quote_items'                              => 'Exportovat položky nabídky',
    'export_quotes'                                   => 'Exportovat nabídky',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Císlo faxu',
    'field_label'                                     => 'Štítek pole',
    'field_meta'                                      => 'Field Meta',
    'field_meta_description'                          => 'Pole Field Meta použijte, pouze pokud je rozevíracím seznamem Field Type. Chcete-li urcit hodnoty rozevíracího seznamu, zadejte seznam hodnot rozevíracího seznamu oddelených cárkami.',
    'field_type'                                      => 'Typ pole',
    'footer'                                          => 'Zápatí',
    'format'                                          => 'Formát',
    'frequency'                                       => 'Frekvence',
    'from'                                            => 'Od',
    'from_date'                                       => 'Od data',
    'general'                                         => 'Všeobecné',
    'generate_keys'                                   => 'Generovat klíce',
    'group'                                           => 'Skupina',
    'group_form'                                      => 'Skupinový formulár',
    'groups'                                          => 'Skupiny',
    'header_title_text'                               => 'Text nadpisu záhlaví',
    'help'                                            => 'Pomoc',
    'help_currency_code'                              => 'Kód meny, napr.',
    'help_currency_name'                              => 'Název meny, napr.',
    'help_currency_symbol'                            => 'Symbol meny, napr.',
    'help_currency_symbol_placement'                  => 'Kam umístit symbol meny.',
    'help_text_client_name'                           => 'Touto hodnotou muže být název spolecnosti nebo osoby a objeví se na nabídkách a fakturách. Tato hodnota nemusí být jedinecná.',
    'help_text_client_password'                       => 'Pokud nevytvoríte nebo neobnovíte heslo, ponechte toto pole prázdné.',
    'help_text_client_unique_name'                    => 'Když jeden nebo více klientu v systému sdílí stejný název, je treba zadat jedinecný název, který je bude odlišovat. Tato hodnota se neobjeví na nabídkách ani na fakturách.',
    'i_accept'                                        => 'Prijímám',
    'import_data'                                     => 'Importovat data',
    'inactive'                                        => 'Neaktivní',
    'income'                                          => 'Príjem',
    'install'                                         => 'Nainstalujte',
    'installation_complete'                           => 'Instalace dokoncena',
    'installing_please_wait'                          => 'Instalace, cekejte prosím ...',
    'invalid_credentials'                             => 'Neplatná poverení',
    'invoice'                                         => 'Faktura',
    'invoice_default'                                 => 'Výchozí faktura',
    'invoice_email_subject'                           => 'Predmet e-mailu s fakturou',
    'invoice_items'                                   => 'Položky faktury',
    'invoice_number'                                  => 'Císlo faktury',
    'invoice_summary'                                 => 'Prehled faktur',
    'invoiced'                                        => 'Fakturováno',
    'invoices'                                        => 'Faktury',
    'invoices_due_after'                              => 'Faktury splatné po (dnech)',
    'issued'                                          => 'Vydáno',
    'item'                                            => 'Položka',
    'item_lookup_form'                                => 'Formulár pro vyhledávání položek',
    'item_lookups'                                    => 'Vyhledávání položek',
    'item_sales'                                      => 'Prodej zboží',
    'items'                                           => 'Položky',
    'label_invoice'                                   => 'Vyberte fakturu, do které chcete pridat tento výdaj',
    'label_item_description'                          => 'Zadejte popis tohoto nákladu (nepovinné)',
    'label_item_name'                                 => 'Zadejte název rádkové položky, kterou chcete pridat na fakturu',
    'landscape'                                       => 'Krajina',
    'language'                                        => 'Jazyk',
    'left_pad'                                        => 'Levá podložka',
    'left_pad_description'                            => 'Pocet nul, které volitelne mají vlevo, doplnit další císlo.',
    'legal'                                           => 'Právní',
    'letter'                                          => 'Dopis',
    'license_agreement'                               => 'Licencní smlouva',
    'license_agreement_accept'                        => 'Souhlasím s podmínkami licencní smlouvy',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Zdá se, že váš tajný klíc byl zmenen od posledního uložení e-mailového hesla. Chcete-li tuto chybu opravit, prejdete do Nastavení systému -',
    'manual'                                          => 'Manuál',
    'map_fields_to_import'                            => 'Mapujte pole k importu',
    'merchant_api_key'                                => 'Klíc API',
    'merchant_api_password'                           => 'Heslo API',
    'merchant_api_username'                           => 'Uživatelské jméno API',
    'merchant_publishable_key'                        => 'Publikovatelný klíc',
    'merchant_secret_key'                             => 'Tajný klíc',
    'merchant_signature'                              => 'Podpis',
    'mobile'                                          => 'Mobil',
    'mobile_number'                                   => 'Císlo mobilního telefonu',
    'monthly'                                         => 'Mesícne',
    'months'                                          => 'mes.',
    'multiple_email_validation'                       => 'Více e-mailových adres by melo být platných a oddelených cárkami.',
    'name'                                            => 'název',
    'net_income'                                      => 'Cistý príjem',
    'never'                                           => 'Nikdy',
    'new'                                             => 'Nový',
    'next_date'                                       => 'Další datum',
    'next_number'                                     => 'Další císlo',
    'no'                                              => 'Ne',
    'no_open_invoices'                                => 'Tento klient nemá otevrené faktury. K vyúctování výdaju musí mít klient alespon jednu fakturu, která nebyla zcela zaplacena.',
    'no_records_found'                                => 'Nenalezeny žádné záznamy.',
    'none'                                            => 'Žádný',
    'not_billable'                                    => 'Nezúctovatelné',
    'not_billed'                                      => 'Není úctováno',
    'not_viewed'                                      => 'Nezobrazeno',
    'not_visible'                                     => 'Neviditelný',
    'note'                                            => 'Poznámka',
    'note_notification'                               => 'Oznámení: Nová poznámka',
    'notes'                                           => 'Poznámky',
    'online_payment'                                  => 'Platba pres internet',
    'online_payment_method'                           => 'Online platební metoda',
    'online_payments'                                 => 'Online platby',
    'options'                                         => 'Možnosti',
    'other'                                           => 'Další',
    'output_type'                                     => 'Typ výstupu',
    'overdue'                                         => 'Po splatnosti',
    'overdue_email_subject'                           => 'Zpoždený predmet e-mailu',
    'overdue_invoice_reminder'                        => 'Pripomenutí faktury po splatnosti',
    'overdue_invoice_reminder_frequency'              => 'Cetnost pripomenutí faktury po splatnosti',
    'overdue_invoice_reminder_frequency_help'         => 'Seznam dnu oddelených cárkou PO fakture, která má zaslat pripomenutí. Chcete-li deaktivovat upomínky faktur po splatnosti, ponechte toto pole prázdné. Napríklad hodnota 1,5,10 by poslala upomínky 1, 5 a 10 dní po splatnosti faktury.',
    'overdue_invoices'                                => 'Faktury po splatnosti',
    'paid'                                            => 'Zaplaceno',
    'paper_orientation'                               => 'Orientace papíru',
    'paper_size'                                      => 'Velikost papíru',
    'password'                                        => 'Heslo',
    'password_confirmation'                           => 'Potvrzení hesla',
    'password_successfully_reset'                     => 'Heslo bylo úspešne zmeneno',
    'pay'                                             => 'Platit',
    'pay_now'                                         => 'Zaplat ted',
    'payment_applied'                                 => 'Vaše platba byla provedena',
    'payment_button_text'                             => 'Text tlacítka platby',
    'payment_date'                                    => 'Datum splatnosti',
    'payment_form'                                    => 'Platební formulár',
    'payment_method'                                  => 'Zpusob platby',
    'payment_method_form'                             => 'Formulár platební metody',
    'payment_methods'                                 => 'Zpusoby platby',
    'payment_receipt'                                 => 'Úctenka',
    'payment_receipt_email_subject'                   => 'Predmet e-mailu s potvrzením o platbe',
    'payments'                                        => 'Platby',
    'payments_collected'                              => 'Prijaté platby',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'Ovladac PDF',
    'pdf_driver_wkhtmltopdf'                          => 'Pri použití ovladace PDF wkhtmltopdf musí pole Binární cesta obsahovat platnou cestu k souboru.',
    'percent'                                         => 'Procent',
    'phone'                                           => 'Telefon',
    'phone_number'                                    => 'Telefonní císlo',
    'php_version_error'                               => 'PHP nesplnuje požadavek na verzi (% s)',
    'placeholder_type_message'                        => 'Napište zprávu ...',
    'portrait'                                        => 'Portrét',
    'postal_code'                                     => 'PSC',
    'prefix'                                          => 'Predpona',
    'prerequisites'                                   => 'Predpoklady',
    'preview'                                         => 'Náhled',
    'price'                                           => 'Cena',
    'private'                                         => 'Soukromé',
    'problem_with_email_template'                     => 'Zdá se, že nastal problém s e-mailovou šablonou. Zkontrolujte šablony v cásti Nastavení systému na karte E-mail.',
    'product'                                         => 'Produkt',
    'profit_and_loss'                                 => 'Zisk a ztráta',
    'public'                                          => 'Verejný náhled',
    'qty'                                             => 'Množství',
    'quantity'                                        => 'Množství',
    'quantity_price_decimals'                         => 'Pocet desetinných míst pro množství a cástky',
    'quote'                                           => 'Nabídka',
    'quote_approved'                                  => 'Nabídka schválena',
    'quote_approved_email_body'                       => 'Nabídka schváleného tela e-mailu',
    'quote_default'                                   => 'Nabídka výchozí',
    'quote_email_subject'                             => 'Predmet e-mailu s nabídkou',
    'quote_items'                                     => 'Nabídka položek',
    'quote_number'                                    => 'Nabídka císlo',
    'quote_rejected'                                  => 'Nabídka odmítnuta',
    'quote_rejected_email_body'                       => 'Nabídka odmítnutého tela e-mailu',
    'quote_status_change_notification'                => 'Oznámení: Zmena stavu nabídky',
    'quote_summary'                                   => 'Prehled nabídek',
    'quote_to_invoice'                                => 'Prevést na fakturu',
    'quotes'                                          => 'Nabídky',
    'quotes_expire_after'                             => 'Nabídka vyprší po (dnech)',
    'recalculate'                                     => 'Prepocítat',
    'recalculate_help_text'                           => 'Prepocet muže trvat nekolik okamžiku. Po dokoncení procesu se zobrazí zpráva.',
    'recalculate_invoices'                            => 'Prepocítat faktury',
    'recalculate_quotes'                              => 'Prepocítat nabídky',
    'recalculating_wait'                              => 'Prepocítávám, prosím cekejte ...',
    'recalculation_complete'                          => 'Prepocet dokoncen',
    'recent_invoices'                                 => 'Poslední faktury',
    'recent_payments'                                 => 'Nedávné platby',
    'recent_quotes'                                   => 'Nedávné citace',
    'record_not_found'                                => 'záznam nenalezen',
    'record_successfully_created'                     => 'Záznam byl úspešne vytvoren',
    'record_successfully_deleted'                     => 'Záznam byl úspešne smazán',
    'record_successfully_updated'                     => 'Záznam byl úspešne aktualizován',
    'records_imported_successfully'                   => 'Záznamy byly úspešne importovány',
    'recurring'                                       => 'Pravidelné',
    'reject'                                          => 'Odmítnout',
    'rejected'                                        => 'Odmítnuto',
    'rejected_quotes'                                 => 'Zamítnuté nabídky',
    'remember_me'                                     => 'Zapamatuj si me',
    'remove_logo'                                     => 'Odebrat logo',
    'report_rev_client_notice'                        => 'Tento prehled bude k dispozici, jakmile v systému zadáte nejaké platby.',
    'reports'                                         => 'Prehledy',
    'require'                                         => 'Vyžadovat',
    'reset_number'                                    => 'Resetovat císlo',
    'reset_password'                                  => 'Obnovit heslo',
    'results_per_page'                                => 'Výsledky na stránku',
    'revenue_by_client'                               => 'Príjmy klienta',
    'round_tax_decimals'                              => 'Pocet desetinných míst pro zaokrouhlování daní',
    'run_report'                                      => 'Spustit zprávu',
    'save'                                            => 'Uložit',
    'save_and_apply_exchange_rate'                    => 'Uložit a použít smenný kurz',
    'save_item_as_lookup'                             => 'Uložit položku jako vyhledávání',
    'search'                                          => 'Vyhledávání',
    'select_file_to_import'                           => 'Vyberte soubor, který chcete importovat',
    'send'                                            => 'Poslat',
    'sending'                                         => 'Odesílá se',
    'sendmail_path'                                   => 'Cesta služby Sendmail',
    'sent'                                            => 'Odesláno',
    'sent_invoices'                                   => 'Odeslané faktury',
    'sent_quotes'                                     => 'Odeslané nabídky',
    'settings'                                        => 'Nastavení',
    'settings_successfully_saved'                     => 'Nastavení bylo úspešne uloženo',
    'setup'                                           => 'Založit',
    'sign_in'                                         => 'Prihlásit se',
    'sign_out'                                        => 'Odhlásit se',
    'skin'                                            => 'Vzhled',
    'smtp_encryption'                                 => 'Šifrování SMTP',
    'smtp_host_address'                               => 'Adresa hostitele SMTP',
    'smtp_host_port'                                  => 'Hostitelský port SMTP',
    'smtp_password'                                   => 'Heslo SMTP',
    'smtp_username'                                   => 'Uživatelské jméno SMTP',
    'start_date'                                      => 'Datum zahájení',
    'state'                                           => 'Stát',
    'status'                                          => 'Stav',
    'step_database_setup'                             => 'Tento krok nainstaluje a upgraduje vaše databázové tabulky. Dokoncení tohoto kroku muže chvíli trvat.',
    'step_prerequisites'                              => 'Pred pokracováním instalace je treba vyrešit následující predpoklady:',
    'subject'                                         => 'Predmet',
    'submit'                                          => 'Odeslat',
    'subtotal'                                        => 'Mezisoucet',
    'summary'                                         => 'Souhrn',
    'symbol'                                          => 'Symbol',
    'symbol_placement'                                => 'Umístení symbolu',
    'system'                                          => 'Systém',
    'system_settings'                                 => 'Nastavení systému',
    'table_name'                                      => 'Název tabulky',
    'tax'                                             => 'Dan',
    'tax_1'                                           => 'Dan 1',
    'tax_2'                                           => 'Dan 2',
    'tax_rate'                                        => 'Sazba dane',
    'tax_rate_form'                                   => 'Formulár danové sazby',
    'tax_rate_name'                                   => 'Název danové sazby',
    'tax_rate_percent'                                => 'Procento danové sazby',
    'tax_rates'                                       => 'Danová sazba',
    'tax_summary'                                     => 'Souhrn dane',
    'taxable_amount'                                  => 'Zdanitelná cástka',
    'taxes'                                           => 'Dane',
    'template'                                        => 'Šablona',
    'terms_and_conditions'                            => 'Platební podmínky',
    'test_mode'                                       => 'Testovací mód',
    'text'                                            => 'Text',
    'textarea'                                        => 'Textarea',
    'this_quarter'                                    => 'Toto ctvrtletí',
    'thousands_separator'                             => 'Oddelovac tisícu',
    'timezone'                                        => 'Casové pásmo',
    'to'                                              => 'Pro',
    'to_date'                                         => 'K datu',
    'total'                                           => 'Celkem',
    'total_balance'                                   => 'Celkový zustatek',
    'total_invoiced'                                  => 'Celkem fakturováno',
    'total_expenses'                                  => 'Celkové výdaje',
    'total_paid_invoices'                             => 'Celkem zaplacené faktury',
    'try_again'                                       => 'Zkus to znovu',
    'uninstall'                                       => 'Odinstalovat',
    'uninstall_addon_warning'                         => 'Opravdu chcete tento doplnek deaktivovat?',
    'unique_name'                                     => 'Jedinecné jméno',
    'unknown_error'                                   => 'Neznámá chyba',
    'upcoming_payment_notice_email_body'              => 'Telo e-mailu s oznámením o blížícím se termínu platby',
    'upcoming_payment_notice_email_subject'           => 'Predmet e-mailu s oznámením o blížícím se termínu platby',
    'upcoming_payment_notice_frequency'               => 'Cetnost upozornení na blížící se platby',
    'upcoming_payment_notice_frequency_help'          => 'Seznam dnu oddelených cárkou PRED PREDMETEM faktury k odeslání upomínky. Chcete-li deaktivovat nadcházející oznámení o platbe, ponechte toto pole prázdné. Napríklad hodnota 1,5 by poslala oznámení 1 a 5 dní pred splatností faktury.',
    'update_available'                                => 'FusionInvoice :version je k dispozici ke stažení!',
    'update_exchange_rate'                            => 'Aktualizujte smenný kurz',
    'update_not_available'                            => 'Momentálne nejsou k dispozici žádné aktualizace.',
    'upload_progress'                                 => 'Prubeh nahrávání',
    'user'                                            => 'Uživatel',
    'user_accounts'                                   => 'Uživatelské úcty',
    'user_form'                                       => 'Uživatelský formulár',
    'users'                                           => 'Uživatelé',
    'validation_invoice_summary_from_date'            => 'Pokud je casové období nastaveno na Vlastní casové období, je požadováno datum od v Widgetu souhrnu faktur faktury.',
    'validation_invoice_summary_to_date'              => 'Pri použití vlastního casového období je vyžadováno datum ve widgetu souhrnného panelu faktur.',
    'validation_quote_summary_from_date'              => 'Pri použití vlastního casového období je vyžadováno datum od v Widgetu souhrnu nabídek.',
    'validation_quote_summary_to_date'                => 'Pri použití vlastního casového období je vyžadováno datum do widgetu Dashboard Summary Dashboard.',
    'vendor'                                          => 'Prodejce',
    'version'                                         => 'Verze',
    'view'                                            => 'Zobrazit',
    'view_all'                                        => 'Zobrazit vše',
    'view_all_invoices_for_client'                    => 'Zobrazit všechny faktury pro tohoto klienta',
    'view_all_payments_for_client'                    => 'Zobrazit všechny platby pro tohoto klienta',
    'view_all_quotes_for_client'                      => 'Zobrazit všechny nabídky tohoto klienta',
    'view_approved_quotes'                            => 'Zobrazit schválené nabídky',
    'view_client'                                     => 'Detail klienta',
    'view_draft_invoices'                             => 'Zobrazit koncepty faktur',
    'view_draft_quotes'                               => 'Zobrazit koncepty nabídek',
    'view_overdue_invoices'                           => 'Zobrazit faktury po splatnosti',
    'view_payments'                                   => 'Zobrazit platby',
    'view_rejected_quotes'                            => 'Zobrazit odmítnuté nabídky',
    'view_sent_invoices'                              => 'Zobrazit odeslané faktury',
    'view_sent_quotes'                                => 'Zobrazit odeslané nabídky',
    'view_unique_name'                                => 'Zobrazit jedinecné jméno',
    'viewed'                                          => 'Zobrazeno',
    'visible'                                         => 'Viditelné',
    'visible_after_payment'                           => 'Viditelné po zaplacení',
    'web'                                             => 'Web',
    'web_address'                                     => 'Webová adresa',
    'weekly'                                          => 'Týdne',
    'weeks'                                           => 'Týdny',
    'welcome'                                         => 'Vítejte',
    'what_to_import'                                  => 'Co chcete importovat?',
    'year'                                            => 'Rok',
    'yearly'                                          => 'Rocní',
    'years'                                           => 'rok/y',
    'yes'                                             => 'Ano',
    'you_may_now_sign_in'                             => 'Nyní se mužete prihlásit!',

    // 2017-1
    'all_company_profiles'                            => 'Všechny spolecnosti',
    'cannot_delete_record_in_use'                     => 'Tento záznam se používá a nelze jej smazat.',
    'cannot_edit_record_in_use'                       => 'Tento záznam se používá a nelze jej upravovat.',
    'change_company_profile'                          => 'Zmenit profil spolecnosti',
    'company_profile'                                 => 'Profil spolecnosti',
    'company_profiles'                                => 'Profily spolecnosti',
    'company_profile_form'                            => 'Formulár profilu spolecnosti',
    'copy'                                            => 'Kopírovat',
    'create_recurring_invoice'                        => 'Vytvorte pravidelnou fakturu',
    'custom'                                          => 'Vlastní',
    'date_range'                                      => 'Casové období',
    'day_short_sunday'                                => 'Ne',
    'day_short_monday'                                => 'Po',
    'day_short_tuesday'                               => 'Út',
    'day_short_wednesday'                             => 'St',
    'day_short_thursday'                              => 'Ct',
    'day_short_friday'                                => 'Pá',
    'day_short_saturday'                              => 'So',
    'default_company_profile'                         => 'Výchozí profil spolecnosti',
    'first_quarter'                                   => 'První ctvrtletí',
    'fourth_quarter'                                  => 'Ctvrté ctvrtletí',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Posledních 7 dní',
    'last_30_days'                                    => 'Posledních 30 dní',
    'last_month'                                      => 'Minulý mesíc',
    'last_quarter'                                    => 'Poslední ctvrtletí',
    'last_year'                                       => 'Minulý rok',
    'month_january'                                   => 'Leden',
    'month_february'                                  => 'Únor',
    'month_march'                                     => 'Brezen',
    'month_april'                                     => 'Duben',
    'month_may'                                       => 'Kveten',
    'month_june'                                      => 'Cerven',
    'month_july'                                      => 'Cervenec',
    'month_august'                                    => 'Srpen',
    'month_september'                                 => 'Zárí',
    'month_october'                                   => 'Ríjen',
    'month_november'                                  => 'Listopad',
    'month_december'                                  => 'Prosinec',
    'recurring_invoice'                               => 'Pravidelná faktura',
    'second_quarter'                                  => 'Druhé ctvrtletí',
    'stop_date'                                       => 'Datum zastavení',
    'third_quarter'                                   => 'Tretí ctvrtletí',
    'this_month'                                      => 'Tento mesíc',
    'this_year'                                       => 'Tento rok',
    'today'                                           => 'Dnes',
    'user_account'                                    => 'Uživatelský úcet',
    'yesterday'                                       => 'Vcera',

    // 2017-3
    'mail_log'                                        => 'Protokol pošty',
    'recent_client_activity'                          => 'Nedávná aktivita klienta',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Vyloucit nezaplacené faktury',

    // 2017-7
    'please_wait'                                     => 'Prosím, cekejte...',
    'reply_to_address'                                => 'Odpovedet na adresu',

    // 2017-8
    'admin'                                           => 'Správce',
    'admin_account'                                   => 'Úcet správce',
    'admin_accounts'                                  => 'Úcty správce',
    'all_accounts'                                    => 'Všechny úcty',
    'api_key'                                         => 'Klíc API',
    'client_account'                                  => 'Klientský úcet',
    'client_accounts'                                 => 'Klientské úcty',
    'client_id'                                       => 'ID klienta',
    'client_secret'                                   => 'Tajemství klienta',
    'enable_bitcoin_payments'                         => 'Povolit platby bitcoinem',
    'live'                                            => 'Žít',
    'mode'                                            => 'Režim',
    'publishable_key'                                 => 'Publikovatelný klíc',
    'sandbox'                                         => 'Pískovište',
    'secret_key'                                      => 'Tajný klíc',
    'type'                                            => 'Typ',

    // 2017-10
    'deselect_all'                                    => 'Odznacit vše',
    'select_all'                                      => 'Vybrat vše',
    'use_24_hour_time_format'                         => 'Použijte 24hodinový formát casu',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Opravdu chcete tyto záznamy smazat?',
    'bulk_invoice_change_status_warning'              => 'Opravdu chcete zmenit stav vybraných faktur?',
    'bulk_quote_change_status_warning'                => 'Opravdu chcete zmenit stav vybraných nabídek?',
    'calculate_as_vat_gst'                            => 'Vypocítat jako DPH / DPH',
    'change_status'                                   => 'Zmenit stav',
    'default_status_filter'                           => 'Výchozí filtr stavu',
    'error_applying_payment'                          => 'Pri provádení této platby došlo k chybe. Zkuste jinou kartu nebo platební metodu.',
    'remaining'                                       => 'Zbývající',

    // 2017-12
    'invoice_date'                                    => 'Datum faktury',
    'include_profit_based_on'                         => 'Zahrnout zisk založený na',

    // 2018-1
    'add_contact'                                     => 'Pridat kontakt',
    'allow_self_signed_cert'                          => 'Povolit certifikát podepsaný sám sebou',
    'backup'                                          => 'Záloha',
    'close'                                           => 'Zavrít',
    'change_invoice_date_to_todays_date'              => 'Zmenit datum faktury na dnešní datum',
    'change_quote_date_to_todays_date'                => 'Zmenit datum nabídky na dnešní datum',
    'contacts'                                        => 'Kontakty',
    'default_bcc'                                     => 'Výchozí BCC',
    'default_cc'                                      => 'Výchozí CC',
    'default_to'                                      => 'Výchozí Pro',
    'disable'                                         => 'Zakázat',
    'download_database_backup'                        => 'Stáhnete si zálohu databáze',
    'edit_contact'                                    => 'Upravit kontakt',
    'expense_list'                                    => 'Seznam výdaju',
    'keep_invoice_date_as_is'                         => 'Ponechat datum faktury tak, jak je',
    'keep_quote_date_as_is'                           => 'Ponechat datum nabídky tak, jak je',
    'if_quote_is_emailed_while_draft'                 => 'Pokud je nabídka zaslána e-mailem ve stavu konceptu',

    // 2018-4
    'force_https'                                     => 'Vynutit HTTPS',
    'force_https_help'                                => 'Pred povolením této možnosti se ujistete, že vaše instalace FusionInvoice je funkcní pres https. Pokud tak neuciníte, muže to mít za následek nefunkcní (ale opravitelnou) instalaci.',

    // 2019-1
    'attached_to'                                     => 'Pripojený k',
    'customer'                                        => 'Zákazník',
    'expense'                                         => 'Výdaje',
    'expense_categories'                              => 'Kategorie výdaju',
    'expense_category_form'                           => 'Formulár kategorie výdaju',
    'expense_vendors'                                 => 'Prodejci výdaju',
    'expense_vendor_form'                             => 'Formulár dodavatele výdaju',
    'lead'                                            => 'Vést',
    'local_time'                                      => 'Místní cas',
    'prospect'                                        => 'Vyhlídka',
    'search_clients'                                  => 'Hledat klienty',
    'search_expenses'                                 => 'Výdaje na vyhledávání',
    'search_invoices'                                 => 'Hledat faktury',
    'search_items'                                    => 'Hledat položky',
    'search_log'                                      => 'Prohledat protokol',
    'search_quotes'                                   => 'Hledat nabídky',
    'search_payments'                                 => 'Hledat platby',
    'search_recurring_invoices'                       => 'Hledat opakující se faktury',
    'show_all_statuses'                               => 'Zobrazit všechny stavy',
    'show_all_types'                                  => 'Zobrazit všechny typy',
    'unknown'                                         => 'Neznámý',
    'value'                                           => 'Hodnota',

    // 2019-2
    'default'                                         => 'Výchozí',
    'no_data_available'                               => 'Údaje nejsou k dispozici',
    'recurring_invoice_list'                          => 'Seznam opakovaných faktur',
    'report_total'                                    => 'Nahlásit soucty',

    //2019-3
    'checkbox'                                        => 'Zaškrtávací polícko',
    'custom_dropdown_validate'                        => 'Vyberte platnou možnost z pole :label',
    'custom_image_validate'                           => 'Vyberte platný obrázek.',
    'custom_tag_validate'                             => 'Vyberte platnou znacku z :label',
    'custom_text_validate'                            => 'Do pole :label zadejte platnou :label.',
    'datetime'                                        => 'Cas schuzky',
    'decimal'                                         => 'Desetinný',
    'delete-confirm'                                  => 'Jsi si jistá?',
    'grand_total'                                     => 'Celkový soucet',
    'image'                                           => 'obraz',
    'integer'                                         => 'Celé císlo',
    'mailed'                                          => 'Zasláno poštou',
    'mailed_invoices'                                 => 'Zaslané faktury',
    'radio'                                           => 'Rádio',
    'recurring_id'                                    => 'Opakující se ID',
    'remove_image'                                    => 'Odebrat obrázek',
    'tags'                                            => 'Znacky',
    'tagselection'                                    => 'Výber znacky',
    'unpaid'                                          => 'Neplacené',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Zobrazit zaslané faktury',
    'important'                                       => 'Duležité!',
    'created_recurring_invoice_id'                    => 'Vytvoreno z ID opakované faktury',
    'mr'                                              => 'Pan.',
    'miss'                                            => 'Slecna, minout',
    'ms'                                              => 'Slecna.',
    'mrs'                                             => 'Paní.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Název kontaktu',
    'title'                                           => 'Titul',
    'test_email_subject'                              => 'Dobrý den od FusionInvoice',
    'test_email_body'                                 => 'Toto je testovací e-mail od FusionInvoice.',
    'test_email_address'                              => 'Odeslat test e-mailu uživateli',
    'send_test_email'                                 => 'Odeslat zkušební e-mail',
    'invalid_json'                                    => 'Zadejte platný retezec JSON',
    'textarea_rows_limit'                             => 'Rádky nesmí prekrocit :limit',
    'custom_integer_validate'                         => ':label musí být platná celocíselná hodnota',

    //2020-1
    'user_role'                                       => 'Role uživatele',
    'standard_user'                                   => 'Standardní uživatel',
    'permissions'                                     => 'Oprávnení',
    'modules'                                         => 'Moduly',
    'is_view'                                         => 'Pohled',
    'is_create'                                       => 'Vytvorit',
    'is_update'                                       => 'Aktualizace',
    'is_delete'                                       => 'Vymazat',
    'dashboards'                                      => 'Rídicí panely',
    'allow_time_period_change'                        => 'Povolit zmenu casového období',
    'page_not_found'                                  => 'Jejda! Stránka nenalezena.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href=":dashboard_link">Zpet na hlavní panel</a>.',
    'no_auth_to_create_client'                        => 'Nemáte oprávnení k vytvárení klientu!',
    'check-all'                                       => 'Zkontrolovat vše',
    'invoice_prefix'                                  => 'Predpona faktury',
    'recently_viewed'                                 => 'Historie',
    'copy_from'                                       => 'Kopírovat z',
    'select_user'                                     => 'Vyberte uživatele',
    'please_select_user'                              => 'Vyberte uživatele ze seznamu',
    'allow_client_center_login'                       => 'Povolit prihlášení do klientského centra',
    'online_payment_processing_fee'                   => 'Poplatek za zpracování online plateb',
    'client_password_required'                        => 'Zadejte heslo klienta',
    'last_login_at'                                   => 'Poslední prihlášení v',
    'show_notes_panel_below_client'                   => 'Zobrazit panel poznámek pod podrobnostmi klienta',
    'notepad'                                         => 'Poznámky',
    'added'                                           => 'Pridáno',
    'last_edited'                                     => 'Naposledy upraveno',
    'loading'                                         => 'Zpracovává se ....',
    'n_records_match'                                 => ':label nalezených záznamu :plural',
    'initials'                                        => 'Iniciály',
    'initials_bg_color'                               => 'Iniciály Barva pozadí',
    'more'                                            => 'Více',
    'must_match_all'                                  => 'Musí odpovídat všem',
    'clear'                                           => 'Zrušit filtr',
    'no_client_tags'                                  => 'Nejsou k dispozici žádné záznamy klientu s definovanými znackami.',
    'qr_code_on_invoice_quote'                        => 'QR kód na fakture a nabídce',
    'delete_tags'                                     => 'Vycištení znacky',
    'orphan_tags_deleted'                             => 'Úspešne odstraneny všechny osirelé znacky ze systému.',
    'orphan_tags_delete_confirm'                      => 'Spuštením Vycištení znacek odstraníte všechny nepoužívané znacky. Pokracovat?',
    'deleting_tags_wait'                              => 'Mazání znacek, cekejte prosím ...',
    'new-version-available'                           => 'Nová verze k dispozici!',
    'ignore-this-version'                             => 'Tuto verzi ignorovat',
    'view-release-notes'                              => 'Zobrazit poznámky k verzi',
    'task_list'                                       => 'Seznam úkolu',
    'create_task'                                     => 'Vytvorit úkol',
    'open'                                            => 'Otevreno',
    'closed'                                          => 'Zavreno',
    'assignee'                                        => 'Prirazeno',
    'task'                                            => 'Úkol',
    'task_successfully_created'                       => 'Úkol byl úspešne vytvoren',
    'task_successfully_updated'                       => 'Úkol byl úspešne aktualizován',
    'task_completed'                                  => 'Úkol byl úspešne dokoncen',
    'task_marked_incomplete'                          => 'Úkol byl znovu otevren',
    'due_date_validation_date'                        => 'Vyberte prosím platné datum splatnosti',
    'assignee_validation_required'                    => 'Vyberte prosím platného postupníka ze seznamu',
    'assignee_validation_exists'                      => 'Vyberte prosím platného postupníka ze seznamu',
    'tomorrow'                                        => 'Zítra',
    'task_not_authorized'                             => 'Nemáte oprávnení tento úkol upravovat!',
    'me'                                              => 'Me',
    'task_from_note'                                  => 'Vytvorit úkol pri uložení',
    'done'                                            => 'Hotovo',
    'refresh'                                         => 'Obnovit',
    'task_list_page_size'                             => 'Pocet úkolu na stránku',
    'select_client'                                   => 'Vyberte klienta',
    'note-search-config'                              => 'Hledání poznámek k zahrnutí',
    'username'                                        => 'Uživatelské jméno',
    'task-search-config'                              => 'Hledání úlohy k zahrnutí',
    'task_section_invalid'                            => 'Neplatná cást úkolu',
    'task_section'                                    => 'Sekce úkolu',
    'select_section'                                  => 'Vyberte sekci',
    'email-test-failed'                               => 'Test e-mailu se nezdaril',
    'smtp-setting-suggestion'                         => 'Návrhy:<br>1. Overte a znovu zadejte hodnoty svého uživatele / hesla<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Návrhy:<br>1. Overte, zda je server PHP Mail správne nakonfigurován<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Návrhy:<br>1. Overte, zda je vaše cesta k Sendmailu správne nakonfigurována.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Návrhy:<br>1. Overte, zda je váš klíc Sendgrid správne nakonfigurován.<br>2. Contact server admin',
    'later'                                           => 'Pozdeji',
    'test-email-required'                             => 'Musíte zadat platný e-mail',
    'test_mail_sent_successfully'                     => 'Testovací e-mail byl úspešne odeslán',
    'test-mail-btn-title'                             => 'Pred testováním je nutné uložit zmeny.',
    'agreement_expire'                                => 'Aktualizace a podpora vašich produktu vyprší dne :date',
    'agreement_expired'                               => 'Aktualizace a podpora vašich produktu vypršela dne :date',
    'piracy_message'                                  => 'Váš licencní klíc FusionInvoice není platný. Softwarové pirátství je zlocin. Hrajte prosím fér. S platnou licencí získáte podporu, aktualizace a dobrou karmu.',
    'buy-now'                                         => 'Kup nyní',
    'piracy_alert'                                    => 'Budte prosím spravedliví!',
    'agreement-expire-alert'                          => 'Aktualizace a podpora produktu brzy vyprší.',
    'agreement-expired-alert'                         => 'Aktualizace a podpora produktu vypršela.',
    'dismiss-forever'                                 => 'Zavrít navždy',
    'renew-now'                                       => 'Obnovit hned',
    'select_all_permissions'                          => 'Vyberte Všechna oprávnení',
    'app-key-missing'                                 => 'Zadejte svuj licencní klíc do souboru config / app.php.',
    'custom_fields_column_width'                      => 'Vlastní pole zobrazují sloupce',
    'select-user-type'                                => 'Vyberte typ uživatele',
    'lead-or-prospect-with-invoices-error'            => 'Je nám líto, ale typ klienta nemuže být Lead nebo Prospect, pokud existují faktury nebo opakované faktury.',
    'sendgrid_key'                                    => 'Klíc Sendgrid',

    //2020-2.0
    'space'                                           => 'Prostor',
    'apostrophe'                                      => 'Apostrof',
    'comma'                                           => 'Cárka',
    'fullstop'                                        => 'Tecka (tecka)',
    'middledot'                                       => 'Strední tecka',
    'thinspace'                                       => 'Tenký prostor',
    'narrow-no-break-space'                           => 'Úzký prostor bez prestávky',
    'dotabove'                                        => 'Tecka nahore',
    'arabic-decimal'                                  => 'Arabský oddelovac desetinných míst',
    'arabic-thousand'                                 => 'Arabský oddelovac tisícu',
    'decimal-separator-key-symbol'                    => 'Symbol klíce desetinného oddelovace',
    'select-item'                                     => 'Vybrat predmet',
    'item-lookup-overload'                            => 'Pro vyhledávání položek je povoleno maximálne 100 položek',
    'select-expense-category'                         => 'Vyberte kategorii výdaju',
    'select-expense-vendor'                           => 'Vyberte dodavatele výdaju',
    'can-not-delete-all-users'                        => 'Litujeme, nemužete ze systému smazat všechny uživatele',
    'can-not-change-default-user-role'                => 'Litujeme, výchozí uživatelskou roli nemužete zmenit',
    'can-not-change-default-user-status'              => 'Litujeme, výchozí stav uživatele nemužete zmenit',
    'user_not_active'                                 => 'Uživatel není aktivní',
    'can-not-inactive-your-own-status'                => 'Litujeme, nemužete se stát neaktivními.',
    'delete_user_warning'                             => '<p>STOP! Odstranení tohoto uživatele je destruktivní akce, která muže odstranit záznamy, které vytvoril v systému. Místo toho zvažte, aby byl uživatel neaktivní.</p><p>Opravdu chcete tohoto uživatele smazat?</p>',
    'include_time_in_due_date'                        => 'Zahrnout cas splatnosti',
    'cannot_delete_default_company'                   => 'Výchozí profil spolecnosti nelze odstranit',
    'make-user-inactive'                              => 'Zcinit uživatele neaktivním',
    'mail_from_address'                               => 'E-mail z adresy',
    'mail_from_name'                                  => 'E-mail od jména',
    'item_categories'                                 => 'Kategorie položek',
    'select-item-category'                            => 'Vyberte kategorii položky',
    'item_category_form'                              => 'Formulár kategorie zboží',
    'sort_by_due'                                     => 'Trídit podle data splatnosti',
    'affiliate'                                       => 'Affiliate',
    'parent_account'                                  => 'Rodicovský úcet',
    'child_account'                                   => 'Detské úcty',
    'select_parent_client'                            => 'Vyberte nadrazený úcet',
    'record_successfully_retrieved'                   => 'Záznam byl úspešne nacten',
    'custom-image-not-support'                        => 'Vlastní pole obrázku není podporováno',
    'custom-tag-not-support'                          => 'Pole vlastní znacky není podporováno',
    'custom-checkbox-not-support'                     => 'Pole vlastního zaškrtávacího polícka není podporováno',
    'custom-date-not-support'                         => 'Vlastní pole data není podporováno',
    'custom-datetime-not-support'                     => 'Vlastní pole datetime není podporováno',
    'timeline'                                        => 'Historie',
    'client_invoice'                                  => 'Faktury od klienta',
    'select_client_blank_for_all'                     => 'Vyberte klienta (prázdné pro všechny)',
    'invoice_email_success'                           => 'E-mail s fakturou byl úspešne odeslán',
    'quote_email_success'                             => 'E-mail s nabídkou úspešne odeslán',
    'document_number_schemes'                         => 'Císlování dokumentu',
    'document_number_scheme'                          => 'Schéma císla dokumentu',
    'document_number_scheme_form'                     => 'Formulár schématu císla dokumentu',
    'default_document_number_scheme'                  => 'Výchozí schéma císla dokumentu',
    'supporting_data'                                 => 'Podpurná data',
    'customizations'                                  => 'Prizpusobení',
    'utilities_and_logs'                              => 'Nástroje a protokoly',
    'system_log'                                      => 'Systémový protokol',
    'paid_amount'                                     => 'Uhrazená suma',
    'payment_amount'                                  => 'Cástka k úhrade',
    'payment_intent'                                  => 'Platební zámer',
    'apply_payment_to_one_or_more_invoice'            => 'Použít platbu na jednu nebo více faktur',
    'pre_payment_for_future_invoices'                 => 'Platba predem za budoucí faktury',
    'apply_to_invoices'                               => 'Použít na fakturu',
    'payment_application'                             => 'Žádost o platbu',
    'remaining_payment_balance'                       => 'Zbývající zustatek platby',
    'remaining_balance'                               => 'Zustatek úctu',
    'payment_warning'                                 => 'Zadejte cástku',
    'apply_pre_payment_warning'                       => 'Platbu jste nepoužili na žádné faktury. Chcete jej zaznamenat jako platbu predem?',
    'confirm_remaining_balance'                       => 'Zbývající zustatek :value bude k dispozici pro použití na budoucí faktury pro tohoto klienta.',
    'open_balance'                                    => 'Otevrený zustatek',
    'more_figure_then_total_payment'                  => 'Znovu zadejte platbu, celková platba na fakture je vyšší než zbývající zustatek.',
    'remaining_payment_balance_apply_later_info'      => 'Zbývající zustatky plateb lze pozdeji použít na jiné faktury.',
    'invoice_balance'                                 => 'Zustatek na fakture',
    'enter_payment_for_invoice'                       => 'Zadejte platbu za fakturu',
    'invoice_pdf'                                     => 'Faktura PDF',
    'payment_applications'                            => 'Žádosti o platbu',
    'multiple'                                        => 'Násobek',
    'ok'                                              => 'OK',
    'credit_memo_default'                             => 'Výchozí dobropis',
    'edit_payment'                                    => 'Upravit platbu',
    'credit_memo'                                     => 'Dobropis',
    'credit_memos'                                    => 'Dobropisy',
    'create_credit_memo'                              => 'Vytvorte dobropis',
    'credit_applications'                             => 'Aplikace dobropisu',
    'credit_applications_for_invoice'                 => 'Žádosti o dobropis pro fakturu',
    'prepayment_applications_for_invoice'             => 'Žádosti o platbu predem na fakturu',
    'apply_credit_memo'                               => 'Použít dobropis',
    'apply_pre_payment'                               => 'Použijte predplacení',
    'applied_amount'                                  => 'Aplikovaná cástka',
    'remaining_credit_balance'                        => 'Zbývající zustatek kreditu',
    'remaining_credit_balance_apply_later_info'       => 'Zbývající kreditní zustatky lze pozdeji použít na jiné faktury.',
    'applied'                                         => 'Aplikovaný',
    'more_figure_then_invoice_amount'                 => 'Zadejte znovu cástku, cástka nemuže být vetší než cástka na fakture.',
    'more_figure_then_invoice_total'                  => 'Zadejte znovu cástku, celková použitá cástka nemuže být vetší než cástka na fakture.',
    'invoice_not_selected_warning'                    => 'Pockejte, dobropis jste nepoužili na žádné faktury.',
    'select_type'                                     => 'Vyberte typ',
    'email_credit_memo'                               => 'Zaslat dobropis e-mailem',
    'back_to_credit_memo'                             => 'Zpet na dobropis',
    'invoice_amount'                                  => 'Cástka faktury',
    'remaining_invoice_amount'                        => 'Zbývající cástka faktury',
    'settlement_for_credit_memo'                      => 'Vyporádání dobropisu',
    'credit_memo_amount'                              => 'Cástka dobropisu',
    'confirm_remaining_balance_invoice'               => 'Zbývající zustatek pro tuto fakturu bude po zúctování :value.',
    'payment_receipt_for_invoices'                    => 'Potvrzení platby za faktury',
    'primary_phone'                                   => 'Hlavní telefonní císlo',
    'alternate_phone'                                 => 'Alternativní telefonní císlo',
    'currency_not_match'                              => 'Mena se neshoduje',
    'tasks'                                           => 'Úkoly',
    'full_and_final_payment'                          => 'plný',
    'partial'                                         => 'cástecný',
    'transition'                                      => [
        'created'          => 'Vytvoreno',
        'updated'          => 'Aktualizováno',
        'deleted'          => 'Smazáno',
        'received'         => 'Prijato',
        'opened'           => 'Otevreno',
        'sent'             => 'Odesláno',
        'mail'             => 'Odesláno poštou',
        'changed'          => 'Zmeneno',
        'recurring'        => 'Vytvoreno',
        'completed'        => 'Dokonceno',
        'reversed'         => 'Obrácene',
        'quote_to_invoice' => 'Prevést na fakturu',
        'download'         => 'Stažení',
        'added'            => 'Pridáno',
        'email'            => 'E-mailem',
        'merge'            => 'Spojit',
        'billed'           => 'Úctováno',
        'failed'           => 'Nepodarilo se',
        'invoice'          => [
            'created'                => 'Faktura :invoice_number byla vytvorena',
            'credit_memo_created'    => 'Credit Memo :credit_memo_number bylo vytvoreno',
            'credit_memo_updated'    => 'Credit Memo :credit_memo_number byl upraven',
            'created_from_recurring' => 'Faktura :invoice_number byla vytvorena (z opakující se šablony :recurring_invoice_id)',
            'updated'                => 'Faktura :invoice_number byla zmenena',
            'deleted'                => 'Faktura :invoice_number byla smazána',
            'credit_memo_deleted'    => 'Credit Memo :credit_memo_number byl smazán',
            'status_changed'         => 'Stav faktury :invoice_number zmenen z :previous_value na :current_value',
            'email_sent'             => 'E-mail s fakturou :invoice_number odeslán',
            'resend_email'           => 'Faktura :invoice_number e-mail znovu odeslat',
            'email_opened'           => 'E-mail s fakturou :invoice_number otevren',
            'payment_updated'        => 'Faktura :invoice_number aktualizováno :full_payment_text platba',
            'payment_received'       => 'Faktura :invoice_number prijata platba :full_payment_text',
            'payment_reversed'       => 'Faktura :invoice_number mela :full_payment_text',
            'invoice_tag_updated'    => 'Na fakture :invoice_number byla pridána znacka faktury :tags',
            'invoice_tag_deleted'    => 'Fakturacní znacka :invoice_number byla odstranena :tags',
            'mark_mail'              => 'Fakturu :invoice_number oznacit jako odeslanou',
            'unmark_mail'            => 'Maska faktury :invoice_number jako odeslaná',
            'paid_invoice_opened'    => 'Uhrazená faktura byla otevrena pro úpravy',
            'sent_invoice_opened'    => 'Odeslaná faktura byla otevrena pro úpravy',
            'sms_sent'               => 'Faktura :invoice_number SMS odeslána',
        ],
        'quote'            => [
            'created'           => 'Citace :quote_number byla vytvorena',
            'updated'           => 'Citace :quote_number byla upravena',
            'deleted'           => 'Quote :quote_number was deleted',
            'status_changed'    => 'Quote :quote_number Status zmenen z :previous_value na :current_value',
            'email_sent'        => 'Quote :quote_number email sent sent',
            'resend_email'      => 'Citovat :quote_number e-mail znovu odeslat',
            'email_opened'      => 'Quote :quote_number email otevren',
            'quote_to_invoice'  => ':quote_number byl preveden na fakturu - :invoice_number',
            'quote_tag_updated' => 'Quote Tag :tags byl pridán k citaci :quote_number',
            'quote_tag_deleted' => 'Citace Tag :quote_number byl smazán :tags',
            'sms_sent'          => 'Citovat :quote_number SMS odeslána',
        ],
        'payment'          => [
            'prepayment_created'           => 'Záloha byla vytvorena',
            'payment_receipt_email_sent'   => 'E-mail s potvrzením platby odeslán',
            'payment_receipt_resend_email' => 'Znovu odeslat e-mail s potvrzením o platbe',
            'payment_updated'              => 'Platba byla zmenena',
            'deleted'                      => 'Platba byla smazána',
            'payment_receipt_pdf_download' => 'Potvrzení o platbe PDF ke stažení',
            'payment_note_deleted'         => 'Platební poznámka smazána:',
            'payment_note_added'           => 'Pridána poznámka k platbe:',
            'payment_note_updated'         => 'Platební poznámka aktualizována z',
            'payment_failed'               => 'Platba selhala',
        ],
        'client'           => [
            'client_created'     => ':client_type byl vytvoren',
            'type_changed'       => ':previous_value se stal :current_value',
            'updated'            => 'Klient byl aktualizován',
            'deleted'            => 'Klient byl smazán',
            'status_changed'     => 'Klient nastaven na :current_value',
            'client_tag_updated' => 'Byla pridána znacka :tags',
            'client_tag_deleted' => 'Znacka :tags byla smazána',
            'merge'              => 'ID klienta: :idTo - :nameTo bylo slouceno do ID klienta: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Výdaje byly vytvoreny',
            'updated' => 'Výdaje byly upraveny',
            'deleted' => 'Výdaje byly smazány',
            'billed'  => 'Úctovány byly náklady',
            'vendor'  => [
                'created' => 'Byl vytvoren dodavatel výdaju',
                'updated' => 'Prodejce výdaju byl upraven',
                'deleted' => 'Prodejce výdaju byl smazán',
            ],
        ],
        'note'             => [
            'created'          => 'Poznámka byla vytvorena',
            'updated'          => 'Poznámka byla zmenena',
            'deleted'          => 'Poznámka byla smazána',
            'note_tag_updated' => 'Oznacení :tags pridáno do poznámky',
            'note_tag_deleted' => 'Znacka :tags byla smazána z poznámky',
        ],
        'task'             => [
            'created'   => 'Úkol byl vytvoren',
            'updated'   => 'Úkol byl zmenen',
            'deleted'   => 'Úkol byl smazán',
            'completed' => 'Úkol byl dokoncen',
        ],
        'subscription'     => [
            'created'                       => 'Predplatné :invoice_number bylo vytvoreno',
            'updated'                       => 'Predplatné :invoice_number bylo zmeneno',
            'deleted'                       => 'Predplatné :invoice_number bylo smazáno',
            'recurring_invoice_tag_updated' => 'Znacka odberu :tags byla pridána k odberu :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Znacka odberu :recurringInvoice_number byla smazána :tags',
        ],
        'attachment'       => [
            'created' => ':filename byl nahrán jako príloha',
            'deleted' => ':filename byl odstranen jako príloha',
        ],
        'tag'              => [
            'created' => 'Byla pridána znacka :tag',
            'deleted' => 'Znacka :tag byla odstranena',
        ],
    ],
    'reset'                                           => 'Resetovat',
    'select_event'                                    => 'Vyberte typ události',
    'select_country'                                  => 'Vyber zemi',
    'type_captcha'                                    => 'Odpovezte prosím na výše uvedenou otázku',
    'refresh_captcha'                                 => 'Obnovit otázku',
    'answer'                                          => 'Odpovedet',
    'use_captcha_in_login'                            => 'V prihlášení použijte captcha',
    'allow_client_timeline'                           => 'Casová osa',
    'client_timeline'                                 => 'Casová osa',
    'no_invoice_tags'                                 => 'Neexistují žádné znacky faktur.',
    'total_notifications'                             => 'Máte oznámení :total',
    'no_notifications'                                => 'Žádná nová oznámení',
    'notifications'                                   => 'Oznámení',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Nový úkol, který vám byl pridelen',
            'due_date_breached' => 'Úkol',
            'completed'         => ':user dokoncil úkol:',
        ],
        'quote' => [
            'approved'             => ':quote_number byl schválen',
            'quote_to_invoice'     => ':quote_number byl preveden na fakturu -',
            'rejected'             => ':quote_number byl odmítnut',
            'payment_successfully' => 'Nabídka :quote_number pro klienta :client_name byla zaplacena. Faktura :invoice_number byla vytvorena a platba byla pripsána',
        ],
    ],
    'search_tasks'                                    => 'Hledat úkoly',
    'reopen_task'                                     => 'Znovu otevrít úkol',
    'task_form'                                       => 'Pridat úkol',
    'view_task'                                       => 'Podrobnosti úkolu',
    'client_deleted'                                  => 'Klient je smazán',
    'payment_canceled'                                => 'Vaše platba byla zrušena',
    'default_company_profile_set'                     => 'Nastavili jsme váš výchozí profil spolecnosti. Mužete jej kdykoli aktualizovat v nastavení profilu spolecnosti.',
    'file_uploaded_successfully'                      => 'Soubor byl úspešne nahrán',
    'attachment_notice'                               => 'Maximální velikost souboru prílohy je menší nebo rovna :size',
    'attachment_error'                                => 'Velikost prílohy nesmí prekrocit :size',
    'attachment_warning'                              => 'Velikost prílohy je :size. Nahráním mnoha velkých príloh se muže casem snížit výkon databáze.',
    'generate_timeline_history'                       => 'Generovat historii casové osy',
    'generating_timeline_wait'                        => 'Generování casové osy, cekejte prosím ...',
    'generating_timeline_confirm'                     => 'Funkce casové osy byla pridána ve FusionInvoice 2020. Tím se vygenerují položky casové osy pro všechny aktivity, které pred pridáním funkce predcházely. Pokracovat?',
    'generated_timeline_request_accepted'             => 'Generování historie casové osy je dokonceno.',
    'transitions'                                     => 'Historie casové osy',
    'pending'                                         => 'cekající',
    'client_transition'                               => 'Casové osy klienta',
    'expense_transition'                              => 'Casové osy výdaju',
    'invoice_transition'                              => 'Casové osy faktur',
    'payment_invoice_transition'                      => 'Casové osy platebních faktur',
    'payment_transition'                              => 'Casové harmonogramy plateb',
    'quote_transition'                                => 'Casové osy nabídky',
    'note_transition'                                 => 'Poznámka casové osy',
    'task_transition'                                 => 'Casové osy úkolu',
    'email_sent'                                      => 'Email odeslán',
    'credit_applied'                                  => 'Kredit byl použit',
    'configuration'                                   => 'Konfigurace',
    'include_prepayments'                             => 'Zahrnout zálohy',
    'pre_payment'                                     => 'Predplacení',
    'pre_payments'                                    => 'Platby predem',
    'times'                                           => 'Casy',
    'include_prepayments_applied'                     => 'Zahrnout uplatnené zálohy',
    'confirm_full_payment_applied'                    => 'Platba byla plne provedena',
    'confirm_full_credit_memo_applied'                => 'Dobropis byl plne použit',
    'all_tasks'                                       => 'Všechny úkoly',
    'my_tasks'                                        => 'Moje úkoly',
    'assigned_from_others'                            => 'Prirazeno od ostatních',
    'full_payment_reversed'                           => 'plná platba obrácena.',
    'partial_payment_reversed'                        => 'cástecná platba obrácena.',
    'invoice_delete_error'                            => 'Je nám líto, ale nemužete odstranit fakturu, která obsahuje aplikace pro platby nebo dobropisy. Nejprve musíte odstranit aplikace plateb nebo dobropisu.',
    'mail-from-required'                              => 'Musíte zadat platnou poštu z e-mailu',
    'contact_updated'                                 => 'Kontakt byl úspešne aktualizován',
    'contact_added'                                   => 'Kontakt byl úspešne pridán',
    'generate_passport_key_wait'                      => 'Generování klíce k pasu, cekejte prosím ...',
    'generate_passport_key'                           => 'Vygenerujte klíc pasu',
    'default_greeting'                                => 'Ahoj!<br>',
    'hi'                                              => 'Ahoj,',
    'deduct_tax_from_expenses'                        => 'Odectete dan z výdaju',
    'invalid_invoice_id'                              => 'Neplatné ID faktury',
    'client_related_record_exist'                     => 'Je nám líto, ale klient má související záznamy pro:: moduly. Klienty s historií transakcí nelze smazat.',
    'email_payment_receipt_notice'                    => 'Klient nemá evidovanou žádnou e-mailovou adresu',
    'show_more'                                       => 'Zobrazit více ...',
    'show_less'                                       => 'Ukaž méne ...',
    'invoice_already_paid'                            => 'Faktura je již zaplacena!',
    'system_default'                                  => 'Výchozí nastavení systému',
    'created_by'                                      => 'Vytvoril',
    'created_at'                                      => 'Vytvoreno v',
    'task_created_by_and_created_at'                  => 'Úkol vytvoril :created_by na :created_at',
    'dashboard_widgets_date_options'                  => 'Výchozí casové období systému pro souhrn faktur a nabídek',
    'dashboard-widget-from-date-required'             => 'Od data je požadováno, pokud je v systémovém výchozím casovém období pro prehled faktur a nabídek vybráno vlastní casové období',
    'dashboard-widget-to-date-required'               => 'K dnešnímu dni je požadováno, když je vybráno vlastní casové období ve výchozím casovém období systému pro souhrn faktur a nabídek',
    'invoice_currency'                                => 'Mena faktury',
    'currency_format'                                 => 'Formát meny',
    'create_missing_folder_success'                   => 'Byla vytvorena chybející požadovaná složka',
    'create_missing_folder_failed'                    => 'Pokus o vytvorení složky se nezdaril :path',
    'folder_is_not_writable'                          => 'Do složky nelze zapisovat :path',
    'update_item_as_lookup'                           => 'Aktualizovat vyhledávání položek',
    'number_of_tax_fields'                            => 'Pocet danových polí',
    'tax_1_entry'                                     => '1 Vstup',
    'tax_2_entries'                                   => '2 položky',
    'require_tags_on_client_notes'                    => 'Vyžadovat znacky v poznámkách klienta',
    'entered_amount_less_than_invoice_amount'         => 'Zadaná cástka musí být menší nebo rovna cástce faktury',
    'send-to'                                         => 'Poslat komu',
    'print'                                           => 'Tisk',
    'pdf_cleanup'                                     => 'Vycištení PDF',
    'pdf_cleanup_confirm'                             => 'Opravdu chcete vycistit staré soubory PDF',
    'pdf_cleanup_success'                             => 'Vycištení souboru PDF je dokonceno',
    'deleting_pdf_wait'                               => 'Mazání starých souboru PDF, cekejte prosím ...',
    'open_invoices'                                   => 'Otevrete faktury',
    'open_credits'                                    => 'Otevrené kredity',
    'unapplied_payments'                              => 'Neuplatnené platby',
    'attach_invoice_pdf'                              => 'Priložte fakturu PDF',
    'upcoming_payment_notice'                         => 'Oznámení o pripravované platbe',
    'select_mapping'                                  => 'Vyberte Mapování',
    'select_named_export'                             => 'Vyberte pojmenovaný export',
    'save_mapping'                                    => 'Uložit mapování',
    'add_mapping'                                     => 'Vytvorit nové mapování',
    'edit_mapping'                                    => 'Aktualizovat mapování',
    'save_as_default_mapping'                         => 'Výchozí mapování',
    'save_as_default_export'                          => 'Výchozí export',
    'export_item_lookups'                             => 'Exportovat vyhledávání položek',
    'import_file_selection'                           => 'Importovat výber souboru',
    'next'                                            => 'další',
    'delete_import_mapping_warning'                   => 'Opravdu chcete toto mapování smazat?',
    'export'                                          => 'Vývozní',
    'named_exports'                                   => 'Pojmenované exporty',
    'save_named_export'                               => 'Uložit pojmenovaný export',
    'delete_named_export'                             => 'Odstranit pojmenovaný export',
    'updated_at'                                      => 'Aktualizováno v',
    'zip'                                             => 'Zip',
    'fields_to_export'                                => 'Pole pro export',
    'import-file-type-error'                          => 'Importovaný typ souboru musí být CSV',
    'recurring_invoice_items'                         => 'Opakující se položky faktury',
    'important_details'                               => 'Duležité detaily',
    'important_information'                           => 'Duležitá informace',
    'item_lookups_important_information'              => '<p>Pokud se pri importu CSV ve stávajících datech najde odpovídající vyhledávací název položky, dávka importu se nezdarí a zobrazí se položka, která zpusobila selhání.</p>',
    'invoices_important_information'                  => '<p>Jméno klienta (z CSV) se vyhledá v tabulce Clients a vyreší se na client_id, pokud existuje odpovídající jméno. Pokud není nalezena shoda jmen, vytvorí klientskou položku a použije ID nové položky klienta</p><p>Císlo faktury,</p><p>Invoice_items provede vyhledání císla faktury (z CSV) v tabulce faktur a prenese ji na ID. Neprovádejí se žádná další vyhledávání/validace klícových polí</p>',
    'invoice_items_important_information'             => '<p>Import faktury_položky provede vyhledání císla faktury (z CSV) v tabulce faktur a prenese ji na príslušné ID faktury. ID klienta je také odvozeno od odpovídajících informací o fakture.</p>',
    'payments_important_information'                  => '<p>Import plateb vyžaduje k prirazení plateb platné odpovídající císlo faktury. Pokud není nalezena odpovídající faktura, celý dávkový import se nezdarí.</p><p>Príslušní klienti-</p><p>Vyhledá se název platební metody (z CSV do tabulky payment_methods) a vyreší se na príslušný platební_method_id, pokud je nalezen. pokud není nalezeno odpovídající jméno, bude vytvoren nový záznam o platební metode a bude použit nový platební_metod_id.</p>',
    'run_daily_tasks'                                 => 'Spustte denní úkoly',
    'daily_task_ran'                                  => 'Denní úkoly probehly úspešne',
    'csv_row_number'                                  => 'Císlo rádku CSV :row',
    'max_item_lookup_records'                         => 'Max. Záznamy vyhledávání položek',
    'invoice_with_commission_delete_error'            => 'Je nám líto, nemužete smazat fakturu, která obsahuje položky provize se stavem zaplaceno. Nejprve musíte smazat zaplacenou provizi na této fakture.',
    'if_invoice_is_emailed_while_draft'               => 'Pokud je faktura odeslána e-mailem ve stavu konceptu',
    'custom_payment_receipt_body_not_exists'          => 'Vlastní šablona pro potvrzení o platbe nebyla nalezena.',
    'invoice_email_body_type'                         => 'Typ tela e-mailu faktury',
    'send_overdue_reminder'                           => 'Odeslat upomínku po splatnosti',
    'reminder_sent_successfully'                      => 'Pripomenutí bylo úspešne odesláno',
    'error_sending_reminder'                          => 'Pri odesílání pripomenutí došlo k chybe, zkuste to prosím znovu pozdeji.',
    'expense_date'                                    => 'Datum výdaju',
    'group_by'                                        => 'Skupina vytvorená',
    'timeline_scope_all_user'                         => 'Rozsah casové osy – Všichni uživatelé',
    'copy_to_clipboard'                               => 'Zkopírovat do schránky',
    'text_copied_clipboard'                           => 'Text zkopírován do schránky!',
    'import_example_csv'                              => 'Príklad souboru CSV naleznete zde',
    'import'                                          => 'Import',
    'address2'                                        => 'Adresa 2',
    'use_parent_email'                                => 'Použijte rodicovský e-mail',
    'max_import_records'                              => 'Maximální limit pro import záznamu je :total_records',
    'demo_file_attachment_disabled'                   => 'Prílohy souboru jsou v ukázce zakázány',
    'drag_drop_file'                                  => 'Táhnout',
    'or'                                              => 'NEBO',
    'browse_file'                                     => 'Procházet soubor',
    'system_setting_and_ui'                           => 'Nastavení systému',
    'localization_and_timezone'                       => 'Lokalizace',
    'security'                                        => 'Bezpecnostní',
    'cleanup_and_backup'                              => 'Cištení',
    'attach_quote_pdf'                                => 'Priložte nabídku PDF',
    'attach_payment_receipt'                          => 'Priložte potvrzení o platbe',
    'choose-file'                                     => 'Vyberte soubor',
    'important-note'                                  => 'Duležitá poznámka',
    'collapse'                                        => 'Kolaps',
    'add_task'                                        => 'Pridat úkol',
    'recurring_invoice_commissions'                   => 'Provize za opakované faktury',
    'invoice_commissions'                             => 'Fakturacní provize',
    'percentage'                                      => 'Procento',
    'flat_amount'                                     => 'Paušální cástka',
    'discount-amount'                                 => 'Sleva',
    'discount-type'                                   => 'Typ slevy',
    'saving'                                          => 'Ukládání...',
    'preparing'                                       => 'Pripravuje se',
    'allow_line_item_discounts'                       => 'Povolit slevy na rádkové položky',
    'invalid_price_amount'                            => 'Neplatná výše ceny! Musí být vetší než 0.',
    'light-mode'                                      => 'Svetelný režim',
    'dark-mode'                                       => 'Tmavý režim',
    'system_base_currency'                            => 'Základní mena systému',
    'is_recurring_task'                               => 'Je opakující se úkol',
    'contact_names'                                   => 'Jména kontaktu',
    'all_client'                                      => 'Všichni klienti',
    'invoice_grand_total'                             => 'Celková faktura',
    'recurring_invoice_grand_total'                   => 'Celkový soucet opakující se faktury',
    'is_required'                                     => 'Je požadováno?',
    'add-new-client'                                  => 'Pridat nového klienta',
    'client_name_required'                            => 'Jméno klienta je povinné',
    'custom_item_text_validate'                       => 'Zadejte prosím platnou položku :label do pole :label.',
    'assigned_to_others'                              => 'Prirazeno Ostatním',
    'all_tasks_and_all_users'                         => 'Všechny úkoly/Všichni uživatelé',
    'statement'                                       => 'Prohlášení',
    'profile_code'                                    => 'Kód profilu',
    'login-url'                                       => 'Prihlašovací URL',
    'url_copied_clipboard'                            => 'URL zkopírováno do schránky!',
    'payment_receipt_email_sent'                      => 'E-mail s potvrzením o platbe byl úspešne odeslán',
    'edit_payment_note_form'                          => 'Upravit poznámku k platbe',
    'payment_invoices_text'                           => 'Dekuju! Vaše platba :amount byla použita na následující faktury.',
    'payment_text'                                    => 'Dekujeme za vaši platbu :amount.',
    'date_filter_by'                                  => 'Datum Filtrovat podle',
    'filter_by_invoice_date'                          => 'Datum faktury',
    'filter_by_payment_date'                          => 'Datum splatnosti',
    'date-range-required'                             => 'Vyberte casové období',
    'save-and-complete'                               => 'Uložit a dokoncit',
    'completion-note'                                 => 'Poznámka k dokoncení',
    'complete-with-note'                              => 'Kompletní s poznámkou',
    'placeholder_type_note'                           => 'Napište své poznámky...',
    'credit_memo_email_subject'                       => 'Predmet e-mailu dobropisu',
    'default_credit_memo_email_body'                  => 'Výchozí telo e-mailu dobropisu',
    'show_invoices_from'                              => 'Zobrazit faktury od',
    'system_mail_from_address'                        => 'System Mail From Address',
    'user_who_created_invoice'                        => 'Uživatel, který vytvoril fakturu',
    'completed'                                       => 'Dokonceno',
    'no_auth_to_view_task'                            => 'Tento úkol již není ve vašem seznamu.',
    'credit-memo-and-prepayments'                     => 'Kredity a platby predem',
    'all_selected'                                    => 'Všechny vybrané',
    'select_columns'                                  => 'Vyberte Sloupce',
    'column_settings'                                 => 'Nastavení sloupcu',
    'minimum_one_column_check_is_required'            => 'Vyberte prosím alespon jeden sloupec',
    'date_of_entry'                                   => 'Datum vstupu',
    'amount_applied'                                  => 'Použitá cástka',
    'date_applied'                                    => 'Datum použití',
    'copy_to_recurring_invoice'                       => 'Kopírovat do opakující se faktury',
    'top_bar_color'                                   => 'Barva horní lišty',
    'light_grey'                                      => 'Svetle šedá',
    'bg-primary'                                      => 'Modrý',
    'bg-warning'                                      => 'Žlutá',
    'bg-info'                                         => 'Vážka modrá',
    'bg-danger'                                       => 'Cervené',
    'bg-success'                                      => 'Turf Green',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victoria Blue',
    'bg-navy'                                         => 'Námornická modrá',
    'bg-purple'                                       => 'Nachový',
    'bg-fuchsia'                                      => 'Fuchsie',
    'bg-pink'                                         => 'Ružový',
    'bg-maroon'                                       => 'Maroon',
    'bg-orange'                                       => 'oranžový',
    'bg-lime'                                         => 'Limetkove zelená',
    'bg-teal'                                         => 'Teal',
    'bg-olive'                                        => 'Olivový',
    'fee_name'                                        => 'Název poplatku',
    'fee_percentage'                                  => 'Procento poplatku',
    'fee_explanation'                                 => 'Vysvetlení poplatku',
    'enable_online_payment_processing_fees'           => 'Povolit poplatky za zpracování online plateb',
    'allow_online_payment_processing_fees'            => 'Povolit poplatky za zpracování online plateb',
    'allow_online_pay_fees'                           => 'Povolit online platby',
    'convenience_charges'                             => 'Poplatky za pohodlí',
    'opp-fee-percentage-required'                     => 'Je vyžadováno procento poplatku za zpracování online plateb',
    'opp-fee-percentage-gt-zero'                      => 'Procento poplatku za zpracování online plateb musí být vyšší než nula',
    'cron_error'                                      => 'selhal na :datetime',
    'cron_start'                                      => 'Denní úkolovník zacal na :datetime',
    'notification_clear_all'                          => 'Vymazat všechna oznámení',
    'show'                                            => 'Ukázat',
    'report'                                          => 'Zpráva',
    'profit_loss'                                     => 'Zisk a ztráta',
    'credit_and_pre_payments'                         => 'Kredity a platby predem',
    'expenses_vendors'                                => 'Prodejci nákladu',
    'expenses_categories'                             => 'Kategorie výdaju',
    'create'                                          => 'Vytvorit',
    'import_map_clients'                              => 'Import mapových klientu',
    'payctr_users'                                    => 'Uživatelé PaymentCenter',
    'ctrl_plus_click'                                 => 'Klepnutím se stisknutou klávesou Ctrl pridejte poznámky k dokoncení',
    'edit_note'                                       => 'Upravit poznámku',
    'save-and-unComplete'                             => 'Uložit a nedokoncit',
    'sales_chart'                                     => 'Prodejní tabulka',
    'accumulate_totals'                               => 'Akumulovat soucty',
    'do_not_accumulate_totals'                        => 'Nescítat soucty',
    'kpi_cards'                                       => 'KPI karty',
    'no_data_to_display'                              => 'Žádná data k zobrazení',
    'choose_period'                                   => 'Vyberte Období',
    'date_mailed'                                     => 'Datum odeslání',
    'date_emailed'                                    => 'Datum odeslání e-mailem',
    'action'                                          => 'Akce',
    'mail'                                            => 'Pošta',
    'mark_as_mailed'                                  => 'Oznacit jako odeslané',
    'invoice_mailed'                                  => 'Faktura byla oznacena jako odeslaná',
    'emailed'                                         => 'Odesláno e-mailem',
    'paid_invoice_canceled_error'                     => 'Chcete-li zrušit tuto fakturu, odstrante platby z faktury.',
    'allow_invoice_delete'                            => 'Povolit smazání faktury',
    'allow_child_accounts'                            => 'Povolit podrízené úcty',
    'third_party_bill_payer'                          => 'Plátce faktur tretí strany',
    'invoices_paid_by'                                => 'Zaplacené faktury',
    'use_third_party_bill_payer_email'                => 'Použijte e-mail plátce faktur tretí strany',
    'email_default'                                   => 'Výchozí e-mail',
    'client_default'                                  => 'Výchozí nastavení klienta',
    'clear-all'                                       => 'Vymazat vše',
    'system_log_is_missing_or_empty'                  => 'Systémový protokol chybí nebo je prázdný',
    'change_to_draft'                                 => 'Zmenit na Koncept',
    'invoice_status_change_to_draft'                  => 'Zmena stavu faktury na Koncept',
    'there_is_some_error'                             => 'Existují urcité chyby',
    'filter_by_date'                                  => 'Filtrovat podle data',
    'quote_grand_total'                               => 'Citace Celkový soucet',
    'email_upcoming_payment_due_notice'               => 'Oznámení o nadcházející platbe e-mailem',
    'email_overdue_invoice_reminder'                  => 'E-mail s upomínkou na fakturu po splatnosti',
    'page_totals'                                     => 'Soucty stránek',
    'categories'                                      => 'Kategorie',
    'conven_charges'                                  => 'Konv. Poplatky',
    'invoice_status_change_to_cancel'                 => 'Zmena stavu faktury na Storno',
    'filter_by_invoice_number'                        => 'Císlo faktury',
    'filter_by_client_name'                           => 'jméno klienta',
    'custom_mail_template'                            => 'Vlastní šablona pošty',
    'invoice_use_custom_mail_template'                => 'Faktura Použijte vlastní šablonu pošty',
    'client_or_company_name'                          => 'Jméno klienta/spolecnosti',
    'view_invoice'                                    => 'Zobrazit fakturu',
    'tt_active'                                       => 'Pokud záznam klienta není aktivní, nezobrazí se ve výchozím seznamu klientu a nebudou povoleny bežné transakce.',
    'tt_invoice_prefix'                               => 'Jedinecný kód predcíslí faktury je automaticky prirazen záznamu klienta pri jeho vytvorení. Pozdeji jej lze rucne zmenit. Lze jej použít jako soucást vašeho schématu císlování dokumentu pro císlování faktur, což umožnuje jedinecné císlo faktury pro každého klienta.',
    'tt_automatic_email_payment_receipts'             => 'Po prijetí platby zašle klientovi e-mailem potvrzení o platbe. Globální nastavení je k dispozici v nastavení systému, ale muže být prepsáno u jednotlivých klientu.',
    'tt_automatic_email_on_recur'                     => 'Odešle e-mailem klientovi fakturu, když je spuštena opakovaná faktura, a vytvorí skutecnou fakturu. Globální nastavení je k dispozici v nastavení systému, ale muže být prepsáno u jednotlivých klientu.',
    'tt_default_currency'                             => 'Mena prirazená tomuto klientskému úctu, která bude použita pro jejich fakturaci, nabídku a platební transakce. Tato hodnota je výchozí z nastavení systému pro základní menu.',
    'tt_language'                                     => 'Jazyk, který se klientovi zobrazí pri prihlášení do klientského centra.',
    'tt_allow_client_center_login'                    => 'Melo by být klientovi povoleno prihlásit se do vašeho klientského centra FusionInvoice? Jejich e-mail musí být použit pro jejich uživatelské jméno a musíte jim priradit heslo. Adresa URL klientského centra je',
    'tt_timezone'                                     => 'Casové pásmo pro klienta. Pokud je zadán, místní cas klienta se zobrazí v horní cásti zobrazení stránky klienta.',
    'tt_allow_online_payment_processing_fees'         => 'Poplatky za zpracování online plateb mohou být úctovány zákazníkum platícím kreditní kartou pomocí odkazu na verejnou fakturu (obsaženého v e-mailu s fakturou). Tato možnost má globální systémové nastavení, ale muže být také prepsána u jednotlivých klientu.',
    'tt_allow_child_accounts'                         => 'Nastavení Povolit podrízené úcty na Ano umožní tomuto klientovi vystupovat jako nadrazený úcet a umožní vám jej vybrat ze seznamu nadrazených úctu.',
    'tt_third_party_bill_payer'                       => 'Plátce faktur tretí strany je organizace, která platí úcty za své klienty, napríklad externí úcetní firma.',
    'tt_parent_account'                               => 'Materská spolecnost, se kterou je tento klient spríznen nebo její dcerinou spolecností. Tento seznam obsahuje záznamy klientu, které mají nastavení Povolit podrízené úcty nastaveno na Ano. Pokud klient nemá žádný nadrazený úcet, ponechte prázdné.',
    'tt_invoices_paid_by'                             => 'Podnik tretí strany, který tento klient používá k úhrade faktur. Tento seznam obsahuje záznamy klientu, které mají nastavení Plátce faktury tretí strany nastaveno na Ano. Nechte prázdné, pokud si klient hradí faktury sám.',
    'tt_email_default'                                => 'Pri odesílání e-mailu tomuto klientovi vyberte e-mail, který má být použit. Pokud má tento klient pridružený nadrazený úcet nebo úcet s placenými fakturami, lze vybrat kteroukoli z techto možností. Výchozí je standardní e-mail klienta.',
    'tt_default_to'                                   => 'Pri odesílání e-mailu by mel být tento kontakt automaticky pridán do seznamu príjemcu \'To:\'?',
    'tt_default_cc'                                   => 'Mel by se pri odesílání e-mailu tento kontakt automaticky pridat do seznamu príjemcu \'CC:\'?',
    'tt_default_bcc'                                  => 'Pri odesílání e-mailu by mel být tento kontakt automaticky pridán do seznamu príjemcu \'BCC:\'?',
    'tt_client_type'                                  => 'Vedoucí je nekvalifikovaný prodejní kandidát. Prospekt je kvalifikovaný kandidát, který se muže brzy stát zákazníkem. Zákazník je firma nebo jednotlivec, kterému jste prodali (nebo brzy prodáte) zboží nebo služby. Affiliate je firma nebo jednotlivec, který dále prodává vaše zboží nebo služby. Jiné se používá pro obchody, které neodpovídají jiným typum, jako jsou plátci faktur tretích stran nebo nadrazené úcty, se kterými prímo neobchodujete.',
    'tt_client_tags'                                  => 'Klientovi lze priradit znacky, které pomohou kategorizovat nebo filtrovat seznam klientu pro prohlížení nebo vytvárení prehledu.',
    'tt_important_note'                               => 'Zde zadaná poznámka se automaticky objeví v DULEŽITÉ! pri zobrazení záznamu klienta.',
    'tt_gen_header_title_text'                        => 'Text, který se zobrazuje v levém horním rohu vedle vašeho loga, obvykle název vaší spolecnosti.',
    'tt_gen_default_company_profile'                  => 'Firemní profil, který se má ve výchozím nastavení použít pri vytvárení nových faktur, nabídek atd. Firemní profily vám umožnují prezentovat vaši firmu s každým profilem jinak, umožnují ruzné názvy spolecností, loga, formáty faktur atd.',
    'tt_gen_address_format'                           => 'Umožnuje vytvorit formát adresy zobrazený na fakturách a nabídkách pomocí jediného pole adresy nebo kombinace jednotlivých polí adresy, jako je mesto, stát, zeme atd.',
    'tt_gen_custom_fields_columns'                    => 'Vlastní pole mohou být zobrazena od 1 do 3 polí na rádek.',
    'tt_gen_require_tags_on_client_notes'             => 'Je-li nastaveno na Ano, bude pri pridávání poznámky klienta vyžadovat výber nebo zadání znacky, jako je \'Podpora\' nebo \'Prodej\'. To je užitecné pro kategorizaci a vyhledávání poznámek.',
    'tt_gen_skin'                                     => 'Jak chcete zobrazit uživatelské rozhraní FI, režim Svetlý nebo Tmavý',
    'tt_gen_top_bar_color'                            => 'Barva horního záhlaví. Pokud pracujete s nekolika ruznými instalacemi FusionInvoice, muže to být užitecná vizuální identifikace.',
    'tt_gen_results_per_page'                         => 'Pocet záznamu zobrazených na stránce pro všechna zobrazení seznamu, jako jsou klienti, faktury, nabídky, výdaje atd.',
    'tt_gen_allow_line_item_discounts'                => 'Povolí nebo zakáže funkci zlevnování rádkových položek ve fakturách a nabídkách.',
    'tt_gen_language'                                 => 'Jazyk, který bude použit pro vaši instalaci FusionInvoice. Upozornujeme, že svým klientum mužete priradit jiný jazyk, což jim umožní komunikovat s klientským centrem FusionInvoice pomocí jejich materského jazyka.',
    'tt_gen_date_format'                              => 'Váš preferovaný formát data',
    'tt_gen_use_24_hour_time_format'                  => 'Umožnuje podporu 24 nebo 12hodinových formátu casu.',
    'tt_gen_timezone'                                 => 'Primární casové pásmo vaší firmy.',
    'tt_gen_base_currency'                            => 'Mena, kterou vaše firma používá nejcasteji.',
    'tt_gen_exchange_rate_mode'                       => 'Rucní vám umožní zadat hodnotu smenného kurzu pri vytvárení faktur. Automatic se pokusí použít verejné API k nactení smenného kurzu meny. Toto se používá pouze v prípade, že zadáváte transakci v jiné mene, než je vaše základní mena.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice podporuje až 2 danová pole na rádkovou položku. Hodnota vybraná pomocí Zobrazit nebo skrýt druhé danové pole.',
    'tt_gen_quantity_price_decimals'                  => 'Pocet desetinných míst, která se mají zobrazit pro hodnoty množství a množství. Vyberte 0 až 4 na základe požadované úrovne presnosti.',
    'tt_gen_round_tax_decimals'                       => 'Vyberte požadovaný pocet desetinných míst pro výpocty zaokrouhlení dane.',
    'tt_gen_use_captcha_in_login'                     => 'Pokud je nastaveno na Ano, bude vyžadovat, aby vaši uživatelé behem prihlašování odpovedeli na výzvu CAPTCHA.',
    'tt_gen_force_https'                              => 'Zrídka doporucujeme tuto možnost zapnout. Pokud vaše instalace nemá na vašem webovém serveru nainstalovaný správne fungující certifikát SSL, mužete u instalace FusionInvoice zaznamenat problémy. Stejného výsledku mužete dosáhnout nastavením pravidla presmerování serveru.',
    'dashboard_settings'                              => 'Nastavení rídicího panelu',
    'tt_dashboard_settings'                           => 'Váš rídicí panel se používá k zobrazení duležitých obchodních metrik a událostí, což vám poskytuje cenný prehled o výkonu vaší spolecnosti. Systémový rídicí panel je výchozí pro všechny uživatele, avšak v rámci konfigurace každého uživatele mužete výchozí systémový rídicí panel prepsat a definovat konkrétní nastavení pro každého uživatele. Níže uvedená nastavení vám umožnují prizpusobit si rídicí panel.',
    'tt_db_default_time_period'                       => 'Nastaví výchozí pocátecní a koncové datum pro widgety rídicího panelu, které je používají, jako jsou karty klícových ukazatelu výkonu a graf prodeje.',
    'tt_db_recent_client_activity'                    => 'Widget, který zobrazuje interakce klienta, jako jsou provedené platby a zobrazené faktury nebo nabídky, z vašich odkazu na verejnou fakturu nebo nabídku.',
    'tt_db_display_order'                             => 'Tím se zmení poradí zobrazení widgetu rídicího panelu. 1 se zobrazí nahore, 2 se zobrazí po 1 atd.',
    'tt_db_column_width'                              => 'Widgety rídicího panelu používají mrížkový systém Bootstrap a mají maximální šírku sloupce 12. Nastavení šírky sloupce na 12 zpusobí, že widget použije celou dostupnou šírku. Nastavení na 6 umožní dvema widgetum sdílet stejný rádek, 4 umožní 3 widgetum sdílet stejný rádek atd.',
    'tt_db_accumulate_totals'                         => 'Nastavení této hodnoty zpusobí, že váš graf bude zahrnovat soucty za predchozí dny pro každý den. Napríklad tržby za 1. den byly 100 USD, 2. den 50 USD a 3. den 125 USD. Graf by ukazoval stoupající cáru s touto možností nastavenou na Ano. Pokud nastavíte Ne, zobrazí se pokles prodejní linie v den 2 a zvýší se na den 3.',
    'tt_db_kpi_cards'                                 => 'Tyto barevne odlišené karty zobrazují klícové ukazatele výkonu v horní cásti palubní desky.',
    'tt_db_sales_chart'                               => 'Spojnicový graf zobrazující soucty faktur a plateb.',
    'tt_db_task_list'                                 => 'Tento widget vám umožnuje pracovat s modulem Seznam úkolu prímo z vašeho rídicího panelu.',
    'tt_db_task_list_include_time'                    => 'Zapnutí této možnosti vám umožní urcit datum a cas pro termíny pri práci s úkoly. Pri nastavení na Ne se použije pouze datum.',
    'tt_db_timeline'                                  => 'Widget casové osy zobrazuje chronologický a prohledávatelný seznam duležitých událostí systému, jako jsou zmeny stavu klienta, faktury zaslané e-mailem, prijaté platby, porízené poznámky atd.',
    'tt_ss_invoices_default_invoice_template'         => 'Vyberte šablonu, která se bude standardne používat pri vytvárení nových faktur. Vlastní šablony by mely být umísteny v .\\custom\\templates\\invoice_templates\\ a musí být pojmenovány s príponou .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Vyberte schéma císel dokladu, které se bude standardne používat pri vytvárení nových faktur. Schémata císel dokladu lze vytvorit v Nastavení konfigurace a umožnují vám personalizovat císla dokladu (faktury, nabídky, dobropisy).',
    'tt_ss_invoices_invoice_due_days'                 => 'Výchozí pocet dní po datu (vytvorení) faktury, po které bude faktura splatná a ocekává se, že bude zaplacena.',
    'tt_ss_invoices_automatic_email_ri'               => 'Když se spustí opakovaná faktura a vygeneruje se aktuální faktura, mela by být tato aktuální faktura automaticky zaslána klientovi e-mailem?',
    'tt_ss_invoices_qr_code'                          => 'Mel by být QR kód automaticky umísten na výchozí faktury a nabídky. Pokud používáte vlastní šablony faktur nebo cenových nabídek, použijte výchozí šablony a pridejte QR kód do vlastních šablon.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Pokud je faktura ve stavu Koncept a je odeslána e-mailem, bud rucne, nebo automaticky, co by se melo stát s datem faktury. Duležitá poznámka: Když je faktura zaslána e-mailem, stav se automaticky zmení z Koncept na Odesláno.',
    'tt_ss_invoices_recalculate'                      => 'Spustí každou transakci provedenou pro každou fakturu od data vytvorení do aktuálního data a prepocítá soucty, soucty rádkových položek, dane, slevy a soucty faktur. To muže trvat dlouho, pokud máte velkou datovou sadu.',
    'tt_ss_invoices_due_after'                        => 'Datum splatnosti faktury bude datum faktury plus zde zadaný pocet dnu.',
    'tt_ss_invoices_default_status_filter'            => 'Filtr stavu, který se má ve výchozím nastavení použít pri prohlížení seznamu faktur.',
    'tt_ss_invoices_default_terms'                    => 'Hodnota textu podmínek, která se zobrazuje ve výchozí šablone faktury ve spodní cásti faktury v oblasti Podmínky.',
    'tt_ss_invoices_default_footer'                   => 'Hodnota textu v zápatí, která se zobrazuje ve výchozí šablone faktury v dolní cásti faktury. Napríklad:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Když denní úkolovník (úloha CRON) provede a vygeneruje živou fakturu ze šablony opakující se faktury, mela by být nove vytvorená faktura automaticky zaslána klientovi e-mailem? Toto lze prepsat u jednotlivých klientu.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Když je platba prijata, mely by být tyto platební informace automaticky zaslány klientovi e-mailem?',
    'tt_ss_invoices_online_payment_method'            => 'Zpusob platby, který je prirazen, když klient platí pomocí odkazu na verejnou fakturu. Platební metody lze spravovat prostrednictvím Nastavení systému.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Mel by být na dokumentu zobrazen QR kód, který vede na verejnou adresu URL faktury nebo nabídky?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Meli by mít uživatelé, dokonce i správci, povoleno mazat faktury? Bezpecnejší a lépe dohledatelnou alternativou k mazání faktur je zmena stavu faktury na \'Zrušeno\', což zmení celkovou fakturu na nulu a vyloucí ji z vetšiny seznamu a sestav.',
    'tt_ss_invoices_show_invoices_from'               => 'Když jsou faktury zasílány e-mailem, zobrazí se jako adresa odeslaná poštou. Duležitá poznámka: Hodnota Odpovedet bude vždy hodnotou prirazenou v Nastavení systému -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Pokud je v zobrazení faktury faktura ve stavu Koncept a odeslaná e-mailem, melo by datum faktury zustat nezmeneno nebo se zmenit na aktuální datum? Pokud se zmení datum faktury, aktualizuje se i datum splatnosti.',
    'tt_ss_quotes_default_quote_template'             => 'Vyberte šablonu, která bude standardne použita pri vytvárení nové nabídky. Vlastní šablony by mely být umísteny v .\\custom\\templates\\quote_templates\\ a musí být pojmenovány s príponou .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Vyberte schéma císel dokladu, které se má jako výchozí použít pri vytvárení nových nabídek. Schémata císel dokladu lze vytvorit v Nastavení konfigurace a umožnují vám personalizovat císla dokladu (faktury, nabídky, dobropisy).',
    'tt_ss_quotes_expire_days'                        => 'Výchozí pocet dní po datu (vytvorení) nabídky, po které nabídka vyprší. Pokud kotace vyprší datum vypršení platnosti, rozumí se, že cena se muže zmenit v dusledku kolísání trhu atd.',
    'tt_ss_quotes_default_status_filter'              => 'Filtr stavu, který se má ve výchozím nastavení použít pri prohlížení seznamu faktur.',
    'tt_ss_quotes_auto_convert'                       => 'Pokud je nabídka schválena, melo by to zpusobit automatické vytvorení faktury z nabídky.',
    'tt_ss_quotes_when_converted_action'              => 'Když je nabídka prevedena na fakturu, mely by být platební podmínky použity z nabídky nebo z výchozího nastavení fakturacních podmínek?',
    'tt_ss_quotes_default_terms'                      => 'Hodnota textu podmínek, která se zobrazuje ve výchozí šablone nabídky v dolní cásti nabídky v oblasti Podmínky.',
    'tt_ss_quotes_default_footer'                     => 'Hodnota textu zápatí, která se zobrazuje ve výchozí šablone nabídky v dolní cásti nabídky. Napríklad:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Pokud je nabídka ve stavu Koncept a je zaslána e-mailem, bud rucne, nebo automaticky, co by se melo stát s datem nabídky. Duležitá poznámka: Když je nabídka zaslána e-mailem, stav se automaticky zmení z Koncept na Odesláno.',
    'tt_ss_quotes_recalculate'                        => 'Spustí každou transakci provedenou pro každou cenovou nabídku od data vytvorení do aktuálního data a prepocítá soucty, soucty rádkových položek, dane, slevy a soucty cenových nabídek. To muže trvat dlouho, pokud máte velkou datovou sadu.',
    'tt_ss_taxes_default_rate1'                       => 'Primární sazba dane, která by se mela automaticky použít na nové rádkové položky pridané do faktur nebo nabídek. Danové sazby jsou udržovány prostrednictvím Konfigurace -',
    'tt_ss_taxes_default_rate2'                       => 'Sekundární sazba dane, která by se mela automaticky použít na nové rádkové položky pridané do faktur nebo nabídek. Danové sazby jsou udržovány prostrednictvím Konfigurace -',
    'tt_ss_email_send_method'                         => 'Metoda odesílání e-mailu, kterou by mela FusionInvoice používat. Zmenou zpusobu odeslání se zmení také zobrazení podpurných polí pro zpusob odeslání.',
    'tt_ss_email_allow_self_cert'                     => 'Zapnutím této možnosti vypnete požadavek PHP authentic_peer. Pro více informací vyhledejte na internetu: PHP email self-signed certificate openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Pri odesílání e-mailu se jedná o výchozí adresu pro odpoved, kterou uvidí vaši príjemci.',
    'tt_ss_email_always_cc'                           => 'E-mailová adresa, kterou byste ve výchozím nastavení chteli automaticky kopírovat s každým odeslaným e-mailem.',
    'tt_ss_email_always_bcc'                          => 'E-mailová adresa, kterou chcete ve výchozím nastavení automaticky zasílat jako BCC s každým odeslaným e-mailem.',
    'tt_ss_email_send_test_to'                        => 'E-mailová adresa, která se použije pri kliknutí na tlacítko Odeslat zkušební e-mail.',
    'tt_ss_email_mail_from_addr'                      => 'Výchozí adresa odesílatele, která se použije pri odesílání e-mailu z FusionInvoice. Poznámka: v nastavení systému -',
    'tt_ss_email_mail_from_name'                      => 'Popisný název Mail From, který se bude zobrazovat v odeslaných e-mailech.',
    'tt_ss_email_email_templates'                     => 'E-mailové šablony jsou k dispozici pro mnoho dokumentu a událostí, mezi ne patrí: nabídky, schvalování nabídek, zamítnutí nabídek, faktury, faktury po splatnosti, dobropisy, potvrzení o platbách, oznámení o nadcházejících platbách. Je zahrnuta výchozí šablona, ale mužete také vytváret vlastní šablony, které mohou být jednoduché (jako poskytnuté výchozí šablony) nebo plne formátované HTML.',
    'tt_ss_pdf_driver'                                => 'Ovladac, který se má použít pri vytvárení dokumentu PDF. Výber ovladace \'wkhtmltopdf\' vyžaduje instalaci tohoto programu na místní server a nastavení príslušné binární cesty pro nej.',
    'tt_ss_pdf_binary_path'                           => 'Cesta místního serveru k binárnímu souboru pro wkhtmltopdf. Napríklad C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice podporuje nekolik poskytovatelu online plateb. Povolte poskytovatele, u kterých máte založené úcty. Poskytovatelé, kterí jsou zde povoleni, se zobrazí jako možnosti platby, když vaši klienti prohlížejí své faktury pomocí odkazu na verejnou fakturu (je soucástí výchozího e-mailu s fakturou).',
    'tt_ss_olp_api_key'                               => 'Klíc API vám poskytne váš poskytovatel plateb.',
    'tt_ss_olp_payment_button_text'                   => 'Text, který se zobrazuje na tlacítku zpusobu platby pro tohoto poskytovatele plateb v horní cásti vaší verejné faktury, jak jej vidí vaši klienti.',
    'tt_ss_olp_mode'                                  => 'Podporováno nekterými poskytovateli plateb, což umožnuje více Sandbox (testování) a živé vysílání.',
    'tt_ss_olp_client_id'                             => 'Klientské ID vám poskytuje tento poskytovatel plateb.',
    'tt_ss_olp_client_secret'                         => 'Tajemství klienta vám poskytuje tento poskytovatel plateb.',
    'tt_ss_olp_publishable_key'                       => 'Publikovatelný klíc vám poskytuje tento poskytovatel plateb.',
    'tt_ss_olp_secret_key'                            => 'Tajný klíc vám poskytuje tento poskytovatel plateb.',
    'tt_ss_olp_opp_fees_about'                        => 'Poplatky za zpracování online plateb mohou být úctovány zákazníkum platícím kreditní kartou pomocí odkazu na verejnou fakturu (obsaženého v e-mailu s fakturou).',
    'tt_ss_olp_enable_opp_fees'                       => 'Poplatky za zpracování online plateb mohou být úctovány zákazníkum platícím kreditní kartou pomocí odkazu na verejnou fakturu (obsaženého v e-mailu s fakturou). Tato možnost má globální systémové nastavení, ale muže být také prepsána u jednotlivých klientu.',
    'tt_ss_olp_opp_fee_pct'                           => 'Procento z celkové cástky faktury, které bude úctováno jako poplatek za zpracování online platby (pohodlí).',
    'tt_ss_olp_opp_fee_name'                          => 'Název poplatku, který bude uveden na fakture. Tj. \'Poplatek za pohodlí kreditní karty\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Vysvetlení poplatku, který má být uveden na fakture. Tj. „Za všechny transakce kreditní kartou je úctován poplatek ve výši 3 %“',
    'tt_company_profiles_about'                       => 'Firemní profily vám umožnují prezentovat vaši firmu odlišne s každým profilem, což umožnuje ruzné názvy spolecností, loga, formáty faktur atd. Poskytuje zpusob, jak mít více virtuálních spolecností v rámci stejné instalace FusionInvoice. V nastavení systému je treba vybrat výchozí profil spolecnosti.',
    'tt_users_about'                                  => 'Mužete vytvorit uživatele typu Admin (plný prístup) nebo Standardní (musí být udelena individuální systémová oprávnení). Nastavením možnosti „Povolit prihlášení do klientského centra“ na Ano pro záznam klienta se automaticky pridá záznam uživatele pro klienta, avšak uživatelé klienta lze pridat pouze pomocí rozhraní nastavení klienta.',
    'tt_users_client_about'                           => 'Klienti se mohou prihlásit pouze do Klientského centra, které jim umožnuje omezený pohled na jejich faktury, nabídky a platby. Nastavením možnosti „Povolit prihlášení do klientského centra“ na Ano u záznamu o klientech jim umožníte prístup do klientského centra.',
    'tt_user_types_about'                             => 'Administrátori mají úplný prístup k systému. Standardním uživatelum mohou být udelena jednotlivá oprávnení, která vyžadují. Klientští uživatelé mají prístup pouze ke svým konkrétním informacím v Klientském centru a jejich možnost prihlášení je nastavena v Klientském nastavení –',
    'tt_custom_fields_about'                          => 'Vlastní pole umožnují pridávat vlastní datová pole do vetšiny modulu. Pokud jste potrebovali zachytit odvetví pro klienty, jednoduše pridejte vlastní pole oznacené \'Industry\' na stránku Klienti, címž se stane rozbalovacím typem. Vlastní pole se automaticky zobrazí pod normálními poli.',
    'tt_recurring_invoices_about'                     => 'Opakované faktury nejsou ve skutecnosti faktury, ale spíše šablony pro vytvárení budoucích faktur. Mají frekvenci opakování a další datum, které urcují, kdy vygenerují aktuální fakturu. Aby opakované faktury správne fungovaly, je vyžadována denní úloha CRON nebo naplánovaná úloha.',
    'tt_addons_about'                                 => 'Doplnky jsou prizpusobení FusionInvoice pro jedinecné obchodní potreby, jako je sledování casu, cenové nabídky nebo sylizované šablony faktur. Jsou nabízeny prostrednictvím tržište doplnku FusionInvoice.',
    'client_center_user'                              => 'Uživatel klientského centra',
    'user_type'                                       => 'Typ uživatele',
    'custom_field'                                    => 'Vlastní pole',
    'placeholder_type_email_template'                 => 'Zadejte nebo vložte šablonu e-mailu. . .',
    'email_templates'                                 => 'Šablony e-mailu',
    'payment_receipts'                                => 'Potvrzení o platbe',
    'upcoming_payment_notices'                        => 'Oznámení o nadcházejících platbách',
    'convenience_fee_for_credit_card_transactions'    => 'Komfortní poplatek za transakce kreditní kartou',
    'credit_card_processing_fee'                      => 'Poplatek za zpracování kreditní karty',
    'delete_client_user_warning'                      => '<p>Smazáním klientského uživatele znemožníte jeho prihlášení do klientského centra.</p>',
    'use_default_mail_template'                       => 'Výchozí šablona pošty',
    'use_custom_mail_template'                        => 'Vlastní šablona pošty',
    'quote_email_body'                                => 'Citace tela e-mailu',
    'overdue_invoice_email_body'                      => 'Telo e-mailu s fakturou po splatnosti',
    'credit_memo_email_body'                          => 'Telo e-mailu dobropisu',
    'payment_receipt_body'                            => 'Telo potvrzení o platbe',
    'invoice_email_body'                              => 'Telo e-mailu faktury',
    'quote_custom_email_body_require'                 => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu s nabídkou',
    'quote_custom_approve_email_body_require'         => 'Zadejte prosím vlastní šablonu e-mailu pro text e-mailu se schválením nabídky',
    'quote_reject_email_body_require'                 => 'Zadejte prosím vlastní šablonu e-mailu pro text e-mailu pro odmítnutí nabídky',
    'overdue_invoice_email_body_require'              => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu faktury po splatnosti',
    'invoice_email_body_require'                      => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu faktury',
    'credit_memo_email_body_require'                  => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu dobropisu',
    'payment_receipt_email_body_require'              => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu s potvrzením o platbe',
    'upcoming_payment_notice_email_body_require'      => 'Zadejte prosím vlastní šablonu e-mailu pro telo e-mailu s oznámením o nadcházející platbe',
    'copy_text'                                       => 'Kopírovat text',
    'tt_preview_template'                             => 'Náhled šablony',
    'tt_view_template_code'                           => 'Zobrazit kód šablony',
    'dashboard_date_range'                            => 'Casové období rídicího panelu',
    'tt_dashboard_date_range'                         => 'Casové období rídicího panelu filtruje zobrazení pro následující widgety: Karty klícových ukazatelu výkonu, Graf prodeje, Nedávná aktivita klienta.',
    'product_copy'                                    => 'Kopie produktu',
    'open_selected_client'                            => 'Otevrete vybraného klienta',
    'save_this_client'                                => 'Uložit tohoto klienta (ne duplikát)',
    'looks_like_duplicate'                            => 'Hmm... Tohle vypadá jako duplikát',
    'duplicate_instructions'                          => 'Pokud v seznamu vidíte požadovaného klienta, vyberte jej a otevrete. Pokud ne, uložte nového klienta.',
    'select_checkbox'                                 => 'Vyberte klienta',
    'select_lead_source_tag'                          => 'Vyberte Zdroj potenciálního zákazníka',
    'lead_source'                                     => 'Hlavní zdroj',
    'tt_client_lead_source_tags'                      => 'Vyberte nebo zadejte zdroj potenciálního zákazníka klienta (jak byl klient získán)',
    'your_link_is_expired'                            => 'Jejda! Platnost vašeho odkazu vypršela.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Návrat na palubní desku</a>.',
    'secure_link_and_expire_link_days'                => 'Zabezpecení a vypršení platnosti odkazu na verejnou fakturu',
    'secure_link_expire_days'                         => 'Pocet dní',
    'tt_secure_link_and_expire_link_days'             => 'Pri aktivaci zabezpecených odkazu musíte také nastavit pocet dní, po kterých vyprší platnost odkazu na fakturu. Tímto zpusobem muže klient zobrazit odkaz na verejnou fakturu, dokud nevyprší jeho platnost.',
    'expire_time_period'                              => 'Pole Pocet dní vypršení platnosti odkazu je povinné',
    'enter_days'                                      => 'Zadejte dny',
    'invalid_field_name'                              => 'Zadejte prosím platný název pole',
    'lead_source_notes'                               => 'Poznámky k hlavnímu zdroji',
    'important_note'                                  => 'Duležitá poznámka',
    'social_media_url'                                => 'URL sociálních médií',
    'general_notes'                                   => 'Obecné poznámky',
    'payment_amount_mismatch'                         => 'Nesoulad cástky platby',
    'open_invoice_aging'                              => 'Otevrené stárnutí faktur',
    'tt_db_open_invoice_aging'                        => 'Otevrené stárnutí faktur',
    'current'                                         => 'Proud',
    'oneToThirty'                                     => '1-30 dní',
    'thirtyOneToSixty'                                => '31-60 dní',
    'sixtyOneToNinety'                                => '61-90 dní',
    'ninetyOnePlus'                                   => '91 dní',
    'sent_and_draft'                                  => 'Zahrnte odeslané i koncepty faktur',
    'sent_only'                                       => 'Zahrnout pouze odeslané faktury',
    'tt_open_ar_aging_settings'                       => 'Nastavení pro soucty stárí otevrené faktury',
    'tt_client_field_settings'                        => 'Vyberte pole, která chcete zobrazit v zobrazení klienta',
    'position_change'                                 => 'Pozice zmenena',
    'dynamic_width'                                   => 'Dynamická šírka',
    'full_width'                                      => 'Plná šírka',
    'save_configuration_default'                      => 'Uložte konfiguraci jako výchozí systém',
    'assign_configuration_other'                      => 'Pridelte konfiguraci ostatním uživatelum',
    'tt_user_tags'                                    => 'Uživatelské znacky',
    'select_users'                                    => 'Vyberte možnost Uživatelé',
    'configuration_assigned'                          => 'Konfigurace byla úspešne prirazena',
    'default_configuration_set'                       => 'Výchozí konfigurace byla úspešne nastavena',
    'current_user_id'                                 => 'ID aktuálního uživatele',
    'tt_users_settings'                               => 'Uživatelská nastavení',
    'invoice_link_expire'                             => 'Platnost vašeho verejného odkazu na fakturu vyprší za',
    'quote_link_expire'                               => 'Platnost vašeho verejného odkazu na cenovou nabídku vyprší za',
    'dashboard_width'                                 => 'Nastavení šírky sloupce rídicího panelu :widthName bylo zmeneno',
    'unmark_mailed'                                   => 'Zrušit oznacení jako odeslané',
    'invoice_unmark_mailed'                           => 'Zrušte oznacení faktury jako odeslané',
    'print_mark_mailed'                               => 'Vytisknout',
    'public_link'                                     => 'Verejný odkaz',
    'tt_sales_chart_settings'                         => 'Nastavení pro prodejní graf faktura/celkem',
    'verify_key'                                      => 'Overení kódu Product Key',
    'enter_key'                                       => 'Zadejte svuj klíc',
    'verify'                                          => 'Overte to!',
    'key_required'                                    => 'Je vyžadován produktový klíc',
    'key_length_invalid'                              => 'Zadejte prosím 32znakový kód Product Key poskytnutý pri nákupu.',
    'invalid_key'                                     => 'Litujeme, váš klíc je neplatný. Instalace nemuže pokracovat.',
    'key_verified'                                    => 'Gratulujeme, váš klíc byl overen.',
    'clear_cache'                                     => 'Vycistit mezipamet',
    'clear_cache_confirm'                             => 'Opravdu chcete vymazat mezipamet aplikace?',
    'cache_clear_success'                             => 'Mezipamet byla úspešne vymazána.',
    'cache_clear_error'                               => 'Zkontrolujte konfiguraci serveru pro príkaz PHP exec().',
    'add_new_client'                                  => 'Pridat nového klienta',
    'add'                                             => 'Pridat',
    'invalid_quantity_amount'                         => 'Neplatná cástka množství! Musí být vetší než 0.',
    'api_version'                                     => 'Verze API',
    '2021_prior'                                      => '2021 a predchozí',
    '2022_later'                                      => '2022 a pozdeji',
    'vendors'                                         => 'Prodejci',
    'file_not_found'                                  => ':file_name nebyl nalezen',
    'leave_empty_no_parent_account'                   => 'ponechte prázdné, pokud klient nemá nadrazený úcet',
    'leave_empty_client_pays_invoices'                => 'ponechte prázdné, pokud klient platí své vlastní faktury',
    'modal_not_found'                                 => 'Modal nebyl nalezen',
    'payment_delete_success'                          => 'Platba byla úspešne smazána',
    'payment_delete_error'                            => 'Pri mazání platby došlo k problému, zkuste to prosím znovu pozdeji.',
    'status_change_error'                             => 'Neco se pokazilo! Stav nebyl zmenen.',
    'total_payments'                                  => 'Celkové platby',
    'licence_verification_error'                      => 'Licencní klíc nelze overit.',
    'line_item_discount_limit'                        => 'Rádkové položky nesmí mít slevu vyšší než 99,99 %.',
    'date_range_report'                               => 'Casové období (príští datum spuštení)',
    'no_client_found'                                 => 'Hmmm... toho klienta jsme nenašli.',
    'tt_line_item_discount'                           => 'Slevu rádkové položky lze vypocítat procentem z ceny nebo pevnou cástkou za cenu jednotlivé položky.',
    'functionality_not_available_on_demo'             => 'Je nám líto, tato funkce není v ukázce povolena.',
    'vat_tax_id'                                      => 'DIC',
    'tt_vat_tax_id'                                   => 'Císlo dane z pridané hodnoty (DPH).',
    'enable_vat_tax_id'                               => 'Povolit DIC',
    'no-attachment'                                   => 'Neexistuje žádná príloha',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Uklidit',
    'allow_edit_status_invoice'                       => 'Upravit fakturu :status',
    'tt_ss_allow_edit_invoices_status'                => 'Z bezpecnostních duvodu lze upravovat pouze faktury ve stavu Koncept. Toto mužete prepsat povolením úprav Odeslaných a/nebo Zaplacených faktur.',
    'allow_edit_invoices_status'                      => 'Povolit úpravy faktur ve stavu',
    'draft_and_sent'                                  => 'Koncept A Odeslané',
    'draft_or_sent_and_paid'                          => 'Koncept, odesláno a zaplaceno',
    'invoice_editable'                                => 'Faktura upravitelná',
    'can_not_edit_paid_invoice'                       => 'Uhrazenou fakturu nelze upravit',
    'item_category'                                   => 'Kategorie položky',
    'itemLookups'                                     => 'Vyhledávání položek',
    'quoteItems'                                      => 'Nabídka položek',
    'invoiceItems'                                    => 'Fakturacní položky',
    'imports_disabled_in_demo.'                       => 'Importy jsou v ukázce zakázány.',
    'no_file_selected'                                => 'Žádný soubor nevybrán',
    'no_import_records'                               => 'Nebyly nalezeny žádné záznamy k importu',
    'vendor_name'                                     => 'Jméno prodejce',
    'license_key'                                     => 'Licencní klíc',
    'change_license_key'                              => 'Zmenit licencní klíc',
    'verify_and_save'                                 => 'Overte',
    'same_key_error'                                  => 'Nebyla zjištena žádná zmena. Zkuste prosím jiný klíc',
    'trying_invalid_key'                              => 'Litujeme, tento klíc nelze overit. Licencní klíc nebyl zmenen.',
    'key_updated'                                     => 'Gratulujeme! Váš licencní klíc byl úspešne aktualizován.',
    'invalid_date_format'                             => 'Neplatný formát data. Požadovaný formát: RRRR-MM-DD',
    'invalid_datetime_format'                         => 'Neplatný formát data a casu. Požadovaný formát: RRRR-MM-DD HH:MM :SS',
    'profile_setting'                                 => 'Nastavení profilu',
    'include_draft_invoices_unpaid_and_overdue'       => 'Zahrnout koncepty faktur do seznamu nezaplacených a po splatnosti',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Pokud je nastaveno na Ano, budou faktury se stavem Koncept zahrnuty do seznamu a výpoctu pro faktury po splatnosti a nezaplacené faktury.',
    'tt_utilities_import'                             => 'Importujte data ze souboru CSV do databáze FusionInvoice.',
    'tt_utilities_export'                             => 'Exportujte data z databáze FusionInvoice do rady ruzných formátu: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Zobrazte soubor protokolu, který obsahuje všechny e-mailové události v rámci FusionInvoice.',
    'tt_utilities_system_log'                         => 'Zobrazte soubor protokolu systému obsahující chybové a varovné systémové události.',
    'tt_utilities_tag_cleanup'                        => 'Odstraní znacky, které byly definovány, ale nebyly použity. Také odstraní všechny duplicitní znacky.',
    'tt_utilities_pdf_cleanup'                        => 'Odstraní docasné soubory PDF.',
    'tt_utilities_recalc_invoices'                    => 'Prohledá každou fakturu a zajistí, že soucty odpovídají souctu všech rádkových položek, pricemž zohlední slevy a dan. *To muže trvat dlouho.',
    'tt_utilities_recalc_quotes'                      => 'Prohledá každou cenovou nabídku a zajistí, že soucty odpovídají souctu všech rádkových položek, pricemž zohlední slevy a dan. *To muže trvat dlouho.',
    'tt_utilities_clear_cache'                        => 'Odstraní docasné soubory mezipameti.',
    'tt_utilities_download_database'                  => 'Stáhnete si exportovaný soubor databáze z vašich živých dat FusionInvoice. Cím vetší databáze, tím déle to bude trvat.',
    'tt_utilities_run_daily_tasks'                    => 'Úloha CRON nebo naplánovaná úloha obvykle spouští vaše denní úlohy. To vám umožní provést to rucne. Generuje živé faktury ze šablon opakujících se faktur, odesílá upomínky plateb atd.',
    'include_line_item_detail'                        => 'Zahrnout podrobnosti o rádkové položce',
    'invoice_tags'                                    => 'Fakturacní štítky',
    'related_accounts'                                => 'Související úcty',
    'not_found_related_clients'                       => 'Nebyly prirazeny žádné související klientské úcty',
    'invoices_paid_for_list'                          => 'Tento klientský úcet platí faktury za',
    'child_accounts_exist'                            => 'Nastavení Povolit podrízené úcty se vrátilo na Ano. Nelze zmenit na Ne, pokud podrízené úcty existují.',
    'third_bp_accounts_exist'                         => 'Nastavení 3rd Party Bill Payer se vrátilo na Ano. Nelze zmenit na Ne, pokud existují související úcty.',
    'tag_name'                                        => 'Název štítku',
    'tag_new_name'                                    => 'Nový název znacky',
    'tag_category'                                    => 'Kategorie znacky',
    'rename_tags'                                     => 'Prejmenovat znacky',
    'apply'                                           => 'Aplikovat',
    'select_tag_category'                             => 'Vyberte Kategorie štítku',
    'tt_utilities_rename_tags'                        => 'Prejmenujte znacky prirazené klientum, poznámkám, prodejním aktivitám atd.',
    'system_default_dashboard'                        => 'Výchozí rídicí panel systému',
    'user_specific_dashboards'                        => 'Panely specifické pro uživatele',
    'tt_default_client_type'                          => 'Výchozí typ klienta',
    'default_client_type'                             => 'Výchozí typ klienta',
    'invalid_user'                                    => 'Vyberte platného uživatele.',
    'create_live_invoice'                             => 'Vytvorte živou fakturu',
    'create_live_invoice_successfully'                => 'Živá faktura',
    'create_live_invoice_unsuccessfully'              => 'Skutecná faktura nebyla vytvorena',
    'live_invoice_not_generate'                       => 'Nelze vygenerovat živou fakturu z opakující se faktury, která má datum ukoncení dnešní nebo predchozí, nebo další datum více než 30 dní v budoucnosti.',
    'data_seeder'                                     => 'Data Seeder',
    'select_module'                                   => 'Vyberte Modul',
    'number_of_seed'                                  => 'Pocet semen',
    'seed_it'                                         => 'Seed It!',
    'seeds_success'                                   => 'Semena byla úspešne pridána',
    'tt_ri_generate_the_next_live_invoice'            => 'Vygenerujte další aktuální fakturu pro tuto opakovanou fakturu práve ted.',
    'system_log_clear_message'                        => 'Opravdu chcete vymazat systémový protokol? Tuto akci nelze vrátit zpet a všechny predchozí protokoly budou trvale smazány.',
    'system_log_clear_successfully'                   => 'Systémový protokol byl úspešne vymazán',
    'payment_problem'                                 => 'Pri platbe nastal problém. Prosím zkuste to znovu pozdeji.',
    'log_detail'                                      => 'Kliknutím sem zobrazíte podrobný protokol.',
    'log_limit_message'                               => 'Log soubor',
    'log_download_file'                               => 'Stáhnout soubor',
    'log_delete_all'                                  => 'Smažte všechny soubory',
    'log_level'                                       => 'Úroven',
    'log_context'                                     => 'Kontext',
    'log_date'                                        => 'datum',
    'log_line_number'                                 => 'Císlo rádku',
    'log_content'                                     => 'Obsah',
    'addon_install_error'                             => 'Došlo k problému s instalací doplnku, zkuste to znovu pozdeji.',
    'addon_installed_success'                         => 'Addon byl úspešne nainstalován.',
    'allow_edit_status_credit_memo'                   => 'Upravit použitý dobropis',
    'database_seeder'                                 => 'Secí stroj',
    'tt_utilities_database_seeder'                    => 'Osadte svou databázi testovacími daty pomocí tríd semen',
    'vat_information'                                 => 'Informace o DPH',
    'tt_vat_information'                              => 'IBAN císlo bankovního úctu, BIC, email atd...',
    'explore_addons'                                  => 'Prozkoumejte doplnky',
    'available_addons'                                => 'Dostupné doplnky FusionInvoice',
    'addon_success'                                   => 'Addon byl úspešne pridán.',
    'payment_cannot_enabled_in_demo'                  => 'V ukázce nelze aktivovat platební brány',
    'confirm_approve_leave_page'                      => 'Na této stránce jsou neuložené zmeny! Opravdu chcete odejít bez uložení?',
    'leave'                                           => 'Odejít',
    'demo_date_refresh'                               => 'Demo data budou obnovena za',
    'minutes'                                         => 'minut',
    'minute'                                          => 'minuta',
    'seconds'                                         => 'sekundy',
    'mautic-authentication-fail'                      => 'Nemáte oprávnení k prístupu k tomuto zdroji, použijte prosím platný tajný klíc.',
    'something_went_wrong'                            => 'Neco se pokazilo!',
    'month_to_date'                                   => 'Tento mesíc do dnešního dne',
    'quarter_to_date'                                 => 'Toto ctvrtletí k dnešnímu dni',
    'year_to_date'                                    => 'Tento rok',
    'last_active'                                     => 'poslední aktivní',
    'database_seeder_stop'                            => ':name ZASTAVENÍ PODNIKATELU',
    'database_seeder_start'                           => ':name ZACÁTEK PODNIKÁNÍ',
    'seeder_records_created'                          => ':total Záznamy úspešne vytvoreny pro :modal',
    'seeder_credit_apply_invoice'                     => 'Dobropis použít na fakturu',
    'seeder_quote_approve_reject'                     => 'Nabídka Schválit A Odmítnout',
    'seeder_executed'                                 => 'Secí stroj byl úspešne proveden!',
    'seeder_not_executed'                             => 'Seeder nebyl popraven!',
    'db_to_file_system_attachments_migration'         => 'Migrace príloh – databáze do souborového systému',
    'attachment_content_count'                        => 'Chystáte se migrovat celkem',
    'attachment_repeat_content_count'                 => 'Chystáte se migrovat celkem',
    'attachment_key_invalid'                          => 'Klíc prílohy je neplatný',
    'stop'                                            => 'Stop!',
    'attachment_migration_warning'                    => 'Tento krok provede migraci príloh z databáze do systému souboru. Pred pokracováním provedte úplnou zálohu databáze a ujistete se, že máte k provedení této operace dostatek místa na disku.',
    'attachment_agreement_accept'                     => 'Zálohoval jsem databázi.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Heslo Microsoft 365',
    'office365_username'                              => 'Uživatelské jméno Microsoft 365',
    'custom_date_formula_note1'                       => '<b><u>Výchozí hodnota zástupných symbolu :</span></u></b> ~<br> Jako výchozí mužete použít libovolnou hodnotu <b>dnes, zítra a vcera</b> .<br>',
    'custom_date_formula_note2'                       => '<b>Pro dnešek + N dní použijte </b> \'výchozí\': \'+7\' Tím se k dnešnímu datu pridá 7 dní <br><b>Pro dnešek - N dní použijte </b> \'výchozí\': \'-7\' Toto odecte 7 dní od dnešního data <br>',
    'mail_config_error'                               => 'Bez definované metody odesílání e-mailu nelze odeslat zkušební e-mail.',
    'db_prefix_alert'                                 => 'Všimli jsme si, že používáte predponu databáze :prefix . FusionInvoice nebude v budoucích verzích podporovat databázové predpony. Upravte prosím svou databázi a prejmenujte všechny své tabulky odstranením predpony, poté upravte soubor database.php a nastavte hodnotu \'prefix\' na prázdnou',
    'db_prefix_alert_title'                           => 'Podpora prefixu DB brzy skoncí',
    'add_title_bar_shortcut'                          => 'Pridat zástupce záhlaví',
    'title_bar_shortcuts'                             => 'Zkratky záhlaví',
    'select_icon'                                     => 'Vyberte ikonu',
    'all_payment_method'                              => 'Všechny zpusoby platby',
    'about'                                           => 'O',
    'own_license'                                     => 'Vlastní licence',
    'tt_own_license'                                  => 'Vlastní licence',
    'git_branch'                                      => 'Aktuální vetev Git',
    'quote_email'                                     => 'E-mail s citací',
    'custom1'                                         => 'Vlastní 1',
    'custom2'                                         => 'Vlastní 2',
    'custom3'                                         => 'Vlastní 3',
    'default_document_template'                       => 'Výchozí šablona dokumentu',
    'default_email_template'                          => 'Výchozí šablona e-mailu',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Cenový vzorec',
    'is_mobile'                                       => 'Je mobilní?',
    'default_sms_template'                            => 'Výchozí šablona SMS',
    'sms_log'                                         => 'Záznam SMS',
    'two_factor_auth'                                 => 'Dvoufaktorová autentizace',
    'enabled_mail_driver'                             => 'Povolte e-mailovou službu',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Neplatný overovací kód',
    'otp-subject'                                     => 'Prihlašovací OTP',
    'resend_otp_success'                              => 'Znovu odeslán overovací kód',
    'resend_otp_btn'                                  => 'Znovu odeslat kód',
    'expired_otp'                                     => 'Platnost overovacího kódu vypršela',
    'token_expired'                                   => 'Platnost vašeho tokenu CSRF vypršela',
    'verification_code'                               => 'Overovací kód',
    'migration'                                       => 'Migrace',
    'invoice_status_change_draft_to_sent'             => 'Stav faktury se zmenil z konceptu na odeslanou',
    'default_sales_quantity'                          => 'Výchozí prodejní množství',
    'lead_time'                                       => 'Prum. Doba dodání (dny)',
    'primary_vendor_id'                               => 'Preferovaný prodejce',
    'all_items'                                       => 'Všechny položky',
    'non_inventory_items'                             => 'Položky bez zásob',
    'back_ordered'                                    => 'Zpet objednáno',
    'low_inventory'                                   => 'Nízké zásoby',
    'high_inventory'                                  => 'Vysoké zásoby',
    'merge_client_records'                            => 'Sloucit záznamy klienta',
    'primary_merge_to_client'                         => 'Sloucit do (zachovat)',
    'surrogate_merge_from_client'                     => 'Sloucit z (zahodit)',
    'merge'                                           => 'Spojit',
    'merge_action'                                    => 'Akce sloucení',
    'ignore'                                          => 'Ignorovat',
    'overwrite'                                       => 'Prepsat',
    'add_to'                                          => 'Pridat do',
    'select_merge_client'                             => 'Vyberte Pro sloucení',
    'client_to_and_from_not_same'                     => 'Klient do a klient od se musí lišit.',
    'client_id_required'                              => 'Pole výberu klienta musí být povinné a jedinecné.',
    'is_merge'                                        => 'Spojit',
    'record_successfully_merged'                      => 'Záznam byl úspešne sloucen',
    'service_ends'                                    => 'Služba koncí',
    'service_starts'                                  => 'Spuštení služby',
    'explanation'                                     => 'Vysvetlení',
    'subscription_details'                            => 'Podrobnosti o predplatném',
    'generate_next_invoice'                           => 'Generovat další fakturu',
    'subscription'                                    => 'Predplatné',
    'of_the'                                          => 'z',
    'on'                                              => 'Na',
    'invoice_month'                                   => 'Mesíc fakturace',
    'invoice_year'                                    => 'Rok faktury',
    'next_month'                                      => 'Príští mesíc',
    'next_year'                                       => 'Príští rok',
    'day'                                             => 'Den',
    'last_date'                                       => 'Poslední datum',
    'merge_record_warning'                            => 'Stop! Sloucení klientských úctu nelze vrátit zpet. Krome polí, která jste vybrali k prepsání nebo pridání, se do klienta sloucení prenese veškerá historie transakcí pro klienta sloucení. Opravdu chcete tyto klientské úcty sloucit?',
    'merge_child_account_warning'                     => 'Klient Merge(From) má nadrazený úcet se souvisejícími podrízenými úcty, které budou znovu prirazeny klientovi Merge(To), ujistete se, že je klient Merge(To) povolen jako nadrazený úcet.',
    'merge_parent_account_warning'                    => 'Sloucením se odstraní vaše pridružení k nadrazenému úctu.',
    'merge_invoices_paid_by_warning'                  => 'Sloucením se odstraní vaše spojení s nadrazenou fakturou, kterou zaplatil.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Pocet vztahu v modelu Klient se zmenil.',
    'payment_terms'                                   => 'Platební podmínky',
    'net_amount_due_in'                               => 'Cistá splatná cástka v',
    'net_amount_due_by'                               => 'Cistá cástka splatná do',
    'if_paid_within'                                  => 'pokud je zaplaceno v rámci',
    'if_paid_by'                                      => 'pokud platí',
    'th_of_next_month'                                => 'dne príštího mesíce',
    'of_next_month'                                   => 'príštího mesíce',
    'down_payment'                                    => 'Záloha',
    'balance_amount_due_of'                           => 'zustatek splatný v',
    'payment_split_over'                              => 'Platba rozdelena',
    'installments'                                    => 'splátky',
    'days_from_invoice_date'                          => 'dnu od data vystavení faktury',
    'payment'                                         => 'Zpusob platby',
    'one'                                             => 'Jeden',
    'two'                                             => 'Dva',
    'three'                                           => 'Tri',
    'four'                                            => 'Ctyri',
    'five'                                            => 'Pet',
    'six'                                             => 'Šest',
    'discount_percent'                                => 'Procento slevy',
    'discount_days_simple'                            => 'Slevové dny jednoduché',
    'discount_days_nth'                               => 'Slevové dny N-tý',
    'net_due_days'                                    => 'Cisté splatné dny',
    'balance_due_days'                                => 'Dny splatnosti zustatku',
    'number_of_installments'                          => 'Pocet Splátek',
    'payment_term'                                    => 'Platební lhuta',
    'select_payment_term'                             => 'Vyberte Platební termín',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Pole procento splátek :index je povinné a vetší než nula.',
        'installment_due_days_error'                  => 'Je vyžadováno pole Dny splatnosti splátek :index',
        'discount_percent_gt_error'                   => 'Vyplnené procento slevy je povinné a vetší než nula.',
        'discount_percent_lt_error'                   => 'Je nutné zadat procento slevy a méne než 100 %.',
        'down_payment_percent_lt_error'               => 'Je požadováno procento zálohy a méne než 100 %.',
        'discount_percent_numeric_error'              => 'Pole procento slevy musí být císelná hodnota a musí být menší než 100 %.',
        'down_payment_gt_error'                       => 'Vyplnená záloha je povinná a vetší než nula.',
        'discount_days_gt_net_days_error'             => 'Dny splatnosti cisté cástky by mely být vetší než dny slevy.',
        'discount_days_nth_gt_net_days_error'         => 'Dny splatnosti cisté cástky by mely být vetší než N-tý den slevy.',
        'installment_due_days_gt_error'               => 'Dny splatnosti splátek :index by mely být vetší než :preIndex dny splatnosti splátek.',
        'installment_percent_total_error'             => 'Celkové procento splátek není presné. mela by se rovnat 100 %.',
        'installment_percent_numeric_error'           => 'Celkové procento splátek není presné. Mela by to být císelná hodnota.',
        'term_discount'                               => 'Termínová sleva',
        'installment_due_days_gt_zero_error'          => 'Dny splatnosti splátek :index by mely být vetší nebo rovné nule.',
        'net_due_days_error'                          => 'Dny splatnosti cisté cástky by mely být vyšší než nula a mely by být povinné vyplnit.',
        'discount_days_simple_error'                  => 'Jednoduché dny slevy by mely být vetší než nula a mely by být vyplneny.',
        'discount_days_nth_error'                     => 'N-tý den slevy by mel být vetší než nula a mel by být vyplnen.',
        'balance_due_days_error'                      => 'Dny splatnosti zustatku by mely být vetší než nula a mely by být vyplneny.',
        'status_error'                                => 'Litujeme, stav se nezmenil kvuli termínu použitému na fakture.',
        'down_payment_type_invoice_description_error' => 'Zadaný token popisu faktury se neshoduje s typem zálohy.',
        'down_payment_type_quote_description_error'   => 'Zadaný token popisu nabídky se neshoduje s typem vaší zálohy.',
    ],
    'quotes_delete_error'                             => 'Chyba mazání uvozovek',
    'for'                                             => 'Pro',
    'production'                                      => 'Výroba',
    'access_token'                                    => 'Prístupový token',
    'application_id'                                  => 'ID aplikace',
    'location_id'                                     => 'ID umístení',
    'fi_config_check'                                 => 'Predpoklady Zkontrolujte',
    'requirement'                                     => 'Požadavek',
    'required'                                        => 'Požadované',
    'actual'                                          => 'Aktuální',
    'result'                                          => 'Výsledek',
    'db_prefix_setup_alert'                           => 'Vaše databáze FusionInvoice používá predpony DB. Podpora prefixu DB skoncila s verzí 2023-3.0. Chcete-li pokracovat v upgradu na tuto a budoucí verze, je nutné odebrat predpony DB. Mužete to udelat prejmenováním všech tabulek ve vaší DB a odstranením prefixu a také nastavením hodnoty \'prefix\' => \'\' ve vašem souboru database.php.',
    'open_tasks'                                      => 'Otevrete Úkoly',
    'closed_tasks'                                    => 'Uzavrené úkoly',
    'select_status'                                   => 'Vyberte Stav',
    'net_amount_due_invoice'                          => 'Cistá cástka splatná za :days dny.',
    'days_add_in_current_date'                        => 'Aktuální datum ke dni <span class="text-blue">:date</span> , a datum splatnosti se považují za <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">pocet dní</span>.',
    'terms'                                           => 'Podmínky',
    'quote_rejecting_error'                           => 'Faktura c. :invoice_number byla vytvorena dne :invoice_date od schválení této nabídky. Pred odmítnutím této nabídky musíte tuto fakturu smazat nebo zrušit.',
    'resend_record_warning'                           => 'Odeslat tento e-mail nyní znovu?',
    'resend_email'                                    => 'Preposlat email',
    'requirement_check_fail'                          => 'Než bude instalace pokracovat, musíte opravit výše uvedené chyby.',
    'failed'                                          => 'Nepodarilo se',
    'subscriptions'                                   => 'Predplatné',
    'tt_explanation'                                  => 'Zadejte popis služby s volitelnými zástupnými symboly data. K dynamickému vkládání dat zahájení a ukoncení služby mužete použít následující tokeny:{{service_starts_on}} a {{service_ends_on}}. Ty budou pri zobrazení obsahu nahrazeny skutecnými daty zahájení a ukoncení.',
    'tt_ss_invoices_default_payment_terms'            => 'Výchozí platební podmínky faktury',
    'invoices_default_terms'                          => 'Výchozí podmínky faktur',
    'net_amount_due_in_n_days'                        => 'Cistá cástka splatná za N dní',
    'last_day'                                        => 'Poslední den',
    'down_payment_payment_term1'                      => 'Záloha ve výši',
    'down_payment_payment_term2'                      => 'je požadováno.  Zustatek je splatný v',
    '1_type'                                          => 'Faktura vytvorená dnes bude splatná za <span class="text-primary">#N</span> dní',
    '2_type'                                          => 'Faktura vytvorená dnes umožní slevu, pokud ji zaplatíte do <span class="text-primary">#date</span> , pokud ne, celá cástka je splatná do <span class="text-primary">#N</span>  dnu',
    '3_type'                                          => 'Faktura vytvorená dnes umožní slevu, pokud bude zaplacena do <span class="text-primary">#date</span>  . Cistá cástka je splatná do <span class="text-primary">#N</span>  dnu',
    '4_type'                                          => 'Faktura vytvorená dnes bude vyžadovat zálohu ve <span class="text-primary">#amount</span>  . Zbývající zustatek bude splatný do <span class="text-primary">#N</span>  dnu',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Faktura vytvorená dnes a rozdelená na <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Platba <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Splatné <span class="text-primary">#date</span></p>',
    'installment'                                     => 'splátka',
    'apply_payment_terms'                             => 'Uplatnete platební podmínky výše slevy',
    'payable_amount'                                  => 'Konecná splatná cástka',
    'payable_amount_lt_error'                         => 'Konecná splatná cástka by mela být nižší než zustatek na fakture.',
    'payment_term_type_4_amount'                      => 'Cástecná platba :amount prijata',
    'net_terms'                                       => 'Cisté podmínky',
    'proforma_invoice_default'                        => 'Výchozí proforma faktura',
    'expense_vendor'                                  => 'Prodejce nákladu',
    'expense_vendor_deleted'                          => 'Prodejce nákladu byl smazán',
    'expense_vendor_already_used'                     => 'Nemužete odstranit dodavatele, který má související položky nákladu.',
    'total_must_be_gt_zero'                           => 'Soucet :modal_name musí být vetší než nula.',
    'payment_failed'                                  => 'Platba se nezdarila s :error',
    'xss_validation'                                  => 'Pole :attribute obsahuje znacky, které by mohly odhalit chybu zabezpecení XSS',
    'support_desk'                                    => 'Pracovní stul podpory',
    'choose_file'                                     => 'Vyberte soubor',
    'supportTicket'                                   => 'Pracovní stul podpory',
    'create_support_ticket'                           => 'Vytvorit lístek podpory',
    'supportTicket_inbox_view'                        => 'Pracovní stul podpory',
    'support_ticket'                                  => 'Vstupenka na podporu',
    'ticket_number'                                   => 'Císlo lístku',
    'revision'                                        => 'Revize',
    'revisions'                                       => 'Revize',
    'recurring_invoices'                              => 'Pravidelné faktury',
    'message'                                         => 'Zpráva',
    'custom_img'                                      => 'Vlastní obrázek',
    'please_fill_some_data'                           => 'Vyplnte prosím požadované údaje o nové položce.',
    'assigned'                                        => 'Zadáno',
    'add_ons_will_be_disabled'                        => 'NÁSLEDUJÍCÍ DOPLNKY BUDOU ZAKÁZÁNY:',
    'add_ons_will_be_disabled_msg'                    => 'Behem upgradu jádra FusionInvoice jsou všechny doplnky automaticky zakázány. Po dokoncení tohoto upgradu se ujistete, že jste stáhli príslušné doplnkové soubory zip a nainstalovali je. Jakmile to udeláte, mužete je znovu povolit z nabídky Nastavení systému, Prizpusobení, Doplnky a výberem [Instalovat].',
    'price_not_valid'                                 => 'Cena musí být vetší než nula',
    'free_space'                                      => 'Volný prostor',
    'expense_type'                                    => 'Typ výdaje',
    'standard_expense'                                => 'Standardní výdaj',
    'expense_with_deductible_tax'                     => 'Výdaj s odpocitatelnou daní',
    'remittance_to_tax_authority'                     => 'Prevod danovému úradu',
    'tax_paid'                                        => 'Dan zaplacena',
    'tax_detail'                                      => 'Danový detail',
    'select_expense_type'                             => 'Vyberte Typ výdaje',
    'taxes_paid_on_expenses_or_remitted'              => 'Dane Zaplacené Z Výdaju Nebo Odvedené',
    'tax_name'                                        => 'Danový název',
    'last_activity'                                   => 'poslední aktivita',
    'select_default_company_profile'                  => 'Vyberte svuj výchozí profil spolecnosti',
    'mn_sales_tax'                                    => 'Dan z obratu MN',
    'taxes_collected_on_sales'                        => 'Dane vybrané z prodeje',
    'vatgst_tax_note'                                 => 'Ano vypocítá dan jako zahrnutou do celkové položky. Ne pripocte dan k celkové položce.',
    'tt_vatgst_tax'                                   => 'V tomto príkladu budeme predpokládat danovou sazbu 5 % a cenu položky 100 USD. Nastavením Povolit DPH/GST na Ano získáte celkovou fakturu 100 USD, pricemž cástka položky se upraví na 95,24 USD a cástka dane 4,76 USD. Nastavením DPH/GST na Ne vynese faktura v celkové výši 105 USD s cenou položky 100 USD a daní 5 USD.',
    'level_of_detail'                                 => 'Úroven detailu',
    'tax_report'                                      => 'Danová zpráva',
    'detail'                                          => 'Detail',
    'totals'                                          => 'soucty',
    'totals_with_dots'                                => 'Celkem . . .',
    'yes_all'                                         => 'ano (vše)',
    'invoices_only'                                   => 'Pouze faktury',
    'payment_receipts_only'                           => 'Pouze potvrzení o platbe',
    'role'                                            => 'Role',
    'previous_email'                                  => 'Predchozí e-mail',
    'web_store_user_id'                               => 'ID uživatele internetového obchodu: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Cistá cástka splatná do <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Pri platbe do #DISCOUNTPERCENT % <span class="text-info">#DISCOUNTDATE</span>  jinak je cistá cástka splatná do <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'Pri platbe do #DISCOUNTPERCENT % <span class="text-info">#DISCOUNTDATE</span>  jinak je cistá cástka splatná do <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'Záloha ve výši <span class="text-info">#DOWNPAYMENT</span>  je k datu #INVOICEDATE . Zustatek je splatný do <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Platby lze rozdelit do <span class="text-info">#NUMBEROFINSTALLMENTS</span> splátek</p>',
        '5_1_type'     => '<li>Platba <span class="text-info">#PERCENT %</span> splatná <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Príští mesíc má celkem #N dní, takže zadejte hodnotu mezi 1 a #N pro dny slevy v príštím mesíci.</span>',
    ],
    'payment_term_not_selected'                       => 'Platební lhuta není vybrána',
    'confirm'                                         => 'Potvrdit',
    'create_live_invoice_now'                         => 'Vytvorit aktuální fakturu?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Predplatné je jako šablona faktury, která se používá k vytvárení aktuálních faktur s danou frekvencí.</p><p class="m-0"> Normálne úloha CRON nebo naplánovaná úloha je nastaven tak, aby se spouštel jednou denne, a je zodpovedný za kontrolu aktuálních faktur, které by mely být vytvoreny, na základe pole data Generate Next Invoice predplatného.  Pokud je tato hodnota data dnes nebo dríve než dnes, automaticky se vytvorí aktuální faktura.</p><p class="m-0"> Tato možnost vám umožnuje rucne vytvorit aktuální fakturu z predplatného a obejít tak automatizovanou metodu . Chcete nyní vytvorit aktuální fakturu?</p>',
    'contact'                                         => 'Kontakt',
    'invoice_month_plus_one'                          => 'Fakturacní mesíc +1',
    'invoice_month_plus_two'                          => 'Fakturacní mesíc +2',
    'invoice_month_plus_three'                        => 'Fakturacní mesíc +3',
    'inbound_email'                                   => 'Príchozí e-mail',
    'outbound_email'                                  => 'Odchozí e-mail',
    'email_signature'                                 => 'Emailový podpis',
    'mail_credential_error'                           => 'Neplatná konfigurace e-mailu. Zkontrolujte prosím nastavení a zkuste to znovu. <strong>( Konfigurace <i class="fa fa-arrow-alt-circle-right"> </i> Nastavení systému <i class="fa fa-arrow-alt-circle-right"> </i> E-mail )</strong>',
    'tt_generate_next_invoice'                        => 'Datum, kdy bude z tohoto predplatného automaticky vytvorena další aktuální faktura.',
    'tt_stop_date'                                    => 'Limit data, po kterém nebudou pro toto predplatné automaticky generovány žádné další aktuální faktury. U predplatného, které by melo pokracovat navždy, ponechte toto pole prázdné.',
    'description_template'                            => 'Šablona popisu',
    't_1_description'                                 => 'Celá platba je splatná do #LASTDATE.',
    't_2_description'                                 => 'Vezmete #DISCOUNTPERCENT % slevu, pokud zaplatíte do #DISCOUNTDATE, jinak zaplatte celou fakturovanou cástku do #LASTDATE.',
    't_3_description'                                 => 'Vezmete #DISCOUNTPERCENT % slevu, pokud zaplatíte do #DISCOUNTDATE, jinak zaplatte celou fakturovanou cástku do #LASTDATE.',
    't_4_description'                                 => 'Záloha ve výši #DOWNPAYMENT je splatná #INVOICEDATE, zustatek faktury je splatný do #LASTDATE',
    't_4_1_description'                               => 'Záloha ve výši #DOWNPAYMENTPERCENT je splatná #INVOICEDATE, zustatek faktury je splatný do #LASTDATE',
    't_5_description'                                 => 'Platby se provádejí v #NUMBEROFINSTALLMENTS stejných splátkách',
    't_5_type_description'                            => 'Platba #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT je splatná #LASTDATE',
    'tokens_allowed'                                  => 'Tokeny povoleny',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Vyhodnoceným textem ze šablony je popis pojmu, který se zobrazuje na dokumentech, jako je faktura, nabídky atd.',
    'cc_mail'                                         => 'CC Mail',
    'assigned_inv_sent_or_paid'                       => '*Existují faktury, které byly zaplaceny nebo odeslány, které mají tento platební termín prirazen. Zmena podrobností „Typ“ není povolena.',
    'exclude_paid_invoices'                           => 'Vyloucit zaplacené faktury',
    'phone_number_numeric_error'                      => 'Telefonní císlo musí být císlo.',
    'phone_num_same_country_code_error'               => 'Ujistete se, že je vaše telefonní císlo správne naformátováno. Zdá se, že byl zadán pocínaje kódem zeme, což není povoleno.',
    'tt_expense_amount'                               => 'Zadejte celkovou cástku nákladu vcetne dane. Toto pole není dostupné pri poukazování platby dane financnímu úradu.',
    'tt_expense_tax_paid_deductible'                  => 'Zadejte cástku dane, která byla zaplacena s tímto nákladem. Tato hodnota bude odectena z vaší celkové danové povinnosti v prehledech Prehled dane a Podrobnosti dane.',
    'tt_expense_tax_paid_remittance'                  => 'Zadejte cástku dane, která byla poukázána financnímu úradu. Slouží k evidenci plateb za dane vybrané na vašich zaplacených fakturách.',
    'tt_expense_client'                               => 'Pokud byly tyto náklady vynaloženy výhradne jménem klienta a chcete mu je fakturovat, vyberte souvisejícího klienta zde.',
    'base_currency_not_deleted'                       => 'Základní menu nelze smazat',
    'used_currency_modal_error'                       => 'Mena již použitá v modulu :modal_names.',
    'addon_uninstall_success'                         => 'Addon byl úspešne odinstalován',
    'original'                                        => 'Originál',
    'revision_current'                                => 'Revize (aktuální)',
    'number'                                          => 'Císlo',
    'copy_process_error'                              => 'Jejda! Zdá se, že behem procesu kopírování došlo k škytavce. Prosím zkuste to znovu pozdeji.',
    'tt_captcha_image'                                => 'Obrázek CAPTCHA',
    'reload_page'                                     => 'Nactete stránku znovu',
    'discount_limit'                                  => 'Sleva musí být nižší než 99,99 %.',
    'tooltip'                                         => 'Popisek',
    'authorization_error'                             => 'K provedení této operace nemáte oprávnení.',
    'reset_to_default'                                => 'Obnovit do základního nastavení',
    'reset_to_default_warning'                        => '<p>Tím se predmet a telo resetují na výchozí hodnotu pro :model . Pokracovat?</p>',
    'reset_default_mail_template'                     => 'Výchozí šablona pošty pro :model byla úspešne resetována.',
    'overdue_invoice'                                 => 'Faktura po splatnosti',
    'total_cannot_be_lt_zero'                         => 'Soucet :modal_name nemuže být menší než nula.',
    'addons_disabled_during_setup'                    => 'Behem procesu upgradu byly zakázány následující doplnky: :addons . Po dokoncení upgradu je nezapomente povolit.',
    'allow_payments_on_quotes'                        => 'Povolit platby na základe nabídek A/N',
    'allow_payments_on_quote'                         => 'Povolit platbu A/N',
    'tt_ss_quotes_is_payable'                         => 'Je-li povoleno, po schválení nabídky se v zobrazení verejného odkazu nabídky zobrazí tlacítko Zaplatit. Automaticky se vytvorí faktura a platba bude pripsána na fakturu.',
    'pay_with_square'                                 => 'Platte ctvercem',
    'validation_mess_for_is_payable_quote'            => 'Nastavení Automaticky prevést nabídku na fakturu, když klient schválí, je vyžadováno, když je Povolit platby na nabídky nastaveno na „Ano“.',
    'client_requirement_msg'                          => 'Pred pridáním :seed_name vytvorte klienta',
    'quote_add_items'                                 => 'Položky nabídky jsou povinné a stav není zrušen',
    'invalid_quote_id'                                => 'Neplatné ID nabídky',
    'information_header'                              => 'Gratulujeme, chystáte se ušetrit nejaké peníze!',
    'convenience_charge'                              => 'Príplatek za pohodlí',
    'credit_card_fee_message'                         => 'Za tuto transakci bude úctován poplatek za použití kreditní karty ve výši :charge.',
    'info_payment_term_type_2'                        => 'Prestože je váš zustatek na fakture :ORIGINAL_AMOUNT, máte nárok na slevu z platebních podmínek ve výši :DISCOUNT_PERCENT %, což sníží vaši cástku platby na :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Prestože je váš zustatek na fakture :ORIGINAL_AMOUNT, máte nárok na slevu z platebních podmínek ve výši :DISCOUNT_PERCENT %, což sníží vaši cástku platby na :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Prestože je váš zustatek na fakture :ORIGINAL_AMOUNT, máte nárok na platební podmínky pro zaplacení zálohy :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Prestože je váš zustatek na fakture :ORIGINAL_AMOUNT, máte nárok na platební podmínky pro zaplacení splátky :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Platební podmínky musí být pred smazáním odstraneny z :modal.',
    'default_payment_term_warn'                       => '*Mužete zmenit pouze název a cisté dny splatnosti pro <strong>Výchozí platební podmínky systému</strong>.',
    'quote_rejected_not_payable'                      => 'Citace # :number byla zamítnuta a není splatná kvuli svému stavu.',
    'could_not_delete'                                => 'Nelze smazat',
    'convenience_charges_calculation_fail'            => 'Chyba: Výpocet poplatku za pohodlí se behem migrace nezdaril. Prosím zkuste to znovu pozdeji.',
    'sign_in_welcome_message'                         => 'ðŸš€ Gratulujeme! Vaše FusionInvoice byla úspešne nainstalována! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Vaše faktura FusionInvoice byla úspešne upgradována z verze :old_version na verzi :new_version .</p><p> Podrobný prehled všech nových funkcí a vylepšení naleznete v našich <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Poznámky k vydání</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Dekujeme, že jste si vybrali FusionInvoice. Vaše duvera, podpora a zpetná vazba jsou hnací silou naší inovace.</p><p class="m-0 text-bold">Hodne štestí pri fakturaci!</p><p class="text-bold">Tým FusionInvoice</p >',
    'tt_gen_skin_user_profile'                        => 'Zmena této hodnoty nastaví výchozí nastavení systému POUZE pro nové uživatele. Uživatelé mohou toto nastavení prepsat prostrednictvím nastavení svého uživatelského profilu.',
    'description_template_invoice'                    => 'Šablona popisu – faktura',
    'description_template_quote'                      => 'Šablona popisu - nabídka',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Celá platba je splatná do #NETDAYS od data faktury.',
    't_2_description_for_quote'                       => 'Získejte #DISCOUNTPERCENT % slevu, pokud zaplatíte do #DISCOUNTDAYS, jinak zaplatte celou cástku do #NETDAYS.',
    't_3_description_for_quote'                       => 'Vezmete #DISCOUNTPERCENT % slevu, pokud zaplatíte do #NTHDAY príštího mesíce, jinak zaplatte celou fakturovanou cástku do #NETDAYS dnu.',
    't_4_description_for_quote'                       => 'Záloha ve výši #DOWNPAYMENT je splatná v den faktury, zbývající zustatek je splatný do #NETDAYS dnu',
    't_4_1_description_for_quote'                     => 'Záloha ve výši #DOWNPAYMENTPERCENT je splatná v den faktury, zbývající zustatek je splatný do #NETDAYS dnu',
    't_5_description_for_quote'                       => 'Platby se provádejí v #NUMBEROFINSTALLMENTS stejných splátkách',
    't_5_type_description_for_quote'                  => 'Platba #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT je splatná #INSTALLMENTDUEDAYS dní od data faktury',
    'default_term'                                    => 'Výchozí termín',
    'proceed_to_payment'                              => 'Pokracujte k platbe',
    'version_upgraded'                                => 'Vaše prihláška je aktuální.',
    'term_amount_gt_payment_amount'                   => 'Cástka by mela být vyšší než cástka slevy platebních podmínek',
    'payment_term_not_eligible_warning'               => 'Sleva za platební období je dostupná pouze pro plné platby. Bohužel na to nemáte nárok.',
    'processed_by_user'                               => '<strong>Zpracoval:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Zpusob platby:</strong> :method',
    'all_methods'                                     => 'Všechny metody',
    'this_payment'                                    => 'Tato platba',
    'previous_balance'                                => 'Predchozí zustatek',
    'payment_applied_with_remaining_balance'          => '<p><strong>Vaše platba ve výši :amount byla cástecne uplatnena. :remaining_balance zustává nevyrízeno.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Predbežná platba ve výši :amount byla prijata pro budoucí faktury dne :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Vaše platba :amount byla plne uplatnena.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Platba <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Podrobnosti:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Platba :paid byla pripsána na fakturu :invoice_number dne :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Platba :paid, minus :payment_terms_discount sleva z platebního období, byla pripsána na fakturu :invoice_number dne :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Platba :paid, plus :convenience_charges poplatky za pohodlí byla pripsána na fakturu :invoice_number dne :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Platba :paid, plus :convenience_charges poplatky za pohodlí a mínus :payment_terms_discount sleva z platebního období, byla pripsána na fakturu :invoice_number :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Zbývající zustatek faktury :invoice_number je :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Nezaplacené faktury',
    'include'                                         => 'Zahrnout',
    'exclude'                                         => 'Vyloucit',
    'invoice_with_no_tax'                             => 'Faktury bez dane',
    'tax_total'                                       => 'Dan celkem',
];

return TranslationOverride::override(__FILE__, $translations);
