<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Configuració del compte',
    'active'                                          => 'Actiu',
    'activity'                                        => 'Activitat',
    'activity_invoice_paid'                           => 'S\'ha pagat la factura <a href=":link"># :number</span></a> ~.',
    'activity_invoice_viewed'                         => 'S\'ha vist la factura <a href=":link">núm. :number</span></a> ~.',
    'activity_quote_approved'                         => 'S\'ha aprovat la cita <a href=":link"># :number</span></a> ~.',
    'activity_quote_rejected'                         => 'La cita <a href=":link"># :number</span></a> ~ s\'ha rebutjat.',
    'activity_quote_viewed'                           => 'S\'ha vist la cita <a href=":link"># :number</span></a> ~.',
    'add_item'                                        => 'Afegeix un element',
    'add_line_item_to_invoice'                        => 'Afegiu una línia de comanda a la factura',
    'add_note'                                        => 'Afegir nota',
    'additional'                                      => 'Addicional',
    'addon'                                           => 'Afegir',
    'addons'                                          => 'Complements',
    'address'                                         => 'adreça',
    'address_format'                                  => 'Format d\'adreça',
    'after_amount'                                    => 'Després de la quantitat',
    'all'                                             => 'Tots',
    'all_categories'                                  => 'totes les categories',
    'all_statuses'                                    => 'Tots els estats',
    'all_time'                                        => 'Tot el temps',
    'all_vendors'                                     => 'Tots els venedors',
    'allow_login'                                     => 'Permet l\'inici de sessió',
    'always_attach_pdf'                               => 'Adjunteu sempre PDF',
    'always_bcc'                                      => 'Sempre l\'adreça BCC',
    'always_cc'                                       => 'Adreça CC sempre',
    'amount'                                          => 'Import',
    'api_public_key'                                  => 'Clau pública de l\'API',
    'api_secret_key'                                  => 'Clau secreta de l\'API',
    'approve'                                         => 'Aprovar',
    'approved'                                        => 'Aprovat',
    'approved_quotes'                                 => 'Cotitzacions aprovades',
    'attach_files'                                    => 'Adjuntar fitxers',
    'attach_pdf'                                      => 'Adjunta PDF',
    'attachment'                                      => 'Adjunt',
    'attachments'                                     => 'Adjunts',
    'author'                                          => 'Autor',
    'automatic'                                       => 'Automàtic',
    'automatic_email_on_recur'                        => 'Envieu automàticament les factures recurrents per correu electrònic',
    'automatic_email_payment_receipts'                => 'Correu electrònic automàtic dels rebuts de pagament',
    'available_fields'                                => 'Camps disponibles',
    'back'                                            => 'esquena',
    'back_to_invoice'                                 => 'Torna a Factura',
    'back_to_quote'                                   => 'Tornar a la cotització',
    'balance'                                         => 'Balanç',
    'base_currency'                                   => 'Moneda base',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Abans de la quantitat',
    'bill_this_expense'                               => 'Facturar aquesta despesa',
    'bill_to'                                         => 'Factura a',
    'billable'                                        => 'Facturable',
    'billed'                                          => 'Facturat',
    'billing_address'                                 => 'Adreça de facturació',
    'billing_city'                                    => 'Ciutat de facturació',
    'billing_name'                                    => 'Nom de facturació',
    'billing_state'                                   => 'Estat de facturació',
    'billing_zip'                                     => 'Zip de facturació',
    'binary_path'                                     => 'Camí Binari',
    'body'                                            => 'Cos',
    'cancel'                                          => 'Cancel · lar',
    'canceled'                                        => 'Cancel·lat',
    'card_number'                                     => 'Número de targeta',
    'cash'                                            => 'Efectiu',
    'category'                                        => 'Categoria',
    'cc'                                              => 'CC',
    'change'                                          => 'Canviar',
    'change_client'                                   => 'Canvi de client',
    'check_for_update'                                => 'Cercar actualitzacions',
    'city'                                            => 'ciutat',
    'clear_keys'                                      => 'Esborra les tecles',
    'client'                                          => 'Client',
    'client_form'                                     => 'Formulari de client',
    'client_name'                                     => 'Nom del client',
    'client_not_found'                                => 'No s\'ha trobat el client',
    'client_statement'                                => 'Declaració del client',
    'client_unique_name_option_1'                     => 'Només quan el nom del client no és únic',
    'client_unique_name_option_2'                     => 'Mostra sempre',
    'client_visibility'                               => 'Visibilitat del client',
    'clients'                                         => 'Clients',
    'code'                                            => 'Codi',
    'column_name'                                     => 'Nom de la columna',
    'column_width'                                    => 'Amplada de la columna',
    'company'                                         => 'Companyia',
    'complete'                                        => 'Completa',
    'complete_upgrade'                                => 'Completa l\'actualització',
    'compound'                                        => 'Compost',
    'compound_tax_note'                               => 'Els tipus impositius compostos s\'han d\'aplicar a un article com a impost 2 per tenir l\'efecte desitjat.',
    'confirm_approve_quote'                           => 'Esteu segur que voleu aprovar aquesta cotització?',
    'confirm_reject_quote'                            => 'Esteu segur que voleu rebutjar aquesta cita?',
    'continue'                                        => 'Continua',
    'convert_quote_option1'                           => 'La factura ha de contenir els termes del pressupost',
    'convert_quote_option2'                           => 'La factura hauria d\'utilitzar els termes predeterminats de la factura',
    'convert_quote_setting'                           => 'Quan un pressupost es converteix en una factura',
    'convert_quote_when_approved'                     => 'Converteix automàticament el pressupost en factura quan el client l\'aprovi',
    'converted_from_quote'                            => 'Convertit de la cotització',
    'converted_to_invoice'                            => 'Convertit en factura',
    'country'                                         => 'País',
    'create_invoice'                                  => 'Crear factura',
    'create_quote'                                    => 'Crea una cotització',
    'created'                                         => 'Creat',
    'credit_card'                                     => 'Targeta de crèdit',
    'currencies'                                      => 'Monedes',
    'currency'                                        => 'Moneda',
    'currency_form'                                   => 'Formulari de moneda',
    'currency_symbol'                                 => 'Símbol de moneda',
    'currency_symbol_placement'                       => 'Col·locació del símbol de moneda',
    'custom_date_range'                               => 'Interval de dates personalitzat',
    'custom_field_form'                               => 'Formulari de camp personalitzat',
    'custom_fields'                                   => 'Camps personalitzats',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'panell',
    'dashboard_totals_option'                         => 'S\'han d\'incloure els totals del tauler',
    'database_not_configured'                         => 'Sembla que app/config/database.php encara no s\'ha configurat.',
    'database_setup'                                  => 'Configuració de la base de dades',
    'date'                                            => 'Data',
    'date_format'                                     => 'Format de data',
    'days'                                            => 'Dies',
    'decimal_point'                                   => 'Punt decimal',
    'default_currency'                                => 'Moneda per defecte',
    'default_footer'                                  => 'Peu de pàgina per defecte',
    'default_group'                                   => 'Grup per defecte',
    'default_invoice_email_body'                      => 'Cos de correu electrònic de la factura per defecte',
    'default_invoice_template'                        => 'Plantilla de factura predeterminada',
    'default_item_tax_2_rate'                         => 'Taxa d\'impost 2 per a articles per defecte',
    'default_item_tax_rate'                           => 'Tipus d\'impost sobre articles per defecte',
    'default_overdue_invoice_email_body'              => 'Cos del correu electrònic de la factura vençuda per defecte',
    'default_payment_receipt_body'                    => 'Cos del rebut de pagament per defecte',
    'default_quote_email_body'                        => 'Cos del correu electrònic de la cotització per defecte',
    'default_quote_template'                          => 'Plantilla de pressupost per defecte',
    'default_terms'                                   => 'Termes predeterminats',
    'delete'                                          => 'Suprimeix',
    'delete_client_warning'                           => '<p>PARA! Si suprimiu aquest client, també suprimiu TOT el seu historial de transaccions, incloses les factures, els pressupostos i els pagaments.</p><p>Esteu segur que voleu suprimir aquest client permanentment?</p>',
    'delete_record_warning'                           => 'Esteu segur que voleu suprimir aquest registre?',
    'description'                                     => 'Descripció',
    'details'                                         => 'Detalls',
    'disabled'                                        => 'Inhabilitat',
    'discount'                                        => 'Descompte',
    'display_client_unique_name'                      => 'Mostra el nom únic del client',
    'display_do_not_require'                          => 'Mostra però no requereix',
    'display_order'                                   => 'Ordre de visualització',
    'display_profile_image'                           => 'Mostra la imatge de perfil',
    'do_not_add_line_item_to_invoice'                 => 'No afegiu una línia de comanda a la factura',
    'do_not_display'                                  => 'No mostris',
    'documentation'                                   => 'Documentació',
    'download'                                        => 'descarregar',
    'draft'                                           => 'Esborrany',
    'draft_invoices'                                  => 'Esborrany de factures',
    'draft_quotes'                                    => 'Esborrany de cotitzacions',
    'dropdown'                                        => 'Menú desplegable',
    'due'                                             => 'Degut',
    'due_date'                                        => 'Data de venciment',
    'edit'                                            => 'Edita',
    'edit_client'                                     => 'Edita el client',
    'email'                                           => 'Correu electrònic',
    'email_address'                                   => 'Correu electrònic',
    'email_invoice'                                   => 'Factura per correu electrònic',
    'email_payment_receipt'                           => 'Rebut de pagament per correu electrònic',
    'email_quote'                                     => 'Cotització per correu electrònic',
    'email_send_method'                               => 'Mètode d\'enviament de correu electrònic',
    'email_send_method_phpmail'                       => 'Correu PHP',
    'email_send_method_sendmail'                      => 'Envia un correu',
    'email_send_method_sendgrid'                      => 'API SendGrid',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Habilitat',
    'enter_payment'                                   => 'Introduïu el pagament',
    'error'                                           => 'Error',
    'every'                                           => 'Cada',
    'exchange_rate'                                   => 'Tipus de canvi',
    'exchange_rate_mode'                              => 'Mode de tipus de canvi',
    'expense_form'                                    => 'Formulari de despeses',
    'expenses'                                        => 'Despeses',
    'expiration'                                      => 'Caducitat',
    'expires'                                         => 'Caduca',
    'export_clients'                                  => 'Clients d\'exportació',
    'export_data'                                     => 'Exporta dades',
    'export_expenses'                                 => 'Despeses d\'exportació',
    'export_invoice_items'                            => 'Exportar elements de la factura',
    'export_invoices'                                 => 'Factures d\'exportació',
    'export_payments'                                 => 'Pagaments d\'exportació',
    'export_quote_items'                              => 'Exporta elements de pressupost',
    'export_quotes'                                   => 'Exportar pressupostos',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Número de fax',
    'field_label'                                     => 'Etiqueta de camp',
    'field_meta'                                      => 'Camp Meta',
    'field_meta_description'                          => 'Utilitzeu el camp Meta del camp només si el Tipus de camp és un desplegable. Per especificar valors desplegables, introduïu una llista de valors desplegables separats per comes.',
    'field_type'                                      => 'Tipus de camp',
    'footer'                                          => 'Peu de pàgina',
    'format'                                          => 'Format',
    'frequency'                                       => 'Freqüència',
    'from'                                            => 'Des de',
    'from_date'                                       => 'Des de la data',
    'general'                                         => 'General',
    'generate_keys'                                   => 'Generar claus',
    'group'                                           => 'Grup',
    'group_form'                                      => 'Formulari de grup',
    'groups'                                          => 'Grups',
    'header_title_text'                               => 'Text del títol de la capçalera',
    'help'                                            => 'Ajuda',
    'help_currency_code'                              => 'El codi de moneda, p. "USD".',
    'help_currency_name'                              => 'El nom de la moneda, p. "Dòlar americà".',
    'help_currency_symbol'                            => 'El símbol de la moneda, p. "$".',
    'help_currency_symbol_placement'                  => 'On col·locar el símbol de la moneda.',
    'help_text_client_name'                           => 'Aquest valor pot ser el nom d\'una empresa o una persona i apareixerà en pressupostos i factures. Aquest valor no ha de ser únic.',
    'help_text_client_password'                       => 'Deixeu aquest camp en blanc tret que creeu o restabliu una contrasenya.',
    'help_text_client_unique_name'                    => 'Quan un o més clients del sistema comparteixen el mateix nom, s\'ha de proporcionar un nom únic per distingir-los. Aquest valor no apareixerà als pressupostos ni a les factures.',
    'i_accept'                                        => 'Accepto',
    'import_data'                                     => 'Importa dades',
    'inactive'                                        => 'Inactiu',
    'income'                                          => 'Ingressos',
    'install'                                         => 'Instal·lar',
    'installation_complete'                           => 'Instal·lació completada',
    'installing_please_wait'                          => 'S\'està instal·lant, espereu...',
    'invalid_credentials'                             => 'Credencials no vàlides',
    'invoice'                                         => 'Factura',
    'invoice_default'                                 => 'Factura per defecte',
    'invoice_email_subject'                           => 'Assumpte del correu electrònic de la factura',
    'invoice_items'                                   => 'Elements de la factura',
    'invoice_number'                                  => 'Nombre de factura',
    'invoice_summary'                                 => 'Resum de la factura',
    'invoiced'                                        => 'Facturat',
    'invoices'                                        => 'Factures',
    'invoices_due_after'                              => 'Factures vençudes després (dies)',
    'issued'                                          => 'Emès',
    'item'                                            => 'Article',
    'item_lookup_form'                                => 'Formulari de cerca d\'elements',
    'item_lookups'                                    => 'Cerques d\'elements',
    'item_sales'                                      => 'Vendes d\'articles',
    'items'                                           => 'Elements',
    'label_invoice'                                   => 'Trieu la factura a la qual afegir-hi aquesta despesa',
    'label_item_description'                          => 'Introduïu una descripció per a aquesta despesa (opcional)',
    'label_item_name'                                 => 'Introduïu el nom de la línia que voleu afegir a la factura',
    'landscape'                                       => 'Paisatge',
    'language'                                        => 'Llenguatge',
    'left_pad'                                        => 'Coixinet esquerre',
    'left_pad_description'                            => 'El nombre de zeros a l\'esquerra opcionalment escriu el següent número.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Carta',
    'license_agreement'                               => 'Acord de llicència',
    'license_agreement_accept'                        => 'Accepto els termes de l\'acord de llicència',
    'logo'                                            => 'Logotip',
    'mail_hash_error'                                 => 'Sembla que la vostra clau secreta s\'ha canviat des de l\'última vegada que vau desar la contrasenya de correu electrònic. Per solucionar aquest error, aneu a Configuració del sistema -> pestanya Correu electrònic, torneu a introduir la vostra contrasenya de correu electrònic i premeu Desa. Tingueu en compte que no es lliurarà cap correu fins que no s\'hagi fet.',
    'manual'                                          => 'Manual',
    'map_fields_to_import'                            => 'Assigna camps per importar',
    'merchant_api_key'                                => 'Clau de l\'API',
    'merchant_api_password'                           => 'Contrasenya de l\'API',
    'merchant_api_username'                           => 'Nom d\'usuari de l\'API',
    'merchant_publishable_key'                        => 'Clau publicable',
    'merchant_secret_key'                             => 'Clau secreta',
    'merchant_signature'                              => 'Signatura',
    'mobile'                                          => 'Mòbil',
    'mobile_number'                                   => 'Número de mòbil',
    'monthly'                                         => 'Mensual',
    'months'                                          => 'Mesos',
    'multiple_email_validation'                       => 'Diverses adreces de correu electrònic han de ser vàlides i separades per comes.',
    'name'                                            => 'Nom',
    'net_income'                                      => 'Ingressos nets',
    'never'                                           => 'Mai',
    'new'                                             => 'Nou',
    'next_date'                                       => 'Propera data',
    'next_number'                                     => 'Número següent',
    'no'                                              => 'No',
    'no_open_invoices'                                => 'Aquest client no té factures obertes. Per facturar una despesa, el client ha de tenir almenys una factura que no s\'hagi pagat íntegrament.',
    'no_records_found'                                => 'No s\'han trobat registres',
    'none'                                            => 'Cap',
    'not_billable'                                    => 'No facturable',
    'not_billed'                                      => 'No facturat',
    'not_viewed'                                      => 'No vist',
    'not_visible'                                     => 'No visible',
    'note'                                            => 'Nota',
    'note_notification'                               => 'Notificació: nota nova',
    'notes'                                           => 'Notes',
    'online_payment'                                  => 'Pagament en línia',
    'online_payment_method'                           => 'Mètode de pagament en línia',
    'online_payments'                                 => 'Pagaments en línia',
    'options'                                         => 'Opcions',
    'other'                                           => 'Altres',
    'output_type'                                     => 'Tipus de sortida',
    'overdue'                                         => 'Endarrerit',
    'overdue_email_subject'                           => 'Assumpte del correu electrònic vençut',
    'overdue_invoice_reminder'                        => 'Recordatori de factura vençuda',
    'overdue_invoice_reminder_frequency'              => 'Freqüència de recordatori de factures vençudes',
    'overdue_invoice_reminder_frequency_help'         => 'S\'ha d\'enviar el recordatori una llista separada per comes de dies DESPRÉS d\'una factura. Deixeu-lo en blanc per desactivar els recordatoris de factures vençudes. Per exemple, un valor d\'1, 5, 10 enviaria recordatoris 1, 5 i 10 dies després de la facturació.',
    'overdue_invoices'                                => 'Factures vençudes',
    'paid'                                            => 'Pagat',
    'paper_orientation'                               => 'Orientació del paper',
    'paper_size'                                      => 'Mida del paper',
    'password'                                        => 'Contrasenya',
    'password_confirmation'                           => 'Confirmació de la contrasenya',
    'password_successfully_reset'                     => 'La contrasenya s\'ha restablert correctament',
    'pay'                                             => 'Pagar',
    'pay_now'                                         => 'Paga ara',
    'payment_applied'                                 => 'S\'ha aplicat el vostre pagament',
    'payment_button_text'                             => 'Text del botó de pagament',
    'payment_date'                                    => 'Data de pagament',
    'payment_form'                                    => 'Formulari de pagament',
    'payment_method'                                  => 'Mètode de pagament',
    'payment_method_form'                             => 'Formulari de forma de pagament',
    'payment_methods'                                 => 'Mètodes de Pagament',
    'payment_receipt'                                 => 'Rebut de pagament',
    'payment_receipt_email_subject'                   => 'Assumpte del correu electrònic del rebut de pagament',
    'payments'                                        => 'Pagaments',
    'payments_collected'                              => 'Pagaments recaptats',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'Controlador de PDF',
    'pdf_driver_wkhtmltopdf'                          => 'El camp Binary Path ha de contenir una ruta de fitxer vàlida quan utilitzeu el controlador PDF wkhtmltopdf.',
    'percent'                                         => 'Per cent',
    'phone'                                           => 'Telèfon',
    'phone_number'                                    => 'Número de telèfon',
    'php_version_error'                               => 'PHP no compleix el requisit de versió (%s)',
    'placeholder_type_message'                        => 'Escriu missatge...',
    'portrait'                                        => 'Retrat',
    'postal_code'                                     => 'Codi Postal',
    'prefix'                                          => 'Prefix',
    'prerequisites'                                   => 'Requisits previs',
    'preview'                                         => 'Vista prèvia',
    'price'                                           => 'Preu',
    'private'                                         => 'Privat',
    'problem_with_email_template'                     => 'Sembla que hi ha un problema amb la plantilla de correu electrònic. Si us plau, comproveu les plantilles a la configuració del sistema a la pestanya Correu electrònic.',
    'product'                                         => 'Producte',
    'profit_and_loss'                                 => 'Benefici i pèrdua',
    'public'                                          => 'Públic',
    'qty'                                             => 'Quantitat',
    'quantity'                                        => 'Quantitat',
    'quantity_price_decimals'                         => 'Nombre de decimals per a quantitats i quantitats',
    'quote'                                           => 'Cita',
    'quote_approved'                                  => 'Cotització aprovada',
    'quote_approved_email_body'                       => 'Cotització del correu electrònic aprovat',
    'quote_default'                                   => 'Cita per defecte',
    'quote_email_subject'                             => 'Assumpte del correu electrònic de cita',
    'quote_items'                                     => 'Cotitzar articles',
    'quote_number'                                    => 'Número de cita',
    'quote_rejected'                                  => 'Cita rebutjada',
    'quote_rejected_email_body'                       => 'Cos del correu electrònic rebutjat de la cita',
    'quote_status_change_notification'                => 'Notificació: canvi d\'estat del pressupost',
    'quote_summary'                                   => 'Resum de la cita',
    'quote_to_invoice'                                => 'Cotització per facturar',
    'quotes'                                          => 'Cites',
    'quotes_expire_after'                             => 'Les cotitzacions caduquen després de (dies)',
    'recalculate'                                     => 'Recalcular',
    'recalculate_help_text'                           => 'El recàlcul pot trigar uns quants moments a completar-se. Es mostrarà un missatge un cop finalitzat el procés.',
    'recalculate_invoices'                            => 'Recalcular les factures',
    'recalculate_quotes'                              => 'Recalcular pressupostos',
    'recalculating_wait'                              => 'S\'està tornant a calcular, espereu...',
    'recalculation_complete'                          => 'Recàlcul completat',
    'recent_invoices'                                 => 'Factures recents',
    'recent_payments'                                 => 'Pagaments recents',
    'recent_quotes'                                   => 'Cites recents',
    'record_not_found'                                => 'No s\'ha trobat el registre',
    'record_successfully_created'                     => 'El registre s\'ha creat correctament',
    'record_successfully_deleted'                     => 'El registre s\'ha suprimit correctament',
    'record_successfully_updated'                     => 'Registre actualitzat correctament',
    'records_imported_successfully'                   => 'Registres importats correctament: :total_records',
    'recurring'                                       => 'Recurrent',
    'reject'                                          => 'Rebutjar',
    'rejected'                                        => 'Rebutjada',
    'rejected_quotes'                                 => 'Cites rebutjades',
    'remember_me'                                     => 'Recorda\'m',
    'remove_logo'                                     => 'Elimina el logotip',
    'report_rev_client_notice'                        => 'Aquest informe estarà disponible un cop hàgiu introduït alguns pagaments al sistema.',
    'reports'                                         => 'Informes',
    'require'                                         => 'Requereix',
    'reset_number'                                    => 'Restableix el número',
    'reset_password'                                  => 'Restablir la contrasenya',
    'results_per_page'                                => 'Resultats per pàgina',
    'revenue_by_client'                               => 'Ingressos per client',
    'round_tax_decimals'                              => 'Nombre de decimals per a l\'arrodoniment fiscal',
    'run_report'                                      => 'Executar informe',
    'save'                                            => 'Desa',
    'save_and_apply_exchange_rate'                    => 'Desa i aplica el tipus de canvi',
    'save_item_as_lookup'                             => 'Desa l\'element com a cerca',
    'search'                                          => 'Cerca',
    'select_file_to_import'                           => 'Seleccioneu el fitxer a importar',
    'send'                                            => 'Enviar',
    'sending'                                         => 'Enviament',
    'sendmail_path'                                   => 'Sendmail Camí',
    'sent'                                            => 'Enviat',
    'sent_invoices'                                   => 'Factures enviades',
    'sent_quotes'                                     => 'Cotitzacions enviades/Pendents',
    'settings'                                        => 'Configuració',
    'settings_successfully_saved'                     => 'La configuració s\'ha desat correctament',
    'setup'                                           => 'Configuració',
    'sign_in'                                         => 'Inicieu la sessió',
    'sign_out'                                        => 'Tanca sessió',
    'skin'                                            => 'Pell',
    'smtp_encryption'                                 => 'Xifratge SMTP',
    'smtp_host_address'                               => 'Adreça d\'amfitrió SMTP',
    'smtp_host_port'                                  => 'Port d\'amfitrió SMTP',
    'smtp_password'                                   => 'Contrasenya SMTP',
    'smtp_username'                                   => 'Nom d\'usuari SMTP',
    'start_date'                                      => 'Data d\'inici',
    'state'                                           => 'Estat',
    'status'                                          => 'Estat',
    'step_database_setup'                             => 'Aquest pas instal·larà i actualitzarà les taules de la base de dades. Aquest pas pot trigar uns quants moments a completar-se.',
    'step_prerequisites'                              => 'Els requisits previs següents s\'han de resoldre abans que la instal·lació pugui continuar:',
    'subject'                                         => 'Assignatura',
    'submit'                                          => 'Presentar',
    'subtotal'                                        => 'Subtotal',
    'summary'                                         => 'Resum',
    'symbol'                                          => 'Símbol',
    'symbol_placement'                                => 'Col·locació de símbols',
    'system'                                          => 'Sistema',
    'system_settings'                                 => 'Ajustos del sistema',
    'table_name'                                      => 'Nom de la taula',
    'tax'                                             => 'Impost',
    'tax_1'                                           => 'Impost 1',
    'tax_2'                                           => 'Impost 2',
    'tax_rate'                                        => 'Taxa d\'impost',
    'tax_rate_form'                                   => 'Formulari de tipus impositiu',
    'tax_rate_name'                                   => 'Nom del tipus impositiu',
    'tax_rate_percent'                                => 'Percentatge del tipus impositiu',
    'tax_rates'                                       => 'Taxes fiscals',
    'tax_summary'                                     => 'Resum fiscal',
    'taxable_amount'                                  => 'Import imposable',
    'taxes'                                           => 'Impostos',
    'template'                                        => 'Plantilla',
    'terms_and_conditions'                            => 'Termes i condicions',
    'test_mode'                                       => 'Mode de prova',
    'text'                                            => 'Text',
    'textarea'                                        => 'Àrea de text',
    'this_quarter'                                    => 'Aquest trimestre',
    'thousands_separator'                             => 'Separador de milers',
    'timezone'                                        => 'Fus horari',
    'to'                                              => 'A',
    'to_date'                                         => 'Quedar',
    'total'                                           => 'Total',
    'total_balance'                                   => 'Balanç total',
    'total_invoiced'                                  => 'Total facturat',
    'total_expenses'                                  => 'Despeses totals',
    'total_paid_invoices'                             => 'Total de factures pagades',
    'try_again'                                       => 'Torna-ho a provar',
    'uninstall'                                       => 'Desinstal·la',
    'uninstall_addon_warning'                         => 'Esteu segur que voleu desactivar aquest complement?',
    'unique_name'                                     => 'Nom únic',
    'unknown_error'                                   => 'Error desconegut',
    'upcoming_payment_notice_email_body'              => 'Cos del correu electrònic de l\'avís de pagament proper',
    'upcoming_payment_notice_email_subject'           => 'Avís de pagament proper Assumpte del correu electrònic',
    'upcoming_payment_notice_frequency'               => 'Freqüència d\'avís de pagament proper',
    'upcoming_payment_notice_frequency_help'          => 'S\'ha d\'enviar el recordatori una llista separada per comes de dies ABANS d\'una factura. Deixeu-lo en blanc per desactivar els avisos de pagament propers. Per exemple, un valor d\'1,5 enviaria avisos 1 i 5 dies abans del venciment de la factura.',
    'update_available'                                => 'FusionInvoice :version està disponible per descarregar!',
    'update_exchange_rate'                            => 'Actualitzar el tipus de canvi',
    'update_not_available'                            => 'Actualment no hi ha actualitzacions disponibles.',
    'upload_progress'                                 => 'Progrés de càrrega',
    'user'                                            => 'Usuari',
    'user_accounts'                                   => 'Comptes d\'usuari',
    'user_form'                                       => 'Formulari d\'usuari',
    'users'                                           => 'Usuaris',
    'validation_invoice_summary_from_date'            => 'La data a partir del widget del tauler de resum de factures és necessària quan l\'interval de dates s\'estableix en Interval de dates personalitzat.',
    'validation_invoice_summary_to_date'              => 'La data fins al widget del tauler de resum de factures és necessària quan s\'utilitza un interval de dates personalitzat.',
    'validation_quote_summary_from_date'              => 'La data a partir del widget del tauler de resum de cotització és necessària quan s\'utilitza un interval de dates personalitzat.',
    'validation_quote_summary_to_date'                => 'La data fins al widget del tauler de resum de cotitzacions és necessària quan s\'utilitza un interval de dates personalitzat.',
    'vendor'                                          => 'Venedor',
    'version'                                         => 'Versió',
    'view'                                            => 'Veure',
    'view_all'                                        => 'Veure tot',
    'view_all_invoices_for_client'                    => 'Veure totes les factures d\'aquest client',
    'view_all_payments_for_client'                    => 'Veure tots els pagaments d\'aquest client',
    'view_all_quotes_for_client'                      => 'Consulta totes les cotitzacions d\'aquest client',
    'view_approved_quotes'                            => 'Veure pressupostos aprovats',
    'view_client'                                     => 'Visualitza el client',
    'view_draft_invoices'                             => 'Veure esborranys de factures',
    'view_draft_quotes'                               => 'Veure esborranys de pressupostos',
    'view_overdue_invoices'                           => 'Consulta les factures vençudes',
    'view_payments'                                   => 'Veure Pagaments',
    'view_rejected_quotes'                            => 'Mostra les cotitzacions rebutjades',
    'view_sent_invoices'                              => 'Veure les factures enviades',
    'view_sent_quotes'                                => 'Veure pressupostos enviats',
    'view_unique_name'                                => 'Veure el nom únic',
    'viewed'                                          => 'Vist',
    'visible'                                         => 'Visible',
    'visible_after_payment'                           => 'Visible després del pagament',
    'web'                                             => 'Web',
    'web_address'                                     => 'Adreça web',
    'weekly'                                          => 'Setmanalment',
    'weeks'                                           => 'Setmanes',
    'welcome'                                         => 'Benvingut',
    'what_to_import'                                  => 'Què t\'agradaria importar?',
    'year'                                            => 'Curs',
    'yearly'                                          => 'Anualment',
    'years'                                           => 'Anys',
    'yes'                                             => 'Sí',
    'you_may_now_sign_in'                             => 'Ara pots iniciar la sessió!',

    // 2017-1
    'all_company_profiles'                            => 'Tots els perfils d\'empresa',
    'cannot_delete_record_in_use'                     => 'Aquest registre està en ús i no es pot suprimir.',
    'cannot_edit_record_in_use'                       => 'Aquest registre està en ús i no es pot editar.',
    'change_company_profile'                          => 'Canviar el perfil de l\'empresa',
    'company_profile'                                 => 'Perfil de la companyia',
    'company_profiles'                                => 'Perfils d\'empresa',
    'company_profile_form'                            => 'Formulari de perfil de l\'empresa',
    'copy'                                            => 'Còpia',
    'create_recurring_invoice'                        => 'Crea una factura recurrent',
    'custom'                                          => 'Personalitzat',
    'date_range'                                      => 'Interval de dates',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mo',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'Nosaltres',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Perfil d\'empresa predeterminat',
    'first_quarter'                                   => 'Primer quart',
    'fourth_quarter'                                  => 'Quart trimestre',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Últims 7 dies',
    'last_30_days'                                    => 'Últims 30 dies',
    'last_month'                                      => 'El mes passat',
    'last_quarter'                                    => 'Últim trimestre',
    'last_year'                                       => 'L\'any passat',
    'month_january'                                   => 'gener',
    'month_february'                                  => 'febrer',
    'month_march'                                     => 'març',
    'month_april'                                     => 'Abril',
    'month_may'                                       => 'maig',
    'month_june'                                      => 'juny',
    'month_july'                                      => 'juliol',
    'month_august'                                    => 'Agost',
    'month_september'                                 => 'setembre',
    'month_october'                                   => 'Octubre',
    'month_november'                                  => 'de novembre',
    'month_december'                                  => 'desembre',
    'recurring_invoice'                               => 'Factura recurrent',
    'second_quarter'                                  => 'Segon trimestre',
    'stop_date'                                       => 'Data d\'aturada',
    'third_quarter'                                   => 'Tercer trimestre',
    'this_month'                                      => 'Aquest mes',
    'this_year'                                       => 'Aquest any',
    'today'                                           => 'Avui',
    'user_account'                                    => 'Compte d\'usuari',
    'yesterday'                                       => 'Ahir',

    // 2017-3
    'mail_log'                                        => 'Registre de correu',
    'recent_client_activity'                          => 'Activitat recent del client',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Exclou les factures impagades',

    // 2017-7
    'please_wait'                                     => 'Si us plau, espereu...',
    'reply_to_address'                                => 'Respon a l\'adreça',

    // 2017-8
    'admin'                                           => 'Admin',
    'admin_account'                                   => 'Compte d\'administrador',
    'admin_accounts'                                  => 'Comptes d\'administrador',
    'all_accounts'                                    => 'Tots els comptes',
    'api_key'                                         => 'Clau de l\'API',
    'client_account'                                  => 'Compte de client',
    'client_accounts'                                 => 'Comptes de client',
    'client_id'                                       => 'ID de client',
    'client_secret'                                   => 'Secret del client',
    'enable_bitcoin_payments'                         => 'Activa els pagaments de Bitcoin',
    'live'                                            => 'Viu',
    'mode'                                            => 'Mode',
    'publishable_key'                                 => 'Clau publicable',
    'sandbox'                                         => 'Sandbox',
    'secret_key'                                      => 'Clau secreta',
    'type'                                            => 'Tipus',

    // 2017-10
    'deselect_all'                                    => 'Deseleccionar tot',
    'select_all'                                      => 'Seleccionar tot',
    'use_24_hour_time_format'                         => 'Utilitzeu el format d\'hora de 24 hores',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Esteu segur que voleu suprimir aquests registres?',
    'bulk_invoice_change_status_warning'              => 'Esteu segur que voleu canviar l\'estat de les factures seleccionades?',
    'bulk_quote_change_status_warning'                => 'Esteu segur que voleu canviar l\'estat de les cotitzacions seleccionades?',
    'calculate_as_vat_gst'                            => 'Calcula com a IVA/GST',
    'change_status'                                   => 'Canvia l\'estat',
    'default_status_filter'                           => 'Filtre d\'estat predeterminat',
    'error_applying_payment'                          => 'S\'ha produït un error en aplicar aquest pagament. Si us plau, proveu una altra targeta o mètode de pagament.',
    'remaining'                                       => 'Restant',

    // 2017-12
    'invoice_date'                                    => 'Data de la factura',
    'include_profit_based_on'                         => 'Inclou benefici basat en',

    // 2018-1
    'add_contact'                                     => 'Afegeix contacte',
    'allow_self_signed_cert'                          => 'Permet un certificat autofirmat',
    'backup'                                          => 'Còpia de seguretat',
    'close'                                           => 'Tanca',
    'change_invoice_date_to_todays_date'              => 'Canvia la data de la factura a la d\'avui',
    'change_quote_date_to_todays_date'                => 'Canvia la data del pressupost a la data d\'avui',
    'contacts'                                        => 'Contactes',
    'default_bcc'                                     => 'CCO predeterminat',
    'default_cc'                                      => 'CC predeterminat',
    'default_to'                                      => 'Per defecte',
    'disable'                                         => 'Desactivar',
    'download_database_backup'                        => 'Descarrega la còpia de seguretat de la base de dades',
    'edit_contact'                                    => 'Edita el contacte',
    'expense_list'                                    => 'Llista de despeses',
    'keep_invoice_date_as_is'                         => 'Mantenir la data de la factura tal com està',
    'keep_quote_date_as_is'                           => 'Mantingueu la data del pressupost com està',
    'if_quote_is_emailed_while_draft'                 => 'Si la cotització s\'envia per correu electrònic mentre es troba en estat d\'esborrany',

    // 2018-4
    'force_https'                                     => 'Força HTTPS',
    'force_https_help'                                => 'Abans d\'activar aquesta opció, assegureu-vos que la vostra instal·lació de FusionInvoice funcioni mitjançant https. Si no ho feu, es pot produir una instal·lació no funcional (però arreglable).',

    // 2019-1
    'attached_to'                                     => 'Unit a',
    'customer'                                        => 'Client',
    'expense'                                         => 'Despesa',
    'expense_categories'                              => 'Categories de despeses',
    'expense_category_form'                           => 'Formulari de categoria de despeses',
    'expense_vendors'                                 => 'Proveïdors de despeses',
    'expense_vendor_form'                             => 'Formulari de proveïdor de despeses',
    'lead'                                            => 'Dirigir',
    'local_time'                                      => 'Hora local',
    'prospect'                                        => 'Perspectiva',
    'search_clients'                                  => 'Cerca clients',
    'search_expenses'                                 => 'Despeses de cerca',
    'search_invoices'                                 => 'Cerca factures',
    'search_items'                                    => 'Cerca articles',
    'search_log'                                      => 'Registre de cerca',
    'search_quotes'                                   => 'Cerca pressupostos',
    'search_payments'                                 => 'Cerca pagaments',
    'search_recurring_invoices'                       => 'Cerca factures recurrents',
    'show_all_statuses'                               => 'Mostra tots els estats',
    'show_all_types'                                  => 'Mostra tots els tipus',
    'unknown'                                         => 'Desconegut',
    'value'                                           => 'Valor',

    // 2019-2
    'default'                                         => 'Per defecte',
    'no_data_available'                               => 'No hi ha dades disponibles',
    'recurring_invoice_list'                          => 'Llista de factures recurrents',
    'report_total'                                    => 'Informe totals',

    //2019-3
    'checkbox'                                        => 'casella de selecció',
    'custom_dropdown_validate'                        => 'Seleccioneu una opció vàlida al camp :label',
    'custom_image_validate'                           => 'Seleccioneu una imatge vàlida.',
    'custom_tag_validate'                             => 'Seleccioneu una etiqueta vàlida de :label',
    'custom_text_validate'                            => 'Introduïu una :label vàlida al camp :label.',
    'datetime'                                        => 'Data i hora',
    'decimal'                                         => 'Decimal',
    'delete-confirm'                                  => 'Estàs segur?',
    'grand_total'                                     => 'Gran Total',
    'image'                                           => 'Imatge',
    'integer'                                         => 'Enter',
    'mailed'                                          => 'Enviat per correu',
    'mailed_invoices'                                 => 'Factures enviades per correu',
    'radio'                                           => 'Ràdio',
    'recurring_id'                                    => 'ID recurrent',
    'remove_image'                                    => 'Elimina la imatge',
    'tags'                                            => 'Etiquetes',
    'tagselection'                                    => 'Selecció d\'etiquetes',
    'unpaid'                                          => 'Sense pagar',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Veure les factures enviades per correu',
    'important'                                       => 'Important!',
    'created_recurring_invoice_id'                    => 'Creat a partir de l\'identificador de factura recurrent',
    'mr'                                              => 'Sr.',
    'miss'                                            => 'Senyoreta',
    'ms'                                              => 'Senyora.',
    'mrs'                                             => 'Mrs.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Títol de contacte',
    'title'                                           => 'Títol',
    'test_email_subject'                              => 'Hola de FusionInvoice',
    'test_email_body'                                 => 'Aquest és un correu electrònic de prova de FusionInvoice.',
    'test_email_address'                              => 'Envia una prova per correu electrònic a',
    'send_test_email'                                 => 'Envia un correu electrònic de prova',
    'invalid_json'                                    => 'Introduïu una cadena JSON vàlida',
    'textarea_rows_limit'                             => 'Les files no poden superar :limit',
    'custom_integer_validate'                         => ':label ha de ser un valor enter vàlid',

    //2020-1
    'user_role'                                       => 'Rol d\'usuari',
    'standard_user'                                   => 'Usuari estàndard',
    'permissions'                                     => 'Permisos',
    'modules'                                         => 'Mòduls',
    'is_view'                                         => 'Veure',
    'is_create'                                       => 'Crear',
    'is_update'                                       => 'Actualització',
    'is_delete'                                       => 'Suprimeix',
    'dashboards'                                      => 'Taulers de control',
    'allow_time_period_change'                        => 'Permet el canvi de període de temps',
    'page_not_found'                                  => 'Vaja! Pàgina no trobada.',
    'return_to_dashboard'                             => 'No hem trobat la pàgina que estaves buscant. <a href=":dashboard_link">Torna~ al tauler</a>.',
    'no_auth_to_create_client'                        => 'No estàs autoritzat per crear clients!',
    'check-all'                                       => 'Marqueu-ho tot',
    'invoice_prefix'                                  => 'Prefix de factura',
    'recently_viewed'                                 => 'vist recentment',
    'copy_from'                                       => 'Còpia de',
    'select_user'                                     => 'Seleccioneu Usuari',
    'please_select_user'                              => 'Seleccioneu un usuari de la llista',
    'allow_client_center_login'                       => 'Permet l\'inici de sessió al centre de clients',
    'online_payment_processing_fee'                   => 'Taxa de processament de pagaments en línia',
    'client_password_required'                        => 'Introduïu la contrasenya del client',
    'last_login_at'                                   => 'Últim inici de sessió a',
    'show_notes_panel_below_client'                   => 'Mostra el tauler de notes a sota dels detalls del client',
    'notepad'                                         => 'Bloc de notes',
    'added'                                           => 'Afegit',
    'last_edited'                                     => 'Última edició',
    'loading'                                         => 'Processament....',
    'n_records_match'                                 => ':label Enregistra la coincidència :plural',
    'initials'                                        => 'Inicials',
    'initials_bg_color'                               => 'Color de fons de les inicials',
    'more'                                            => 'Més',
    'must_match_all'                                  => 'Ha de coincidir amb tots',
    'clear'                                           => 'Clar',
    'no_client_tags'                                  => 'No hi ha registres de client amb etiquetes definides.',
    'qr_code_on_invoice_quote'                        => 'Codi QR a la factura i al pressupost',
    'delete_tags'                                     => 'Neteja d\'etiquetes',
    'orphan_tags_deleted'                             => 'S\'han suprimit correctament totes les etiquetes òrfenes del sistema.',
    'orphan_tags_delete_confirm'                      => 'L\'execució de la neteja d\'etiquetes eliminarà totes les etiquetes no utilitzades. Continuar?',
    'deleting_tags_wait'                              => 'S\'estan suprimint les etiquetes, espereu...',
    'new-version-available'                           => 'Nova versió disponible!',
    'ignore-this-version'                             => 'Ignora aquesta versió',
    'view-release-notes'                              => 'Veure notes de la versió',
    'task_list'                                       => 'Llista de tasques',
    'create_task'                                     => 'Crea una tasca',
    'open'                                            => 'Obert',
    'closed'                                          => 'Tancat',
    'assignee'                                        => 'Cesionari',
    'task'                                            => 'Tasques',
    'task_successfully_created'                       => 'La tasca s\'ha creat correctament',
    'task_successfully_updated'                       => 'La tasca s\'ha actualitzat correctament',
    'task_completed'                                  => 'Tasca completada correctament',
    'task_marked_incomplete'                          => 'S\'ha reobert la tasca',
    'due_date_validation_date'                        => 'Seleccioneu una data de venciment vàlida',
    'assignee_validation_required'                    => 'Seleccioneu un assignat vàlid de la llista',
    'assignee_validation_exists'                      => 'Seleccioneu un assignat vàlid de la llista',
    'tomorrow'                                        => 'Demà',
    'task_not_authorized'                             => 'No esteu autoritzat per editar aquesta tasca!',
    'me'                                              => 'jo',
    'task_from_note'                                  => 'Crea una tasca en desar',
    'done'                                            => 'Fet',
    'refresh'                                         => 'Actualització',
    'task_list_page_size'                             => 'Nombre de tasques per pàgina',
    'select_client'                                   => 'Seleccioneu Client',
    'note-search-config'                              => 'Cerca de notes per incloure',
    'username'                                        => 'Nom d\'usuari',
    'task-search-config'                              => 'Cerca de tasques per incloure',
    'task_section_invalid'                            => 'La secció de tasques no és vàlida',
    'task_section'                                    => 'Secció de tasques',
    'select_section'                                  => 'Seleccioneu la secció',
    'email-test-failed'                               => 'La prova del correu electrònic ha fallat',
    'smtp-setting-suggestion'                         => 'Suggeriments: <br> 1. Verifiqueu i torneu a introduir els vostres valors d\'usuari/contrasenya<br>2. Verifiqueu que la vostra configuració SMTP s\'ha introduït correctament',
    'mail-setting-suggestion'                         => 'Suggeriments: <br> 1. Verifiqueu que el servidor de correu PHP estigui configurat correctament <br>2. Contacteu amb l\'administrador del servidor',
    'sendmail-setting-suggestion'                     => 'Suggeriments: <br> 1. Verifiqueu que el vostre camí de Sendmail estigui configurat correctament.<br>2. Contacteu amb l\'administrador del servidor',
    'sendgrid-setting-suggestion'                     => 'Suggeriments: <br> 1. Verifiqueu que la vostra clau de Sendgrid estigui configurada correctament.<br>2. Contacteu amb l\'administrador del servidor',
    'later'                                           => 'Més tard',
    'test-email-required'                             => 'Heu d\'introduir un correu electrònic a vàlid',
    'test_mail_sent_successfully'                     => 'Correu de prova enviat correctament',
    'test-mail-btn-title'                             => 'Cal desar els canvis abans de provar.',
    'agreement_expire'                                => 'Les actualitzacions i l\'assistència de productes caducaran el :date',
    'agreement_expired'                               => 'Les actualitzacions del producte i l\'assistència van caducar el :date',
    'piracy_message'                                  => 'La vostra clau de llicència de FusionInvoice no és vàlida. La pirateria de programari és un delicte. Si us plau, juga net. Amb una llicència vàlida rebràs suport, actualitzacions i un bon karma.',
    'buy-now'                                         => 'Compra ara',
    'piracy_alert'                                    => 'Si us plau, sigueu justos!',
    'agreement-expire-alert'                          => 'Actualitzacions del producte i assistència caducant aviat.',
    'agreement-expired-alert'                         => 'Les actualitzacions del producte i l\'assistència han caducat.',
    'dismiss-forever'                                 => 'Descartar per sempre',
    'renew-now'                                       => 'Renova ara',
    'select_all_permissions'                          => 'Seleccioneu Tots els permisos',
    'app-key-missing'                                 => 'Introduïu una clau de llicència vàlida',
    'custom_fields_column_width'                      => 'Els camps personalitzats mostren les columnes',
    'select-user-type'                                => 'Seleccioneu el tipus d\'usuari',
    'lead-or-prospect-with-invoices-error'            => 'Ho sentim, el tipus d\'un client no pot ser client potencial o potencial quan hi ha factures o factures recurrents.',
    'sendgrid_key'                                    => 'Clau Sendgrid',

    //2020-2.0
    'space'                                           => 'Espai',
    'apostrophe'                                      => 'Apòstrof',
    'comma'                                           => 'coma',
    'fullstop'                                        => 'Punt (punt final)',
    'middledot'                                       => 'Punt mitjà',
    'thinspace'                                       => 'Espai prim',
    'narrow-no-break-space'                           => 'Espai estret sense interrupció',
    'dotabove'                                        => 'Punt a dalt',
    'arabic-decimal'                                  => 'Separador decimal àrab',
    'arabic-thousand'                                 => 'Separador de mil àrabs',
    'decimal-separator-key-symbol'                    => 'Símbol de la clau del separador decimal',
    'select-item'                                     => 'Seleccioneu l\'element',
    'item-lookup-overload'                            => 'Màxim de :max_import elements permesos per a la cerca d\'elements',
    'select-expense-category'                         => 'Seleccioneu la categoria de despeses',
    'select-expense-vendor'                           => 'Seleccioneu Proveïdor de despeses',
    'can-not-delete-all-users'                        => 'Ho sentim, no podeu suprimir tots els usuaris del sistema',
    'can-not-change-default-user-role'                => 'Ho sentim, no pots canviar el rol d\'usuari predeterminat',
    'can-not-change-default-user-status'              => 'Ho sentim, no pots canviar l\'estat d\'usuari predeterminat',
    'user_not_active'                                 => 'L\'usuari no està actiu',
    'can-not-inactive-your-own-status'                => 'Ho sentim, no pots deixar-te inactiu.',
    'delete_user_warning'                             => '<p>PARA! Suprimir aquest usuari és una acció destructiva que pot eliminar els registres que han creat dins del sistema. Penseu en fer l\'usuari inactiu.</p><p>Esteu segur que voleu suprimir aquest usuari?</p>',
    'include_time_in_due_date'                        => 'Inclou l\'hora a la data de venciment',
    'cannot_delete_default_company'                   => 'No podeu suprimir el perfil d\'empresa predeterminat',
    'make-user-inactive'                              => 'Fer l\'usuari inactiu',
    'mail_from_address'                               => 'Correu de l\'adreça',
    'mail_from_name'                                  => 'Correu de Nom',
    'item_categories'                                 => 'Categories d\'articles',
    'select-item-category'                            => 'Seleccioneu la categoria d\'elements',
    'item_category_form'                              => 'Formulari de categoria d\'elements',
    'sort_by_due'                                     => 'Ordena per data de venciment',
    'affiliate'                                       => 'Afiliat',
    'parent_account'                                  => 'Compte dels pares',
    'child_account'                                   => 'Comptes infantils',
    'select_parent_client'                            => 'Seleccioneu Compte pare',
    'record_successfully_retrieved'                   => 'El registre s\'ha recuperat correctament',
    'custom-image-not-support'                        => 'El camp d\'imatge personalitzada no és compatible',
    'custom-tag-not-support'                          => 'El camp d\'etiqueta personalitzada no és compatible',
    'custom-checkbox-not-support'                     => 'El camp de la casella de selecció personalitzada no és compatible',
    'custom-date-not-support'                         => 'El camp de data personalitzat no és compatible',
    'custom-datetime-not-support'                     => 'El camp de data i hora personalitzat no és compatible',
    'timeline'                                        => 'Línia de temps',
    'client_invoice'                                  => 'Factures per client',
    'select_client_blank_for_all'                     => 'Seleccioneu client (en blanc per a tots)',
    'invoice_email_success'                           => 'El correu electrònic de la factura s\'ha enviat correctament',
    'quote_email_success'                             => 'El correu electrònic de pressupost s\'ha enviat correctament',
    'document_number_schemes'                         => 'Numeració de documents',
    'document_number_scheme'                          => 'Esquema de números de document',
    'document_number_scheme_form'                     => 'Formulari d\'esquema de números de document',
    'default_document_number_scheme'                  => 'Esquema de números de document predeterminat',
    'supporting_data'                                 => 'Dades de suport',
    'customizations'                                  => 'Personalitzacions',
    'utilities_and_logs'                              => 'Utilitats i registres',
    'system_log'                                      => 'Registre del sistema',
    'paid_amount'                                     => 'Import pagat',
    'payment_amount'                                  => 'Import del pagament',
    'payment_intent'                                  => 'Intenció de pagament',
    'apply_payment_to_one_or_more_invoice'            => 'Aplicar el pagament a una o més factures',
    'pre_payment_for_future_invoices'                 => 'Prepagament per a futures factures',
    'apply_to_invoices'                               => 'Aplicar a les factures',
    'payment_application'                             => 'Aplicació de pagament',
    'remaining_payment_balance'                       => 'Saldo de pagament restant',
    'remaining_balance'                               => 'El saldo restant',
    'payment_warning'                                 => 'Introduïu la quantitat',
    'apply_pre_payment_warning'                       => 'No heu aplicat el pagament a cap factura. Voleu registrar-lo com a prepagament?',
    'confirm_remaining_balance'                       => 'El saldo restant de :value estarà disponible per aplicar-lo a futures factures d\'aquest client.',
    'open_balance'                                    => 'Balanç obert',
    'more_figure_then_total_payment'                  => 'Torneu a introduir el pagament, el pagament total de la factura és superior al saldo restant.',
    'remaining_payment_balance_apply_later_info'      => 'Els saldos de pagament restants es poden aplicar a altres factures més endavant.',
    'invoice_balance'                                 => 'Saldo de la factura',
    'enter_payment_for_invoice'                       => 'Introduïu el pagament de la factura',
    'invoice_pdf'                                     => 'Factura PDF',
    'payment_applications'                            => 'Aplicacions de pagament',
    'multiple'                                        => 'Múltiples',
    'ok'                                              => 'D\'acord',
    'credit_memo_default'                             => 'Nota de crèdit per defecte',
    'edit_payment'                                    => 'Edita el pagament',
    'credit_memo'                                     => 'Nota de crèdit',
    'credit_memos'                                    => 'Memòries de crèdit',
    'create_credit_memo'                              => 'Crear una nota de crèdit',
    'credit_applications'                             => 'Sol·licituds de nota de crèdit',
    'credit_applications_for_invoice'                 => 'Sol·licituds de nota de crèdit per a factura',
    'prepayment_applications_for_invoice'             => 'Sol·licituds de prepagament de la factura',
    'apply_credit_memo'                               => 'Aplica la nota de crèdit',
    'apply_pre_payment'                               => 'Aplica el prepagament',
    'applied_amount'                                  => 'Import aplicat',
    'remaining_credit_balance'                        => 'Saldo de crèdit restant',
    'remaining_credit_balance_apply_later_info'       => 'Els saldos de crèdit restants es poden aplicar a altres factures més endavant.',
    'applied'                                         => 'Aplicat',
    'more_figure_then_invoice_amount'                 => 'Torneu a introduir l\'import, l\'import no pot ser superior a l\'import de la factura.',
    'more_figure_then_invoice_total'                  => 'Torneu a introduir l\'import, l\'import total aplicat no pot ser superior a l\'import de la factura.',
    'invoice_not_selected_warning'                    => 'Espereu, no heu aplicat la nota de crèdit a cap factura.',
    'select_type'                                     => 'Seleccioneu Tipus',
    'email_credit_memo'                               => 'Nota de crèdit per correu electrònic',
    'back_to_credit_memo'                             => 'Tornar a la nota de crèdit',
    'invoice_amount'                                  => 'Import de la factura',
    'remaining_invoice_amount'                        => 'Import de la factura restant',
    'settlement_for_credit_memo'                      => 'Liquidació de la nota de crèdit',
    'credit_memo_amount'                              => 'Import de la nota de crèdit',
    'confirm_remaining_balance_invoice'               => 'El saldo restant d\'aquesta factura serà :value després de la liquidació.',
    'payment_receipt_for_invoices'                    => 'Rebut de pagament de factures',
    'primary_phone'                                   => 'Número de telèfon principal',
    'alternate_phone'                                 => 'Número de telèfon alternatiu',
    'currency_not_match'                              => 'La moneda no coincideix',
    'tasks'                                           => 'Tasques',
    'full_and_final_payment'                          => 'ple',
    'partial'                                         => 'parcial',
    'transition'                                      => [
        'created'          => 'Creat',
        'updated'          => 'Actualitzat',
        'deleted'          => 'S\'ha suprimit',
        'received'         => 'Rebut',
        'opened'           => 'Obert',
        'sent'             => 'Enviat',
        'mail'             => 'Enviat per correu',
        'changed'          => 'Canviat',
        'recurring'        => 'Creat',
        'completed'        => 'Completat',
        'reversed'         => 'Invertit',
        'quote_to_invoice' => 'Cotització per facturar',
        'download'         => 'descarregar',
        'added'            => 'Afegit',
        'email'            => 'Correu electrònic',
        'merge'            => 'Fusionar',
        'billed'           => 'Facturat',
        'failed'           => 'Fracassat',
        'invoice'          => [
            'created'                => 'S\'ha creat la factura :invoice_number',
            'credit_memo_created'    => 'S\'ha creat la nota de crèdit :credit_memo_number',
            'credit_memo_updated'    => 'La nota de crèdit :credit_memo_number s\'ha modificat',
            'created_from_recurring' => 'S\'ha creat :invoice_number (a partir de la plantilla recurrent <strong>:recurring_invoice_id</span></strong> )~',
            'updated'                => 'S\'ha modificat la factura :invoice_number',
            'deleted'                => 'S\'ha suprimit la factura :invoice_number',
            'credit_memo_deleted'    => 'S\'ha suprimit la nota de crèdit :credit_memo_number',
            'status_changed'         => 'Factura :invoice_number L\'estat ha canviat de <strong><del>:previous_value</span></del></strong> ~ a <strong>:current_value</span></strong> ~',
            'email_sent'             => 'Correu electrònic enviat :invoice_number de la factura',
            'resend_email'           => 'Reenvia el correu electrònic de la factura :invoice_number',
            'email_opened'           => 'S\'ha obert el correu electrònic de la factura :invoice_number',
            'payment_updated'        => ':invoice_number actualitzat :full_payment_text pagament',
            'payment_received'       => ':invoice_number rebut :full_payment_text pagament',
            'payment_reversed'       => 'La factura :invoice_number tenia un :full_payment_text',
            'invoice_tag_updated'    => 'L\'etiqueta de factura :tags s\'ha afegit a la factura :invoice_number',
            'invoice_tag_deleted'    => 'L\'etiqueta de factura :invoice_number s\'ha suprimit :tags',
            'mark_mail'              => 'Factura :invoice_number marca com a enviada per correu',
            'unmark_mail'            => 'La factura :invoice_number emmascara com a enviada per correu',
            'paid_invoice_opened'    => 'La factura pagada s\'ha obert per editar <strong>:invoice_number</span></strong> ~',
            'sent_invoice_opened'    => 'La factura enviada s\'ha obert per editar <strong>:invoice_number</span></strong> ~',
            'sms_sent'               => 'Factura :invoice_number SMS enviat',
        ],
        'quote'            => [
            'created'           => 'S\'ha creat la cita :quote_number',
            'updated'           => 'S\'ha modificat la cita :quote_number',
            'deleted'           => 'S\'ha suprimit la cita :quote_number',
            'status_changed'    => 'Quote :quote_number L\'estat ha canviat de <strong><del>:previous_value</span></del></strong> ~ a <strong>:current_value</span></strong> ~',
            'email_sent'        => 'S\'ha enviat un correu electrònic de cita :quote_number',
            'resend_email'      => 'Cita :quote_number Torna a enviar el correu electrònic',
            'email_opened'      => 'S\'ha obert el correu electrònic Quote :quote_number',
            'quote_to_invoice'  => ':quote_number s\'ha convertit en una factura - <strong>:invoice_number</span></strong> ~',
            'quote_tag_updated' => 'L\'etiqueta de cita :tags es va afegir a la cita :quote_number',
            'quote_tag_deleted' => 'L\'etiqueta de cita :quote_number s\'ha suprimit :tags',
            'sms_sent'          => 'Quote :quote_number SMS enviat',
        ],
        'payment'          => [
            'prepayment_created'           => 'S\'ha creat el prepagament',
            'payment_receipt_email_sent'   => 'S\'ha enviat el correu electrònic del rebut de pagament',
            'payment_receipt_resend_email' => 'Torna a enviar el correu electrònic del rebut de pagament',
            'payment_updated'              => 'S\'ha modificat el pagament',
            'deleted'                      => 'El pagament s\'ha suprimit',
            'payment_receipt_pdf_download' => 'Descàrrega en PDF del rebut de pagament',
            'payment_note_deleted'         => 'S\'ha suprimit la nota de pagament: <span><strong><del>:previous_value</span></del></strong></span> ~',
            'payment_note_added'           => 'S\'ha afegit una nota de pagament: <strong>:current_value</span></strong> ~',
            'payment_note_updated'         => 'La nota de pagament s\'ha actualitzat de <strong><del>:previous_value</span></del></strong> ~ a <strong>:current_value</span></strong> ~',
            'payment_failed'               => 'El pagament ha fallat',
        ],
        'client'           => [
            'client_created'     => 'S\'ha creat :client_type',
            'type_changed'       => '<strong><del>:previous_value</span></del></strong> ~ es va convertir en un <strong>:current_value</span></strong> ~',
            'updated'            => 'El client s\'ha actualitzat',
            'deleted'            => '<strong><del>â€œ :client_nameâ€</span></del></strong> ~ s\'ha suprimit',
            'status_changed'     => 'S\'ha establert el client a <strong>:current_value</span></strong> ~',
            'client_tag_updated' => 'S\'ha afegit l\'etiqueta :tags',
            'client_tag_deleted' => 'L\'etiqueta :tags s\'ha suprimit',
            'merge'              => 'Identificador de client: :idTo - :nameTo es va combinar amb l\'ID de client: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Es va crear una despesa',
            'updated' => 'La despesa s\'ha modificat',
            'deleted' => 'S\'ha suprimit la despesa',
            'billed'  => 'La despesa es va facturar',
            'vendor'  => [
                'created' => 'Es va crear el proveïdor de despeses',
                'updated' => 'S\'ha modificat el proveïdor de despeses',
                'deleted' => 'S\'ha suprimit el proveïdor de despeses',
            ],
        ],
        'note'             => [
            'created'          => 'S\'ha creat una nota',
            'updated'          => 'La nota s\'ha modificat',
            'deleted'          => 'S\'ha suprimit la nota',
            'note_tag_updated' => 'L\'etiqueta :tags s\'ha afegit a la nota',
            'note_tag_deleted' => 'L\'etiqueta :tags s\'ha suprimit de la nota',
        ],
        'task'             => [
            'created'   => 'S\'ha creat la tasca',
            'updated'   => 'S\'ha modificat la tasca',
            'deleted'   => 'S\'ha suprimit la tasca',
            'completed' => 'S\'ha completat la tasca',
        ],
        'subscription'     => [
            'created'                       => 'S\'ha creat la subscripció :invoice_number',
            'updated'                       => 'La subscripció :invoice_number s\'ha modificat',
            'deleted'                       => 'La subscripció :invoice_number s\'ha suprimit',
            'recurring_invoice_tag_updated' => 'L\'etiqueta de subscripció :tags s\'ha afegit a la subscripció :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'L\'etiqueta de subscripció :recurringInvoice_number s\'ha suprimit :tags',
        ],
        'attachment'       => [
            'created' => ':filename s\'ha penjat com a fitxer adjunt',
            'deleted' => ':filename s\'ha eliminat com a fitxer adjunt',
        ],
        'tag'              => [
            'created' => 'L\'etiqueta :tag s\'ha afegit a <strong>:module</span></strong> ~.',
            'deleted' => 'L\'etiqueta :tag s\'ha eliminat de <strong>:module</span></strong> ~.',
        ],
    ],
    'reset'                                           => 'Restableix',
    'select_event'                                    => 'Seleccioneu el tipus d\'esdeveniment',
    'select_country'                                  => 'Seleccioneu un país',
    'type_captcha'                                    => 'Si us plau, respon a la pregunta anterior',
    'refresh_captcha'                                 => 'Actualitza la pregunta',
    'answer'                                          => 'Respon',
    'use_captcha_in_login'                            => 'Utilitzeu captcha per iniciar sessió',
    'allow_client_timeline'                           => 'Cronologia',
    'client_timeline'                                 => 'Cronologia',
    'no_invoice_tags'                                 => 'No hi ha etiquetes de factura.',
    'total_notifications'                             => 'Tens :total notificacions',
    'no_notifications'                                => 'No hi ha notificacions noves',
    'notifications'                                   => 'Notificacions',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Una nova tasca que t\'ha assignat',
            'due_date_breached' => 'La tasca <strong>" :task_title"</span></strong> ~ ha passat la seva data de venciment.',
            'completed'         => ':user tasca completada: <strong>:task_title</span></strong> ~',
        ],
        'quote' => [
            'approved'             => ':quote_number ha estat aprovat',
            'quote_to_invoice'     => ':quote_number s\'ha convertit en una factura - <strong>:invoice_number</span></strong> ~',
            'rejected'             => ':quote_number ha estat rebutjat',
            'payment_successfully' => 'S\'ha pagat la cotització :quote_number per al client :client_name . S\'ha creat la factura :invoice_number i s\'ha aplicat el pagament',
        ],
    ],
    'search_tasks'                                    => 'Tasques de cerca',
    'reopen_task'                                     => 'Torna a obrir la tasca',
    'task_form'                                       => 'Afegeix una tasca',
    'view_task'                                       => 'Detalls de la tasca',
    'client_deleted'                                  => 'S\'ha suprimit el client',
    'payment_canceled'                                => 'El vostre pagament s\'ha cancel·lat',
    'default_company_profile_set'                     => 'Hem configurat el vostre perfil d\'empresa predeterminat. Podeu actualitzar-lo en qualsevol moment des de la configuració del perfil d\'empresa.',
    'file_uploaded_successfully'                      => 'El fitxer s\'ha penjat correctament',
    'attachment_notice'                               => 'Mida màxima del fitxer adjunt inferior o igual a :size',
    'attachment_error'                                => 'La mida del fitxer adjunt no pot superar :size',
    'attachment_warning'                              => 'La mida del fitxer adjunt és :size . La càrrega de molts fitxers adjunts grans pot degradar el rendiment de la vostra base de dades amb el temps.',
    'generate_timeline_history'                       => 'Generar historial de cronologia',
    'generating_timeline_wait'                        => 'S\'està generant la cronologia, espereu...',
    'generating_timeline_confirm'                     => 'La funció de cronologia s\'ha afegit a FusionInvoice 2020. Això generarà entrades de cronologia per a totes les activitats que van precedir aquesta funció. Continuar?',
    'generated_timeline_request_accepted'             => 'S\'ha completat la generació de l\'historial de la línia de temps.',
    'transitions'                                     => 'Història de la cronologia',
    'pending'                                         => 'Pendents',
    'client_transition'                               => 'Cronologia del client',
    'expense_transition'                              => 'Cronologia de despeses',
    'invoice_transition'                              => 'Cronologia de facturació',
    'payment_invoice_transition'                      => 'Termini de pagament de la factura',
    'payment_transition'                              => 'Terminis de pagament',
    'quote_transition'                                => 'Línia de temps de cita',
    'note_transition'                                 => 'Anoteu les cronologies',
    'task_transition'                                 => 'Cronologia de les tasques',
    'email_sent'                                      => 'Email enviat',
    'credit_applied'                                  => 'Crèdit aplicat',
    'configuration'                                   => 'Configuració',
    'include_prepayments'                             => 'Inclou pagaments anticipats',
    'pre_payment'                                     => 'Prepagament',
    'pre_payments'                                    => 'Prepagaments',
    'times'                                           => 'Temps',
    'include_prepayments_applied'                     => 'Inclou els prepagaments aplicats',
    'confirm_full_payment_applied'                    => 'El pagament s\'ha aplicat completament',
    'confirm_full_credit_memo_applied'                => 'La nota de crèdit s\'ha aplicat completament',
    'all_tasks'                                       => 'Totes les tasques',
    'my_tasks'                                        => 'Les meves tasques',
    'assigned_from_others'                            => 'Assignat d\'altres',
    'full_payment_reversed'                           => 'pagament complet revertit.',
    'partial_payment_reversed'                        => 'pagament parcial revertit.',
    'invoice_delete_error'                            => 'Ho sentim, no podeu suprimir una factura que contingui pagaments o aplicacions de nota de crèdit. Primer heu de suprimir les sol·licituds de pagament o nota de crèdit.',
    'mail-from-required'                              => 'Heu d\'introduir una adreça de correu electrònic de correu vàlida',
    'contact_updated'                                 => 'El contacte s\'ha actualitzat correctament',
    'contact_added'                                   => 'El contacte s\'ha afegit correctament',
    'generate_passport_key_wait'                      => 'S\'està generant la clau del passaport, espereu...',
    'generate_passport_key'                           => 'Genera la clau del passaport',
    'default_greeting'                                => 'Hola, allà! <br>',
    'hi'                                              => 'Hola,',
    'deduct_tax_from_expenses'                        => 'Deduir l\'impost de les despeses',
    'invalid_invoice_id'                              => 'Identificador de factura no vàlid',
    'client_related_record_exist'                     => 'Ho sentim, el client té registres relacionats per a: :modules . Els clients amb historial de transaccions no es poden suprimir.',
    'email_payment_receipt_notice'                    => 'El client no té cap adreça de correu electrònic al fitxer',
    'show_more'                                       => 'Mostra més ...',
    'show_less'                                       => 'Mostra menys...',
    'invoice_already_paid'                            => 'La factura ja està pagada!',
    'system_default'                                  => 'Sistema per defecte',
    'created_by'                                      => 'Creat per',
    'created_at'                                      => 'Creat a',
    'task_created_by_and_created_at'                  => 'Tasca creada per :created_by a :created_at',
    'dashboard_widgets_date_options'                  => 'Període de temps predeterminat del sistema per als widgets',
    'dashboard-widget-from-date-required'             => 'La data a partir és necessària quan se selecciona l\'interval de dates personalitzat al període de temps predeterminat del sistema per al resum de la factura i el pressupost',
    'dashboard-widget-to-date-required'               => 'Fins a la data és obligatori quan es selecciona un interval de dates personalitzat al Període de temps predeterminat del sistema per al resum de la factura i el pressupost',
    'invoice_currency'                                => 'Moneda de la factura',
    'currency_format'                                 => 'Format de moneda',
    'create_missing_folder_success'                   => 'S\'ha creat la carpeta necessària que falta',
    'create_missing_folder_failed'                    => 'L\'intent de crear carpetes ha fallat :path',
    'folder_is_not_writable'                          => 'La carpeta no es pot escriure :path',
    'update_item_as_lookup'                           => 'Actualitza la cerca d\'elements',
    'number_of_tax_fields'                            => 'Nombre de camps fiscals',
    'tax_1_entry'                                     => '1 entrada',
    'tax_2_entries'                                   => '2 entrades',
    'require_tags_on_client_notes'                    => 'Requereix etiquetes a les notes del client',
    'entered_amount_less_than_invoice_amount'         => 'L\'import introduït ha de ser inferior o igual a l\'import de la factura',
    'send-to'                                         => 'Envia a',
    'print'                                           => 'Imprimir',
    'pdf_cleanup'                                     => 'Neteja de PDF',
    'pdf_cleanup_confirm'                             => 'Esteu segur que voleu netejar els fitxers PDF antics?',
    'pdf_cleanup_success'                             => 'S\'ha completat la neteja de PDF',
    'deleting_pdf_wait'                               => 'S\'estan suprimint fitxers PDF antics, espereu...',
    'open_invoices'                                   => 'Factures obertes',
    'open_credits'                                    => 'Crèdits oberts',
    'unapplied_payments'                              => 'Pagaments no aplicats',
    'attach_invoice_pdf'                              => 'Adjunteu el PDF de la factura',
    'upcoming_payment_notice'                         => 'Avís de pagament proper',
    'select_mapping'                                  => 'Seleccioneu Mapes',
    'select_named_export'                             => 'Seleccioneu Exportació amb nom',
    'save_mapping'                                    => 'Desa la cartografia',
    'add_mapping'                                     => 'Crea un mapa nou',
    'edit_mapping'                                    => 'Actualitzar el mapa',
    'save_as_default_mapping'                         => 'Mapeig per defecte',
    'save_as_default_export'                          => 'Exportació per defecte',
    'export_item_lookups'                             => 'Exporta les cerques d\'elements',
    'import_file_selection'                           => 'Importa la selecció de fitxers',
    'next'                                            => 'Pròxim',
    'delete_import_mapping_warning'                   => 'Esteu segur que voleu suprimir aquest mapatge?',
    'export'                                          => 'Exporta',
    'named_exports'                                   => 'Exportacions anomenades',
    'save_named_export'                               => 'Desa l\'exportació amb nom',
    'delete_named_export'                             => 'Suprimeix l\'exportació amb nom',
    'updated_at'                                      => 'Actualitzat a les',
    'zip'                                             => 'Zip',
    'fields_to_export'                                => 'Camps per exportar',
    'import-file-type-error'                          => 'El tipus de fitxer d\'importació ha de ser CSV',
    'recurring_invoice_items'                         => 'Elements de factura recurrent',
    'important_details'                               => 'Detalls importants',
    'important_information'                           => 'Informació important',
    'item_lookups_important_information'              => '<p>Si es troba un nom de cerca d\'element coincident a les dades existents durant la importació CSV, el lot d\'importació fallarà, mostrant l\'element que va provocar l\'error.</p>',
    'invoices_important_information'                  => '<p>El nom del client (del CSV) es cerca a la taula Clients i es resol a client_id, si hi ha un nom que coincideix. Si no es troba cap coincidència de nom, es crea una entrada de client i utilitza l\'ID de la nova entrada de client</p><p>Número de factura, "número" a la taula de factures es conserva des del CSV com a número de factura. Si el número de factura ja existeix quan s\'intenta importar, la importació per lot fallarà.</p><p>Invoice_items fa una cerca al número de factura (des del CSV) a la taula de factures i el resol amb l\'ID. No es fan altres cerques/validacions de camps clau</p>',
    'invoice_items_important_information'             => '<p>La importació invoice_items fa una cerca al número de factura (del CSV) a la taula de factures i el resol amb l\'ID de factura adequat. L\'identificador de client també es deriva de la informació de la factura coincident.</p>',
    'payments_important_information'                  => '<p>Per importar pagaments, cal un número de factura coincident vàlid per aplicar els pagaments. Si no es troba una factura coincident, es produirà un error en la importació del lot complet.</p><p>L\'identificador de client adequat es resol mitjançant el número de factura al CSV, a partir d\'una cerca a la taula de factures.</p> <p>Es realitza una cerca al nom del mètode de pagament (del CSV a la taula payment_methods) i es resoldrà amb l\'identificador de payment_method_id adequat, si es troba. si es troba un nom que no coincideix, es crearà un registre de mètode de pagament nou i s\'utilitzarà el nou payment_method_id.</p>',
    'run_daily_tasks'                                 => 'Executar tasques diàries',
    'daily_task_ran'                                  => 'Les tasques diàries s\'han executat correctament',
    'csv_row_number'                                  => 'CSV Número de fila :row',
    'max_item_lookup_records'                         => 'Màx. Registres de cerca d\'elements',
    'invoice_with_commission_delete_error'            => 'Ho sentim, no podeu suprimir una factura que tingui entrades de comissions amb un estat de pagament. Primer heu d\'eliminar la comissió pagada d\'aquesta factura.',
    'if_invoice_is_emailed_while_draft'               => 'Si la factura s\'envia per correu electrònic mentre es troba en estat d\'esborrany',
    'custom_payment_receipt_body_not_exists'          => 'No s\'ha trobat la plantilla personalitzada per als rebuts de pagament. "custom/email_templates/ payment/ paymentReceiptBody.blade.php"',
    'invoice_email_body_type'                         => 'Tipus de cos del correu electrònic de la factura',
    'send_overdue_reminder'                           => 'Envia un recordatori vençut',
    'reminder_sent_successfully'                      => 'El recordatori s\'ha enviat correctament',
    'error_sending_reminder'                          => 'S\'ha produït un error en enviar el recordatori. Torneu-ho a provar més tard.',
    'expense_date'                                    => 'Data de la despesa',
    'group_by'                                        => 'Agrupar per',
    'timeline_scope_all_user'                         => 'Àmbit de la cronologia: tots els usuaris',
    'copy_to_clipboard'                               => 'Copiar al portapapers',
    'text_copied_clipboard'                           => 'Text copiat al porta-retalls!',
    'import_example_csv'                              => 'Podeu trobar un exemple de fitxer CSV aquí',
    'import'                                          => 'Importar',
    'address2'                                        => 'Adreça 2',
    'use_parent_email'                                => 'Utilitzeu el correu electrònic dels pares',
    'max_import_records'                              => 'El límit màxim per importar registres és :total_records',
    'demo_file_attachment_disabled'                   => 'Els fitxers adjunts estan desactivats a la demostració',
    'drag_drop_file'                                  => 'Arrossegueu i deixeu anar per carregar el fitxer',
    'or'                                              => 'O',
    'browse_file'                                     => 'Navega el fitxer',
    'system_setting_and_ui'                           => 'Configuració del sistema i interfície d\'usuari',
    'localization_and_timezone'                       => 'Localització i zona horària',
    'security'                                        => 'Seguretat',
    'cleanup_and_backup'                              => 'Neteja i còpia de seguretat',
    'attach_quote_pdf'                                => 'Adjunteu PDF de pressupost',
    'attach_payment_receipt'                          => 'Adjunteu el rebut de pagament',
    'choose-file'                                     => 'Trieu l\'arxiu',
    'important-note'                                  => 'Nota important',
    'collapse'                                        => 'Col·lapse',
    'add_task'                                        => 'Afegeix una tasca',
    'recurring_invoice_commissions'                   => 'Comissions de factura recurrent',
    'invoice_commissions'                             => 'Comissions de facturació',
    'percentage'                                      => 'Percentatge',
    'flat_amount'                                     => 'Quantitat plana',
    'discount-amount'                                 => 'Descompte',
    'discount-type'                                   => 'Tipus de descompte',
    'saving'                                          => 'S\'està desant...',
    'preparing'                                       => 'Preparant',
    'allow_line_item_discounts'                       => 'Permet descomptes de línia de comanda',
    'invalid_price_amount'                            => 'El preu no pot ser zero/buit',
    'light-mode'                                      => 'Mode de llum',
    'dark-mode'                                       => 'Mode fosc',
    'system_base_currency'                            => 'Moneda base del sistema',
    'is_recurring_task'                               => 'És una tasca recurrent',
    'contact_names'                                   => 'Noms de contacte',
    'all_client'                                      => 'Tots els Clients',
    'invoice_grand_total'                             => 'Total de facturació',
    'recurring_invoice_grand_total'                   => 'Total de factura recurrent',
    'is_required'                                     => 'Es requereix?',
    'add-new-client'                                  => 'Afegeix un client nou',
    'client_name_required'                            => 'El nom del client és obligatori',
    'custom_item_text_validate'                       => 'Introduïu un element vàlid :label al camp :label.',
    'assigned_to_others'                              => 'Assignat a Altres',
    'all_tasks_and_all_users'                         => 'Totes les tasques/Tots els usuaris',
    'statement'                                       => 'Declaració',
    'profile_code'                                    => 'Codi de perfil',
    'login-url'                                       => 'URL d\'inici de sessió',
    'url_copied_clipboard'                            => 'URL copiat al porta-retalls!',
    'payment_receipt_email_sent'                      => 'Correu electrònic del rebut de pagament enviat correctament',
    'edit_payment_note_form'                          => 'Edita la nota de pagament',
    'payment_invoices_text'                           => 'Gràcies! El vostre pagament de :amount s\'ha aplicat a les factures següents.',
    'payment_text'                                    => 'Gràcies pel vostre pagament de :amount.',
    'date_filter_by'                                  => 'Data Filtra per',
    'filter_by_invoice_date'                          => 'Data de la factura',
    'filter_by_payment_date'                          => 'Data de pagament',
    'date-range-required'                             => 'Seleccioneu Interval de dates',
    'save-and-complete'                               => 'Guarda i completa',
    'completion-note'                                 => 'Nota de finalització',
    'complete-with-note'                              => 'Completa amb nota',
    'placeholder_type_note'                           => 'Escriu les teves notes...',
    'credit_memo_email_subject'                       => 'Assumpte del correu electrònic de la nota de crèdit',
    'default_credit_memo_email_body'                  => 'Cos del correu electrònic de la nota de crèdit per defecte',
    'show_invoices_from'                              => 'Mostra les factures de',
    'system_mail_from_address'                        => 'Adreça de correu del sistema',
    'user_who_created_invoice'                        => 'Usuari que ha creat la factura',
    'completed'                                       => 'Completat',
    'no_auth_to_view_task'                            => 'Aquesta tasca ja no és a la vostra llista.',
    'credit-memo-and-prepayments'                     => 'Crèdits i prepagaments',
    'all_selected'                                    => 'Tots seleccionats',
    'select_columns'                                  => 'Seleccioneu Columnes',
    'column_settings'                                 => 'Configuració de la columna',
    'minimum_one_column_check_is_required'            => 'Seleccioneu almenys una columna',
    'date_of_entry'                                   => 'Data d\'entrada',
    'amount_applied'                                  => 'Import aplicat',
    'date_applied'                                    => 'Data d\'aplicació',
    'copy_to_recurring_invoice'                       => 'Còpia a la factura recurrent',
    'top_bar_color'                                   => 'Color de la barra superior',
    'light_grey'                                      => 'Gris clar',
    'bg-primary'                                      => 'Blau',
    'bg-warning'                                      => 'groc',
    'bg-info'                                         => 'Blau Libélula',
    'bg-danger'                                       => 'Vermell',
    'bg-success'                                      => 'Turf Green',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victòria Blava',
    'bg-navy'                                         => 'Blau marí',
    'bg-purple'                                       => 'Porpra',
    'bg-fuchsia'                                      => 'Fúcsia',
    'bg-pink'                                         => 'Rosa',
    'bg-maroon'                                       => 'Granat',
    'bg-orange'                                       => 'taronja',
    'bg-lime'                                         => 'Verd llima',
    'bg-teal'                                         => 'Teal',
    'bg-olive'                                        => 'Oliva',
    'fee_name'                                        => 'Nom de la taxa',
    'fee_percentage'                                  => 'Percentatge de tarifa',
    'fee_explanation'                                 => 'Explicació de la tarifa',
    'enable_online_payment_processing_fees'           => 'Activa les tarifes de processament de pagaments en línia',
    'allow_online_payment_processing_fees'            => 'Permet les tarifes de processament de pagaments en línia',
    'allow_online_pay_fees'                           => 'Permet comissions de pagament en línia',
    'convenience_charges'                             => 'Càrrecs de conveniència',
    'opp-fee-percentage-required'                     => 'Es requereix un percentatge de tarifes de processament de pagaments en línia',
    'opp-fee-percentage-gt-zero'                      => 'El percentatge de tarifes de processament de pagaments en línia ha de ser superior a zero',
    'cron_error'                                      => 'ha fallat a :datetime',
    'cron_start'                                      => 'El corredor de tasques diàries va començar a :datetime',
    'notification_clear_all'                          => 'Esborra totes les notificacions',
    'show'                                            => 'Espectacle',
    'report'                                          => 'Informeu',
    'profit_loss'                                     => 'Benefici i pèrdua',
    'credit_and_pre_payments'                         => 'Crèdits i prepagaments',
    'expenses_vendors'                                => 'Proveïdors de despeses',
    'expenses_categories'                             => 'Categories de despeses',
    'create'                                          => 'Crear',
    'import_map_clients'                              => 'Importa clients de mapes',
    'payctr_users'                                    => 'Usuaris de PaymentCenter',
    'ctrl_plus_click'                                 => 'Ctrl-Feu clic per afegir notes de finalització',
    'edit_note'                                       => 'Edita la nota',
    'save-and-unComplete'                             => 'Desa i no completa',
    'sales_chart'                                     => 'Gràfic de vendes',
    'accumulate_totals'                               => 'Totals acumulats',
    'do_not_accumulate_totals'                        => 'No acumuli totals',
    'kpi_cards'                                       => 'Targetes KPI',
    'no_data_to_display'                              => 'No hi ha dades per mostrar',
    'choose_period'                                   => 'Trieu Període',
    'date_mailed'                                     => 'Data d\'enviament',
    'date_emailed'                                    => 'Data d\'enviament per correu electrònic',
    'action'                                          => 'Acció',
    'mail'                                            => 'Correu',
    'mark_as_mailed'                                  => 'Marca com a enviat per correu',
    'invoice_mailed'                                  => 'La factura s\'ha marcat com a enviada per correu',
    'emailed'                                         => 'Enviat per correu electrònic',
    'paid_invoice_canceled_error'                     => 'Per cancel·lar aquesta factura, suprimiu els pagaments de la factura.',
    'allow_invoice_delete'                            => 'Permet la supressió de la factura',
    'allow_child_accounts'                            => 'Permet comptes infantils',
    'third_party_bill_payer'                          => 'Pagador de factures de tercers',
    'invoices_paid_by'                                => 'Factures pagades per',
    'use_third_party_bill_payer_email'                => 'Utilitzeu el correu electrònic del pagador de factures de tercers',
    'email_default'                                   => 'Correu electrònic per defecte',
    'client_default'                                  => 'Client per defecte',
    'clear-all'                                       => 'Esborra-ho tot',
    'system_log_is_missing_or_empty'                  => 'Falta el registre del sistema o està buit',
    'change_to_draft'                                 => 'Canvia a Esborrany',
    'invoice_status_change_to_draft'                  => 'Canvi d\'estat de la factura a Esborrany',
    'there_is_some_error'                             => 'Hi ha alguns errors',
    'filter_by_date'                                  => 'Filtra per data',
    'quote_grand_total'                               => 'Cotització Gran Total',
    'email_upcoming_payment_due_notice'               => 'Avís de pagament per correu electrònic',
    'email_overdue_invoice_reminder'                  => 'Recordatori de factura vençuda per correu electrònic',
    'page_totals'                                     => 'Totals de pàgines',
    'categories'                                      => 'Categories',
    'conven_charges'                                  => 'Conv. Càrrecs',
    'invoice_status_change_to_cancel'                 => 'Canviar l\'estat de la factura a Cancel·lar',
    'filter_by_invoice_number'                        => 'Nombre de factura',
    'filter_by_client_name'                           => 'Nom del client',
    'custom_mail_template'                            => 'Plantilla de correu personalitzada',
    'invoice_use_custom_mail_template'                => 'Factura Utilitzeu una plantilla de correu personalitzada',
    'client_or_company_name'                          => 'Nom del client/empresa',
    'view_invoice'                                    => 'Veure factura',
    'tt_active'                                       => 'Quan un registre de client no està actiu, no apareixerà a la llista de clients predeterminada i no es permetran les transaccions normals.',
    'tt_invoice_prefix'                               => 'Un codi de prefix de factura únic s\'assigna automàticament a un registre de client quan es crea. Es pot canviar manualment més tard. Es pot utilitzar com a part del vostre esquema de numeració de documents per a la numeració de factures, permetent un número de factura únic per client.',
    'tt_automatic_email_payment_receipts'             => 'Envia un rebut de pagament per correu electrònic al client després de rebre un pagament. Una configuració global està disponible a la configuració del sistema, però es pot substituir per cada client individual.',
    'tt_automatic_email_on_recur'                     => 'Envia una factura per correu electrònic al client quan s\'executa una factura recurrent i crea una factura en directe. Una configuració global està disponible a la configuració del sistema, però es pot substituir per cada client individual.',
    'tt_default_currency'                             => 'La moneda assignada a aquest compte de client, que s\'utilitzarà per a les seves operacions de factura, pressupost i pagament. Aquest valor és per defecte de la configuració del sistema per a la moneda base.',
    'tt_language'                                     => 'L\'idioma que es mostrarà per al client quan iniciï sessió al centre de clients.',
    'tt_allow_client_center_login'                    => 'S\'ha de permetre al client iniciar sessió al vostre centre de clients de FusionInvoice? El seu correu electrònic s\'ha d\'utilitzar per al seu nom d\'usuari i heu d\'assignar una contrasenya. L\'URL del centre de clients és <your_fusioninvoice_url>/client_center',
    'tt_timezone'                                     => 'Zona horària del client. Si s\'introdueix, l\'hora local del client es mostrarà a la part superior de la vista de la pàgina del client.',
    'tt_allow_online_payment_processing_fees'         => 'Les tarifes de processament de pagaments en línia es poden avaluar per als clients que paguen amb targeta de crèdit, mitjançant l\'enllaç de la factura pública (inclòs al correu electrònic de la factura). Aquesta opció té una configuració global del sistema, però també es pot substituir per a un client individual.',
    'tt_allow_child_accounts'                         => 'Si configureu Permet comptes infantils a Sí, aquest client pot actuar com a compte principal i us permetrà seleccionar-lo a la llista de comptes per a pares.',
    'tt_third_party_bill_payer'                       => 'Un tercer pagador de factures és una organització que paga les factures dels seus clients, com ara una empresa de comptabilitat externa.',
    'tt_parent_account'                               => 'L\'empresa matriu amb la qual està relacionat aquest client o una filial. Aquesta llista conté els registres de client que tenen l\'opció Permetre comptes infantils establerta en Sí. Deixeu-lo en blanc si el client no té cap compte principal.',
    'tt_invoices_paid_by'                             => 'El negoci de tercers que aquest client utilitza per pagar les seves factures. Aquesta llista conté els registres del client que tenen l\'opció Pagador de factures de tercers establerta en Sí. Deixeu buit si el client paga les seves pròpies factures.',
    'tt_email_default'                                => 'Quan envieu correus electrònics a aquest client, seleccioneu el correu electrònic que s\'ha d\'utilitzar. Si aquest client té associat un compte principal o un compte de Factures pagades per, es pot seleccionar qualsevol d\'aquestes opcions. El correu electrònic estàndard del client és per defecte.',
    'tt_default_to'                                   => 'Quan envieu correus electrònics, aquest contacte s\'ha d\'afegir automàticament a la llista de destinataris \'A :\' ?',
    'tt_default_cc'                                   => 'Quan envieu correus electrònics, aquest contacte s\'hauria d\'afegir automàticament a la llista de destinataris \'CC :\' ?',
    'tt_default_bcc'                                  => 'Quan envieu correus electrònics, aquest contacte s\'ha d\'afegir automàticament a la llista de destinataris \'BCC :\' ?',
    'tt_client_type'                                  => 'Un Lead és un candidat de vendes no qualificat. Un prospecte és un candidat qualificat que aviat es pot convertir en client. Un client és una empresa o una persona amb qui heu venut (o aviat vendrà) béns o serveis. Un afiliat és una empresa o individu que ven els vostres béns o serveis. Altres s\'utilitza per a negocis que no s\'ajusten als altres tipus, com ara pagadors de factures de tercers o comptes de pares amb els quals no feu negocis directament.',
    'tt_client_tags'                                  => 'Es poden assignar etiquetes a un client per ajudar a categoritzar o filtrar la vostra llista de clients per veure\'ls o informar-los.',
    'tt_important_note'                               => 'Una nota introduïda aquí apareixerà automàticament dins d\'un IMPORTANT! finestra quan es visualitza el registre del client.',
    'tt_gen_header_title_text'                        => 'El text que es mostra a la cantonada superior esquerra, al costat del vostre logotip, normalment el nom de la vostra empresa.',
    'tt_gen_default_company_profile'                  => 'El perfil de l\'empresa que s\'utilitza per defecte a l\'hora de crear noves factures, pressupostos, etc. Els perfils d\'empresa us permeten presentar el vostre negoci de manera diferent amb cada perfil, permetent diferents noms d\'empresa, logotips, formats de factura, etc.',
    'tt_gen_address_format'                           => 'Us permet crear el format d\'adreça que es mostra a les factures i pressupostos mitjançant el camp d\'adreça única o una combinació dels camps d\'adreça individuals, com ara ciutat, estat, país, etc.',
    'tt_gen_custom_fields_columns'                    => 'Els camps personalitzats es poden mostrar d\'1 a 3 camps per fila.',
    'tt_gen_require_tags_on_client_notes'             => 'Si s\'estableix en Sí, caldrà que s\'hagi seleccionat o introduït una etiqueta en afegir una nota de client, com ara "Suport" o "Vendes", Això és útil per classificar i cercar notes.',
    'tt_gen_skin'                                     => 'Com us agradaria que es mostrés la vostra interfície d\'usuari FI, en mode clar o fosc',
    'tt_gen_top_bar_color'                            => 'El color de la barra de títol superior. Si treballeu amb diverses instal·lacions de FusionInvoice diferents, aquesta pot ser una identificació visual útil.',
    'tt_gen_results_per_page'                         => 'El nombre de registres que es mostren per pàgina per a totes les visualitzacions de llista, com ara clients, factures, pressupostos, despeses, etc.',
    'tt_gen_allow_line_item_discounts'                => 'Activa o desactiva la funció de descompte d\'elements de línia dins de factures i pressupostos.',
    'tt_gen_language'                                 => 'L\'idioma que s\'utilitzarà per a la instal·lació de FusionInvoice. Tingueu en compte que podeu assignar un idioma diferent als vostres clients, que els permeti interactuar amb el centre de clients de FusionInvoice utilitzant el seu idioma nadiu.',
    'tt_gen_date_format'                              => 'El vostre format de data preferit',
    'tt_gen_use_24_hour_time_format'                  => 'Permet suport de formats d\'hora de 24 o 12 hores.',
    'tt_gen_timezone'                                 => 'Zona horària principal de la vostra empresa.',
    'tt_gen_base_currency'                            => 'La moneda que la vostra empresa utilitza més sovint.',
    'tt_gen_exchange_rate_mode'                       => 'El manual us permet introduir el valor del tipus de canvi mentre creeu les factures. Automatic intentarà utilitzar una API pública per obtenir el tipus de canvi de la moneda. Això només s\'utilitza quan introduïu una transacció amb una moneda diferent de la vostra moneda base.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice admet fins a 2 camps d\'impostos per línia de comanda. El valor seleccionat amb mostra o amaga el segon camp fiscal.',
    'tt_gen_quantity_price_decimals'                  => 'El nombre de decimals a mostrar per als valors de quantitat i quantitat. Seleccioneu de 0 a 4 segons el nivell de precisió requerit.',
    'tt_gen_round_tax_decimals'                       => 'Seleccioneu el vostre nombre de decimals necessaris per als càlculs d\'arrodoniment d\'impostos.',
    'tt_gen_use_captcha_in_login'                     => 'Si s\'estableix en Sí, els usuaris hauran de respondre a una pregunta de repte CAPTCHA durant l\'inici de sessió.',
    'tt_gen_force_https'                              => 'Poques vegades recomanem activar aquesta opció. Si la vostra instal·lació no té instal·lat un certificat SSL que funcioni correctament al vostre servidor web, és possible que tingueu problemes per a la instal·lació de FusionInvoice. Podeu aconseguir el mateix resultat configurant una regla de redirecció del servidor.',
    'dashboard_settings'                              => 'Configuració del tauler',
    'tt_dashboard_settings'                           => 'El tauler s\'utilitza per mostrar mètriques i esdeveniments empresarials importants, proporcionant informació valuosa sobre el rendiment de la vostra empresa. El tauler predeterminat del sistema és el punt de partida per a tots els usuaris, però cada ús pot tenir el seu propi tauler específic d\'usuari. Els taulers de control específics per a l\'usuari, si es defineixen, es mostraran en lloc dels valors predeterminats del sistema.',
    'tt_db_default_time_period'                       => 'Estableix les dates d\'inici i de finalització predeterminades dels ginys del tauler de control que els utilitzen, com ara les targetes KPI i el gràfic de vendes.',
    'tt_db_recent_client_activity'                    => 'Un giny que mostra les interaccions dels clients, com ara els pagaments realitzats i les factures o els pressupostos visualitzats, des dels enllaços de la vostra factura pública o pressupost.',
    'tt_db_display_order'                             => 'Això canvia l\'ordre de visualització dels ginys del tauler de control. 1 es mostrarà a la part superior, 2 després de 1, etc.',
    'tt_db_column_width'                              => 'Els ginys del tauler de control utilitzen el sistema de quadrícula Bootstrap i tenen una amplada màxima de columna de 12. Si estableix l\'amplada de la columna a 12, el giny utilitzarà tota l\'amplada disponible. Si l\'estableixes a 6, dos ginys compartiran la mateixa fila, 4 permetrà que 3 ginys comparteixin la mateixa fila, etc.',
    'tt_db_accumulate_totals'                         => 'Si activeu aquest valor, el vostre gràfic inclourà els totals dels dies anteriors de cada dia. Per exemple, les vendes del dia 1 van ser de 100 $, el dia 2 van ser de 50 $ i el dia 3 van ser de 125 $. El gràfic mostraria una línia ascendent amb aquesta opció establerta en Sí. Estableix a No, mostraria una caiguda a la línia de vendes el dia 2 i augmentaria fins al dia 3.',
    'tt_db_kpi_cards'                                 => 'Aquestes targetes amb codi de colors mostren indicadors clau de rendiment a la part superior del tauler.',
    'tt_db_sales_chart'                               => 'Un gràfic de línies, que mostra els totals de la factura i el pagament.',
    'tt_db_task_list'                                 => 'Aquest giny us permet treballar amb el mòdul Llista de tasques, directament des del vostre tauler.',
    'tt_db_task_list_include_time'                    => 'Activar aquesta opció us permet especificar la data i l\'hora de les dates de venciment quan treballeu amb tasques. Quan s\'estableix a No, només s\'utilitza el valor de la data.',
    'tt_db_timeline'                                  => 'El giny de la línia de temps mostra una llista cronològica i cercable d\'esdeveniments importants del sistema, com ara canvis d\'estat del client, factures enviades per correu electrònic, pagaments fets, notes preses, etc.',
    'tt_ss_invoices_default_invoice_template'         => 'Seleccioneu la plantilla que s\'utilitzarà, per defecte, a l\'hora de crear noves factures. Les plantilles personalitzades s\'han de col·locar a .custom emplatesinvoice_templates i s\'han d\'anomenar amb una extensió .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Seleccioneu l\'esquema de números de document que s\'utilitzarà, de manera predeterminada, en crear noves factures. Els esquemes de números de documents es poden crear a la configuració de configuració i us permeten personalitzar els vostres números de documents (factures, pressupostos, notes de crèdit).',
    'tt_ss_invoices_invoice_due_days'                 => 'El nombre predeterminat de dies, després de la data de creació (creació) de la factura, en què la factura vencerà i s\'espera que es pagui.',
    'tt_ss_invoices_automatic_email_ri'               => 'Quan s\'executa una factura recurrent i genera una factura en directe, s\'hauria d\'enviar automàticament aquesta factura al client per correu electrònic?',
    'tt_ss_invoices_qr_code'                          => 'Si un codi QR es col·loca automàticament a les factures i pressupostos predeterminats. Si utilitzeu plantilles personalitzades de factura o pressupost, consulteu les plantilles predeterminades per afegir el codi QR a les vostres plantilles personalitzades.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Si una factura està en estat d\'esborrany i s\'envia per correu electrònic, ja sigui manualment o automàticament, què hauria de passar amb la data de la factura. Nota important: quan s\'envia una factura per correu electrònic, l\'estat es canviarà automàticament d\'Esborrany a Enviat.',
    'tt_ss_invoices_recalculate'                      => 'Executa totes les transaccions realitzades per a cada factura, des de la data de creació fins a la data actual, i torna a calcular els totals, els totals de les línies de comanda, els impostos, els descomptes i els totals de la factura. Això pot trigar molt a executar-se si teniu un conjunt de dades gran.',
    'tt_ss_invoices_due_after'                        => 'La data de venciment de la factura serà la data de la factura més el nombre de dies introduït aquí.',
    'tt_ss_invoices_default_status_filter'            => 'El filtre d\'estat que s\'ha d\'aplicar, per defecte, en visualitzar la llista de factures.',
    'tt_ss_invoices_default_terms'                    => 'El valor de text dels termes que es mostra, a la plantilla de factura predeterminada, a l\'àrea inferior de la factura, dins de l\'àrea de Termes i condicions.',
    'tt_ss_invoices_default_footer'                   => 'Valor de text del peu de pàgina que es mostra, a la plantilla de factura predeterminada, a la part inferior de la factura. Per exemple: "Gràcies pel teu negoci"',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Quan l\'executor de tasques diàries (treball CRON) executa i genera una factura en directe a partir d\'una plantilla de factura recurrent, s\'hauria d\'enviar automàticament per correu electrònic al client aquesta factura recent creada? Això es pot anul·lar client per client.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Quan es realitza un pagament, aquesta informació de pagament s\'ha d\'enviar automàticament per correu electrònic al client?',
    'tt_ss_invoices_online_payment_method'            => 'La forma de pagament que s\'assigna quan un client paga mitjançant un enllaç de factura pública. Els mètodes de pagament es poden mantenir mitjançant la configuració del sistema.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'S\'ha de mostrar al document un codi QR, que direcciona a l\'URL públic de la factura o del pressupost?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Els usuaris, fins i tot els administradors, haurien de poder eliminar factures? Una alternativa més segura i traçable a l\'eliminació de factures és canviar l\'estat de la factura a "Cancel·lada", cosa que canvia el total de la factura a zero i l\'exclou de la majoria de llistes i informes.',
    'tt_ss_invoices_show_invoices_from'               => 'Quan les factures s\'enviïn per correu electrònic, es mostrarà com a adreça enviada per correu. Nota important: el valor Respon a sempre serà el valor assignat al camp Configuració del sistema -> Correu electrònic -> Adreça de resposta.',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Des de la visualització de la factura, si la factura es troba en estat d\'esborrany i s\'envia per correu electrònic, la data de la factura hauria de romandre sense canvis o canviar a la data actual? Si canvia la data de la factura, també s\'actualitza la data de venciment.',
    'tt_ss_quotes_default_quote_template'             => 'Seleccioneu la plantilla que s\'utilitzarà, de manera predeterminada, en crear un pressupost nou. Les plantilles personalitzades s\'han de col·locar a .custom emplatesquote_templates i s\'han de nomenar amb una extensió .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Seleccioneu l\'esquema de números de document que s\'utilitzarà, de manera predeterminada, en crear pressupostos nous. Els esquemes de números de documents es poden crear a la configuració de configuració i us permeten personalitzar els vostres números de documents (factures, pressupostos, notes de crèdit).',
    'tt_ss_quotes_expire_days'                        => 'El nombre predeterminat de dies, després de la data de creació (creació) del pressupost, que caducarà el pressupost. Quan una cotització ha superat la data de caducitat, s\'entén que el preu pot canviar a causa de les fluctuacions del mercat, etc.',
    'tt_ss_quotes_default_status_filter'              => 'El filtre d\'estat que s\'ha d\'aplicar, per defecte, en visualitzar la llista de factures.',
    'tt_ss_quotes_auto_convert'                       => 'Quan s\'aprova un pressupost, si això provoca que es creï automàticament una factura a partir del pressupost.',
    'tt_ss_quotes_when_converted_action'              => 'Quan un pressupost es converteix en una factura, s\'han d\'utilitzar les condicions de pagament del pressupost o de la configuració predeterminada de les condicions de la factura?',
    'tt_ss_quotes_default_terms'                      => 'El valor de text dels termes que es mostra, a la plantilla de pressupost predeterminada, a la part inferior de la cotització, dins de l\'àrea de Termes i condicions.',
    'tt_ss_quotes_default_footer'                     => 'Valor de text del peu de pàgina que es mostra, a la plantilla de pressupost per defecte, a la part inferior de la cita. Per exemple: "Esperem treballar amb vosaltres!"',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Si un pressupost es troba en estat d\'esborrany i s\'envia per correu electrònic, ja sigui manualment o automàticament, què hauria de passar amb la data del pressupost. Nota important: quan s\'enviï un pressupost per correu electrònic, l\'estat es canviarà automàticament d\'Esborrany a Enviat.',
    'tt_ss_quotes_recalculate'                        => 'Executa totes les transaccions realitzades per a cada pressupost, des de la data de creació fins a la data actual, i torna a calcular els totals, els totals de les línies de comanda, els impostos, els descomptes i els totals de la cotització. Això pot trigar molt a executar-se si teniu un conjunt de dades gran.',
    'tt_ss_taxes_default_rate1'                       => 'El tipus impositiu principal que s\'ha d\'aplicar automàticament a les línies de comanda noves afegides a les factures o als pressupostos. Els tipus impositius es mantenen mitjançant Configuració -> Taxes.',
    'tt_ss_taxes_default_rate2'                       => 'El tipus impositiu secundari que s\'ha d\'aplicar automàticament a les línies de comanda noves afegides a les factures o pressupostos. Els tipus impositius es mantenen mitjançant Configuració -> Taxes. Nota: a Configuració del sistema -> General, podeu seleccionar mostrar 1 o 2 camps d\'impostos a les factures i pressupostos.',
    'tt_ss_email_send_method'                         => 'El mètode d\'enviament de correu electrònic que hauria d\'utilitzar FusionInvoice. Canviar el mètode d\'enviament també canvia la visualització dels camps de suport per al mètode d\'enviament.',
    'tt_ss_email_allow_self_cert'                     => 'Si activeu aquesta opció, es desactiva el requisit PHP verify_peer. Per obtenir més informació, cerqueu a Internet: certificat de correu electrònic PHP autofirmat openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Quan envieu correus electrònics, aquesta és l\'adreça de resposta predeterminada que veuran els vostres destinataris.',
    'tt_ss_email_always_cc'                           => 'Una adreça de correu electrònic que, per defecte, voldríeu CC automàticament amb cada correu electrònic enviat.',
    'tt_ss_email_always_bcc'                          => 'Una adreça de correu electrònic que, per defecte, voldríeu CCO automàticament amb cada correu electrònic enviat.',
    'tt_ss_email_send_test_to'                        => 'L\'adreça de correu electrònic que s\'utilitzarà en fer clic al botó Envia un correu electrònic de prova.',
    'tt_ss_email_mail_from_addr'                      => 'L\'adreça de correu de correu predeterminada que s\'utilitzarà quan s\'enviïn correus electrònics des de FusionInvoice. Nota: a Configuració del sistema -> Factures, podeu seleccionar que els correus electrònics de les factures s\'enviïn des d\'aquesta adreça (del sistema) o des de l\'usuari que ha creat la factura.',
    'tt_ss_email_mail_from_name'                      => 'El nom amigable de Mail From que es mostrarà als correus electrònics enviats.',
    'tt_ss_email_email_templates'                     => 'Les plantilles de correu electrònic estan disponibles per a molts documents i esdeveniments, com ara: pressupostos, aprovacions de pressupostos, rebuigs de pressupostos, factures, factures vençudes, notes de crèdit, rebuts de pagament, avisos de pagament propers. S\'inclou una plantilla predeterminada, però també podeu crear plantilles personalitzades, que poden ser senzilles (com les plantilles predeterminades proporcionades) o HTML amb format complet.',
    'tt_ss_pdf_driver'                                => 'El controlador que cal utilitzar per crear documents PDF. La selecció del controlador "wkhtmltopdf" requereix la instal·lació d\'un servidor local d\'aquest programa i la configuració del camí binari adequat per a ell.',
    'tt_ss_pdf_binary_path'                           => 'La ruta del servidor local al fitxer binari per a wkhtmltopdf. Per exemple, C :\wkhtmltopdf\bin\wkhtmltopdf .exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice admet diversos proveïdors de pagament en línia. Habiliteu els proveïdors amb els quals heu establert comptes. Els proveïdors activats aquí es mostraran com a opcions de pagament quan els vostres clients vegin les seves factures mitjançant l\'enllaç de factura pública (inclòs al correu electrònic de factura predeterminat).',
    'tt_ss_olp_api_key'                               => 'El vostre proveïdor de pagaments us proporciona la clau API.',
    'tt_ss_olp_payment_button_text'                   => 'El text que es mostra al botó del mètode de pagament d\'aquest proveïdor de pagament, a la part superior de la factura pública, tal com el veuen els vostres clients.',
    'tt_ss_olp_mode'                                  => 'Admesos per alguns proveïdors de pagament, permetent més Sandbox (prova) i en directe.',
    'tt_ss_olp_client_id'                             => 'Aquest proveïdor de pagament us proporciona l\'identificador de client.',
    'tt_ss_olp_client_secret'                         => 'Aquest proveïdor de pagament us proporciona el secret del client.',
    'tt_ss_olp_publishable_key'                       => 'Aquest proveïdor de pagament us proporciona la clau publicable.',
    'tt_ss_olp_secret_key'                            => 'Aquest proveïdor de pagament us proporciona la clau secreta.',
    'tt_ss_olp_opp_fees_about'                        => 'Les tarifes de processament de pagaments en línia es poden avaluar per als clients que paguen amb targeta de crèdit, mitjançant l\'enllaç de la factura pública (inclòs al correu electrònic de la factura).',
    'tt_ss_olp_enable_opp_fees'                       => 'Les tarifes de processament de pagaments en línia es poden avaluar per als clients que paguen amb targeta de crèdit, mitjançant l\'enllaç de la factura pública (inclòs al correu electrònic de la factura). Aquesta opció té una configuració global del sistema, però també es pot substituir per a un client individual.',
    'tt_ss_olp_opp_fee_pct'                           => 'El percentatge del total de la factura que s\'ha de cobrar com a tarifa de processament de pagament en línia (conveniència).',
    'tt_ss_olp_opp_fee_name'                          => 'El nom de la tarifa que es mostrarà a la factura. És a dir. "Comissió de conveniència de targeta de crèdit".',
    'tt_ss_olp_opp_fee_explanation'                   => 'Una explicació de la tarifa que es mostrarà a la factura. És a dir. "Es cobra una comissió del 3% per a totes les transaccions amb targeta de crèdit"',
    'tt_company_profiles_about'                       => 'Els perfils d\'empresa us permeten presentar el vostre negoci de manera diferent amb cada perfil, permetent diferents noms d\'empresa, logotips, formats de factura, etc. Proporciona una manera de tenir diverses empreses virtuals dins de la mateixa instal·lació de FusionInvoice. S\'ha de seleccionar un perfil d\'empresa predeterminat a la configuració del sistema.',
    'tt_users_about'                                  => 'Podeu crear usuaris del tipus Admin (accés complet) o Estàndard (s\'han de concedir permisos individuals del sistema). Si configureu "Permetre l\'inici de sessió al centre de clients" com a Sí per a un registre de client, s\'afegirà automàticament un registre d\'usuari per al client, però, només es poden afegir usuaris de client mitjançant la interfície de configuració del client.',
    'tt_users_client_about'                           => 'Els usuaris del client només poden iniciar sessió al Centre de clients, cosa que els permet una visió limitada de les seves factures, pressupostos i pagaments. Si configureu l\'opció "Permetre l\'inici de sessió al centre de clients" com a Sí per a un registre de client, els permetrà accedir al centre de clients.',
    'tt_user_types_about'                             => 'Els usuaris administradors tenen accés complet al sistema. Els usuaris estàndard poden rebre els permisos individuals que necessiten. Els usuaris del client només tenen accés a la seva informació específica al Centre de clients i la seva capacitat d\'iniciar sessió es defineix a Configuració del client -> "Permet l\'inici de sessió al Centre de clients"',
    'tt_custom_fields_about'                          => 'Els camps personalitzats us permeten afegir els vostres propis camps de dades a la majoria de mòduls. Si necessiteu capturar la indústria per als clients, només cal que afegiu un camp personalitzat amb l\'etiqueta "Indústria" a la pàgina Clients, convertint-lo en un tipus desplegable. Els camps personalitzats es mostren automàticament a sota dels camps normals.',
    'tt_recurring_invoices_about'                     => 'Les factures recurrents no són en realitat factures, sinó plantilles per crear factures futures. Tenen una freqüència de recurrència i una data següent que determinen quan generaran una factura en directe. Es requereix un treball CRON diari o una tasca programada perquè les factures recurrents funcionin correctament.',
    'tt_addons_about'                                 => 'Els complements són personalitzacions de FusionInvoice per a necessitats empresarials úniques, com ara el seguiment del temps, furmules de preus o plantilles de factura sylized. S\'ofereixen a través del mercat de complements FusionInvoice.',
    'client_center_user'                              => 'Usuari del centre de clients',
    'user_type'                                       => 'Tipus d\'usuari',
    'custom_field'                                    => 'Camp personalitzat',
    'placeholder_type_email_template'                 => 'Escriviu o enganxeu la vostra plantilla de correu electrònic. . .',
    'email_templates'                                 => 'Plantilles de correu electrònic',
    'payment_receipts'                                => 'Rebuts de pagament',
    'upcoming_payment_notices'                        => 'Pròxims avisos de pagament',
    'convenience_fee_for_credit_card_transactions'    => 'Comissió de conveniència per a transaccions amb targeta de crèdit',
    'credit_card_processing_fee'                      => 'Comissió de processament de targeta de crèdit',
    'delete_client_user_warning'                      => '<p>El fet de suprimir un usuari client desactivarà la seva capacitat d\'iniciar sessió al centre de clients.</p>',
    'use_default_mail_template'                       => 'Plantilla de correu predeterminada',
    'use_custom_mail_template'                        => 'Plantilla de correu personalitzada',
    'quote_email_body'                                => 'Cotització del correu electrònic',
    'overdue_invoice_email_body'                      => 'Cos del correu electrònic de la factura vençuda',
    'credit_memo_email_body'                          => 'Cos del correu electrònic de la nota de crèdit',
    'payment_receipt_body'                            => 'Cos del rebut de pagament',
    'invoice_email_body'                              => 'Cos del correu electrònic de la factura',
    'quote_custom_email_body_require'                 => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de pressupost',
    'quote_custom_approve_email_body_require'         => 'Introduïu la vostra plantilla de correu electrònic personalitzada per a l\'aprovació de pressupostos',
    'quote_reject_email_body_require'                 => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de rebuig del pressupost',
    'overdue_invoice_email_body_require'              => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de la factura vençuda',
    'invoice_email_body_require'                      => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de la factura',
    'credit_memo_email_body_require'                  => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de la nota de crèdit',
    'payment_receipt_email_body_require'              => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic del rebut de pagament',
    'upcoming_payment_notice_email_body_require'      => 'Introduïu la vostra plantilla de correu electrònic personalitzada per al cos del correu electrònic de l\'avís de pagament proper',
    'copy_text'                                       => 'Copia el text',
    'tt_preview_template'                             => 'Plantilla de vista prèvia',
    'tt_view_template_code'                           => 'Veure codi de plantilla',
    'dashboard_date_range'                            => 'Interval de dates del tauler',
    'tt_dashboard_date_range'                         => 'L\'interval de dates del tauler filtra la visualització dels ginys següents: targetes KPI, gràfic de vendes, activitat recent del client.',
    'product_copy'                                    => 'Còpia del producte',
    'open_selected_client'                            => 'Obriu el client seleccionat',
    'save_this_client'                                => 'Desa aquest client (no un duplicat)',
    'looks_like_duplicate'                            => 'Hmm... Això sembla un duplicat',
    'duplicate_instructions'                          => 'Si veieu el client que voleu a la llista, seleccioneu-lo i obriu-lo. Si no, deseu el client nou.',
    'select_checkbox'                                 => 'Seleccioneu un client',
    'select_lead_source_tag'                          => 'Seleccioneu la font del client potencial',
    'lead_source'                                     => 'Font principal',
    'tt_client_lead_source_tags'                      => 'Seleccioneu o introduïu la font del client potencial (com es va adquirir el client)',
    'your_link_is_expired'                            => 'Vaja! El teu enllaç ha caducat.',
    'page_expire_return_to_dashboard'                 => 'No hem trobat la pàgina que estaves buscant. <a href=":dashboard_link">Torna~ al tauler</a>.',
    'secure_link_and_expire_link_days'                => 'Enllaços de factures públiques segures i caducades',
    'secure_link_expire_days'                         => 'Nombre de dies',
    'tt_secure_link_and_expire_link_days'             => 'Quan habiliteu els enllaços segurs, també heu d\'establir el nombre de dies després dels quals caducarà l\'enllaç de la factura. En fer això, un client pot veure el seu enllaç de factura pública fins que caduqui.',
    'expire_time_period'                              => 'El camp Nombre de dies de caducitat de l\'enllaç és obligatori',
    'enter_days'                                      => 'Introduïu els dies',
    'invalid_field_name'                              => 'Introduïu un nom de camp vàlid',
    'lead_source_notes'                               => 'Notes de fonts principals',
    'important_note'                                  => 'Nota important',
    'social_media_url'                                => 'URL de xarxes socials',
    'general_notes'                                   => 'Notes generals',
    'payment_amount_mismatch'                         => 'L\'import del pagament no coincideix',
    'open_invoice_aging'                              => 'Envelliment de la factura oberta',
    'tt_db_open_invoice_aging'                        => 'Envelliment de la factura oberta',
    'current'                                         => 'Actual',
    'oneToThirty'                                     => '1-30 dies',
    'thirtyOneToSixty'                                => '31-60 dies',
    'sixtyOneToNinety'                                => '61-90 dies',
    'ninetyOnePlus'                                   => 'Més de 91 dies',
    'sent_and_draft'                                  => 'Inclou les factures enviades i esborranys',
    'sent_only'                                       => 'Inclou només les factures enviades',
    'tt_open_ar_aging_settings'                       => 'Configuració dels totals d\'antiguitat de la factura oberta',
    'tt_client_field_settings'                        => 'Seleccioneu els camps que voleu que es mostrin a la vista de client',
    'position_change'                                 => 'La posició ha canviat',
    'dynamic_width'                                   => 'Amplada dinàmica',
    'full_width'                                      => 'Ample total',
    'save_configuration_default'                      => 'Desa la configuració com a predeterminada del sistema',
    'assign_configuration_other'                      => 'Assigna la configuració a altres usuaris',
    'tt_user_tags'                                    => 'Etiquetes d\'usuari',
    'select_users'                                    => 'Seleccioneu Usuaris',
    'configuration_assigned'                          => 'Configuració assignada correctament',
    'default_configuration_set'                       => 'La configuració predeterminada s\'ha establert correctament',
    'current_user_id'                                 => 'Identificador d\'usuari actual',
    'tt_users_settings'                               => 'Configuració dels usuaris',
    'invoice_link_expire'                             => 'L\'enllaç públic de la factura caducarà d\'aquí a <strong>:days</strong> dies',
    'quote_link_expire'                               => 'El vostre enllaç públic de pressupost caducarà d\'aquí a <strong>:days</strong> dies',
    'dashboard_width'                                 => 'S\'ha canviat la configuració d\'amplada de columna :widthName del tauler',
    'unmark_mailed'                                   => 'Desmarca com a enviat per correu',
    'invoice_unmark_mailed'                           => 'Desmarca la factura com a enviada per correu',
    'print_mark_mailed'                               => 'Imprimeix i marca com a enviat per correu',
    'public_link'                                     => 'Enllaç públic',
    'tt_sales_chart_settings'                         => 'Configuració per a la factura/total del gràfic de vendes',
    'verify_key'                                      => 'Verificació de la clau del producte',
    'enter_key'                                       => 'Introduïu la vostra clau',
    'verify'                                          => 'Verifica-ho!',
    'key_required'                                    => 'La clau de producte és necessària',
    'key_length_invalid'                              => 'Introduïu la clau de producte de 32 caràcters proporcionada en el moment de la compra.',
    'invalid_key'                                     => 'Ho sentim, la teva clau no és vàlida. La instal·lació no pot continuar.',
    'key_verified'                                    => 'Enhorabona, la teva clau s\'ha verificat.',
    'clear_cache'                                     => 'Netejar memòria cau',
    'clear_cache_confirm'                             => 'Esteu segur que voleu esborrar la memòria cau de l\'aplicació?',
    'cache_clear_success'                             => 'La memòria cau s\'ha esborrat correctament.',
    'cache_clear_error'                               => 'Si us plau, comproveu la configuració del vostre servidor per a l\'ordre PHP exec().',
    'add_new_client'                                  => 'Afegeix un client nou',
    'add'                                             => 'Afegeix',
    'invalid_quantity_amount'                         => 'Quantitat no vàlida! Ha de ser superior a 0.',
    'api_version'                                     => 'Versió de l\'API',
    '2021_prior'                                      => '2021 i Prior',
    '2022_later'                                      => '2022 i posteriors',
    'vendors'                                         => 'Venedors',
    'file_not_found'                                  => ':file_name no s\'ha trobat',
    'leave_empty_no_parent_account'                   => 'deixar buit si el client no té cap compte principal',
    'leave_empty_client_pays_invoices'                => 'deixar buit si el client paga les seves pròpies factures',
    'modal_not_found'                                 => 'No s\'ha trobat el modal',
    'payment_delete_success'                          => 'El pagament s\'ha suprimit correctament',
    'payment_delete_error'                            => 'S\'ha produït un problema en suprimir el pagament. Torneu-ho a provar més tard.',
    'status_change_error'                             => 'Alguna cosa ha anat malament! L\'estat no s\'ha canviat.',
    'total_payments'                                  => 'Pagaments totals',
    'licence_verification_error'                      => 'No es pot verificar la vostra clau de llicència.',
    'line_item_discount_limit'                        => 'Les línies de comanda no poden tenir un descompte superior al 99,99%.',
    'date_range_report'                               => 'Interval de dates (propera data a executar)',
    'no_client_found'                                 => 'Hmmm... no hem pogut trobar aquest client.',
    'tt_line_item_discount'                           => 'Un descompte d\'elements de línia es pot calcular mitjançant un percentatge del preu o un import fix per al preu de l\'article individual.',
    'functionality_not_available_on_demo'             => 'Ho sentim, aquesta funció no està permesa a la demostració.',
    'vat_tax_id'                                      => 'ID IVA',
    'tt_vat_tax_id'                                   => 'Número d\'impost sobre el valor afegit (IVA).',
    'enable_vat_tax_id'                               => 'Activa el número d\'IVA',
    'no-attachment'                                   => 'No hi ha cap adjunt',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Netejar',
    'allow_edit_status_invoice'                       => 'Edita :status Factura',
    'tt_ss_allow_edit_invoices_status'                => 'Com a mesura de seguretat, només es poden editar les factures en estat d\'esborrany. Podeu anul·lar-ho si permet l\'edició de factures enviades i/o pagades.',
    'allow_edit_invoices_status'                      => 'Permetre l\'edició de les factures en estat',
    'draft_and_sent'                                  => 'Esborrany i enviat',
    'draft_or_sent_and_paid'                          => 'Esborrany, enviat i pagat',
    'invoice_editable'                                => 'Factura editable',
    'can_not_edit_paid_invoice'                       => 'No podeu editar una factura pagada',
    'item_category'                                   => 'Categoria d\'article',
    'itemLookups'                                     => 'Cerques d\'elements',
    'quoteItems'                                      => 'Cotitzar articles',
    'invoiceItems'                                    => 'Elements de la factura',
    'imports_disabled_in_demo.'                       => 'Les importacions estan desactivades a la demostració.',
    'no_file_selected'                                => 'No s\'ha seleccionat cap fitxer',
    'no_import_records'                               => 'No s\'han trobat registres per importar',
    'vendor_name'                                     => 'Nom del venedor',
    'license_key'                                     => 'Clau de llicència',
    'change_license_key'                              => 'Canviar la clau de llicència',
    'verify_and_save'                                 => 'Verifica i desa',
    'same_key_error'                                  => 'No s\'ha detectat cap canvi. Si us plau, prova amb una clau diferent',
    'trying_invalid_key'                              => 'Ho sentim, aquesta clau no s\'ha pogut verificar. La clau de llicència no s\'ha canviat.',
    'key_updated'                                     => 'Felicitats! La vostra clau de llicència s\'ha actualitzat correctament.',
    'invalid_date_format'                             => 'Format de data no vàlid. Format obligatori: AAAA-MM-DD',
    'invalid_datetime_format'                         => 'Format de data i hora no vàlid. Format obligatori: AAAA-MM-DD HH:MM :SS',
    'profile_setting'                                 => 'Configuració del perfil',
    'include_draft_invoices_unpaid_and_overdue'       => 'Incloeu els esborranys de factures a les llistes impagades i vençudes',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Si s\'estableix en Sí, les factures amb l\'estat d\'Esborrany s\'inclouran a les llistes i càlculs per a les factures vençudes i impagades.',
    'tt_utilities_import'                             => 'Importeu dades dels fitxers CSV a la vostra base de dades de FusionInvoice.',
    'tt_utilities_export'                             => 'Exporteu les dades de la vostra base de dades de FusionInvoice a diversos formats diferents: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Consulteu el fitxer de registre que conté tots els esdeveniments de correu electrònic dins de FusionInvoice.',
    'tt_utilities_system_log'                         => 'Consulteu el fitxer de registre del sistema que conté errors i esdeveniments del sistema d\'avís.',
    'tt_utilities_tag_cleanup'                        => 'Elimina les etiquetes definides però no utilitzades. També elimina les etiquetes duplicades.',
    'tt_utilities_pdf_cleanup'                        => 'Elimina els fitxers PDF temporals.',
    'tt_utilities_recalc_invoices'                    => 'Explora cada factura, assegurant-se que els totals coincideixen amb la suma de totes les línies, tenint en compte els descomptes i els impostos. *Això pot trigar molt de temps.',
    'tt_utilities_recalc_quotes'                      => 'Explora cada pressupost, assegurant-se que els totals coincideixen amb la suma de totes les línies, tenint en compte els descomptes i els impostos. *Això pot trigar molt de temps.',
    'tt_utilities_clear_cache'                        => 'Elimina els fitxers de memòria cau temporals.',
    'tt_utilities_download_database'                  => 'Baixeu un fitxer de base de dades exportat de les vostres dades de FusionInvoice en directe. Com més gran sigui la base de dades, més temps trigarà.',
    'tt_utilities_run_daily_tasks'                    => 'Una tasca CRON o una tasca programada normalment executa les vostres tasques diàries. Això us permet fer-ho manualment. Genera factures en directe a partir de plantilles de factures recurrents, envia recordatoris de pagament, etc.',
    'include_line_item_detail'                        => 'Inclou els detalls de la línia de comanda',
    'invoice_tags'                                    => 'Etiquetes de factura',
    'related_accounts'                                => 'Comptes relacionats',
    'not_found_related_clients'                       => 'No s\'ha assignat cap compte de client relacionat',
    'invoices_paid_for_list'                          => 'Aquest compte de client paga les factures',
    'child_accounts_exist'                            => 'La configuració de Permet comptes infantils ha tornat a Sí. No es pot canviar a No quan existeixen comptes secundaris.',
    'third_bp_accounts_exist'                         => 'La configuració del pagador de factures de tercers ha tornat a Sí. No es pot canviar a No quan existeixen comptes relacionats.',
    'tag_name'                                        => 'Nom de l\'etiqueta',
    'tag_new_name'                                    => 'Nom de l\'etiqueta nou',
    'tag_category'                                    => 'Categoria d\'etiquetes',
    'rename_tags'                                     => 'Canvia el nom de les etiquetes',
    'apply'                                           => 'Aplicar',
    'select_tag_category'                             => 'Seleccioneu la categoria d\'etiquetes',
    'tt_utilities_rename_tags'                        => 'Canviar el nom de les etiquetes assignades als clients, notes, activitats de vendes, etc.',
    'system_default_dashboard'                        => 'Tauler de control predeterminat del sistema',
    'user_specific_dashboards'                        => 'Taulers de control específics per a l\'usuari',
    'tt_default_client_type'                          => 'Tipus de client predeterminat',
    'default_client_type'                             => 'Tipus de client predeterminat',
    'invalid_user'                                    => 'Seleccioneu un usuari vàlid.',
    'create_live_invoice'                             => 'Crea una factura en directe',
    'create_live_invoice_successfully'                => 'S\'ha creat la factura actual <strong>:number</strong>',
    'create_live_invoice_unsuccessfully'              => 'No s\'ha creat la factura en directe',
    'live_invoice_not_generate'                       => 'No es pot generar una factura en directe a partir d\'una factura recurrent que tingui una data de finalització d\'avui o anterior, o una data següent de més de 30 dies en el futur.',
    'data_seeder'                                     => 'Sembradora de dades',
    'select_module'                                   => 'Seleccioneu Mòdul',
    'number_of_seed'                                  => 'Nombre de llavors',
    'seed_it'                                         => 'Sembra-ho!',
    'seeds_success'                                   => 'Les llavors s\'han afegit correctament',
    'tt_ri_generate_the_next_live_invoice'            => 'Genereu la següent factura actual per a aquesta factura recurrent ara mateix.',
    'system_log_clear_message'                        => 'Esteu segur que voleu esborrar el registre del sistema? Aquesta acció no es pot desfer i tots els registres anteriors se suprimiran permanentment.',
    'system_log_clear_successfully'                   => 'El registre del sistema s\'ha esborrat correctament',
    'payment_problem'                                 => 'S\'ha produït un problema durant el pagament. Siusplau, intenta-ho més tard.',
    'log_detail'                                      => 'Feu clic aquí per veure el registre detallat.',
    'log_limit_message'                               => 'Fitxer de registre > :size M, descarregueu-lo.',
    'log_download_file'                               => 'Descarrega l\'arxiu',
    'log_delete_all'                                  => 'Suprimeix tots els fitxers',
    'log_level'                                       => 'Nivell',
    'log_context'                                     => 'Context',
    'log_date'                                        => 'Data',
    'log_line_number'                                 => 'Número de línia',
    'log_content'                                     => 'Contingut',
    'addon_install_error'                             => 'Hi ha hagut un problema amb la instal·lació de complements. Torneu-ho a provar més tard.',
    'addon_installed_success'                         => 'El complement s\'ha instal·lat correctament.',
    'allow_edit_status_credit_memo'                   => 'Edita la nota de crèdit aplicada',
    'database_seeder'                                 => 'Sembradora',
    'tt_utilities_database_seeder'                    => 'Introduïu la vostra base de dades amb dades de prova mitjançant classes de llavors',
    'vat_information'                                 => 'Informació sobre l\'IVA',
    'tt_vat_information'                              => 'Número de compte bancari IBAN, BIC, correu electrònic, etc...',
    'explore_addons'                                  => 'Exploreu els complements',
    'available_addons'                                => 'Complements de FusionInvoice disponibles',
    'addon_success'                                   => 'El complement s\'ha afegit correctament.',
    'payment_cannot_enabled_in_demo'                  => 'Les passarel·les de pagament no es poden habilitar a la demostració',
    'confirm_approve_leave_page'                      => 'Hi ha canvis no desats en aquesta pàgina! Estàs segur que vols marxar sense desar?',
    'leave'                                           => 'marxar',
    'demo_date_refresh'                               => 'Les dades de demostració s\'actualitzaran',
    'minutes'                                         => 'minuts',
    'minute'                                          => 'minut',
    'seconds'                                         => 'segons',
    'mautic-authentication-fail'                      => 'No teniu autorització per accedir a aquest recurs, feu servir una clau secreta vàlida.',
    'something_went_wrong'                            => 'Alguna cosa ha anat malament!',
    'month_to_date'                                   => 'Aquest mes fins ara',
    'quarter_to_date'                                 => 'Aquest trimestre fins avui',
    'year_to_date'                                    => 'Aquest any fins ara',
    'last_active'                                     => 'Últim actiu',
    'database_seeder_stop'                            => ':name PARADA DE LA SEEDORA EMPRESARIAL',
    'database_seeder_start'                           => ':name COMENÇA DE LA SEEDORA DE NEGOCIS',
    'seeder_records_created'                          => ':total Registres creats amb èxit per a :modal',
    'seeder_credit_apply_invoice'                     => 'Nota de crèdit s\'aplica a la factura',
    'seeder_quote_approve_reject'                     => 'Cita Aprovar i rebutjar',
    'seeder_executed'                                 => 'Sembradora executada amb èxit!',
    'seeder_not_executed'                             => 'La sembradora no va ser executada!',
    'db_to_file_system_attachments_migration'         => 'Migració de fitxers adjunts - Base de dades al sistema de fitxers',
    'attachment_content_count'                        => 'Esteu a punt de migrar un total de <strong style="color: #b22222 !important;">:number</strong> fitxers adjunts de la vostra base de dades al disc',
    'attachment_repeat_content_count'                 => 'Esteu a punt de migrar un total de <strong style="color: #b22222 !important;">:number1</strong> fitxers adjunts de la vostra base de dades al disc i <strong style="color: #42b602 !important;">:number2</strong> ja s\'han migrat correctament.',
    'attachment_key_invalid'                          => 'La clau del fitxer adjunt no és vàlida',
    'stop'                                            => 'Atura!',
    'attachment_migration_warning'                    => 'Aquest pas migrarà els fitxers adjunts de la vostra base de dades al vostre sistema de fitxers, feu una còpia de seguretat completa de la base de dades abans de continuar i assegureu-vos que teniu prou espai al disc per realitzar aquesta operació.',
    'attachment_agreement_accept'                     => 'He fet una còpia de seguretat de la meva base de dades.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Contrasenya de Microsoft 365',
    'office365_username'                              => 'Nom d\'usuari de Microsoft 365',
    'custom_date_formula_note1'                       => '<b><u>Marcadors de posició de valors predeterminats :</span></u></b> ~<br> Podeu utilitzar <b>avui, demà i ahir</b> qualsevol valor per defecte.<br>',
    'custom_date_formula_note2'                       => '<b>Per a avui + N dies, utilitzeu </b> "predeterminat": "+7" Això afegeix 7 dies a la data d\'avui <br><b>Per a avui - N dies, utilitzeu </b> "predeterminat": \'-7\' Això restarà 7 dies a la data d\'avui <br>',
    'mail_config_error'                               => 'No es pot enviar un correu electrònic de prova sense el Mètode d\'enviament de correu electrònic definit.',
    'db_prefix_alert'                                 => 'Hem observat que esteu utilitzant un prefix de base de dades de :prefix . FusionInvoice no admetrà prefixos de bases de dades en futures versions. Si us plau, editeu la vostra base de dades i canvieu el nom de totes les vostres taules, eliminant el prefix, després editeu el fitxer database.php i configureu el valor del "prefix" com a buit.',
    'db_prefix_alert_title'                           => 'Suport per a prefixos de base de dades que finalitzarà aviat',
    'add_title_bar_shortcut'                          => 'Afegeix una drecera a la barra de títol',
    'title_bar_shortcuts'                             => 'Dreceres de la barra de títol',
    'select_icon'                                     => 'Seleccioneu la icona',
    'all_payment_method'                              => 'Tot el mètode de pagament',
    'about'                                           => 'Sobre',
    'own_license'                                     => 'Llicència pròpia',
    'tt_own_license'                                  => 'Llicència pròpia',
    'git_branch'                                      => 'Branca actual de Git',
    'quote_email'                                     => 'Correu electrònic de cotització',
    'custom1'                                         => 'Personalitzat 1',
    'custom2'                                         => 'Personalitzat 2',
    'custom3'                                         => 'Personalitzat 3',
    'default_document_template'                       => 'Plantilla de document predeterminada',
    'default_email_template'                          => 'Plantilla de correu electrònic predeterminada',
    'sms'                                             => 'Sms',
    'pricing_formula'                                 => 'Fórmula de preus',
    'is_mobile'                                       => 'És mòbil?',
    'default_sms_template'                            => 'Plantilla d\'SMS predeterminada',
    'sms_log'                                         => 'Registre de SMS',
    'two_factor_auth'                                 => 'Autenticació de dos factors',
    'enabled_mail_driver'                             => 'Activa el servei de correu electrònic',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Codi de verificació no vàlid',
    'otp-subject'                                     => 'Inicieu sessió OTP',
    'resend_otp_success'                              => 'Codi de verificació enviat',
    'resend_otp_btn'                                  => 'Codi de reenviament',
    'expired_otp'                                     => 'Codi de verificació caducat',
    'token_expired'                                   => 'El vostre testimoni CSRF ha caducat',
    'verification_code'                               => 'Codi de verificació',
    'migration'                                       => 'Migració',
    'invoice_status_change_draft_to_sent'             => 'L\'estat de la factura ha canviat d\'esborrany a enviat',
    'default_sales_quantity'                          => 'Quantitat de vendes per defecte',
    'lead_time'                                       => 'Mitjana Temps de lliurament (dies)',
    'primary_vendor_id'                               => 'Venedor preferit',
    'all_items'                                       => 'Tots els articles',
    'non_inventory_items'                             => 'Articles no inventaris',
    'back_ordered'                                    => 'Tornar ordenat',
    'low_inventory'                                   => 'Inventari baix',
    'high_inventory'                                  => 'Inventari alt',
    'merge_client_records'                            => 'Combina els registres de clients',
    'primary_merge_to_client'                         => 'Unir-se a (conservar)',
    'surrogate_merge_from_client'                     => 'Fusionar de (descartar)',
    'merge'                                           => 'Fusionar',
    'merge_action'                                    => 'Acció de combinació',
    'ignore'                                          => 'Ignorar',
    'overwrite'                                       => 'Sobreescriure',
    'add_to'                                          => 'Afegir a',
    'select_merge_client'                             => 'Seleccioneu Per combinar',
    'client_to_and_from_not_same'                     => 'El client cap i el client des de han de ser diferents.',
    'client_id_required'                              => 'El camp de selecció del client ha de ser obligatori i únic.',
    'is_merge'                                        => 'Fusionar',
    'record_successfully_merged'                      => 'El registre s\'ha combinat correctament',
    'service_ends'                                    => 'Finalitza el servei',
    'service_starts'                                  => 'Inici del servei',
    'explanation'                                     => 'Explicació',
    'subscription_details'                            => 'Detalls de la subscripció',
    'generate_next_invoice'                           => 'Genereu la següent factura',
    'subscription'                                    => 'Subscripció',
    'of_the'                                          => 'Del',
    'on'                                              => 'Encès',
    'invoice_month'                                   => 'Mes de la factura',
    'invoice_year'                                    => 'Any de facturació',
    'next_month'                                      => 'El mes que ve',
    'next_year'                                       => 'L\'any que vé',
    'day'                                             => 'Dia',
    'last_date'                                       => 'Última data',
    'merge_record_warning'                            => 'Atura! La fusió de comptes de client no es pot desfer. A més dels camps que heu seleccionat per sobreescriure o afegir-hi, tot l\'historial de transaccions del client de fusió es transferirà al client de fusió. Esteu segur que voleu combinar aquests comptes de client?',
    'merge_child_account_warning'                     => 'El client Merge(From) té un compte principal amb comptes secundaris relacionats que es reassignaran al client Merge(To). Assegureu-vos que el client Merge(To) es permet com a compte principal.',
    'merge_parent_account_warning'                    => 'La fusió eliminarà la vostra associació amb el compte principal.',
    'merge_invoices_paid_by_warning'                  => 'La fusió eliminarà la vostra associació amb la factura principal pagada per.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'El nombre de relacions en el model de client ha canviat.',
    'payment_terms'                                   => 'Condicions de pagament',
    'net_amount_due_in'                               => 'Import net a pagar en',
    'net_amount_due_by'                               => 'Import net a pagar per',
    'if_paid_within'                                  => 'si es paga dins',
    'if_paid_by'                                      => 'si es paga per',
    'th_of_next_month'                                => 'dia del mes vinent',
    'of_next_month'                                   => 'del mes vinent',
    'down_payment'                                    => 'Dipòsit',
    'balance_amount_due_of'                           => 'import del saldo degut a',
    'payment_split_over'                              => 'Pagament fraccionat',
    'installments'                                    => 'quotes',
    'days_from_invoice_date'                          => 'dies des de la data de la factura',
    'payment'                                         => 'Pagament',
    'one'                                             => 'Un',
    'two'                                             => 'Dos',
    'three'                                           => 'Tres',
    'four'                                            => 'Quatre',
    'five'                                            => 'Cinc',
    'six'                                             => 'Sis',
    'discount_percent'                                => 'Percentatge de descompte',
    'discount_days_simple'                            => 'Dies de descompte Simple',
    'discount_days_nth'                               => 'Dies de descompte Nè',
    'net_due_days'                                    => 'Dies de venciment nets',
    'balance_due_days'                                => 'Saldo de dies de venciment',
    'number_of_installments'                          => 'Nombre de quotes',
    'payment_term'                                    => 'Termini de pagament',
    'select_payment_term'                             => 'Seleccioneu Termini de pagament',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'El camp Percentatge de pagament :index és obligatori i és superior a zero.',
        'installment_due_days_error'                  => 'Cal els dies de venciment :index presentats',
        'discount_percent_gt_error'                   => 'El percentatge de descompte presentat és obligatori i és superior a zero.',
        'discount_percent_lt_error'                   => 'El percentatge de descompte presentat és obligatori i menys del 100%.',
        'down_payment_percent_lt_error'               => 'Es requereix el percentatge de pagament inicial presentat i menys del 100%.',
        'discount_percent_numeric_error'              => 'El camp Percentatge de descompte ha de ser un valor numèric i inferior al 100%.',
        'down_payment_gt_error'                       => 'El pagament inicial presentat és obligatori i és superior a zero.',
        'discount_days_gt_net_days_error'             => 'L\'import net dels dies de venciment hauria de ser superior als dies de descompte.',
        'discount_days_nth_gt_net_days_error'         => 'L\'import net dels dies de venciment hauria de ser superior als dies nè de descompte.',
        'installment_due_days_gt_error'               => 'Els dies de venciment de la quota :index hauria de ser superior als dies de venciment de :preIndex.',
        'installment_percent_total_error'             => 'El percentatge total de la quota no és exacte. hauria de ser igual al 100%.',
        'installment_percent_numeric_error'           => 'El percentatge total de la quota no és exacte. Hauria de ser un valor numèric.',
        'term_discount'                               => 'Descompte de termini',
        'installment_due_days_gt_zero_error'          => 'Els dies de venciment de la quota :index hauria de ser superior o igual a zero.',
        'net_due_days_error'                          => 'L\'import net dels dies de venciment hauria de ser superior a zero i s\'hauria de presentar.',
        'discount_days_simple_error'                  => 'Els dies de descompte simples haurien de ser superiors a zero i s\'haurien de presentar.',
        'discount_days_nth_error'                     => 'Els dies enèsimos de descompte haurien de ser superiors a zero i s\'haurien de presentar.',
        'balance_due_days_error'                      => 'Els dies de venciment del saldo haurien de ser superiors a zero i s\'hauria de presentar.',
        'status_error'                                => 'Ho sentim, l\'estat no ha canviat a causa del terme utilitzat a la factura.',
        'down_payment_type_invoice_description_error' => 'El testimoni de descripció de la factura que heu introduït no coincideix amb el tipus de pagament inicial.',
        'down_payment_type_quote_description_error'   => 'El testimoni de descripció del pressupost introduït no coincideix amb el tipus de pagament inicial.',
    ],
    'quotes_delete_error'                             => 'Error d\'eliminació de cites',
    'for'                                             => 'Per',
    'production'                                      => 'Producció',
    'access_token'                                    => 'Fitxa d\'accés',
    'application_id'                                  => 'Id. de l\'aplicació',
    'location_id'                                     => 'Id. de la ubicació',
    'fi_config_check'                                 => 'Comprovació de requisits previs',
    'requirement'                                     => 'Requisit',
    'required'                                        => 'Obligatori',
    'actual'                                          => 'Real',
    'result'                                          => 'Resultat',
    'db_prefix_setup_alert'                           => 'La vostra base de dades de FusionInvoice utilitza prefixos de base de dades. El suport per als prefixos de base de dades va acabar amb la versió 2023-3.0. Per continuar amb l\'actualització a aquesta i a les futures versions, cal que elimineu els prefixos de base de dades. Podeu fer-ho canviant el nom de totes les taules de la vostra base de dades i eliminant el prefix i també establint el valor \'prefix\' => \'\', al fitxer database.php.',
    'open_tasks'                                      => 'Tasques obertes',
    'closed_tasks'                                    => 'Tasques tancades',
    'select_status'                                   => 'Seleccioneu Estat',
    'net_amount_due_invoice'                          => 'Import net a pagar en :days dies.',
    'days_add_in_current_date'                        => 'La data actual, a partir de <span class="text-blue">:date</span> , i la data de venciment, s\'han de considerar com a <span class="text-blue">:date</span>  <span class="text-danger">més</span> <span class="text-blue">el nombre de dies</span>.',
    'terms'                                           => 'Termes',
    'quote_rejecting_error'                           => 'La factura # :invoice_number es va crear el :invoice_date a partir de l\'aprovació d\'aquest pressupost. Heu de suprimir o cancel·lar aquesta factura abans de rebutjar aquest pressupost.',
    'resend_record_warning'                           => 'Vols tornar a enviar aquest correu electrònic ara?',
    'resend_email'                                    => 'Reenvia l\'email',
    'requirement_check_fail'                          => 'Abans que la instal·lació pugui continuar, heu de corregir els errors mostrats anteriorment.',
    'failed'                                          => 'Fracassat',
    'subscriptions'                                   => 'Subscripcions',
    'tt_explanation'                                  => 'Introduïu una descripció del servei amb marcadors de posició de data opcionals. Podeu utilitzar els següents testimonis per inserir dinàmicament les dates d\'inici i finalització del servei:{{service_starts_on}} i {{service_ends_on}}. Aquestes seran substituïdes per les dates d\'inici i finalització reals quan es mostri el contingut.',
    'tt_ss_invoices_default_payment_terms'            => 'Condicions de pagament predeterminades de la factura',
    'invoices_default_terms'                          => 'Condicions per defecte de les factures',
    'net_amount_due_in_n_days'                        => 'Import net a pagar en N dies',
    'last_day'                                        => 'L\'últim dia',
    'down_payment_payment_term1'                      => 'Pagament anticipat de',
    'down_payment_payment_term2'                      => 'es requereix.  El saldo s\'ha de pagar',
    '1_type'                                          => 'Una factura creada avui es vencerà d\'aquí a <span class="text-primary">#N</span> dies',
    '2_type'                                          => 'Una factura creada avui permetrà un descompte si es paga abans del <span class="text-primary">#date</span> , si no, l\'import total s\'haurà de pagar en un termini de <span class="text-primary">#N</span>  dies',
    '3_type'                                          => 'Una factura creada avui permetrà un descompte si es paga abans del <span class="text-primary">#date</span>  . L\'import net s\'ha de pagar en un termini de <span class="text-primary">#N</span>  dies',
    '4_type'                                          => 'Una factura creada avui requerirà un pagament inicial de <span class="text-primary">#amount</span>  . El saldo restant s\'haurà de pagar en un termini de <span class="text-primary">#N</span>  dies',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Una factura creada avui i dividida en <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Pagament <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Venciment <span class="text-primary">#date</span></p>',
    'installment'                                     => 'fraccionament',
    'apply_payment_terms'                             => 'Aplicar l\'import del descompte de condicions de pagament',
    'payable_amount'                                  => 'Import final a pagar',
    'payable_amount_lt_error'                         => 'L\'import final a pagar hauria de ser inferior al saldo de la factura.',
    'payment_term_type_4_amount'                      => 'S\'accepta el pagament parcial de :amount',
    'net_terms'                                       => 'Termes nets',
    'proforma_invoice_default'                        => 'Factura proforma per defecte',
    'expense_vendor'                                  => 'Proveïdor de despeses',
    'expense_vendor_deleted'                          => 'S\'ha suprimit el proveïdor de despeses',
    'expense_vendor_already_used'                     => 'No podeu suprimir un proveïdor que tingui entrades de despeses relacionades.',
    'total_must_be_gt_zero'                           => 'El total de :modal_name ha de ser superior a zero.',
    'payment_failed'                                  => 'El pagament ha fallat amb :error',
    'xss_validation'                                  => 'El camp :attribute conté etiquetes que podrien exposar una vulnerabilitat XSS',
    'support_desk'                                    => 'Taulell de suport',
    'choose_file'                                     => 'Trieu l\'arxiu',
    'supportTicket'                                   => 'Taulell de suport',
    'create_support_ticket'                           => 'Crea un bitllet de suport',
    'supportTicket_inbox_view'                        => 'Taulell de suport',
    'support_ticket'                                  => 'Bitllet de suport',
    'ticket_number'                                   => 'Número de bitllet',
    'revision'                                        => 'Revisió',
    'revisions'                                       => 'Revisions',
    'recurring_invoices'                              => 'Factures recurrents',
    'message'                                         => 'Missatge',
    'custom_img'                                      => 'Imatge personalitzada',
    'please_fill_some_data'                           => 'Si us plau, ompliu les dades requerides en el nou element.',
    'assigned'                                        => 'Assignat',
    'add_ons_will_be_disabled'                        => 'ELS SEGÜENTS COMPLEMENTS ES DESHABILITARAN:',
    'add_ons_will_be_disabled_msg'                    => 'Tots els complements es desactiven automàticament durant una actualització bàsica de FusionInvoice. Un cop finalitzada aquesta actualització, assegureu-vos de descarregar els fitxers zip del complement adequat i instal·lar-los. Un cop hàgiu fet això, podeu tornar-los a habilitar des del menú Configuració del sistema, Personalitzacions, Complements i seleccionant [Instal·la].',
    'price_not_valid'                                 => 'El preu ha de ser superior a zero',
    'free_space'                                      => 'Espai lliure',
    'expense_type'                                    => 'Tipus de despesa',
    'standard_expense'                                => 'Despesa estàndard',
    'expense_with_deductible_tax'                     => 'Despesa amb impost deduïble',
    'remittance_to_tax_authority'                     => 'Remesa a l\'Agència Tributària',
    'tax_paid'                                        => 'Impost pagat',
    'tax_detail'                                      => 'Detall fiscal',
    'select_expense_type'                             => 'Seleccioneu el tipus de despesa',
    'taxes_paid_on_expenses_or_remitted'              => 'Impostos pagats sobre despeses o remesos',
    'tax_name'                                        => 'Nom fiscal',
    'last_activity'                                   => 'Última Activitat',
    'select_default_company_profile'                  => 'Seleccioneu el vostre perfil d\'empresa predeterminat',
    'mn_sales_tax'                                    => 'Impost de vendes MN',
    'taxes_collected_on_sales'                        => 'Impostos recaptats per vendes',
    'vatgst_tax_note'                                 => 'Sí calcula l\'impost com a inclòs en el total de l\'article. No afegirà l\'impost al total de l\'article.',
    'tt_vatgst_tax'                                   => 'Per a aquest exemple, assumirem un tipus impositiu del 5% i un preu de l\'article de 100 dòlars. Si activeu l\'IVA/GST en Sí, obtindreu un total de factura de 100 $, amb l\'import de l\'article ajustat a 95,24 $ i un import fiscal de 4,76 $. Si establiu l\'IVA/GST a No, obtindreu una factura total de 105 $, amb un preu de l\'article de 100 $ i un impost de 5 $.',
    'level_of_detail'                                 => 'Nivell de detall',
    'tax_report'                                      => 'Informe fiscal',
    'detail'                                          => 'Detall',
    'totals'                                          => 'Totals',
    'totals_with_dots'                                => 'Totals. . .',
    'yes_all'                                         => 'Sí (tots)',
    'invoices_only'                                   => 'Només factures',
    'payment_receipts_only'                           => 'Només rebuts de pagament',
    'role'                                            => 'Rol',
    'previous_email'                                  => 'Correu electrònic anterior',
    'web_store_user_id'                               => 'Identificador d\'usuari de la botiga web: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Import net pendent el <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Es pot fer un descompte de #DISCOUNTPERCENT % si es paga abans de <span class="text-info">#DISCOUNTDATE</span> ~,</span> en cas contrari, l\'import net s\'haurà de pagar el <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'Es pot fer un descompte de #DISCOUNTPERCENT % si es paga abans de <span class="text-info">#DISCOUNTDATE</span> ~,</span> en cas contrari, l\'import net s\'haurà de pagar el <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'Un pagament inicial de <span class="text-info">#DOWNPAYMENT</span>  és el #INVOICEDATE . El saldo s\'haurà de pagar el <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Els pagaments es poden dividir en <span class="text-info">#NUMBEROFINSTALLMENTS</span> terminis</p>',
        '5_1_type'     => '<li>Pagament <span class="text-info">#PERCENT %</span> pendent <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">El mes que ve té un total de #N dies, així que introduïu un valor entre 1 i #N per al descompte dels dies del mes vinent.</span>',
    ],
    'payment_term_not_selected'                       => 'Termini de pagament no seleccionat',
    'confirm'                                         => 'Confirmeu',
    'create_live_invoice_now'                         => 'Vols crear una factura en directe ara?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Una subscripció és com una plantilla de factura que s\'utilitza per crear factures en directe amb una freqüència determinada.</p><p class="m-0"> Normalment una tasca CRON o una tasca programada s\'ha configurat per executar-se un cop al dia i s\'encarrega de comprovar les factures en directe que s\'han de crear, en funció del camp Generar data de la següent factura de la subscripció.  Si aquest valor de data és avui o anterior a avui, es crea automàticament una factura en directe.</p><p class="m-0"> Aquesta opció us permet crear manualment la factura en directe a partir de la subscripció, sense passar pel mètode automatitzat. . Voleu crear la factura actual ara?</p>',
    'contact'                                         => 'Contacte',
    'invoice_month_plus_one'                          => 'Factura mes +1',
    'invoice_month_plus_two'                          => 'Factura mes +2',
    'invoice_month_plus_three'                        => 'Factura mes +3',
    'inbound_email'                                   => 'Correu electrònic entrant',
    'outbound_email'                                  => 'Correu electrònic sortint',
    'email_signature'                                 => 'Signatura de correu electrònic',
    'mail_credential_error'                           => 'Configuració de correu electrònic no vàlida. Comproveu la vostra configuració i torneu-ho a provar. <strong>( Configuració <i class="fa-arrow-alt-circle-right"> </i> Configuració del sistema <i class="fa fa-arrow-alt-circle-right"> </i> Correu electrònic )</strong>',
    'tt_generate_next_invoice'                        => 'La data en què es crearà automàticament la següent factura en directe a partir d\'aquesta subscripció.',
    'tt_stop_date'                                    => 'El llindar de data després del qual no es generaran automàticament més factures en directe per a aquesta subscripció. Deixeu aquest camp buit per a una subscripció que hauria de continuar per sempre.',
    'description_template'                            => 'Plantilla de descripció',
    't_1_description'                                 => 'El pagament complet s\'haurà de fer abans del #LASTDATE.',
    't_2_description'                                 => 'Agafeu un descompte #DISCOUNTPERCENT % si el pagueu abans del #DISCOUNTDATE, en cas contrari, pagueu l\'import total de la factura abans del #LASTDATE.',
    't_3_description'                                 => 'Feu un descompte del #DISCOUNTPERCENT% si el pagueu abans del #DISCOUNTDATE, en cas contrari, pagueu l\'import total de la factura abans del #LASTDATE.',
    't_4_description'                                 => 'S\'ha de pagar un pagament inicial de #DOWNPAYMENT el #INVOICEDATE, el saldo de la factura s\'haurà de pagar el #LASTDATE',
    't_4_1_description'                               => 'S\'ha de pagar un pagament inicial de #DOWNPAYMENTPERCENT el #INVOICEDATE, el saldo de la factura s\'ha de pagar el #LASTDATE',
    't_5_description'                                 => 'Els pagaments s\'han de fer en #NUMBEROFINSTALLMENTS quotes iguals',
    't_5_type_description'                            => 'El pagament #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT s\'ha de pagar el #LASTDATE',
    'tokens_allowed'                                  => 'Es permeten fitxes',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'El text avaluat de la plantilla és la descripció dels termes que es mostra en documents com ara factura, pressupostos, etc.',
    'cc_mail'                                         => 'Correu CC',
    'assigned_inv_sent_or_paid'                       => '*Hi ha factures pagades o enviades que tenen assignat aquest termini de pagament. No es permet canviar els detalls del "Tipus".',
    'exclude_paid_invoices'                           => 'Exclou les factures pagades',
    'phone_number_numeric_error'                      => 'El número de telèfon ha de ser un número.',
    'phone_num_same_country_code_error'               => 'Assegureu-vos que el vostre número de telèfon estigui ben format. Sembla que s\'ha introduït començant pel codi del país, que no està permès.',
    'tt_expense_amount'                               => 'Introduïu l\'import total de la despesa, impostos inclosos. Aquest camp no està disponible quan s\'envia un pagament fiscal a una autoritat fiscal.',
    'tt_expense_tax_paid_deductible'                  => 'Introduïu l\'import de l\'impost que s\'ha pagat amb aquesta despesa. Aquest valor es deduirà de la vostra obligació fiscal global als informes de resum fiscal i detall fiscal.',
    'tt_expense_tax_paid_remittance'                  => 'Introduïu l\'import de l\'impost que es va remetre a l\'autoritat fiscal. S\'utilitza per registrar els pagaments realitzats pels impostos cobrats a les vostres factures pagades.',
    'tt_expense_client'                               => 'Si aquesta despesa s\'ha fet únicament en nom d\'un client i voleu facturar-li per això, seleccioneu el client relacionat aquí.',
    'base_currency_not_deleted'                       => 'La moneda base no es pot suprimir',
    'used_currency_modal_error'                       => 'La moneda ja s\'utilitza al mòdul :modal_names.',
    'addon_uninstall_success'                         => 'El complement s\'ha desinstal·lat correctament',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revisió (actual)',
    'number'                                          => 'Número',
    'copy_process_error'                              => 'Vaja! Sembla que hi va haver un singlot durant el procés de còpia. Siusplau, intenta-ho més tard.',
    'tt_captcha_image'                                => 'Imatge CAPTCHA',
    'reload_page'                                     => 'Torneu a carregar la pàgina',
    'discount_limit'                                  => 'El descompte ha de ser inferior al 99,99%.',
    'tooltip'                                         => 'Informació sobre eines',
    'authorization_error'                             => 'No estàs autoritzat per realitzar aquesta operació.',
    'reset_to_default'                                => 'Restableix al valor predeterminat',
    'reset_to_default_warning'                        => '<p>Això restablirà el subjecte i el cos al valor predeterminat per a :model . Continuar?</p>',
    'reset_default_mail_template'                     => 'La plantilla de correu predeterminada per a :model s\'ha restablert correctament.',
    'overdue_invoice'                                 => 'Factura vençuda',
    'total_cannot_be_lt_zero'                         => 'El total de :modal_name no pot ser inferior a zero.',
    'addons_disabled_during_setup'                    => 'Durant el procés d\'actualització es van desactivar els complements següents: :addons . No oblideu activar-los ara que s\'hagi completat l\'actualització.',
    'allow_payments_on_quotes'                        => 'Permet pagaments a les cotitzacions S/N',
    'allow_payments_on_quote'                         => 'Permet el pagament S/N',
    'tt_ss_quotes_is_payable'                         => 'Si està activat, després de l\'aprovació del pressupost, apareixerà un botó Paga ara a la vista d\'enllaç públic del pressupost. Es crearà automàticament una factura i el pagament s\'aplicarà a la factura.',
    'pay_with_square'                                 => 'Paga amb Square',
    'validation_mess_for_is_payable_quote'            => 'La configuració per convertir automàticament la cotització en factura quan el client l\'aprova és necessària quan Permet pagaments a les cotitzacions s\'estableix en "Sí".',
    'client_requirement_msg'                          => 'Creeu un client abans d\'afegir :seed_name',
    'quote_add_items'                                 => 'Cal cotitzar articles i l\'estat no s\'ha cancel·lat',
    'invalid_quote_id'                                => 'Identificador de pressupost no vàlid',
    'information_header'                              => 'Enhorabona, estàs a punt d\'estalviar una mica de diners!',
    'convenience_charge'                              => 'Càrrec de conveniència',
    'credit_card_fee_message'                         => 'Hi haurà una taxa de conveniència de targeta de crèdit de :charge en aquesta transacció.',
    'info_payment_term_type_2'                        => 'Tot i que el saldo de la vostra factura és :ORIGINAL_AMOUNT, sou elegible per a un descompte en termes de pagament del :DISCOUNT_PERCENT %, que reduirà l\'import del vostre pagament a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Tot i que el saldo de la vostra factura és :ORIGINAL_AMOUNT, sou elegible per a un descompte en termes de pagament del :DISCOUNT_PERCENT %, que reduirà l\'import del vostre pagament a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Tot i que el saldo de la vostra factura és :ORIGINAL_AMOUNT, sou apte per a les condicions de pagament per pagar un pagament inicial :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Tot i que el saldo de la vostra factura és :ORIGINAL_AMOUNT, sou apte per a les condicions de pagament per pagar un pagament fraccionat :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Les condicions de pagament s\'han d\'eliminar del :modal abans de suprimir-les.',
    'default_payment_term_warn'                       => '*Només podeu canviar el nom i els dies de venciment nets per a les <strong>Condicions de pagament predeterminades del sistema</strong>.',
    'quote_rejected_not_payable'                      => 'La cotització # :number ha estat rebutjada i no s\'ha de pagar a causa del seu estat.',
    'could_not_delete'                                => 'No s\'ha pogut suprimir',
    'convenience_charges_calculation_fail'            => 'Error: el càlcul dels càrrecs de conveniència ha fallat durant la migració. Siusplau, intenta-ho més tard.',
    'sign_in_welcome_message'                         => 'ðŸš€ Felicitats! La vostra FusionInvoice s\'ha instal·lat correctament! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>La vostra FusionInvoice s\'ha actualitzat correctament de la versió :old_version a la versió :new_version .</p><p> Per obtenir una visió general detallada de totes les noves funcions i millores, consulteu les nostres <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Notes de la versió</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Gràcies per triar FusionInvoice. La vostra confiança, suport i comentaris impulsen la nostra innovació.</p><p class="m-0 text-bold">Facturació feliç!</p><p class="text-bold">L\'equip de FusionInvoice</p >',
    'tt_gen_skin_user_profile'                        => 'Si canvieu aquest valor, s\'estableix el sistema predeterminat NOMÉS per als usuaris nous. Els usuaris poden anul·lar aquesta configuració mitjançant la configuració del seu perfil d\'usuari.',
    'description_template_invoice'                    => 'Plantilla de descripció - Factura',
    'description_template_quote'                      => 'Plantilla de descripció - Pressupost',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'El pagament íntegre s\'haurà de pagar dins dels #NETDAYS de la data de la factura.',
    't_2_description_for_quote'                       => 'Agafeu un descompte del #DISCOUNTPERCENT % si es paga dins #DISCOUNTDAYS, en cas contrari, pagueu l\'import total del pressupost abans de #NETDAYS.',
    't_3_description_for_quote'                       => 'Preneu un descompte #DISCOUNTPERCENT % si el pagueu abans del #NTHDAY del mes següent, en cas contrari, pagueu l\'import total de la factura en un termini de #NETDAYS dies.',
    't_4_description_for_quote'                       => 'S\'ha de pagar un pagament inicial de #DOWNPAYMENT en la data de la factura, el saldo restant s\'haurà de pagar en un termini de #NETDAYS dies',
    't_4_1_description_for_quote'                     => 'S\'ha de pagar un pagament inicial de #DOWNPAYMENTPERCENT a la data de la factura, el saldo restant s\'haurà de pagar en un termini de #NETDAYS dies',
    't_5_description_for_quote'                       => 'Els pagaments s\'han de fer en #NUMBEROFINSTALLMENTS quotes iguals',
    't_5_type_description_for_quote'                  => 'El pagament #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT s\'ha de pagar #INSTALLMENTDUEDAYS dies a partir de la data de la factura',
    'default_term'                                    => 'Terme predeterminat',
    'proceed_to_payment'                              => 'Procedir al pagament',
    'version_upgraded'                                => 'La teva sol·licitud està actualitzada.',
    'term_amount_gt_payment_amount'                   => 'L\'import ha de ser superior a l\'import del descompte en termes de pagament',
    'payment_term_not_eligible_warning'               => 'El descompte del termini de pagament només està disponible per a pagaments complets. Malauradament, no es qualifica per a això.',
    'processed_by_user'                               => '<strong>Processat per:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Mètode de pagament:</strong> :method',
    'all_methods'                                     => 'Tots els mètodes',
    'this_payment'                                    => 'Aquest Pagament',
    'previous_balance'                                => 'Balanç previ',
    'payment_applied_with_remaining_balance'          => '<p><strong>El vostre pagament de :amount s\'ha aplicat parcialment. :remaining_balance continua pendent.</strong></p>',
    'pre_payment_received'                            => '<p><strong>S\'ha rebut un prepagament de :amount per a futures factures el :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>El vostre :amount pagament s\'ha aplicat completament.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Pagament <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Detalls:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>El pagament de :paid s\'ha aplicat a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>El pagament de :paid, menys :payment_terms_discount descompte del termini de pagament, s\'ha aplicat a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>El pagament de :paid, més :convenience_charges càrrecs de conveniència, s\'ha aplicat a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>El pagament de :paid, més :convenience_charges càrrecs de conveniència i menys :payment_terms_discount descompte del termini de pagament, s\'ha aplicat a la factura :invoice_number el :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>El saldo restant de Invoice :invoice_number és :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Factures impagades',
    'include'                                         => 'Incloure',
    'exclude'                                         => 'Excloure',
    'invoice_with_no_tax'                             => 'Factures sense impostos',
    'tax_total'                                       => 'Impost total',
];

return TranslationOverride::override(__FILE__, $translations);
