<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!(Schema::hasColumn('quotes', 'online_payment_processing_fee')))
        {
            Schema::table('quotes', function (Blueprint $table)
            {
                $table->enum('online_payment_processing_fee', ['yes', 'no'])->default('no');
            });
        }
    }
};