<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Setting::saveByKey('isPayableQuote', 0);
        Setting::saveByKey('merchant_Square_paymentButtonText', trans('fi.pay_with_square'));

        if (!Schema::hasColumn('quotes', 'is_payable_quote'))
        {
            Schema::table('quotes', function (Blueprint $table)
            {
                $table->boolean('is_payable_quote')->default(0);
            });
        }

    }
};