<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Setting::saveByKey('quoteApprovedSubjectDefault', 'Quote #{{ $quote->number }}');
        Setting::saveByKey('quoteRejectedSubjectDefault', 'Quote #{{ $quote->number }}');
        Setting::saveByKey('creditMemosSubjectDefault', 'Credit Memo #{!! $invoice->number !!}');
        Setting::saveByKey('creditMemosMailTemplateDefault', '<p>To view your credit memo from {{ $invoice->user->name }} for {{ $invoice->amount->formatted_total }}, click the link below:</p>' . "\r\n\r\n" . '<p><a href="{{ $invoice->public_url }}">{{ $invoice->public_url }}</a></p>');
        Setting::saveByKey('overdueInvoiceSubjectDefault', 'Invoice #{!! $invoice->number !!}');
    }

};
