<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\PaymentTerms\Models\PaymentTerm;
use FI\Modules\RecurringInvoices\Models\RecurringInvoice;
use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{

    public function up(): void
    {

        $paymentTerm = PaymentTerm::where('is_default', 1)->first();

        if (empty($paymentTerm))
        {
            $paymentTerm = PaymentTerm::create(
                [
                    "type"         => 0,
                    "name"         => trans('fi.net_terms'),
                    "net_due_days" => 0,
                    "is_default"   => 1,
                ]
            );
        }
        if (config('fi.defaultPaymentTerms') == '')
        {
            Setting::saveByKey('defaultPaymentTerms', $paymentTerm->id);
        }
        RecurringInvoice::where('payment_terms_id', 0)->orWhere('payment_terms_id', null)->update(['payment_terms_id' => $paymentTerm->id]);
    }
};
