<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('recurring_invoices', 'payment_terms_id'))
        {
            Schema::table('recurring_invoices', function (Blueprint $table)
            {
                $table->integer('payment_terms_id');
                $table->enum('online_payment_processing_fee', ['yes', 'no'])->default('no');

                $table->index('payment_terms_id');
            });
        }

        DB::statement("ALTER TABLE ".DB::getTablePrefix()."recurring_invoices MODIFY COLUMN service_ends_of_the ENUM('invoice_month', 'invoice_month_plus_one', 'invoice_month_plus_two', 'invoice_month_plus_three', 'invoice_year', 'next_year')");
    }
};
