<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Expenses\Models\Expense;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('expenses', 'type'))
            {
                Schema::table('expenses', function (Blueprint $table)
                {
                    $table->string('type')->nullable();
                    $table->decimal('tax_paid', 20, 4)->nullable();
                });
            }

            $expenses = Expense::all();
            foreach ($expenses as $expense)
            {
                $amount = floatval($expense->amount);
                $tax    = floatval($expense->tax);

                if ($amount == 0 && $tax > 0)
                {
                    $expense->type = "remittance_to_tax_authority";
                }
                elseif ((!$amount == 0) && $amount > 0 && $tax > 0)
                {
                    $expense->type = "expense_with_deductible_tax";
                }
                else
                {
                    $expense->type = "standard_expense";
                }
                $expense->tax_paid = $tax;
                $expense->tax      = '';
                $expense->save();
            }
            Schema::table('expenses', function (Blueprint $table)
            {
                $table->integer('tax')->nullable()->change();
            });
        }
        catch (Exception $e)
        {
            Log::channel('single')->error('Exception: ' . $e->getMessage() . ' ' . $e->getLine());
        }

    }
};
