<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('invoices', 'discount_type'))
        {
            Schema::table('invoices', function (Blueprint $table)
            {
                $table->string('discount_type')->default('percentage');
            });
        }

        if (!Schema::hasColumn('quotes', 'discount_type'))
        {
            Schema::table('quotes', function (Blueprint $table)
            {
                $table->string('discount_type')->default('percentage');
            });
        }

        if (!Schema::hasColumn('recurring_invoices', 'discount_type'))
        {
            Schema::table('recurring_invoices', function (Blueprint $table)
            {
                $table->string('discount_type')->default('percentage');
            });
        }

        if (Schema::hasTable('proforma_invoices') && !Schema::hasColumn('proforma_invoices', 'discount_type'))
        {
            Schema::table('proforma_invoices', function (Blueprint $table)
            {
                $table->string('discount_type')->default('percentage');
            });
        }
    }

};
