<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('payment_terms'))
        {
            Schema::create('payment_terms', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->text('description')->nullable();
                $table->integer('type')->default(1);
                $table->decimal('discount_percent', 20, 4)->default(0.00)->nullable();
                $table->integer('discount_days_simple')->nullable();
                $table->integer('discount_days_nth')->nullable();
                $table->integer('net_due_days')->nullable();
                $table->integer('down_payment')->nullable();
                $table->integer('balance_due_days')->nullable();
                $table->integer('number_of_installments')->nullable();
            });
        }

        if (!Schema::hasTable('payment_term_installments'))
        {
            Schema::create('payment_term_installments', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('payment_terms_id');
                $table->integer('installment_number')->nullable();
                $table->decimal('installment_percent', 20, 18)->default(0.00)->nullable();
                $table->integer('installment_due_days')->nullable();

                $table->index('payment_terms_id');
            });
        }

        if (!Schema::hasColumn('invoices', 'payment_terms_id'))
        {
            Schema::table('invoices', function (Blueprint $table)
            {
                $table->integer('payment_terms_id');

                $table->index('payment_terms_id');
            });
        }

        if (!Schema::hasColumn('payment_invoices', 'installment_number'))
        {
            Schema::table('payment_invoices', function (Blueprint $table)
            {
                $table->integer('installment_number');
            });
        }
    }
};
