<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('recurring_invoices', 'service_explanation'))
        {
            Schema::table('recurring_invoices', function (Blueprint $table)
            {
                $table->text('service_explanation')->nullable();
                $table->text('service_starts_on')->nullable();
                $table->enum('service_ends_of_the', ['invoice_month', 'next_month', 'invoice_year', 'next_year'])->nullable();
            });
        }

    }
};