<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTimeTrackingTasksTable extends Migration 
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    
    //Convert the time tracking add-ons task description field from string to text if it was not done already.
    public function up()
    {
        if (Schema::hasTable('time_tracking_tasks'))
        {
            if (Schema::hasColumn('time_tracking_tasks', 'description'))
            {
                $descriptionColumn = Schema::getConnection()->getDoctrineColumn('time_tracking_tasks', 'description'); 
                $columnType = $descriptionColumn->getType()->getName(); 

                if ($columnType !== 'text')
                {
                    Schema::table('time_tracking_tasks', function (Blueprint $table)
                    {
                        $table->text('description')->nullable()->change();
                    });
                }   
            }
        }
    }
}
