<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Clients\Models\Client;
use FI\Modules\CompanyProfiles\Models\CompanyProfile;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (! Schema::hasColumn('clients', 'company_profile_id'))
        {
            Schema::table('clients', function (Blueprint $table)
            {
                $table->integer('company_profile_id');
                $table->index('company_profile_id');
            });
        }

        $companyProfile = CompanyProfile::whereIsDefault(1)->first();

        if ($companyProfile)
        {
            Client::where(function($query) {
                $query->whereNull('company_profile_id')
                      ->orWhere('company_profile_id', 0)
                      ->orWhere('company_profile_id', '');
            })->update(['company_profile_id' => $companyProfile->id]);
        }
    }

};
