<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientsRecurringEmailReceipt extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasColumn('clients','automatic_email_on_recur'))
        {
            Schema::table('clients', function (Blueprint $table)
            {
                $table->enum('automatic_email_on_recur', ['default', 'yes', 'no'])->default('default')->after('automatic_email_payment_receipt');
            });
        }
    }
}