<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumns('payments', ['remaining_balance', 'client_id']))
        {
            Schema::table('payments', function (Blueprint $table)
            {
                $table->decimal('remaining_balance', 10, 2)->default(0.00)->after('amount');
                $table->integer('client_id')->nullable()->after('invoice_id');

                $table->index('client_id');
            });
        }
    }
}
