<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransitionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('transitions'))
        {
            Schema::create('transitions', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('user_id');
                $table->integer('transitionable_id');
                $table->string('transitionable_type')->nullable();
                $table->string('transitionable_field')->nullable();
                $table->string('previous_state')->nullable();
                $table->string('state')->nullable();
            });
        }
    }
}
