<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddIsDefaultToCompanyProfiles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('company_profiles', 'is_default'))
        {
            Schema::table('company_profiles', function (Blueprint $table)
            {
                $table->boolean('is_default')->default(0);
            });
        }

        if (Schema::hasColumn('company_profiles', 'is_default'))
        {
            DB::table('company_profiles')->where('id', DB::table('company_profiles')->min('id'))
                ->update(['is_default' => 1]);
        }
    }

}
