<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class PersistRecurringInvoiceSource extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('invoices', 'recurring_invoice_id'))
        {
            Schema::table('invoices', function (Blueprint $table)
            {
                $table->integer('recurring_invoice_id')->unsigned();
            });
        }
    }
}
