<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;

class QuoteStatusChangeSettings extends Migration
{
    public function up()
    {
        Setting::saveByKey('quoteApprovedEmailBody', '<p><a href="{{ $quote->public_url }}">Quote #{{ $quote->number }}</a> has been APPROVED.</p>');
        Setting::saveByKey('quoteRejectedEmailBody', '<p><a href="{{ $quote->public_url }}">Quote #{{ $quote->number }}</a> has been REJECTED.</p>');
    }
}
