<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Requests;

use Illuminate\Contracts\Validation\Rule;

class RemoveTagsRule implements Rule
{
    public function passes($attribute, $value)
    {

        $tags     = ['script', 'java', 'live', 'vb', 'mocha', 'feed', 'data', 'form', 'xml', 'iframe', 'frameset', 'frame', 'title', 'div'];
        $pattern  = '/<(' . implode('|', $tags) . ')(\s[^>]*)?/';
        $pattern1 = '/<(' . implode('|', $tags) . ')(\s[^>]*)?>/';
        $pattern2 = '/^<(' . implode('|', $tags) . ')(\s[^>]*)?>.*<\/\1>$/';


        preg_match_all($pattern, $value, $matches);
        preg_match_all($pattern1, $value, $matches1);
        preg_match_all($pattern2, $value, $matches2);

        if (!empty($matches[0]) || !empty($matches1[0]) || !empty($matches2[0]))
        {
            return false;
        }
        return true;

    }

    public function message()
    {
        return trans('fi.xss_validation');
    }

}