<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\WebhookApi\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;

class WebhookApiClientStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        $request                        = $this->all();
        $signature                      = $this->header('Webhook-Signature');
        $payload                        = $this->getContent();
        $secretKey                      = config('mautic.secret_key');
        $generatedSignature             = base64_encode(hash_hmac('sha256', $payload, $secretKey, true));
        $request['webhook-signature']   = $signature;
        $request['generated-signature'] = $generatedSignature;

        $this->replace($request);
    }

    public function rules()
    {
        return [
            'webhook-signature'   => 'required',
            'generated-signature' => 'required|same:webhook-signature',
        ];
    }

    public function messages()
    {
        return [
            'signature.same' => trans('fi.mautic-authentication-fail'),
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json(['errors' => (new ValidationException($validator))->errors()], JsonResponse::HTTP_UNPROCESSABLE_ENTITY));
    }
}