<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\WebhookApi\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Clients\Models\Client;
use FI\Modules\Tags\Models\Tag;
use FI\Modules\Users\Models\User;
use FI\Modules\WebhookApi\Requests\WebhookApiClientStoreRequest;
use Illuminate\Support\Str;

class WebhookApiClientController extends Controller
{
    public function store(WebhookApiClientStoreRequest $request)
    {
        try
        {
            $leadData = $request['mautic.lead_post_save_update'];

            $extractedValues = [];
            foreach ($leadData as $contact)
            {
                foreach ($contact['contact'] as $key => $value)
                {

                    if ($key == 'fields')
                    {
                        foreach ($contact['contact']['fields']['core'] as $field => $field_val)
                        {
                            $extractedValues[$field] = $field_val['value'];
                        }
                    }
                    else
                    {
                        $extractedValues[$key] = $value;
                    }
                }
            }

            $client = [
                'created_at' => $extractedValues['dateAdded'],
                'user_id'    => User::whereUserType('system')->first()->id,
                'name'       => $extractedValues['firstname'] . ' ' . $extractedValues['lastname'],
                'address'    => $extractedValues['address1'] . ' ' . $extractedValues['address2'],
                'city'       => $extractedValues['city'],
                'state'      => $extractedValues['state'],
                'zip'        => $extractedValues['zipcode'],
                'country'    => $extractedValues['country'],
                'phone'      => $extractedValues['phone'],
                'fax'        => $extractedValues['fax'],
                'mobile'     => $extractedValues['mobile'],
                'email'      => $extractedValues['email'],
                'web'        => $extractedValues['website'],
                'url_key'    => Str::random(32),
                'language'   => explode('_', $extractedValues['preferred_locale'])[0],
                'timezone'   => $extractedValues['timezone'],
                'type'       => 'lead',
            ];

            $newClient = Client::create($client);

            if (isset($extractedValues['tags']) && $extractedValues['tags'] != null)
            {
                foreach ($extractedValues['tags'] as $tag)
                {
                    $tagModel = Tag::firstOrNew(['name' => $tag['tag'], 'tag_entity' => 'client'])->fill(['name' => $tag['tag'], 'tag_entity' => 'client']);

                    $tagModel->save();

                    $tag_ids[] = $tagModel->id;
                }

                foreach ($tag_ids as $tag_id)
                {
                    $newClient->tags()->create(['client_id' => $newClient->id, 'tag_id' => $tag_id]);
                }

            }

            return response()->json(['success' => true, 'message' => trans('fi.record_successfully_created')], 200);
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => trans('fi.something_went_wrong')], 400);
        }
    }
}