@extends('setup.master')
@section('warning')
    @if($requirementsError)
        <div class="row after-check-warning">
            <div class="col-md-12">
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <h5><i class="icon fas fa-exclamation-triangle"></i> {{trans('fi.failed')}}!</h5>
                    {{trans('fi.requirement_check_fail')}}
                </div>
            </div>
        </div>
    @endif
@endsection
@section('content')
    @include('setup.check_cross_animation')
    <script>
        $(function () {

            $('.animation-list-check-and-cross').hide();
            $('.requirement-after-next').hide();
            $('.after-check-warning').hide();

            let total_config_check_length = Array.from({length: ($('.animation-list-check-and-cross').length)}, (v, k) => k);

            const shuffle = (array) => {
                return array.sort(() => Math.random() - 0.5);
            };

            const shuffledArray = shuffle(total_config_check_length);

            shuffledArray.forEach((value, index) => {
                setTimeout(() => {
                    showElementsWithDelay(value, index);
                }, index * 200);
            });

            function showElementsWithDelay(length, index)
            {
                $('.spinner-loader:eq(' + length + ')').hide();
                $('.animation-list-check-and-cross:eq(' + length + ')').fadeIn(50);

                if ($('.animation-list-check-and-cross').length == (index + 1))
                {
                    setTimeout(() => {
                        $('.after-check-warning').fadeIn(200);
                        $('.requirement-after-next').fadeIn(200);
                    }, 1000);
                }
            }

            $('[data-toggle="tooltip"]').tooltip()

        });
    </script>

    <section class="content-header">
        <h1>{{ trans('fi.fi_config_check') }}</h1>
    </section>

    <section class="content">
        {!! Form::open(['url' => route('setup.migration'), 'method' => 'GET']) !!}
        <div class="row">

            <div class="col-md-12">

                <div class="card card-primary card-outline">

                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-hover table-striped table-sm text-nowrap">
                                    <thead>
                                    <tr>
                                        <th>{{trans('fi.requirement')}}</th>
                                        <th>{{trans('fi.required')}}</th>
                                        <th>{{trans('fi.actual')}}</th>
                                        <th class="text-right">{{trans('fi.result')}}</th>
                                    </tr>

                                    </thead>
                                    <tbody>

                                    @foreach($requirements as $required)
                                        <tr style="height: 40px;">
                                            <td>{!!  $required['requirement']!!}</td>
                                            <td>{{$required['required']}}</td>
                                            <td>{{$required['actual']}}</td>
                                            <td>
                                                <span class="float-right">
                                                    <span class="animation-list-check-and-cross">
                                                        @if($required['result'] == 0 )
                                                            <svg class="mark cross_mark" viewBox="0 0 52 52">
                                                                <circle class="checkmark_cross_circle" cx="26" cy="26" r="25" fill="none"/>
                                                                <path class="checkmark__check__cross" fill="none" d="M14.1 14.1l23.8 23.8 m0,-23.8 l-23.8,23.8"/>
                                                            </svg>
                                                        @else
                                                            <svg class="mark checkmark" viewBox="0 0 52 52">
                                                                <circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/>
                                                                <path class="checkmark__check__cross" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                                                            </svg>
                                                        @endif
                                                    </span>
                                                    <div class="spinner-border spinner-loader" role="status"></div>
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>

                                </table>
                            </div>

                            @if($requirementsError != true)
                                <div class="col-12 text-right requirement-after-next">
                                    {!! Form::submit(trans('fi.next'), ['class' => 'btn btn-sm btn-outline-primary','style'=>'box-shadow: 0px 0px 6px lightblue;']) !!}
                                </div>
                            @endif
                        </div>

                    </div>

                </div>

            </div>

        </div>
        {!! Form::close() !!}
    </section>
@stop