@extends('setup.master')
@section('head')
    @if( config('fi.headerTitleText') == '')
        <title>{{ trans('fi.migration') }}</title>
    @endif
@stop
@section('javascript')
    <script type="text/javascript">
        $(function () {

            $('#btn-run-migration').click(function () {

                $('#btn-run-migration').hide();
                $('#btn-running-migration').show();

                $.post('{{ route('setup.postMigration') }}').done(function () {
                    $('#div-exception').hide();
                    $('#btn-running-migration').hide();
                    $('#btn-attachment-complete').show();
                }).fail(function (response) {
                    $('#div-exception').show().html($.parseJSON(response.responseText).exception);
                    $('#btn-running-migration').hide();
                    $('#btn-run-migration').show();
                });
            });

        });
    </script>
@stop

@section('content')

    <section class="content-header">
        <h1>{{ trans('fi.database_setup') }}
            @if($branch!='')
                <span data-toggle="tooltip" data-placement="auto" title="{{trans('fi.git_branch')}}">
                    ({{$branch}})
                </span>
            @endif
        </h1>
    </section>

    <section class="content">

        <div class="row">

            <div class="col-md-12">

                <div class="card card-primary card-outline">

                    <div class="card-body">

                        <div class="alert alert-error text-danger" id="div-exception" style="display: none;"></div>

                        <p>{{ trans('fi.step_database_setup') }}</p>

                        <a class="btn btn-sm btn-outline-primary" id="btn-run-migration" @style('box-shadow: 0px 0px 6px lightblue;')>{{ trans('fi.continue') }}</a>

                        <a class="btn btn-sm btn-outline-secondary" id="btn-running-migration" style="display: none;"
                           disabled="disabled">{{ trans('fi.installing_please_wait') }}</a>

                        <a href="{{ route('setup.attachment') }}" class="btn btn-sm btn-outline-success"
                           id="btn-attachment-complete" @style('display: none; box-shadow: 0px 0px 6px lightblue;')>{{ trans('fi.continue') }}</a>
                    </div>

                </div>

            </div>

        </div>

    </section>

@stop