@extends('setup.master')

@section('javascript')

    <script type="text/javascript">
        $(function () {
            attachmentAgreementAccept();

            function attachmentAgreementAccept() {
                $attachmentCheck = $('#attachment-check').prop('checked');
                if ($attachmentCheck) {
                    $('.attachment-check').removeClass('.d-none').addClass('d-block');
                    $('.attachment-check-btn').removeClass('disabled');
                } else {
                    $('.attachment-check').addClass('d-none').removeClass('d-block');
                    $('.attachment-check-btn').addClass('disabled');
                }
            }

            $('#attachment-check').click(function () {
                attachmentAgreementAccept();
            });

            $('#btn-run-attachment').click(function (e) {
                $('#btn-run-attachment').hide();
                $('#btn-running-attachment').show();

                $.post('{{ route('setup.postAttachment') }}', {
                    _token: '{{ csrf_token() }}',
                    key: '{{$attachmentCheckKey}}'
                }).done(function () {
                    $('#div-exception').hide();
                    $('#btn-running-attachment').hide();
                    $('#btn-attachment-complete').show();
                }).fail(function (response) {
                    $('#div-exception').show().html($.parseJSON(response.responseText).exception);
                    $('#btn-running-attachment').hide();
                    $('#btn-run-attachment').show();
                });
            });

        });
    </script>
@stop

@section('content')

    <section class="content-header">

        <h1>{{ trans('fi.db_to_file_system_attachments_migration') }}</h1>

    </section>

    <section class="content">

        <div class="row">

            <div class="col-md-12">

                <div class="card card-primary card-outline">

                    <div class="card-body">
                        @if($attachmentCount->totalContent != 0)

                            <marquee behavior="scroll" direction="left" onmouseover="this.stop();"
                                     onmouseout="this.start();">
                                <span class="font-style-color text-info">
                                    @if($attachmentCount->moveContent == 0)
                                        {!! trans('fi.attachment_content_count', ['number' => $attachmentCount->totalContent]) !!}
                                    @else
                                        {!! trans('fi.attachment_repeat_content_count', ['number1' => $attachmentCount->totalContent,'number2' => $attachmentCount->moveContent]) !!}
                                    @endif
                                    </span>
                            </marquee>

                        @endif

                        <div class="alert alert-warning">
                            <h5><i class="icon fas fa-exclamation-triangle"></i> {{ trans('fi.stop') }}</h5>
                            {{ trans('fi.attachment_migration_warning') }}
                        </div>

                        <div class="alert alert-error text-danger" id="div-exception" style="display: none;"></div>

                        <div class="form-group">
                            {!! Form::checkbox('attachment_accept', 1,false,['id' => 'attachment-check']) !!} <label
                                    for="attachment-check"> {{ trans('fi.attachment_agreement_accept') }} </label>
                        </div>
                        <div class="attachment-check d-none">
                            <a class="btn btn-sm btn-outline-primary attachment-check-btn"
                               id="btn-run-attachment" @style('box-shadow: 0px 0px 6px lightblue;')>{{ trans('fi.continue') }}</a>

                            <a class="btn btn-sm btn-outline-secondary attachment-check-btn" id="btn-running-attachment"
                               style="display: none;"
                               disabled="disabled">{{ trans('fi.installing_please_wait') }}</a>

                            <a href="{{ route('setup.account') }}" class="btn btn-sm btn-outline-success attachment-check-btn"
                               id="btn-attachment-complete" @style('display: none; box-shadow: 0px 0px 6px lightblue;')>{{ trans('fi.continue') }}</a>
                        </div>
                    </div>

                </div>

            </div>

        </div>

    </section>
@stop