<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Settings\Models;

use FI\Modules\CompanyProfiles\Models\CompanyProfile;
use FI\Modules\Users\Models\User;

class SettingObserver
{
    public function saving(Setting $setting)
    {
        if ($setting->setting_key == 'invoiceTemplate' or $setting->setting_key == 'quoteTemplate' or $setting->setting_key == 'proformaInvoiceTemplate')
        {
            $original = $setting->getOriginal();

            if (isset($original['setting_value']) and $original['setting_value'] !== $setting->setting_value)
            {
                $templateType     = $setting->setting_key;
                $originalTemplate = $original['setting_value'];
                $newTemplate      = $setting->setting_value;

                if ($templateType == 'invoiceTemplate')
                {
                    CompanyProfile::whereNull('invoice_template')->orWhere('invoice_template', $originalTemplate)->orWhere('invoice_template', '')->update(['invoice_template' => $newTemplate]);
                }
                elseif ($templateType == 'quoteTemplate')
                {
                    CompanyProfile::whereNull('quote_template')->orWhere('quote_template', $originalTemplate)->orWhere('quote_template', '')->update(['quote_template' => $newTemplate]);
                }
                elseif ($templateType == 'proformaInvoiceTemplate')
                {
                    CompanyProfile::whereNull('proforma_invoice_template')->orWhere('proforma_invoice_template', $originalTemplate)->orWhere('proforma_invoice_template', '')->update(['proforma_invoice_template' => $newTemplate]);
                }
            }
        }

        if ($setting->setting_key == 'defaultCompanyProfile')
        {
            $original = $setting->getOriginal();

            if (isset($original['setting_value']) and $original['setting_value'] !== $setting->setting_value)
            {
                $oldCompanyProfile             = CompanyProfile::whereIsDefault(1)->first();
                $oldCompanyProfile->is_default = 0;
                $oldCompanyProfile->save();
                $companyProfile             = CompanyProfile::find($setting->setting_value);
                $companyProfile->is_default = 1;
                $companyProfile->save();
            }
        }

        if (config('fi.mailDriver') == '' && auth()->user() != '')
        {
            $user                     = User::find(auth()->user()->id);
            $user->two_factor_enabled = 0;
            $user->save();
        }
    }
}