<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Settings\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Storage;
use PDOException;

class Setting extends Model
{
    protected $guarded = ['id'];

    /*
    |--------------------------------------------------------------------------
    | Static Methods
    |--------------------------------------------------------------------------
    */

    public static function deleteByKey($key)
    {
        self::where('setting_key', $key)->delete();
    }

    public static function getByKey($key)
    {
        $setting = self::where('setting_key', $key)->first();

        if ($setting)
        {
            return $setting->setting_value;
        }

        return null;
    }

    public static function saveByKey($key, $value)
    {
        $setting = self::firstOrNew(['setting_key' => $key]);

        $setting->setting_value = $value;

        config(['fi.' . $key => $value]);

        $setting->save();

        return $setting;
    }

    public static function setAll()
    {
        try
        {
            $settings = self::all();

            foreach ($settings as $setting)
            {
                config(['fi.' . $setting->setting_key => $setting->setting_value]);
            }

            return true;
        }
        catch (QueryException $e)
        {
            return false;
        }
        catch (PDOException $e)
        {
            return false;
        }
    }

    public static function writeEmailTemplates()
    {
        $emailTemplates = self::emailList();

        foreach ($emailTemplates as $key => $template)
        {
            foreach ($template as $key2 => $items)
            {
                foreach ($items as $key3 => $emailBody)
                {
                    $emailKey         = $key . $key2 . ucfirst($key3);
                    $templateContents = self::getByKey($emailKey);
                    $templateContents = str_replace('{{', '{!!', $templateContents);
                    $templateContents = str_replace('}}', '!!}', $templateContents);

                    Storage::put('email_templates/' . $key . '/' . $key2 . '/' . $key3 . '.blade.php', $templateContents);
                }
            }
        }
    }

    public static function getSettingKeyValuePair()
    {
        $settingKeyValuePair = [];
        $settings            = self::all();
        foreach ($settings as $setting)
        {
            $settingKeyValuePair[$setting->setting_key] = $setting->setting_value;
        }

        return $settingKeyValuePair;

    }

    public function mailQueue()
    {
        return $this->morphMany('FI\Modules\MailQueue\Models\MailQueue', 'mailable');
    }

    public static function emailList()
    {

        $emailTemplates = [

            'quote'                   => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'quoteApproved'           => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),

                ]
            ],
            'quoteRejected'           => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'proformaInvoice'         => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'proformaInvoiceApproved' => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),

                ]
            ],
            'proformaInvoiceRejected' => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'invoice'                 => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'creditMemos'             => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'overdueInvoice'          => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],
            'upcomingPayment'         => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),

                ]
            ],
            'paymentReceipt'          => [
                'Subject'      => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ],
                'MailTemplate' => [
                    'default' => trans('fi.default'),
                    'custom1' => trans('fi.custom1'),
                    'custom2' => trans('fi.custom2'),
                    'custom3' => trans('fi.custom3'),
                ]
            ],


        ];
        return $emailTemplates;
    }

}