<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Sessions\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SessionRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'email'            => trans('fi.email'),
            'password'         => trans('fi.password'),
            'captcha_response' => trans('fi.answer'),
        ];
    }

    public function rules()
    {
        $rules = ['email' => 'required|email', 'password' => 'required'];
        if (config('fi.useCaptchaInLogin'))
        {
            $rules['captcha_response'] = 'required|captcha';
        }
        if (config('app.demo'))
        {
            $rules['database'] = 'required';
        }

        return $rules;
    }

    public function withValidator($validator)
    {
        $validator->addExtension('captcha', function ($attribute, $value)
        {
            return $value === session('captcha');
        });

        return $validator;
    }
}