<table class="table table-hover table-striped table-sm text-nowrap">
    <thead>
    <tr>
        @foreach($tableHeaders as $tableHeader)
            <th>
                {{ trans('ProformaInvoice::lang.'.$tableHeader) }}
            </th>
        @endforeach
    </tr>
    </thead>
    <tbody>
    @foreach ($seeds as $proformaInvoice)
        <tr>
            <td>
                <span class="badge badge-{{ $proformaInvoice->status }}">{{ trans('fi.' . $proformaInvoice->status) }}</span>
                @if ($proformaInvoice->viewed)
                    <span class="badge badge-success">{{ trans('fi.viewed') }}</span>
                @endif
            </td>
            <td>
                <a target="_blank" href="{{ route('proforma.invoices.edit', [$proformaInvoice->id]) }}"
                   title="{{ trans('fi.edit') }}">{{ $proformaInvoice->number }}
                </a>
            </td>
            <td>{{ $proformaInvoice->formatted_proforma_invoice_date }}</td>
            <td>{{ $proformaInvoice->formatted_expires_at }}</td>
            <td>
                <a target="_blank" href="{{ route('clients.show', [$proformaInvoice->client->id]) }}"
                   title="{{ trans('fi.view_client') }}">{{ $proformaInvoice->client->name }}
                </a>
            </td>
            <td>{{ $proformaInvoice->short_summary }}</td>
            <td>
                @if ($proformaInvoice->invoice)
                    <a target="_blank"
                       href="{{ route('invoices.edit', [$proformaInvoice->invoice_id]) }}">{{ trans('fi.yes') }}</a>
                @else
                    {{ trans('fi.no') }}
                @endif
            </td>
            <td>{{ $proformaInvoice->amount->formatted_total }}</td>
        </tr>
    @endforeach
    </tbody>
</table>