<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Seeder\Controllers;

use Exception;
use FI\Http\Controllers\Controller;
use FI\Modules\Clients\Models\Client;
use FI\Modules\Seeder\Requests\DataSeederRequest;
use FI\Support\Frequency;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

class SeederController extends Controller
{
    public function index()
    {
        return view('seeder.data-seeder')->with('modules', $this->seederName());
    }

    public function seederName($modal = null)
    {
        $seeder = [
            'client'           => trans('fi.clients'),
            'quote'            => trans('fi.quotes'),
            'invoice'          => trans('fi.invoices'),
            'recurringInvoice' => trans('fi.recurring_invoices'),
            'expense'          => trans('fi.expenses'),
            'task'             => trans('fi.tasks'),
        ];

        if (config('proforma_invoice_enabled') && Schema::hasTable('proforma_invoices'))
        {
            $seeder['proformaInvoice'] = trans('ProformaInvoice::lang.proforma_invoices');
        }

        return ($modal != '') ? ($seeder[$modal]) : $seeder;
    }

    public function dataSeederModal(DataSeederRequest $request)
    {
        try
        {
            if (!config('app.demo'))
            {
                $modalName  = $seederName = ucwords(request('module'));
                $modalName  = $modalName == 'Task' ? 'TaskList' : $modalName . 's';
                $modal      = ($modalName != 'ProformaInvoices') ? ('FI\Modules\\' . $modalName . '\\Models\\' . $seederName) : ('Addons\\' . ucwords(request('module')) . '\\Models\\' . $seederName);
                $modalClass = 'FI\Modules\Seeder\Seeds\\' . $seederName . 'Seeder';

                if (in_array(request('module'), ['quote', 'invoice', 'recurringInvoice', 'proformaInvoice']) && empty(Client::count()))
                {
                    return response()->json(['success' => false, 'message' => trans('fi.client_requirement_msg', ['seed_name' => $this->seederName(request('module'))])], 400);
                }

                $seeder = new $modalClass(request('number_of_seed_data'));
                $seeds  = $seeder->run();

                $tableHeader = $modal::getheaders();
                return view('seeder._' . request('module') . '_table')
                    ->with(['seeds' => $seeds, 'tableHeaders' => $tableHeader])
                    ->with('frequencies', Frequency::lists())
                    ->with('typeLabels', ['lead' => 'badge-warning', 'prospect' => 'badge-danger', 'customer' => 'badge-success', 'affiliate' => 'badge-info', 'other' => 'badge-secondary'])
                    ->render();
            }
            else
            {
                return response()->json(['success' => false, 'message' => trans('fi.functionality_not_available_on_demo')], 400);
            }
        }
        catch (Exception $e)
        {
            Log::channel('single')->error($e->getMessage() . ' ' . $e->getFile());
        }
    }

}