@extends('reports.layouts.master')
@section('title')
    {{ config('fi.headerTitleText') }} | {{ trans('fi.tax_detail') }}
@stop
@section('content')

    <table>
        <tr>
            <td style="width: 25%;" valign="top">
                @if(isset($logo['image']) && $logo['image'] != null)
                    <span style="width: 100%">
                        {!! $logo['image'] !!}
                    </span>
                    <p style="margin: 2px !important;">
                        <strong style=" color: #5D6975;">{!! $logo['name'] !!}</strong>
                    </p>
                @endif
            </td>

            <td style="width: 50%;margin: 0px;padding: 0px !important;" valign="top" align="center">
                <h1 class="theme-color"
                    style="font-size: 34px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">
                    {{ trans('fi.tax_detail') }}
                </h1>
            </td>
            <td style="width: 25%; text-align: right;" valign="top">
            </td>
        </tr>
    </table>
    <br>
    <div style="width: 100%;">
        <table>
            <tr>
                <td style="width: 100%;margin: 0px;padding: 0px !important;" valign="top" align="center">
                    <h3 class="theme-color"
                        style="font-size: 26px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">
                        {{ trans('fi.taxes_collected_on_sales') }}
                    </h3>
                    <h3 class="theme-color" style="margin-top: 0; font-size: 15px;">
                        {{ $results['from_date'] }} - {{ $results['to_date'] }}
                    </h3>
                </td>
            </tr>
        </table>
        <table class="alternate" style=" font-size: 12px;">
            <thead>
            <tr>
                <th class="theme-color">{{ trans('fi.date') }}</th>
                <th class="theme-color">{{ $groupBy }}</th>
                <th class="theme-color">{{ trans('fi.client') }}</th>
                <th class="amount theme-color">{{ trans('fi.price') }}</th>
                <th class="amount theme-color">{{ trans('fi.quantity') }}</th>
                <th class="amount theme-color">{{ trans('fi.subtotal') }}</th>
                <th class="amount theme-color">{{ trans('fi.discount') }}</th>
                @foreach($results['taxNames'] as $tax)
                    <th class="amount theme-color">{{ $tax }}</th>
                @endforeach
                <th class="amount theme-color">{{ trans('fi.tax_total') }}</th>
            </tr>
            </thead>
            <tbody>
            @if(count($results['records']) == 0)
                <tr>
                    <td class="theme-color" colspan="{{ 9 + count($results['taxNames']) }}" text-align="center"
                        style="padding-top: 40;">
                        <h5>{{ trans('fi.no_records_found') }}</h5></td>
                </tr>
            @else
                @foreach ($results['records'] as $code => $itemsArray)
                    @foreach ($itemsArray as $key=>$items)

                        <tr>
                            <td colspan="{{ 9 + count($results['taxNames']) }}" text-align="center">
                                <h2 class="theme-color">
                                    {{ ($loop->first) ? trans('fi.currency').': '.$code : ''}}
                                </h2>
                                <h2>{{ $key }}</h2>
                            </td>
                        </tr>

                        @foreach ($items['items'] as $item)

                            <tr>
                                <td class="theme-color">{{ $item['date'] }}</td>
                                <td class="theme-color">{{ $item['invoice_number'] }}</td>
                                <td class="theme-color">{{ $item['client_name'] }}</td>
                                <td class="amount theme-color">{{ $item['price'] }}</td>
                                <td class="amount theme-color">{{ $item['quantity'] }}</td>
                                <td class="amount theme-color">{{ $item['subtotal'] }}</td>
                                <td class="amount theme-color">{{ $item['discount'] }}</td>
                                @foreach($results['taxNames'] as $tax)
                                    <td class="amount theme-color">{{ isset($item['tax'][$tax]) ? $item['tax'][$tax]:'' }}</td>
                                @endforeach
                                <td class="amount theme-color">{{ $item['total_tax'] }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <td class="amount theme-color" colspan="4">
                                <strong>{{ trans('fi.totals_with_dots') }}</strong></td>
                            <td class="amount theme-color"><strong>{{ $items['totals']['quantity'] }}</strong></td>
                            <td class="amount theme-color"><strong>{{ $items['totals']['subtotal'] }}</strong></td>
                            <td class="amount theme-color"><strong>{{ $items['totals']['discount'] }}</strong></td>
                            @foreach($results['taxNames'] as $tax)
                                <td class="amount theme-color">
                                    <strong>{{ isset($items['totals'][$tax]) ? $items['totals'][$tax]:'' }}</strong>
                                </td>
                            @endforeach
                            <td class="amount theme-color"><strong>{{ $items['totals']['tax'] }}</strong></td>
                        </tr>

                    @endforeach
                    <tr>
                        <td class="amount theme-color" colspan="{{ 7 + count($results['taxNames']) }}">
                            <strong>{{ trans('fi.total') }}</strong></td>
                        <td class="amount theme-color"><strong>{{ $results['grand_total_tax'][$code] }}</strong></td>
                    </tr>
                @endforeach
            @endif
            </tbody>
        </table>


        @if(count($results['expenses']) > 0)
            <div style="page-break-after: always;"></div>
            <table>
                <tr>
                    <td style="width: 100%;margin: 0px;padding: 0px !important;" valign="top" align="center">
                        <h3 class="theme-color"
                            style="font-size: 26px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">
                            {{ trans('fi.taxes_paid_on_expenses_or_remitted') }}
                        </h3>
                        <h3 class="theme-color" style="margin-top: 0; font-size: 15px;">
                            {{ $results['from_date'] }} - {{ $results['to_date'] }}
                        </h3>
                    </td>
                </tr>
            </table>
            <table class="alternate" style=" font-size: 12px;">
                <thead>
                <tr>
                    <th class="theme-color">{{ trans('fi.date') }}</th>
                    <th class="theme-color">{{ trans('fi.type') }}</th>
                    <th class="theme-color">{{ trans('fi.vendor') }}</th>
                    <th class="theme-color">{{ trans('fi.client') }}</th>
                    <th class="theme-color">{{ trans('fi.category') }}</th>
                    <th class="theme-color">{{ trans('fi.description') }}</th>
                    @foreach($results['taxNames'] as $tax)
                        <th class="amount theme-color">{{ $tax }}</th>
                    @endforeach
                    <th class="amount theme-color">{{ trans('fi.total') }}</th>
                </tr>
                </thead>
                <tbody>
                @if(count($results['records']) == 0)
                    <tr>
                        <td class="theme-color" colspan="{{ 9 + count($results['taxNames']) }}" text-align="center">
                            <h5>{{ trans('fi.no_records_found') }}</h5></td>
                    </tr>
                @else
                    @foreach ($results['expenses']['records'] as $key => $expense)
                        <tr>
                            <td class="theme-color">{{$expense['expense_date']}}</td>
                            <td class="theme-color">{!! $expense['type'] !!}</td>
                            <td class="theme-color">{{$expense['vendor']}}</td>
                            <td class="theme-color">{{$expense['client']}}</td>
                            <td class="theme-color">{{$expense['category_name']}}</td>
                            <td class="theme-color">{!! $expense['formatted_description'] !!}</td>
                            @foreach($results['taxNames'] as $tax)
                                <td class="amount theme-color">{{ ($expense['tax_name'] == $tax) ? $expense['formatted_tax_paid'] :''}}</td>
                            @endforeach
                            <td class="amount theme-color">{{$expense['formatted_tax_paid']}}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td class="amount theme-color" colspan="6">
                            <strong>{{ trans('fi.totals_with_dots') }}</strong></td>
                        </td>
                        @foreach($results['taxNames'] as $tax)
                            <td class="amount theme-color">
                                <strong>{{ isset($results['expenses']['tax'][$tax]) ? $results['expenses']['tax'][$tax] : '' }}</strong>
                            </td>
                        @endforeach
                        <td class="amount theme-color" colspan="1"><strong>{{ $results['expenses']['total'] }}</strong>
                        </td>
                    </tr>
                @endif
                </tbody>
            </table>
        @endif
    </div>
@stop

<style>
    {{ config('fi.skin') == 'dark-mode' ? iframeThemeColor() : ''  }}
</style>