@extends('reports.layouts.master')
@section('title')
    {{ config('fi.headerTitleText') }} | {{ trans('fi.profit_and_loss') }}
@stop
@section('content')

    <table>
        <tr>
            <td style="width: 25%;" valign="top">
                @if(isset($logo['image']) && $logo['image'] != null)
                    <span style="width: 100%">
                        {!! $logo['image'] !!}
                    </span>
                    <p style="margin: 2px !important;">
                        <strong style=" color: #5D6975;">{!! $logo['name'] !!}</strong>
                    </p>
                @endif
            </td>

            <td style="width: 50%;margin: 0px;padding: 0px !important;" valign="top" align="center">
                <h1 class="theme-color"
                    style="font-size: 34px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">
                    {{ trans('fi.profit_and_loss') }}</h1>
                <h3 class="theme-color" style="margin-top: 0;font-size: 15px;">{{ $results['from_date'] }}
                    - {{ $results['to_date'] }}</h3>
            </td>
            <td style="width: 25%; text-align: right;" valign="top">
            </td>
        </tr>
    </table>

    <br>
    <table class="alternate" style=" font-size: 12px;">
        <thead>
        <tr>
            <th></th>
            <th class="amount theme-color">{{ trans('fi.total') }}</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td class="theme-color" style="font-weight: bold;">{{ trans('fi.income') }}</td>
            <td class="amount theme-color" style="font-weight: bold;">{{ $results['income'] }}</td>
        </tr>
        <tr>
            <td class="theme-color" style="font-weight: bold;">{{ trans('fi.expenses') }}</td>
            <td></td>
        </tr>
        @foreach ($results['expenses'] as $category => $amount)
            <tr>
                <td class="theme-color" style="text-indent: 15px;">{{ $category }}</td>
                <td class="amount theme-color">{{ $amount }}</td>
            </tr>
        @endforeach
        <tr>
            <td class="theme-color" style="font-weight: bold;">{{ trans('fi.total_expenses') }}</td>
            <td class="amount theme-color" style="font-weight: bold;">{{ $results['total_expenses'] }}</td>
        </tr>
        <tr>
            <td class="theme-color" style="font-weight: bold;">{{ trans('fi.net_income') }}</td>
            <td class="amount theme-color" style="font-weight: bold;">{{ $results['net_income'] }}</td>
        </tr>
        </tbody>
    </table>

@stop

<style>
    {{ config('fi.skin') == 'dark-mode' ? iframeThemeColor() : ''  }}
</style>