@extends('reports.layouts.master')
@section('title')
    {{ config('fi.headerTitleText') }} | {{ trans('fi.client_statement') }}
@stop
@section('content')

    <table>
        <tr>
            <td style="width: 25%;" valign="top">
                @if(isset($logo['image']) && $logo['image'] != null)
                    <span style="width: 100%">
                        {!! $logo['image'] !!}
                    </span>
                    <p style="margin: 2px !important;">
                        <strong style=" color: #5D6975;">{!! $logo['name'] !!}</strong>
                    </p>
                @endif
            </td>

            <td style="width: 50%;" valign="top" align="center">
                <h1 class="theme-color"
                    style="font-size: 34px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">
                    {{ trans('fi.client_statement') }}</h1>
                <h3 class="theme-color"
                    style="margin-top: 0; margin-bottom: 0; font-size: 15px;">{{ trans('fi.for') .': '.$results['client_name'] }}</h3>
                <h3 class="theme-color" style="margin-top: 0; font-size: 15px;">{{ $results['from_date'] }}
                    - {{ $results['to_date'] }}</h3>
            </td>
            <td style="width: 25%; text-align: right;" valign="top">
            </td>
        </tr>
    </table>

    <br>
    <div style="width: 100%;">
        <table class="alternate" style=" font-size: 12px;">
            <thead>
            <tr>
                <th class="theme-color">{{ trans('fi.date') }}</th>
                <th class="theme-color">{{ trans('fi.invoice') }}</th>
                <th class="theme-color">{{ trans('fi.summary') }}</th>
                <th class="amount theme-color">{{ trans('fi.subtotal') }}</th>
                <th class="amount theme-color">{{ trans('fi.discount') }}</th>
                @foreach($results['taxNames'] as $tax)
                    <th class="amount theme-color">{{ $tax }}</th>
                @endforeach
                <th class="amount theme-color">{{ trans('fi.total') }}</th>
                <th class="amount theme-color">{{ trans('fi.paid') }}</th>
                <th class="amount theme-color">{{ trans('fi.balance') }}</th>
            </tr>
            </thead>
            <tbody>
            @if(count($results['records']) == 0)
                <tr>
                    <td class="theme-color" colspan="{{ 9 + count($results['taxNames']) }}" text-align="center" style="padding-top: 40;">
                        <h5>{{ trans('fi.no_records_found') }}</h5></td>
                </tr>
            @else
                @foreach ($results['records'] as $key => $records)
                    @if(count($results['records']) > 1)
                        <tr>
                            <td class="theme-color" colspan="9" text-align="center"><h2>{{ trans('fi.currency') }}
                                    : {{ $key }}</h2></td>
                        </tr>
                    @endif
                    @foreach ($records as $record)
                        <tr>
                            <td class="theme-color">{{ $record['formatted_invoice_date'] }}</td>
                            <td class="theme-color {{ $record['type'] == 'credit_memo' ? 'text-danger' : '' }}"
                                title="{{ $record['type'] == 'credit_memo' ? trans('fi.credit_memo') : '' }}">{{ $record['number'] }}</td>
                            <td>{{ $record['summary'] }}</td>
                            <td class="amount theme-color">{{ $record['formatted_subtotal'] }}</td>
                            <td class="amount theme-color">{{ $record['formatted_discount'] }}</td>
                            @foreach($results['taxNames'] as $tax)
                                <td class="amount theme-color">{{ isset($record['tax'][$tax]) ? $record['tax'][$tax]:'' }}</td>
                            @endforeach
                            <td class="amount theme-color">{{ $record['formatted_total'] }}</td>
                            <td class="amount theme-color">{{ $record['formatted_paid'] }}</td>
                            <td class="amount theme-color">{{ $record['formatted_balance'] }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="3"></td>
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['subtotal'][$key] }}</td>
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['discount'][$key] }}</td>
                        @foreach($results['taxNames'] as $tax)
                            <td class="amount theme-color"
                                style="font-weight: bold;">{{ isset($results['tax'][$key][$tax]) ? $results['tax'][$key][$tax]:'' }}</td>
                        @endforeach
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['total'][$key] }}</td>
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['paid'][$key] }}</td>
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['balance'][$key] }}</td>
                    </tr>
                @endforeach
            @endif

            </tbody>
        </table>
        @if(count($results['prepayments']) > 0)
            <div style="page-break-after: always;"></div>
            <h2 class="theme-color" style="margin-top: 0; margin-bottom: 0;">{{ trans('fi.pre_payment') }}</h2>
            <h3 class="theme-color" style="margin-top: 0;">{{ $results['from_date'] }} - {{ $results['to_date'] }}</h3>
            <br>
            <table class="alternate" style=" font-size: 12px;">
                <thead>
                <tr>
                    <th class="theme-color">{{ trans('fi.date') }}</th>
                    @for($i=0; $i < (count($results['taxNames']) + 5); $i++)
                        <th></th>
                    @endfor
                    <th class="amount theme-color">{{ trans('fi.total') }}</th>
                    <th></th>
                    <th width="10%" class="amount theme-color">{{ trans('fi.balance') }}</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($results['prepayments']['records'] as $key => $records)
                    @foreach ($records as $record)
                        <tr>
                            <td class="theme-color">{{ $record['formatted_invoice_date'] }}</td>
                            @for($i=0; $i < (count($results['taxNames']) + 5); $i++)
                                <td></td>
                            @endfor
                            <td class="amount theme-color">{{ $record['formatted_total'] }}</td>
                            <td></td>
                            <td width="10%" class="amount theme-color">{{ $record['formatted_balance'] }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td></td>
                        @for($i=0; $i < (count($results['taxNames']) + 5); $i++)
                            <td></td>
                        @endfor
                        <td class="amount theme-color" style="font-weight: bold;">{{ $results['prepayments']['total'][$key] }}</td>
                        <td class="amount theme-color"></td>
                        <td width="10%" class="amount theme-color" style="font-weight: bold;">{{ $results['prepayments']['balance'][$key] }}</td>
                    </tr>
                @endforeach

                </tbody>
            </table>
        @endif
    </div>
@stop

<style>
    {{ config('fi.skin') == 'dark-mode' ? iframeThemeColor() : ''  }}
</style>