@extends('layouts.master')

<style>
    .is-dark {
        filter: invert(83%);
    }

    .custom-invoice-padding {
        padding-top: 4px !important;
    }
</style>

@section('javascript')

    @include('layouts._daterangepicker')

    <script type="text/javascript">
        $(function () {

            initDateRangePicker('tax_report');

            initDateRangePreSelected('tax_report');

            if (document.querySelectorAll('.dark-mode').length == 1)
            {
                const iframes = document.querySelectorAll('iframe');

                for (i = 0; i < iframes.length; i++)
                {
                    iframes[i].classList.toggle('is-dark');
                }
            }

            function levelOfDetailOption()
            {
                if ($('#level_of_detail').val() == 'summary')
                {
                    $('#tax_group_by').prop('disabled', true);
                    $('#expense_type').val('').prop('disabled', true);
                    $('#date_filter_by').prop('disabled', false);
                    $('#company_profile_id').prop('disabled', false);
                }
                else
                {
                    $('#tax_group_by').prop('disabled', false);
                    $('#expense_type').val('').prop('disabled', false);
                    $('#date_filter_by').val('invoice_date').prop('disabled', true);
                    $('#exclude_unpaid_invoices').val(0).prop('disabled', false);
                    $('#company_profile_id').val('').prop('disabled', true);
                }
            }

            $('#level_of_detail').change(function () {
                levelOfDetailOption()
            });

            levelOfDetailOption();

            $('#date_filter_by').change(function () {
                if ($(this).val() == 'payment_date')
                {
                    $('#exclude_unpaid_invoices').val(1);
                    $('#exclude_unpaid_invoices').prop('disabled', 'disabled');
                }
                else
                {
                    $('#exclude_unpaid_invoices').prop('disabled', false);
                }
            });

            $('#btn-run-report').click(function () {

                var $this = $(this);
                $this.html('<i class="fa fa-circle-o-notch fa-spin"></i> ' + $this.data('loading-text')).attr("disabled", true);
                var from_date = $('#tax_report_from_date').val();
                var to_date = $('#tax_report_to_date').val();
                var exclude_unpaid_invoices = $('#exclude_unpaid_invoices').val();
                var expense_type = $('#expense_type').val();
                var company_profile_id = $('#company_profile_id').val();
                var date_filter_by = $('#date_filter_by').val();
                var level_of_detail = $('#level_of_detail').val();
                var tax_group_by = $('#tax_group_by').val();
                var invoice_with_no_tax = $('#invoice_with_no_tax').val();

                $.post("{{ route('reports.taxReport.validate') }}", {
                    from_date: from_date,
                    to_date: to_date,
                    exclude_unpaid_invoices: exclude_unpaid_invoices,
                    expense_type: expense_type,
                    company_profile_id: company_profile_id,
                    date_filter_by: date_filter_by,
                    level_of_detail: level_of_detail,
                    tax_group_by: tax_group_by,
                    invoice_with_no_tax: invoice_with_no_tax,
                }).done(function () {
                    clearErrors();
                    $('#form-validation-placeholder').html('');
                    output_type = $("input[name=output_type]:checked").val();
                    query_string = "?from_date=" + from_date + "&to_date=" + to_date + "&exclude_unpaid_invoices=" + exclude_unpaid_invoices + "&level_of_detail=" + level_of_detail + "&tax_group_by=" + tax_group_by + "&invoice_with_no_tax=" + invoice_with_no_tax;
                    if (expense_type)
                    {
                        query_string += ("&expense_type=" + expense_type);
                    }
                    if (company_profile_id)
                    {
                        query_string += ("&company_profile_id=" + company_profile_id);
                    }
                    if (date_filter_by)
                    {
                        query_string += ("&date_filter_by=" + date_filter_by);
                    }
                    if (output_type == 'preview')
                    {
                        $('#report-preview').show();
                        $('#preview-results').attr('src', "{{ route('reports.taxReport.html') }}" + query_string);
                    }
                    else if (output_type == 'pdf')
                    {
                        window.open("{{ route('reports.taxReport.pdf') }}" + query_string, '_blank');
                    }
                    else if (output_type == 'csv')
                    {
                        window.open("{{ route('reports.taxReport.csv') }}" + query_string, '_blank');
                    }
                    $this.html($this.data('original-text')).attr("disabled", false);
                }).fail(function (response) {
                    $this.html($this.data('original-text')).attr("disabled", false);
                    showAlertifyErrors($.parseJSON(response.responseText).errors);
                });
            });
        });
    </script>
@stop

@section('content')

    <section class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-6">
                    <h1><i class="fa fa-bar-chart"> </i> {{ trans('fi.tax_report') }}</h1>
                </div>
                <div class="col-6 d-none d-sm-block">
                    <ol class="breadcrumb float-sm-right">{!!  breadcrumbs() !!}</ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">

        <div class="container-fluid">

            @include('layouts._alerts')

            <div id="form-validation-placeholder"></div>

            <div class="row">

                <div class="col-md-12">

                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{ trans('fi.options') }}</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool mt-0" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.company_profile') }}:</label>
                                        {!! Form::select('company_profile_id', $companyProfiles, null, ['id' => 'company_profile_id', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.date_range') }}:</label>
                                        {!! Form::hidden('from_date', null, ['id' => 'tax_report_from_date']) !!}
                                        {!! Form::hidden('to_date', null, ['id' => 'tax_report_to_date']) !!}
                                        {!! Form::text('date_range', null, ['id' => 'tax_report_date_range', 'class' => 'form-control form-control-sm', 'readonly' => 'readonly','placeholder'=>trans('fi.filter_by_date')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.level_of_detail') }}:</label>
                                        {!! Form::select('level_of_detail', ['summary' => trans('fi.summary'), 'detail' => trans('fi.detail')], null, ['id' => 'level_of_detail', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.date_filter_by') }}:</label>
                                        {!! Form::select('date_filter_by', $date_filter_by, null, ['id' => 'date_filter_by', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.unpaid_invoices') }}:</label>
                                        {!! Form::select('exclude_unpaid_invoices', ['0' => trans('fi.include'), '1' => trans('fi.exclude')], null, ['id' => 'exclude_unpaid_invoices', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.expense_type') }}:</label>
                                        {!! Form::select('expense_type', $expenseType, null, ['id' => 'expense_type', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.invoice_with_no_tax') }}:</label>
                                        {!! Form::select('invoice_with_no_tax', ['0' => trans('fi.include'), '1' => trans('fi.exclude')], null, ['id' => 'invoice_with_no_tax', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{ trans('fi.group_by') }}:</label>
                                        {!! Form::select('tax_group_by', ['item' => trans('fi.item'),'invoice' => trans('fi.invoice')], null, ['id' => 'tax_group_by', 'class' => 'form-control form-control-sm'])  !!}
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group clearfix">
                                        <label>{{ trans('fi.output_type') }}:</label><br>

                                        <div class="form-check d-inline mr-3">
                                            <input class="form-check-input" type="radio" name="output_type"
                                                   value="preview" checked="checked" id="preview">
                                            <label class="form-check-label"
                                                   for="preview">{{ trans('fi.preview') }}</label>
                                        </div>
                                        <div class="form-check d-inline mr-3">
                                            <input class="form-check-input" type="radio" name="output_type" value="pdf"
                                                   id="pdf">
                                            <label class="form-check-label" for="pdf">{{ trans('fi.pdf') }}</label>
                                        </div>
                                        <div class="form-check d-inline">
                                            <input class="form-check-input" type="radio" name="output_type" value="csv"
                                                   id="csv">
                                            <label class="form-check-label" for="csv">{{ trans('fi.csv') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1 offset-md-4 text-right">
                                    <button class="btn btn-sm btn-primary mt-4"
                                            data-loading-text="{{ trans('fi.preparing') }}"
                                            data-original-text="{{ trans('fi.run_report') }}" id="btn-run-report">
                                        {{ trans('fi.run_report') }}
                                    </button>
                                </div>

                            </div>

                        </div>

                    </div>
                </div>

            </div>

            <div class="row" id="report-preview" style="display: none;">
                <div class="col-md-12">
                    <div class="card card-primary card-outline">
                        <div class="card-body">
                            <iframe src="about:blank" id="preview-results" frameborder="0" style="width: 100%;"
                                    scrolling="yes" onload="resizeIframe(this, 500);"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>

@stop