<script type="text/javascript">

    $(function () {

        var mainDiscountType = $('#main-discount-type').iconpicker().iconpicker('setSearch', false).iconpicker('setRows', 1);

        mainDiscountType.iconpicker('setIconset', {
            iconClass: 'fa',
            icons: [
                'fa-ban',
                'fa-percentage',
                'fa-money-bill',
            ]
        });

        function findClassInIconPicker($this)
        {
            var iconName = $this.children('input').val();
            if (iconName == 'fa-percentage')
            {
                return 'percentage';
            }
            else if (iconName == 'fa-money-bill')
            {
                return 'flat_amount';
            }
            else
            {
                return '';
            }

        }

        $('#main-discount-type').iconpicker().on('change', function () {
            var val = $(this).children('input').val();
            if (val == 'fa-ban')
            {
                $('#discount').val('').attr('disabled', true);
            }
            else
            {
                $('#discount').attr('disabled', false);
            }
        });
        $(document).off('click', '.revision-doc-preview').on('click', '.revision-doc-preview', function () {
            let id = $(this).data('id');

            $('#modal-placeholder').load('{!! route('document.revision.view.modal') !!}', {
                    id: id,
                },
                function (response, status, xhr) {
                    if (status == "error")
                    {
                        var response = JSON.parse(response);
                        alertify.error(response.message);
                    }
                }
            );
        });
        var mainDiscountTypeIcon = $("#main-discount-type").data('icon');

        iconClassSet($("#main-discount-type"), mainDiscountTypeIcon);

        function iconClassSet($this, mainDiscountTypeIcon)
        {
            switch (mainDiscountTypeIcon)
            {
                case 'fa-money-bill':
                    $this.iconpicker('setIcon', 'fa-money-bill');
                    break;
                case 'fa-percentage':
                    $this.iconpicker('setIcon', 'fa-percentage');
                    break;
                default:
                    $this.iconpicker('setIcon', 'fa-ban');
                    $('#discount').val('').attr('disabled', true);
            }
        }

        $("#next_date").datetimepicker({autoclose: true, format: dateFormat});
        $("#stop_date").datetimepicker({autoclose: true, format: dateFormat});
        $('#invoice-tags').select2({tags: true, tokenSeparators: [",", " "]});

        var recurring_period = $('#recurring_period').find(":selected").val();
        var daysAndWeeksDays = @json($daysAndWeeksDays);
        var monthDays = @json($monthDays);
        var yearDays = @json($yearDays);
        var serviceStartsOfTheMonth = @json($serviceStartsOfTheMonth);
        var serviceStartsOfTheYear = @json($serviceStartsOfTheYear);

        if (recurring_period == 1 || recurring_period == 2)
        {
            $('#service-ends-of-the').find('option').remove().end();
            $('#service-ends-of-the').attr("disabled", true);
            subscriptionServiceAppendOptions(daysAndWeeksDays, 'service-starts-on');
        }
        else if (recurring_period == 3)
        {
            $('#service-ends-of-the').attr("disabled", false);
            subscriptionServiceAppendOptions(serviceStartsOfTheMonth, 'service-ends-of-the');
            subscriptionServiceAppendOptions(monthDays, 'service-starts-on');
        }
        else if (recurring_period == 4)
        {
            $('#service-ends-of-the').attr("disabled", false);
            subscriptionServiceAppendOptions(serviceStartsOfTheYear, 'service-ends-of-the');
            subscriptionServiceAppendOptions(yearDays, 'service-starts-on');
        }
        else
        {
            $('#service-ends-of-the').find('option').remove().end();
            $('#service-ends-of-the').attr("disabled", true);
            subscriptionServiceAppendOptions(daysAndWeeksDays, 'service-starts-on');
        }

        $('.data-changes-check').data('serialize', $('.data-changes-check').serializeFormJSON());
        var beforeunload = false;


        $(window).bind('beforeunload', function (e) {
            const formData1 = $('.data-changes-check').data('serialize');
            const formData2 = $('.data-changes-check').serializeFormJSON();
            const areFormObjectsEqual = matchDataRI(formData1, formData2);

            if (!areFormObjectsEqual || !filesChecks)
            {
                return true;
            }

        });

        function matchDataRI(formData1, formData2)
        {
            const currentSerializedFormData1 = JSON.stringify(formData1);
            const currentSerializedFormData2 = JSON.stringify(formData2);
            const currentFormData1 = JSON.parse(currentSerializedFormData1);
            const currentFormData2 = JSON.parse(currentSerializedFormData2);
            delete currentFormData1.service_ends;
            delete currentFormData2.service_ends;
            delete currentFormData1.service_starts;
            delete currentFormData2.service_starts;
            delete currentFormData1.recurring_invoice_id;
            delete currentFormData2.recurring_invoice_id;

            delete currentFormData1.service_starts;
            delete currentFormData2.service_starts;


            if (subscriptionSave)
            {
                delete currentFormData1.service_ends_of_the;
                delete currentFormData1.service_explanation;
                delete currentFormData1.service_starts_on;
                delete currentFormData1.stop_date;
                delete currentFormData1.next_date;
                delete currentFormData1.recurring_frequency;
                delete currentFormData1.recurring_period;

                delete currentFormData2.service_ends_of_the;
                delete currentFormData2.service_explanation;
                delete currentFormData2.service_starts_on;
                delete currentFormData2.stop_date;
                delete currentFormData2.next_date;
                delete currentFormData2.recurring_frequency;
                delete currentFormData2.recurring_period;

            }


            return areObjectsEqual(currentFormData1, currentFormData2, false);
        }

        $('#btn-create-live-invoice').click(function (event) {

            const formData1 = $('.data-changes-check').data('serialize');
            const formData2 = $('.data-changes-check').serializeFormJSON();
            const areFormObjectsEqual = matchDataRI(formData1, formData2);

            if (!areFormObjectsEqual || !filesChecks)
            {
                beforeunload = true;
            }
            else
            {
                beforeunload = false;
            }
            if (beforeunload)
            {
                var confirmationMessage = '{!! trans('fi.confirm_approve_leave_page') !!}';
                if (!confirm(confirmationMessage))
                {
                    event.preventDefault();
                    event.stopPropagation();
                }
                else
                {
                    beforeunload = false;
                }
            }
            if (!beforeunload)
            {
                $('#modal-placeholder').load('{!! route('recurring.invoice.create.live.invoice.modal') !!}', {
                        id: $(this).data('id'),
                        editMode: true
                    },
                    function (response, status, xhr) {
                        if (status == "error")
                        {
                            var response = JSON.parse(response);
                            alertify.error(response.message);
                        }
                    }
                );


            }
        });

        $('body').on('change', '.item-lookup', function () {
            var row = $(this).closest('tr');
            row.find('.lbl_item_lookup > .update_item_lookup').prop("checked", false);
        });

        $('body').on('change', 'textarea[name="description"],input[name="price"],select[name="tax_rate_id"],select[name="tax_rate_2_id"]', function () {
            var row = $(this).closest('tr');
            row.find('.lbl_item_lookup').show();
            if (!row.find('.lbl_item_lookup > .update_item_lookup').prop("checked") && typeof row.find('.item-lookup option:selected').val() != "undefined" && row.find('.item-lookup option:selected').val() != row.find('.item-lookup option:selected').text())
            {
                row.find('.lbl_item_lookup').show().html('<input type="checkbox" class="update_item_lookup" name="save_item_as_lookup" tabindex="999"> {{ trans('fi.update_item_as_lookup') }}');
            }
        });

        $('#btn-copy-recurring-invoice').click(function () {
            $('#modal-placeholder').load('{{ route('recurringInvoiceCopy.create') }}', {
                recurring_invoice_id: '{{ $recurringInvoice->id }}'
            });
        });

        $('#btn-update-exchange-rate').click(function () {
            $('.update-exchange').addClass('fa-spin')
            setTimeout(function () {
                $('.update-exchange').removeClass('fa-spin')
            }, 1500);
            updateExchangeRate();
        });

        $('#currency_code').change(function () {
            updateExchangeRate();
        });

        function updateExchangeRate()
        {

            if ($('#currency_code').val() != '{{ config('fi.baseCurrency') }}')
            {
                $('#currency_code, #exchange_rate').css('background', '#fff8dc');
            }
            else
            {
                $('#currency_code, #exchange_rate').css('background', 'none');
            }

            $.post('{{ route('currencies.getExchangeRate') }}', {
                currency_code: $('#currency_code').val()
            }, function (data) {
                $('#exchange_rate').val(data);
            });
        }

        $('.btn-save-recurring-invoice').click(function () {
            var items = [];
            var files = [];
            var display_order = 1;
            var custom_fields = {};
            var recurring_invoice_data = {};
            var apply_exchange_rate = $(this).data('apply-exchange-rate');
            var form_data;
            var selectCustomRadioButtonValue = null;
            var selectItemCustomRadioButtonValue = null;
            var $this = $(this);

            $this.html('<i class="fa fa-circle-o-notch fa-spin"></i> ' + $this.data('loading-text')).attr("disabled", true);

            $('table tr.item').each(function () {
                let name = ($(this).find('select[name="name"] option:selected').eq(0).text());
                let price = ($(this).find('input[name="price"]').eq(0).val());
                if (name)
                {
                    var row = {};
                    $(this).find('.regular-fields').find('text,input,select,textarea').each(function () {
                        if ($(this).attr('name') !== undefined)
                        {
                            if ($(this).is(':checkbox'))
                            {
                                if ($(this).is(':checked'))
                                {
                                    row[$(this).attr('name')] = 1;
                                }
                                else
                                {
                                    row[$(this).attr('name')] = 0;
                                }
                            }
                            else
                            {
                                if ($(this).attr('name') == 'name')
                                {
                                    row[$(this).attr('name')] = name;
                                }
                                else
                                {
                                    row[$(this).attr('name')] = $(this).val();
                                }
                            }
                        }
                    });
                    if ($(this).find('.custom-fields-table').length)
                    {
                        row["custom"] = {};
                    }
                    $(this).find('.custom-fields-table').find('text,input,select,textarea').each(function () {
                        var fieldName = $(this).data("recurring_invoice_items-field-name");
                        var inputType = $(this).attr('type') || this.tagName.toLowerCase();
                        if (fieldName !== undefined)
                        {
                            if ('file' === inputType)
                            {
                                row["custom"][fieldName] = typeof this.files[0] === 'undefined' ? '' : this.files[0];
                                return true;
                            }
                            if ('select' === inputType)
                            {
                                if ($(this).find('option:selected').length == 0)
                                {
                                    row["custom"][fieldName] = '';
                                    return true;
                                }
                            }
                            if ('checkbox' === inputType)
                            {
                                row["custom"][fieldName] = ($(this).is(":checked")) ? 1 : 0;
                                return true;
                            }
                            if ('radio' === inputType)
                            {
                                if ($(this).prop('checked') == true)
                                {
                                    row["custom"][fieldName] = $(this).val();
                                    selectItemCustomRadioButtonValue = $(this).val();
                                }
                                if ($(this).prop('checked') == false && selectItemCustomRadioButtonValue == null)
                                {
                                    row["custom"][fieldName] = 'null';
                                }
                                if ($(this).prop('checked') == false)
                                {
                                    selectItemCustomRadioButtonValue = null;
                                }
                                return row["custom"][fieldName];
                            }
                            row["custom"][$(this).data("recurring_invoice_items-field-name")] = $(this).val();
                        }

                    });
                    row['display_order'] = display_order;
                    display_order++;
                    items.push(row);
                }
            });

            $('.custom-file-input,.form-check-input,.custom-form-field').each(function () {
                var fieldName = $(this).data('recurring_invoices-field-name');
                var inputType = $(this).attr('type') || this.tagName.toLowerCase();

                if (fieldName !== undefined)
                {
                    if ('file' === inputType)
                    {
                        custom_fields[fieldName] = typeof this.files[0] === 'undefined' ? '' : this.files[0];

                        return true;
                    }

                    if ('select' === inputType)
                    {
                        if ($(this).find('option:selected').length == 0)
                        {
                            custom_fields[fieldName] = '';
                            return true;
                        }
                    }
                    if ('radio' === inputType)
                    {
                        if ($(this).prop('checked') == true)
                        {
                            custom_fields[fieldName] = $(this).val();
                            selectCustomRadioButtonValue = $(this).val();
                        }
                        if ($(this).prop('checked') == false && selectCustomRadioButtonValue == null)
                        {
                            custom_fields[fieldName] = 'null';
                        }
                        return custom_fields[fieldName];
                    }

                    if ('checkbox' === inputType)
                    {
                        custom_fields[fieldName] = ($(this).is(":checked")) ? 1 : 0;
                        return true;
                    }
                    custom_fields[fieldName] = $(this).val();
                }
            });
            recurring_invoice_data['recurring_invoice_id'] = $('#recurring_invoice_id').val();
            recurring_invoice_data['custom_module'] = $('#custom_module').val();
            recurring_invoice_data['custom_items_module'] = $('#custom_items_module').val();
            recurring_invoice_data['items'] = items;
            recurring_invoice_data['terms'] = $('#terms').val();
            recurring_invoice_data['footer'] = $('#footer').val();
            recurring_invoice_data['currency_code'] = $('#currency_code').val();
            recurring_invoice_data['exchange_rate'] = $('#exchange_rate').val();
            recurring_invoice_data['custom'] = custom_fields;
            recurring_invoice_data['apply_exchange_rate'] = typeof apply_exchange_rate === 'undefined' ? '' : apply_exchange_rate;
            recurring_invoice_data['template'] = $('#template').val();
            recurring_invoice_data['summary'] = $('#summary').val();
            recurring_invoice_data['discount'] = $('#discount').val();
            recurring_invoice_data['document_number_scheme_id'] = $('#document_number_scheme_id').val();
            recurring_invoice_data['custom_files'] = files;
            recurring_invoice_data['tags'] = $('#invoice-tags').val();
            recurring_invoice_data['discount_type'] = findClassInIconPicker($('#main-discount-type'));
            recurring_invoice_data['payment_terms_id'] = $('#payment-terms-id').val();
            recurring_invoice_data['online_payment_processing_fee'] = $('#online_payment_processing_fee').val();

            form_data = objectToFormData(recurring_invoice_data);

            let finalTotal = checkInvoiceTotalLessThenZero(recurring_invoice_data['items'], '{{$recurringInvoice->currency_code}}');
            if (finalTotal >= 0)
            {
                $.ajax({
                    url: '{{ route('recurringInvoices.update', [$recurringInvoice->id]) }}',
                    method: 'post',
                    data: form_data,
                    processData: false,
                    async: false,
                    contentType: false,
                    success: function (data) {
                        if (data.error)
                        {
                            alertify.error(data.error, 5);
                        }
                    },
                }).done(function () {
                    $('#div-recurring-invoice-edit').load('{{ route('recurringInvoiceEdit.refreshEdit', [$recurringInvoice->id]) }}', function () {
                        alertify.success('{{ trans('fi.record_successfully_updated') }}', 5);

                        var settings = {
                            placeholder: '{{ trans('fi.select-item') }}',
                            allowClear: true,
                            tags: true,
                        };

                        // Make all existing items select
                        $('.item-lookup').select2(settings);
                        itemLookupTabFunctionality(settings);
                    });
                    $this.html($this.data('original-text')).attr("disabled", false);
                }).fail(function (response) {
                    $this.html($this.data('original-text')).attr("disabled", false);
                    $.each($.parseJSON(response.responseText).errors, function (id, message) {
                        alertify.error(message[0], 5);
                    });
                });
            }
            else
            {
                $this.html($this.data('original-text')).attr("disabled", false);
                alertify.error('{{trans('fi.total_cannot_be_lt_zero',['modal_name'=>trans('fi.recurring_invoice')])}}', 5);
            }
        });

        var fixHelper = function (e, tr) {
            var $originals = tr.children();
            var $helper = tr.clone();
            $helper.children().each(function (index) {
                $(this).width($originals.eq(index).width())
            });
            return $helper;
        };

        $("#item-table tbody").sortable({
            helper: fixHelper
        });

        $('.btn-delete-custom-img').click(function () {
            let $this = $(this);
            let ItemCustomId = $(this).closest('.custom-fields-table').siblings('.main-table').data('item-custom-id');
            let url = "{{ route('recurringInvoiceEdit.deleteImage', [$recurringInvoice->id,'field_name' => '']) }}";
            $.post(url + '/' + $(this).data('field-name'), {'item_custom_id': ItemCustomId}).done(function () {
                $this.closest('.custom_img').html('');
            });
        });

        $('.btn-delete-recurring-invoice').click(function () {

            $('#modal-placeholder').load('{!! route('recurring.invoice.delete.modal') !!}', {
                    action: '{{ route('recurringInvoices.delete', [$recurringInvoice->id]) }}',
                    modalName: 'recurring-invoice',
                    isReload: true,
                    returnURL: '{{route('recurringInvoices.index')}}'
                },
                function (response, status, xhr) {
                    if (status == "error")
                    {
                        var response = JSON.parse(response);
                        alertify.error(response.message);
                    }
                }
            );
        });

        $(document).off('click', '.btn-delete-recurring-invoice-item').on('click', '.btn-delete-recurring-invoice-item', function () {
            var id = $(this).data('item-id');
            if (typeof id === 'undefined')
            {
                $(this).closest('tr').remove();
                var key = $('#item-table > tbody > tr').length;
                key = (parseInt(key));
                if (key <= 1)
                {
                    $('.footer-btn-add-item').hide();
                }
            }
            else
            {
                $(this).addClass('delete-recurring-invoice-item-active');

                $('#modal-placeholder').load('{!! route('recurring.invoice.item.delete.modal') !!}', {
                        itemId: id,
                        isReload: false,
                        modalName: 'recurring-invoice-item',
                        recurringInvoiceId: '{{ $recurringInvoice->id }}',
                        action: '{{ route('recurringInvoiceItem.delete') }}',
                        refreshURL: '{{ route('recurringInvoiceEdit.refreshTotals') }}',
                    },
                    function (response, status, xhr) {
                        if (status == "error")
                        {
                            var response = JSON.parse(response);
                            alertify.error(response.message);
                        }
                    }
                );
            }

        });

        $('body').off('change', '.quantity,.price').on('change', '.quantity,.price', function () {
            invoiceAndQuoteDiscountItemTotal($(this), 'other');
        });


        $(document).on('change', '.description', function () {
            $(this).css('border-color', '#007bff');
        });


        $('#recurring_period').change(function () {

            if ($(this).val() == 3)
            {
                $('#service-ends-of-the').attr("disabled", false);
                subscriptionServiceAppendOptionsSecondTime(serviceStartsOfTheMonth, 'service-ends-of-the');
                subscriptionServiceAppendOptionsSecondTime(monthDays, 'service-starts-on');
            }
            else if ($(this).val() == 4)
            {
                $('#service-ends-of-the').attr("disabled", false);
                subscriptionServiceAppendOptionsSecondTime(serviceStartsOfTheYear, 'service-ends-of-the');
                subscriptionServiceAppendOptionsSecondTime(yearDays, 'service-starts-on');
            }
            else
            {
                $('#service-ends-of-the').find('option').remove().end();
                $('#service-ends-of-the').attr("disabled", true);
                subscriptionServiceAppendOptionsSecondTime(daysAndWeeksDays, 'service-starts-on');
            }
            ajaxGetStartAndEndDates();
        });

        $('#recurring_frequency, #service-starts-on,#recurring_frequency,#service-ends-of-the').change(function () {
            ajaxGetStartAndEndDates();
        });

        $("#next_date").on("change.datetimepicker", () => {
            ajaxGetStartAndEndDates();
            compareSubscription();
        });

        function subscriptionServiceAppendOptions(options, id)
        {
            $('#' + id).find('option').remove().end();
            $.each(options, function (key, value) {
                if ('{{$recurringInvoice->service_starts_on}}' != null && '{{$recurringInvoice->service_starts_on}}' == key)
                {
                    $('#' + id).append($("<option></option>").attr('selected', 'selected').attr("value", key).text(value));
                }
                else if ('{{$recurringInvoice->service_ends_of_the}}' != null && '{{$recurringInvoice->service_ends_of_the}}' == key)
                {
                    $('#' + id).append($("<option></option>").attr('selected', 'selected').attr("value", key).text(value));
                }
                else
                {
                    $('#' + id).append($("<option></option>").attr("value", key).text(value));
                }
            });
        }

        function subscriptionServiceAppendOptionsSecondTime(options, id)
        {
            $('#' + id).find('option').remove().end();
            $.each(options, function (key, value) {
                $('#' + id).append($("<option></option>").attr("value", key).text(value));
            });
        }

        ajaxGetStartAndEndDates();

        function ajaxGetStartAndEndDates()
        {
            $.post('{{route('recurring.invoice.get.service.dates')}}',
                {
                    next_date: $("#generate_next_date").val(),
                    recurring_frequency: $('#recurring_frequency').find(":selected").val(),
                    recurring_period: $('#recurring_period').find(":selected").val(),
                    service_starts_on: $('#service-starts-on').find(":selected").val(),
                    service_ends_of_the: $('#service-ends-of-the').find(":selected").val(),
                }).done(function (responce) {
                $('#service-starts').val(responce.service_start_date);
                $('#service-ends').val(responce.service_end_date);
                $('#service-starts,#service-ends').animate({
                    opacity: 0.7,
                    color: '#000000',
                    fontSize: '20px',
                }, 500, function () {
                    $('#service-starts,#service-ends').animate({
                        opacity: 1,
                        color: '#495057',
                        fontSize: '.875rem',
                    }, 500);
                });
            }).fail(function (response) {
                alertify.error($.parseJSON(response.responseText).message, 5);
            });
        }

        $('.btn-save-subscription').hide();
        const prepareSubscriptionArray = () => {
            return {
                "recurring_frequency": $('#recurring_frequency').val(),
                "recurring_period": $('#recurring_period').val(),
                "next_date": $('#generate_next_date').val(),
                "stop_date": $("input[name=stop_date]").val(),
                "service_explanation": $('#service-explanation').val(),
                "service_starts_on": $('#service-starts-on').val(),
                "service_ends_of_the": $('#service-ends-of-the').val(),
            }
        }
        var subscriptionData = prepareSubscriptionArray();

        const compareSubscription = () => {
            var currentSubscriptionData = prepareSubscriptionArray();
            if (JSON.stringify(currentSubscriptionData) != JSON.stringify(subscriptionData))
            {
                $('.btn-save-subscription').show()
                $('.recurring_invoices-save').hide();
            }
            else
            {
                $('.btn-save-subscription').hide()
                $('.recurring_invoices-save').show();
            }
        }

        $('.subscription-data input, .subscription-data select, .subscription-data textarea').change(function () {
            compareSubscription();
        });

        $("#stop_date").on("change.datetimepicker", () => {
            compareSubscription();
        });

        var subscriptionSave = false;

        $('.btn-save-subscription').click(function () {
            subscriptionSave = true;
            $.post($(this).data('action'),
                prepareSubscriptionArray())
                .done(function () {
                    $('#div-recurring-invoice-edit').load('{{ route('recurringInvoiceEdit.refreshEdit', [$recurringInvoice->id]) }}', function () {
                        alertify.success('{{ trans('fi.record_successfully_updated') }}', 5);

                        var settings = {
                            placeholder: '{{ trans('fi.select-item') }}',
                            allowClear: true,
                            tags: true,
                        };

                        // Make all existing items select
                        $('.item-lookup').select2(settings);
                        itemLookupTabFunctionality(settings);
                    });
                }).fail(function (response) {
                alertify.error($.parseJSON(response.responseText).message, 5);
            });
        });
    });

</script>
