<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\RecurringInvoices\Requests;

use FI\Traits\CustomFieldValidator;

class RecurringSubscriptionsDataUpdateRequest extends RecurringInvoiceStoreRequest
{
    use CustomFieldValidator;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'next_date'           => 'required_without:stop_date',
            'recurring_frequency' => 'numeric|required',
            'recurring_period'    => 'required',
        ];
    }
}