<script type="text/javascript">

    $(function () {

        $('#create-quote').modal();

        $('#create-quote').on('shown.bs.modal', function () {
            $("#create_client_name").focus();
        });

        $('.modal-create-quote-close').click(function () {
            $('.btn-action-modal').removeClass('disabled');
        });

        $("#create_quote_date").datetimepicker({autoclose: true, format: dateFormat, defaultDate: new Date()});

        @can('quotes.create')
        $('#quote-create-confirm').click(function () {
            var $this = $(this);
            $this.attr('disabled', true);
            $.post('{{ route('quotes.store') }}', {
                user_id: $('#user_id').val(),
                company_profile_id: $('#company_profile_id').val(),
                client_id: $('#create_client_name').val(),
                quote_date: $('#create_quote_date').children().val(),
                document_number_scheme_id: $('#create_document_number_scheme_id').val(),
                payment_term_id: $('#payment-terms-create-id').val(),
            }).done(function (response) {
                window.location = '{{ url('quotes') }}' + '/' + response.id + '/edit';
            }).fail(function (response) {
                $this.attr('disabled', false);
                showAlertifyErrors($.parseJSON(response.responseText).errors);
            });
        });

        $(document).off('click', ".create-client").on("click", ".create-client", function () {

            var select2_value = $(this).closest('.select2-results').prev().children().val();
            var client_name = (select2_value != null && select2_value != 'undefined') ? select2_value : null;
            $('#modal-quote-client-create').load('{!! route('quotes.client.create.modal') !!}', {
                client_name: client_name,
                type: 'create'
            })
        });

        $(document).on('change', '#create_client_name', function () {
            var client_id = $(this).val();

            if (client_id)
            {
                var item_lookup_data = {};
                item_lookup_data['client_id'] = client_id;

                $.ajax({
                    url: "{{ route('clients.ajax.getCompanyProfileIdByClientId') }}",
                    method: 'post',
                    data: item_lookup_data,
                    beforeSend: function () {
                        $(".modal-loader").show();
                    },
                    success: function (response) {
                        $(".modal-loader").hide();
                        $('.quote_model_company_profile_id option[value=' + response.company_profile_id + ']').prop("selected", true);

                        if (response.payment_term_id != '')
                        {
                            $(".payment-terms-create-id").val(response.payment_term_id).trigger('change');
                        }
                        else
                        {
                            $('#company_profile_id').trigger('change');
                        }
                    }
                });
            }
        });
        @endcan

        var settings = {
            placeholder: '{{ trans('fi.select_payment_term') }}',
            allowClear: true,
            escapeMarkup: function (markup) {
                return markup;
            }
        };

        $('.payment-terms-create-id').select2(settings);

        $('#company_profile_id').change(function () {
            $.post('{{ route('company.profiles.get.payment.term') }}', {
                company_profile_id: $('#company_profile_id').val(),
            }).done(function (response) {
                $(".payment-terms-create-id").val(response.id).trigger('change');
            }).fail(function (response) {
                showAlertifyErrors($.parseJSON(response.responseText).errors);
            });
        });

    });
</script>