<tr id="new-item">
    <td class="handle"><i class="fa fa-sort"></i></td>

    <td colspan="{{ $allowLineItemDiscounts == true ? 6 : 5 }}" class="no-padding col-12">

        <table class="table main-table table-hover table-borderless no-padding regular-fields">
            <tr>
                <td class="{{ $allowLineItemDiscounts == true ? 'col-4 cw-33' : 'col-6 cw-50' }} copy-to-clipboard-hover">
                    {!! Form::hidden('quote_id', $quote_id) !!}
                    {!! Form::hidden('id', '') !!}
                    {!! Form::hidden('item_lookup_id',null,['data-item-lookUp-id' => '']) !!}
                    {!! Form::hidden('data_custom_item_delete','yes') !!}
                    {!! itemLookUpsDropDown() !!}
                    <i class="float-right p-2 fa fa-copy copy-icon-btn d-none" title="{{trans('fi.copy')}}"></i>
                    <label class="lbl_item_lookup">
                        <input type="checkbox" class="update_item_lookup" name="save_item_as_lookup" tabindex="999">
                        {{ trans('fi.save_item_as_lookup') }}
                    </label>

                    {!! Form::textarea('description', null, ['class' => 'description form-control form-control-sm mt-1 description-cw add-right-margin', 'rows' => 3, 'placeholder' => trans('fi.description')]) !!}
                </td>
                <td class="col-1 cw-8 w-100">{!! Form::text('quantity', null, ['class' => 'form-control form-control-sm quantity quantity-cw', 'data-field'=>'quantity', 'placeholder' => trans('fi.quantity')]) !!}</td>
                <td class="col-2 cw-16 w-100">{!! Form::text('price', null, ['class' => 'form-control form-control-sm price price-cw', 'data-currency'=> $currencyCode, 'data-field'=>'price', 'placeholder' => trans('fi.price')]) !!}</td>
                @if($allowLineItemDiscounts == true)
                    <td class="col-2 cw-16 min-width-185">
                        <div class="row">
                            <button name="discount_type"
                                    type="button"
                                    class="btn btn-sm btn-light discount-action-invoice-lookup discount-action col-4 ml-1"
                                    role="iconpicker"
                                    data-placement="top"
                                    data-header="false"
                                    data-footer="false"
                                    data-icon="fa-ban">
                            </button>
                            {!! Form::text('discount', null, ['class' => 'form-control form-control-sm discount col-7 d-none ml-1 discount-sm','placeholder' => trans('fi.discount-amount')]) !!}
                        </div>

                    </td>

                @endif
                <td class="col-1 cw-8">
                    {!! Form::select('tax_rate_id', $taxRates, config('fi.itemTaxRate'), ['class' => 'form-control form-control-sm tax-cw']) !!}
                    @if(config('fi.numberOfTaxFields') == '2')
                        {!! Form::select('tax_rate_2_id', $taxRates, config('fi.itemTax2Rate'), ['class' => 'form-control form-control-sm mt-1 tax-cw']) !!}
                    @endif

                </td>
                <td class="col-2 cw-16 item-subtotal text-center subtotal-cw"></td>
            </tr>
        </table>

        @if ($quoteItemCustomFields)
            @include('custom_fields._custom_fields_unbound_quote_items', ['object' => new \FI\Modules\Quotes\Models\QuoteItem(), 'customFields' => $quoteItemCustomFields ,'key' => $key ])
        @endif

    </td>
    <td>
        <a class="btn btn-sm btn-danger btn-delete-quote-item"
           href="javascript:void(0);" title="{{ trans('fi.delete') }}">
            <i class="fa fa-times"></i>
        </a>
    </td>
</tr>

<script>
    $(function () {
        $('.discount-action').iconpicker({
            rows: 1,
        }).iconpicker('setIconset', {
            iconClass: 'fas',
            icons: [
                'fa-ban',
                'fa-percentage',
                'fa-money-bill',
            ]
        }).iconpicker('setSearch', false);

        $('.discount-action-invoice-lookup').iconpicker().on('change', function (e) {
            invoiceAndQuoteDiscountItemTotal($(this), 'discount-type');
        });
    });

</script>
