<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Quotes\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Clients\Models\Client;
use FI\Modules\CompanyProfiles\Models\CompanyProfile;
use FI\Modules\DocumentNumberSchemes\Models\DocumentNumberScheme;
use FI\Modules\PaymentTerms\Models\PaymentTerm;
use FI\Modules\Quotes\Models\Quote;
use FI\Modules\Quotes\Requests\QuoteStoreRequest;
use FI\Support\DateFormatter;
use Illuminate\Support\Facades\Gate;

class QuoteCreateController extends Controller
{
    public function create()
    {
        $cp = CompanyProfile::where('is_default', 1)->first();

        return view('quotes._modal_create')
            ->with('companyProfiles', CompanyProfile::getList())
            ->with('clients', Client::getDropDownList())
            ->with('documentNumberSchemes', DocumentNumberScheme::getList())
            ->with('paymentTerms', PaymentTerm::getDropDownList())
            ->with('defaultPaymentTerms', (isset($cp->payment_term_id) && !empty($cp->payment_term_id)) ? $cp->payment_term_id : config('fi.defaultPaymentTerms'))
            ->with('isClientCreate', Gate::check('clients.create'));
    }

    public function store(QuoteStoreRequest $request)
    {
        $input = $request->except('client_id');

        $input['user_id'] = auth()->user()->id;

        $client = Client::find($request->input('client_id'));
        if (false === $client)
        {
            return response()->json(['errors' => [[trans('fi.no_auth_to_create_client')]]], 403);
        }
        $input['client_id'] = $client->id;

        $input['quote_date']       = DateFormatter::unformat($input['quote_date']);
        $input['is_payable_quote'] = config('fi.isPayableQuote', 0);

        if (($client->online_payment_processing_fee == 'yes' && config('fi.enableOppFees', 'no') == 1) || ($client->online_payment_processing_fee == 'default' && config('fi.enableOppFees', 'no') == 1))
        {
            $input['online_payment_processing_fee'] = 'yes';
        }

        $quote = Quote::create($input);

        return response()->json(['id' => $quote->id], 200);
    }
}