@can('payments.update')
    <script type="text/javascript">
        $(function () {
            $('.email-payment-receipt').click(function () {
                $('#modal-placeholder').load("{{ route('paymentMail.create') }}", {
                    payment_id: $(this).data('payment-id'),
                    redirectTo: $(this).data('redirect-to')
                }, function (response, status, req) {
                    if (status == 'error')
                    {
                        alertify.error('{{ trans('fi.problem_with_email_template') }}', 5);
                    }
                });
            });
            $('.invoice-data-toggle-btn').on('click', function () {
                $('.invoice-data-toggle').toggle("slow")
            });
        });
    </script>
@endcan
<style>
    .invoice-col-data {
        min-width: 120px !important;
    }

    .inner-table-hover:hover {
        background-color: transparent !important;
    }

    .inner-table-hover {
        background-color: transparent !important;
    }
</style>

<table class="table table-hover table-striped table-sm text-nowrap">

    <thead>
    <tr>
        @if(isset($client_view))
            <th colspan="6" class="border-0"></th>
        @else
            <th colspan="8" class="border-0"></th>
        @endif
        <th class="border-0  bg-light">
            <table class="table m-0 table-hover">
                <thead>
                <tr class=" border-0">
                    <th width="40%" class="border-0 align-middle invoice-data-toggle" style="display: none;">
                        <div class="dropdown-divider"></div>
                    </th>
                    <th width="20%" class="border-0 text-center align-middle bg-secondary rounded">
                        <button type="button" class="btn btn-xs invoice-data-toggle-btn">
                            <i class="fas fa-chevron-right text-light invoice-data-toggle"></i>
                            <i class="fas fa-chevron-left text-light invoice-data-toggle" style="display: none;"></i>
                        </button>
                        {!!  trans('fi.invoice') !!}
                    </th>
                    <th width="40%" class="border-0 align-middle invoice-data-toggle" style="display: none;">
                        <div class="dropdown-divider"></div>
                    </th>
                </tr>
                </thead>
            </table>
        </th>
    </tr>

    <tr>
        @if(isset($bulk_action) && $bulk_action == true)
            @can('payments.delete')
                <th>
                    <div class="btn-group"><input type="checkbox" id="bulk-select-all"></div>
                </th>
            @endcan
        @endif
        <th>{!! Sortable::link('id', trans('fi.id'), 'payments') !!}</th>
        <th>{!! Sortable::link('paid_at', trans('fi.payment_date'), 'payments') !!}</th>
        @if(!isset($client_view))
            <th>{!! trans('fi.client') !!}</th>
        @endif

        <th>{!! Sortable::link('payment_methods.name', trans('fi.payment_method'), 'payments') !!}</th>
        <th class="pr-1">{!! trans('fi.payment') !!}</th>
        <th class="pr-1">{!! trans('fi.balance') !!}</th>

        <th class="text-right  pr-3">{{ trans('fi.options') }}</th>

        <th class="pl-2 bg-light " colspan="4">
            <table class="table m-0 table-hover">
                <thead>
                <tr class=" border-0">
                    <th class="border-0 w-25">  {!! Sortable::link('invoices.number', trans('fi.number'), 'payments') !!}</th>
                    <th class="border-0 w-25 invoice-data-toggle" style="display: none;"> {!! Sortable::link('invoices.invoice_date', trans('fi.date'), 'payments') !!}</th>
                    <th class="border-0 w-25 invoice-data-toggle" style="display: none;"> {!!  trans('fi.amount') !!}</th>
                    <th class="border-0 w-25 invoice-data-toggle" style="display: none;"> {!! trans('fi.balance') !!}</th>
                </tr>
                </thead>
            </table>
        </th>

    </tr>
    </thead>

    <tbody>
    @foreach ($payments as $payment)

        <tr>
            @if(isset($bulk_action) && $bulk_action == true)
                @can('payments.delete')
                    <td><input type="checkbox" class="bulk-record" data-id="{{ $payment->id }}"></td>
                @endcan
            @endif
            <td>
                <a href="javascript:void(0)"
                   data-action="{{ route('payments.applications',['payment' => $payment->id])}}"
                   class="payment-applications ">
                    {{ $payment->formatted_number }}
                </a>
            </td>
            <td>{{ $payment->formatted_paid_at }}</td>
            @if(!isset($client_view))
                <td>
                    @if( Gate::check('clients.view'))
                        @if($payment->client_id)
                            <a href="{{ route('clients.show', [$payment->client_id]) }}"
                               class="text-info">{{ $payment->client->name }}</a>
                        @endif
                    @else
                        {{ $payment->client->name }}
                    @endif
                </td>
            @endif

            <td>
                <span>
                    @if($payment->paymentMethod)
                        {{ $payment->paymentMethod->name }}
                    @endif
                 </span>
                <br>
                @if(!empty($payment->formatted_notes))
                    <span class="mt-2 text-secondary font-italic"> {!! $payment->formatted_notes !!} </span>
                @endif
            </td>

            <td>{{ $payment->formatted_amount_with_currency }}</td>
            <td>
                <span class="{{($payment->remaining_balance) ? 'open-balance' : ''}}">{{ $payment->formatted_remaining_balance_with_currency }}</span>
            </td>
            <td class="text-right pr-3">
                <div class="btn-group action-menu">
                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                        {{ trans('fi.options') }} <span class="caret"></span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        @if($payment->amount == $payment->remaining_balance)
                            @can('payments.update')
                                <a href="javascript:void(0)" class="edit-payment dropdown-item"
                                   data-action="{{ route('payments.editPayment',['payment' => $payment->id]) }}">
                                    <i class="fa fa-edit"></i> {{ trans('fi.edit') }}
                                </a>
                            @endcan
                        @endif
                        @if(count($payment->paymentInvoice) == 1)
                            @can('invoices.view')
                                <a href="{{ route('invoices.pdf', [$payment->paymentInvoice->first()->invoice_id]) }}"
                                   target="_blank" id="btn-pdf-invoice" class="dropdown-item">
                                    <i class="fa fa-print"></i> {{ trans('fi.invoice_pdf') }}
                                </a>
                            @endcan
                        @endif
                        @if(count($payment->paymentInvoice) > 0)
                            @can('invoices.view')
                                <a href="javascript:void(0)"
                                   data-action="{{ route('payments.applications',['payment' => $payment->id])}}"
                                   class="payment-applications dropdown-item">
                                    <i class="fas fa-dollar-sign"></i> {{ trans('fi.payment_applications') }}
                                </a>
                            @endcan
                        @endif
                        @if (config('fi.mailConfigured'))
                            @can('payments.update')
                                <a href="javascript:void(0)" class="email-payment-receipt dropdown-item"
                                   data-payment-id="{{ $payment->id }}" data-redirect-to="{{ request()->fullUrl() }}">
                                    <i class="fa fa-envelope"></i> {{ trans('fi.email_payment_receipt') }}
                                </a>
                            @endcan
                        @endif
                        @can('payments.view')
                            <a href="{{ route('payments.pdf',$payment->id) }}" class="payment-receipt dropdown-item">
                                <i class="fa fa-file-pdf"></i> {{ trans('fi.payment_receipt') }}
                            </a>
                        @endcan
                        @can('payments.delete')
                            <div class="dropdown-divider"></div>
                            <a href="#" data-action="{{ route('payments.delete', [$payment->id]) }}"
                               class="delete-payment text-danger dropdown-item">
                                <i class="fa fa-trash"></i> {{ trans('fi.delete') }}
                            </a>
                        @endcan
                    </div>
                </div>
            </td>

            <td class="invoice-cols-grouping-data ml-1 pl-2" colspan="4">
                <table class="table  table-sm text-nowrap m-0">
                    <tbody>
                    <tr class="inner-table-hover">
                        <td class="border-0 w-25 invoice-col-data">
                            @if(Gate::check('invoices.update'))
                                @if(count($payment->paymentInvoice) == 1 && isset($payment->paymentInvoice->first()->invoice->number))
                                    <a href="{{ route('invoices.edit', [$payment->paymentInvoice->first()->invoice_id]) }}"
                                       class="text-info">{{ $payment->paymentInvoice->first()->invoice->number }}</a>
                                @elseif(count($payment->paymentInvoice) > 1)
                                    <a href="javascript:void(0)"
                                       data-action="{{ route('payments.applications',['payment' => $payment->id])}}"
                                       class="payment-applications">
                                        {{ trans('fi.multiple') }}
                                    </a>
                                @endif
                            @else
                                @if(count($payment->paymentInvoice) == 1)
                                    {{ $payment->paymentInvoice->first()->invoice->number }}
                                @elseif(count($payment->paymentInvoice) > 1)
                                    <a href="javascript:void(0)"
                                       data-action="{{ route('payments.applications',['payment' => $payment->id])}}"
                                       class="payment-applications">
                                        {{ trans('fi.multiple') }}
                                    </a>
                                @endif
                            @endif
                        </td>

                        <td class="border-0 w-25 invoice-col-data invoice-data-toggle" style="display: none;">
                            @if(count($payment->paymentInvoice) == 1 && isset($payment->paymentInvoice->first()->invoice->formatted_invoice_date))
                                {{ $payment->paymentInvoice->first()->invoice->formatted_invoice_date }}
                            @elseif(count($payment->paymentInvoice) > 1)
                                {{ trans('fi.multiple') }}
                            @endif
                        </td>
                        <td class="border-0 w-25 invoice-col-data invoice-data-toggle" style="display: none;">
                            @if(count($payment->paymentInvoice) == 1 && isset($payment->paymentInvoice->first()->invoice->amount->formatted_total))
                                {{ $payment->paymentInvoice->first()->invoice->amount->formatted_total }}
                            @endif
                        </td>
                        <td class="border-0 w-25 invoice-col-data invoice-data-toggle" style="display: none;">
                            @if(count($payment->paymentInvoice) == 1 && isset($payment->paymentInvoice->first()->invoice->amount->formatted_balance))
                                {{ $payment->paymentInvoice->first()->invoice->amount->formatted_balance }}
                            @endif
                        </td>
                    </tr>
                    <tr class="w-100 inner-table-hover invoice-data-toggle" style="display: none;">
                        <td colspan="4" class="border-0">
                            @if(count($payment->paymentInvoice) == 1 && isset($payment->paymentInvoice->first()->invoice->summary))
                                @if(!empty($payment->paymentInvoice->first()->invoice->summary))
                                    <span class="text-secondary font-italic  "
                                          data-toggle="tooltip" data-placement="auto"
                                          data-original-title="{{$payment->paymentInvoice->first()->invoice->summary }}">
                                        <span class="text-bold"> {{trans('fi.note')}}:</span>
                                            {{ $payment->paymentInvoice->first()->invoice->formatted_summary }}
                                    </span>
                                @endif
                            @else

                            @endif
                        </td>
                    </tr>
                    </tbody>
                </table>
            </td>

        </tr>

    @endforeach
    </tbody>

</table>