<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Payments\Events;

use FI\Events\Event;
use FI\Modules\Payments\Models\Payment;
use Illuminate\Queue\SerializesModels;

class PaymentEmailed extends Event
{
    use SerializesModels;

    public $payment;
    public $actionType;
    public $previousValue;
    public $currentValue;
    public $detail;
    public $invoiceId;

    public function __construct(Payment $payment, $actionType = null, $previousValue = null, $currentValue = null, $invoiceId = null)
    {
        $this->payment       = $payment;
        $this->actionType    = ($actionType == '') ? 'payment_receipt_email_sent' : $actionType;
        $this->previousValue = $previousValue;
        $this->currentValue  = $currentValue;
        $this->invoiceId     = $invoiceId;
        $this->detail        = [
            'id'     => $payment->id,
            'amount' => getCurrencySign(config('fi.baseCurrency')) . ' ' . $payment->formatted_numeric_amount,
        ];
    }
}
