<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['middleware' => ['web', 'auth.admin'], 'namespace' => 'FI\Modules\PaymentTerms\Controllers'], function ()
{
    Route::group(['prefix' => 'payment_terms'], function ()
    {
        Route::get('/', ['uses' => 'PaymentTermController@index', 'as' => 'payment.terms.index'])->middleware('can:payments.view');
        Route::get('create', ['uses' => 'PaymentTermController@create', 'as' => 'payment.terms.create'])->middleware('can:payments.view');
        Route::post('store', ['uses' => 'PaymentTermController@store', 'as' => 'payment.terms.store'])->middleware('can:payments.create');
        Route::get('{id}/edit', ['uses' => 'PaymentTermController@edit', 'as' => 'payment.terms.edit'])->middleware('can:payments.update');
        Route::post('{id}/edit', ['uses' => 'PaymentTermController@update', 'as' => 'payment.terms.update'])->middleware('can:payments.update');
        Route::get('{id}/delete', ['uses' => 'PaymentTermController@delete', 'as' => 'payment.terms.delete'])->middleware('can:payments.delete');
        Route::post('delete/confirmation/modal', ['uses' => 'PaymentTermController@deleteModal', 'as' => 'payment.terms.delete.modal'])->middleware('can:payments.delete');
        Route::post('{id}/update', ['uses' => 'PaymentTermController@editableUpdate', 'as' => 'payment.terms.editable.update'])->middleware('can:payments.update');
    });
});